/*
 * Decompiled with CFR 0.152.
 */
package korlibs.image.format;

import korlibs.encoding.HexKt;
import korlibs.image.color.Colors;
import korlibs.image.color.RGBA;
import korlibs.image.color.RGBAKt;
import korlibs.image.color.RgbaArray;
import korlibs.io.stream.SyncStream;
import korlibs.io.stream.SyncStreamKt;
import korlibs.util.StringformatKt;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UByteArray;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.unsigned.UArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function9;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\f\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0006EFGHIJB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0017\u001a\u00020\u00102\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001J\u000e\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001e\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001f\u0010 J\u000e\u0010!\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012J \u0010\"\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010#\u001a\u00020$\u00f8\u0001\u0000\u00a2\u0006\u0004\b%\u0010&J\u000e\u0010'\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015J\u001e\u0010(\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010)\u001a\u00020\u00042\u0006\u0010*\u001a\u00020+J\u0016\u0010,\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\u00042\u0006\u0010.\u001a\u00020\u0004J\u001e\u0010/\u001a\u0002002\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u00101\u001a\u0002002\u0006\u00102\u001a\u00020\u0004J\u000e\u00103\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020\u0004J\u000e\u00104\u001a\u0002052\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u00106\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u00107\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u00108\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u00109\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010:\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010;\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010<\u001a\u00020\u001cJ\u000e\u0010=\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010>\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015J \u0010?\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010#\u001a\u00020$\u00f8\u0001\u0000\u00a2\u0006\u0004\b@\u0010&J\u0012\u0010A\u001a\u00020\u001c*\u00020B2\u0006\u0010C\u001a\u00020DR\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006K"}, d2={"Lkorlibs/image/format/GifDec;", "", "()V", "SEEK_CUR", "", "getSEEK_CUR", "()I", "SEEK_SET", "getSEEK_SET", "add_entry", "tablep", "Lkorlibs/image/format/GifDec$Table;", "length", "prefix", "suffix", "close", "", "fd", "Lkorlibs/io/stream/SyncStream;", "discard_sub_blocks", "gif", "Lkorlibs/image/format/GifDec$gd_GIF;", "dispose", "free", "obj", "gd_close_gif", "gd_get_frame", "gd_is_bgcolor", "", "color", "Lkorlibs/image/color/RGBA;", "gd_is_bgcolor-XDoMphA", "(Lkorlibs/image/format/GifDec$gd_GIF;I)Z", "gd_open_gif", "gd_render_frame", "buffer", "Lkorlibs/image/color/RgbaArray;", "gd_render_frame-k4wfwjs", "(Lkorlibs/image/format/GifDec$gd_GIF;[I)V", "gd_rewind", "get_key", "key_size", "s", "Lkorlibs/image/format/GifDec$KeyState;", "interlaced_line_index", "h", "y", "lseek", "", "pos", "kind", "new_table", "readChar", "", "read_application_ext", "read_comment_ext", "read_ext", "read_graphic_control_ext", "read_image", "read_image_data", "interlace", "read_num", "read_plain_text_ext", "render_frame_rect", "render_frame_rect-k4wfwjs", "eqbytes", "", "str", "", "Entry", "KeyState", "Table", "gd_GCE", "gd_GIF", "gd_Palette", "korge-core"})
public final class GifDec {
    @NotNull
    public static final GifDec INSTANCE = new GifDec();
    private static final int SEEK_SET;
    private static final int SEEK_CUR;

    private GifDec() {
    }

    public final int read_num(@NotNull SyncStream fd) {
        int a = SyncStreamKt.readU8(fd);
        int b = SyncStreamKt.readU8(fd);
        return a | b << 8;
    }

    public final boolean eqbytes(@NotNull byte[] $this$eqbytes, @NotNull String str) {
        int n = str.length();
        for (int n2 = 0; n2 < n; ++n2) {
            if ($this$eqbytes[n2] == (byte)str.charAt(n2)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public final gd_GIF gd_open_gif(@NotNull SyncStream fd) {
        byte[] sigver1 = SyncStreamKt.readBytes(fd, 3);
        if (!this.eqbytes(sigver1, "GIF")) {
            throw new IllegalStateException(("invalid signature: " + HexKt.getHex(sigver1)).toString());
        }
        byte[] sigver2 = SyncStreamKt.readBytes(fd, 3);
        if (!this.eqbytes(sigver2, "89a")) {
            throw new IllegalStateException(("invalid version: " + HexKt.getHex(sigver2)).toString());
        }
        int width2 = this.read_num(fd);
        int height2 = this.read_num(fd);
        int fdsz = SyncStreamKt.readU8(fd);
        if ((fdsz & 0x80) == 0) {
            throw new IllegalStateException("no global color table".toString());
        }
        int depth = (fdsz >>> 4 & 7) + 1;
        int gct_sz = 1 << (fdsz & 7) + 1;
        int bgidx = SyncStreamKt.readU8(fd);
        int aspect = SyncStreamKt.readU8(fd);
        gd_GIF gif = new gd_GIF(fd, 0L, 0, 0, 0, 0, null, null, null, null, null, null, null, 0, 0, 0, 0, 0, RgbaArray.Companion.invoke-lrAz6eQ(width2 * height2), UByteArray.constructor-impl(width2 * height2), 262142, null);
        gif.setFd(fd);
        gif.setWidth(width2);
        gif.setHeight(height2);
        gif.setDepth(depth);
        gif.getGct().setSize(gct_sz);
        int n = gif.getGct().getSize();
        for (int n2 = 0; n2 < n; ++n2) {
            int r = SyncStreamKt.readU8(fd);
            int g = SyncStreamKt.readU8(fd);
            int b = SyncStreamKt.readU8(fd);
            RgbaArray.set-XDoMphA(gif.getGct().getColors-FROm4YY(), n2, RGBA.Companion.invoke-u6-pZFY(r, g, b));
        }
        gif.setPalette(gif.getGct());
        gif.setBgindex(bgidx);
        if (gif.getBgindex() != 0) {
            UArraysKt.fill-WpHrYlw(gif.getFrame-TcUX1vc(), UByte.constructor-impl((byte)gif.getBgindex()), 0, gif.getWidth() * gif.getHeight());
        }
        RgbaArray.set-XDoMphA(gif.getPalette().getColors-FROm4YY(), gif.getBgindex(), Colors.INSTANCE.getTRANSPARENT-JH0Opww());
        gif.setAnim_start(this.lseek(fd, 0L, SEEK_CUR));
        return gif;
    }

    public final void discard_sub_blocks(@NotNull gd_GIF gif) {
        int size2;
        do {
            size2 = SyncStreamKt.readU8(gif.getFd());
            this.lseek(gif.getFd(), size2, SEEK_CUR);
        } while (size2 != 0);
    }

    public final void read_plain_text_ext(@NotNull gd_GIF gif) {
        Function9<gd_GIF, Integer, Integer, Integer, Integer, Integer, Integer, Integer, Integer, Unit> plain_text = gif.getPlain_text();
        if (plain_text != null) {
            this.lseek(gif.getFd(), 1L, SEEK_CUR);
            int tx = this.read_num(gif.getFd());
            int ty = this.read_num(gif.getFd());
            int tw = this.read_num(gif.getFd());
            int th = this.read_num(gif.getFd());
            int cw = SyncStreamKt.readU8(gif.getFd());
            int ch = SyncStreamKt.readU8(gif.getFd());
            int fg = SyncStreamKt.readU8(gif.getFd());
            int bg2 = SyncStreamKt.readU8(gif.getFd());
            long sub_block = this.lseek(gif.getFd(), 0L, SEEK_CUR);
            plain_text.invoke(gif, tx, ty, tw, th, cw, ch, fg, bg2);
            this.lseek(gif.getFd(), sub_block, SEEK_SET);
        } else {
            this.lseek(gif.getFd(), 13L, SEEK_CUR);
        }
        this.discard_sub_blocks(gif);
    }

    public final void read_graphic_control_ext(@NotNull gd_GIF gif) {
        this.lseek(gif.getFd(), 1L, SEEK_CUR);
        int rdit = SyncStreamKt.readU8(gif.getFd());
        gif.getGce().setDisposal(rdit >>> 2 & 3);
        gif.getGce().setInput(rdit & 2);
        gif.getGce().setTransparency((rdit & 1) != 0);
        gif.getGce().setDelay(this.read_num(gif.getFd()));
        gif.getGce().setTindex(SyncStreamKt.readU8(gif.getFd()));
        this.lseek(gif.getFd(), 1L, SEEK_CUR);
    }

    public final void read_comment_ext(@NotNull gd_GIF gif) {
        Function1<gd_GIF, Unit> comment = gif.getComment();
        if (comment != null) {
            long sub_block = this.lseek(gif.getFd(), 0L, SEEK_CUR);
            comment.invoke(gif);
            this.lseek(gif.getFd(), sub_block, SEEK_SET);
        }
        this.discard_sub_blocks(gif);
    }

    public final void read_application_ext(@NotNull gd_GIF gif) {
        this.lseek(gif.getFd(), 1L, SEEK_CUR);
        byte[] app_id = SyncStreamKt.readBytesExact(gif.getFd(), 8);
        byte[] app_auth_code = SyncStreamKt.readBytesExact(gif.getFd(), 3);
        if (this.eqbytes(app_id, "NETSCAPE")) {
            this.lseek(gif.getFd(), 2L, SEEK_CUR);
            gif.setLoop_count(this.read_num(gif.getFd()));
            this.lseek(gif.getFd(), 1L, SEEK_CUR);
        } else if (gif.getApplication() != null) {
            long sub_block = this.lseek(gif.getFd(), 0L, SEEK_CUR);
            Function3<gd_GIF, byte[], byte[], Unit> function3 = gif.getApplication();
            Intrinsics.checkNotNull(function3);
            function3.invoke(gif, app_id, app_auth_code);
            this.lseek(gif.getFd(), sub_block, SEEK_SET);
            this.discard_sub_blocks(gif);
        } else {
            this.discard_sub_blocks(gif);
        }
    }

    public final void read_ext(@NotNull gd_GIF gif) {
        int label = SyncStreamKt.readU8(gif.getFd());
        switch (label) {
            case 1: {
                this.read_plain_text_ext(gif);
                break;
            }
            case 249: {
                this.read_graphic_control_ext(gif);
                break;
            }
            case 254: {
                this.read_comment_ext(gif);
                break;
            }
            case 255: {
                this.read_application_ext(gif);
                break;
            }
            default: {
                Object object = new Object[]{label};
                object = StringformatKt.format("unknown extension: %02X", (Object[])object);
                throw new IllegalStateException(object.toString());
            }
        }
    }

    @NotNull
    public final Table new_table(int key_size) {
        int init_bulk = Math.max(1 << key_size + 1, 256);
        int n = 0;
        Entry[] entryArray = new Entry[init_bulk];
        int n2 = (1 << key_size) + 2;
        int n3 = init_bulk;
        while (n < init_bulk) {
            int n4 = n++;
            entryArray[n4] = new Entry(1, 4095, n4);
        }
        Entry[] entryArray2 = entryArray;
        int n5 = n2;
        int n6 = n3;
        return new Table(n6, n5, entryArray2);
    }

    public final int add_entry(@NotNull Table tablep, int length2, int prefix, int suffix) {
        Table table = tablep;
        if (table.getNentries() == table.getBulk()) {
            table.resize(table.getBulk() * 2);
        }
        table.getEntries()[table.getNentries()] = new Entry(length2, prefix, suffix);
        Table table2 = table;
        int n = table2.getNentries();
        table2.setNentries(n + 1);
        if ((table.getNentries() & table.getNentries() - 1) == 0) {
            return 1;
        }
        return 0;
    }

    public final int get_key(@NotNull gd_GIF gif, int key_size, @NotNull KeyState s) {
        int frag_size;
        int key = 0;
        for (int bits_read = 0; bits_read < key_size; bits_read += frag_size) {
            int rpad = (s.getShift() + bits_read) % 8;
            if (rpad == 0) {
                if (s.getSub_len() == 0) {
                    s.setSub_len(SyncStreamKt.readU8(gif.getFd()));
                    if (s.getSub_len() == 0) {
                        return 4096;
                    }
                }
                s.setByte(SyncStreamKt.readU8(gif.getFd()));
                int n = s.getSub_len();
                s.setSub_len(n + -1);
            }
            frag_size = Math.min(key_size - bits_read, 8 - rpad);
            key |= (0xFFFF & s.getByte() >>> rpad) << bits_read;
        }
        s.setShift((s.getShift() + key_size) % 8);
        return key &= (1 << key_size) - 1;
    }

    public final int interlaced_line_index(int h, int y) {
        int y2 = y;
        int p = (h - 1) / 8 + 1;
        if (y2 < p) {
            return y2 * 8;
        }
        if ((y2 -= p) < (p = (h - 5) / 8 + 1)) {
            return y2 * 8 + 4;
        }
        if ((y2 -= p) < (p = (h - 3) / 4 + 1)) {
            return y2 * 4 + 2;
        }
        return (y2 -= p) * 2 + 1;
    }

    public final int read_image_data(@NotNull gd_GIF gif, boolean interlace) {
        int str_len = 0;
        boolean table_is_full = false;
        int n = SyncStreamKt.readU8(gif.getFd());
        int key_size = n;
        if (key_size < 2 || key_size > 8) {
            return -1;
        }
        long start2 = this.lseek(gif.getFd(), 0L, SEEK_CUR);
        this.discard_sub_blocks(gif);
        long end2 = this.lseek(gif.getFd(), 0L, SEEK_CUR);
        this.lseek(gif.getFd(), start2, SEEK_SET);
        int clear = 1 << key_size;
        int stop = clear + 1;
        Table table = this.new_table(key_size);
        int init_key_size = ++key_size;
        KeyState state2 = new KeyState(0, 0, 0, 7, null);
        Entry entry2 = null;
        state2.setByte(n);
        int key = this.get_key(gif, key_size, state2);
        int frm_off = 0;
        int ret = 0;
        int frm_size = gif.getFw() * gif.getFh();
        while (frm_off < frm_size) {
            Entry entry3;
            if (key == clear) {
                key_size = init_key_size;
                table.setNentries((1 << key_size - 1) + 2);
                table_is_full = false;
            } else if (!table_is_full) {
                Entry entry4 = entry2;
                if (entry4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("entry");
                    entry4 = null;
                }
                if ((ret = this.add_entry(table, str_len + 1, key, entry4.getSuffix())) == -1) {
                    this.free(table);
                    return -1;
                }
                if (table.getNentries() == 4096) {
                    ret = 0;
                    table_is_full = true;
                }
            }
            if ((key = this.get_key(gif, key_size, state2)) == clear) continue;
            if (key == stop || key == 4096) break;
            if (ret == 1) {
                ++key_size;
            }
            if ((entry3 = (entry2 = table.getEntries()[key])) == null) {
                Intrinsics.throwUninitializedPropertyAccessException("entry");
                entry3 = null;
            }
            str_len = entry3.getLength();
            int n2 = str_len;
            for (int i2 = 0; i2 < n2; ++i2) {
                Entry entry5 = entry2;
                if (entry5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("entry");
                    entry5 = null;
                }
                int p = frm_off + entry5.getLength() - 1;
                int x = p % gif.getFw();
                int y = p / gif.getFw();
                if (interlace) {
                    y = this.interlaced_line_index(gif.getFh(), y);
                }
                UByteArray.set-VurrAj0(gif.getFrame-TcUX1vc(), (gif.getFy() + y) * gif.getWidth() + gif.getFx() + x, UByte.constructor-impl((byte)entry2.getSuffix()));
                if (entry2.getPrefix() == 4095) break;
                entry2 = table.getEntries()[entry2.getPrefix()];
            }
            frm_off += str_len;
            if (key >= table.getNentries() - 1 || table_is_full) continue;
            Entry entry6 = table.getEntries()[table.getNentries() - 1];
            Entry entry7 = entry2;
            if (entry7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("entry");
                entry7 = null;
            }
            entry6.setSuffix(entry7.getSuffix());
        }
        this.free(table);
        if (key == stop) {
            state2.setSub_len(SyncStreamKt.readU8(gif.getFd()));
        }
        this.lseek(gif.getFd(), end2, SEEK_SET);
        return 0;
    }

    public final int read_image(@NotNull gd_GIF gif) {
        boolean interlace;
        gif.setFx(this.read_num(gif.getFd()));
        gif.setFy(this.read_num(gif.getFd()));
        if (gif.getFx() >= gif.getWidth() || gif.getFy() >= gif.getHeight()) {
            return -1;
        }
        gif.setFw(this.read_num(gif.getFd()));
        gif.setFh(this.read_num(gif.getFd()));
        gif.setFw(Math.min(gif.getFw(), gif.getWidth() - gif.getFx()));
        gif.setFh(Math.min(gif.getFh(), gif.getHeight() - gif.getFy()));
        int fisrz = SyncStreamKt.readU8(gif.getFd());
        boolean bl = interlace = (fisrz & 0x40) != 0;
        if ((fisrz & 0x80) != 0) {
            gif.getLct().setSize(1 << (fisrz & 7) + 1);
            int n = gif.getLct().getSize();
            for (int n2 = 0; n2 < n; ++n2) {
                int r = SyncStreamKt.readU8(gif.getFd());
                int g = SyncStreamKt.readU8(gif.getFd());
                int b = SyncStreamKt.readU8(gif.getFd());
                RgbaArray.set-XDoMphA(gif.getLct().getColors-FROm4YY(), n2, RGBA.Companion.invoke-u6-pZFY(r, g, b));
            }
            gif.setPalette(gif.getLct());
        } else {
            gif.setPalette(gif.getGct());
        }
        return this.read_image_data(gif, interlace);
    }

    public final void render_frame_rect-k4wfwjs(@NotNull gd_GIF gif, @NotNull int[] buffer) {
        int i2 = gif.getFy() * gif.getWidth() + gif.getFx();
        int n = gif.getFh();
        for (int j = 0; j < n; ++j) {
            int n2 = gif.getFw();
            for (int k = 0; k < n2; ++k) {
                int index2 = UByteArray.get-w2LRezQ(gif.getFrame-TcUX1vc(), (gif.getFy() + j) * gif.getWidth() + gif.getFx() + k) & 0xFF;
                int color2 = RgbaArray.get-O1c-hRk(gif.getPalette().getColors-FROm4YY(), index2);
                if (gif.getGce().getTransparency() && index2 == gif.getGce().getTindex()) continue;
                RgbaArray.set-XDoMphA(buffer, i2 + k, color2);
            }
            i2 += gif.getWidth();
        }
    }

    public final void dispose(@NotNull gd_GIF gif) {
        switch (gif.getGce().getDisposal()) {
            case 2: {
                int i2 = gif.getFy() * gif.getWidth() + gif.getFx();
                int n = gif.getFh();
                for (int j = 0; j < n; ++j) {
                    int n2 = gif.getFw();
                    for (int k = 0; k < n2; ++k) {
                        RgbaArray.set-XDoMphA(gif.getCanvas-FROm4YY(), i2 + k, Colors.INSTANCE.getTRANSPARENT-JH0Opww());
                    }
                    i2 += gif.getWidth();
                }
                break;
            }
            case 3: {
                break;
            }
            default: {
                this.render_frame_rect-k4wfwjs(gif, gif.getCanvas-FROm4YY());
            }
        }
    }

    public final int gd_get_frame(@NotNull gd_GIF gif) {
        char sep = '\u0000';
        this.dispose(gif);
        sep = this.readChar(gif.getFd());
        while (sep != ',') {
            if (sep == ';') {
                return 0;
            }
            if (sep != '!') {
                return -1;
            }
            this.read_ext(gif);
            sep = this.readChar(gif.getFd());
        }
        if (this.read_image(gif) == -1) {
            return -1;
        }
        return 1;
    }

    public final void gd_render_frame-k4wfwjs(@NotNull gd_GIF gif, @NotNull int[] buffer) {
        RGBAKt.arraycopy-NfnQA0g(gif.getCanvas-FROm4YY(), 0, buffer, 0, gif.getWidth() * gif.getHeight());
        this.render_frame_rect-k4wfwjs(gif, buffer);
    }

    public final boolean gd_is_bgcolor-XDoMphA(@NotNull gd_GIF gif, int color2) {
        return RGBA.equals-impl0(RgbaArray.get-O1c-hRk(gif.getPalette().getColors-FROm4YY(), gif.getBgindex()), color2);
    }

    public final void gd_rewind(@NotNull gd_GIF gif) {
        this.lseek(gif.getFd(), gif.getAnim_start(), SEEK_SET);
    }

    public final void gd_close_gif(@NotNull gd_GIF gif) {
        this.close(gif.getFd());
        this.free(gif);
    }

    public final int getSEEK_SET() {
        return SEEK_SET;
    }

    public final int getSEEK_CUR() {
        return SEEK_CUR;
    }

    public final void close(@NotNull SyncStream fd) {
        fd.close();
    }

    public final void free(@Nullable Object obj) {
    }

    public final char readChar(@NotNull SyncStream fd) {
        return (char)SyncStreamKt.readU8(fd);
    }

    public final long lseek(@NotNull SyncStream fd, long pos, int kind2) {
        int n = kind2;
        if (n == SEEK_SET) {
            fd.setPosition(pos);
        } else if (n == SEEK_CUR) {
            fd.setPosition(fd.getPosition() + pos);
        }
        return fd.getPosition();
    }

    static {
        SEEK_CUR = 1;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\f\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\nR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\b\"\u0004\b\u000e\u0010\n\u00a8\u0006\u000f"}, d2={"Lkorlibs/image/format/GifDec$Entry;", "", "length", "", "prefix", "suffix", "(III)V", "getLength", "()I", "setLength", "(I)V", "getPrefix", "setPrefix", "getSuffix", "setSuffix", "korge-core"})
    public static final class Entry {
        private int length;
        private int prefix;
        private int suffix;

        public Entry(int length2, int prefix, int suffix) {
            this.length = length2;
            this.prefix = prefix;
            this.suffix = suffix;
        }

        public /* synthetic */ Entry(int n, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 1) != 0) {
                n = 0;
            }
            if ((n4 & 2) != 0) {
                n2 = 0;
            }
            if ((n4 & 4) != 0) {
                n3 = 0;
            }
            this(n, n2, n3);
        }

        public final int getLength() {
            return this.length;
        }

        public final void setLength(int n) {
            this.length = n;
        }

        public final int getPrefix() {
            return this.prefix;
        }

        public final void setPrefix(int n) {
            this.prefix = n;
        }

        public final int getSuffix() {
            return this.suffix;
        }

        public final void setSuffix(int n) {
            this.suffix = n;
        }

        public Entry() {
            this(0, 0, 0, 7, null);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\nR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\b\"\u0004\b\u000e\u0010\n\u00a8\u0006\u0019"}, d2={"Lkorlibs/image/format/GifDec$KeyState;", "", "sub_len", "", "shift", "byte", "(III)V", "getByte", "()I", "setByte", "(I)V", "getShift", "setShift", "getSub_len", "setSub_len", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "korge-core"})
    public static final class KeyState {
        private int sub_len;
        private int shift;
        private int byte;

        public KeyState(int sub_len, int shift, int n) {
            this.sub_len = sub_len;
            this.shift = shift;
            this.byte = n;
        }

        public /* synthetic */ KeyState(int n, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 1) != 0) {
                n = 0;
            }
            if ((n4 & 2) != 0) {
                n2 = 0;
            }
            if ((n4 & 4) != 0) {
                n3 = 0;
            }
            this(n, n2, n3);
        }

        public final int getSub_len() {
            return this.sub_len;
        }

        public final void setSub_len(int n) {
            this.sub_len = n;
        }

        public final int getShift() {
            return this.shift;
        }

        public final void setShift(int n) {
            this.shift = n;
        }

        public final int getByte() {
            return this.byte;
        }

        public final void setByte(int n) {
            this.byte = n;
        }

        public final int component1() {
            return this.sub_len;
        }

        public final int component2() {
            return this.shift;
        }

        public final int component3() {
            return this.byte;
        }

        @NotNull
        public final KeyState copy(int sub_len, int shift, int n) {
            return new KeyState(sub_len, shift, n);
        }

        public static /* synthetic */ KeyState copy$default(KeyState keyState, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = keyState.sub_len;
            }
            if ((n4 & 2) != 0) {
                n2 = keyState.shift;
            }
            if ((n4 & 4) != 0) {
                n3 = keyState.byte;
            }
            return keyState.copy(n, n2, n3);
        }

        @NotNull
        public String toString() {
            return "KeyState(sub_len=" + this.sub_len + ", shift=" + this.shift + ", byte=" + this.byte + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.sub_len);
            result2 = result2 * 31 + Integer.hashCode(this.shift);
            result2 = result2 * 31 + Integer.hashCode(this.byte);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof KeyState)) {
                return false;
            }
            KeyState keyState = (KeyState)other;
            if (this.sub_len != keyState.sub_len) {
                return false;
            }
            if (this.shift != keyState.shift) {
                return false;
            }
            return this.byte == keyState.byte;
        }

        public KeyState() {
            this(0, 0, 0, 7, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B)\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\"\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0011\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\n\"\u0004\b\u0013\u0010\f\u00a8\u0006\u0017"}, d2={"Lkorlibs/image/format/GifDec$Table;", "", "bulk", "", "nentries", "entries", "", "Lkorlibs/image/format/GifDec$Entry;", "(II[Lkorlibs/image/format/GifDec$Entry;)V", "getBulk", "()I", "setBulk", "(I)V", "getEntries", "()[Lkorlibs/image/format/GifDec$Entry;", "setEntries", "([Lkorlibs/image/format/GifDec$Entry;)V", "[Lkorlibs/image/format/GifDec$Entry;", "getNentries", "setNentries", "resize", "", "count", "korge-core"})
    @SourceDebugExtension(value={"SMAP\nGIF.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GIF.kt\nkorlibs/image/format/GifDec$Table\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,551:1\n26#2:552\n*S KotlinDebug\n*F\n+ 1 GIF.kt\nkorlibs/image/format/GifDec$Table\n*L\n110#1:552\n*E\n"})
    public static final class Table {
        private int bulk;
        private int nentries;
        @NotNull
        private Entry[] entries;

        public Table(int bulk, int nentries, @NotNull Entry[] entries2) {
            this.bulk = bulk;
            this.nentries = nentries;
            this.entries = entries2;
        }

        public /* synthetic */ Table(int n, int n2, Entry[] entryArray, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 1) != 0) {
                n = 0;
            }
            if ((n3 & 2) != 0) {
                n2 = 0;
            }
            if ((n3 & 4) != 0) {
                boolean $i$f$emptyArray = false;
                entryArray = new Entry[]{};
            }
            this(n, n2, entryArray);
        }

        public final int getBulk() {
            return this.bulk;
        }

        public final void setBulk(int n) {
            this.bulk = n;
        }

        public final int getNentries() {
            return this.nentries;
        }

        public final void setNentries(int n) {
            this.nentries = n;
        }

        @NotNull
        public final Entry[] getEntries() {
            return this.entries;
        }

        public final void setEntries(@NotNull Entry[] entryArray) {
            this.entries = entryArray;
        }

        public final void resize(int count2) {
            this.bulk = count2;
            Entry[] entryArray = new Entry[count2];
            Table table = this;
            for (int j = 0; j < count2; ++j) {
                int n = j;
                Entry entry2 = ArraysKt.getOrNull(this.entries, n);
                if (entry2 == null) {
                    entry2 = new Entry(0, 0, 0, 7, null);
                }
                entryArray[n] = entry2;
            }
            table.entries = entryArray;
        }

        public Table() {
            this(0, 0, null, 7, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0010\u0018\u00002\u00020\u0001B7\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000b\"\u0004\b\u000f\u0010\rR\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u000b\"\u0004\b\u0011\u0010\rR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000b\"\u0004\b\u0013\u0010\rR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lkorlibs/image/format/GifDec$gd_GCE;", "", "delay", "", "tindex", "disposal", "input", "transparency", "", "(IIIIZ)V", "getDelay", "()I", "setDelay", "(I)V", "getDisposal", "setDisposal", "getInput", "setInput", "getTindex", "setTindex", "getTransparency", "()Z", "setTransparency", "(Z)V", "korge-core"})
    public static final class gd_GCE {
        private int delay;
        private int tindex;
        private int disposal;
        private int input;
        private boolean transparency;

        public gd_GCE(int delay, int tindex, int disposal, int input, boolean transparency) {
            this.delay = delay;
            this.tindex = tindex;
            this.disposal = disposal;
            this.input = input;
            this.transparency = transparency;
        }

        public /* synthetic */ gd_GCE(int n, int n2, int n3, int n4, boolean bl, int n5, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n5 & 1) != 0) {
                n = 0;
            }
            if ((n5 & 2) != 0) {
                n2 = 0;
            }
            if ((n5 & 4) != 0) {
                n3 = 0;
            }
            if ((n5 & 8) != 0) {
                n4 = 0;
            }
            if ((n5 & 0x10) != 0) {
                bl = false;
            }
            this(n, n2, n3, n4, bl);
        }

        public final int getDelay() {
            return this.delay;
        }

        public final void setDelay(int n) {
            this.delay = n;
        }

        public final int getTindex() {
            return this.tindex;
        }

        public final void setTindex(int n) {
            this.tindex = n;
        }

        public final int getDisposal() {
            return this.disposal;
        }

        public final void setDisposal(int n) {
            this.disposal = n;
        }

        public final int getInput() {
            return this.input;
        }

        public final void setInput(int n) {
            this.input = n;
        }

        public final boolean getTransparency() {
            return this.transparency;
        }

        public final void setTransparency(boolean bl) {
            this.transparency = bl;
        }

        public gd_GCE() {
            this(0, 0, 0, 0, false, 31, null);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b@\u0018\u00002\u00020\u0001B\u00f6\u0003\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u0012\b\b\u0002\u0010\n\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u000e\u0012\u00ce\u0001\b\u0002\u0010\u0011\u001a\u00c7\u0001\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0016\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0017\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0018\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0019\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u001a\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u001b\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u001c\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u001d\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u0012\u0012%\b\u0002\u0010\u001f\u001a\u001f\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u001e\u0018\u00010 \u0012O\b\u0002\u0010!\u001aI\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110#\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b($\u0012\u0013\u0012\u00110#\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(%\u0012\u0004\u0012\u00020\u001e\u0018\u00010\"\u0012\b\b\u0002\u0010&\u001a\u00020\u0007\u0012\b\b\u0002\u0010'\u001a\u00020\u0007\u0012\b\b\u0002\u0010(\u001a\u00020\u0007\u0012\b\b\u0002\u0010)\u001a\u00020\u0007\u0012\b\b\u0002\u0010*\u001a\u00020\u0007\u0012\b\b\u0002\u0010+\u001a\u00020,\u0012\b\b\u0002\u0010-\u001a\u00020.\u00a2\u0006\u0002\u0010/R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103Ra\u0010!\u001aI\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110#\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b($\u0012\u0013\u0012\u00110#\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(%\u0012\u0004\u0012\u00020\u001e\u0018\u00010\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u001a\u0010*\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R\"\u0010+\u001a\u00020,X\u0086\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0010\n\u0002\u0010@\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R7\u0010\u001f\u001a\u001f\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u001e\u0018\u00010 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010B\"\u0004\bC\u0010DR\u001a\u0010\t\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u00109\"\u0004\bF\u0010;R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bG\u0010H\"\u0004\bI\u0010JR\u001a\u0010)\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u00109\"\u0004\bL\u0010;R\"\u0010-\u001a\u00020.X\u0086\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0010\n\u0002\u0010Q\u001a\u0004\bM\u0010N\"\u0004\bO\u0010PR\u001a\u0010(\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bR\u00109\"\u0004\bS\u0010;R\u001a\u0010&\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bT\u00109\"\u0004\bU\u0010;R\u001a\u0010'\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bV\u00109\"\u0004\bW\u0010;R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bX\u0010Y\"\u0004\bZ\u0010[R\u001a\u0010\u0010\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\\\u0010]\"\u0004\b^\u0010_R\u001a\u0010\b\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b`\u00109\"\u0004\ba\u0010;R\u001a\u0010\u000f\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bb\u0010]\"\u0004\bc\u0010_R\u001a\u0010\n\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bd\u00109\"\u0004\be\u0010;R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bf\u0010]\"\u0004\bg\u0010_R\u00e0\u0001\u0010\u0011\u001a\u00c7\u0001\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0016\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0017\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0018\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0019\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u001a\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u001b\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u001c\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u001d\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bh\u0010i\"\u0004\bj\u0010kR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bl\u00109\"\u0004\bm\u0010;\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006n"}, d2={"Lkorlibs/image/format/GifDec$gd_GIF;", "", "fd", "Lkorlibs/io/stream/SyncStream;", "anim_start", "", "width", "", "height", "depth", "loop_count", "gce", "Lkorlibs/image/format/GifDec$gd_GCE;", "palette", "Lkorlibs/image/format/GifDec$gd_Palette;", "lct", "gct", "plain_text", "Lkotlin/Function9;", "Lkotlin/ParameterName;", "name", "gif", "tx", "ty", "tw", "th", "cw", "ch", "fg", "bg", "", "comment", "Lkotlin/Function1;", "application", "Lkotlin/Function3;", "", "id", "auth", "fx", "fy", "fw", "fh", "bgindex", "canvas", "Lkorlibs/image/color/RgbaArray;", "frame", "Lkotlin/UByteArray;", "(Lkorlibs/io/stream/SyncStream;JIIIILkorlibs/image/format/GifDec$gd_GCE;Lkorlibs/image/format/GifDec$gd_Palette;Lkorlibs/image/format/GifDec$gd_Palette;Lkorlibs/image/format/GifDec$gd_Palette;Lkotlin/jvm/functions/Function9;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function3;IIIII[I[BLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getAnim_start", "()J", "setAnim_start", "(J)V", "getApplication", "()Lkotlin/jvm/functions/Function3;", "setApplication", "(Lkotlin/jvm/functions/Function3;)V", "getBgindex", "()I", "setBgindex", "(I)V", "getCanvas-FROm4YY", "()[I", "setCanvas-2N1wtbg", "([I)V", "[I", "getComment", "()Lkotlin/jvm/functions/Function1;", "setComment", "(Lkotlin/jvm/functions/Function1;)V", "getDepth", "setDepth", "getFd", "()Lkorlibs/io/stream/SyncStream;", "setFd", "(Lkorlibs/io/stream/SyncStream;)V", "getFh", "setFh", "getFrame-TcUX1vc", "()[B", "setFrame-GBYM_sE", "([B)V", "[B", "getFw", "setFw", "getFx", "setFx", "getFy", "setFy", "getGce", "()Lkorlibs/image/format/GifDec$gd_GCE;", "setGce", "(Lkorlibs/image/format/GifDec$gd_GCE;)V", "getGct", "()Lkorlibs/image/format/GifDec$gd_Palette;", "setGct", "(Lkorlibs/image/format/GifDec$gd_Palette;)V", "getHeight", "setHeight", "getLct", "setLct", "getLoop_count", "setLoop_count", "getPalette", "setPalette", "getPlain_text", "()Lkotlin/jvm/functions/Function9;", "setPlain_text", "(Lkotlin/jvm/functions/Function9;)V", "getWidth", "setWidth", "korge-core"})
    public static final class gd_GIF {
        @NotNull
        private SyncStream fd;
        private long anim_start;
        private int width;
        private int height;
        private int depth;
        private int loop_count;
        @NotNull
        private gd_GCE gce;
        @NotNull
        private gd_Palette palette;
        @NotNull
        private gd_Palette lct;
        @NotNull
        private gd_Palette gct;
        @Nullable
        private Function9<? super gd_GIF, ? super Integer, ? super Integer, ? super Integer, ? super Integer, ? super Integer, ? super Integer, ? super Integer, ? super Integer, Unit> plain_text;
        @Nullable
        private Function1<? super gd_GIF, Unit> comment;
        @Nullable
        private Function3<? super gd_GIF, ? super byte[], ? super byte[], Unit> application;
        private int fx;
        private int fy;
        private int fw;
        private int fh;
        private int bgindex;
        @NotNull
        private int[] canvas;
        @NotNull
        private byte[] frame;

        private gd_GIF(SyncStream fd, long anim_start, int width2, int height2, int depth, int loop_count, gd_GCE gce, gd_Palette palette, gd_Palette lct, gd_Palette gct, Function9<? super gd_GIF, ? super Integer, ? super Integer, ? super Integer, ? super Integer, ? super Integer, ? super Integer, ? super Integer, ? super Integer, Unit> plain_text, Function1<? super gd_GIF, Unit> comment, Function3<? super gd_GIF, ? super byte[], ? super byte[], Unit> application, int fx, int fy, int fw, int fh, int bgindex, int[] canvas2, byte[] frame2) {
            this.fd = fd;
            this.anim_start = anim_start;
            this.width = width2;
            this.height = height2;
            this.depth = depth;
            this.loop_count = loop_count;
            this.gce = gce;
            this.palette = palette;
            this.lct = lct;
            this.gct = gct;
            this.plain_text = plain_text;
            this.comment = comment;
            this.application = application;
            this.fx = fx;
            this.fy = fy;
            this.fw = fw;
            this.fh = fh;
            this.bgindex = bgindex;
            this.canvas = canvas2;
            this.frame = frame2;
        }

        public /* synthetic */ gd_GIF(SyncStream syncStream, long l, int n, int n2, int n3, int n4, gd_GCE gd_GCE2, gd_Palette gd_Palette2, gd_Palette gd_Palette3, gd_Palette gd_Palette4, Function9 function9, Function1 function1, Function3 function3, int n5, int n6, int n7, int n8, int n9, int[] nArray, byte[] byArray, int n10, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n10 & 2) != 0) {
                l = 0L;
            }
            if ((n10 & 4) != 0) {
                n = 0;
            }
            if ((n10 & 8) != 0) {
                n2 = 0;
            }
            if ((n10 & 0x10) != 0) {
                n3 = 0;
            }
            if ((n10 & 0x20) != 0) {
                n4 = 0;
            }
            if ((n10 & 0x40) != 0) {
                gd_GCE2 = new gd_GCE(0, 0, 0, 0, false, 31, null);
            }
            if ((n10 & 0x80) != 0) {
                gd_Palette2 = new gd_Palette(0, null, 3, null);
            }
            if ((n10 & 0x100) != 0) {
                gd_Palette3 = new gd_Palette(0, null, 3, null);
            }
            if ((n10 & 0x200) != 0) {
                gd_Palette4 = new gd_Palette(0, null, 3, null);
            }
            if ((n10 & 0x400) != 0) {
                function9 = null;
            }
            if ((n10 & 0x800) != 0) {
                function1 = null;
            }
            if ((n10 & 0x1000) != 0) {
                function3 = null;
            }
            if ((n10 & 0x2000) != 0) {
                n5 = 0;
            }
            if ((n10 & 0x4000) != 0) {
                n6 = 0;
            }
            if ((n10 & 0x8000) != 0) {
                n7 = 0;
            }
            if ((n10 & 0x10000) != 0) {
                n8 = 0;
            }
            if ((n10 & 0x20000) != 0) {
                n9 = 0;
            }
            if ((n10 & 0x40000) != 0) {
                nArray = RgbaArray.Companion.invoke-lrAz6eQ(0);
            }
            if ((n10 & 0x80000) != 0) {
                byArray = UByteArray.constructor-impl(0);
            }
            this(syncStream, l, n, n2, n3, n4, gd_GCE2, gd_Palette2, gd_Palette3, gd_Palette4, function9, function1, function3, n5, n6, n7, n8, n9, nArray, byArray, null);
        }

        @NotNull
        public final SyncStream getFd() {
            return this.fd;
        }

        public final void setFd(@NotNull SyncStream syncStream) {
            this.fd = syncStream;
        }

        public final long getAnim_start() {
            return this.anim_start;
        }

        public final void setAnim_start(long l) {
            this.anim_start = l;
        }

        public final int getWidth() {
            return this.width;
        }

        public final void setWidth(int n) {
            this.width = n;
        }

        public final int getHeight() {
            return this.height;
        }

        public final void setHeight(int n) {
            this.height = n;
        }

        public final int getDepth() {
            return this.depth;
        }

        public final void setDepth(int n) {
            this.depth = n;
        }

        public final int getLoop_count() {
            return this.loop_count;
        }

        public final void setLoop_count(int n) {
            this.loop_count = n;
        }

        @NotNull
        public final gd_GCE getGce() {
            return this.gce;
        }

        public final void setGce(@NotNull gd_GCE gd_GCE2) {
            this.gce = gd_GCE2;
        }

        @NotNull
        public final gd_Palette getPalette() {
            return this.palette;
        }

        public final void setPalette(@NotNull gd_Palette gd_Palette2) {
            this.palette = gd_Palette2;
        }

        @NotNull
        public final gd_Palette getLct() {
            return this.lct;
        }

        public final void setLct(@NotNull gd_Palette gd_Palette2) {
            this.lct = gd_Palette2;
        }

        @NotNull
        public final gd_Palette getGct() {
            return this.gct;
        }

        public final void setGct(@NotNull gd_Palette gd_Palette2) {
            this.gct = gd_Palette2;
        }

        @Nullable
        public final Function9<gd_GIF, Integer, Integer, Integer, Integer, Integer, Integer, Integer, Integer, Unit> getPlain_text() {
            return this.plain_text;
        }

        public final void setPlain_text(@Nullable Function9<? super gd_GIF, ? super Integer, ? super Integer, ? super Integer, ? super Integer, ? super Integer, ? super Integer, ? super Integer, ? super Integer, Unit> function9) {
            this.plain_text = function9;
        }

        @Nullable
        public final Function1<gd_GIF, Unit> getComment() {
            return this.comment;
        }

        public final void setComment(@Nullable Function1<? super gd_GIF, Unit> function1) {
            this.comment = function1;
        }

        @Nullable
        public final Function3<gd_GIF, byte[], byte[], Unit> getApplication() {
            return this.application;
        }

        public final void setApplication(@Nullable Function3<? super gd_GIF, ? super byte[], ? super byte[], Unit> function3) {
            this.application = function3;
        }

        public final int getFx() {
            return this.fx;
        }

        public final void setFx(int n) {
            this.fx = n;
        }

        public final int getFy() {
            return this.fy;
        }

        public final void setFy(int n) {
            this.fy = n;
        }

        public final int getFw() {
            return this.fw;
        }

        public final void setFw(int n) {
            this.fw = n;
        }

        public final int getFh() {
            return this.fh;
        }

        public final void setFh(int n) {
            this.fh = n;
        }

        public final int getBgindex() {
            return this.bgindex;
        }

        public final void setBgindex(int n) {
            this.bgindex = n;
        }

        @NotNull
        public final int[] getCanvas-FROm4YY() {
            return this.canvas;
        }

        public final void setCanvas-2N1wtbg(@NotNull int[] nArray) {
            this.canvas = nArray;
        }

        @NotNull
        public final byte[] getFrame-TcUX1vc() {
            return this.frame;
        }

        public final void setFrame-GBYM_sE(@NotNull byte[] byArray) {
            this.frame = byArray;
        }

        public /* synthetic */ gd_GIF(SyncStream fd, long anim_start, int width2, int height2, int depth, int loop_count, gd_GCE gce, gd_Palette palette, gd_Palette lct, gd_Palette gct, Function9 plain_text, Function1 comment, Function3 application, int fx, int fy, int fw, int fh, int bgindex, int[] canvas2, byte[] frame2, DefaultConstructorMarker $constructor_marker) {
            this(fd, anim_start, width2, height2, depth, loop_count, gce, palette, lct, gct, plain_text, comment, application, fx, fy, fw, fh, bgindex, canvas2, frame2);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0019\u0010\u0004\u001a\u00020\u0005\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u000e"}, d2={"Lkorlibs/image/format/GifDec$gd_Palette;", "", "size", "", "colors", "Lkorlibs/image/color/RgbaArray;", "(I[ILkotlin/jvm/internal/DefaultConstructorMarker;)V", "getColors-FROm4YY", "()[I", "[I", "getSize", "()I", "setSize", "(I)V", "korge-core"})
    public static final class gd_Palette {
        private int size;
        @NotNull
        private final int[] colors;

        private gd_Palette(int size2, int[] colors) {
            this.size = size2;
            this.colors = colors;
        }

        public /* synthetic */ gd_Palette(int n, int[] nArray, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = 0;
            }
            if ((n2 & 2) != 0) {
                nArray = RgbaArray.Companion.invoke-lrAz6eQ(256);
            }
            this(n, nArray, null);
        }

        public final int getSize() {
            return this.size;
        }

        public final void setSize(int n) {
            this.size = n;
        }

        @NotNull
        public final int[] getColors-FROm4YY() {
            return this.colors;
        }

        public /* synthetic */ gd_Palette(int size2, int[] colors, DefaultConstructorMarker $constructor_marker) {
            this(size2, colors);
        }
    }
}

