/*
 * Decompiled with CFR 0.152.
 */
package korlibs.image.format;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import korlibs.image.bitmap.Bitmap;
import korlibs.image.bitmap.Bitmap1;
import korlibs.image.bitmap.Bitmap32;
import korlibs.image.bitmap.Bitmap4;
import korlibs.image.bitmap.Bitmap8;
import korlibs.image.color.BGRA;
import korlibs.image.color.RGBA;
import korlibs.image.color.RGBAKt;
import korlibs.image.color.RgbaArray;
import korlibs.image.format.BMP;
import korlibs.image.format.ICO;
import korlibs.image.format.ImageData;
import korlibs.image.format.ImageDecodingProps;
import korlibs.image.format.ImageEncodingProps;
import korlibs.image.format.ImageFormat;
import korlibs.image.format.ImageFrame;
import korlibs.image.format.ImageInfo;
import korlibs.image.format.PNG;
import korlibs.io.stream.SyncOutputStream;
import korlibs.io.stream.SyncStream;
import korlibs.io.stream.SyncStreamKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lkorlibs/image/format/ICO;", "Lkorlibs/image/format/ImageFormat;", "()V", "decodeHeader", "Lkorlibs/image/format/ImageInfo;", "s", "Lkorlibs/io/stream/SyncStream;", "props", "Lkorlibs/image/format/ImageDecodingProps;", "readImage", "Lkorlibs/image/format/ImageData;", "writeImage", "", "image", "Lkorlibs/image/format/ImageEncodingProps;", "korge-core"})
@SourceDebugExtension(value={"SMAP\nICO.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ICO.kt\nkorlibs/image/format/ICO\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,135:1\n1549#2:136\n1620#2,3:137\n1549#2:140\n1620#2,3:141\n1549#2:144\n1620#2,3:145\n*S KotlinDebug\n*F\n+ 1 ICO.kt\nkorlibs/image/format/ICO\n*L\n83#1:136\n83#1:137,3\n90#1:140\n90#1:141,3\n60#1:144\n60#1:145,3\n*E\n"})
public final class ICO
extends ImageFormat {
    @NotNull
    public static final ICO INSTANCE = new ICO();

    private ICO() {
        String[] stringArray = new String[]{"ico"};
        super(stringArray);
    }

    @Override
    @Nullable
    public ImageInfo decodeHeader(@NotNull SyncStream s, @NotNull ImageDecodingProps props) {
        if (SyncStreamKt.readU16LE(s) != 0) {
            return null;
        }
        if (SyncStreamKt.readU16LE(s) != 1) {
            return null;
        }
        int count2 = SyncStreamKt.readU16LE(s);
        if (count2 >= 1000) {
            return null;
        }
        return new ImageInfo();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ImageData readImage(@NotNull SyncStream s, @NotNull ImageDecodingProps props) {
        void $this$mapTo$iv$iv;
        Object bmp2;
        void $this$mapTo$iv$iv2;
        int reserved = SyncStreamKt.readU16LE(s);
        int type2 = SyncStreamKt.readU16LE(s);
        int count2 = SyncStreamKt.readU16LE(s);
        Iterable $this$map$iv = RangesKt.until(0, count2);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ICO.readImage$readDirEntry(s));
        }
        List entries2 = (List)destination$iv$iv;
        ArrayList bitmaps = new ArrayList();
        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u001c\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J^\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u001eJ\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020\u0003H\u00d6\u0001J\t\u0010#\u001a\u00020$H\u00d6\u0001R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\r\u00a8\u0006%"}, d2={"korlibs/image/format/ICO$readImage$DirEntry", "", "width", "", "height", "colorCount", "reserved", "planes", "bitCount", "size", "offset", "(IIIIIIII)V", "getBitCount", "()I", "getColorCount", "getHeight", "getOffset", "getPlanes", "getReserved", "getSize", "getWidth", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "(IIIIIIII)Lkorlibs/image/format/ICO$readImage$DirEntry;", "equals", "", "other", "hashCode", "toString", "", "korge-core"})
        public final class DirEntry {
            private final int width;
            private final int height;
            private final int colorCount;
            private final int reserved;
            private final int planes;
            private final int bitCount;
            private final int size;
            private final int offset;

            public DirEntry(int width2, int height2, int colorCount, int reserved, int planes, int bitCount, int size2, int offset2) {
                this.width = width2;
                this.height = height2;
                this.colorCount = colorCount;
                this.reserved = reserved;
                this.planes = planes;
                this.bitCount = bitCount;
                this.size = size2;
                this.offset = offset2;
            }

            public final int getWidth() {
                return this.width;
            }

            public final int getHeight() {
                return this.height;
            }

            public final int getColorCount() {
                return this.colorCount;
            }

            public final int getReserved() {
                return this.reserved;
            }

            public final int getPlanes() {
                return this.planes;
            }

            public final int getBitCount() {
                return this.bitCount;
            }

            public final int getSize() {
                return this.size;
            }

            public final int getOffset() {
                return this.offset;
            }

            public final int component1() {
                return this.width;
            }

            public final int component2() {
                return this.height;
            }

            public final int component3() {
                return this.colorCount;
            }

            public final int component4() {
                return this.reserved;
            }

            public final int component5() {
                return this.planes;
            }

            public final int component6() {
                return this.bitCount;
            }

            public final int component7() {
                return this.size;
            }

            public final int component8() {
                return this.offset;
            }

            @NotNull
            public final DirEntry copy(int width2, int height2, int colorCount, int reserved, int planes, int bitCount, int size2, int offset2) {
                return new DirEntry(width2, height2, colorCount, reserved, planes, bitCount, size2, offset2);
            }

            public static /* synthetic */ DirEntry copy$default(DirEntry dirEntry, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Object object) {
                if ((n9 & 1) != 0) {
                    n = dirEntry.width;
                }
                if ((n9 & 2) != 0) {
                    n2 = dirEntry.height;
                }
                if ((n9 & 4) != 0) {
                    n3 = dirEntry.colorCount;
                }
                if ((n9 & 8) != 0) {
                    n4 = dirEntry.reserved;
                }
                if ((n9 & 0x10) != 0) {
                    n5 = dirEntry.planes;
                }
                if ((n9 & 0x20) != 0) {
                    n6 = dirEntry.bitCount;
                }
                if ((n9 & 0x40) != 0) {
                    n7 = dirEntry.size;
                }
                if ((n9 & 0x80) != 0) {
                    n8 = dirEntry.offset;
                }
                return dirEntry.copy(n, n2, n3, n4, n5, n6, n7, n8);
            }

            @NotNull
            public String toString() {
                return "DirEntry(width=" + this.width + ", height=" + this.height + ", colorCount=" + this.colorCount + ", reserved=" + this.reserved + ", planes=" + this.planes + ", bitCount=" + this.bitCount + ", size=" + this.size + ", offset=" + this.offset + ")";
            }

            public int hashCode() {
                int result2 = Integer.hashCode(this.width);
                result2 = result2 * 31 + Integer.hashCode(this.height);
                result2 = result2 * 31 + Integer.hashCode(this.colorCount);
                result2 = result2 * 31 + Integer.hashCode(this.reserved);
                result2 = result2 * 31 + Integer.hashCode(this.planes);
                result2 = result2 * 31 + Integer.hashCode(this.bitCount);
                result2 = result2 * 31 + Integer.hashCode(this.size);
                result2 = result2 * 31 + Integer.hashCode(this.offset);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof DirEntry)) {
                    return false;
                }
                DirEntry dirEntry = (DirEntry)other;
                if (this.width != dirEntry.width) {
                    return false;
                }
                if (this.height != dirEntry.height) {
                    return false;
                }
                if (this.colorCount != dirEntry.colorCount) {
                    return false;
                }
                if (this.reserved != dirEntry.reserved) {
                    return false;
                }
                if (this.planes != dirEntry.planes) {
                    return false;
                }
                if (this.bitCount != dirEntry.bitCount) {
                    return false;
                }
                if (this.size != dirEntry.size) {
                    return false;
                }
                return this.offset == dirEntry.offset;
            }
        }
        for (DirEntry e : entries2) {
            bmp2 = ICO.readImage$readBitmap(props, e, SyncStreamKt.sliceWithSize(s, (long)e.getOffset(), (long)e.getSize()));
            ((Bitmap)bmp2).flipY();
            ((Collection)bitmaps).add(bmp2);
        }
        Iterable $this$map$iv2 = bitmaps;
        boolean $i$f$map2 = false;
        bmp2 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Bitmap bl = (Bitmap)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(ImageFrame.Companion.invoke-5fuBHu4$default(ImageFrame.Companion, (Bitmap)it, 0L, 0, 0, false, false, null, 0, 238, null));
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 126;
        String string = null;
        List list2 = null;
        List list3 = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        List list4 = (List)destination$iv$iv2;
        return new ImageData(list4, n4, n3, n2, list3, list2, string, n, defaultConstructorMarker);
    }

    @Override
    public void writeImage(@NotNull ImageData image2, @NotNull SyncStream s, @NotNull ImageEncodingProps props) {
        SyncStreamKt.write16LE(s, 0);
        SyncStreamKt.write16LE(s, 1);
        SyncStreamKt.write16LE(s, image2.getFrames().size());
        int payloadStart = 6 + 16 * image2.getFrames().size();
        SyncStream payloadData = SyncStreamKt.MemorySyncStream$default(null, 1, null);
        for (ImageFrame frame2 : image2.getFrames()) {
            Bitmap bitmap = frame2.getBitmap();
            int width2 = bitmap.getWidth();
            int height2 = bitmap.getHeight();
            if (width2 > 256 || height2 > 256) {
                throw new IllegalStateException(("Size too big for ICO image: " + frame2.getBitmap().getSize()).toString());
            }
            SyncStreamKt.write8(s, width2);
            SyncStreamKt.write8(s, height2);
            SyncStreamKt.write8(s, 0);
            SyncStreamKt.write8(s, 0);
            SyncStreamKt.write16LE(s, 1);
            SyncStreamKt.write16LE(s, 32);
            int start2 = (int)payloadData.getPosition();
            if (width2 == 32 && height2 == 32) {
                byte[] bmp2 = ImageFormat.encode$default((ImageFormat)BMP.INSTANCE, bitmap.toBMP32(), null, 2, null);
                SyncStreamKt.writeBytes(payloadData, ArraysKt.sliceArray(bmp2, RangesKt.until(14, bmp2.length)));
                Bitmap1 data2 = new Bitmap1(width2, height2, null, null, 12, null);
                SyncStreamKt.writeBytes(payloadData, data2.getData());
            } else {
                SyncStreamKt.writeBytes(payloadData, ImageFormat.encode$default((ImageFormat)PNG.INSTANCE, bitmap.toBMP32(), null, 2, null));
            }
            int size2 = (int)payloadData.getPosition() - start2;
            SyncStreamKt.write32LE((SyncOutputStream)s, size2);
            SyncStreamKt.write32LE((SyncOutputStream)s, payloadStart + start2);
        }
        SyncStreamKt.writeBytes(s, SyncStreamKt.toByteArray(payloadData));
    }

    private static final readImage.DirEntry readImage$readDirEntry(SyncStream $s) {
        return new DirEntry(SyncStreamKt.readU8($s), SyncStreamKt.readU8($s), SyncStreamKt.readU8($s), SyncStreamKt.readU8($s), SyncStreamKt.readU16LE($s), SyncStreamKt.readU16LE($s), SyncStreamKt.readS32LE($s), SyncStreamKt.readS32LE($s));
    }

    /*
     * WARNING - void declaration
     */
    private static final Bitmap readImage$readBitmap(ImageDecodingProps $props, readImage.DirEntry e, SyncStream s) {
        Bitmap bitmap;
        long tryPNGHead = SyncStreamKt.readU32BE(SyncStreamKt.sliceStart$default(s, 0L, 1, null));
        if (tryPNGHead == 2303741511L) {
            return PNG.INSTANCE.decode(SyncStreamKt.sliceStart$default(s, 0L, 1, null), $props.withFileName($props.getFilename() + ".png"));
        }
        int headerSize = SyncStreamKt.readS32LE(s);
        int width2 = SyncStreamKt.readS32LE(s);
        int height2 = SyncStreamKt.readS32LE(s);
        int planes = SyncStreamKt.readS16LE(s);
        int bitCount = SyncStreamKt.readS16LE(s);
        int compression = SyncStreamKt.readS32LE(s);
        int imageSize = SyncStreamKt.readS32LE(s);
        int pixelsXPerMeter = SyncStreamKt.readS32LE(s);
        int pixelsYPerMeter = SyncStreamKt.readS32LE(s);
        int clrUsed = SyncStreamKt.readS32LE(s);
        int clrImportant = SyncStreamKt.readS32LE(s);
        int[] palette = RgbaArray.Companion.invoke-lrAz6eQ(0);
        if (compression != 0) {
            throw new UnsupportedOperationException("Not supported compressed .ico");
        }
        if (bitCount <= 8) {
            void $this$mapTo$iv$iv;
            int colors = clrUsed == 0 ? 1 << bitCount : clrUsed;
            Iterable $this$map$iv = RangesKt.until(0, colors);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                int b = SyncStreamKt.readU8(s);
                int g = SyncStreamKt.readU8(s);
                int r = SyncStreamKt.readU8(s);
                int reserved = SyncStreamKt.readU8(s);
                collection.add(RGBA.box-impl(RGBA.Companion.invoke-6bQucaA(r, g, b, 255)));
            }
            palette = RGBAKt.toRgbaArray((List)destination$iv$iv);
        }
        int stride = e.getWidth() * bitCount / 8;
        byte[] data2 = SyncStreamKt.readBytes(s, stride * e.getHeight());
        switch (bitCount) {
            case 4: {
                bitmap = new Bitmap4(e.getWidth(), e.getHeight(), data2, palette, null);
                break;
            }
            case 8: {
                bitmap = new Bitmap8(e.getWidth(), e.getHeight(), data2, palette, null);
                break;
            }
            case 32: {
                bitmap = Bitmap32.writeDecoded$default(new Bitmap32(e.getWidth(), e.getHeight(), null, false, 4, null), BGRA.INSTANCE, data2, 0, false, 12, null);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported bitCount: " + bitCount);
            }
        }
        return bitmap;
    }
}

