/*
 * Decompiled with CFR 0.152.
 */
package korlibs.image.format;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import korlibs.encoding.HexKt;
import korlibs.image.bitmap.Bitmap;
import korlibs.image.bitmap.Bitmap32;
import korlibs.image.bitmap.Bitmap8;
import korlibs.image.bitmap.Bitmap8Kt;
import korlibs.image.bitmap.BitmapIndexed;
import korlibs.image.color.ColorFormatKt;
import korlibs.image.color.RGB;
import korlibs.image.color.RGBA;
import korlibs.image.color.RgbaArray;
import korlibs.image.format.EXIF;
import korlibs.image.format.ImageData;
import korlibs.image.format.ImageDecodingProps;
import korlibs.image.format.ImageEncodingProps;
import korlibs.image.format.ImageFormat;
import korlibs.image.format.ImageInfo;
import korlibs.image.format.PNG;
import korlibs.io.async.RunBlockingNoSuspensionsKt;
import korlibs.io.compression.CompressionContext;
import korlibs.io.compression.CompressionMethodKt;
import korlibs.io.compression.deflate.ZLib;
import korlibs.io.lang.CharsetKt;
import korlibs.io.stream.SyncInputStream;
import korlibs.io.stream.SyncOutputStream;
import korlibs.io.stream.SyncStream;
import korlibs.io.stream.SyncStreamKt;
import korlibs.io.util.checksum.CRC32;
import korlibs.io.util.checksum.SimpleChecksum;
import korlibs.math.ConvertRangeKt;
import korlibs.math.DivisionKt;
import korlibs.memory.ArraysKt;
import korlibs.memory.BitsKt;
import korlibs.memory.ByteArrayBuilder;
import korlibs.memory.ByteArrayGetSetKt;
import korlibs.memory.UByteArrayInt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.UByte;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00044567B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\t2\b\b\u0002\u0010\u0014\u001a\u00020\t\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0016J\"\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0011H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u001e\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\tJ$\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010(\u001a\u00020)2\b\b\u0002\u0010*\u001a\u00020\u001eH\u0002J\u0018\u0010+\u001a\u00020,2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J \u0010-\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u0011\u00f8\u0001\u0000\u00a2\u0006\u0004\b/\u00100J \u00101\u001a\u00020\u000e2\u0006\u00102\u001a\u00020,2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u000203H\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0007\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u00068"}, d2={"Lkorlibs/image/format/PNG;", "Lkorlibs/image/format/ImageFormat;", "()V", "InterlacedPasses", "", "Lkorlibs/image/format/PNG$InterlacedPass;", "getInterlacedPasses", "()Ljava/util/List;", "MAGIC1", "", "MAGIC2", "NormalPasses", "getNormalPasses", "applyFilter", "", "filter", "p", "Lkorlibs/memory/UByteArrayInt;", "c", "bpp", "size", "applyFilter-4yeQB6Q", "(I[B[BII)V", "compressionScore", "", "data", "temp", "compressionScore-GERVgfE", "([B[B)D", "decodeHeader", "Lkorlibs/image/format/ImageInfo;", "s", "Lkorlibs/io/stream/SyncStream;", "props", "Lkorlibs/image/format/ImageDecodingProps;", "paethPredictor", "a", "b", "readCommon", "", "readHeader", "", "info", "readImage", "Lkorlibs/image/format/ImageData;", "updateHistoriogram", "historiogram", "updateHistoriogram-GERVgfE", "([B[B)V", "writeImage", "image", "Lkorlibs/image/format/ImageEncodingProps;", "Colorspace", "DecodingContext", "Header", "InterlacedPass", "korge-core"})
@SourceDebugExtension(value={"SMAP\nPNG.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PNG.kt\nkorlibs/image/format/PNG\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 BitmapIndexed.kt\nkorlibs/image/bitmap/BitmapIndexed\n+ 5 SyncStream.kt\nkorlibs/io/stream/SyncStreamKt\n*L\n1#1,477:1\n11155#2:478\n11266#2,4:479\n2310#3,14:483\n1549#3:497\n1620#3,3:498\n32#4:501\n32#4:502\n32#4:503\n298#5,4:504\n298#5,4:508\n*S KotlinDebug\n*F\n+ 1 PNG.kt\nkorlibs/image/format/PNG\n*L\n226#1:478\n226#1:479,4\n230#1:483,14\n361#1:497\n361#1:498,3\n394#1:501\n395#1:502\n396#1:503\n125#1:504,4\n130#1:508,4\n*E\n"})
public final class PNG
extends ImageFormat {
    @NotNull
    public static final PNG INSTANCE = new PNG();
    public static final int MAGIC1 = -1991225785;
    public static final int MAGIC2 = 218765834;
    @NotNull
    private static final List<InterlacedPass> InterlacedPasses;
    @NotNull
    private static final List<InterlacedPass> NormalPasses;

    private PNG() {
        String[] stringArray = new String[]{"png"};
        super(stringArray);
    }

    @NotNull
    public final List<InterlacedPass> getInterlacedPasses() {
        return InterlacedPasses;
    }

    @NotNull
    public final List<InterlacedPass> getNormalPasses() {
        return NormalPasses;
    }

    @Override
    @Nullable
    public ImageInfo decodeHeader(@NotNull SyncStream s, @NotNull ImageDecodingProps props) {
        ImageInfo imageInfo;
        try {
            ImageInfo info2 = new ImageInfo();
            Object object = this.readCommon(s, true, info2);
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type korlibs.image.format.PNG.Header");
            Header header = (Header)object;
        }
        catch (Throwable t) {
            imageInfo = null;
        }
        return imageInfo;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeImage(@NotNull ImageData image2, @NotNull SyncStream s, @NotNull ImageEncodingProps props) {
        Bitmap bitmap;
        Bitmap bitmap2 = image2.getMainBitmap();
        int width2 = bitmap2.getWidth();
        int height2 = bitmap2.getHeight();
        SyncStreamKt.write32BE((SyncOutputStream)s, -1991225785);
        SyncStreamKt.write32BE((SyncOutputStream)s, 218765834);
        int level = (int)ConvertRangeKt.convertRangeClamped(props.getQuality(), 0.0, 1.0, 0.0, 9.0);
        if (bitmap2 instanceof BitmapIndexed) {
            int ncolors = ((BitmapIndexed)bitmap2).computeMaxReferencedColors();
            PNG.writeImage$writeHeader(width2, height2, s, Colorspace.INDEXED);
            PNG.writeImage$writeChunk$1(s, "PLTE", ncolors * 3, (Function1<? super SyncStream, Unit>)new Function1<SyncStream, Unit>(ncolors, bitmap2){
                final /* synthetic */ int $ncolors;
                final /* synthetic */ Bitmap $bitmap;
                {
                    this.$ncolors = $ncolors;
                    this.$bitmap = $bitmap;
                    super(1);
                }

                public final void invoke(@NotNull SyncStream $this$writeChunk) {
                    for (int n = 0; n < this.$ncolors; ++n) {
                        int c = RgbaArray.get-O1c-hRk(((BitmapIndexed)this.$bitmap).getPalette-FROm4YY(), n);
                        SyncStreamKt.write8($this$writeChunk, RGBA.getR-impl(c));
                        SyncStreamKt.write8($this$writeChunk, RGBA.getG-impl(c));
                        SyncStreamKt.write8($this$writeChunk, RGBA.getB-impl(c));
                    }
                }
            });
            PNG.writeImage$writeChunk$1(s, "tRNS", RgbaArray.getSize-impl(((BitmapIndexed)bitmap2).getPalette-FROm4YY()) * 1, (Function1<? super SyncStream, Unit>)new Function1<SyncStream, Unit>(ncolors, bitmap2){
                final /* synthetic */ int $ncolors;
                final /* synthetic */ Bitmap $bitmap;
                {
                    this.$ncolors = $ncolors;
                    this.$bitmap = $bitmap;
                    super(1);
                }

                public final void invoke(@NotNull SyncStream $this$writeChunk) {
                    for (int n = 0; n < this.$ncolors; ++n) {
                        int c = RgbaArray.get-O1c-hRk(((BitmapIndexed)this.$bitmap).getPalette-FROm4YY(), n);
                        SyncStreamKt.write8($this$writeChunk, RGBA.getA-impl(c));
                    }
                }
            });
            Bitmap8 bitmap8 = Bitmap8Kt.tryToExactBitmap8(bitmap2);
            bitmap = bitmap8 != null ? (BitmapIndexed)bitmap8 : (BitmapIndexed)bitmap2;
        } else {
            PNG.writeImage$writeHeader(width2, height2, s, Colorspace.RGBA);
            bitmap = props.getDepremultiplyIfRequired() ? bitmap2.toBMP32().depremultipliedIfRequired() : bitmap2.toBMP32();
        }
        Bitmap bmp2 = bitmap;
        Bitmap8 bmp8 = bmp2 instanceof Bitmap8 ? (Bitmap8)bmp2 : null;
        Bitmap32 bmp322 = bmp2 instanceof Bitmap32 ? (Bitmap32)bmp2 : null;
        int Bpp = DivisionKt.divCeil(bitmap2.getBpp(), 8);
        int scanline = width2 * Bpp;
        byte[] prev = UByteArrayInt.constructor-impl(scanline);
        int n = 0;
        UByteArrayInt[] uByteArrayIntArray = new UByteArrayInt[3];
        while (n < 3) {
            int n2 = n++;
            uByteArrayIntArray[n2] = UByteArrayInt.box-impl(UByteArrayInt.constructor-impl(scanline));
        }
        UByteArrayInt[] currs = uByteArrayIntArray;
        byte[] curr = currs[0].unbox-impl();
        byte[] currF1 = currs[1].unbox-impl();
        byte[] currF2 = currs[2].unbox-impl();
        byte[] tempScore = UByteArrayInt.constructor-impl(256);
        int oscanline = scanline + 1;
        byte[] out = new byte[height2 * oscanline];
        boolean tryFilters = props.getQuality() >= 0.5;
        for (int y = 0; y < height2; ++y) {
            int n3;
            int x;
            int index2 = bmp2.index(0, y);
            int pos = 0;
            if (bmp322 != null) {
                for (x = 0; x < width2; ++x) {
                    int c = bmp322.getRgbaAtIndex-O1c-hRk(index2 + x);
                    ByteArrayGetSetKt.set8(curr, pos++, RGBA.getR-impl(c));
                    ByteArrayGetSetKt.set8(curr, pos++, RGBA.getG-impl(c));
                    ByteArrayGetSetKt.set8(curr, pos++, RGBA.getB-impl(c));
                    ByteArrayGetSetKt.set8(curr, pos++, RGBA.getA-impl(c));
                }
            } else if (bmp8 != null) {
                for (x = 0; x < width2; ++x) {
                    ByteArrayGetSetKt.set8(curr, pos++, bmp8.getIntIndex(index2 + x));
                }
            }
            if (tryFilters) {
                int n4;
                PNG $this$writeImage_u24lambda_u243 = this;
                boolean bl = false;
                for (n4 = 0; n4 < Bpp; ++n4) {
                    UByteArrayInt.set-impl(currF1, n4, UByteArrayInt.get-impl(curr, n4));
                }
                for (n4 = Bpp; n4 < scanline; ++n4) {
                    UByteArrayInt.set-impl(currF1, n4, UByteArrayInt.get-impl(curr, n4) - UByteArrayInt.get-impl(curr, n4 - Bpp) & 0xFF);
                }
                if (y > 0) {
                    PNG $this$writeImage_u24lambda_u244 = this;
                    boolean bl2 = false;
                    for (n4 = 0; n4 < scanline; ++n4) {
                        UByteArrayInt.set-impl(currF2, n4, UByteArrayInt.get-impl(curr, n4) - UByteArrayInt.get-impl(prev, n4) & 0xFF);
                    }
                }
            }
            if (!tryFilters) {
                n3 = 0;
            } else if (props.getQuality() < 0.9) {
                n3 = y == 0 ? 1 : 2;
            } else {
                Object t;
                void $this$mapIndexedTo$iv$iv;
                UByteArrayInt[] $this$mapIndexed$iv = currs;
                boolean $i$f$mapIndexed = false;
                UByteArrayInt[] uByteArrayIntArray2 = $this$mapIndexed$iv;
                Collection destination$iv$iv = new ArrayList($this$mapIndexed$iv.length);
                boolean $i$f$mapIndexedTo = false;
                int index$iv$iv = 0;
                for (void item$iv$iv : $this$mapIndexedTo$iv$iv) {
                    void bytes;
                    void index3;
                    int n5 = index$iv$iv++;
                    byte[] byArray = item$iv$iv.unbox-impl();
                    int n6 = n5;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    UByteArrayInt.fill-impl$default(tempScore, 0, 0, 0, 6, null);
                    collection.add(TuplesKt.to((int)index3, y > 0 || index3 <= true ? INSTANCE.compressionScore-GERVgfE((byte[])bytes, tempScore) : Double.POSITIVE_INFINITY));
                }
                List scores = (List)destination$iv$iv;
                Iterable<Object> $this$minBy$iv = scores;
                boolean $i$f$minByOrThrow = false;
                Iterator iterator$iv = $this$minBy$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    t = minElem$iv;
                } else {
                    Pair it = (Pair)minElem$iv;
                    boolean bl = false;
                    double minValue$iv = ((Number)it.getSecond()).doubleValue();
                    do {
                        Object e$iv = iterator$iv.next();
                        Pair it2 = (Pair)e$iv;
                        $i$a$-minByOrThrow-PNG$writeImage$filter$1 = false;
                        double v$iv = ((Number)it2.getSecond()).doubleValue();
                        if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    t = minElem$iv;
                }
                $this$minBy$iv = ((Pair)t).getFirst();
                int filter2 = ((Number)((Object)$this$minBy$iv)).intValue();
                boolean bl = false;
                n3 = ((Number)((Object)$this$minBy$iv)).intValue();
            }
            int filter3 = n3;
            int outpos = y * oscanline;
            byte[] currFiltered = currs[filter3].unbox-impl();
            out[outpos] = (byte)filter3;
            ArraysKt.arraycopy(currFiltered, 0, out, outpos + 1, scanline);
            ArraysKt.arraycopy-Q2LO90Q(curr, 0, prev, 0, scanline);
        }
        PNG.writeImage$writeChunk(s, "IDAT", PNG.writeImage$compress(level, out));
        PNG.writeImage$writeChunk$1(s, "IEND", 0, writeImage.3.INSTANCE);
    }

    public final void updateHistoriogram-GERVgfE(@NotNull byte[] historiogram, @NotNull byte[] data2) {
        int n = UByteArrayInt.getSize-impl(data2);
        for (int n2 = 0; n2 < n; ++n2) {
            int n3 = UByte.constructor-impl((byte)UByteArrayInt.get-impl(data2, n2)) & 0xFF;
            int n4 = UByteArrayInt.get-impl(historiogram, n3);
            UByteArrayInt.set-impl(historiogram, n3, n4 + 1);
        }
    }

    private final double compressionScore-GERVgfE(byte[] data2, byte[] temp) {
        int n;
        double score = 0.0;
        UByteArrayInt.fill-impl$default(temp, 0, 0, 0, 6, null);
        int n2 = UByteArrayInt.getSize-impl(data2);
        for (n = 0; n < n2; ++n) {
            int n3 = UByte.constructor-impl((byte)UByteArrayInt.get-impl(data2, n)) & 0xFF;
            int n4 = UByteArrayInt.get-impl(temp, n3);
            UByteArrayInt.set-impl(temp, n3, n4 + 1);
        }
        for (n = 0; n < 256; ++n) {
            int count2 = UByteArrayInt.get-impl(temp, n);
            if (count2 == 0) continue;
            score += 1.0 / (double)count2 * Math.sqrt(1.0 + (double)n);
        }
        return score;
    }

    /*
     * WARNING - void declaration
     */
    private final Object readCommon(SyncStream s, boolean readHeader, ImageInfo info2) {
        Bitmap bitmap;
        int n;
        Object object;
        int magic = SyncStreamKt.readS32BE(s);
        if (magic != -1991225785) {
            throw new IllegalArgumentException("Invalid PNG file magic: " + HexKt.getHex(magic) + "!=" + HexKt.getHex(-1991225785));
        }
        SyncStreamKt.readS32BE(s);
        Ref.ObjectRef<Header> pheader = new Ref.ObjectRef<Header>();
        ByteArrayBuilder pngdata = new ByteArrayBuilder(0, 1, null);
        byte[] rgbPalette = UByteArrayInt.constructor-impl(768);
        int n2 = 0;
        byte[] byArray = new byte[256];
        while (n2 < 256) {
            int n3 = n2++;
            byArray[n3] = -1;
        }
        byte[] aPalette = UByteArrayInt.constructor-impl(byArray);
        Ref.IntRef paletteCount = new Ref.IntRef();
        while (!SyncStreamKt.getEof(s) && PNG.readCommon$readChunk(s, pheader, paletteCount, rgbPalette, aPalette, readHeader, pngdata, info2)) {
        }
        if (readHeader) {
            return pheader.element;
        }
        Header header = (Header)pheader.element;
        if (header == null) {
            throw new IllegalArgumentException("PNG without header!");
        }
        Header header2 = header;
        int width2 = header2.getWidth();
        int height2 = header2.getHeight();
        int outputSizeHint = (1 + width2) * height2 * header2.getComponents();
        byte[] databb = CompressionMethodKt.uncompress$default(pngdata.toByteArray(), ZLib.Companion, 0, 2, null);
        int databbp = 0;
        DecodingContext context2 = new DecodingContext(header2);
        int bpp = context2.getHeader().getComponents();
        int[] row32 = context2.getRow32-FROm4YY();
        if (header2.getComponents() == 1) {
            Collection<Integer> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = RangesKt.until(0, paletteCount.element);
            byte[] byArray2 = null;
            int n4 = height2;
            int n5 = width2;
            boolean $i$f$map = false;
            void var22_26 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            object = $this$mapTo$iv$iv.iterator();
            while (object.hasNext()) {
                void it;
                int item$iv$iv;
                n = item$iv$iv = ((IntIterator)object).nextInt();
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(RGBA.Companion.invoke-6bQucaA(UByteArrayInt.get-impl(rgbPalette, (int)(it * 3 + false)), UByteArrayInt.get-impl(rgbPalette, (int)(it * 3 + true)), UByteArrayInt.get-impl(rgbPalette, (int)(it * 3 + 2)), UByteArrayInt.get-impl(aPalette, (int)it)));
            }
            collection = (List)destination$iv$iv;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n6 = 4;
            int[] nArray = RgbaArray.constructor-impl(CollectionsKt.toIntArray(collection));
            byte[] byArray3 = byArray2;
            int n7 = n4;
            int n8 = n5;
            bitmap = new Bitmap8(n8, n7, byArray3, nArray, n6, defaultConstructorMarker);
        } else {
            bitmap = new Bitmap32(width2, height2, null, false, 4, null);
        }
        Bitmap bmp2 = bitmap;
        Bitmap8 bmp8 = bmp2 instanceof Bitmap8 ? (Bitmap8)bmp2 : null;
        Bitmap32 bmp322 = bmp2 instanceof Bitmap32 ? (Bitmap32)bmp2 : null;
        List<InterlacedPass> passes = header2.getInterlacemethod() == 1 ? InterlacedPasses : NormalPasses;
        block13: for (InterlacedPass pass : passes) {
            object = RangesKt.step(RangesKt.until(pass.getStartingRow(), height2), pass.getRowIncrement());
            int row = ((IntProgression)object).getFirst();
            n = ((IntProgression)object).getLast();
            int n9 = ((IntProgression)object).getStep();
            if ((n9 <= 0 || row > n) && (n9 >= 0 || n > row)) continue;
            while (true) {
                block27: {
                    Object object2;
                    byte[] lastRow;
                    byte[] currentRow;
                    int filter2;
                    int bytesInThisRow;
                    int pixelsInThisRow;
                    int colIncrement;
                    int col;
                    block26: {
                        col = pass.getStartingCol();
                        colIncrement = pass.getColIncrement();
                        pixelsInThisRow = width2 >>> pass.getColIncrementShift();
                        bytesInThisRow = pixelsInThisRow * header2.getComponents() * header2.getBitsPerChannel() / 8;
                        filter2 = databb[databbp++] & 0xFF;
                        currentRow = context2.getCurrentRow-uV-T8J8();
                        lastRow = context2.getLastRow-uV-T8J8();
                        ArraysKt.arraycopy(databb, databbp, ArraysKt.asByteArray-Bs7sjYo(currentRow), 0, bytesInThisRow);
                        databbp += bytesInThisRow;
                        if (bmp8 == null) break block26;
                        PNG.applyFilter-4yeQB6Q$default(this, filter2, lastRow, currentRow, header2.getComponents(), 0, 16, null);
                        switch (header2.getBitsPerChannel()) {
                            case 1: {
                                int x$iv;
                                BitmapIndexed this_$iv;
                                boolean $i$f$set;
                                int color$iv;
                                int n10;
                                for (n10 = 0; n10 < width2; ++n10) {
                                    object2 = (BitmapIndexed)bmp2;
                                    int n11 = col + n10;
                                    color$iv = BitsKt.extract(UByteArrayInt.get-impl(currentRow, n10 / 8), 7 - n10 % 8 * 1, 1);
                                    $i$f$set = false;
                                    this_$iv.setInt(x$iv, row, color$iv);
                                }
                                break block27;
                            }
                            case 2: {
                                int x$iv;
                                BitmapIndexed this_$iv;
                                boolean $i$f$set;
                                int color$iv;
                                int n10;
                                for (n10 = 0; n10 < width2; ++n10) {
                                    this_$iv = (BitmapIndexed)bmp2;
                                    x$iv = col + n10;
                                    color$iv = BitsKt.extract(UByteArrayInt.get-impl(currentRow, n10 / 4), 6 - n10 % 4 * 2, 2);
                                    $i$f$set = false;
                                    this_$iv.setInt(x$iv, row, color$iv);
                                }
                                break block27;
                            }
                            case 4: {
                                int x$iv;
                                BitmapIndexed this_$iv;
                                boolean $i$f$set;
                                int color$iv;
                                int n10;
                                for (n10 = 0; n10 < width2; ++n10) {
                                    this_$iv = (BitmapIndexed)bmp2;
                                    x$iv = col + n10;
                                    color$iv = BitsKt.extract(UByteArrayInt.get-impl(currentRow, n10 / 2), 4 - n10 % 2 * 4, 4);
                                    $i$f$set = false;
                                    this_$iv.setInt(x$iv, row, color$iv);
                                }
                                break block27;
                            }
                            case 8: {
                                bmp8.setRowChunk(col, row, ArraysKt.asByteArray-Bs7sjYo(currentRow), width2, colIncrement);
                                break block27;
                            }
                            default: {
                                throw new IllegalStateException(("Unsupported header.bitsPerChannel=" + header2.getBitsPerChannel()).toString());
                            }
                        }
                    }
                    if (bmp322 != null) {
                        if (header2.getBitsPerChannel() == 8) {
                            this.applyFilter-4yeQB6Q(filter2, lastRow, currentRow, bpp, bytesInThisRow);
                            switch (bpp) {
                                case 3: {
                                    ColorFormatKt.decode-GuNni5w$default(RGB.Companion, ArraysKt.asByteArray-Bs7sjYo(currentRow), 0, row32, 0, pixelsInThisRow, false, 32, null);
                                    break;
                                }
                                case 4: {
                                    ColorFormatKt.decode-GuNni5w$default(RGBA.Companion, ArraysKt.asByteArray-Bs7sjYo(currentRow), 0, row32, 0, pixelsInThisRow, false, 32, null);
                                    break;
                                }
                                default: {
                                    object2 = "Bytes: " + bpp;
                                    throw new NotImplementedError("An operation is not implemented: " + (String)object2);
                                }
                            }
                            bmp322.setRowChunk-hRAAKQg(col, row, row32, width2, colIncrement);
                        } else {
                            throw new IllegalStateException(("Unsupported header.bitsPerChannel=" + header2.getBitsPerChannel()).toString());
                        }
                    }
                }
                context2.swapRows();
                if (row == n) continue block13;
                row += n9;
            }
        }
        return bmp2;
    }

    static /* synthetic */ Object readCommon$default(PNG pNG, SyncStream syncStream, boolean bl, ImageInfo imageInfo, int n, Object object) {
        if ((n & 4) != 0) {
            imageInfo = new ImageInfo();
        }
        return pNG.readCommon(syncStream, bl, imageInfo);
    }

    @Override
    @NotNull
    public ImageData readImage(@NotNull SyncStream s, @NotNull ImageDecodingProps props) {
        Object object = PNG.readCommon$default(this, s, false, null, 4, null);
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type korlibs.image.bitmap.Bitmap");
        return ImageData.Companion.invoke((Bitmap)object);
    }

    public final int paethPredictor(int a, int b, int c) {
        int p = a + b - c;
        int pa = Math.abs(p - a);
        int pb = Math.abs(p - b);
        int pc = Math.abs(p - c);
        return pa <= pb && pa <= pc ? a : (pb <= pc ? b : c);
    }

    public final void applyFilter-4yeQB6Q(int filter2, @NotNull byte[] p, @NotNull byte[] c, int bpp, int size2) {
        switch (filter2) {
            case 0: {
                break;
            }
            case 1: {
                for (int n = bpp; n < size2; ++n) {
                    int n2 = n;
                    UByteArrayInt.set-impl(c, n2, UByteArrayInt.get-impl(c, n2) + UByteArrayInt.get-impl(c, n - bpp));
                }
                break;
            }
            case 2: {
                for (int n = 0; n < size2; ++n) {
                    int n3 = n;
                    UByteArrayInt.set-impl(c, n3, UByteArrayInt.get-impl(c, n3) + UByteArrayInt.get-impl(p, n));
                }
                break;
            }
            case 3: {
                int n;
                int n4;
                for (n4 = 0; n4 < bpp; ++n4) {
                    n = n4;
                    UByteArrayInt.set-impl(c, n, UByteArrayInt.get-impl(c, n) + UByteArrayInt.get-impl(p, n4) / 2);
                }
                for (n4 = bpp; n4 < size2; ++n4) {
                    n = n4;
                    UByteArrayInt.set-impl(c, n, UByteArrayInt.get-impl(c, n) + (UByteArrayInt.get-impl(c, n4 - bpp) + UByteArrayInt.get-impl(p, n4)) / 2);
                }
                break;
            }
            case 4: {
                int n;
                int n5;
                for (n5 = 0; n5 < bpp; ++n5) {
                    n = n5;
                    UByteArrayInt.set-impl(c, n, UByteArrayInt.get-impl(c, n) + UByteArrayInt.get-impl(p, n5));
                }
                for (n5 = bpp; n5 < size2; ++n5) {
                    n = n5;
                    UByteArrayInt.set-impl(c, n, UByteArrayInt.get-impl(c, n) + this.paethPredictor(UByteArrayInt.get-impl(c, n5 - bpp), UByteArrayInt.get-impl(p, n5), UByteArrayInt.get-impl(p, n5 - bpp)));
                }
                break;
            }
            default: {
                String string = "Filter: " + filter2;
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
        }
    }

    public static /* synthetic */ void applyFilter-4yeQB6Q$default(PNG pNG, int n, byte[] byArray, byte[] byArray2, int n2, int n3, int n4, Object object) {
        if ((n4 & 0x10) != 0) {
            n3 = UByteArrayInt.getSize-impl(byArray2);
        }
        pNG.applyFilter-4yeQB6Q(n, byArray, byArray2, n2, n3);
    }

    private static final void writeImage$writeChunk(SyncStream $s, String name2, byte[] data2) {
        byte[] byArray = Arrays.copyOf(CharsetKt.toByteArray$default(name2, null, 0, 0, 7, null), 4);
        Intrinsics.checkNotNullExpressionValue(byArray, "copyOf(...)");
        byte[] nameBytes = byArray;
        int crc = CRC32.INSTANCE.getInitialValue();
        crc = SimpleChecksum.DefaultImpls.update$default(CRC32.INSTANCE, crc, nameBytes, 0, 0, 12, null);
        crc = SimpleChecksum.DefaultImpls.update$default(CRC32.INSTANCE, crc, data2, 0, 0, 12, null);
        SyncStreamKt.write32BE((SyncOutputStream)$s, data2.length);
        SyncStreamKt.writeBytes($s, nameBytes);
        SyncStreamKt.writeBytes($s, data2);
        SyncStreamKt.write32BE((SyncOutputStream)$s, crc);
    }

    private static final byte[] writeImage$compress(int level, byte[] data2) {
        return CompressionMethodKt.compress$default(data2, ZLib.Companion, new CompressionContext(level), 0, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final void writeImage$writeChunk$1(SyncStream $s, String name2, int initialCapacity, Function1<? super SyncStream, Unit> callback) {
        void $this$writeImage_u24writeChunk_u241_u24lambda_u240;
        SyncStream s$iv;
        boolean $i$f$MemorySyncStreamToByteArray = false;
        ByteArrayBuilder buffer$iv = new ByteArrayBuilder(initialCapacity);
        SyncStream syncStream = s$iv = SyncStreamKt.MemorySyncStream(buffer$iv);
        String string = name2;
        SyncStream syncStream2 = $s;
        boolean bl = false;
        callback.invoke((SyncStream)$this$writeImage_u24writeChunk_u241_u24lambda_u240);
        Unit unit = Unit.INSTANCE;
        PNG.writeImage$writeChunk(syncStream2, string, buffer$iv.toByteArray());
    }

    static /* synthetic */ void writeImage$writeChunk$1$default(SyncStream syncStream, String string, int n, Function1 function1, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 4096;
        }
        PNG.writeImage$writeChunk$1(syncStream, string, n, function1);
    }

    /*
     * WARNING - void declaration
     */
    private static final void writeImage$writeChunkCompressed(int level, SyncStream $s, String name2, int initialCapacity, Function1<? super SyncStream, Unit> callback) {
        void $this$writeImage_u24writeChunkCompressed_u24lambda_u242;
        SyncStream s$iv;
        boolean $i$f$MemorySyncStreamToByteArray = false;
        ByteArrayBuilder buffer$iv = new ByteArrayBuilder(initialCapacity);
        SyncStream syncStream = s$iv = SyncStreamKt.MemorySyncStream(buffer$iv);
        int n = level;
        String string = name2;
        SyncStream syncStream2 = $s;
        boolean bl = false;
        callback.invoke((SyncStream)$this$writeImage_u24writeChunkCompressed_u24lambda_u242);
        Unit unit = Unit.INSTANCE;
        PNG.writeImage$writeChunk(syncStream2, string, PNG.writeImage$compress(n, buffer$iv.toByteArray()));
    }

    static /* synthetic */ void writeImage$writeChunkCompressed$default(int n, SyncStream syncStream, String string, int n2, Function1 function1, int n3, Object object) {
        if ((n3 & 8) != 0) {
            n2 = 4096;
        }
        PNG.writeImage$writeChunkCompressed(n, syncStream, string, n2, function1);
    }

    private static final void writeImage$writeHeader(int width2, int height2, SyncStream $s, Colorspace colorspace) {
        PNG.writeImage$writeChunk$1($s, "IHDR", 13, (Function1<? super SyncStream, Unit>)new Function1<SyncStream, Unit>(width2, height2, colorspace){
            final /* synthetic */ int $width;
            final /* synthetic */ int $height;
            final /* synthetic */ Colorspace $colorspace;
            {
                this.$width = $width;
                this.$height = $height;
                this.$colorspace = $colorspace;
                super(1);
            }

            public final void invoke(@NotNull SyncStream $this$writeChunk) {
                SyncStreamKt.write32BE((SyncOutputStream)$this$writeChunk, this.$width);
                SyncStreamKt.write32BE((SyncOutputStream)$this$writeChunk, this.$height);
                SyncStreamKt.write8($this$writeChunk, 8);
                SyncStreamKt.write8($this$writeChunk, this.$colorspace.getId());
                SyncStreamKt.write8($this$writeChunk, 0);
                SyncStreamKt.write8($this$writeChunk, 0);
                SyncStreamKt.write8($this$writeChunk, 0);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean readCommon$readChunk(SyncStream $this$readCommon_u24readChunk, Ref.ObjectRef<Header> pheader, Ref.IntRef paletteCount, byte[] rgbPalette, byte[] aPalette, boolean $readHeader, ByteArrayBuilder pngdata, ImageInfo $info) {
        if (SyncStreamKt.getEof($this$readCommon_u24readChunk)) {
            return false;
        }
        int length2 = SyncStreamKt.readS32BE($this$readCommon_u24readChunk);
        String type2 = SyncStreamKt.readStringz$default((SyncInputStream)$this$readCommon_u24readChunk, 4, null, 2, null);
        SyncStream data2 = SyncStreamKt.readStream($this$readCommon_u24readChunk, (long)length2);
        int crc = SyncStreamKt.readS32BE($this$readCommon_u24readChunk);
        switch (type2) {
            case "IHDR": {
                Header header;
                void $this$readCommon_u24readChunk_u24lambda_u249;
                SyncStream syncStream = data2;
                Ref.ObjectRef<Header> objectRef = pheader;
                boolean bl = false;
                int n = SyncStreamKt.readS32BE((SyncInputStream)$this$readCommon_u24readChunk_u24lambda_u249);
                int n2 = SyncStreamKt.readS32BE((SyncInputStream)$this$readCommon_u24readChunk_u24lambda_u249);
                int n3 = SyncStreamKt.readU8((SyncInputStream)$this$readCommon_u24readChunk_u24lambda_u249);
                Colorspace colorspace = Colorspace.Companion.getBY_ID().get(SyncStreamKt.readU8((SyncInputStream)$this$readCommon_u24readChunk_u24lambda_u249));
                if (colorspace == null) {
                    colorspace = Colorspace.RGBA;
                }
                Header it = header = new Header(n, n2, n3, colorspace, SyncStreamKt.readU8((SyncInputStream)$this$readCommon_u24readChunk_u24lambda_u249), SyncStreamKt.readU8((SyncInputStream)$this$readCommon_u24readChunk_u24lambda_u249), SyncStreamKt.readU8((SyncInputStream)$this$readCommon_u24readChunk_u24lambda_u249));
                boolean bl2 = false;
                $info.setWidth(it.getWidth());
                $info.setHeight(it.getHeight());
                $info.setBitsPerPixel(it.getBitsPerChannel() * it.getColorspace().getNchannels());
                objectRef.element = header;
                break;
            }
            case "PLTE": {
                paletteCount.element = Math.max(paletteCount.element, (int)data2.getLength() / 3);
                data2.read(ArraysKt.asByteArray-Bs7sjYo(rgbPalette), 0, (int)data2.getLength());
                break;
            }
            case "tRNS": {
                paletteCount.element = Math.max(paletteCount.element, (int)data2.getLength());
                data2.read(ArraysKt.asByteArray-Bs7sjYo(aPalette), 0, (int)data2.getLength());
                break;
            }
            case "IDAT": {
                if ($readHeader) {
                    return false;
                }
                ByteArrayBuilder.append$default(pngdata, SyncStreamKt.readAll(data2), 0, 0, 6, null);
                break;
            }
            case "eXIf": {
                RunBlockingNoSuspensionsKt.runBlockingNoSuspensions((Function1)new Function1<Continuation<? super ImageInfo>, Object>(data2, $info, null){
                    int label;
                    final /* synthetic */ SyncStream $data;
                    final /* synthetic */ ImageInfo $info;
                    {
                        this.$data = $data;
                        this.$info = $info;
                        super(1, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure(object);
                                this.label = 1;
                                Object object3 = EXIF.readExifBase$default(EXIF.INSTANCE, SyncStreamKt.openAsync$default(SyncStreamKt.readAll(this.$data), null, 1, null), this.$info, false, this, 4, null);
                                if (object3 != object2) return object3;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure($result);
                                Object object3 = $result;
                                return object3;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                        return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                    }

                    @Nullable
                    public final Object invoke(@Nullable Continuation<? super ImageInfo> p1) {
                        return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                    }
                });
                break;
            }
            case "IEND": {
                return false;
            }
        }
        return true;
    }

    static {
        InterlacedPass[] interlacedPassArray = new InterlacedPass[]{new InterlacedPass(0, 0, 8, 8, 8, 8), new InterlacedPass(0, 4, 8, 8, 8, 4), new InterlacedPass(4, 0, 8, 4, 4, 4), new InterlacedPass(0, 2, 4, 4, 4, 2), new InterlacedPass(2, 0, 4, 2, 2, 2), new InterlacedPass(0, 1, 2, 2, 2, 1), new InterlacedPass(1, 0, 2, 1, 1, 1)};
        InterlacedPasses = CollectionsKt.listOf(interlacedPassArray);
        NormalPasses = CollectionsKt.listOf(new InterlacedPass(0, 0, 1, 1, 1, 1));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\f\b\u0086\u0081\u0002\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000eB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007j\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000f"}, d2={"Lkorlibs/image/format/PNG$Colorspace;", "", "id", "", "nchannels", "(Ljava/lang/String;III)V", "getId", "()I", "getNchannels", "GRAYSCALE", "RGB", "INDEXED", "GRAYSCALE_ALPHA", "RGBA", "Companion", "korge-core"})
    @SourceDebugExtension(value={"SMAP\nPNG.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PNG.kt\nkorlibs/image/format/PNG$Colorspace\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,477:1\n8541#2,2:478\n8801#2,4:480\n*S KotlinDebug\n*F\n+ 1 PNG.kt\nkorlibs/image/format/PNG$Colorspace\n*L\n67#1:478,2\n67#1:480,4\n*E\n"})
    public static final class Colorspace
    extends Enum<Colorspace> {
        @NotNull
        public static final Companion Companion;
        private final int id;
        private final int nchannels;
        @NotNull
        private static final Map<Integer, Colorspace> BY_ID;
        public static final /* enum */ Colorspace GRAYSCALE;
        public static final /* enum */ Colorspace RGB;
        public static final /* enum */ Colorspace INDEXED;
        public static final /* enum */ Colorspace GRAYSCALE_ALPHA;
        public static final /* enum */ Colorspace RGBA;
        private static final /* synthetic */ Colorspace[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Colorspace(int id2, int nchannels) {
            this.id = id2;
            this.nchannels = nchannels;
        }

        public final int getId() {
            return this.id;
        }

        public final int getNchannels() {
            return this.nchannels;
        }

        public static Colorspace[] values() {
            return (Colorspace[])$VALUES.clone();
        }

        public static Colorspace valueOf(String value) {
            return Enum.valueOf(Colorspace.class, value);
        }

        @NotNull
        public static EnumEntries<Colorspace> getEntries() {
            return $ENTRIES;
        }

        /*
         * WARNING - void declaration
         */
        static {
            void $this$associateByTo$iv$iv;
            GRAYSCALE = new Colorspace(0, 1);
            RGB = new Colorspace(2, 3);
            INDEXED = new Colorspace(3, 1);
            GRAYSCALE_ALPHA = new Colorspace(4, 2);
            RGBA = new Colorspace(6, 4);
            $VALUES = colorspaceArray = new Colorspace[]{Colorspace.GRAYSCALE, Colorspace.RGB, Colorspace.INDEXED, Colorspace.GRAYSCALE_ALPHA, Colorspace.RGBA};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            Colorspace[] $this$associateBy$iv = Colorspace.values();
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity($this$associateBy$iv.length), 16);
            Colorspace[] colorspaceArray = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            int n = ((void)$this$associateByTo$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                void it;
                void element$iv$iv;
                void var9_9 = element$iv$iv = $this$associateByTo$iv$iv[j];
                Map map2 = destination$iv$iv;
                boolean bl = false;
                map2.put(it.id, element$iv$iv);
            }
            BY_ID = destination$iv$iv;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lkorlibs/image/format/PNG$Colorspace$Companion;", "", "()V", "BY_ID", "", "", "Lkorlibs/image/format/PNG$Colorspace;", "getBY_ID", "()Ljava/util/Map;", "korge-core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Map<Integer, Colorspace> getBY_ID() {
                return BY_ID;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0016\u001a\u00020\u0017R\"\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\"\u0010\u000e\u001a\u00020\u0006X\u0086\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\u000f\u0010\b\"\u0004\b\u0010\u0010\nR\u0019\u0010\u0011\u001a\u00020\u0012\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0018"}, d2={"Lkorlibs/image/format/PNG$DecodingContext;", "", "header", "Lkorlibs/image/format/PNG$Header;", "(Lkorlibs/image/format/PNG$Header;)V", "currentRow", "Lkorlibs/memory/UByteArrayInt;", "getCurrentRow-uV-T8J8", "()[B", "setCurrentRow-Bs7sjYo", "([B)V", "[B", "getHeader", "()Lkorlibs/image/format/PNG$Header;", "lastRow", "getLastRow-uV-T8J8", "setLastRow-Bs7sjYo", "row32", "Lkorlibs/image/color/RgbaArray;", "getRow32-FROm4YY", "()[I", "[I", "swapRows", "", "korge-core"})
    public static final class DecodingContext {
        @NotNull
        private final Header header;
        @NotNull
        private byte[] lastRow;
        @NotNull
        private byte[] currentRow;
        @NotNull
        private final int[] row32;

        public DecodingContext(@NotNull Header header) {
            this.header = header;
            this.lastRow = UByteArrayInt.constructor-impl(this.header.getStride());
            this.currentRow = UByteArrayInt.constructor-impl(this.header.getStride());
            this.row32 = RgbaArray.Companion.invoke-lrAz6eQ(this.header.getWidth());
        }

        @NotNull
        public final Header getHeader() {
            return this.header;
        }

        @NotNull
        public final byte[] getLastRow-uV-T8J8() {
            return this.lastRow;
        }

        public final void setLastRow-Bs7sjYo(@NotNull byte[] byArray) {
            this.lastRow = byArray;
        }

        @NotNull
        public final byte[] getCurrentRow-uV-T8J8() {
            return this.currentRow;
        }

        public final void setCurrentRow-Bs7sjYo(@NotNull byte[] byArray) {
            this.currentRow = byArray;
        }

        @NotNull
        public final int[] getRow32-FROm4YY() {
            return this.row32;
        }

        public final void swapRows() {
            byte[] temp = this.currentRow;
            this.currentRow = this.lastRow;
            this.lastRow = temp;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0012\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\rR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\rR\u0011\u0010\u0016\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\r\u00a8\u0006\u0019"}, d2={"Lkorlibs/image/format/PNG$Header;", "", "width", "", "height", "bitsPerChannel", "colorspace", "Lkorlibs/image/format/PNG$Colorspace;", "compressionmethod", "filtermethod", "interlacemethod", "(IIILkorlibs/image/format/PNG$Colorspace;III)V", "getBitsPerChannel", "()I", "getColorspace", "()Lkorlibs/image/format/PNG$Colorspace;", "components", "getComponents", "getCompressionmethod", "getFiltermethod", "getHeight", "getInterlacemethod", "stride", "getStride", "getWidth", "korge-core"})
    public static final class Header {
        private final int width;
        private final int height;
        private final int bitsPerChannel;
        @NotNull
        private final Colorspace colorspace;
        private final int compressionmethod;
        private final int filtermethod;
        private final int interlacemethod;
        private final int components;
        private final int stride;

        public Header(int width2, int height2, int bitsPerChannel, @NotNull Colorspace colorspace, int compressionmethod, int filtermethod, int interlacemethod) {
            int n;
            this.width = width2;
            this.height = height2;
            this.bitsPerChannel = bitsPerChannel;
            this.colorspace = colorspace;
            this.compressionmethod = compressionmethod;
            this.filtermethod = filtermethod;
            this.interlacemethod = interlacemethod;
            switch (WhenMappings.$EnumSwitchMapping$0[this.colorspace.ordinal()]) {
                case 1: {
                    n = 1;
                    break;
                }
                case 2: {
                    n = 1;
                    break;
                }
                case 3: {
                    n = 2;
                    break;
                }
                case 4: {
                    n = 3;
                    break;
                }
                case 5: {
                    n = 4;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            this.components = n;
            this.stride = this.width * this.components * this.bitsPerChannel / 8;
        }

        public final int getWidth() {
            return this.width;
        }

        public final int getHeight() {
            return this.height;
        }

        public final int getBitsPerChannel() {
            return this.bitsPerChannel;
        }

        @NotNull
        public final Colorspace getColorspace() {
            return this.colorspace;
        }

        public final int getCompressionmethod() {
            return this.compressionmethod;
        }

        public final int getFiltermethod() {
            return this.filtermethod;
        }

        public final int getInterlacemethod() {
            return this.interlacemethod;
        }

        public final int getComponents() {
            return this.components;
        }

        public final int getStride() {
            return this.stride;
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Colorspace.values().length];
                try {
                    nArray[Colorspace.GRAYSCALE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Colorspace.INDEXED.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Colorspace.GRAYSCALE_ALPHA.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Colorspace.RGB.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Colorspace.RGBA.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003JE\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000b\u00a8\u0006 "}, d2={"Lkorlibs/image/format/PNG$InterlacedPass;", "", "startingRow", "", "startingCol", "rowIncrement", "colIncrement", "blockHeight", "blockWidth", "(IIIIII)V", "getBlockHeight", "()I", "getBlockWidth", "getColIncrement", "colIncrementShift", "getColIncrementShift", "getRowIncrement", "getStartingCol", "getStartingRow", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "", "korge-core"})
    public static final class InterlacedPass {
        private final int startingRow;
        private final int startingCol;
        private final int rowIncrement;
        private final int colIncrement;
        private final int blockHeight;
        private final int blockWidth;
        private final int colIncrementShift;

        public InterlacedPass(int startingRow, int startingCol, int rowIncrement, int colIncrement, int blockHeight, int blockWidth) {
            this.startingRow = startingRow;
            this.startingCol = startingCol;
            this.rowIncrement = rowIncrement;
            this.colIncrement = colIncrement;
            this.blockHeight = blockHeight;
            this.blockWidth = blockWidth;
            this.colIncrementShift = (int)MathKt.log2((double)this.colIncrement);
        }

        public final int getStartingRow() {
            return this.startingRow;
        }

        public final int getStartingCol() {
            return this.startingCol;
        }

        public final int getRowIncrement() {
            return this.rowIncrement;
        }

        public final int getColIncrement() {
            return this.colIncrement;
        }

        public final int getBlockHeight() {
            return this.blockHeight;
        }

        public final int getBlockWidth() {
            return this.blockWidth;
        }

        public final int getColIncrementShift() {
            return this.colIncrementShift;
        }

        public final int component1() {
            return this.startingRow;
        }

        public final int component2() {
            return this.startingCol;
        }

        public final int component3() {
            return this.rowIncrement;
        }

        public final int component4() {
            return this.colIncrement;
        }

        public final int component5() {
            return this.blockHeight;
        }

        public final int component6() {
            return this.blockWidth;
        }

        @NotNull
        public final InterlacedPass copy(int startingRow, int startingCol, int rowIncrement, int colIncrement, int blockHeight, int blockWidth) {
            return new InterlacedPass(startingRow, startingCol, rowIncrement, colIncrement, blockHeight, blockWidth);
        }

        public static /* synthetic */ InterlacedPass copy$default(InterlacedPass interlacedPass, int n, int n2, int n3, int n4, int n5, int n6, int n7, Object object) {
            if ((n7 & 1) != 0) {
                n = interlacedPass.startingRow;
            }
            if ((n7 & 2) != 0) {
                n2 = interlacedPass.startingCol;
            }
            if ((n7 & 4) != 0) {
                n3 = interlacedPass.rowIncrement;
            }
            if ((n7 & 8) != 0) {
                n4 = interlacedPass.colIncrement;
            }
            if ((n7 & 0x10) != 0) {
                n5 = interlacedPass.blockHeight;
            }
            if ((n7 & 0x20) != 0) {
                n6 = interlacedPass.blockWidth;
            }
            return interlacedPass.copy(n, n2, n3, n4, n5, n6);
        }

        @NotNull
        public String toString() {
            return "InterlacedPass(startingRow=" + this.startingRow + ", startingCol=" + this.startingCol + ", rowIncrement=" + this.rowIncrement + ", colIncrement=" + this.colIncrement + ", blockHeight=" + this.blockHeight + ", blockWidth=" + this.blockWidth + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.startingRow);
            result2 = result2 * 31 + Integer.hashCode(this.startingCol);
            result2 = result2 * 31 + Integer.hashCode(this.rowIncrement);
            result2 = result2 * 31 + Integer.hashCode(this.colIncrement);
            result2 = result2 * 31 + Integer.hashCode(this.blockHeight);
            result2 = result2 * 31 + Integer.hashCode(this.blockWidth);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof InterlacedPass)) {
                return false;
            }
            InterlacedPass interlacedPass = (InterlacedPass)other;
            if (this.startingRow != interlacedPass.startingRow) {
                return false;
            }
            if (this.startingCol != interlacedPass.startingCol) {
                return false;
            }
            if (this.rowIncrement != interlacedPass.rowIncrement) {
                return false;
            }
            if (this.colIncrement != interlacedPass.colIncrement) {
                return false;
            }
            if (this.blockHeight != interlacedPass.blockHeight) {
                return false;
            }
            return this.blockWidth == interlacedPass.blockWidth;
        }
    }
}

