/*
 * Decompiled with CFR 0.152.
 */
package korlibs.image.format;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import korlibs.image.bitmap.Bitmap32;
import korlibs.image.color.RGBA;
import korlibs.image.format.ImageData;
import korlibs.image.format.ImageDecodingProps;
import korlibs.image.format.ImageFormat;
import korlibs.image.format.ImageInfo;
import korlibs.io.lang.ExceptionsKt;
import korlibs.io.stream.FastByteArrayInputStream;
import korlibs.io.stream.FastByteArrayInputStreamKt;
import korlibs.io.stream.SyncInputStream;
import korlibs.io.stream.SyncStream;
import korlibs.io.stream.SyncStreamKt;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J+\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0014\u0010\u0014\u001a\u00020\n*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0004H\u0002\u00a8\u0006\u0018"}, d2={"Lkorlibs/image/format/PSD;", "Lkorlibs/image/format/ImageFormat;", "()V", "decodeHeader", "Lkorlibs/image/format/PSD$PsdImageInfo;", "s", "Lkorlibs/io/stream/SyncStream;", "props", "Lkorlibs/image/format/ImageDecodingProps;", "packChannels", "Lkorlibs/image/bitmap/Bitmap32;", "width", "", "height", "channels", "", "", "(II[[B)Lkorlibs/image/bitmap/Bitmap32;", "readImage", "Lkorlibs/image/format/ImageData;", "readImageData", "Lkorlibs/io/stream/FastByteArrayInputStream;", "header", "PsdImageInfo", "korge-core"})
@SourceDebugExtension(value={"SMAP\nPSD.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PSD.kt\nkorlibs/image/format/PSD\n+ 2 Unsigned.kt\nkorlibs/math/UnsignedKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,126:1\n7#2:127\n7#2:128\n7#2:129\n7#2:130\n1549#3:131\n1620#3,3:132\n*S KotlinDebug\n*F\n+ 1 PSD.kt\nkorlibs/image/format/PSD\n*L\n43#1:127\n44#1:128\n45#1:129\n46#1:130\n69#1:131\n69#1:132,3\n*E\n"})
public final class PSD
extends ImageFormat {
    @NotNull
    public static final PSD INSTANCE = new PSD();

    private PSD() {
        String[] stringArray = new String[]{"psd"};
        super(stringArray);
    }

    @Override
    @NotNull
    public ImageData readImage(@NotNull SyncStream s, @NotNull ImageDecodingProps props) {
        SyncStream $this$readImage_u24lambda_u240 = s;
        boolean bl = false;
        PsdImageInfo psdImageInfo = INSTANCE.decodeHeader($this$readImage_u24lambda_u240, props);
        if (psdImageInfo == null) {
            ExceptionsKt.invalidOp("Not a PSD file");
            throw new KotlinNothingValueException();
        }
        PsdImageInfo header = psdImageInfo;
        SyncStream colorMode = SyncStreamKt.readStream($this$readImage_u24lambda_u240, SyncStreamKt.readS32BE($this$readImage_u24lambda_u240));
        SyncStream imageResources = SyncStreamKt.readStream($this$readImage_u24lambda_u240, SyncStreamKt.readS32BE($this$readImage_u24lambda_u240));
        SyncStream layerAndMask = SyncStreamKt.readStream($this$readImage_u24lambda_u240, SyncStreamKt.readS32BE($this$readImage_u24lambda_u240));
        Bitmap32 imageData = INSTANCE.readImageData(FastByteArrayInputStreamKt.openFastStream$default(SyncStreamKt.readAvailable($this$readImage_u24lambda_u240), 0, 1, null), header);
        return ImageData.Companion.invoke(imageData);
    }

    private final Bitmap32 packChannels(int width2, int height2, byte[][] channels) {
        byte[] byArray;
        byte[] bchannel;
        byte[] byArray2;
        byte[] gchannel;
        byte[] byArray3;
        byte[] rchannel;
        int pos = 0;
        Bitmap32 out = new Bitmap32(width2, height2, null, false, 4, null);
        int n = 0;
        int n2 = width2 * height2;
        byte[] byArray4 = new byte[n2];
        while (n < n2) {
            int n3 = n++;
            byArray4[n3] = -1;
        }
        byte[] dummyChannel = byArray4;
        byte[] byArray5 = (byte[])ArraysKt.getOrNull((Object[])channels, 0);
        if (byArray5 == null) {
            byArray5 = rchannel = dummyChannel;
        }
        if ((byArray3 = (byte[])ArraysKt.getOrNull((Object[])channels, 1)) == null) {
            byArray3 = gchannel = dummyChannel;
        }
        if ((byArray2 = (byte[])ArraysKt.getOrNull((Object[])channels, 2)) == null) {
            byArray2 = bchannel = dummyChannel;
        }
        if ((byArray = (byte[])ArraysKt.getOrNull((Object[])channels, 3)) == null) {
            byArray = dummyChannel;
        }
        byte[] achannel = byArray;
        for (int y = 0; y < height2; ++y) {
            for (int x = 0; x < width2; ++x) {
                byte $this$unsigned$iv = rchannel[pos];
                boolean $i$f$getUnsigned = false;
                int r = $this$unsigned$iv & 0xFF;
                byte $this$unsigned$iv2 = gchannel[pos];
                boolean $i$f$getUnsigned2 = false;
                int g = $this$unsigned$iv2 & 0xFF;
                byte $this$unsigned$iv3 = bchannel[pos];
                boolean $i$f$getUnsigned3 = false;
                int b = $this$unsigned$iv3 & 0xFF;
                byte $this$unsigned$iv4 = achannel[pos];
                boolean $i$f$getUnsigned4 = false;
                int a = $this$unsigned$iv4 & 0xFF;
                out.getInts()[pos] = RGBA.Companion.invoke-6bQucaA(r, g, b, a);
                ++pos;
            }
        }
        return out;
    }

    /*
     * WARNING - void declaration
     */
    private final Bitmap32 readImageData(FastByteArrayInputStream $this$readImageData, PsdImageInfo header) {
        int compressionMethod = $this$readImageData.readU16BE();
        int width2 = header.getWidth();
        int height2 = header.getHeight();
        int cchannels = header.getChannels();
        int n = 0;
        byte[][] byArrayArray = new byte[cchannels][];
        while (n < cchannels) {
            int n2 = n++;
            byArrayArray[n2] = new byte[width2 * height2];
        }
        byte[][] channels = byArrayArray;
        switch (compressionMethod) {
            case 0: {
                for (int n3 = 0; n3 < cchannels; ++n3) {
                    channels[n3] = $this$readImageData.readBytes(width2 * height2);
                }
                break;
            }
            case 1: {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = RangesKt.until(0, cchannels);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                Iterator iterator2 = $this$mapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    int item$iv$iv;
                    int n4 = item$iv$iv = ((IntIterator)iterator2).nextInt();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add($this$readImageData.readShortArrayBE(height2));
                }
                List sizes = (List)destination$iv$iv;
                for (int cindex = 0; cindex < cchannels; ++cindex) {
                    byte[] carray = channels[cindex];
                    int cpos = 0;
                    for (short size2 : (short[])sizes.get(cindex)) {
                        int end2 = $this$readImageData.getPosition() + size2;
                        block9: while ($this$readImageData.getPosition() < end2) {
                            int len = $this$readImageData.readU8();
                            if (len >= 128) {
                                int n5 = $this$readImageData.readU8();
                                int j = 0;
                                int n6 = 256 - len;
                                if (j > n6) continue;
                                while (true) {
                                    carray[cpos++] = (byte)n5;
                                    if (j == n6) continue block9;
                                    ++j;
                                }
                            }
                            int j = 0;
                            if (j > len) continue;
                            while (true) {
                                carray[cpos++] = (byte)$this$readImageData.readU8();
                                if (j == len) continue block9;
                                ++j;
                            }
                        }
                    }
                }
                break;
            }
            default: {
                ExceptionsKt.invalidOp("Unsupported compression method " + compressionMethod);
                throw new KotlinNothingValueException();
            }
        }
        return this.packChannels(width2, height2, channels);
    }

    @Override
    @Nullable
    public PsdImageInfo decodeHeader(@NotNull SyncStream s, @NotNull ImageDecodingProps props) {
        PsdImageInfo psdImageInfo;
        SyncStream $this$decodeHeader_u24lambda_u243 = s;
        boolean bl = false;
        if (!Intrinsics.areEqual(SyncStreamKt.readStringz$default((SyncInputStream)$this$decodeHeader_u24lambda_u243, 4, null, 2, null), "8BPS")) {
            return null;
        }
        int version = SyncStreamKt.readU16BE($this$decodeHeader_u24lambda_u243);
        switch (version) {
            case 1: {
                break;
            }
            case 2: {
                return null;
            }
            default: {
                return null;
            }
        }
        byte[] reserved = SyncStreamKt.readBytes($this$decodeHeader_u24lambda_u243, 6);
        int channels = SyncStreamKt.readU16BE($this$decodeHeader_u24lambda_u243);
        int height2 = SyncStreamKt.readS32BE($this$decodeHeader_u24lambda_u243);
        int width2 = SyncStreamKt.readS32BE($this$decodeHeader_u24lambda_u243);
        int bitsPerChannel = SyncStreamKt.readU16BE($this$decodeHeader_u24lambda_u243);
        int colorMode = SyncStreamKt.readU16BE($this$decodeHeader_u24lambda_u243);
        PsdImageInfo $this$decodeHeader_u24lambda_u243_u24lambda_u242 = psdImageInfo = new PsdImageInfo();
        boolean bl2 = false;
        $this$decodeHeader_u24lambda_u243_u24lambda_u242.setWidth(width2);
        $this$decodeHeader_u24lambda_u243_u24lambda_u242.setHeight(height2);
        $this$decodeHeader_u24lambda_u243_u24lambda_u242.setBitsPerPixel(bitsPerChannel * channels);
        $this$decodeHeader_u24lambda_u243_u24lambda_u242.setChannels(channels);
        $this$decodeHeader_u24lambda_u243_u24lambda_u242.setBitsPerChannel(bitsPerChannel);
        $this$decodeHeader_u24lambda_u243_u24lambda_u242.setColorMode(colorMode);
        return psdImageInfo;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0006\"\u0004\b\u000e\u0010\b\u00a8\u0006\u000f"}, d2={"Lkorlibs/image/format/PSD$PsdImageInfo;", "Lkorlibs/image/format/ImageInfo;", "()V", "bitsPerChannel", "", "getBitsPerChannel", "()I", "setBitsPerChannel", "(I)V", "channels", "getChannels", "setChannels", "colorMode", "getColorMode", "setColorMode", "korge-core"})
    public static final class PsdImageInfo
    extends ImageInfo {
        private int channels;
        private int bitsPerChannel;
        private int colorMode;

        public final int getChannels() {
            return this.channels;
        }

        public final void setChannels(int n) {
            this.channels = n;
        }

        public final int getBitsPerChannel() {
            return this.bitsPerChannel;
        }

        public final void setBitsPerChannel(int n) {
            this.bitsPerChannel = n;
        }

        public final int getColorMode() {
            return this.colorMode;
        }

        public final void setColorMode(int n) {
            this.colorMode = n;
        }
    }
}

