/*
 * Decompiled with CFR 0.152.
 */
package korlibs.image.format;

import korlibs.image.bitmap.Bitmap;
import korlibs.image.bitmap.Bitmap32;
import korlibs.image.color.RGBA;
import korlibs.image.color.RgbaArray;
import korlibs.image.format.ImageData;
import korlibs.image.format.ImageDecodingProps;
import korlibs.image.format.ImageEncodingProps;
import korlibs.image.format.ImageFormat;
import korlibs.image.format.ImageInfo;
import korlibs.image.format.ImageInfoKt;
import korlibs.image.format.QOIKt;
import korlibs.io.lang.CharsetKt;
import korlibs.io.stream.SyncInputStream;
import korlibs.io.stream.SyncStream;
import korlibs.io.stream.SyncStreamKt;
import korlibs.memory.ByteArrayGetSetKt;
import korlibs.memory.UByteArrayInt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0018J(\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004H\u0002J\u0010\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004H\u0002J\u000e\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020!J\u0016\u0010\u001f\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0004J\u001a\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J\u0018\u0010*\u001a\u00020+2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J \u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020+2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020/H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u00060"}, d2={"Lkorlibs/image/format/QOI;", "Lkorlibs/image/format/ImageFormat;", "()V", "QOI_HEADER_SIZE", "", "QOI_LINEAR", "QOI_MASK_2", "QOI_OP_RGB", "QOI_OP_RGBA", "QOI_PADDING", "", "getQOI_PADDING", "()[B", "QOI_PADDING_SIZE", "QOI_PIXELS_MAX", "QOI_SOP_DIFF", "QOI_SOP_INDEX", "QOI_SOP_LUMA", "QOI_SOP_RUN", "QOI_SRGB", "QOI_COLOR_HASH", "C", "Lkorlibs/image/color/RGBA;", "QOI_COLOR_HASH-PXL95c4", "(I)I", "r", "g", "b", "a", "QUI_SOP", "op", "calculateMaxSize", "bitmap", "Lkorlibs/image/bitmap/Bitmap;", "width", "height", "decodeHeader", "Lkorlibs/image/format/ImageInfo;", "s", "Lkorlibs/io/stream/SyncStream;", "props", "Lkorlibs/image/format/ImageDecodingProps;", "readImage", "Lkorlibs/image/format/ImageData;", "writeImage", "", "image", "Lkorlibs/image/format/ImageEncodingProps;", "korge-core"})
@SourceDebugExtension(value={"SMAP\nQOI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QOI.kt\nkorlibs/image/format/QOI\n+ 2 Bits.kt\nkorlibs/memory/BitsKt\n*L\n1#1,274:1\n136#2:275\n136#2:276\n136#2:277\n136#2:278\n144#2:279\n140#2:280\n140#2:281\n144#2:282\n*S KotlinDebug\n*F\n+ 1 QOI.kt\nkorlibs/image/format/QOI\n*L\n85#1:275\n95#1:276\n96#1:277\n97#1:278\n102#1:279\n103#1:280\n105#1:281\n109#1:282\n*E\n"})
public final class QOI
extends ImageFormat {
    @NotNull
    public static final QOI INSTANCE = new QOI();
    private static final int QOI_SRGB = 0;
    private static final int QOI_LINEAR = 1;
    private static final int QOI_SOP_INDEX = 0;
    private static final int QOI_SOP_DIFF = 1;
    private static final int QOI_SOP_LUMA = 2;
    private static final int QOI_SOP_RUN = 3;
    private static final int QOI_OP_RGB = 254;
    private static final int QOI_OP_RGBA = 255;
    private static final int QOI_MASK_2 = 192;
    @NotNull
    private static final byte[] QOI_PADDING;
    private static final int QOI_HEADER_SIZE = 14;
    private static final int QOI_PADDING_SIZE = 8;
    private static final int QOI_PIXELS_MAX = 400000000;

    private QOI() {
        String[] stringArray = new String[]{"qoi"};
        super(stringArray);
    }

    @Override
    @Nullable
    public ImageInfo decodeHeader(@NotNull SyncStream s, @NotNull ImageDecodingProps props) {
        if (!Intrinsics.areEqual(SyncStreamKt.readStringz((SyncInputStream)s, 4, CharsetKt.getLATIN1()), "qoif")) {
            return null;
        }
        int width2 = SyncStreamKt.readS32BE(s);
        int height2 = SyncStreamKt.readS32BE(s);
        int channels = SyncStreamKt.readU8(s);
        int colorspace = SyncStreamKt.readU8(s);
        return ImageInfoKt.ImageInfo((Function1<? super ImageInfo, Unit>)new Function1<ImageInfo, Unit>(width2, height2, channels){
            final /* synthetic */ int $width;
            final /* synthetic */ int $height;
            final /* synthetic */ int $channels;
            {
                this.$width = $width;
                this.$height = $height;
                this.$channels = $channels;
                super(1);
            }

            public final void invoke(@NotNull ImageInfo $this$ImageInfo) {
                $this$ImageInfo.setWidth(this.$width);
                $this$ImageInfo.setHeight(this.$height);
                $this$ImageInfo.setBitsPerPixel(this.$channels * 8);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ImageData readImage(@NotNull SyncStream s, @NotNull ImageDecodingProps props) {
        Bitmap32 bitmap32;
        ImageInfo imageInfo = this.decodeHeader(s, props);
        if (imageInfo == null) {
            throw new IllegalStateException("Not a QOI image".toString());
        }
        ImageInfo header = imageInfo;
        byte[] bytes = UByteArrayInt.constructor-impl(SyncStreamKt.readAvailable(s));
        int[] index2 = RgbaArray.Companion.invoke-lrAz6eQ(64);
        Bitmap out = props.getOut();
        if (out != null && out.getWidth() == header.getWidth() && out.getHeight() == header.getHeight() && out instanceof Bitmap32) {
            ((Bitmap32)out).setPremultiplied(false);
            bitmap32 = (Bitmap32)out;
        } else {
            bitmap32 = new Bitmap32(header.getWidth(), header.getHeight(), null, false, 4, null);
        }
        Bitmap32 outBmp = bitmap32;
        int[] outp = RgbaArray.constructor-impl(outBmp.getInts());
        int totalPixels = outBmp.getArea();
        int o = 0;
        int p = 0;
        int r = 0;
        int g = 0;
        int b = 0;
        int a = 255;
        int lastCol = RGBA.Companion.invoke-6bQucaA(0, 0, 0, 255);
        block10: while (o < totalPixels && p < UByteArrayInt.getSize-impl(bytes)) {
            int b1 = UByteArrayInt.get-impl(bytes, p++);
            block0 : switch (b1) {
                case 254: {
                    r = UByteArrayInt.get-impl(bytes, p++);
                    g = UByteArrayInt.get-impl(bytes, p++);
                    b = UByteArrayInt.get-impl(bytes, p++);
                    break;
                }
                case 255: {
                    r = UByteArrayInt.get-impl(bytes, p++);
                    g = UByteArrayInt.get-impl(bytes, p++);
                    b = UByteArrayInt.get-impl(bytes, p++);
                    a = UByteArrayInt.get-impl(bytes, p++);
                    break;
                }
                default: {
                    int $this$extract2$iv;
                    int n = b1;
                    int offset$iv = 6;
                    int $i$f$extract2 = 0;
                    switch ($this$extract2$iv >>> offset$iv & 3) {
                        case 0: {
                            int col = RgbaArray.get-O1c-hRk(index2, b1);
                            r = RGBA.getR-impl(col);
                            g = RGBA.getG-impl(col);
                            b = RGBA.getB-impl(col);
                            a = RGBA.getA-impl(col);
                            break block0;
                        }
                        case 1: {
                            int col = b1;
                            offset$iv = 4;
                            $i$f$extract2 = 0;
                            r = r + (($this$extract2$iv >>> offset$iv & 3) - 2) & 0xFF;
                            $this$extract2$iv = b1;
                            offset$iv = 2;
                            $i$f$extract2 = 0;
                            g = g + (($this$extract2$iv >>> offset$iv & 3) - 2) & 0xFF;
                            $this$extract2$iv = b1;
                            offset$iv = 0;
                            $i$f$extract2 = 0;
                            b = b + (($this$extract2$iv >>> offset$iv & 3) - 2) & 0xFF;
                            break block0;
                        }
                        case 2: {
                            int $this$extract4$iv;
                            int $this$extract6$iv;
                            int b2 = UByteArrayInt.get-impl(bytes, p++);
                            $i$f$extract2 = b1;
                            int offset$iv2 = 0;
                            boolean $i$f$extract6 = false;
                            int vg = ($this$extract6$iv >>> offset$iv2 & 0x3F) - 32;
                            $this$extract6$iv = b2;
                            offset$iv2 = 4;
                            boolean $i$f$extract4 = false;
                            r = r + (vg - 8 + ($this$extract4$iv >>> offset$iv2 & 0xF)) & 0xFF;
                            g = g + vg & 0xFF;
                            $this$extract4$iv = b2;
                            offset$iv2 = 0;
                            $i$f$extract4 = false;
                            b = b + (vg - 8 + ($this$extract4$iv >>> offset$iv2 & 0xF)) & 0xFF;
                            break block0;
                        }
                        case 3: {
                            void $this$extract6$iv;
                            int vg = b1;
                            int offset$iv3 = 0;
                            boolean $i$f$extract6 = false;
                            int np = ($this$extract6$iv >>> offset$iv3 & 0x3F) + 1;
                            for (int n2 = 0; n2 < np; ++n2) {
                                RgbaArray.set-XDoMphA(outp, o++, lastCol);
                            }
                            continue block10;
                        }
                    }
                }
            }
            lastCol = RGBA.Companion.packUnsafe-6bQucaA(r, g, b, a);
            RgbaArray.set-XDoMphA(index2, this.QOI_COLOR_HASH(r, g, b, a) % 64, lastCol);
            RgbaArray.set-XDoMphA(outp, o++, lastCol);
        }
        return ImageData.Companion.invoke(outBmp);
    }

    @Override
    public void writeImage(@NotNull ImageData image2, @NotNull SyncStream s, @NotNull ImageEncodingProps props) {
        byte[] byArray;
        Bitmap32 bitmap = image2.getMainBitmap().toBMP32IfRequired();
        int[] pixels = RgbaArray.constructor-impl(bitmap.getInts());
        int[] index2 = RgbaArray.Companion.invoke-lrAz6eQ(64);
        int maxSize = this.calculateMaxSize(bitmap);
        if (QOIKt.getPreAllocatedArrayForQOI(props) == null) {
            byArray = UByteArrayInt.constructor-impl(maxSize);
        } else {
            byte[] byArray2 = QOIKt.getPreAllocatedArrayForQOI(props);
            Intrinsics.checkNotNull(byArray2);
            if (!(UByteArrayInt.getSize-impl(byArray2) >= maxSize)) {
                boolean $i$a$-require-QOI$writeImage$bytes$22 = false;
                byte[] byArray3 = QOIKt.getPreAllocatedArrayForQOI(props);
                Intrinsics.checkNotNull(byArray3);
                String $i$a$-require-QOI$writeImage$bytes$22 = StringsKt.trimIndent("\n                   Requires a pre-allocated array of at least " + maxSize + " bytes.\n                   You provided a pre-allocated array with " + UByteArrayInt.getSize-impl(byArray3) + " bytes.\n                ");
                throw new IllegalArgumentException($i$a$-require-QOI$writeImage$bytes$22.toString());
            }
            byte[] byArray4 = QOIKt.getPreAllocatedArrayForQOI(props);
            byArray = byArray4;
            Intrinsics.checkNotNull(byArray4);
        }
        byte[] bytes = byArray;
        byte[] sbytes = UByteArrayInt.getBytes-impl(bytes);
        int currentIndex = 0;
        int bytesUsed = 0;
        UByteArrayInt.set-impl(bytes, bytesUsed++, 113);
        UByteArrayInt.set-impl(bytes, bytesUsed++, 111);
        UByteArrayInt.set-impl(bytes, bytesUsed++, 105);
        UByteArrayInt.set-impl(bytes, bytesUsed++, 102);
        ByteArrayGetSetKt.set32BE(sbytes, bytesUsed, bitmap.getWidth());
        ByteArrayGetSetKt.set32BE(sbytes, bytesUsed += 4, bitmap.getHeight());
        bytesUsed += 4;
        UByteArrayInt.set-impl(bytes, bytesUsed++, 4);
        UByteArrayInt.set-impl(bytes, bytesUsed++, 1);
        int previousPixel = RGBA.Companion.invoke-6bQucaA(0, 0, 0, 255);
        int previousR = 0;
        int previousG = 0;
        int previousB = 0;
        int previousA = 255;
        int run = 0;
        while (currentIndex < RgbaArray.getSize-impl(pixels)) {
            int currentPixel = RgbaArray.get-O1c-hRk(pixels, currentIndex++);
            int currentR = RGBA.getR-impl(currentPixel);
            int currentG = RGBA.getG-impl(currentPixel);
            int currentB = RGBA.getB-impl(currentPixel);
            int currentA = RGBA.getA-impl(currentPixel);
            if (RGBA.equals-impl0(currentPixel, previousPixel)) {
                if (++run == 62 || currentIndex >= RgbaArray.getSize-impl(pixels)) {
                    UByteArrayInt.set-impl(bytes, bytesUsed++, this.QUI_SOP(3) | run - 1);
                    run = 0;
                }
            } else {
                int index_pos;
                if (run > 0) {
                    UByteArrayInt.set-impl(bytes, bytesUsed++, this.QUI_SOP(3) | run - 1);
                    run = 0;
                }
                if (RGBA.equals-impl0(RgbaArray.get-O1c-hRk(index2, index_pos = this.QOI_COLOR_HASH(currentR, currentG, currentB, currentA) % 64), currentPixel)) {
                    UByteArrayInt.set-impl(bytes, bytesUsed++, this.QUI_SOP(0) | index_pos);
                } else {
                    RgbaArray.set-XDoMphA(index2, index_pos, currentPixel);
                    if (currentA == previousA) {
                        int vr = currentR - previousR;
                        int vg = currentG - previousG;
                        int vb = currentB - previousB;
                        int vg_r = vr - vg;
                        int vg_b = vb - vg;
                        if (vr > -3 && vr < 2 && vg > -3 && vg < 2 && vb > -3 && vb < 2) {
                            UByteArrayInt.set-impl(bytes, bytesUsed++, this.QUI_SOP(1) | vr + 2 << 4 | vg + 2 << 2 | vb + 2);
                        } else if (vg_r > -9 && vg_r < 8 && vg > -33 && vg < 32 && vg_b > -9 && vg_b < 8) {
                            UByteArrayInt.set-impl(bytes, bytesUsed++, this.QUI_SOP(2) | vg + 32);
                            UByteArrayInt.set-impl(bytes, bytesUsed++, vg_r + 8 << 4 | vg_b + 8);
                        } else {
                            UByteArrayInt.set-impl(bytes, bytesUsed++, 254);
                            UByteArrayInt.set-impl(bytes, bytesUsed++, currentR);
                            UByteArrayInt.set-impl(bytes, bytesUsed++, currentG);
                            UByteArrayInt.set-impl(bytes, bytesUsed++, currentB);
                        }
                    } else {
                        UByteArrayInt.set-impl(bytes, bytesUsed++, 255);
                        UByteArrayInt.set-impl(bytes, bytesUsed++, currentR);
                        UByteArrayInt.set-impl(bytes, bytesUsed++, currentG);
                        UByteArrayInt.set-impl(bytes, bytesUsed++, currentB);
                        UByteArrayInt.set-impl(bytes, bytesUsed++, currentA);
                    }
                }
            }
            previousPixel = currentPixel;
            previousR = currentR;
            previousG = currentG;
            previousB = currentB;
            previousA = currentA;
        }
        for (byte sbytes[bytesUsed++] : QOI_PADDING) {
        }
        SyncStreamKt.writeBytes(s, sbytes, 0, bytesUsed);
    }

    public final int calculateMaxSize(@NotNull Bitmap bitmap) {
        return this.calculateMaxSize(bitmap.getWidth(), bitmap.getHeight());
    }

    public final int calculateMaxSize(int width2, int height2) {
        return 14 + width2 * height2 * 5 + 8;
    }

    private final int QUI_SOP(int op) {
        return op << 6;
    }

    private final int QOI_COLOR_HASH(int r, int g, int b, int a) {
        return r * 3 + g * 5 + b * 7 + a * 11;
    }

    private final int QOI_COLOR_HASH-PXL95c4(int C) {
        return this.QOI_COLOR_HASH(RGBA.getR-impl(C), RGBA.getG-impl(C), RGBA.getB-impl(C), RGBA.getA-impl(C));
    }

    @NotNull
    public final byte[] getQOI_PADDING() {
        return QOI_PADDING;
    }

    static {
        byte[] byArray = new byte[]{0, 0, 0, 0, 0, 0, 0, 1};
        QOI_PADDING = byArray;
    }
}

