/*
 * Decompiled with CFR 0.152.
 */
package korlibs.image.format;

import korlibs.image.bitmap.Bitmap;
import korlibs.image.bitmap.Bitmap32;
import korlibs.image.bitmap.Bitmap8;
import korlibs.image.color.BGR;
import korlibs.image.color.BGRA;
import korlibs.image.color.ColorFormat;
import korlibs.image.color.RGBA;
import korlibs.image.format.ImageData;
import korlibs.image.format.ImageDecodingProps;
import korlibs.image.format.ImageEncodingProps;
import korlibs.image.format.ImageFormat;
import korlibs.image.format.ImageInfo;
import korlibs.io.stream.SyncStream;
import korlibs.io.stream.SyncStreamKt;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Result;
import kotlin.ResultKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0010H\u0016\u00a8\u0006\u0012"}, d2={"Lkorlibs/image/format/TGA;", "Lkorlibs/image/format/ImageFormat;", "()V", "decodeHeader", "Lkorlibs/image/format/ImageInfo;", "s", "Lkorlibs/io/stream/SyncStream;", "props", "Lkorlibs/image/format/ImageDecodingProps;", "readHeader", "Lkorlibs/image/format/TGA$Info;", "readImage", "Lkorlibs/image/format/ImageData;", "writeImage", "", "image", "Lkorlibs/image/format/ImageEncodingProps;", "Info", "korge-core"})
public final class TGA
extends ImageFormat {
    @NotNull
    public static final TGA INSTANCE = new TGA();

    private TGA() {
        String[] stringArray = new String[]{"tga"};
        super(stringArray);
    }

    @Override
    @Nullable
    public ImageInfo decodeHeader(@NotNull SyncStream s, @NotNull ImageDecodingProps props) {
        Object object;
        try {
            ImageInfo imageInfo;
            boolean bl = false;
            ImageInfo $this$decodeHeader_u24lambda_u241_u24lambda_u240 = imageInfo = new ImageInfo();
            boolean bl2 = false;
            Info h = INSTANCE.readHeader(s);
            $this$decodeHeader_u24lambda_u241_u24lambda_u240.setWidth(h.getWidth());
            $this$decodeHeader_u24lambda_u241_u24lambda_u240.setHeight(h.getHeight());
            $this$decodeHeader_u24lambda_u241_u24lambda_u240.setBitsPerPixel(h.getBitsPerPixel());
            object = Result.constructor-impl(imageInfo);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl(ResultKt.createFailure(throwable));
        }
        return (ImageInfo)(Result.isFailure-impl(object) ? null : object);
    }

    @NotNull
    public final Info readHeader(@NotNull SyncStream s) {
        int idLength = SyncStreamKt.readU8(s);
        int colorMapType = SyncStreamKt.readU8(s);
        switch (colorMapType) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalStateException("Not a TGA. Unsupported colorMapType".toString());
            }
        }
        int imageType = SyncStreamKt.readU8(s);
        switch (imageType) {
            case 1: {
                String string = "Unsupported indexed";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
            case 2: {
                break;
            }
            case 9: 
            case 10: {
                String string = "Unsupported RLE";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
            default: {
                String string = "Unknown TGA";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
        }
        int firstIndexEntry = SyncStreamKt.readU16LE(s);
        int colorMapLength = SyncStreamKt.readU16LE(s);
        int colorMapEntrySize = SyncStreamKt.readU8(s);
        s.setPosition(s.getPosition() + (long)(colorMapLength * colorMapEntrySize));
        int xorig = SyncStreamKt.readS16LE(s);
        int yorig = SyncStreamKt.readS16LE(s);
        int width2 = SyncStreamKt.readS16LE(s);
        int height2 = SyncStreamKt.readS16LE(s);
        int pixelDepth = SyncStreamKt.readU8(s);
        switch (pixelDepth) {
            case 24: 
            case 32: {
                break;
            }
            default: {
                String string = "Not a RGBA tga";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
        }
        if (width2 < 0 || height2 < 0) {
            throw new IllegalStateException("Not a TGA. Invalid width/height".toString());
        }
        int imageDescriptor = SyncStreamKt.readU8(s);
        boolean flipY = (imageDescriptor >>> 5 & 1) == 0;
        int storage2 = imageDescriptor >>> 6 & 3;
        SyncStreamKt.readBytes(s, idLength);
        return new Info(width2, height2, flipY, pixelDepth);
    }

    @Override
    @NotNull
    public ImageData readImage(@NotNull SyncStream s, @NotNull ImageDecodingProps props) {
        ColorFormat colorFormat;
        Info info2 = this.readHeader(s);
        switch (info2.getBitsPerPixel()) {
            case 24: {
                colorFormat = BGR.INSTANCE;
                break;
            }
            case 32: {
                colorFormat = BGRA.INSTANCE;
                break;
            }
            default: {
                String string = "Not a RGB/RGBA tga";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
        }
        ColorFormat format2 = colorFormat;
        Bitmap32 out = Bitmap32.writeDecoded$default(new Bitmap32(info2.getWidth(), info2.getHeight(), null, false, 4, null), format2, SyncStreamKt.readBytes(s, info2.getArea() * info2.getBytes()), 0, false, 12, null);
        if (info2.getFlipY()) {
            out.flipY();
        }
        return ImageData.Companion.invoke(out);
    }

    @Override
    public void writeImage(@NotNull ImageData image2, @NotNull SyncStream s, @NotNull ImageEncodingProps props) {
        Bitmap bitmap = image2.getMainBitmap();
        if (bitmap instanceof Bitmap8) {
            String string = "Not implemented encoding TGA Bitmap8";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }
        Bitmap32 bmp2 = bitmap.toBMP32();
        byte[] data2 = new byte[bmp2.getArea() * 4];
        int m = 0;
        for (int cc : bmp2.getInts()) {
            int c = RGBA.constructor-impl(cc);
            data2[m++] = (byte)RGBA.getB-impl(c);
            data2[m++] = (byte)RGBA.getG-impl(c);
            data2[m++] = (byte)RGBA.getR-impl(c);
            data2[m++] = (byte)RGBA.getA-impl(c);
        }
        SyncStreamKt.write8(s, 0);
        SyncStreamKt.write8(s, 0);
        SyncStreamKt.write8(s, 2);
        SyncStreamKt.write16LE(s, 0);
        SyncStreamKt.write16LE(s, 0);
        SyncStreamKt.write8(s, 0);
        SyncStreamKt.write16LE(s, 0);
        SyncStreamKt.write16LE(s, 0);
        SyncStreamKt.write16LE(s, bmp2.getWidth());
        SyncStreamKt.write16LE(s, bmp2.getHeight());
        SyncStreamKt.write8(s, 32);
        SyncStreamKt.write8(s, 32);
        SyncStreamKt.writeBytes(s, data2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lkorlibs/image/format/TGA$Info;", "", "width", "", "height", "flipY", "", "bitsPerPixel", "(IIZI)V", "area", "getArea", "()I", "getBitsPerPixel", "bytes", "getBytes", "getFlipY", "()Z", "getHeight", "getWidth", "korge-core"})
    public static final class Info {
        private final int width;
        private final int height;
        private final boolean flipY;
        private final int bitsPerPixel;
        private final int area;
        private final int bytes;

        public Info(int width2, int height2, boolean flipY, int bitsPerPixel) {
            this.width = width2;
            this.height = height2;
            this.flipY = flipY;
            this.bitsPerPixel = bitsPerPixel;
            this.area = this.width * this.height;
            this.bytes = this.bitsPerPixel / 8;
        }

        public final int getWidth() {
            return this.width;
        }

        public final int getHeight() {
            return this.height;
        }

        public final boolean getFlipY() {
            return this.flipY;
        }

        public final int getBitsPerPixel() {
            return this.bitsPerPixel;
        }

        public final int getArea() {
            return this.area;
        }

        public final int getBytes() {
            return this.bytes;
        }
    }
}

