/*
 * Decompiled with CFR 0.152.
 */
package korlibs.image.format;

import korlibs.image.bitmap.Bitmap32;
import korlibs.image.format.ImageData;
import korlibs.image.format.ImageDecodingProps;
import korlibs.image.format.ImageFormat;
import korlibs.image.format.ImageInfo;
import korlibs.image.format.ImageInfoKt;
import korlibs.image.format.WebpWASM;
import korlibs.io.stream.SyncStream;
import korlibs.io.stream.SyncStreamKt;
import korlibs.math.geom.SizeInt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u0000H\u0086B\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lkorlibs/image/format/WEBP;", "Lkorlibs/image/format/ImageFormat;", "()V", "WebpWASM", "Lkorlibs/image/format/WebpWASM;", "decodeHeader", "Lkorlibs/image/format/ImageInfo;", "s", "Lkorlibs/io/stream/SyncStream;", "props", "Lkorlibs/image/format/ImageDecodingProps;", "initOnce", "context", "Lkotlin/coroutines/CoroutineContext;", "invoke", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "readImage", "Lkorlibs/image/format/ImageData;", "korge-core"})
public final class WEBP
extends ImageFormat {
    @NotNull
    public static final WEBP INSTANCE = new WEBP();
    @NotNull
    private static final WebpWASM WebpWASM = new WebpWASM();

    private WEBP() {
        String[] stringArray = new String[]{"webp"};
        super(stringArray);
    }

    @Nullable
    public final Object invoke(@NotNull Continuation<? super WEBP> $completion) {
        return this.initOnce($completion.getContext());
    }

    @NotNull
    public final WEBP initOnce(@NotNull CoroutineContext context2) {
        WebpWASM.initOnce(context2);
        return this;
    }

    @Override
    @NotNull
    public ImageData readImage(@NotNull SyncStream s, @NotNull ImageDecodingProps props) {
        Bitmap32 bitmap32 = WebpWASM.decodeWebpBytes(SyncStreamKt.readAll(s));
        if (bitmap32 == null) {
            throw new IllegalStateException("Not a WEBP".toString());
        }
        return ImageData.Companion.invoke(bitmap32);
    }

    @Override
    @Nullable
    public ImageInfo decodeHeader(@NotNull SyncStream s, @NotNull ImageDecodingProps props) {
        SizeInt sizeInt = WebpWASM.getInfo(SyncStreamKt.readBytes(s, 64));
        if (sizeInt == null) {
            return null;
        }
        SizeInt size2 = sizeInt;
        return ImageInfoKt.ImageInfo((Function1<? super ImageInfo, Unit>)new Function1<ImageInfo, Unit>(size2){
            final /* synthetic */ SizeInt $size;
            {
                this.$size = $size;
                super(1);
            }

            public final void invoke(@NotNull ImageInfo $this$ImageInfo) {
                $this$ImageInfo.setWidth(this.$size.getWidth());
                $this$ImageInfo.setHeight(this.$size.getHeight());
            }
        });
    }
}

