/*
 * Decompiled with CFR 0.152.
 */
package korlibs.image.format.provider;

import com.sun.jna.Pointer;
import korlibs.ffi.FFIFuncConfig;
import korlibs.ffi.FFILib;
import korlibs.ffi.FFILib_jvmKt;
import korlibs.image.bitmap.Bitmap32;
import korlibs.image.format.BaseNativeImageFormatProvider;
import korlibs.image.format.BitmapNativeImage;
import korlibs.image.format.ImageDataContainer;
import korlibs.image.format.ImageDecodingProps;
import korlibs.image.format.ImageEncodingProps;
import korlibs.image.format.ImageFormat;
import korlibs.image.format.ImageInfo;
import korlibs.image.format.ImageInfoKt;
import korlibs.image.format.NativeImageResult;
import korlibs.image.format.RegisteredImageFormatsKt;
import korlibs.math.geom.SizeInt;
import korlibs.platform.Platform;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.functions.Function6;
import kotlin.jvm.functions.Function7;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.reflect.KTypeProjection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0015\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003+,-B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0002J\u0018\u0010\u000e\u001a\n\u0018\u00010\u000fj\u0004\u0018\u0001`\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0094@\u00a2\u0006\u0002\u0010\u0017J\u001e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0094@\u00a2\u0006\u0002\u0010\u001cJ\u001e\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020 H\u0096@\u00a2\u0006\u0002\u0010!J\u001c\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020%0#2\u0006\u0010&\u001a\u00020\u0016H\u0002J\u0010\u0010'\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0016H\u0002J \u0010(\u001a\u00020)2\u000e\u0010\u001a\u001a\n\u0018\u00010\u000fj\u0004\u0018\u0001`\u00102\u0006\u0010*\u001a\u00020\u0012H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006."}, d2={"Lkorlibs/image/format/provider/FFICoreGraphicsImageFormatProvider;", "Lkorlibs/image/format/BaseNativeImageFormatProvider;", "()V", "formats", "Lkorlibs/image/format/ImageFormat;", "getFormats", "()Lkorlibs/image/format/ImageFormat;", "CGRectMake", "", "x", "", "y", "width", "height", "createCFString", "Lcom/sun/jna/Pointer;", "Lkorlibs/ffi/FFIPointer;", "str", "", "decodeHeaderInternal", "Lkorlibs/image/format/ImageInfo;", "data", "", "([BLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "decodeInternal", "Lkorlibs/image/format/NativeImageResult;", "props", "Lkorlibs/image/format/ImageDecodingProps;", "([BLkorlibs/image/format/ImageDecodingProps;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "encodeSuspend", "image", "Lkorlibs/image/format/ImageDataContainer;", "Lkorlibs/image/format/ImageEncodingProps;", "(Lkorlibs/image/format/ImageDataContainer;Lkorlibs/image/format/ImageEncodingProps;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getImageData", "Lkotlin/Pair;", "", "Lkorlibs/math/geom/SizeInt;", "bytes", "getImageSize", "getIntFromDict", "", "key", "CoreFoundation", "CoreGraphics", "ImageIO", "korge-core"})
@SourceDebugExtension(value={"SMAP\nFFICoreGraphicsImageFormatProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FFICoreGraphicsImageFormatProvider.kt\nkorlibs/image/format/provider/FFICoreGraphicsImageFormatProvider\n+ 2 NonJs.kt\nkorlibs/datastructure/NonJsKt\n*L\n1#1,144:1\n6#2:145\n6#2:146\n*S KotlinDebug\n*F\n+ 1 FFICoreGraphicsImageFormatProvider.kt\nkorlibs/image/format/provider/FFICoreGraphicsImageFormatProvider\n*L\n120#1:145\n121#1:146\n*E\n"})
public final class FFICoreGraphicsImageFormatProvider
extends BaseNativeImageFormatProvider {
    @NotNull
    public static final FFICoreGraphicsImageFormatProvider INSTANCE = new FFICoreGraphicsImageFormatProvider();

    private FFICoreGraphicsImageFormatProvider() {
    }

    @Override
    @NotNull
    public ImageFormat getFormats() {
        return RegisteredImageFormatsKt.getRegisteredImageFormats();
    }

    @Override
    @Nullable
    public Object encodeSuspend(@NotNull ImageDataContainer image2, @NotNull ImageEncodingProps props, @NotNull Continuation<? super byte[]> $completion) {
        return ImageFormat.encode$default((ImageFormat)CollectionsKt.first((Iterable)RegisteredImageFormatsKt.getRegisteredImageFormats().getFormats()), image2.getDefault(), null, 2, null);
    }

    @Override
    @Nullable
    protected Object decodeHeaderInternal(@NotNull byte[] data2, @NotNull Continuation<? super ImageInfo> $completion) {
        if (Platform.Companion.isMac()) {
            SizeInt size2 = this.getImageSize(data2);
            return ImageInfoKt.ImageInfo((Function1<? super ImageInfo, Unit>)new Function1<ImageInfo, Unit>(size2){
                final /* synthetic */ SizeInt $size;
                {
                    this.$size = $size;
                    super(1);
                }

                public final void invoke(@NotNull ImageInfo $this$ImageInfo) {
                    $this$ImageInfo.setWidth(this.$size.getWidth());
                    $this$ImageInfo.setHeight(this.$size.getHeight());
                }
            });
        }
        throw new IllegalStateException(("Unsupported platform decodeHeaderInternal '" + Platform.Companion.getOs() + "'").toString());
    }

    @Override
    @Nullable
    protected Object decodeInternal(@NotNull byte[] data2, @NotNull ImageDecodingProps props, @NotNull Continuation<? super NativeImageResult> $completion) {
        if (Platform.Companion.isMac()) {
            Pair<int[], SizeInt> pair = this.getImageData(data2);
            int[] data3 = pair.component1();
            SizeInt size2 = pair.component2();
            return new NativeImageResult(new BitmapNativeImage(new Bitmap32(size2.getWidth(), size2.getHeight(), data3, false, 8, null)), 0, 0, 6, null);
        }
        throw new IllegalStateException(("Unsupported platform decodeInternal '" + Platform.Companion.getOs() + "'").toString());
    }

    private final int getIntFromDict(Pointer props, String key) {
        int kCFNumberIntType = 9;
        int[] buffer = new int[2];
        Pointer keyPtr = this.createCFString(key);
        CoreFoundation.INSTANCE.getCFNumberGetValue().invoke(CoreFoundation.INSTANCE.getCFDictionaryGetValue().invoke(props, keyPtr), kCFNumberIntType, buffer);
        CoreFoundation.INSTANCE.getCFRelease().invoke(keyPtr);
        return buffer[0];
    }

    private final Pointer createCFString(String str) {
        int NSUTF8StringEncoding = 4;
        byte[] bytes = StringsKt.encodeToByteArray(str);
        return CoreFoundation.INSTANCE.getCFStringCreateWithBytes().invoke(null, bytes, bytes.length, NSUTF8StringEncoding, false);
    }

    private final SizeInt getImageSize(byte[] bytes) {
        Pointer data2 = CoreFoundation.INSTANCE.getCFDataCreate().invoke(null, bytes, bytes.length);
        Pointer imgSource = ImageIO.INSTANCE.getCGImageSourceCreateWithData().invoke(data2, null);
        Pointer props = ImageIO.INSTANCE.getCGImageSourceCopyPropertiesAtIndex().invoke(imgSource, 0, null);
        int width2 = this.getIntFromDict(props, "PixelWidth");
        int height2 = this.getIntFromDict(props, "PixelHeight");
        CoreFoundation.INSTANCE.getCFRelease().invoke(props);
        CoreFoundation.INSTANCE.getCFRelease().invoke(imgSource);
        CoreFoundation.INSTANCE.getCFRelease().invoke(data2);
        return new SizeInt(width2, height2);
    }

    private final double[] CGRectMake(double x, double y, double width2, double height2) {
        double[] dArray = new double[]{x, y, width2, height2};
        return dArray;
    }

    private final Pair<int[], SizeInt> getImageData(byte[] bytes) {
        boolean premultiplied = true;
        Pointer data2 = CoreFoundation.INSTANCE.getCFDataCreate().invoke(null, bytes, bytes.length);
        Pointer imgSource = ImageIO.INSTANCE.getCGImageSourceCreateWithData().invoke(data2, null);
        Object dict = null;
        Pointer cgImage = ImageIO.INSTANCE.getCGImageSourceCreateImageAtIndex().invoke(imgSource, 0, (Pointer)dict);
        Integer $this$fastCastTo$iv = CoreGraphics.INSTANCE.getCGImageGetWidth().invoke(cgImage);
        boolean $i$f$fastCastTo = false;
        int width2 = (int)((Number)$this$fastCastTo$iv).doubleValue();
        Integer $this$fastCastTo$iv2 = CoreGraphics.INSTANCE.getCGImageGetHeight().invoke(cgImage);
        boolean $i$f$fastCastTo2 = false;
        int height2 = (int)((Number)$this$fastCastTo$iv2).doubleValue();
        Pointer colorSpace = CoreGraphics.INSTANCE.getCGColorSpaceCreateDeviceRGB().invoke();
        int alphaInfo = 1;
        Pointer context2 = CoreGraphics.INSTANCE.getCGBitmapContextCreate().invoke(null, width2, height2, 8, width2 * 4, colorSpace, alphaInfo);
        double[] rect = this.CGRectMake(0.0, 0.0, width2, height2);
        CoreGraphics.INSTANCE.getCGContextDrawImage().invoke(context2, rect[0], rect[1], rect[2], rect[3], cgImage);
        CoreGraphics.INSTANCE.getCGContextFlush().invoke(context2);
        Pointer pointer = CoreGraphics.INSTANCE.getCGBitmapContextGetData().invoke(context2);
        Intrinsics.checkNotNull(pointer);
        int[] pixels = FFILib_jvmKt.getIntArray$default(pointer, width2 * height2, 0, 2, null);
        CoreGraphics.INSTANCE.getCGImageRelease().invoke(cgImage);
        CoreGraphics.INSTANCE.getCGContextRelease().invoke(context2);
        CoreFoundation.INSTANCE.getCFRelease().invoke(imgSource);
        CoreFoundation.INSTANCE.getCFRelease().invoke(data2);
        CoreGraphics.INSTANCE.getCGColorSpaceRelease().invoke(colorSpace);
        return TuplesKt.to(pixels, new SizeInt(width2, height2));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002RC\u0010\u0003\u001a*\u0012\f\u0012\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\f\u0012\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u00060\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR7\u0010\r\u001a\u001e\u0012\f\u0012\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\u0012\f\u0012\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u00060\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\f\u001a\u0004\b\u000f\u0010\u0010R/\u0010\u0012\u001a\u0016\u0012\f\u0012\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\u0012\u0004\u0012\u00020\b0\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\f\u001a\u0004\b\u0013\u0010\u0010RE\u0010\u0015\u001a,\u0012\f\u0012\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\u0012\f\u0012\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\u0012\f\u0012\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u00060\u00168FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\f\u001a\u0004\b\u0017\u0010\u0018R;\u0010\u001a\u001a\"\u0012\f\u0012\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\f\u001a\u0004\b\u001d\u0010\nR/\u0010\u001f\u001a\u0016\u0012\f\u0012\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\u0012\u0004\u0012\u00020 0\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\f\u001a\u0004\b!\u0010\u0010RO\u0010#\u001a6\u0012\f\u0012\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001c\u0012\f\u0012\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u00060$8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010\f\u001a\u0004\b%\u0010&\u00a8\u0006("}, d2={"Lkorlibs/image/format/provider/FFICoreGraphicsImageFormatProvider$CoreFoundation;", "Lkorlibs/ffi/FFILib;", "()V", "CFDataCreate", "Lkotlin/Function3;", "Lcom/sun/jna/Pointer;", "Lkorlibs/ffi/FFIPointer;", "", "", "getCFDataCreate", "()Lkotlin/jvm/functions/Function3;", "CFDataCreate$delegate", "Lkotlin/properties/ReadOnlyProperty;", "CFDataGetBytePtr", "Lkotlin/Function1;", "getCFDataGetBytePtr", "()Lkotlin/jvm/functions/Function1;", "CFDataGetBytePtr$delegate", "CFDataGetLength", "getCFDataGetLength", "CFDataGetLength$delegate", "CFDictionaryGetValue", "Lkotlin/Function2;", "getCFDictionaryGetValue", "()Lkotlin/jvm/functions/Function2;", "CFDictionaryGetValue$delegate", "CFNumberGetValue", "", "", "getCFNumberGetValue", "CFNumberGetValue$delegate", "CFRelease", "", "getCFRelease", "CFRelease$delegate", "CFStringCreateWithBytes", "Lkotlin/Function5;", "getCFStringCreateWithBytes", "()Lkotlin/jvm/functions/Function5;", "CFStringCreateWithBytes$delegate", "korge-core"})
    @SourceDebugExtension(value={"SMAP\nFFICoreGraphicsImageFormatProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FFICoreGraphicsImageFormatProvider.kt\nkorlibs/image/format/provider/FFICoreGraphicsImageFormatProvider$CoreFoundation\n+ 2 FFILib.kt\nkorlibs/ffi/FFILib\n*L\n1#1,144:1\n234#2:145\n234#2:146\n234#2:147\n234#2:148\n234#2:149\n234#2:150\n234#2:151\n*S KotlinDebug\n*F\n+ 1 FFICoreGraphicsImageFormatProvider.kt\nkorlibs/image/format/provider/FFICoreGraphicsImageFormatProvider$CoreFoundation\n*L\n51#1:145\n52#1:146\n53#1:147\n54#1:148\n55#1:149\n56#1:150\n58#1:151\n*E\n"})
    private static final class CoreFoundation
    extends FFILib {
        @NotNull
        public static final CoreFoundation INSTANCE;
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private static final ReadOnlyProperty CFDataCreate$delegate;
        @NotNull
        private static final ReadOnlyProperty CFStringCreateWithBytes$delegate;
        @NotNull
        private static final ReadOnlyProperty CFDictionaryGetValue$delegate;
        @NotNull
        private static final ReadOnlyProperty CFNumberGetValue$delegate;
        @NotNull
        private static final ReadOnlyProperty CFDataGetBytePtr$delegate;
        @NotNull
        private static final ReadOnlyProperty CFDataGetLength$delegate;
        @NotNull
        private static final ReadOnlyProperty CFRelease$delegate;

        private CoreFoundation() {
            String[] stringArray = new String[]{"CoreFoundation"};
            super(stringArray, false, 2, null);
        }

        @NotNull
        public final Function3<Pointer, byte[], Integer, Pointer> getCFDataCreate() {
            return (Function3)CFDataCreate$delegate.getValue(this, $$delegatedProperties[0]);
        }

        @NotNull
        public final Function5<Pointer, byte[], Integer, Integer, Boolean, Pointer> getCFStringCreateWithBytes() {
            return (Function5)CFStringCreateWithBytes$delegate.getValue(this, $$delegatedProperties[1]);
        }

        @NotNull
        public final Function2<Pointer, Pointer, Pointer> getCFDictionaryGetValue() {
            return (Function2)CFDictionaryGetValue$delegate.getValue(this, $$delegatedProperties[2]);
        }

        @NotNull
        public final Function3<Pointer, Integer, int[], Boolean> getCFNumberGetValue() {
            return (Function3)CFNumberGetValue$delegate.getValue(this, $$delegatedProperties[3]);
        }

        @NotNull
        public final Function1<Pointer, Pointer> getCFDataGetBytePtr() {
            return (Function1)CFDataGetBytePtr$delegate.getValue(this, $$delegatedProperties[4]);
        }

        @NotNull
        public final Function1<Pointer, Integer> getCFDataGetLength() {
            return (Function1)CFDataGetLength$delegate.getValue(this, $$delegatedProperties[5]);
        }

        @NotNull
        public final Function1<Pointer, Unit> getCFRelease() {
            return (Function1)CFRelease$delegate.getValue(this, $$delegatedProperties[6]);
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(CoreFoundation.class, "CFDataCreate", "getCFDataCreate()Lkotlin/jvm/functions/Function3;", 0)), Reflection.property1(new PropertyReference1Impl(CoreFoundation.class, "CFStringCreateWithBytes", "getCFStringCreateWithBytes()Lkotlin/jvm/functions/Function5;", 0)), Reflection.property1(new PropertyReference1Impl(CoreFoundation.class, "CFDictionaryGetValue", "getCFDictionaryGetValue()Lkotlin/jvm/functions/Function2;", 0)), Reflection.property1(new PropertyReference1Impl(CoreFoundation.class, "CFNumberGetValue", "getCFNumberGetValue()Lkotlin/jvm/functions/Function3;", 0)), Reflection.property1(new PropertyReference1Impl(CoreFoundation.class, "CFDataGetBytePtr", "getCFDataGetBytePtr()Lkotlin/jvm/functions/Function1;", 0)), Reflection.property1(new PropertyReference1Impl(CoreFoundation.class, "CFDataGetLength", "getCFDataGetLength()Lkotlin/jvm/functions/Function1;", 0)), Reflection.property1(new PropertyReference1Impl(CoreFoundation.class, "CFRelease", "getCFRelease()Lkotlin/jvm/functions/Function1;", 0))};
            $$delegatedProperties = kPropertyArray;
            INSTANCE = new CoreFoundation();
            FFILib $this$iv = INSTANCE;
            String name$iv = null;
            FFIFuncConfig config$iv = FFIFuncConfig.Companion.getDEFAULT();
            boolean required$iv = true;
            boolean $i$f$func = false;
            CFDataCreate$delegate = new FFILib.FuncInfo(Reflection.typeOf(Function3.class, KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.typeOf(byte[].class)), KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE)), KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class))), name$iv, config$iv, required$iv).provideDelegate(INSTANCE, $$delegatedProperties[0]);
            $this$iv = INSTANCE;
            name$iv = null;
            config$iv = FFIFuncConfig.Companion.getDEFAULT();
            required$iv = true;
            $i$f$func = false;
            CFStringCreateWithBytes$delegate = new FFILib.FuncInfo(Reflection.typeOf(Function5.class, KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.typeOf(byte[].class)), KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE)), KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE)), KTypeProjection.Companion.invariant(Reflection.typeOf(Boolean.TYPE)), KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class))), name$iv, config$iv, required$iv).provideDelegate(INSTANCE, $$delegatedProperties[1]);
            $this$iv = INSTANCE;
            name$iv = null;
            config$iv = FFIFuncConfig.Companion.getDEFAULT();
            required$iv = true;
            $i$f$func = false;
            CFDictionaryGetValue$delegate = new FFILib.FuncInfo(Reflection.typeOf(Function2.class, KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class))), name$iv, config$iv, required$iv).provideDelegate(INSTANCE, $$delegatedProperties[2]);
            $this$iv = INSTANCE;
            name$iv = null;
            config$iv = FFIFuncConfig.Companion.getDEFAULT();
            required$iv = true;
            $i$f$func = false;
            CFNumberGetValue$delegate = new FFILib.FuncInfo(Reflection.typeOf(Function3.class, KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE)), KTypeProjection.Companion.invariant(Reflection.typeOf(int[].class)), KTypeProjection.Companion.invariant(Reflection.typeOf(Boolean.TYPE))), name$iv, config$iv, required$iv).provideDelegate(INSTANCE, $$delegatedProperties[3]);
            $this$iv = INSTANCE;
            name$iv = null;
            config$iv = FFIFuncConfig.Companion.getDEFAULT();
            required$iv = true;
            $i$f$func = false;
            CFDataGetBytePtr$delegate = new FFILib.FuncInfo(Reflection.typeOf(Function1.class, KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class))), name$iv, config$iv, required$iv).provideDelegate(INSTANCE, $$delegatedProperties[4]);
            $this$iv = INSTANCE;
            name$iv = null;
            config$iv = FFIFuncConfig.Companion.getDEFAULT();
            required$iv = true;
            $i$f$func = false;
            CFDataGetLength$delegate = new FFILib.FuncInfo(Reflection.typeOf(Function1.class, KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE))), name$iv, config$iv, required$iv).provideDelegate(INSTANCE, $$delegatedProperties[5]);
            $this$iv = INSTANCE;
            name$iv = null;
            config$iv = FFIFuncConfig.Companion.getDEFAULT();
            required$iv = true;
            $i$f$func = false;
            CFRelease$delegate = new FFILib.FuncInfo(Reflection.typeOf(Function1.class, KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.typeOf(Unit.class))), name$iv, config$iv, required$iv).provideDelegate(INSTANCE, $$delegatedProperties[6]);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0013\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Rc\u0010\u0003\u001aJ\u0012\f\u0012\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0012\f\u0012\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\u0012\u0004\u0012\u00020\u0007\u0012\f\u0012\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u00060\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR7\u0010\f\u001a\u001e\u0012\f\u0012\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\u0012\f\u0012\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u00060\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u000b\u001a\u0004\b\u000e\u0010\u000fR)\u0010\u0011\u001a\u0010\u0012\f\u0012\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u00060\u00128FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u000b\u001a\u0004\b\u0013\u0010\u0014R/\u0010\u0016\u001a\u0016\u0012\f\u0012\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\u0012\u0004\u0012\u00020\u00170\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u000b\u001a\u0004\b\u0018\u0010\u000fRU\u0010\u001a\u001a<\u0012\f\u0012\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001c\u0012\f\u0012\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\u0012\u0004\u0012\u00020\u00170\u001b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u000b\u001a\u0004\b\u001d\u0010\u001eR/\u0010 \u001a\u0016\u0012\f\u0012\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\u0012\u0004\u0012\u00020\u00170\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\u000b\u001a\u0004\b!\u0010\u000fR/\u0010#\u001a\u0016\u0012\f\u0012\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\u0012\u0004\u0012\u00020\u00170\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010\u000b\u001a\u0004\b$\u0010\u000fR/\u0010&\u001a\u0016\u0012\f\u0012\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\u0012\u0004\u0012\u00020\u00070\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010\u000b\u001a\u0004\b'\u0010\u000fR/\u0010)\u001a\u0016\u0012\f\u0012\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\u0012\u0004\u0012\u00020\u00070\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b+\u0010\u000b\u001a\u0004\b*\u0010\u000fR/\u0010,\u001a\u0016\u0012\f\u0012\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\u0012\u0004\u0012\u00020\u00170\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b.\u0010\u000b\u001a\u0004\b-\u0010\u000f\u00a8\u0006/"}, d2={"Lkorlibs/image/format/provider/FFICoreGraphicsImageFormatProvider$CoreGraphics;", "Lkorlibs/ffi/FFILib;", "()V", "CGBitmapContextCreate", "Lkotlin/Function7;", "Lcom/sun/jna/Pointer;", "Lkorlibs/ffi/FFIPointer;", "", "getCGBitmapContextCreate", "()Lkotlin/jvm/functions/Function7;", "CGBitmapContextCreate$delegate", "Lkotlin/properties/ReadOnlyProperty;", "CGBitmapContextGetData", "Lkotlin/Function1;", "getCGBitmapContextGetData", "()Lkotlin/jvm/functions/Function1;", "CGBitmapContextGetData$delegate", "CGColorSpaceCreateDeviceRGB", "Lkotlin/Function0;", "getCGColorSpaceCreateDeviceRGB", "()Lkotlin/jvm/functions/Function0;", "CGColorSpaceCreateDeviceRGB$delegate", "CGColorSpaceRelease", "", "getCGColorSpaceRelease", "CGColorSpaceRelease$delegate", "CGContextDrawImage", "Lkotlin/Function6;", "", "getCGContextDrawImage", "()Lkotlin/jvm/functions/Function6;", "CGContextDrawImage$delegate", "CGContextFlush", "getCGContextFlush", "CGContextFlush$delegate", "CGContextRelease", "getCGContextRelease", "CGContextRelease$delegate", "CGImageGetHeight", "getCGImageGetHeight", "CGImageGetHeight$delegate", "CGImageGetWidth", "getCGImageGetWidth", "CGImageGetWidth$delegate", "CGImageRelease", "getCGImageRelease", "CGImageRelease$delegate", "korge-core"})
    @SourceDebugExtension(value={"SMAP\nFFICoreGraphicsImageFormatProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FFICoreGraphicsImageFormatProvider.kt\nkorlibs/image/format/provider/FFICoreGraphicsImageFormatProvider$CoreGraphics\n+ 2 FFILib.kt\nkorlibs/ffi/FFILib\n*L\n1#1,144:1\n234#2:145\n234#2:146\n234#2:147\n234#2:148\n234#2:149\n234#2:150\n234#2:151\n234#2:152\n234#2:153\n234#2:154\n*S KotlinDebug\n*F\n+ 1 FFICoreGraphicsImageFormatProvider.kt\nkorlibs/image/format/provider/FFICoreGraphicsImageFormatProvider$CoreGraphics\n*L\n62#1:145\n63#1:146\n64#1:147\n65#1:148\n66#1:149\n68#1:150\n69#1:151\n70#1:152\n71#1:153\n73#1:154\n*E\n"})
    private static final class CoreGraphics
    extends FFILib {
        @NotNull
        public static final CoreGraphics INSTANCE;
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private static final ReadOnlyProperty CGImageGetWidth$delegate;
        @NotNull
        private static final ReadOnlyProperty CGImageGetHeight$delegate;
        @NotNull
        private static final ReadOnlyProperty CGColorSpaceCreateDeviceRGB$delegate;
        @NotNull
        private static final ReadOnlyProperty CGBitmapContextCreate$delegate;
        @NotNull
        private static final ReadOnlyProperty CGBitmapContextGetData$delegate;
        @NotNull
        private static final ReadOnlyProperty CGImageRelease$delegate;
        @NotNull
        private static final ReadOnlyProperty CGContextRelease$delegate;
        @NotNull
        private static final ReadOnlyProperty CGColorSpaceRelease$delegate;
        @NotNull
        private static final ReadOnlyProperty CGContextFlush$delegate;
        @NotNull
        private static final ReadOnlyProperty CGContextDrawImage$delegate;

        private CoreGraphics() {
            String[] stringArray = new String[]{"CoreGraphics"};
            super(stringArray, false, 2, null);
        }

        @NotNull
        public final Function1<Pointer, Integer> getCGImageGetWidth() {
            return (Function1)CGImageGetWidth$delegate.getValue(this, $$delegatedProperties[0]);
        }

        @NotNull
        public final Function1<Pointer, Integer> getCGImageGetHeight() {
            return (Function1)CGImageGetHeight$delegate.getValue(this, $$delegatedProperties[1]);
        }

        @NotNull
        public final Function0<Pointer> getCGColorSpaceCreateDeviceRGB() {
            return (Function0)CGColorSpaceCreateDeviceRGB$delegate.getValue(this, $$delegatedProperties[2]);
        }

        @NotNull
        public final Function7<Pointer, Integer, Integer, Integer, Integer, Pointer, Integer, Pointer> getCGBitmapContextCreate() {
            return (Function7)CGBitmapContextCreate$delegate.getValue(this, $$delegatedProperties[3]);
        }

        @NotNull
        public final Function1<Pointer, Pointer> getCGBitmapContextGetData() {
            return (Function1)CGBitmapContextGetData$delegate.getValue(this, $$delegatedProperties[4]);
        }

        @NotNull
        public final Function1<Pointer, Unit> getCGImageRelease() {
            return (Function1)CGImageRelease$delegate.getValue(this, $$delegatedProperties[5]);
        }

        @NotNull
        public final Function1<Pointer, Unit> getCGContextRelease() {
            return (Function1)CGContextRelease$delegate.getValue(this, $$delegatedProperties[6]);
        }

        @NotNull
        public final Function1<Pointer, Unit> getCGColorSpaceRelease() {
            return (Function1)CGColorSpaceRelease$delegate.getValue(this, $$delegatedProperties[7]);
        }

        @NotNull
        public final Function1<Pointer, Unit> getCGContextFlush() {
            return (Function1)CGContextFlush$delegate.getValue(this, $$delegatedProperties[8]);
        }

        @NotNull
        public final Function6<Pointer, Double, Double, Double, Double, Pointer, Unit> getCGContextDrawImage() {
            return (Function6)CGContextDrawImage$delegate.getValue(this, $$delegatedProperties[9]);
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(CoreGraphics.class, "CGImageGetWidth", "getCGImageGetWidth()Lkotlin/jvm/functions/Function1;", 0)), Reflection.property1(new PropertyReference1Impl(CoreGraphics.class, "CGImageGetHeight", "getCGImageGetHeight()Lkotlin/jvm/functions/Function1;", 0)), Reflection.property1(new PropertyReference1Impl(CoreGraphics.class, "CGColorSpaceCreateDeviceRGB", "getCGColorSpaceCreateDeviceRGB()Lkotlin/jvm/functions/Function0;", 0)), Reflection.property1(new PropertyReference1Impl(CoreGraphics.class, "CGBitmapContextCreate", "getCGBitmapContextCreate()Lkotlin/jvm/functions/Function7;", 0)), Reflection.property1(new PropertyReference1Impl(CoreGraphics.class, "CGBitmapContextGetData", "getCGBitmapContextGetData()Lkotlin/jvm/functions/Function1;", 0)), Reflection.property1(new PropertyReference1Impl(CoreGraphics.class, "CGImageRelease", "getCGImageRelease()Lkotlin/jvm/functions/Function1;", 0)), Reflection.property1(new PropertyReference1Impl(CoreGraphics.class, "CGContextRelease", "getCGContextRelease()Lkotlin/jvm/functions/Function1;", 0)), Reflection.property1(new PropertyReference1Impl(CoreGraphics.class, "CGColorSpaceRelease", "getCGColorSpaceRelease()Lkotlin/jvm/functions/Function1;", 0)), Reflection.property1(new PropertyReference1Impl(CoreGraphics.class, "CGContextFlush", "getCGContextFlush()Lkotlin/jvm/functions/Function1;", 0)), Reflection.property1(new PropertyReference1Impl(CoreGraphics.class, "CGContextDrawImage", "getCGContextDrawImage()Lkotlin/jvm/functions/Function6;", 0))};
            $$delegatedProperties = kPropertyArray;
            INSTANCE = new CoreGraphics();
            FFILib $this$iv = INSTANCE;
            String name$iv = null;
            FFIFuncConfig config$iv = FFIFuncConfig.Companion.getDEFAULT();
            boolean required$iv = true;
            boolean $i$f$func = false;
            CGImageGetWidth$delegate = new FFILib.FuncInfo(Reflection.typeOf(Function1.class, KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE))), name$iv, config$iv, required$iv).provideDelegate(INSTANCE, $$delegatedProperties[0]);
            $this$iv = INSTANCE;
            name$iv = null;
            config$iv = FFIFuncConfig.Companion.getDEFAULT();
            required$iv = true;
            $i$f$func = false;
            CGImageGetHeight$delegate = new FFILib.FuncInfo(Reflection.typeOf(Function1.class, KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE))), name$iv, config$iv, required$iv).provideDelegate(INSTANCE, $$delegatedProperties[1]);
            $this$iv = INSTANCE;
            name$iv = null;
            config$iv = FFIFuncConfig.Companion.getDEFAULT();
            required$iv = true;
            $i$f$func = false;
            CGColorSpaceCreateDeviceRGB$delegate = new FFILib.FuncInfo(Reflection.typeOf(Function0.class, KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class))), name$iv, config$iv, required$iv).provideDelegate(INSTANCE, $$delegatedProperties[2]);
            $this$iv = INSTANCE;
            name$iv = null;
            config$iv = FFIFuncConfig.Companion.getDEFAULT();
            required$iv = true;
            $i$f$func = false;
            CGBitmapContextCreate$delegate = new FFILib.FuncInfo(Reflection.typeOf(Function7.class, KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE)), KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE)), KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE)), KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE)), KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE)), KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class))), name$iv, config$iv, required$iv).provideDelegate(INSTANCE, $$delegatedProperties[3]);
            $this$iv = INSTANCE;
            name$iv = null;
            config$iv = FFIFuncConfig.Companion.getDEFAULT();
            required$iv = true;
            $i$f$func = false;
            CGBitmapContextGetData$delegate = new FFILib.FuncInfo(Reflection.typeOf(Function1.class, KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class))), name$iv, config$iv, required$iv).provideDelegate(INSTANCE, $$delegatedProperties[4]);
            $this$iv = INSTANCE;
            name$iv = null;
            config$iv = FFIFuncConfig.Companion.getDEFAULT();
            required$iv = true;
            $i$f$func = false;
            CGImageRelease$delegate = new FFILib.FuncInfo(Reflection.typeOf(Function1.class, KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.typeOf(Unit.class))), name$iv, config$iv, required$iv).provideDelegate(INSTANCE, $$delegatedProperties[5]);
            $this$iv = INSTANCE;
            name$iv = null;
            config$iv = FFIFuncConfig.Companion.getDEFAULT();
            required$iv = true;
            $i$f$func = false;
            CGContextRelease$delegate = new FFILib.FuncInfo(Reflection.typeOf(Function1.class, KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.typeOf(Unit.class))), name$iv, config$iv, required$iv).provideDelegate(INSTANCE, $$delegatedProperties[6]);
            $this$iv = INSTANCE;
            name$iv = null;
            config$iv = FFIFuncConfig.Companion.getDEFAULT();
            required$iv = true;
            $i$f$func = false;
            CGColorSpaceRelease$delegate = new FFILib.FuncInfo(Reflection.typeOf(Function1.class, KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.typeOf(Unit.class))), name$iv, config$iv, required$iv).provideDelegate(INSTANCE, $$delegatedProperties[7]);
            $this$iv = INSTANCE;
            name$iv = null;
            config$iv = FFIFuncConfig.Companion.getDEFAULT();
            required$iv = true;
            $i$f$func = false;
            CGContextFlush$delegate = new FFILib.FuncInfo(Reflection.typeOf(Function1.class, KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.typeOf(Unit.class))), name$iv, config$iv, required$iv).provideDelegate(INSTANCE, $$delegatedProperties[8]);
            $this$iv = INSTANCE;
            name$iv = null;
            config$iv = FFIFuncConfig.Companion.getDEFAULT();
            required$iv = true;
            $i$f$func = false;
            CGContextDrawImage$delegate = new FFILib.FuncInfo(Reflection.typeOf(Function6.class, KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.typeOf(Double.TYPE)), KTypeProjection.Companion.invariant(Reflection.typeOf(Double.TYPE)), KTypeProjection.Companion.invariant(Reflection.typeOf(Double.TYPE)), KTypeProjection.Companion.invariant(Reflection.typeOf(Double.TYPE)), KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.typeOf(Unit.class))), name$iv, config$iv, required$iv).provideDelegate(INSTANCE, $$delegatedProperties[9]);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002RK\u0010\u0003\u001a2\u0012\f\u0012\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\u0012\u0004\u0012\u00020\u0007\u0012\f\u0012\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\u0012\f\u0012\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u00060\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tRK\u0010\f\u001a2\u0012\f\u0012\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\u0012\u0004\u0012\u00020\u0007\u0012\f\u0012\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\u0012\f\u0012\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u00060\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000b\u001a\u0004\b\r\u0010\tRE\u0010\u000f\u001a,\u0012\f\u0012\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\u0012\f\u0012\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\u0012\f\u0012\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u00060\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u000b\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lkorlibs/image/format/provider/FFICoreGraphicsImageFormatProvider$ImageIO;", "Lkorlibs/ffi/FFILib;", "()V", "CGImageSourceCopyPropertiesAtIndex", "Lkotlin/Function3;", "Lcom/sun/jna/Pointer;", "Lkorlibs/ffi/FFIPointer;", "", "getCGImageSourceCopyPropertiesAtIndex", "()Lkotlin/jvm/functions/Function3;", "CGImageSourceCopyPropertiesAtIndex$delegate", "Lkotlin/properties/ReadOnlyProperty;", "CGImageSourceCreateImageAtIndex", "getCGImageSourceCreateImageAtIndex", "CGImageSourceCreateImageAtIndex$delegate", "CGImageSourceCreateWithData", "Lkotlin/Function2;", "getCGImageSourceCreateWithData", "()Lkotlin/jvm/functions/Function2;", "CGImageSourceCreateWithData$delegate", "korge-core"})
    @SourceDebugExtension(value={"SMAP\nFFICoreGraphicsImageFormatProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FFICoreGraphicsImageFormatProvider.kt\nkorlibs/image/format/provider/FFICoreGraphicsImageFormatProvider$ImageIO\n+ 2 FFILib.kt\nkorlibs/ffi/FFILib\n*L\n1#1,144:1\n234#2:145\n234#2:146\n234#2:147\n*S KotlinDebug\n*F\n+ 1 FFICoreGraphicsImageFormatProvider.kt\nkorlibs/image/format/provider/FFICoreGraphicsImageFormatProvider$ImageIO\n*L\n77#1:145\n78#1:146\n79#1:147\n*E\n"})
    private static final class ImageIO
    extends FFILib {
        @NotNull
        public static final ImageIO INSTANCE;
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private static final ReadOnlyProperty CGImageSourceCreateWithData$delegate;
        @NotNull
        private static final ReadOnlyProperty CGImageSourceCopyPropertiesAtIndex$delegate;
        @NotNull
        private static final ReadOnlyProperty CGImageSourceCreateImageAtIndex$delegate;

        private ImageIO() {
            String[] stringArray = new String[]{"ImageIO"};
            super(stringArray, false, 2, null);
        }

        @NotNull
        public final Function2<Pointer, Pointer, Pointer> getCGImageSourceCreateWithData() {
            return (Function2)CGImageSourceCreateWithData$delegate.getValue(this, $$delegatedProperties[0]);
        }

        @NotNull
        public final Function3<Pointer, Integer, Pointer, Pointer> getCGImageSourceCopyPropertiesAtIndex() {
            return (Function3)CGImageSourceCopyPropertiesAtIndex$delegate.getValue(this, $$delegatedProperties[1]);
        }

        @NotNull
        public final Function3<Pointer, Integer, Pointer, Pointer> getCGImageSourceCreateImageAtIndex() {
            return (Function3)CGImageSourceCreateImageAtIndex$delegate.getValue(this, $$delegatedProperties[2]);
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(ImageIO.class, "CGImageSourceCreateWithData", "getCGImageSourceCreateWithData()Lkotlin/jvm/functions/Function2;", 0)), Reflection.property1(new PropertyReference1Impl(ImageIO.class, "CGImageSourceCopyPropertiesAtIndex", "getCGImageSourceCopyPropertiesAtIndex()Lkotlin/jvm/functions/Function3;", 0)), Reflection.property1(new PropertyReference1Impl(ImageIO.class, "CGImageSourceCreateImageAtIndex", "getCGImageSourceCreateImageAtIndex()Lkotlin/jvm/functions/Function3;", 0))};
            $$delegatedProperties = kPropertyArray;
            INSTANCE = new ImageIO();
            FFILib $this$iv = INSTANCE;
            String name$iv = null;
            FFIFuncConfig config$iv = FFIFuncConfig.Companion.getDEFAULT();
            boolean required$iv = true;
            boolean $i$f$func = false;
            CGImageSourceCreateWithData$delegate = new FFILib.FuncInfo(Reflection.typeOf(Function2.class, KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class))), name$iv, config$iv, required$iv).provideDelegate(INSTANCE, $$delegatedProperties[0]);
            $this$iv = INSTANCE;
            name$iv = null;
            config$iv = FFIFuncConfig.Companion.getDEFAULT();
            required$iv = true;
            $i$f$func = false;
            CGImageSourceCopyPropertiesAtIndex$delegate = new FFILib.FuncInfo(Reflection.typeOf(Function3.class, KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE)), KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class))), name$iv, config$iv, required$iv).provideDelegate(INSTANCE, $$delegatedProperties[1]);
            $this$iv = INSTANCE;
            name$iv = null;
            config$iv = FFIFuncConfig.Companion.getDEFAULT();
            required$iv = true;
            $i$f$func = false;
            CGImageSourceCreateImageAtIndex$delegate = new FFILib.FuncInfo(Reflection.typeOf(Function3.class, KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE)), KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class))), name$iv, config$iv, required$iv).provideDelegate(INSTANCE, $$delegatedProperties[2]);
        }
    }
}

