/*
 * Decompiled with CFR 0.152.
 */
package korlibs.image.style;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import korlibs.datastructure.ListReader;
import korlibs.datastructure.ListReaderKt;
import korlibs.image.style.CSS;
import korlibs.math.interpolation.Ratio;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\rJ\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0004R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lkorlibs/image/style/CSSReader;", "", "tokens", "Lkorlibs/datastructure/ListReader;", "Lkorlibs/image/style/CSS$Companion$Token;", "(Lkorlibs/datastructure/ListReader;)V", "getTokens", "()Lkorlibs/datastructure/ListReader;", "parseCSS", "Lkorlibs/image/style/CSS;", "parseDeclaration", "Lkorlibs/image/style/CSS$Declaration;", "parseExpression", "Lkorlibs/image/style/CSS$Expression;", "parseRuleset", "", "Lkorlibs/image/style/CSS$IRuleSet;", "parseRulesets", "selectorFromToken", "Lkorlibs/image/style/CSS$Selector;", "token", "korge-core"})
@SourceDebugExtension(value={"SMAP\nCSS.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CSS.kt\nkorlibs/image/style/CSSReader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,433:1\n1045#2:434\n1549#2:435\n1620#2,3:436\n*S KotlinDebug\n*F\n+ 1 CSS.kt\nkorlibs/image/style/CSSReader\n*L\n357#1:434\n385#1:435\n385#1:436,3\n*E\n"})
public final class CSSReader {
    @NotNull
    private final ListReader<CSS.Companion.Token> tokens;

    public CSSReader(@NotNull ListReader<CSS.Companion.Token> tokens2) {
        this.tokens = tokens2;
    }

    @NotNull
    public final ListReader<CSS.Companion.Token> getTokens() {
        return this.tokens;
    }

    @NotNull
    public final CSS parseCSS() {
        return new CSS(this.parseRulesets(), null, 2, null);
    }

    @NotNull
    public final List<CSS.IRuleSet> parseRulesets() {
        ArrayList out = new ArrayList();
        while (this.tokens.getHasMore()) {
            CollectionsKt.addAll((Collection)out, (Iterable)this.parseRuleset());
        }
        return out;
    }

    @NotNull
    public final CSS.Selector selectorFromToken(@NotNull CSS.Companion.Token token2) {
        if (StringsKt.startsWith$default(token2.getStr(), "#", false, 2, null)) {
            return new CSS.IdSelector(token2);
        }
        if (StringsKt.startsWith$default(token2.getStr(), ".", false, 2, null)) {
            return new CSS.ClassSelector(token2);
        }
        return new CSS.UnknownSelector(token2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<CSS.IRuleSet> parseRuleset() {
        void $this$mapTo$iv$iv;
        CSS.Companion.Token token2 = this.tokens.peek();
        if (StringsKt.startsWith$default(token2.getStr(), "@", false, 2, null)) {
            this.tokens.read();
            String string = token2.getStr();
            if (Intrinsics.areEqual(string, "@keyframes") ? true : Intrinsics.areEqual(string, "@-webkit-keyframes")) {
                CSS.Companion.Token keyframesName = this.tokens.read();
                ArrayList sets = new ArrayList();
                ListReaderKt.expect(this.tokens, new CSS.Companion.Token("{"));
                while (!Intrinsics.areEqual(this.tokens.peek(), new CSS.Companion.Token("}"))) {
                    List<CSS.KeyFrame> frame2 = CSS.KeyFrames.Companion.ruleSetToKeyFrame(this.parseRuleset());
                    if (frame2 == null) continue;
                    CollectionsKt.addAll((Collection)sets, (Iterable)frame2);
                }
                ListReaderKt.expect(this.tokens, new CSS.Companion.Token("}"));
                Iterable $this$sortedBy$iv = sets;
                boolean $i$f$sortedBy = false;
                return CollectionsKt.listOf(new CSS.KeyFrames(keyframesName, CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                    public final int compare(T a, T b) {
                        CSS.KeyFrame it = (CSS.KeyFrame)a;
                        boolean bl = false;
                        Comparable comparable = Ratio.box-impl(it.getRatio-eKSQRR4());
                        it = (CSS.KeyFrame)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues(comparable2, (Comparable)Ratio.box-impl(it.getRatio-eKSQRR4()));
                    }
                })));
            }
            String keyframesName = "Unknown at rule: '" + token2 + "'";
            throw new NotImplementedError("An operation is not implemented: " + keyframesName);
        }
        ArrayList selectors = new ArrayList();
        while (this.tokens.getHasMore()) {
            CSS.Companion.Token token3 = this.tokens.read();
            ((Collection)selectors).add(this.selectorFromToken(token3));
            if (Intrinsics.areEqual(this.tokens.peek().getStr(), ",")) {
                ListReader.skip$default(this.tokens, 0, 1, null);
                continue;
            }
            if (!Intrinsics.areEqual(this.tokens.peek().getStr(), "{")) continue;
        }
        ArrayList decls = new ArrayList();
        ListReaderKt.expect(this.tokens, new CSS.Companion.Token("{"));
        while (!Intrinsics.areEqual(this.tokens.peek(), new CSS.Companion.Token("}"))) {
            ((Collection)decls).add(this.parseDeclaration());
        }
        ListReaderKt.expect(this.tokens, new CSS.Companion.Token("}"));
        CSS.Declarations declsd = new CSS.Declarations(decls);
        Iterable $this$map$iv = selectors;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CSS.Selector selector = (CSS.Selector)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new CSS.RuleSet((CSS.Selector)it, declsd));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final CSS.Declaration parseDeclaration() {
        String property = StringsKt.removePrefix(this.tokens.read().getStr(), (CharSequence)"-webkit-");
        ListReaderKt.expect(this.tokens, new CSS.Companion.Token(":"));
        CSS.Expression expression = this.parseExpression();
        return new CSS.Declaration(property, expression);
    }

    @NotNull
    public final CSS.Expression parseExpression() {
        CSS.Companion.Token token2;
        ArrayList<CSS.Companion.Token> out = new ArrayList<CSS.Companion.Token>();
        while (!Intrinsics.areEqual((token2 = this.tokens.read()).getStr(), ";")) {
            if (Intrinsics.areEqual(token2.getStr(), "}")) {
                this.tokens.skip(-1);
                break;
            }
            out.add(token2);
        }
        return new CSS.Expression((List<CSS.Companion.Token>)out);
    }
}

