/*
 * Decompiled with CFR 0.152.
 */
package korlibs.image.tiles;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import korlibs.datastructure.IntMap;
import korlibs.image.bitmap.Bitmap;
import korlibs.image.bitmap.Bitmap32;
import korlibs.image.bitmap.BitmapKt;
import korlibs.image.bitmap.BitmapSliceKt;
import korlibs.image.bitmap.Bitmaps;
import korlibs.image.bitmap.BitmapsKt;
import korlibs.image.tiles.TileSetTileInfo;
import korlibs.math.PowerOfTwoKt;
import korlibs.math.ToIntegerConvertersKt;
import korlibs.math.geom.SizeInt;
import korlibs.math.geom.slice.RectSlice;
import korlibs.math.geom.slice.SliceCoordsWithBase;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 12\u00020\u0001:\u00011B'\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u0006\u0010(\u001a\u00020\u0000J!\u0010)\u001a\u0012\u0012\u0006\b\u0001\u0012\u00020\n\u0018\u00010*j\u0004\u0018\u0001`+2\u0006\u0010,\u001a\u00020\u0006H\u0086\u0002J\u0010\u0010-\u001a\u0004\u0018\u00010\u00042\u0006\u0010,\u001a\u00020\u0006J\u001e\u0010.\u001a\u0012\u0012\u0006\b\u0001\u0012\u00020\n\u0018\u00010*j\u0004\u0018\u0001`+2\u0006\u0010,\u001a\u00020\u0006J\b\u0010/\u001a\u000200H\u0016R\u001b\u0010\t\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\u000f\u001a\u00020\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u000e\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R#\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00178FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u000e\u001a\u0004\b\u0018\u0010\u0019R1\u0010\u001b\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0006\b\u0001\u0012\u00020\n\u0018\u00010\u001cj\u0004\u0018\u0001`\u001d0\u00178FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\u000e\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010!\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0015\u00a8\u00062"}, d2={"Lkorlibs/image/tiles/TileSet;", "", "tilesMap", "Lkorlibs/datastructure/IntMap;", "Lkorlibs/image/tiles/TileSetTileInfo;", "width", "", "height", "(Lkorlibs/datastructure/IntMap;II)V", "base", "Lkorlibs/image/bitmap/Bitmap;", "getBase", "()Lkorlibs/image/bitmap/Bitmap;", "base$delegate", "Lkotlin/Lazy;", "hasMultipleBaseBitmaps", "", "getHasMultipleBaseBitmaps", "()Z", "hasMultipleBaseBitmaps$delegate", "getHeight", "()I", "infos", "", "getInfos", "()[Lkorlibs/image/tiles/TileSetTileInfo;", "infos$delegate", "textures", "Lkorlibs/math/geom/slice/SliceCoordsWithBase;", "Lkorlibs/image/bitmap/BitmapCoords;", "getTextures", "()[Lkorlibs/math/geom/slice/SliceCoordsWithBase;", "textures$delegate", "tileSize", "Lkorlibs/math/geom/SizeInt;", "getTileSize", "()Lkorlibs/math/geom/SizeInt;", "getTilesMap", "()Lkorlibs/datastructure/IntMap;", "getWidth", "clone", "get", "Lkorlibs/math/geom/slice/RectSlice;", "Lkorlibs/image/bitmap/BmpSlice;", "index", "getInfo", "getSlice", "toString", "", "Companion", "korge-core"})
public final class TileSet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IntMap<TileSetTileInfo> tilesMap;
    private final int width;
    private final int height;
    @NotNull
    private final Lazy base$delegate;
    @NotNull
    private final Lazy hasMultipleBaseBitmaps$delegate;
    @NotNull
    private final Lazy infos$delegate;
    @NotNull
    private final Lazy textures$delegate;
    @NotNull
    private static final TileSet EMPTY = new TileSet(new IntMap(0, 0.0, 3, null), 0, 0, 6, null);

    public TileSet(@NotNull IntMap<TileSetTileInfo> tilesMap, int width2, int height2) {
        this.tilesMap = tilesMap;
        this.width = width2;
        this.height = height2;
        this.base$delegate = LazyKt.lazy((Function0)new Function0<Bitmap>(this){
            final /* synthetic */ TileSet this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Bitmap invoke() {
                Bitmap bitmap;
                if (this.this$0.getTilesMap().getSize() == 0) {
                    Bitmaps this_$iv = Bitmaps.INSTANCE;
                    boolean $i$f$getTransparent = false;
                    bitmap = BitmapSliceKt.getBmp(BitmapsKt.getBitmaps_transparent());
                } else {
                    bitmap = BitmapSliceKt.getBmp(this.this$0.getTilesMap().firstValue().getSlice());
                }
                return bitmap;
            }
        });
        this.hasMultipleBaseBitmaps$delegate = LazyKt.lazy((Function0)new Function0<Boolean>(this){
            final /* synthetic */ TileSet this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Boolean invoke() {
                boolean bl;
                block3: {
                    void $this$any$iv;
                    Iterable<TileSetTileInfo> iterable = this.this$0.getTilesMap().getValues();
                    TileSet tileSet = this.this$0;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            TileSetTileInfo it = (TileSetTileInfo)element$iv;
                            boolean bl2 = false;
                            if (!(it != null && BitmapSliceKt.getBmp(it.getSlice()) != tileSet.getBase())) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }
        });
        this.infos$delegate = LazyKt.lazy((Function0)new Function0<TileSetTileInfo[]>(this){
            final /* synthetic */ TileSet this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final TileSetTileInfo[] invoke() {
                int n = 0;
                Integer n2 = CollectionsKt.maxOrNull(this.this$0.getTilesMap().getKeys());
                int n3 = n2 != null ? n2 + 1 : 0;
                TileSetTileInfo[] tileSetTileInfoArray = new TileSetTileInfo[n3];
                while (n < n3) {
                    int n4 = n++;
                    tileSetTileInfoArray[n4] = this.this$0.getTilesMap().get(n4);
                }
                return tileSetTileInfoArray;
            }
        });
        this.textures$delegate = LazyKt.lazy((Function0)new Function0<SliceCoordsWithBase<? extends Bitmap>[]>(this){
            final /* synthetic */ TileSet this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final SliceCoordsWithBase<? extends Bitmap>[] invoke() {
                Integer n = CollectionsKt.maxOrNull(this.this$0.getTilesMap().getKeys());
                int n2 = n != null ? n + 1 : 0;
                SliceCoordsWithBase[] sliceCoordsWithBaseArray = new SliceCoordsWithBase[n2];
                for (int j = 0; j < n2; ++j) {
                    int n3 = j;
                    TileSetTileInfo tileSetTileInfo = this.this$0.getTilesMap().get(n3);
                    sliceCoordsWithBaseArray[n3] = tileSetTileInfo != null ? tileSetTileInfo.getSlice() : null;
                }
                return sliceCoordsWithBaseArray;
            }
        });
    }

    public /* synthetic */ TileSet(IntMap intMap, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            int n4 = n = intMap.getSize() == 0 ? 0 : ((TileSetTileInfo)intMap.firstValue()).getSlice().getWidth();
        }
        if ((n3 & 4) != 0) {
            n2 = intMap.getSize() == 0 ? 0 : ((TileSetTileInfo)intMap.firstValue()).getSlice().getHeight();
        }
        this(intMap, n, n2);
    }

    @NotNull
    public final IntMap<TileSetTileInfo> getTilesMap() {
        return this.tilesMap;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    @NotNull
    public final SizeInt getTileSize() {
        return new SizeInt(this.width, this.height);
    }

    @NotNull
    public String toString() {
        return "TileSet(size=" + this.width + "x" + this.height + ", tiles=" + CollectionsKt.toList(this.tilesMap.getKeys()) + ")";
    }

    @NotNull
    public final Bitmap getBase() {
        Lazy lazy = this.base$delegate;
        return (Bitmap)lazy.getValue();
    }

    public final boolean getHasMultipleBaseBitmaps() {
        Lazy lazy = this.hasMultipleBaseBitmaps$delegate;
        return (Boolean)lazy.getValue();
    }

    @NotNull
    public final TileSetTileInfo[] getInfos() {
        Lazy lazy = this.infos$delegate;
        return (TileSetTileInfo[])lazy.getValue();
    }

    @NotNull
    public final SliceCoordsWithBase<? extends Bitmap>[] getTextures() {
        Lazy lazy = this.textures$delegate;
        return (SliceCoordsWithBase[])lazy.getValue();
    }

    @Nullable
    public final TileSetTileInfo getInfo(int index2) {
        return ArraysKt.getOrNull(this.getInfos(), index2);
    }

    @Nullable
    public final RectSlice<? extends Bitmap> getSlice(int index2) {
        TileSetTileInfo tileSetTileInfo = this.getInfo(index2);
        return tileSetTileInfo != null ? tileSetTileInfo.getSlice() : null;
    }

    @Nullable
    public final RectSlice<? extends Bitmap> get(int index2) {
        return this.getSlice(index2);
    }

    @NotNull
    public final TileSet clone() {
        return new TileSet(this.tilesMap.clone(), this.width, this.height);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JD\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fJP\u0010\u0012\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0006\b\u0001\u0012\u00020\t0\u0013j\u0002`\u00140\b2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fJD\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0018\u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0006\b\u0001\u0012\u00020\t0\u0013j\u0002`\u00140\b2\b\b\u0002\u0010\u0017\u001a\u00020\f2\b\b\u0002\u0010\u0018\u001a\u00020\u0019J8\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0002\u0010\u0017\u001a\u00020\f2\b\b\u0002\u0010\u0018\u001a\u00020\u0019JE\u0010\u001c\u001a\u00020\u00042\u0012\u0010\u001d\u001a\u000e\u0012\u0006\b\u0001\u0012\u00020\u001e0\u0013j\u0002`\u001f2\b\b\u0002\u0010 \u001a\u00020\f2\b\b\u0002\u0010!\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\f2\b\b\u0002\u0010\"\u001a\u00020\fH\u0086\u0002J6\u0010\u001c\u001a\u00020\u00042\u0012\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020%0$\"\u00020%2\b\b\u0002\u0010&\u001a\u00020\f2\b\b\u0002\u0010'\u001a\u00020\fH\u0086\u0002\u00a2\u0006\u0002\u0010(J+\u0010\u001c\u001a\u00020\u00042\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0\b2\b\b\u0002\u0010&\u001a\u00020\f2\b\b\u0002\u0010'\u001a\u00020\fH\u0086\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006)"}, d2={"Lkorlibs/image/tiles/TileSet$Companion;", "", "()V", "EMPTY", "Lkorlibs/image/tiles/TileSet;", "getEMPTY", "()Lkorlibs/image/tiles/TileSet;", "extractBitmaps", "", "Lkorlibs/image/bitmap/Bitmap32;", "bmp", "tilewidth", "", "tileheight", "columns", "tilecount", "spacing", "margin", "extractBmpSlices", "Lkorlibs/math/geom/slice/RectSlice;", "Lkorlibs/image/bitmap/BmpSlice32;", "fromBitmapSlices", "bmpSlices", "border", "mipmaps", "", "fromBitmaps", "bitmaps", "invoke", "base", "Lkorlibs/image/bitmap/Bitmap;", "Lkorlibs/image/bitmap/BmpSlice;", "tileWidth", "tileHeight", "totalTiles", "tiles", "", "Lkorlibs/image/tiles/TileSetTileInfo;", "width", "height", "([Lkorlibs/image/tiles/TileSetTileInfo;II)Lkorlibs/image/tiles/TileSet;", "korge-core"})
    @SourceDebugExtension(value={"SMAP\nTileSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileSet.kt\nkorlibs/image/tiles/TileSet$Companion\n+ 2 _Datastructure_iterators.kt\nkorlibs/datastructure/iterators/_Datastructure_iteratorsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,210:1\n107#2,6:211\n1549#3:217\n1620#3,3:218\n1549#3:221\n1620#3,3:222\n1726#3,3:225\n1747#3,3:228\n*S KotlinDebug\n*F\n+ 1 TileSet.kt\nkorlibs/image/tiles/TileSet$Companion\n*L\n69#1:211,6\n134#1:217\n134#1:218,3\n143#1:221\n143#1:222,3\n153#1:225,3\n167#1:228,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TileSet getEMPTY() {
            return EMPTY;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final TileSet invoke(@NotNull List<TileSetTileInfo> tiles, int width2, int height2) {
            IntMap<TileSetTileInfo> map2 = new IntMap<TileSetTileInfo>(0, 0.0, 3, null);
            List<TileSetTileInfo> $this$fastForEachWithIndex$iv = tiles;
            boolean $i$f$fastForEachWithIndex = false;
            int n$iv = 0;
            while (n$iv < $this$fastForEachWithIndex$iv.size()) {
                void value;
                TileSetTileInfo tileSetTileInfo = $this$fastForEachWithIndex$iv.get(n$iv);
                int index2 = n$iv++;
                boolean bl = false;
                map2.set(index2, (TileSetTileInfo)value);
            }
            return new TileSet(map2, width2, height2);
        }

        public static /* synthetic */ TileSet invoke$default(Companion companion, List list2, int n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n = ((TileSetTileInfo)CollectionsKt.first(list2)).getSlice().getWidth();
            }
            if ((n3 & 4) != 0) {
                n2 = ((TileSetTileInfo)CollectionsKt.first(list2)).getSlice().getHeight();
            }
            return companion.invoke(list2, n, n2);
        }

        @NotNull
        public final TileSet invoke(@NotNull TileSetTileInfo[] tiles, int width2, int height2) {
            return this.invoke(ArraysKt.toList(tiles), width2, height2);
        }

        public static /* synthetic */ TileSet invoke$default(Companion companion, TileSetTileInfo[] tileSetTileInfoArray, int n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n = ArraysKt.first(tileSetTileInfoArray).getSlice().getWidth();
            }
            if ((n3 & 4) != 0) {
                n2 = ArraysKt.first(tileSetTileInfoArray).getSlice().getHeight();
            }
            return companion.invoke(tileSetTileInfoArray, n, n2);
        }

        @NotNull
        public final TileSet invoke(@NotNull RectSlice<? extends Bitmap> base2, int tileWidth, int tileHeight, int columns, int totalTiles) {
            IntMap<TileSetTileInfo> out = new IntMap<TileSetTileInfo>(0, 0.0, 3, null);
            int rows2 = base2.getHeight() / tileHeight;
            int actualColumns = columns < 0 ? base2.getWidth() / tileWidth : columns;
            int actualTotalTiles = totalTiles < 0 ? rows2 * actualColumns : totalTiles;
            int n = 0;
            block0: for (int y = 0; y < rows2; ++y) {
                for (int x = 0; x < actualColumns; ++x) {
                    out.set(n, new TileSetTileInfo(n + 1, RectSlice.sliceWithSize-DGSIfu0$default(base2, x * tileWidth, y * tileHeight, tileWidth, tileHeight, null, false, 0, 112, null), null, null, 12, null));
                    ++n;
                    if (out.getSize() >= actualTotalTiles) break block0;
                }
            }
            return new TileSet(out, tileWidth, tileHeight);
        }

        public static /* synthetic */ TileSet invoke$default(Companion companion, RectSlice rectSlice, int n, int n2, int n3, int n4, int n5, Object object) {
            if ((n5 & 2) != 0) {
                n = rectSlice.getWidth();
            }
            if ((n5 & 4) != 0) {
                n2 = rectSlice.getHeight();
            }
            if ((n5 & 8) != 0) {
                n3 = -1;
            }
            if ((n5 & 0x10) != 0) {
                n4 = -1;
            }
            return companion.invoke(rectSlice, n, n2, n3, n4);
        }

        @NotNull
        public final List<RectSlice<? extends Bitmap32>> extractBmpSlices(@NotNull Bitmap32 bmp2, int tilewidth, int tileheight, int columns, int tilecount, int spacing2, int margin) {
            ArrayList<RectSlice> arrayList;
            ArrayList<RectSlice> $this$extractBmpSlices_u24lambda_u241 = arrayList = new ArrayList<RectSlice>();
            boolean bl = false;
            int n = bmp2.getHeight() / tileheight;
            block0: for (int y = 0; y < n; ++y) {
                for (int x = 0; x < columns; ++x) {
                    $this$extractBmpSlices_u24lambda_u241.add(BitmapSliceKt.sliceWithSize-dYJqCJA$default(bmp2, margin + x * (tilewidth + spacing2), margin + y * (tileheight + spacing2), tilewidth, tileheight, null, 0, null, 112, null));
                    if ($this$extractBmpSlices_u24lambda_u241.size() >= tilecount) break block0;
                }
            }
            return arrayList;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Bitmap32> extractBitmaps(@NotNull Bitmap32 bmp2, int tilewidth, int tileheight, int columns, int tilecount, int spacing2, int margin) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.extractBmpSlices(bmp2, tilewidth, tileheight, columns, tilecount, spacing2, margin);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                RectSlice rectSlice = (RectSlice)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add((Bitmap32)BitmapSliceKt.extract(it));
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final TileSet fromBitmaps(int tilewidth, int tileheight, @NotNull List<Bitmap32> bitmaps, int border, boolean mipmaps) {
            Collection<RectSlice> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = bitmaps;
            int n = tileheight;
            int n2 = tilewidth;
            Companion companion = this;
            boolean $i$f$map = false;
            void var8_11 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Bitmap32 bitmap32 = (Bitmap32)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(BitmapSliceKt.slice-pvcgspk$default((Bitmap)it, null, null, 0, null, 15, null));
            }
            collection = (List)destination$iv$iv;
            return companion.fromBitmapSlices(n2, n, (List<RectSlice<? extends Bitmap32>>)collection, border, mipmaps);
        }

        public static /* synthetic */ TileSet fromBitmaps$default(Companion companion, int n, int n2, List list2, int n3, boolean bl, int n4, Object object) {
            if ((n4 & 8) != 0) {
                n3 = 1;
            }
            if ((n4 & 0x10) != 0) {
                bl = false;
            }
            return companion.fromBitmaps(n, n2, list2, n3, bl);
        }

        @NotNull
        public final TileSet fromBitmapSlices(int tilewidth, int tileheight, @NotNull List<RectSlice<? extends Bitmap32>> bmpSlices, int border, boolean mipmaps) {
            boolean bl;
            int potSize;
            int rows2;
            int columns;
            int btileheight;
            int btilewidth;
            block14: {
                boolean bl2;
                block13: {
                    Iterable $this$all$iv = bmpSlices;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl2 = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            RectSlice it = (RectSlice)element$iv;
                            boolean bl3 = false;
                            if (it.getWidth() == tilewidth && it.getHeight() == tileheight) continue;
                            bl2 = false;
                            break block13;
                        }
                        bl2 = true;
                    }
                }
                if (!bl2) {
                    String $i$f$all = "Check failed.";
                    throw new IllegalStateException($i$f$all.toString());
                }
                if (bmpSlices.isEmpty()) {
                    return new TileSet(new IntMap<TileSetTileInfo>(0, 0.0, 3, null), tilewidth, tileheight);
                }
                int border2 = border * 2;
                btilewidth = tilewidth + border2;
                btileheight = tileheight + border2;
                columns = ToIntegerConvertersKt.toIntCeil(Math.sqrt(bmpSlices.size()));
                rows2 = ToIntegerConvertersKt.toIntCeil((double)bmpSlices.size() / (double)columns);
                int minWidth = columns * (tilewidth + border) + border;
                int minHeight = rows2 * (tileheight + border) + border;
                potSize = Math.max(PowerOfTwoKt.getNextPowerOfTwo(minWidth), PowerOfTwoKt.getNextPowerOfTwo(minHeight));
                Iterable $this$any$iv = bmpSlices;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        RectSlice it = (RectSlice)element$iv;
                        boolean bl4 = false;
                        if (!((Bitmap32)it.getBase()).getPremultiplied()) continue;
                        bl = true;
                        break block14;
                    }
                    bl = false;
                }
            }
            boolean premultiplied = bl;
            Bitmap32 out = (Bitmap32)BitmapKt.mipmaps((Bitmap)new Bitmap32(potSize, potSize, null, premultiplied, 4, null), mipmaps);
            IntMap<TileSetTileInfo> texs = new IntMap<TileSetTileInfo>(0, 0.0, 3, null);
            int element$iv = bmpSlices.size();
            for (int n = 0; n < element$iv; ++n) {
                int y = n / columns;
                int x = n % columns;
                int px = x * btilewidth + border;
                int py = y * btileheight + border;
                out.put(bmpSlices.get(n), px, py);
                TileSetTileInfo tileInfo = new TileSetTileInfo(n, BitmapSliceKt.sliceWithSize-dYJqCJA$default(out, px, py, tilewidth, tileheight, bmpSlices.get(n).getName(), 0, null, 96, null), null, null, 12, null);
                texs.set(n, tileInfo);
            }
            for (int x = 0; x < columns; ++x) {
                int px = x * btilewidth + border;
                for (int b = 0; b < border; ++b) {
                    Bitmap32.Companion.copyRect(out, px, 0, out, px - 1 - b, 0, 1, out.getHeight());
                    Bitmap32.Companion.copyRect(out, px + tilewidth - 1, 0, out, px + tilewidth + b, 0, 1, out.getHeight());
                }
            }
            for (int y = 0; y < rows2; ++y) {
                int py = y * btileheight + border;
                for (int b = 0; b < border; ++b) {
                    Bitmap32.Companion.copyRect(out, 0, py, out, 0, py - 1 - b, out.getWidth(), 1);
                    Bitmap32.Companion.copyRect(out, 0, py + tileheight - 1, out, 0, py + tileheight + b, out.getWidth(), 1);
                }
            }
            return new TileSet(texs, tilewidth, tileheight);
        }

        public static /* synthetic */ TileSet fromBitmapSlices$default(Companion companion, int n, int n2, List list2, int n3, boolean bl, int n4, Object object) {
            if ((n4 & 8) != 0) {
                n3 = 1;
            }
            if ((n4 & 0x10) != 0) {
                bl = false;
            }
            return companion.fromBitmapSlices(n, n2, list2, n3, bl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

