/*
 * Decompiled with CFR 0.152.
 */
package korlibs.image.vector;

import java.util.Map;
import korlibs.datastructure.DoubleList;
import korlibs.image.paint.Paint;
import korlibs.image.vector.Context2d;
import korlibs.image.vector.FillShape;
import korlibs.image.vector.ShapeKt;
import korlibs.image.vector.StyledShape;
import korlibs.image.vector.SvgBuilder;
import korlibs.math.IsAlmostEquals;
import korlibs.math.geom.BoundsBuilder;
import korlibs.math.geom.MRectangle;
import korlibs.math.geom.Matrix;
import korlibs.math.geom.RectangleD;
import korlibs.math.geom._MathGeomMutableKt;
import korlibs.math.geom.vector.LineCap;
import korlibs.math.geom.vector.LineJoin;
import korlibs.math.geom.vector.LineScaleMode;
import korlibs.math.geom.vector.StrokeInfo;
import korlibs.math.geom.vector.VectorPath;
import korlibs.math.geom.vector._MathGeom_vector_StrokeToFillKt;
import korlibs.math.geom.vector._MathGeom_vector_VectorPathKt;
import korlibs.number.StringExtKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\t\u0010@\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010A\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010B\u001a\u00020\u0006H\u00c6\u0003J\t\u0010C\u001a\u00020\bH\u00c6\u0003J\t\u0010D\u001a\u00020\nH\u00c6\u0003J\t\u0010E\u001a\u00020\fH\u00c6\u0003J\u0018\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020\f2\u0006\u0010I\u001a\u00020\fH\u0016JG\u0010J\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0010\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020NH\u0016J\u0013\u0010O\u001a\u00020G2\b\u0010P\u001a\u0004\u0018\u00010QH\u00d6\u0003J\u0014\u0010R\u001a\u00060Sj\u0002`T2\u0006\u0010U\u001a\u00020GH\u0016J\u001c\u0010V\u001a\u000e\u0012\u0004\u0012\u00020X\u0012\u0004\u0012\u00020X0W2\u0006\u0010Y\u001a\u00020ZH\u0016J\t\u0010[\u001a\u00020\\H\u00d6\u0001J\u000e\u0010]\u001a\u00020L2\u0006\u0010M\u001a\u00020NJ\t\u0010^\u001a\u00020XH\u00d6\u0001R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0010\u001a\u00020\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0015*\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0016\u001a\u00020\u00178FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001d\u0010\u001e\u001a\u0004\u0018\u00010\u001f8FX\u0086\u0084\u0002\u00a2\u0006\f\u001a\u0004\b!\u0010\"*\u0004\b \u0010\u0013R\u001b\u0010#\u001a\u00020\f8FX\u0086\u0084\u0002\u00a2\u0006\f\u001a\u0004\b%\u0010\u001d*\u0004\b$\u0010\u0013R\u001b\u0010&\u001a\u00020'8FX\u0086\u0084\u0002\u00a2\u0006\f\u001a\u0004\b)\u0010**\u0004\b(\u0010\u0013R\u001b\u0010+\u001a\u00020\f8FX\u0086\u0084\u0002\u00a2\u0006\f\u001a\u0004\b-\u0010\u001d*\u0004\b,\u0010\u0013R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u000fR\u001b\u00101\u001a\u0002028FX\u0086\u0084\u0002\u00a2\u0006\f\u001a\u0004\b4\u00105*\u0004\b3\u0010\u0013R\u001b\u00106\u001a\u00020\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\u001a\u0004\b8\u0010\u0015*\u0004\b7\u0010\u0013R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u001b\u0010;\u001a\u00020\f8FX\u0086\u0084\u0002\u00a2\u0006\f\u001a\u0004\b=\u0010\u001d*\u0004\b<\u0010\u0013R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?\u00a8\u0006_"}, d2={"Lkorlibs/image/vector/PolylineShape;", "Lkorlibs/image/vector/StyledShape;", "path", "Lkorlibs/math/geom/vector/VectorPath;", "clip", "paint", "Lkorlibs/image/paint/Paint;", "transform", "Lkorlibs/math/geom/Matrix;", "strokeInfo", "Lkorlibs/math/geom/vector/StrokeInfo;", "globalAlpha", "", "(Lkorlibs/math/geom/vector/VectorPath;Lkorlibs/math/geom/vector/VectorPath;Lkorlibs/image/paint/Paint;Lkorlibs/math/geom/Matrix;Lkorlibs/math/geom/vector/StrokeInfo;D)V", "getClip", "()Lkorlibs/math/geom/vector/VectorPath;", "endCaps", "Lkorlibs/math/geom/vector/LineCap;", "getEndCaps$delegate", "(Lkorlibs/image/vector/PolylineShape;)Ljava/lang/Object;", "getEndCaps", "()Lkorlibs/math/geom/vector/LineCap;", "fillShape", "Lkorlibs/image/vector/FillShape;", "getFillShape", "()Lkorlibs/image/vector/FillShape;", "fillShape$delegate", "Lkotlin/Lazy;", "getGlobalAlpha", "()D", "lineDash", "Lkorlibs/datastructure/DoubleList;", "getLineDash$delegate", "getLineDash", "()Lkorlibs/datastructure/DoubleList;", "lineDashOffset", "getLineDashOffset$delegate", "getLineDashOffset", "lineJoin", "Lkorlibs/math/geom/vector/LineJoin;", "getLineJoin$delegate", "getLineJoin", "()Lkorlibs/math/geom/vector/LineJoin;", "miterLimit", "getMiterLimit$delegate", "getMiterLimit", "getPaint", "()Lkorlibs/image/paint/Paint;", "getPath", "scaleMode", "Lkorlibs/math/geom/vector/LineScaleMode;", "getScaleMode$delegate", "getScaleMode", "()Lkorlibs/math/geom/vector/LineScaleMode;", "startCaps", "getStartCaps$delegate", "getStartCaps", "getStrokeInfo", "()Lkorlibs/math/geom/vector/StrokeInfo;", "thickness", "getThickness$delegate", "getThickness", "getTransform", "()Lkorlibs/math/geom/Matrix;", "component1", "component2", "component3", "component4", "component5", "component6", "containsPoint", "", "x", "y", "copy", "drawInternal", "", "c", "Lkorlibs/image/vector/Context2d;", "equals", "other", "", "getBounds", "Lkorlibs/math/geom/RectangleD;", "Lkorlibs/math/geom/Rectangle;", "includeStrokes", "getSvgXmlAttributes", "", "", "svg", "Lkorlibs/image/vector/SvgBuilder;", "hashCode", "", "setState", "toString", "korge-core"})
public final class PolylineShape
implements StyledShape {
    @NotNull
    private final VectorPath path;
    @Nullable
    private final VectorPath clip;
    @NotNull
    private final Paint paint;
    @NotNull
    private final Matrix transform;
    @NotNull
    private final StrokeInfo strokeInfo;
    private final double globalAlpha;
    @NotNull
    private final Lazy fillShape$delegate;

    public PolylineShape(@NotNull VectorPath path2, @Nullable VectorPath clip, @NotNull Paint paint2, @NotNull Matrix transform2, @NotNull StrokeInfo strokeInfo, double globalAlpha) {
        this.path = path2;
        this.clip = clip;
        this.paint = paint2;
        this.transform = transform2;
        this.strokeInfo = strokeInfo;
        this.globalAlpha = globalAlpha;
        this.fillShape$delegate = LazyKt.lazy((Function0)new Function0<FillShape>(this){
            final /* synthetic */ PolylineShape this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final FillShape invoke() {
                return new FillShape(_MathGeom_vector_StrokeToFillKt.strokeToFill$default(this.this$0.getPath(), this.this$0.getStrokeInfo(), null, null, 6, null), this.this$0.getClip(), this.this$0.getPaint(), this.this$0.getTransform(), this.this$0.getGlobalAlpha());
            }
        });
    }

    public /* synthetic */ PolylineShape(VectorPath vectorPath, VectorPath vectorPath2, Paint paint2, Matrix matrix2, StrokeInfo strokeInfo, double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            d = 1.0;
        }
        this(vectorPath, vectorPath2, paint2, matrix2, strokeInfo, d);
    }

    @Override
    @NotNull
    public VectorPath getPath() {
        return this.path;
    }

    @Override
    @Nullable
    public VectorPath getClip() {
        return this.clip;
    }

    @Override
    @NotNull
    public Paint getPaint() {
        return this.paint;
    }

    @Override
    @NotNull
    public Matrix getTransform() {
        return this.transform;
    }

    @NotNull
    public final StrokeInfo getStrokeInfo() {
        return this.strokeInfo;
    }

    @Override
    public double getGlobalAlpha() {
        return this.globalAlpha;
    }

    public final double getThickness() {
        return this.strokeInfo.getThickness();
    }

    private static Object getThickness$delegate(PolylineShape polylineShape) {
        return Reflection.property0(new PropertyReference0Impl((Object)polylineShape.strokeInfo, StrokeInfo.class, "thickness", "getThickness()D", 0));
    }

    @NotNull
    public final LineScaleMode getScaleMode() {
        return this.strokeInfo.getScaleMode();
    }

    private static Object getScaleMode$delegate(PolylineShape polylineShape) {
        return Reflection.property0(new PropertyReference0Impl((Object)polylineShape.strokeInfo, StrokeInfo.class, "scaleMode", "getScaleMode()Lkorlibs/math/geom/vector/LineScaleMode;", 0));
    }

    @NotNull
    public final LineCap getStartCaps() {
        return this.strokeInfo.getStartCap();
    }

    private static Object getStartCaps$delegate(PolylineShape polylineShape) {
        return Reflection.property0(new PropertyReference0Impl((Object)polylineShape.strokeInfo, StrokeInfo.class, "startCap", "getStartCap()Lkorlibs/math/geom/vector/LineCap;", 0));
    }

    @NotNull
    public final LineCap getEndCaps() {
        return this.strokeInfo.getEndCap();
    }

    private static Object getEndCaps$delegate(PolylineShape polylineShape) {
        return Reflection.property0(new PropertyReference0Impl((Object)polylineShape.strokeInfo, StrokeInfo.class, "endCap", "getEndCap()Lkorlibs/math/geom/vector/LineCap;", 0));
    }

    @NotNull
    public final LineJoin getLineJoin() {
        return this.strokeInfo.getJoin();
    }

    private static Object getLineJoin$delegate(PolylineShape polylineShape) {
        return Reflection.property0(new PropertyReference0Impl((Object)polylineShape.strokeInfo, StrokeInfo.class, "join", "getJoin()Lkorlibs/math/geom/vector/LineJoin;", 0));
    }

    public final double getMiterLimit() {
        return this.strokeInfo.getMiterLimit();
    }

    private static Object getMiterLimit$delegate(PolylineShape polylineShape) {
        return Reflection.property0(new PropertyReference0Impl((Object)polylineShape.strokeInfo, StrokeInfo.class, "miterLimit", "getMiterLimit()D", 0));
    }

    @Nullable
    public final DoubleList getLineDash() {
        return this.strokeInfo.getDash();
    }

    private static Object getLineDash$delegate(PolylineShape polylineShape) {
        return Reflection.property0(new PropertyReference0Impl((Object)polylineShape.strokeInfo, StrokeInfo.class, "dash", "getDash()Lkorlibs/datastructure/DoubleList;", 0));
    }

    public final double getLineDashOffset() {
        return this.strokeInfo.getDashOffset();
    }

    private static Object getLineDashOffset$delegate(PolylineShape polylineShape) {
        return Reflection.property0(new PropertyReference0Impl((Object)polylineShape.strokeInfo, StrokeInfo.class, "dashOffset", "getDashOffset()D", 0));
    }

    @NotNull
    public final FillShape getFillShape() {
        Lazy lazy = this.fillShape$delegate;
        return (FillShape)lazy.getValue();
    }

    @Override
    @NotNull
    public RectangleD getBounds(boolean includeStrokes) {
        IsAlmostEquals<MRectangle> isAlmostEquals;
        MRectangle bounds2;
        RectangleD rectangleD = BoundsBuilder.boundsOrNull-impl(_MathGeom_vector_VectorPathKt.plus-ykjA0fs(BoundsBuilder.Companion.invoke-1t4xLac(), this.getPath()));
        MRectangle mRectangle = bounds2 = rectangleD != null ? _MathGeomMutableKt.getMutable(rectangleD) : null;
        if (includeStrokes) {
            double halfThickness = Math.max(this.strokeInfo.getThickness() / 2.0, 0.0);
            MRectangle mRectangle2 = bounds2;
            if (mRectangle2 != null) {
                MRectangle.inflate$default(mRectangle2, halfThickness, halfThickness, 0.0, 0.0, 12, null);
            }
        }
        if ((isAlmostEquals = bounds2) == null || (isAlmostEquals = isAlmostEquals.getImmutable()) == null) {
            isAlmostEquals = RectangleD.Companion.getZERO();
        }
        return isAlmostEquals;
    }

    public final void setState(@NotNull Context2d c) {
        c.setLineScaleMode(this.strokeInfo.getScaleMode());
        c.setLineWidth(this.strokeInfo.getThickness());
        c.setStartLineCap(this.strokeInfo.getStartCap());
        c.setEndLineCap(this.strokeInfo.getEndCap());
        c.setLineJoin(this.strokeInfo.getJoin());
        c.setMiterLimit(this.strokeInfo.getMiterLimit());
        c.setLineDash(this.strokeInfo.getDash());
        c.setLineDashOffset(this.strokeInfo.getDashOffset());
    }

    @Override
    public void drawInternal(@NotNull Context2d c) {
        this.setState(c);
        c.stroke(this.getPaint());
    }

    @Override
    public boolean containsPoint(double x, double y) {
        double tx = this.getTransform().transformX(x, y);
        double ty = this.getTransform().transformY(x, y);
        if (this.getClip() != null) {
            return this.getClip().containsPoint(tx, ty);
        }
        return this.getPath().containsPoint(tx, ty);
    }

    @Override
    @NotNull
    public Map<String, String> getSvgXmlAttributes(@NotNull SvgBuilder svg) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("fill", "none"), TuplesKt.to("stroke-width", StringExtKt.niceStr$default(this.strokeInfo.getThickness(), svg.getRoundDecimalPlaces(), false, 2, null)), TuplesKt.to("stroke", ShapeKt.toSvg(this.getPaint(), svg))};
        return MapsKt.plus(StyledShape.DefaultImpls.getSvgXmlAttributes(this, svg), MapsKt.mapOf(pairArray));
    }

    @Override
    @Nullable
    public VectorPath getUntransformedPath() {
        return StyledShape.DefaultImpls.getUntransformedPath(this);
    }

    @Override
    public void buildSvg(@NotNull SvgBuilder svg) {
        StyledShape.DefaultImpls.buildSvg(this, svg);
    }

    @Override
    @NotNull
    public VectorPath getPath(@NotNull VectorPath path2) {
        return StyledShape.DefaultImpls.getPath(this, path2);
    }

    @Override
    public void draw(@NotNull Context2d c) {
        StyledShape.DefaultImpls.draw(this, c);
    }

    @Override
    @NotNull
    public RectangleD getBounds() {
        return StyledShape.DefaultImpls.getBounds(this);
    }

    @Override
    public int getLeft() {
        return StyledShape.DefaultImpls.getLeft(this);
    }

    @Override
    public int getTop() {
        return StyledShape.DefaultImpls.getTop(this);
    }

    @Override
    public int getWidth() {
        return StyledShape.DefaultImpls.getWidth(this);
    }

    @Override
    public int getHeight() {
        return StyledShape.DefaultImpls.getHeight(this);
    }

    @NotNull
    public final VectorPath component1() {
        return this.path;
    }

    @Nullable
    public final VectorPath component2() {
        return this.clip;
    }

    @NotNull
    public final Paint component3() {
        return this.paint;
    }

    @NotNull
    public final Matrix component4() {
        return this.transform;
    }

    @NotNull
    public final StrokeInfo component5() {
        return this.strokeInfo;
    }

    public final double component6() {
        return this.globalAlpha;
    }

    @NotNull
    public final PolylineShape copy(@NotNull VectorPath path2, @Nullable VectorPath clip, @NotNull Paint paint2, @NotNull Matrix transform2, @NotNull StrokeInfo strokeInfo, double globalAlpha) {
        return new PolylineShape(path2, clip, paint2, transform2, strokeInfo, globalAlpha);
    }

    public static /* synthetic */ PolylineShape copy$default(PolylineShape polylineShape, VectorPath vectorPath, VectorPath vectorPath2, Paint paint2, Matrix matrix2, StrokeInfo strokeInfo, double d, int n, Object object) {
        if ((n & 1) != 0) {
            vectorPath = polylineShape.path;
        }
        if ((n & 2) != 0) {
            vectorPath2 = polylineShape.clip;
        }
        if ((n & 4) != 0) {
            paint2 = polylineShape.paint;
        }
        if ((n & 8) != 0) {
            matrix2 = polylineShape.transform;
        }
        if ((n & 0x10) != 0) {
            strokeInfo = polylineShape.strokeInfo;
        }
        if ((n & 0x20) != 0) {
            d = polylineShape.globalAlpha;
        }
        return polylineShape.copy(vectorPath, vectorPath2, paint2, matrix2, strokeInfo, d);
    }

    @NotNull
    public String toString() {
        return "PolylineShape(path=" + this.path + ", clip=" + this.clip + ", paint=" + this.paint + ", transform=" + this.transform + ", strokeInfo=" + this.strokeInfo + ", globalAlpha=" + this.globalAlpha + ")";
    }

    public int hashCode() {
        int result2 = this.path.hashCode();
        result2 = result2 * 31 + (this.clip == null ? 0 : this.clip.hashCode());
        result2 = result2 * 31 + this.paint.hashCode();
        result2 = result2 * 31 + this.transform.hashCode();
        result2 = result2 * 31 + this.strokeInfo.hashCode();
        result2 = result2 * 31 + Double.hashCode(this.globalAlpha);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PolylineShape)) {
            return false;
        }
        PolylineShape polylineShape = (PolylineShape)other;
        if (!Intrinsics.areEqual(this.path, polylineShape.path)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.clip, polylineShape.clip)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.paint, polylineShape.paint)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.transform, polylineShape.transform)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.strokeInfo, polylineShape.strokeInfo)) {
            return false;
        }
        return Double.compare(this.globalAlpha, polylineShape.globalAlpha) == 0;
    }
}

