/*
 * Decompiled with CFR 0.152.
 */
package korlibs.image.vector;

import java.util.List;
import korlibs.math.geom.MPoint;
import korlibs.math.geom.Vector2D;
import korlibs.math.geom.bezier.Bezier;
import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\f\u001a\u00060\rj\u0002`\u000e2\n\u0010\u000f\u001a\u00060\rj\u0002`\u000eJ\u0012\u0010\u0010\u001a\u00020\u00112\n\u0010\u000f\u001a\u00060\rj\u0002`\u000eR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lkorlibs/image/vector/ProjectCurvesLookup;", "", "beziers", "", "Lkorlibs/math/geom/bezier/Bezier;", "(Ljava/util/List;)V", "getBeziers", "()Ljava/util/List;", "tempPoint", "Lkorlibs/math/geom/MPoint;", "tempProjected", "Lkorlibs/math/geom/bezier/Bezier$ProjectedPoint;", "closest", "Lkorlibs/math/geom/Vector2D;", "Lkorlibs/math/geom/Point;", "point", "closestDistance", "", "korge-core"})
@SourceDebugExtension(value={"SMAP\nSDF.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SDF.kt\nkorlibs/image/vector/ProjectCurvesLookup\n+ 2 _Datastructure_iterators.kt\nkorlibs/datastructure/iterators/_Datastructure_iteratorsKt\n*L\n1#1,166:1\n61#2,3:167\n61#2,3:170\n*S KotlinDebug\n*F\n+ 1 SDF.kt\nkorlibs/image/vector/ProjectCurvesLookup\n*L\n141#1:167,3\n154#1:170,3\n*E\n"})
public final class ProjectCurvesLookup {
    @NotNull
    private final List<Bezier> beziers;
    @NotNull
    private final Bezier.ProjectedPoint tempProjected;
    @NotNull
    private final MPoint tempPoint;

    public ProjectCurvesLookup(@NotNull List<Bezier> beziers) {
        this.beziers = beziers;
        this.tempProjected = new Bezier.ProjectedPoint(null, 0.0, 0.0, 7, null);
        this.tempPoint = MPoint.Companion.invoke();
    }

    @NotNull
    public final List<Bezier> getBeziers() {
        return this.beziers;
    }

    public final double closestDistance(@NotNull Vector2D point2) {
        return Vector2D.Companion.distance(point2, this.closest(point2));
    }

    @NotNull
    public final Vector2D closest(@NotNull Vector2D point2) {
        if (this.beziers.isEmpty()) {
            return new Vector2D(0, 0);
        }
        double minDistSq = 0.0;
        minDistSq = Double.POSITIVE_INFINITY;
        List<Bezier> $this$fastForEach$iv = this.beziers;
        boolean $i$f$fastForEach = false;
        int n$iv = 0;
        while (n$iv < $this$fastForEach$iv.size()) {
            Bezier it = $this$fastForEach$iv.get(n$iv++);
            boolean bl = false;
            double dist = it.getOuterCircle().distanceFarthestSquared(point2);
            if (!(dist < minDistSq)) continue;
            minDistSq = dist;
        }
        double bminDistSq = 0.0;
        bminDistSq = Double.POSITIVE_INFINITY;
        Vector2D out = null;
        out = new Vector2D();
        List<Bezier> $this$fastForEach$iv2 = this.beziers;
        boolean $i$f$fastForEach2 = false;
        int n$iv2 = 0;
        while (n$iv2 < $this$fastForEach$iv2.size()) {
            Bezier it = $this$fastForEach$iv2.get(n$iv2++);
            boolean bl = false;
            if (it.getOuterCircle().distanceClosestSquared(point2) > minDistSq) continue;
            it.project(point2, this.tempProjected);
            if (!(this.tempProjected.getDSq() < bminDistSq)) continue;
            bminDistSq = this.tempProjected.getDSq();
            out = this.tempProjected.getP();
        }
        return out;
    }
}

