/*
 * Decompiled with CFR 0.152.
 */
package korlibs.image.vector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import korlibs.datastructure.DoubleList;
import korlibs.image.bitmap.Bitmap;
import korlibs.image.font.Font;
import korlibs.image.font.FontRegistry;
import korlibs.image.paint.BitmapPaint;
import korlibs.image.paint.Paint;
import korlibs.image.vector.CompositeOperation;
import korlibs.image.vector.CompoundShape;
import korlibs.image.vector.Context2d;
import korlibs.image.vector.Drawable;
import korlibs.image.vector.FillShape;
import korlibs.image.vector.PolylineShape;
import korlibs.image.vector.Shape;
import korlibs.image.vector.TextShape;
import korlibs.image.vector.renderer.DummyRenderer;
import korlibs.math.geom.Matrix;
import korlibs.math.geom.Size2D;
import korlibs.math.geom.SizeKt;
import korlibs.math.geom.Vector2D;
import korlibs.math.geom.vector.LineCap;
import korlibs.math.geom.vector.LineJoin;
import korlibs.math.geom.vector.LineScaleMode;
import korlibs.math.geom.vector.StrokeInfo;
import korlibs.math.geom.vector.VectorPath;
import korlibs.math.geom.vector.Winding;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0012\u001a\u00020\u000eJ\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0001H\u0016J\b\u0010\u0017\u001a\u00020\u0014H\u0014J\b\u0010\u0018\u001a\u00020\u0004H\u0014J\b\u0010\u0019\u001a\u00020\u0014H\u0014J0\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001c2\n\u0010\u001d\u001a\u00060\u001ej\u0002`\u001f2\n\u0010 \u001a\u00060!j\u0002`\"2\u0006\u0010#\u001a\u00020$H\u0014J\"\u0010%\u001a\u00020\u00142\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+H\u0014J>\u0010,\u001a\u00020\u00142\u0006\u0010&\u001a\u00020'2\b\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\n\u0010\u001d\u001a\u00060\u001ej\u0002`\u001f2\u0006\u0010(\u001a\u00020)H\u0014R\u0014\u0010\u0007\u001a\u00020\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR!\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u00063"}, d2={"Lkorlibs/image/vector/ShapeBuilder;", "Lkorlibs/image/vector/Context2d;", "Lkorlibs/image/vector/Drawable;", "width", "", "height", "(Ljava/lang/Integer;Ljava/lang/Integer;)V", "rendererHeight", "getRendererHeight", "()I", "rendererWidth", "getRendererWidth", "shapes", "Ljava/util/ArrayList;", "Lkorlibs/image/vector/Shape;", "Lkotlin/collections/ArrayList;", "getShapes", "()Ljava/util/ArrayList;", "buildShape", "clear", "", "draw", "c", "rendererBufferingEnd", "rendererBufferingStart", "rendererDispose", "rendererDrawImage", "image", "Lkorlibs/image/bitmap/Bitmap;", "pos", "Lkorlibs/math/geom/Vector2D;", "Lkorlibs/math/geom/Point;", "size", "Lkorlibs/math/geom/Size2D;", "Lkorlibs/math/geom/Size;", "transform", "Lkorlibs/math/geom/Matrix;", "rendererRender", "state", "Lkorlibs/image/vector/Context2d$State;", "fill", "", "winding", "Lkorlibs/math/geom/vector/Winding;", "rendererRenderSystemText", "font", "Lkorlibs/image/font/Font;", "fontSize", "", "text", "", "korge-core"})
@SourceDebugExtension(value={"SMAP\nShapeBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShapeBuilder.kt\nkorlibs/image/vector/ShapeBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,126:1\n1#2:127\n*E\n"})
public class ShapeBuilder
extends Context2d
implements Drawable {
    private final int rendererWidth;
    private final int rendererHeight;
    @NotNull
    private final ArrayList<Shape> shapes;

    public ShapeBuilder(@Nullable Integer width2, @Nullable Integer height2) {
        super(DummyRenderer.Companion, null, null, 6, null);
        Integer n = width2;
        this.rendererWidth = n != null ? n : 256;
        Integer n2 = height2;
        this.rendererHeight = n2 != null ? n2 : 256;
        this.shapes = new ArrayList();
    }

    @Override
    protected int getRendererWidth() {
        return this.rendererWidth;
    }

    @Override
    protected int getRendererHeight() {
        return this.rendererHeight;
    }

    @NotNull
    public final ArrayList<Shape> getShapes() {
        return this.shapes;
    }

    @Override
    protected void rendererRender(@NotNull Context2d.State state2, boolean fill, @Nullable Winding winding) {
        VectorPath vectorPath;
        VectorPath vectorPath2;
        if (state2.getPath().isEmpty()) {
            return;
        }
        VectorPath it = vectorPath2 = state2.getPath().clone();
        boolean bl = false;
        Winding winding2 = winding;
        if (winding2 == null) {
            winding2 = it.getWinding();
        }
        it.setWinding(winding2);
        VectorPath path2 = vectorPath2;
        VectorPath vectorPath3 = state2.getClip();
        if (vectorPath3 != null && (vectorPath3 = vectorPath3.clone()) != null) {
            VectorPath vectorPath4;
            VectorPath it2 = vectorPath4 = vectorPath3;
            boolean bl2 = false;
            Winding winding3 = winding;
            if (winding3 == null) {
                winding3 = it2.getWinding();
            }
            it2.setWinding(winding3);
            vectorPath = vectorPath4;
        } else {
            vectorPath = null;
        }
        VectorPath clip = vectorPath;
        Matrix transform2 = state2.getTransform();
        if (fill) {
            ((Collection)this.shapes).add(new FillShape(path2, clip, state2.getFillStyle().clone(), transform2, state2.getGlobalAlpha()));
        } else {
            Collection collection = this.shapes;
            double d = state2.getLineWidth();
            LineScaleMode lineScaleMode = state2.getLineScaleMode();
            LineCap lineCap = state2.getStartLineCap();
            LineCap lineCap2 = state2.getEndLineCap();
            LineJoin lineJoin = state2.getLineJoin();
            DoubleList doubleList = state2.getLineDash();
            double d2 = state2.getLineDashOffset();
            double d3 = state2.getMiterLimit();
            collection.add(new PolylineShape(path2, clip, state2.getStrokeStyle().clone(), transform2, new StrokeInfo(d, true, lineScaleMode, lineCap, lineCap2, lineJoin, d3, doubleList, d2), state2.getGlobalAlpha()));
        }
    }

    @Override
    protected void rendererRenderSystemText(@NotNull Context2d.State state2, @Nullable Font font, double fontSize, @NotNull String text2, @NotNull Vector2D pos, boolean fill) {
        Collection collection = this.shapes;
        VectorPath vectorPath = state2.getClip();
        collection.add(new TextShape(text2, pos, font, fontSize, vectorPath != null ? vectorPath.clone() : null, fill ? state2.getFillStyle() : null, fill ? null : state2.getStrokeStyle(), state2.getAlignment(), state2.getTransform(), 0.0, 512, null));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void rendererDrawImage(@NotNull Bitmap image2, @NotNull Vector2D pos, @NotNull Size2D size2, @NotNull Matrix transform2) {
        void $this$rendererDrawImage_u24lambda_u242;
        VectorPath vectorPath;
        VectorPath vectorPath2 = vectorPath = new VectorPath(null, null, null, false, 15, null);
        VectorPath vectorPath3 = null;
        Matrix matrix2 = transform2;
        Context2d context2d = this;
        boolean bl = false;
        $this$rendererDrawImage_u24lambda_u242.rect(pos, size2);
        Unit unit = Unit.INSTANCE;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 1047546;
        double d = 0.0;
        DoubleList doubleList = null;
        CompositeOperation compositeOperation = null;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        Font font = null;
        FontRegistry fontRegistry = null;
        Paint paint2 = new BitmapPaint(image2, Matrix.Companion.getIDENTITY().scaled(size2.div(SizeKt.toFloat(image2.getSize()))).translated(pos), null, null, false, null, 60, null);
        Paint paint3 = null;
        double d6 = 0.0;
        LineJoin lineJoin = null;
        LineCap lineCap = null;
        LineCap lineCap2 = null;
        double d7 = 0.0;
        LineScaleMode lineScaleMode = null;
        VectorPath vectorPath4 = vectorPath;
        VectorPath vectorPath5 = vectorPath3;
        Matrix matrix3 = matrix2;
        Context2d.rendererRender$default(context2d, new Context2d.State(matrix3, vectorPath5, vectorPath4, lineScaleMode, d7, lineCap2, lineCap, lineJoin, d6, paint3, paint2, fontRegistry, font, d5, d4, d3, d2, compositeOperation, doubleList, d, n, defaultConstructorMarker), true, null, 4, null);
    }

    @Override
    protected void rendererDispose() {
    }

    @Override
    protected int rendererBufferingStart() {
        return 0;
    }

    @Override
    protected void rendererBufferingEnd() {
    }

    public final void clear() {
        this.getState().clone();
        this.shapes.clear();
    }

    @NotNull
    public final Shape buildShape() {
        return this.shapes.size() == 1 ? (Shape)CollectionsKt.first((List)this.shapes) : (Shape)new CompoundShape(CollectionsKt.toList((Iterable)this.shapes));
    }

    @Override
    public void draw(@NotNull Context2d c) {
        c.draw(this.buildShape());
    }
}

