/*
 * Decompiled with CFR 0.152.
 */
package korlibs.image.vector;

import java.util.Collection;
import java.util.Map;
import korlibs.image.font.Font;
import korlibs.image.font.FontKt;
import korlibs.image.paint.NonePaint;
import korlibs.image.paint.Paint;
import korlibs.image.text.HorizontalAlign;
import korlibs.image.text.TextAlignment;
import korlibs.image.text.VerticalAlign;
import korlibs.image.vector.Context2d;
import korlibs.image.vector.Shape;
import korlibs.image.vector.ShapeBuilder;
import korlibs.image.vector.ShapeKt;
import korlibs.image.vector.StyledShape;
import korlibs.image.vector.SvgBuilder;
import korlibs.io.serialization.xml.Xml;
import korlibs.math.geom.Matrix;
import korlibs.math.geom.RectangleD;
import korlibs.math.geom.Vector2D;
import korlibs.math.geom._MathGeomMutableKt;
import korlibs.math.geom.vector.VectorPath;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001Bg\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u0012\b\b\u0002\u0010\u0014\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0015J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0016J\u0010\u00104\u001a\u0002012\u0006\u00105\u001a\u000206H\u0016J\u0014\u00107\u001a\u000608j\u0002`92\u0006\u0010:\u001a\u00020;H\u0016R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\u0014\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001fR\u0014\u0010!\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001bR\u0015\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001b\u0010%\u001a\u00020&8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010*\u001a\u0004\b'\u0010(R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/\u00a8\u0006<"}, d2={"Lkorlibs/image/vector/TextShape;", "Lkorlibs/image/vector/StyledShape;", "text", "", "pos", "Lkorlibs/math/geom/Vector2D;", "Lkorlibs/math/geom/Point;", "font", "Lkorlibs/image/font/Font;", "fontSize", "", "clip", "Lkorlibs/math/geom/vector/VectorPath;", "fill", "Lkorlibs/image/paint/Paint;", "stroke", "align", "Lkorlibs/image/text/TextAlignment;", "transform", "Lkorlibs/math/geom/Matrix;", "globalAlpha", "(Ljava/lang/String;Lkorlibs/math/geom/Vector2D;Lkorlibs/image/font/Font;DLkorlibs/math/geom/vector/VectorPath;Lkorlibs/image/paint/Paint;Lkorlibs/image/paint/Paint;Lkorlibs/image/text/TextAlignment;Lkorlibs/math/geom/Matrix;D)V", "getAlign", "()Lkorlibs/image/text/TextAlignment;", "getClip", "()Lkorlibs/math/geom/vector/VectorPath;", "getFill", "()Lkorlibs/image/paint/Paint;", "getFont", "()Lkorlibs/image/font/Font;", "getFontSize", "()D", "getGlobalAlpha", "paint", "getPaint", "getPos", "()Lkorlibs/math/geom/Vector2D;", "primitiveShapes", "Lkorlibs/image/vector/Shape;", "getPrimitiveShapes", "()Lkorlibs/image/vector/Shape;", "primitiveShapes$delegate", "Lkotlin/Lazy;", "getStroke", "getText", "()Ljava/lang/String;", "getTransform", "()Lkorlibs/math/geom/Matrix;", "buildSvg", "", "svg", "Lkorlibs/image/vector/SvgBuilder;", "drawInternal", "c", "Lkorlibs/image/vector/Context2d;", "getBounds", "Lkorlibs/math/geom/RectangleD;", "Lkorlibs/math/geom/Rectangle;", "includeStrokes", "", "korge-core"})
@SourceDebugExtension(value={"SMAP\nShape.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Shape.kt\nkorlibs/image/vector/TextShape\n+ 2 Context2d.kt\nkorlibs/image/vector/Context2d\n*L\n1#1,520:1\n223#2,20:521\n*S KotlinDebug\n*F\n+ 1 Shape.kt\nkorlibs/image/vector/TextShape\n*L\n433#1:521,20\n*E\n"})
public final class TextShape
implements StyledShape {
    @NotNull
    private final String text;
    @NotNull
    private final Vector2D pos;
    @Nullable
    private final Font font;
    private final double fontSize;
    @Nullable
    private final VectorPath clip;
    @Nullable
    private final Paint fill;
    @Nullable
    private final Paint stroke;
    @NotNull
    private final TextAlignment align;
    @NotNull
    private final Matrix transform;
    private final double globalAlpha;
    @NotNull
    private final Lazy primitiveShapes$delegate;

    public TextShape(@NotNull String text2, @NotNull Vector2D pos, @Nullable Font font, double fontSize, @Nullable VectorPath clip, @Nullable Paint fill, @Nullable Paint stroke2, @NotNull TextAlignment align, @NotNull Matrix transform2, double globalAlpha) {
        this.text = text2;
        this.pos = pos;
        this.font = font;
        this.fontSize = fontSize;
        this.clip = clip;
        this.fill = fill;
        this.stroke = stroke2;
        this.align = align;
        this.transform = transform2;
        this.globalAlpha = globalAlpha;
        this.primitiveShapes$delegate = LazyKt.lazy((Function0)new Function0<Shape>(this){
            final /* synthetic */ TextShape this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Shape invoke() {
                ShapeBuilder shapeBuilder;
                block3: {
                    TextShape textShape = this.this$0;
                    Integer width$iv = null;
                    Integer height$iv = null;
                    boolean $i$f$buildShape = false;
                    ShapeBuilder $this$invoke_u24lambda_u240 = shapeBuilder = new ShapeBuilder(width$iv, height$iv);
                    boolean bl = false;
                    $this$invoke_u24lambda_u240.transform(_MathGeomMutableKt.getImmutable(textShape.getTransform()));
                    Context2d.clip$default($this$invoke_u24lambda_u240, textShape.getClip(), null, 2, null);
                    if (textShape.getFill() != null) {
                        Font font = textShape.getFont();
                        if (font != null) {
                            FontKt.drawText$default(font, $this$invoke_u24lambda_u240, textShape.getFontSize(), textShape.getText(), textShape.getFill(), textShape.getPos(), true, null, null, null, null, null, 0, 0, null, 16320, null);
                        }
                    }
                    if (textShape.getStroke() == null) break block3;
                    Font font = textShape.getFont();
                    if (font != null) {
                        FontKt.drawText$default(font, $this$invoke_u24lambda_u240, textShape.getFontSize(), textShape.getText(), textShape.getStroke(), textShape.getPos(), false, null, null, null, null, null, 0, 0, null, 16320, null);
                    }
                }
                return shapeBuilder.buildShape();
            }
        });
    }

    public /* synthetic */ TextShape(String string, Vector2D vector2D, Font font, double d, VectorPath vectorPath, Paint paint2, Paint paint3, TextAlignment textAlignment, Matrix matrix2, double d2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x80) != 0) {
            textAlignment = TextAlignment.Companion.getTOP_LEFT();
        }
        if ((n & 0x100) != 0) {
            matrix2 = Matrix.Companion.getIDENTITY();
        }
        if ((n & 0x200) != 0) {
            d2 = 1.0;
        }
        this(string, vector2D, font, d, vectorPath, paint2, paint3, textAlignment, matrix2, d2);
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final Vector2D getPos() {
        return this.pos;
    }

    @Nullable
    public final Font getFont() {
        return this.font;
    }

    public final double getFontSize() {
        return this.fontSize;
    }

    @Override
    @Nullable
    public VectorPath getClip() {
        return this.clip;
    }

    @Nullable
    public final Paint getFill() {
        return this.fill;
    }

    @Nullable
    public final Paint getStroke() {
        return this.stroke;
    }

    @NotNull
    public final TextAlignment getAlign() {
        return this.align;
    }

    @Override
    @NotNull
    public Matrix getTransform() {
        return this.transform;
    }

    @Override
    public double getGlobalAlpha() {
        return this.globalAlpha;
    }

    @Override
    @NotNull
    public Paint getPaint() {
        Paint paint2 = this.fill;
        if (paint2 == null && (paint2 = this.stroke) == null) {
            paint2 = NonePaint.INSTANCE;
        }
        return paint2;
    }

    @Override
    @NotNull
    public RectangleD getBounds(boolean includeStrokes) {
        return RectangleD.Companion.fromBounds(this.pos, new Vector2D(this.pos.getX() + this.fontSize * (double)this.text.length(), this.pos.getY() + this.fontSize));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void drawInternal(@NotNull Context2d c) {
        Font font = this.font;
        TextAlignment align$iv = this.align;
        double size$iv = c.getFontSize();
        boolean $i$f$font = false;
        Font oldFont$iv = c.getFont();
        double oldFontSize$iv = c.getFontSize();
        TextAlignment oldAlign$iv = c.getAlignment();
        try {
            void font$iv;
            c.setFont((Font)font$iv);
            c.setFontSize(size$iv);
            c.setAlignment(align$iv);
            boolean bl = false;
            if (this.fill != null) {
                c.fillText(this.text, this.pos);
            }
            if (this.stroke != null) {
                c.strokeText(this.text, this.pos);
            }
        }
        finally {
            c.setFont(oldFont$iv);
            c.setFontSize(oldFontSize$iv);
            c.setAlignment(oldAlign$iv);
        }
    }

    @NotNull
    public final Shape getPrimitiveShapes() {
        Lazy lazy = this.primitiveShapes$delegate;
        return (Shape)lazy.getValue();
    }

    @Override
    public void buildSvg(@NotNull SvgBuilder svg) {
        Collection collection = svg.getNodes();
        Pair[] pairArray = new Pair[9];
        pairArray[0] = TuplesKt.to("x", this.pos.getX());
        pairArray[1] = TuplesKt.to("y", this.pos.getY());
        Object object = this.fill;
        if (object == null || (object = ShapeKt.toSvg((Paint)object, svg)) == null) {
            object = "none";
        }
        pairArray[2] = TuplesKt.to("fill", object);
        Object object2 = this.stroke;
        if (object2 == null || (object2 = ShapeKt.toSvg((Paint)object2, svg)) == null) {
            object2 = "none";
        }
        pairArray[3] = TuplesKt.to("stroke", object2);
        Font font = this.font;
        pairArray[4] = TuplesKt.to("font-family", font != null ? font.getName() : null);
        pairArray[5] = TuplesKt.to("font-size", this.fontSize + "px");
        double d = this.align.getHorizontal-v5wk5Pc();
        pairArray[6] = TuplesKt.to("text-anchor", HorizontalAlign.equals-impl0(d, HorizontalAlign.Companion.getJUSTIFY-v5wk5Pc()) ? "justify" : (HorizontalAlign.equals-impl0(d, HorizontalAlign.Companion.getLEFT-v5wk5Pc()) ? "start" : (HorizontalAlign.equals-impl0(d, HorizontalAlign.Companion.getCENTER-v5wk5Pc()) ? "middle" : (HorizontalAlign.equals-impl0(d, HorizontalAlign.Companion.getRIGHT-v5wk5Pc()) ? "end" : this.align.getHorizontal-v5wk5Pc() * (double)100 + "%"))));
        d = this.align.getVertical-wm9RW30();
        pairArray[7] = TuplesKt.to("alignment-baseline", VerticalAlign.equals-impl0(d, VerticalAlign.Companion.getTOP-wm9RW30()) ? "hanging" : (VerticalAlign.equals-impl0(d, VerticalAlign.Companion.getMIDDLE-wm9RW30()) ? "middle" : (VerticalAlign.equals-impl0(d, VerticalAlign.Companion.getBASELINE-wm9RW30()) ? "baseline" : (VerticalAlign.equals-impl0(d, VerticalAlign.Companion.getBOTTOM-wm9RW30()) ? "bottom" : this.align.getVertical-wm9RW30() * (double)100 + "%"))));
        pairArray[8] = TuplesKt.to("transform", ShapeKt.toSvg$default(this.getTransform(), 0, 1, null));
        collection.add(Xml.Companion.Tag("text", MapsKt.mapOf(pairArray), CollectionsKt.listOf(Xml.Companion.Text(this.text))));
    }

    @Override
    @Nullable
    public VectorPath getPath() {
        return StyledShape.DefaultImpls.getPath(this);
    }

    @Override
    @Nullable
    public VectorPath getUntransformedPath() {
        return StyledShape.DefaultImpls.getUntransformedPath(this);
    }

    @Override
    @NotNull
    public VectorPath getPath(@NotNull VectorPath path2) {
        return StyledShape.DefaultImpls.getPath(this, path2);
    }

    @Override
    @NotNull
    public Map<String, String> getSvgXmlAttributes(@NotNull SvgBuilder svg) {
        return StyledShape.DefaultImpls.getSvgXmlAttributes(this, svg);
    }

    @Override
    public void draw(@NotNull Context2d c) {
        StyledShape.DefaultImpls.draw(this, c);
    }

    @Override
    @NotNull
    public RectangleD getBounds() {
        return StyledShape.DefaultImpls.getBounds(this);
    }

    @Override
    public boolean containsPoint(double x, double y) {
        return StyledShape.DefaultImpls.containsPoint(this, x, y);
    }

    @Override
    public int getLeft() {
        return StyledShape.DefaultImpls.getLeft(this);
    }

    @Override
    public int getTop() {
        return StyledShape.DefaultImpls.getTop(this);
    }

    @Override
    public int getWidth() {
        return StyledShape.DefaultImpls.getWidth(this);
    }

    @Override
    public int getHeight() {
        return StyledShape.DefaultImpls.getHeight(this);
    }
}

