/*
 * Decompiled with CFR 0.152.
 */
package korlibs.image.vector.rasterizer;

import korlibs.datastructure.IntArrayList;
import korlibs.math.geom.RectangleD;
import korlibs.math.geom.vector.PolygonScanline;
import korlibs.math.geom.vector.RastScale;
import korlibs.math.geom.vector.Winding;
import korlibs.math.segment.IntSegmentSet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u00010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0083\u0001\u0010\u001e\u001a\u00020\u001f2\n\u0010 \u001a\u00060!j\u0002`\"2\b\b\u0002\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$2\b\b\u0002\u0010%\u001a\u00020&2O\u0010'\u001aK\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b)\u0012\b\b*\u0012\u0004\b\b(+\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b)\u0012\b\b*\u0012\u0004\b\b(,\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b)\u0012\b\b*\u0012\u0004\b\b(-\u0012\u0004\u0012\u00020\u001f0(j\u0002`.J\u0006\u0010/\u001a\u00020\u001fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0016\"\u0004\b\u001b\u0010\u0018R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lkorlibs/image/vector/rasterizer/Rasterizer;", "Lkorlibs/math/geom/vector/RastScale;", "()V", "clip", "Lkorlibs/math/geom/vector/PolygonScanline;", "getClip", "()Lkorlibs/math/geom/vector/PolygonScanline;", "clipSegmentSet", "Lkorlibs/math/segment/IntSegmentSet;", "debug", "", "getDebug", "()Z", "setDebug", "(Z)V", "fillSegmentSet", "finalSegmentSet", "path", "getPath", "quality", "", "getQuality", "()I", "setQuality", "(I)V", "scale", "getScale", "setScale", "yList", "Lkorlibs/datastructure/IntArrayList;", "rasterizeFill", "", "bounds", "Lkorlibs/math/geom/RectangleD;", "Lkorlibs/math/geom/Rectangle;", "stats", "Lkorlibs/image/vector/rasterizer/Rasterizer$Stats;", "winding", "Lkorlibs/math/geom/vector/Winding;", "callback", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "x0", "x1", "y", "Lkorlibs/image/vector/rasterizer/RasterizerCallback;", "reset", "Stats", "korge-core"})
@SourceDebugExtension(value={"SMAP\nRasterizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Rasterizer.kt\nkorlibs/image/vector/rasterizer/Rasterizer\n+ 2 _Datastructure_iterators.kt\nkorlibs/datastructure/iterators/_Datastructure_iteratorsKt\n+ 3 _Math_segment.kt\nkorlibs/math/segment/IntSegmentSet\n*L\n1#1,117:1\n86#2,3:118\n90#2:123\n51#3,2:121\n*S KotlinDebug\n*F\n+ 1 Rasterizer.kt\nkorlibs/image/vector/rasterizer/Rasterizer\n*L\n96#1:118,3\n96#1:123\n107#1:121,2\n*E\n"})
public final class Rasterizer
extends RastScale {
    private boolean debug;
    private int quality = 2;
    private int scale = 1;
    @NotNull
    private final PolygonScanline path = new PolygonScanline();
    @NotNull
    private final PolygonScanline clip = new PolygonScanline();
    @NotNull
    private final IntSegmentSet fillSegmentSet = new IntSegmentSet();
    @NotNull
    private final IntSegmentSet clipSegmentSet = new IntSegmentSet();
    @NotNull
    private final IntSegmentSet finalSegmentSet = new IntSegmentSet();
    @NotNull
    private final IntArrayList yList = new IntArrayList(1024);

    public final boolean getDebug() {
        return this.debug;
    }

    public final void setDebug(boolean bl) {
        this.debug = bl;
    }

    public final int getQuality() {
        return this.quality;
    }

    public final void setQuality(int n) {
        this.quality = n;
    }

    public final int getScale() {
        return this.scale;
    }

    public final void setScale(int n) {
        this.scale = n;
    }

    @NotNull
    public final PolygonScanline getPath() {
        return this.path;
    }

    @NotNull
    public final PolygonScanline getClip() {
        return this.clip;
    }

    public final void reset() {
        this.path.reset();
        this.clip.reset();
    }

    /*
     * WARNING - void declaration
     */
    public final void rasterizeFill(@NotNull RectangleD bounds2, int quality, @Nullable Stats stats, @NotNull Winding winding, @NotNull Function3<? super Integer, ? super Integer, ? super Integer, Unit> callback) {
        block5: {
            Stats stats2 = stats;
            if (stats2 != null) {
                stats2.reset();
            }
            int xmin = this.getS(bounds2.getLeft());
            int xmax = this.getS(bounds2.getRight());
            RectangleD tempRect = this.path.getBounds();
            int startY = this.getS(Math.max(bounds2.getTop(), tempRect.getTop()));
            int endY = this.getS(Math.min(bounds2.getBottom(), tempRect.getBottom()));
            Function3 func2 = new Function3<Integer, Integer, Integer, Unit>(xmax, xmin, this, callback){
                final /* synthetic */ int $xmax;
                final /* synthetic */ int $xmin;
                final /* synthetic */ Rasterizer this$0;
                final /* synthetic */ Function3<Integer, Integer, Integer, Unit> $callback;
                {
                    this.$xmax = $xmax;
                    this.$xmin = $xmin;
                    this.this$0 = $receiver;
                    this.$callback = $callback;
                    super(3);
                }

                public final void invoke(int a, int b, int y) {
                    if (a <= this.$xmax && b >= this.$xmin) {
                        int a0 = RangesKt.coerceIn(a, this.$xmin, this.$xmax);
                        int b0 = RangesKt.coerceIn(b, this.$xmin, this.$xmax);
                        if (this.this$0.getDebug()) {
                            System.out.println((Object)("RASTER(" + a0 + ", " + b0 + ", " + y + ")"));
                        }
                        this.$callback.invoke(a0, b0, y);
                    }
                }
            };
            this.yList.clear();
            int q = quality;
            int yCount = ((endY - startY) / this.getSscale() + 1) * q;
            int n = yCount + q - 1;
            for (int n2 = 0; n2 < n; ++n2) {
                int y = startY + n2 * this.getSscale() / this.scale / q;
                this.yList.add(y);
            }
            Rasterizer $this$rasterizeFill_u24lambda_u242 = this;
            boolean bl = false;
            int edgesEmitted = 0;
            int edgesChecked = 0;
            IntArrayList $this$fastForEach$iv = $this$rasterizeFill_u24lambda_u242.yList;
            boolean $i$f$fastForEach = false;
            int n$iv = 0;
            while (n$iv < $this$fastForEach$iv.size()) {
                int y = $this$fastForEach$iv.getAt(n$iv++);
                boolean bl2 = false;
                $this$rasterizeFill_u24lambda_u242.path.scanline(y, winding, $this$rasterizeFill_u24lambda_u242.fillSegmentSet);
                edgesChecked += $this$rasterizeFill_u24lambda_u242.path.getEdgesChecked();
                if ($this$rasterizeFill_u24lambda_u242.clip.isNotEmpty()) {
                    $this$rasterizeFill_u24lambda_u242.clip.scanline(y, $this$rasterizeFill_u24lambda_u242.clip.getWinding(), $this$rasterizeFill_u24lambda_u242.clipSegmentSet);
                    edgesChecked += $this$rasterizeFill_u24lambda_u242.clip.getEdgesChecked();
                    $this$rasterizeFill_u24lambda_u242.finalSegmentSet.setToIntersect($this$rasterizeFill_u24lambda_u242.fillSegmentSet, $this$rasterizeFill_u24lambda_u242.clipSegmentSet);
                }
                IntSegmentSet this_$iv = $this$rasterizeFill_u24lambda_u242.clip.isNotEmpty() ? $this$rasterizeFill_u24lambda_u242.finalSegmentSet : $this$rasterizeFill_u24lambda_u242.fillSegmentSet;
                boolean $i$f$fastForEach2 = false;
                int n3 = this_$iv.getSize();
                for (int n$iv2 = 0; n$iv2 < n3; ++n$iv2) {
                    void max;
                    int n4 = this_$iv.getMax().getAt(n$iv2);
                    int min = this_$iv.getMin().getAt(n$iv2);
                    boolean bl3 = false;
                    func2.invoke(min, (int)max, y);
                    ++edgesEmitted;
                }
            }
            Stats stats3 = stats;
            if (stats3 == null) break block5;
            stats3.chunk(edgesChecked, edgesEmitted, yCount);
        }
    }

    public static /* synthetic */ void rasterizeFill$default(Rasterizer rasterizer, RectangleD rectangleD, int n, Stats stats, Winding winding, Function3 function3, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = rasterizer.quality;
        }
        if ((n2 & 4) != 0) {
            stats = null;
        }
        if ((n2 & 8) != 0) {
            winding = Winding.NON_ZERO;
        }
        rasterizer.rasterizeFill(rectangleD, n, stats, winding, function3);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001J\u0006\u0010\u0019\u001a\u00020\u0010J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\nR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\b\"\u0004\b\u000e\u0010\n\u00a8\u0006\u001c"}, d2={"Lkorlibs/image/vector/rasterizer/Rasterizer$Stats;", "", "edgesChecked", "", "edgesEmitted", "yCount", "(III)V", "getEdgesChecked", "()I", "setEdgesChecked", "(I)V", "getEdgesEmitted", "setEdgesEmitted", "getYCount", "setYCount", "chunk", "", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "reset", "toString", "", "korge-core"})
    public static final class Stats {
        private int edgesChecked;
        private int edgesEmitted;
        private int yCount;

        public Stats(int edgesChecked, int edgesEmitted, int yCount) {
            this.edgesChecked = edgesChecked;
            this.edgesEmitted = edgesEmitted;
            this.yCount = yCount;
        }

        public /* synthetic */ Stats(int n, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 1) != 0) {
                n = 0;
            }
            if ((n4 & 2) != 0) {
                n2 = 0;
            }
            if ((n4 & 4) != 0) {
                n3 = 0;
            }
            this(n, n2, n3);
        }

        public final int getEdgesChecked() {
            return this.edgesChecked;
        }

        public final void setEdgesChecked(int n) {
            this.edgesChecked = n;
        }

        public final int getEdgesEmitted() {
            return this.edgesEmitted;
        }

        public final void setEdgesEmitted(int n) {
            this.edgesEmitted = n;
        }

        public final int getYCount() {
            return this.yCount;
        }

        public final void setYCount(int n) {
            this.yCount = n;
        }

        public final void reset() {
            this.edgesChecked = 0;
            this.edgesEmitted = 0;
            this.yCount = 0;
        }

        public final void chunk(int edgesChecked, int edgesEmitted, int yCount) {
            this.edgesChecked += edgesChecked;
            this.edgesEmitted += edgesEmitted;
            this.yCount += yCount;
        }

        public final int component1() {
            return this.edgesChecked;
        }

        public final int component2() {
            return this.edgesEmitted;
        }

        public final int component3() {
            return this.yCount;
        }

        @NotNull
        public final Stats copy(int edgesChecked, int edgesEmitted, int yCount) {
            return new Stats(edgesChecked, edgesEmitted, yCount);
        }

        public static /* synthetic */ Stats copy$default(Stats stats, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = stats.edgesChecked;
            }
            if ((n4 & 2) != 0) {
                n2 = stats.edgesEmitted;
            }
            if ((n4 & 4) != 0) {
                n3 = stats.yCount;
            }
            return stats.copy(n, n2, n3);
        }

        @NotNull
        public String toString() {
            return "Stats(edgesChecked=" + this.edgesChecked + ", edgesEmitted=" + this.edgesEmitted + ", yCount=" + this.yCount + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.edgesChecked);
            result2 = result2 * 31 + Integer.hashCode(this.edgesEmitted);
            result2 = result2 * 31 + Integer.hashCode(this.yCount);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Stats)) {
                return false;
            }
            Stats stats = (Stats)other;
            if (this.edgesChecked != stats.edgesChecked) {
                return false;
            }
            if (this.edgesEmitted != stats.edgesEmitted) {
                return false;
            }
            return this.yCount == stats.yCount;
        }

        public Stats() {
            this(0, 0, 0, 7, null);
        }
    }
}

