/*
 * Decompiled with CFR 0.152.
 */
package korlibs.io.compression.lzma;

import korlibs.io.compression.lzma.SevenZipKt;
import korlibs.io.stream.SyncInputStream;
import korlibs.io.stream.SyncOutputStream;
import korlibs.io.stream.SyncStreamKt;
import korlibs.io.util.checksum.CRC32;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u000b\u0003\u0004\u0005\u0006\u0007\b\t\n\u000b\f\rB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u000e"}, d2={"Lkorlibs/io/compression/lzma/SevenZip;", "", "()V", "BitTreeDecoder", "BitTreeEncoder", "ICodeProgress", "LzBinTree", "LzInWindow", "LzOutWindow", "LzmaBase", "LzmaDecoder", "LzmaEncoder", "RangeDecoder", "RangeEncoder", "korge-core"})
public final class SevenZip {
    @NotNull
    public static final SevenZip INSTANCE = new SevenZip();

    private SevenZip() {
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0017\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lkorlibs/io/compression/lzma/SevenZip$BitTreeDecoder;", "", "numBitLevels", "", "(I)V", "models", "", "decode", "rangeDecoder", "Lkorlibs/io/compression/lzma/SevenZip$RangeDecoder;", "init", "", "reverseDecode", "Companion", "korge-core"})
    public static final class BitTreeDecoder {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private int numBitLevels;
        @NotNull
        private final short[] models;

        public BitTreeDecoder(int numBitLevels) {
            this.numBitLevels = numBitLevels;
            this.models = new short[1 << this.numBitLevels];
        }

        public final void init() {
            RangeDecoder.Companion.initBitModels(this.models);
        }

        public final int decode(@NotNull RangeDecoder rangeDecoder) {
            int m = 1;
            for (int bitIndex = this.numBitLevels; 0 < bitIndex; --bitIndex) {
                m = (m << 1) + rangeDecoder.decodeBit(this.models, m);
            }
            return m - (1 << this.numBitLevels);
        }

        public final int reverseDecode(@NotNull RangeDecoder rangeDecoder) {
            int m = 1;
            int symbol = 0;
            int n = this.numBitLevels;
            for (int bitIndex = 0; bitIndex < n; ++bitIndex) {
                int bit = rangeDecoder.decodeBit(this.models, m);
                m <<= 1;
                m += bit;
                symbol |= bit << bitIndex;
            }
            return symbol;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0017\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004\u00a8\u0006\u000b"}, d2={"Lkorlibs/io/compression/lzma/SevenZip$BitTreeDecoder$Companion;", "", "()V", "reverseDecode", "", "Models", "", "startIndex", "rangeDecoder", "Lkorlibs/io/compression/lzma/SevenZip$RangeDecoder;", "NumBitLevels", "korge-core"})
        public static final class Companion {
            private Companion() {
            }

            public final int reverseDecode(@NotNull short[] Models, int startIndex, @NotNull RangeDecoder rangeDecoder, int NumBitLevels) {
                int m = 1;
                int symbol = 0;
                for (int bitIndex = 0; bitIndex < NumBitLevels; ++bitIndex) {
                    int bit = rangeDecoder.decodeBit(Models, startIndex + m);
                    m <<= 1;
                    m += bit;
                    symbol |= bit << bitIndex;
                }
                return symbol;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0017\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003J\u000e\u0010\f\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003J\u0006\u0010\r\u001a\u00020\bJ\u0016\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003J\u000e\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lkorlibs/io/compression/lzma/SevenZip$BitTreeEncoder;", "", "numBitLevels", "", "(I)V", "models", "", "encode", "", "rangeEncoder", "Lkorlibs/io/compression/lzma/SevenZip$RangeEncoder;", "symbol", "getPrice", "init", "reverseEncode", "reverseGetPrice", "Companion", "korge-core"})
    public static final class BitTreeEncoder {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private int numBitLevels;
        @NotNull
        private final short[] models;

        public BitTreeEncoder(int numBitLevels) {
            this.numBitLevels = numBitLevels;
            this.models = new short[1 << this.numBitLevels];
        }

        public final void init() {
            RangeDecoder.Companion.initBitModels(this.models);
        }

        public final void encode(@NotNull RangeEncoder rangeEncoder, int symbol) {
            int m = 1;
            int bitIndex = this.numBitLevels;
            while (bitIndex != 0) {
                int bit = symbol >>> --bitIndex & 1;
                rangeEncoder.encode(this.models, m, bit);
                m = m << 1 | bit;
            }
        }

        public final void reverseEncode(@NotNull RangeEncoder rangeEncoder, int symbol) {
            int symbol2 = symbol;
            int m = 1;
            int n = this.numBitLevels;
            for (int i2 = 0; i2 < n; ++i2) {
                int bit = symbol2 & 1;
                rangeEncoder.encode(this.models, m, bit);
                m = m << 1 | bit;
                symbol2 >>= 1;
            }
        }

        public final int getPrice(int symbol) {
            int price = 0;
            int m = 1;
            int bitIndex = this.numBitLevels;
            while (bitIndex != 0) {
                int bit = symbol >>> --bitIndex & 1;
                price += RangeEncoder.Companion.getPrice(this.models[m], bit);
                m = (m << 1) + bit;
            }
            return price;
        }

        public final int reverseGetPrice(int symbol) {
            int symbol2 = symbol;
            int price = 0;
            int m = 1;
            for (int i2 = this.numBitLevels; 0 < i2; --i2) {
                int bit = symbol2 & 1;
                symbol2 >>>= 1;
                price += RangeEncoder.Companion.getPrice(this.models[m], bit);
                m = m << 1 | bit;
            }
            return price;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0017\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bJ&\u0010\r\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b\u00a8\u0006\u000e"}, d2={"Lkorlibs/io/compression/lzma/SevenZip$BitTreeEncoder$Companion;", "", "()V", "reverseEncode", "", "Models", "", "startIndex", "", "rangeEncoder", "Lkorlibs/io/compression/lzma/SevenZip$RangeEncoder;", "NumBitLevels", "symbol", "reverseGetPrice", "korge-core"})
        public static final class Companion {
            private Companion() {
            }

            public final int reverseGetPrice(@NotNull short[] Models, int startIndex, int NumBitLevels, int symbol) {
                int symbol2 = symbol;
                int price = 0;
                int m = 1;
                for (int i2 = NumBitLevels; 0 < i2; --i2) {
                    int bit = symbol2 & 1;
                    symbol2 >>>= 1;
                    price += RangeEncoder.Companion.getPrice(Models[startIndex + m], bit);
                    m = m << 1 | bit;
                }
                return price;
            }

            public final void reverseEncode(@NotNull short[] Models, int startIndex, @NotNull RangeEncoder rangeEncoder, int NumBitLevels, int symbol) {
                int symbol2 = symbol;
                int m = 1;
                for (int i2 = 0; i2 < NumBitLevels; ++i2) {
                    int bit = symbol2 & 1;
                    rangeEncoder.encode(Models, startIndex + m, bit);
                    m = m << 1 | bit;
                    symbol2 >>= 1;
                }
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&\u00a8\u0006\u0007"}, d2={"Lkorlibs/io/compression/lzma/SevenZip$ICodeProgress;", "", "setProgress", "", "inSize", "", "outSize", "korge-core"})
    public static interface ICodeProgress {
        public void setProgress(long var1, long var3);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\f\u0018\u0000 %2\u00020\u0001:\u0001%B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0006J\u000e\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\nJ\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0016J\b\u0010\u001c\u001a\u00020\u001aH\u0002J \u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u0006H\u0002J\u000e\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u0006J\u000e\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lkorlibs/io/compression/lzma/SevenZip$LzBinTree;", "Lkorlibs/io/compression/lzma/SevenZip$LzInWindow;", "()V", "HASH_ARRAY", "", "_cutValue", "", "_cyclicBufferPos", "_cyclicBufferSize", "_hash", "", "_hashMask", "_hashSizeSum", "_matchMaxLen", "_son", "kFixHashSize", "kMinMatchCheck", "kNumHashDirectBytes", "create", "historySize", "keepAddBufferBefore", "matchMaxLen", "keepAddBufferAfter", "getMatches", "distances", "init", "", "movePos", "normalize", "normalizeLinks", "items", "numItems", "subValue", "setType", "numHashBytes", "skip", "num", "Companion", "korge-core"})
    public static final class LzBinTree
    extends LzInWindow {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private int _cyclicBufferPos;
        private int _cyclicBufferSize;
        private int _matchMaxLen;
        private int[] _son;
        private int[] _hash;
        private int _cutValue = 255;
        private int _hashMask;
        private int _hashSizeSum;
        private boolean HASH_ARRAY = true;
        private int kNumHashDirectBytes;
        private int kMinMatchCheck = 4;
        private int kFixHashSize = 66560;
        public static final int kHash2Size = 1024;
        public static final int kHash3Size = 65536;
        public static final int kBT2HashSize = 65536;
        public static final int kStartMaxLen = 1;
        public static final int kHash3Offset = 1024;
        public static final int kEmptyHashValue = 0;
        public static final int kMaxValForNormalize = 0x3FFFFFFF;
        @NotNull
        private static final int[] CrcTable = CRC32.INSTANCE.getTABLE$korge_core();

        public final void setType(int numHashBytes) {
            boolean bl = this.HASH_ARRAY = numHashBytes > 2;
            if (this.HASH_ARRAY) {
                this.kNumHashDirectBytes = 0;
                this.kMinMatchCheck = 4;
                this.kFixHashSize = 66560;
            } else {
                this.kNumHashDirectBytes = 2;
                this.kMinMatchCheck = 3;
                this.kFixHashSize = 0;
            }
        }

        @Override
        public void init() {
            super.init();
            int n = this._hashSizeSum;
            for (int i2 = 0; i2 < n; ++i2) {
                int[] nArray = this._hash;
                if (this._hash == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("_hash");
                    nArray = null;
                }
                nArray[i2] = 0;
            }
            this._cyclicBufferPos = 0;
            this.reduceOffsets(-1);
        }

        @Override
        public void movePos() {
            ++this._cyclicBufferPos;
            if (this._cyclicBufferPos >= this._cyclicBufferSize) {
                this._cyclicBufferPos = 0;
            }
            super.movePos();
            if (this.get_pos() == 0x3FFFFFFF) {
                this.normalize();
            }
        }

        public final boolean create(int historySize, int keepAddBufferBefore, int matchMaxLen, int keepAddBufferAfter) {
            if (historySize > 0x3FFFFEFF) {
                return false;
            }
            this._cutValue = 16 + (matchMaxLen >> 1);
            int windowReservSize = (historySize + keepAddBufferBefore + matchMaxLen + keepAddBufferAfter) / 2 + 256;
            super.create(historySize + keepAddBufferBefore, matchMaxLen + keepAddBufferAfter, windowReservSize);
            this._matchMaxLen = matchMaxLen;
            int cyclicBufferSize = historySize + 1;
            if (this._cyclicBufferSize != cyclicBufferSize) {
                this._cyclicBufferSize = cyclicBufferSize;
            }
            this._son = new int[this._cyclicBufferSize * 2];
            int hs = 65536;
            if (this.HASH_ARRAY) {
                hs = historySize - 1;
                hs |= hs >> 1;
                hs |= hs >> 2;
                hs |= hs >> 4;
                hs |= hs >> 8;
                hs >>= 1;
                if ((hs |= 0xFFFF) > 0x1000000) {
                    hs >>= 1;
                }
                this._hashMask = hs++;
                hs += this.kFixHashSize;
            }
            if (hs != this._hashSizeSum) {
                this._hashSizeSum = hs;
                this._hash = new int[this._hashSizeSum];
            }
            return true;
        }

        public final int getMatches(@NotNull int[] distances) {
            int lenLimit = 0;
            if (this.get_pos() + this._matchMaxLen <= this.get_streamPos()) {
                lenLimit = this._matchMaxLen;
            } else {
                lenLimit = this.get_streamPos() - this.get_pos();
                if (lenLimit < this.kMinMatchCheck) {
                    this.movePos();
                    return 0;
                }
            }
            int offset2 = 0;
            int matchMinPos = this.get_pos() > this._cyclicBufferSize ? this.get_pos() - this._cyclicBufferSize : 0;
            int cur = this.get_bufferOffset() + this.get_pos();
            int maxLen = 1;
            int hashValue = 0;
            int hash2Value = 0;
            int hash3Value = 0;
            if (this.HASH_ARRAY) {
                byte[] byArray = this.get_bufferBase();
                Intrinsics.checkNotNull(byArray);
                int n = CrcTable[SevenZipKt.access$and(byArray[cur], 255)];
                byte[] byArray2 = this.get_bufferBase();
                Intrinsics.checkNotNull(byArray2);
                int temp = n ^ SevenZipKt.access$and(byArray2[cur + 1], 255);
                hash2Value = temp & 0x3FF;
                byte[] byArray3 = this.get_bufferBase();
                Intrinsics.checkNotNull(byArray3);
                hash3Value = (temp ^= SevenZipKt.access$and(byArray3[cur + 2], 255) << 8) & 0xFFFF;
                byte[] byArray4 = this.get_bufferBase();
                Intrinsics.checkNotNull(byArray4);
                hashValue = (temp ^ CrcTable[SevenZipKt.access$and(byArray4[cur + 3], 255)] << 5) & this._hashMask;
            } else {
                byte[] byArray = this.get_bufferBase();
                Intrinsics.checkNotNull(byArray);
                int n = SevenZipKt.access$and(byArray[cur], 255);
                byte[] byArray5 = this.get_bufferBase();
                Intrinsics.checkNotNull(byArray5);
                hashValue = n ^ SevenZipKt.access$and(byArray5[cur + 1], 255) << 8;
            }
            int[] nArray = this._hash;
            if (this._hash == null) {
                Intrinsics.throwUninitializedPropertyAccessException("_hash");
                nArray = null;
            }
            int curMatch = nArray[this.kFixHashSize + hashValue];
            if (this.HASH_ARRAY) {
                int[] nArray2 = this._hash;
                if (this._hash == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("_hash");
                    nArray2 = null;
                }
                int curMatch2 = nArray2[hash2Value];
                int[] nArray3 = this._hash;
                if (this._hash == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("_hash");
                    nArray3 = null;
                }
                int curMatch3 = nArray3[1024 + hash3Value];
                int[] nArray4 = this._hash;
                if (this._hash == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("_hash");
                    nArray4 = null;
                }
                nArray4[hash2Value] = this.get_pos();
                int[] nArray5 = this._hash;
                if (this._hash == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("_hash");
                    nArray5 = null;
                }
                nArray5[1024 + hash3Value] = this.get_pos();
                if (curMatch2 > matchMinPos) {
                    byte[] byArray = this.get_bufferBase();
                    Intrinsics.checkNotNull(byArray);
                    byte by = byArray[this.get_bufferOffset() + curMatch2];
                    byte[] byArray6 = this.get_bufferBase();
                    Intrinsics.checkNotNull(byArray6);
                    if (by == byArray6[cur]) {
                        maxLen = 2;
                        distances[offset2++] = maxLen;
                        distances[offset2++] = this.get_pos() - curMatch2 - 1;
                    }
                }
                if (curMatch3 > matchMinPos) {
                    byte[] byArray = this.get_bufferBase();
                    Intrinsics.checkNotNull(byArray);
                    byte by = byArray[this.get_bufferOffset() + curMatch3];
                    byte[] byArray7 = this.get_bufferBase();
                    Intrinsics.checkNotNull(byArray7);
                    if (by == byArray7[cur]) {
                        if (curMatch3 == curMatch2) {
                            offset2 -= 2;
                        }
                        maxLen = 3;
                        distances[offset2++] = maxLen;
                        distances[offset2++] = this.get_pos() - curMatch3 - 1;
                        curMatch2 = curMatch3;
                    }
                }
                if (offset2 != 0 && curMatch2 == curMatch) {
                    offset2 -= 2;
                    maxLen = 1;
                }
            }
            int[] nArray6 = this._hash;
            if (this._hash == null) {
                Intrinsics.throwUninitializedPropertyAccessException("_hash");
                nArray6 = null;
            }
            nArray6[this.kFixHashSize + hashValue] = this.get_pos();
            int ptr0 = (this._cyclicBufferPos << 1) + 1;
            int ptr1 = this._cyclicBufferPos << 1;
            int len0 = 0;
            int len1 = 0;
            len0 = len1 = this.kNumHashDirectBytes;
            if (this.kNumHashDirectBytes != 0 && curMatch > matchMinPos) {
                byte[] byArray = this.get_bufferBase();
                Intrinsics.checkNotNull(byArray);
                byte by = byArray[this.get_bufferOffset() + curMatch + this.kNumHashDirectBytes];
                byte[] byArray8 = this.get_bufferBase();
                Intrinsics.checkNotNull(byArray8);
                if (by != byArray8[cur + this.kNumHashDirectBytes]) {
                    maxLen = this.kNumHashDirectBytes;
                    distances[offset2++] = maxLen;
                    distances[offset2++] = this.get_pos() - curMatch - 1;
                }
            }
            int count2 = this._cutValue;
            while (true) {
                if (curMatch <= matchMinPos || count2-- == 0) {
                    int[] nArray7 = this._son;
                    if (this._son == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("_son");
                        nArray7 = null;
                    }
                    nArray7[ptr1] = 0;
                    int[] nArray8 = this._son;
                    if (this._son == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("_son");
                        nArray8 = null;
                    }
                    int[] nArray9 = this._son;
                    if (this._son == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("_son");
                        nArray9 = null;
                    }
                    nArray8[ptr0] = nArray9[ptr1];
                    break;
                }
                int delta = this.get_pos() - curMatch;
                int cyclicPos = (delta <= this._cyclicBufferPos ? this._cyclicBufferPos - delta : this._cyclicBufferPos - delta + this._cyclicBufferSize) << 1;
                int pby1 = this.get_bufferOffset() + curMatch;
                int len = Math.min(len0, len1);
                byte[] byArray = this.get_bufferBase();
                Intrinsics.checkNotNull(byArray);
                byte by = byArray[pby1 + len];
                byte[] byArray9 = this.get_bufferBase();
                Intrinsics.checkNotNull(byArray9);
                if (by == byArray9[cur + len]) {
                    while (++len != lenLimit) {
                        byte[] byArray10 = this.get_bufferBase();
                        Intrinsics.checkNotNull(byArray10);
                        byte by2 = byArray10[pby1 + len];
                        byte[] byArray11 = this.get_bufferBase();
                        Intrinsics.checkNotNull(byArray11);
                        if (by2 == byArray11[cur + len]) continue;
                    }
                    if (maxLen < len) {
                        maxLen = len;
                        distances[offset2++] = maxLen;
                        distances[offset2++] = delta - 1;
                        if (len == lenLimit) {
                            int[] nArray10 = this._son;
                            if (this._son == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("_son");
                                nArray10 = null;
                            }
                            int[] nArray11 = this._son;
                            if (this._son == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("_son");
                                nArray11 = null;
                            }
                            nArray10[ptr1] = nArray11[cyclicPos];
                            int[] nArray12 = this._son;
                            if (this._son == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("_son");
                                nArray12 = null;
                            }
                            int[] nArray13 = this._son;
                            if (this._son == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("_son");
                                nArray13 = null;
                            }
                            nArray12[ptr0] = nArray13[cyclicPos + 1];
                            break;
                        }
                    }
                }
                byte[] byArray12 = this.get_bufferBase();
                Intrinsics.checkNotNull(byArray12);
                int n = SevenZipKt.access$and(byArray12[pby1 + len], 255);
                byte[] byArray13 = this.get_bufferBase();
                Intrinsics.checkNotNull(byArray13);
                if (n < SevenZipKt.access$and(byArray13[cur + len], 255)) {
                    int[] nArray14 = this._son;
                    if (this._son == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("_son");
                        nArray14 = null;
                    }
                    nArray14[ptr1] = curMatch;
                    ptr1 = cyclicPos + 1;
                    int[] nArray15 = this._son;
                    if (this._son == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("_son");
                        nArray15 = null;
                    }
                    curMatch = nArray15[ptr1];
                    len1 = len;
                    continue;
                }
                int[] nArray16 = this._son;
                if (this._son == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("_son");
                    nArray16 = null;
                }
                nArray16[ptr0] = curMatch;
                ptr0 = cyclicPos;
                int[] nArray17 = this._son;
                if (this._son == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("_son");
                    nArray17 = null;
                }
                curMatch = nArray17[ptr0];
                len0 = len;
            }
            this.movePos();
            return offset2;
        }

        public final void skip(int num) {
            int nnum = num;
            do {
                int lenLimit = 0;
                if (this.get_pos() + this._matchMaxLen <= this.get_streamPos()) {
                    lenLimit = this._matchMaxLen;
                } else {
                    lenLimit = this.get_streamPos() - this.get_pos();
                    if (lenLimit < this.kMinMatchCheck) {
                        this.movePos();
                        continue;
                    }
                }
                int matchMinPos = this.get_pos() > this._cyclicBufferSize ? this.get_pos() - this._cyclicBufferSize : 0;
                int cur = this.get_bufferOffset() + this.get_pos();
                int hashValue = 0;
                if (this.HASH_ARRAY) {
                    byte[] byArray = this.get_bufferBase();
                    Intrinsics.checkNotNull(byArray);
                    int n = CrcTable[SevenZipKt.access$and(byArray[cur], 255)];
                    byte[] byArray2 = this.get_bufferBase();
                    Intrinsics.checkNotNull(byArray2);
                    int temp = n ^ SevenZipKt.access$and(byArray2[cur + 1], 255);
                    int hash2Value = temp & 0x3FF;
                    int[] nArray = this._hash;
                    if (this._hash == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("_hash");
                        nArray = null;
                    }
                    nArray[hash2Value] = this.get_pos();
                    byte[] byArray3 = this.get_bufferBase();
                    Intrinsics.checkNotNull(byArray3);
                    int hash3Value = (temp ^= SevenZipKt.access$and(byArray3[cur + 2], 255) << 8) & 0xFFFF;
                    int[] nArray2 = this._hash;
                    if (this._hash == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("_hash");
                        nArray2 = null;
                    }
                    nArray2[1024 + hash3Value] = this.get_pos();
                    byte[] byArray4 = this.get_bufferBase();
                    Intrinsics.checkNotNull(byArray4);
                    hashValue = (temp ^ CrcTable[SevenZipKt.access$and(byArray4[cur + 3], 255)] << 5) & this._hashMask;
                } else {
                    byte[] byArray = this.get_bufferBase();
                    Intrinsics.checkNotNull(byArray);
                    int n = SevenZipKt.access$and(byArray[cur], 255);
                    byte[] byArray5 = this.get_bufferBase();
                    Intrinsics.checkNotNull(byArray5);
                    hashValue = n ^ SevenZipKt.access$and(byArray5[cur + 1], 255) << 8;
                }
                int[] nArray = this._hash;
                if (this._hash == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("_hash");
                    nArray = null;
                }
                int curMatch = nArray[this.kFixHashSize + hashValue];
                int[] nArray3 = this._hash;
                if (this._hash == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("_hash");
                    nArray3 = null;
                }
                nArray3[this.kFixHashSize + hashValue] = this.get_pos();
                int ptr0 = (this._cyclicBufferPos << 1) + 1;
                int ptr1 = this._cyclicBufferPos << 1;
                int len0 = 0;
                int len1 = 0;
                len0 = len1 = this.kNumHashDirectBytes;
                int count2 = this._cutValue;
                while (true) {
                    if (curMatch <= matchMinPos || count2-- == 0) {
                        int[] nArray4 = this._son;
                        if (this._son == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("_son");
                            nArray4 = null;
                        }
                        nArray4[ptr1] = 0;
                        int[] nArray5 = this._son;
                        if (this._son == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("_son");
                            nArray5 = null;
                        }
                        int[] nArray6 = this._son;
                        if (this._son == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("_son");
                            nArray6 = null;
                        }
                        nArray5[ptr0] = nArray6[ptr1];
                        break;
                    }
                    int delta = this.get_pos() - curMatch;
                    int cyclicPos = (delta <= this._cyclicBufferPos ? this._cyclicBufferPos - delta : this._cyclicBufferPos - delta + this._cyclicBufferSize) << 1;
                    int pby1 = this.get_bufferOffset() + curMatch;
                    int len = Math.min(len0, len1);
                    byte[] byArray = this.get_bufferBase();
                    Intrinsics.checkNotNull(byArray);
                    byte by = byArray[pby1 + len];
                    byte[] byArray6 = this.get_bufferBase();
                    Intrinsics.checkNotNull(byArray6);
                    if (by == byArray6[cur + len]) {
                        while (++len != lenLimit) {
                            byte[] byArray7 = this.get_bufferBase();
                            Intrinsics.checkNotNull(byArray7);
                            byte by2 = byArray7[pby1 + len];
                            byte[] byArray8 = this.get_bufferBase();
                            Intrinsics.checkNotNull(byArray8);
                            if (by2 == byArray8[cur + len]) continue;
                        }
                        if (len == lenLimit) {
                            int[] nArray7 = this._son;
                            if (this._son == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("_son");
                                nArray7 = null;
                            }
                            int[] nArray8 = this._son;
                            if (this._son == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("_son");
                                nArray8 = null;
                            }
                            nArray7[ptr1] = nArray8[cyclicPos];
                            int[] nArray9 = this._son;
                            if (this._son == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("_son");
                                nArray9 = null;
                            }
                            int[] nArray10 = this._son;
                            if (this._son == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("_son");
                                nArray10 = null;
                            }
                            nArray9[ptr0] = nArray10[cyclicPos + 1];
                            break;
                        }
                    }
                    byte[] byArray9 = this.get_bufferBase();
                    Intrinsics.checkNotNull(byArray9);
                    int n = SevenZipKt.access$and(byArray9[pby1 + len], 255);
                    byte[] byArray10 = this.get_bufferBase();
                    Intrinsics.checkNotNull(byArray10);
                    if (n < SevenZipKt.access$and(byArray10[cur + len], 255)) {
                        int[] nArray11 = this._son;
                        if (this._son == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("_son");
                            nArray11 = null;
                        }
                        nArray11[ptr1] = curMatch;
                        ptr1 = cyclicPos + 1;
                        int[] nArray12 = this._son;
                        if (this._son == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("_son");
                            nArray12 = null;
                        }
                        curMatch = nArray12[ptr1];
                        len1 = len;
                        continue;
                    }
                    int[] nArray13 = this._son;
                    if (this._son == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("_son");
                        nArray13 = null;
                    }
                    nArray13[ptr0] = curMatch;
                    ptr0 = cyclicPos;
                    int[] nArray14 = this._son;
                    if (this._son == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("_son");
                        nArray14 = null;
                    }
                    curMatch = nArray14[ptr0];
                    len0 = len;
                }
                this.movePos();
            } while (--nnum != 0);
        }

        private final void normalizeLinks(int[] items2, int numItems, int subValue) {
            for (int i2 = 0; i2 < numItems; ++i2) {
                int value = items2[i2];
                value = value <= subValue ? 0 : (value -= subValue);
                items2[i2] = value;
            }
        }

        private final void normalize() {
            int subValue = this.get_pos() - this._cyclicBufferSize;
            int[] nArray = this._son;
            if (this._son == null) {
                Intrinsics.throwUninitializedPropertyAccessException("_son");
                nArray = null;
            }
            this.normalizeLinks(nArray, this._cyclicBufferSize * 2, subValue);
            int[] nArray2 = this._hash;
            if (this._hash == null) {
                Intrinsics.throwUninitializedPropertyAccessException("_hash");
                nArray2 = null;
            }
            this.normalizeLinks(nArray2, this._hashSizeSum, subValue);
            this.reduceOffsets(subValue);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lkorlibs/io/compression/lzma/SevenZip$LzBinTree$Companion;", "", "()V", "CrcTable", "", "kBT2HashSize", "", "kEmptyHashValue", "kHash2Size", "kHash3Offset", "kHash3Size", "kMaxValForNormalize", "kStartMaxLen", "korge-core"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0005\n\u0002\b\u000f\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0004J\b\u0010#\u001a\u00020\u001fH\u0002J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0004J\u001e\u0010'\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u0004J\u0006\u0010*\u001a\u00020\u0004J\b\u0010+\u001a\u00020\u001fH\u0016J\b\u0010,\u001a\u00020\u001fH\u0002J\b\u0010-\u001a\u00020\u001fH\u0016J\b\u0010.\u001a\u00020\u001fH\u0002J\u000e\u0010/\u001a\u00020\u001f2\u0006\u00100\u001a\u00020\u0004J\u0006\u00101\u001a\u00020\u001fJ\u000e\u00102\u001a\u00020\u001f2\u0006\u00103\u001a\u00020\u0018R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u000fR\u000e\u0010\u0016\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\r\"\u0004\b\u001d\u0010\u000f\u00a8\u00064"}, d2={"Lkorlibs/io/compression/lzma/SevenZip$LzInWindow;", "", "()V", "_blockSize", "", "_bufferBase", "", "get_bufferBase", "()[B", "set_bufferBase", "([B)V", "_bufferOffset", "get_bufferOffset", "()I", "set_bufferOffset", "(I)V", "_keepSizeAfter", "_keepSizeBefore", "_pointerToLastSafePosition", "_pos", "get_pos", "set_pos", "_posLimit", "_stream", "Lkorlibs/io/stream/SyncInputStream;", "_streamEndWasReached", "", "_streamPos", "get_streamPos", "set_streamPos", "create", "", "keepSizeBefore", "keepSizeAfter", "keepSizeReserv", "free", "getIndexByte", "", "index", "getMatchLen", "distance", "limit", "getNumAvailableBytes", "init", "moveBlock", "movePos", "readBlock", "reduceOffsets", "subValue", "releaseStream", "setStream", "stream", "korge-core"})
    public static class LzInWindow {
        @Nullable
        private byte[] _bufferBase;
        @Nullable
        private SyncInputStream _stream;
        private int _posLimit;
        private boolean _streamEndWasReached;
        private int _pointerToLastSafePosition;
        private int _bufferOffset;
        private int _blockSize;
        private int _pos;
        private int _keepSizeBefore;
        private int _keepSizeAfter;
        private int _streamPos;

        @Nullable
        public final byte[] get_bufferBase() {
            return this._bufferBase;
        }

        public final void set_bufferBase(@Nullable byte[] byArray) {
            this._bufferBase = byArray;
        }

        public final int get_bufferOffset() {
            return this._bufferOffset;
        }

        public final void set_bufferOffset(int n) {
            this._bufferOffset = n;
        }

        public final int get_pos() {
            return this._pos;
        }

        public final void set_pos(int n) {
            this._pos = n;
        }

        public final int get_streamPos() {
            return this._streamPos;
        }

        public final void set_streamPos(int n) {
            this._streamPos = n;
        }

        private final void moveBlock() {
            int offset2 = this._bufferOffset + this._pos - this._keepSizeBefore;
            if (offset2 > 0) {
                --offset2;
            }
            int numBytes = this._bufferOffset + this._streamPos - offset2;
            for (int i2 = 0; i2 < numBytes; ++i2) {
                Intrinsics.checkNotNull(this._bufferBase);
                Intrinsics.checkNotNull(this._bufferBase);
                this._bufferBase[i2] = this._bufferBase[offset2 + i2];
            }
            this._bufferOffset -= offset2;
        }

        private final void readBlock() {
            if (this._streamEndWasReached) {
                return;
            }
            int size2;
            while ((size2 = 0 - this._bufferOffset + this._blockSize - this._streamPos) != 0) {
                SyncInputStream syncInputStream = this._stream;
                Intrinsics.checkNotNull(syncInputStream);
                Intrinsics.checkNotNull(this._bufferBase);
                int numReadBytes = syncInputStream.read(this._bufferBase, this._bufferOffset + this._streamPos, size2);
                if (numReadBytes <= 0) {
                    this._posLimit = this._streamPos;
                    int pointerToPostion = this._bufferOffset + this._posLimit;
                    if (pointerToPostion > this._pointerToLastSafePosition) {
                        this._posLimit = this._pointerToLastSafePosition - this._bufferOffset;
                    }
                    this._streamEndWasReached = true;
                    return;
                }
                this._streamPos += numReadBytes;
                if (this._streamPos < this._pos + this._keepSizeAfter) continue;
                this._posLimit = this._streamPos - this._keepSizeAfter;
            }
            return;
        }

        private final void free() {
            this._bufferBase = null;
        }

        public final void create(int keepSizeBefore, int keepSizeAfter, int keepSizeReserv) {
            this._keepSizeBefore = keepSizeBefore;
            this._keepSizeAfter = keepSizeAfter;
            int blockSize = keepSizeBefore + keepSizeAfter + keepSizeReserv;
            if (this._bufferBase == null || this._blockSize != blockSize) {
                this.free();
                this._blockSize = blockSize;
                this._bufferBase = new byte[this._blockSize];
            }
            this._pointerToLastSafePosition = this._blockSize - keepSizeAfter;
        }

        public final void setStream(@NotNull SyncInputStream stream) {
            this._stream = stream;
        }

        public final void releaseStream() {
            this._stream = null;
        }

        public void init() {
            this._bufferOffset = 0;
            this._pos = 0;
            this._streamPos = 0;
            this._streamEndWasReached = false;
            this.readBlock();
        }

        public void movePos() {
            int n = this._pos;
            this._pos = n + 1;
            if (this._pos > this._posLimit) {
                int pointerToPostion = this._bufferOffset + this._pos;
                if (pointerToPostion > this._pointerToLastSafePosition) {
                    this.moveBlock();
                }
                this.readBlock();
            }
        }

        public final byte getIndexByte(int index2) {
            Intrinsics.checkNotNull(this._bufferBase);
            return this._bufferBase[this._bufferOffset + this._pos + index2];
        }

        public final int getMatchLen(int index2, int distance, int limit) {
            int i2;
            int ddis = distance;
            int dlim = limit;
            if (this._streamEndWasReached && this._pos + index2 + dlim > this._streamPos) {
                dlim = this._streamPos - (this._pos + index2);
            }
            ++ddis;
            int pby = this._bufferOffset + this._pos + index2;
            for (i2 = 0; i2 < dlim; ++i2) {
                Intrinsics.checkNotNull(this._bufferBase);
                byte by = this._bufferBase[pby + i2];
                Intrinsics.checkNotNull(this._bufferBase);
                if (by != this._bufferBase[pby + i2 - ddis]) break;
            }
            return i2;
        }

        public final int getNumAvailableBytes() {
            return this._streamPos - this._pos;
        }

        public final void reduceOffsets(int subValue) {
            this._bufferOffset += subValue;
            this._posLimit -= subValue;
            this._pos -= subValue;
            this._streamPos -= subValue;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006J\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0006J\u0006\u0010\u0011\u001a\u00020\fJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u0006J\u000e\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0013J\u0006\u0010\u0019\u001a\u00020\fJ\u000e\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\bR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lkorlibs/io/compression/lzma/SevenZip$LzOutWindow;", "", "()V", "_buffer", "", "_pos", "", "_stream", "Lkorlibs/io/stream/SyncOutputStream;", "_streamPos", "_windowSize", "copyBlock", "", "distance", "len", "create", "windowSize", "flush", "getByte", "", "init", "solid", "", "putByte", "b", "releaseStream", "setStream", "stream", "korge-core"})
    public static final class LzOutWindow {
        @Nullable
        private byte[] _buffer;
        private int _pos;
        private int _windowSize;
        private int _streamPos;
        @Nullable
        private SyncOutputStream _stream;

        public final void create(int windowSize) {
            if (this._buffer == null || this._windowSize != windowSize) {
                this._buffer = new byte[windowSize];
            }
            this._windowSize = windowSize;
            this._pos = 0;
            this._streamPos = 0;
        }

        public final void setStream(@NotNull SyncOutputStream stream) {
            this.releaseStream();
            this._stream = stream;
        }

        public final void releaseStream() {
            this.flush();
            this._stream = null;
        }

        public final void init(boolean solid) {
            if (!solid) {
                this._streamPos = 0;
                this._pos = 0;
            }
        }

        public final void flush() {
            int size2 = this._pos - this._streamPos;
            if (size2 == 0) {
                return;
            }
            SyncOutputStream syncOutputStream = this._stream;
            Intrinsics.checkNotNull(syncOutputStream);
            Intrinsics.checkNotNull(this._buffer);
            syncOutputStream.write(this._buffer, this._streamPos, size2);
            if (this._pos >= this._windowSize) {
                this._pos = 0;
            }
            this._streamPos = this._pos;
        }

        public final void copyBlock(int distance, int len) {
            int llen = len;
            int pos = this._pos - distance - 1;
            if (pos < 0) {
                pos += this._windowSize;
            }
            while (llen != 0) {
                if (pos >= this._windowSize) {
                    pos = 0;
                }
                Intrinsics.checkNotNull(this._buffer);
                int n = this._pos;
                this._pos = n + 1;
                Intrinsics.checkNotNull(this._buffer);
                this._buffer[n] = this._buffer[pos++];
                if (this._pos >= this._windowSize) {
                    this.flush();
                }
                --llen;
            }
        }

        public final void putByte(byte b) {
            Intrinsics.checkNotNull(this._buffer);
            int n = this._pos;
            this._pos = n + 1;
            this._buffer[n] = b;
            if (this._pos >= this._windowSize) {
                this.flush();
            }
        }

        public final byte getByte(int distance) {
            int pos = this._pos - distance - 1;
            if (pos < 0) {
                pos += this._windowSize;
            }
            Intrinsics.checkNotNull(this._buffer);
            return this._buffer[pos];
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u001d\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004J\u0006\u0010 \u001a\u00020\u0004J\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0004J\u000e\u0010$\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0004J\u000e\u0010%\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0004J\u000e\u0010&\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0004J\u000e\u0010'\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lkorlibs/io/compression/lzma/SevenZip$LzmaBase;", "", "()V", "kAlignMask", "", "kAlignTableSize", "kDicLogSizeMin", "kEndPosModelIndex", "kMatchMaxLen", "kMatchMinLen", "kNumAlignBits", "kNumFullDistances", "kNumHighLenBits", "kNumLenSymbols", "kNumLenToPosStates", "kNumLenToPosStatesBits", "kNumLitContextBitsMax", "kNumLitPosStatesBitsEncodingMax", "kNumLowLenBits", "kNumLowLenSymbols", "kNumMidLenBits", "kNumMidLenSymbols", "kNumPosSlotBits", "kNumPosStatesBitsEncodingMax", "kNumPosStatesBitsMax", "kNumPosStatesEncodingMax", "kNumPosStatesMax", "kNumRepDistances", "kNumStates", "kStartPosModelIndex", "getLenToPosState", "len", "stateInit", "stateIsCharState", "", "index", "stateUpdateChar", "stateUpdateMatch", "stateUpdateRep", "stateUpdateShortRep", "korge-core"})
    public static final class LzmaBase {
        @NotNull
        public static final LzmaBase INSTANCE = new LzmaBase();
        public static final int kNumRepDistances = 4;
        public static final int kNumStates = 12;
        public static final int kNumPosSlotBits = 6;
        public static final int kDicLogSizeMin = 0;
        public static final int kNumLenToPosStatesBits = 2;
        public static final int kNumLenToPosStates = 4;
        public static final int kMatchMinLen = 2;
        public static final int kNumAlignBits = 4;
        public static final int kAlignTableSize = 16;
        public static final int kAlignMask = 15;
        public static final int kStartPosModelIndex = 4;
        public static final int kEndPosModelIndex = 14;
        public static final int kNumFullDistances = 128;
        public static final int kNumLitPosStatesBitsEncodingMax = 4;
        public static final int kNumLitContextBitsMax = 8;
        public static final int kNumPosStatesBitsMax = 4;
        public static final int kNumPosStatesMax = 16;
        public static final int kNumPosStatesBitsEncodingMax = 4;
        public static final int kNumPosStatesEncodingMax = 16;
        public static final int kNumLowLenBits = 3;
        public static final int kNumMidLenBits = 3;
        public static final int kNumHighLenBits = 8;
        public static final int kNumLowLenSymbols = 8;
        public static final int kNumMidLenSymbols = 8;
        public static final int kNumLenSymbols = 272;
        public static final int kMatchMaxLen = 273;

        private LzmaBase() {
        }

        public final int stateInit() {
            return 0;
        }

        public final int stateUpdateChar(int index2) {
            return index2 < 4 ? 0 : (index2 < 10 ? index2 - 3 : index2 - 6);
        }

        public final int stateUpdateMatch(int index2) {
            return index2 < 7 ? 7 : 10;
        }

        public final int stateUpdateRep(int index2) {
            return index2 < 7 ? 8 : 11;
        }

        public final int stateUpdateShortRep(int index2) {
            return index2 < 7 ? 9 : 11;
        }

        public final boolean stateIsCharState(int index2) {
            return index2 < 7;
        }

        public final int getLenToPosState(int len) {
            int len2 = len;
            return (len2 -= 2) < 4 ? len2 : 3;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0017\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\t\u0018\u00002\u00020\u0001:\u000212B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\r\u0010%\u001a\u00020&H\u0000\u00a2\u0006\u0002\b'J\u000e\u0010(\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020*J\u0010\u0010+\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020\u0004H\u0002J \u0010-\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u00042\u0006\u00100\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00060\u000eR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00060\u0010R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0017X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001c\u001a\u00060\u000eR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lkorlibs/io/compression/lzma/SevenZip$LzmaDecoder;", "", "()V", "m_DictionarySize", "", "m_DictionarySizeCheck", "m_IsMatchDecoders", "", "m_IsRep0LongDecoders", "m_IsRepDecoders", "m_IsRepG0Decoders", "m_IsRepG1Decoders", "m_IsRepG2Decoders", "m_LenDecoder", "Lkorlibs/io/compression/lzma/SevenZip$LzmaDecoder$LenDecoder;", "m_LiteralDecoder", "Lkorlibs/io/compression/lzma/SevenZip$LzmaDecoder$LiteralDecoder;", "m_OutWindow", "Lkorlibs/io/compression/lzma/SevenZip$LzOutWindow;", "m_PosAlignDecoder", "Lkorlibs/io/compression/lzma/SevenZip$BitTreeDecoder;", "m_PosDecoders", "m_PosSlotDecoder", "", "[Lkorlibs/io/compression/lzma/SevenZip$BitTreeDecoder;", "m_PosStateMask", "m_RangeDecoder", "Lkorlibs/io/compression/lzma/SevenZip$RangeDecoder;", "m_RepLenDecoder", "code", "", "inStream", "Lkorlibs/io/stream/SyncInputStream;", "outStream", "Lkorlibs/io/stream/SyncOutputStream;", "outSize", "", "init", "", "init$korge_core", "setDecoderProperties", "properties", "", "setDictionarySize", "dictionarySize", "setLcLpPb", "lc", "lp", "pb", "LenDecoder", "LiteralDecoder", "korge-core"})
    public static final class LzmaDecoder {
        @NotNull
        private LzOutWindow m_OutWindow = new LzOutWindow();
        @NotNull
        private RangeDecoder m_RangeDecoder = new RangeDecoder();
        @NotNull
        private short[] m_IsMatchDecoders = new short[192];
        @NotNull
        private short[] m_IsRepDecoders = new short[12];
        @NotNull
        private short[] m_IsRepG0Decoders = new short[12];
        @NotNull
        private short[] m_IsRepG1Decoders = new short[12];
        @NotNull
        private short[] m_IsRepG2Decoders = new short[12];
        @NotNull
        private short[] m_IsRep0LongDecoders = new short[192];
        @NotNull
        private BitTreeDecoder[] m_PosSlotDecoder = new BitTreeDecoder[4];
        @NotNull
        private short[] m_PosDecoders = new short[114];
        @NotNull
        private BitTreeDecoder m_PosAlignDecoder = new BitTreeDecoder(4);
        @NotNull
        private LenDecoder m_LenDecoder = new LenDecoder();
        @NotNull
        private LenDecoder m_RepLenDecoder = new LenDecoder();
        @NotNull
        private LiteralDecoder m_LiteralDecoder = new LiteralDecoder();
        private int m_DictionarySize = -1;
        private int m_DictionarySizeCheck = -1;
        private int m_PosStateMask;

        public LzmaDecoder() {
            for (int i2 = 0; i2 < 4; ++i2) {
                this.m_PosSlotDecoder[i2] = new BitTreeDecoder(6);
            }
        }

        private final boolean setDictionarySize(int dictionarySize) {
            if (dictionarySize < 0) {
                return false;
            }
            if (this.m_DictionarySize != dictionarySize) {
                this.m_DictionarySize = dictionarySize;
                this.m_DictionarySizeCheck = Math.max(this.m_DictionarySize, 1);
                this.m_OutWindow.create(Math.max(this.m_DictionarySizeCheck, 4096));
            }
            return true;
        }

        private final boolean setLcLpPb(int lc, int lp, int pb) {
            if (lc > 8 || lp > 4 || pb > 4) {
                return false;
            }
            this.m_LiteralDecoder.create(lp, lc);
            int numPosStates = 1 << pb;
            this.m_LenDecoder.create(numPosStates);
            this.m_RepLenDecoder.create(numPosStates);
            this.m_PosStateMask = numPosStates - 1;
            return true;
        }

        public final void init$korge_core() {
            this.m_OutWindow.init(false);
            RangeDecoder.Companion.initBitModels(this.m_IsMatchDecoders);
            RangeDecoder.Companion.initBitModels(this.m_IsRep0LongDecoders);
            RangeDecoder.Companion.initBitModels(this.m_IsRepDecoders);
            RangeDecoder.Companion.initBitModels(this.m_IsRepG0Decoders);
            RangeDecoder.Companion.initBitModels(this.m_IsRepG1Decoders);
            RangeDecoder.Companion.initBitModels(this.m_IsRepG2Decoders);
            RangeDecoder.Companion.initBitModels(this.m_PosDecoders);
            this.m_LiteralDecoder.init();
            for (int i2 = 0; i2 < 4; ++i2) {
                BitTreeDecoder bitTreeDecoder = this.m_PosSlotDecoder[i2];
                Intrinsics.checkNotNull(bitTreeDecoder);
                bitTreeDecoder.init();
            }
            this.m_LenDecoder.init();
            this.m_RepLenDecoder.init();
            this.m_PosAlignDecoder.init();
            this.m_RangeDecoder.init();
        }

        public final boolean code(@NotNull SyncInputStream inStream, @NotNull SyncOutputStream outStream, long outSize) {
            this.m_RangeDecoder.setStream(inStream);
            this.m_OutWindow.setStream(outStream);
            this.init$korge_core();
            int state2 = LzmaBase.INSTANCE.stateInit();
            int rep0 = 0;
            int rep1 = 0;
            int rep2 = 0;
            int rep3 = 0;
            long nowPos64 = 0L;
            byte prevByte = 0;
            while (outSize < 0L || nowPos64 < outSize) {
                int posState = (int)nowPos64 & this.m_PosStateMask;
                if (this.m_RangeDecoder.decodeBit(this.m_IsMatchDecoders, (state2 << 4) + posState) == 0) {
                    LiteralDecoder.Decoder2 decoder2 = this.m_LiteralDecoder.getDecoder((int)nowPos64, prevByte);
                    prevByte = !LzmaBase.INSTANCE.stateIsCharState(state2) ? decoder2.decodeWithMatchByte(this.m_RangeDecoder, this.m_OutWindow.getByte(rep0)) : decoder2.decodeNormal(this.m_RangeDecoder);
                    this.m_OutWindow.putByte(prevByte);
                    state2 = LzmaBase.INSTANCE.stateUpdateChar(state2);
                    long l = nowPos64;
                    nowPos64 = l + 1L;
                    continue;
                }
                int len = 0;
                if (this.m_RangeDecoder.decodeBit(this.m_IsRepDecoders, state2) == 1) {
                    len = 0;
                    if (this.m_RangeDecoder.decodeBit(this.m_IsRepG0Decoders, state2) == 0) {
                        if (this.m_RangeDecoder.decodeBit(this.m_IsRep0LongDecoders, (state2 << 4) + posState) == 0) {
                            state2 = LzmaBase.INSTANCE.stateUpdateShortRep(state2);
                            len = 1;
                        }
                    } else {
                        int distance = 0;
                        if (this.m_RangeDecoder.decodeBit(this.m_IsRepG1Decoders, state2) == 0) {
                            distance = rep1;
                        } else {
                            if (this.m_RangeDecoder.decodeBit(this.m_IsRepG2Decoders, state2) == 0) {
                                distance = rep2;
                            } else {
                                distance = rep3;
                                rep3 = rep2;
                            }
                            rep2 = rep1;
                        }
                        rep1 = rep0;
                        rep0 = distance;
                    }
                    if (len == 0) {
                        len = this.m_RepLenDecoder.decode(this.m_RangeDecoder, posState) + 2;
                        state2 = LzmaBase.INSTANCE.stateUpdateRep(state2);
                    }
                } else {
                    rep3 = rep2;
                    rep2 = rep1;
                    rep1 = rep0;
                    len = 2 + this.m_LenDecoder.decode(this.m_RangeDecoder, posState);
                    state2 = LzmaBase.INSTANCE.stateUpdateMatch(state2);
                    BitTreeDecoder bitTreeDecoder = this.m_PosSlotDecoder[LzmaBase.INSTANCE.getLenToPosState(len)];
                    Intrinsics.checkNotNull(bitTreeDecoder);
                    int posSlot = bitTreeDecoder.decode(this.m_RangeDecoder);
                    if (posSlot >= 4) {
                        int numDirectBits = (posSlot >> 1) - 1;
                        rep0 = (2 | posSlot & 1) << numDirectBits;
                        if (posSlot < 14) {
                            rep0 += BitTreeDecoder.Companion.reverseDecode(this.m_PosDecoders, rep0 - posSlot - 1, this.m_RangeDecoder, numDirectBits);
                        } else {
                            rep0 += this.m_RangeDecoder.decodeDirectBits(numDirectBits - 4) << 4;
                            if ((rep0 += this.m_PosAlignDecoder.reverseDecode(this.m_RangeDecoder)) < 0) {
                                if (rep0 == -1) break;
                                return false;
                            }
                        }
                    } else {
                        rep0 = posSlot;
                    }
                }
                if ((long)rep0 >= nowPos64 || rep0 >= this.m_DictionarySizeCheck) {
                    return false;
                }
                this.m_OutWindow.copyBlock(rep0, len);
                nowPos64 += (long)len;
                prevByte = this.m_OutWindow.getByte(0);
            }
            this.m_OutWindow.flush();
            this.m_OutWindow.releaseStream();
            this.m_RangeDecoder.releaseStream();
            return true;
        }

        public final boolean setDecoderProperties(@NotNull byte[] properties2) {
            if (properties2.length < 5) {
                return false;
            }
            int val = SevenZipKt.access$and(properties2[0], 255);
            int lc = val % 9;
            int remainder = val / 9;
            int lp = remainder % 5;
            int pb = remainder / 5;
            int dictionarySize = 0;
            for (int i2 = 0; i2 < 4; ++i2) {
                dictionarySize += (properties2[1 + i2] & 0xFF) << i2 * 8;
            }
            return !this.setLcLpPb(lc, lp, pb) ? false : this.setDictionarySize(dictionarySize);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fJ\u0016\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\fJ\u0006\u0010\u0014\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u0018\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lkorlibs/io/compression/lzma/SevenZip$LzmaDecoder$LenDecoder;", "", "(Lkorlibs/io/compression/lzma/SevenZip$LzmaDecoder;)V", "m_Choice", "", "m_HighCoder", "Lkorlibs/io/compression/lzma/SevenZip$BitTreeDecoder;", "m_LowCoder", "", "[Lkorlibs/io/compression/lzma/SevenZip$BitTreeDecoder;", "m_MidCoder", "m_NumPosStates", "", "create", "", "numPosStates", "decode", "rangeDecoder", "Lkorlibs/io/compression/lzma/SevenZip$RangeDecoder;", "posState", "init", "korge-core"})
        public final class LenDecoder {
            @NotNull
            private short[] m_Choice = new short[2];
            @NotNull
            private BitTreeDecoder[] m_LowCoder = new BitTreeDecoder[16];
            @NotNull
            private BitTreeDecoder[] m_MidCoder = new BitTreeDecoder[16];
            @NotNull
            private BitTreeDecoder m_HighCoder = new BitTreeDecoder(8);
            private int m_NumPosStates;

            public final void create(int numPosStates) {
                while (this.m_NumPosStates < numPosStates) {
                    this.m_LowCoder[this.m_NumPosStates] = new BitTreeDecoder(3);
                    this.m_MidCoder[this.m_NumPosStates] = new BitTreeDecoder(3);
                    int n = this.m_NumPosStates;
                    this.m_NumPosStates = n + 1;
                }
            }

            public final void init() {
                RangeDecoder.Companion.initBitModels(this.m_Choice);
                int n = this.m_NumPosStates;
                for (int posState = 0; posState < n; ++posState) {
                    BitTreeDecoder bitTreeDecoder = this.m_LowCoder[posState];
                    Intrinsics.checkNotNull(bitTreeDecoder);
                    bitTreeDecoder.init();
                    BitTreeDecoder bitTreeDecoder2 = this.m_MidCoder[posState];
                    Intrinsics.checkNotNull(bitTreeDecoder2);
                    bitTreeDecoder2.init();
                }
                this.m_HighCoder.init();
            }

            public final int decode(@NotNull RangeDecoder rangeDecoder, int posState) {
                int n;
                if (rangeDecoder.decodeBit(this.m_Choice, 0) == 0) {
                    BitTreeDecoder bitTreeDecoder = this.m_LowCoder[posState];
                    Intrinsics.checkNotNull(bitTreeDecoder);
                    return bitTreeDecoder.decode(rangeDecoder);
                }
                int symbol = 8;
                if (rangeDecoder.decodeBit(this.m_Choice, 1) == 0) {
                    BitTreeDecoder bitTreeDecoder = this.m_MidCoder[posState];
                    Intrinsics.checkNotNull(bitTreeDecoder);
                    n = bitTreeDecoder.decode(rangeDecoder);
                } else {
                    n = 8 + this.m_HighCoder.decode(rangeDecoder);
                }
                return symbol += n;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0005\n\u0002\b\u0003\b\u0080\u0004\u0018\u00002\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\tJ\u001e\u0010\u0010\u001a\n0\u0005R\u00060\u0000R\u00020\u00062\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\rR \u0010\u0003\u001a\u0012\u0012\f\u0012\n0\u0005R\u00060\u0000R\u00020\u0006\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lkorlibs/io/compression/lzma/SevenZip$LzmaDecoder$LiteralDecoder;", "", "(Lkorlibs/io/compression/lzma/SevenZip$LzmaDecoder;)V", "m_Coders", "", "Lkorlibs/io/compression/lzma/SevenZip$LzmaDecoder$LiteralDecoder$Decoder2;", "Lkorlibs/io/compression/lzma/SevenZip$LzmaDecoder;", "[Lkorlibs/io/compression/lzma/SevenZip$LzmaDecoder$LiteralDecoder$Decoder2;", "m_NumPosBits", "", "m_NumPrevBits", "m_PosMask", "create", "", "numPosBits", "numPrevBits", "getDecoder", "pos", "prevByte", "", "init", "Decoder2", "korge-core"})
        public final class LiteralDecoder {
            @Nullable
            private Decoder2[] m_Coders;
            private int m_NumPrevBits;
            private int m_NumPosBits;
            private int m_PosMask;

            public final void create(int numPosBits, int numPrevBits) {
                if (this.m_Coders != null && this.m_NumPrevBits == numPrevBits && this.m_NumPosBits == numPosBits) {
                    return;
                }
                this.m_NumPosBits = numPosBits;
                this.m_PosMask = (1 << numPosBits) - 1;
                this.m_NumPrevBits = numPrevBits;
                int numStates = 1 << this.m_NumPrevBits + this.m_NumPosBits;
                int n = 0;
                Decoder2[] decoder2Array = new Decoder2[numStates];
                LiteralDecoder literalDecoder = this;
                while (n < numStates) {
                    int n2 = n++;
                    decoder2Array[n2] = new Decoder2();
                }
                literalDecoder.m_Coders = decoder2Array;
            }

            public final void init() {
                int numStates = 1 << this.m_NumPrevBits + this.m_NumPosBits;
                for (int i2 = 0; i2 < numStates; ++i2) {
                    Intrinsics.checkNotNull(this.m_Coders);
                    this.m_Coders[i2].init();
                }
            }

            @NotNull
            public final Decoder2 getDecoder(int pos, byte prevByte) {
                Intrinsics.checkNotNull(this.m_Coders);
                return this.m_Coders[((pos & this.m_PosMask) << this.m_NumPrevBits) + (SevenZipKt.access$and(prevByte, 255) >>> 8 - this.m_NumPrevBits)];
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0017\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0006J\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lkorlibs/io/compression/lzma/SevenZip$LzmaDecoder$LiteralDecoder$Decoder2;", "", "(Lkorlibs/io/compression/lzma/SevenZip$LzmaDecoder$LiteralDecoder;)V", "m_Decoders", "", "decodeNormal", "", "rangeDecoder", "Lkorlibs/io/compression/lzma/SevenZip$RangeDecoder;", "decodeWithMatchByte", "matchByte", "init", "", "korge-core"})
            public final class Decoder2 {
                @NotNull
                private short[] m_Decoders = new short[768];

                public final void init() {
                    RangeDecoder.Companion.initBitModels(this.m_Decoders);
                }

                public final byte decodeNormal(@NotNull RangeDecoder rangeDecoder) {
                    int symbol = 1;
                    while ((symbol = symbol << 1 | rangeDecoder.decodeBit(this.m_Decoders, symbol)) < 256) {
                    }
                    return (byte)symbol;
                }

                public final byte decodeWithMatchByte(@NotNull RangeDecoder rangeDecoder, byte matchByte) {
                    byte matchByte2 = matchByte;
                    int symbol = 1;
                    do {
                        int matchBit = SevenZipKt.access$shr(matchByte2, 7) & 1;
                        matchByte2 = (byte)SevenZipKt.access$shl(matchByte2, 1);
                        int bit = rangeDecoder.decodeBit(this.m_Decoders, (1 + matchBit << 8) + symbol);
                        symbol = symbol << 1 | bit;
                        if (matchBit == bit) continue;
                        while (symbol < 256) {
                            symbol = symbol << 1 | rangeDecoder.decodeBit(this.m_Decoders, symbol);
                        }
                        break;
                    } while (symbol < 256);
                    return (byte)symbol;
                }
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0017\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0018\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b2\u0018\u0000 \u0083\u00012\u00020\u0001:\n\u0083\u0001\u0084\u0001\u0085\u0001\u0086\u0001\u0087\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010K\u001a\u00020\u00042\u0006\u0010L\u001a\u00020\u0004H\u0002J\b\u0010M\u001a\u00020NH\u0002J0\u0010O\u001a\u00020N2\u0006\u0010P\u001a\u00020\u000f2\u0006\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020B2\u0006\u0010T\u001a\u00020B2\b\u0010U\u001a\u0004\u0018\u00010VJ \u0010W\u001a\u00020N2\u0006\u0010S\u001a\u00020D2\u0006\u0010T\u001a\u00020D2\u0006\u0010?\u001a\u00020@H\u0002J\r\u0010X\u001a\u00020NH\u0000\u00a2\u0006\u0002\bYJ\b\u0010Z\u001a\u00020NH\u0002J\b\u0010[\u001a\u00020NH\u0002J\u0010\u0010\\\u001a\u00020N2\u0006\u0010]\u001a\u00020\u0004H\u0002J\u0010\u0010^\u001a\u00020\u00042\u0006\u0010_\u001a\u00020\u0004H\u0002J \u0010`\u001a\u00020\u00042\u0006\u0010a\u001a\u00020\u00042\u0006\u0010b\u001a\u00020\u00042\u0006\u0010c\u001a\u00020\u0004H\u0002J \u0010d\u001a\u00020\u00042\u0006\u0010e\u001a\u00020\u00042\u0006\u0010f\u001a\u00020\u00042\u0006\u0010c\u001a\u00020\u0004H\u0002J\u0018\u0010g\u001a\u00020\u00042\u0006\u0010f\u001a\u00020\u00042\u0006\u0010c\u001a\u00020\u0004H\u0002J(\u0010h\u001a\u00020\u00042\u0006\u0010e\u001a\u00020\u00042\u0006\u0010b\u001a\u00020\u00042\u0006\u0010f\u001a\u00020\u00042\u0006\u0010c\u001a\u00020\u0004H\u0002J\r\u0010i\u001a\u00020NH\u0000\u00a2\u0006\u0002\bjJ\u0010\u0010k\u001a\u00020N2\u0006\u0010l\u001a\u00020\u0004H\u0002J\b\u0010m\u001a\u00020\u0004H\u0002J\b\u0010n\u001a\u00020NH\u0002J\b\u0010o\u001a\u00020NH\u0002J\b\u0010p\u001a\u00020NH\u0002J\u000e\u0010q\u001a\u00020\r2\u0006\u0010r\u001a\u00020\u0004J\u000e\u0010s\u001a\u00020\r2\u0006\u0010t\u001a\u00020\u0004J\u000e\u0010u\u001a\u00020N2\u0006\u0010v\u001a\u00020\rJ\u001e\u0010w\u001a\u00020\r2\u0006\u0010x\u001a\u00020\u00042\u0006\u0010y\u001a\u00020\u00042\u0006\u0010z\u001a\u00020\u0004J\u000e\u0010{\u001a\u00020\r2\u0006\u0010|\u001a\u00020\u0004J\u000e\u0010}\u001a\u00020\r2\u0006\u0010~\u001a\u00020\u0004J\u0010\u0010\u007f\u001a\u00020N2\u0006\u0010Q\u001a\u00020RH\u0002J)\u0010\u0080\u0001\u001a\u00020N2\u0006\u0010P\u001a\u00020\u000f2\u0006\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020B2\u0006\u0010T\u001a\u00020BH\u0002J\u000f\u0010\u0081\u0001\u001a\u00020N2\u0006\u0010Q\u001a\u00020RJ\u0011\u0010\u0082\u0001\u001a\u00020N2\u0006\u0010c\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0017\u001a\u00060\u0018R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0019\u001a\u00060\u001aR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010(\u001a\f\u0012\b\u0012\u00060*R\u00020\u00000)X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010+R\u000e\u0010,\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u00101\u001a\b\u0012\u0004\u0012\u00020/0)X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u00102R\u000e\u00103\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u000207X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u000209X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010;\u001a\u00060\u0018R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020@X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020BX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010C\u001a\u00020DX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010E\u001a\u00020DX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010F\u001a\u00020GX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010H\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010I\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010J\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0088\u0001"}, d2={"Lkorlibs/io/compression/lzma/SevenZip$LzmaEncoder;", "", "()V", "_additionalOffset", "", "_alignPriceCount", "_alignPrices", "", "_dictionarySize", "_dictionarySizePrev", "_distTableSize", "_distancesPrices", "_finished", "", "_inStream", "Lkorlibs/io/stream/SyncInputStream;", "_isMatch", "", "_isRep", "_isRep0Long", "_isRepG0", "_isRepG1", "_isRepG2", "_lenEncoder", "Lkorlibs/io/compression/lzma/SevenZip$LzmaEncoder$LenPriceTableEncoder;", "_literalEncoder", "Lkorlibs/io/compression/lzma/SevenZip$LzmaEncoder$LiteralEncoder;", "_longestMatchLength", "_longestMatchWasFound", "_matchDistances", "_matchFinder", "Lkorlibs/io/compression/lzma/SevenZip$LzBinTree;", "_matchFinderType", "_matchPriceCount", "_needReleaseMFStream", "_numDistancePairs", "_numFastBytes", "_numFastBytesPrev", "_numLiteralContextBits", "_numLiteralPosStateBits", "_optimum", "", "Lkorlibs/io/compression/lzma/SevenZip$LzmaEncoder$Optimal;", "[Lkorlibs/io/compression/lzma/SevenZip$LzmaEncoder$Optimal;", "_optimumCurrentIndex", "_optimumEndIndex", "_posAlignEncoder", "Lkorlibs/io/compression/lzma/SevenZip$BitTreeEncoder;", "_posEncoders", "_posSlotEncoder", "[Lkorlibs/io/compression/lzma/SevenZip$BitTreeEncoder;", "_posSlotPrices", "_posStateBits", "_posStateMask", "_previousByte", "", "_rangeEncoder", "Lkorlibs/io/compression/lzma/SevenZip$RangeEncoder;", "_repDistances", "_repMatchLenEncoder", "_state", "_writeEndMark", "backRes", "finished", "", "nowPos64", "", "processedInSize", "", "processedOutSize", "properties", "", "repLens", "reps", "tempPrices", "backward", "cur", "baseInit", "", "code", "inStream", "outStream", "Lkorlibs/io/stream/SyncOutputStream;", "inSize", "outSize", "progress", "Lkorlibs/io/compression/lzma/SevenZip$ICodeProgress;", "codeOneBlock", "create", "create$korge_core", "fillAlignPrices", "fillDistancesPrices", "flush", "nowPos", "getOptimum", "position", "getPosLenPrice", "pos", "len", "posState", "getPureRepPrice", "repIndex", "state", "getRepLen1Price", "getRepPrice", "init", "init$korge_core", "movePos", "num", "readMatchDistances", "releaseMFStream", "releaseOutStream", "releaseStreams", "setAlgorithm", "algorithm", "setDictionarySize", "dictionarySize", "setEndMarkerMode", "endMarkerMode", "setLcLpPb", "lc", "lp", "pb", "setMatchFinder", "matchFinderIndex", "setNumFastBytes", "numFastBytes", "setOutStream", "setStreams", "writeCoderProperties", "writeEndMarker", "Companion", "LenEncoder", "LenPriceTableEncoder", "LiteralEncoder", "Optimal", "korge-core"})
    public static final class LzmaEncoder {
        @NotNull
        public static final Companion Companion;
        private int _state = LzmaBase.INSTANCE.stateInit();
        private byte _previousByte;
        @NotNull
        private int[] _repDistances = new int[4];
        @NotNull
        private Optimal[] _optimum;
        @Nullable
        private LzBinTree _matchFinder;
        @NotNull
        private RangeEncoder _rangeEncoder;
        @NotNull
        private short[] _isMatch;
        @NotNull
        private short[] _isRep;
        @NotNull
        private short[] _isRepG0;
        @NotNull
        private short[] _isRepG1;
        @NotNull
        private short[] _isRepG2;
        @NotNull
        private short[] _isRep0Long;
        @NotNull
        private BitTreeEncoder[] _posSlotEncoder;
        @NotNull
        private short[] _posEncoders;
        @NotNull
        private BitTreeEncoder _posAlignEncoder;
        @NotNull
        private LenPriceTableEncoder _lenEncoder;
        @NotNull
        private LenPriceTableEncoder _repMatchLenEncoder;
        @NotNull
        private LiteralEncoder _literalEncoder;
        @NotNull
        private int[] _matchDistances;
        private int _numFastBytes;
        private int _longestMatchLength;
        private int _numDistancePairs;
        private int _additionalOffset;
        private int _optimumEndIndex;
        private int _optimumCurrentIndex;
        private boolean _longestMatchWasFound;
        @NotNull
        private int[] _posSlotPrices;
        @NotNull
        private int[] _distancesPrices;
        @NotNull
        private int[] _alignPrices;
        private int _alignPriceCount;
        private int _distTableSize;
        private int _posStateBits;
        private int _posStateMask;
        private int _numLiteralPosStateBits;
        private int _numLiteralContextBits;
        private int _dictionarySize;
        private int _dictionarySizePrev;
        private int _numFastBytesPrev;
        private long nowPos64;
        private boolean _finished;
        @Nullable
        private SyncInputStream _inStream;
        private int _matchFinderType;
        private boolean _writeEndMark;
        private boolean _needReleaseMFStream;
        @NotNull
        private int[] reps;
        @NotNull
        private int[] repLens;
        private int backRes;
        @NotNull
        private long[] processedInSize;
        @NotNull
        private long[] processedOutSize;
        @NotNull
        private boolean[] finished;
        @NotNull
        private byte[] properties;
        @NotNull
        private int[] tempPrices;
        private int _matchPriceCount;
        public static final int EMatchFinderTypeBT2 = 0;
        public static final int EMatchFinderTypeBT4 = 1;
        public static final int kIfinityPrice = 0xFFFFFFF;
        @NotNull
        private static final byte[] g_FastPos;
        public static final int kDefaultDictionaryLogSize = 22;
        public static final int kNumFastBytesDefault = 32;
        public static final int kNumOpts = 4096;
        public static final int kPropSize = 5;

        public LzmaEncoder() {
            int n;
            int n2 = 0;
            Object[] objectArray = new Optimal[4096];
            LzmaEncoder lzmaEncoder = this;
            while (n2 < 4096) {
                n = n2++;
                objectArray[n] = new Optimal();
            }
            lzmaEncoder._optimum = objectArray;
            this._rangeEncoder = new RangeEncoder();
            this._isMatch = new short[192];
            this._isRep = new short[12];
            this._isRepG0 = new short[12];
            this._isRepG1 = new short[12];
            this._isRepG2 = new short[12];
            this._isRep0Long = new short[192];
            n2 = 0;
            objectArray = new BitTreeEncoder[4];
            lzmaEncoder = this;
            while (n2 < 4) {
                n = n2++;
                objectArray[n] = new BitTreeEncoder(6);
            }
            lzmaEncoder._posSlotEncoder = objectArray;
            this._posEncoders = new short[114];
            this._posAlignEncoder = new BitTreeEncoder(4);
            this._lenEncoder = new LenPriceTableEncoder();
            this._repMatchLenEncoder = new LenPriceTableEncoder();
            this._literalEncoder = new LiteralEncoder();
            this._matchDistances = new int[548];
            this._numFastBytes = 32;
            this._posSlotPrices = new int[256];
            this._distancesPrices = new int[512];
            this._alignPrices = new int[16];
            this._distTableSize = 44;
            this._posStateBits = 2;
            this._posStateMask = 3;
            this._numLiteralContextBits = 3;
            this._dictionarySize = 0x400000;
            this._dictionarySizePrev = -1;
            this._numFastBytesPrev = -1;
            this._matchFinderType = 1;
            this.reps = new int[4];
            this.repLens = new int[4];
            this.processedInSize = new long[1];
            this.processedOutSize = new long[1];
            this.finished = new boolean[1];
            this.properties = new byte[5];
            this.tempPrices = new int[128];
        }

        private final void baseInit() {
            this._state = LzmaBase.INSTANCE.stateInit();
            this._previousByte = 0;
            for (int i2 = 0; i2 < 4; ++i2) {
                this._repDistances[i2] = 0;
            }
        }

        public final void create$korge_core() {
            if (this._matchFinder == null) {
                LzBinTree bt = new LzBinTree();
                int numHashBytes = 4;
                if (this._matchFinderType == 0) {
                    numHashBytes = 2;
                }
                bt.setType(numHashBytes);
                this._matchFinder = bt;
            }
            this._literalEncoder.create(this._numLiteralPosStateBits, this._numLiteralContextBits);
            if (this._dictionarySize == this._dictionarySizePrev && this._numFastBytesPrev == this._numFastBytes) {
                return;
            }
            LzBinTree lzBinTree = this._matchFinder;
            Intrinsics.checkNotNull(lzBinTree);
            lzBinTree.create(this._dictionarySize, 4096, this._numFastBytes, 274);
            this._dictionarySizePrev = this._dictionarySize;
            this._numFastBytesPrev = this._numFastBytes;
        }

        public final void init$korge_core() {
            this.baseInit();
            this._rangeEncoder.init();
            RangeEncoder.Companion.initBitModels(this._isMatch);
            RangeEncoder.Companion.initBitModels(this._isRep0Long);
            RangeEncoder.Companion.initBitModels(this._isRep);
            RangeEncoder.Companion.initBitModels(this._isRepG0);
            RangeEncoder.Companion.initBitModels(this._isRepG1);
            RangeEncoder.Companion.initBitModels(this._isRepG2);
            RangeEncoder.Companion.initBitModels(this._posEncoders);
            this._literalEncoder.init();
            for (int i2 = 0; i2 < 4; ++i2) {
                this._posSlotEncoder[i2].init();
            }
            this._lenEncoder.init(1 << this._posStateBits);
            this._repMatchLenEncoder.init(1 << this._posStateBits);
            this._posAlignEncoder.init();
            this._longestMatchWasFound = false;
            this._optimumEndIndex = 0;
            this._optimumCurrentIndex = 0;
            this._additionalOffset = 0;
        }

        private final int readMatchDistances() {
            int lenRes = 0;
            LzBinTree lzBinTree = this._matchFinder;
            Intrinsics.checkNotNull(lzBinTree);
            this._numDistancePairs = lzBinTree.getMatches(this._matchDistances);
            if (this._numDistancePairs > 0 && (lenRes = this._matchDistances[this._numDistancePairs - 2]) == this._numFastBytes) {
                LzBinTree lzBinTree2 = this._matchFinder;
                Intrinsics.checkNotNull(lzBinTree2);
                lenRes += lzBinTree2.getMatchLen(lenRes - 1, this._matchDistances[this._numDistancePairs - 1], 273 - lenRes);
            }
            int n = this._additionalOffset;
            this._additionalOffset = n + 1;
            return lenRes;
        }

        private final void movePos(int num) {
            if (num > 0) {
                LzBinTree lzBinTree = this._matchFinder;
                Intrinsics.checkNotNull(lzBinTree);
                lzBinTree.skip(num);
                this._additionalOffset += num;
            }
        }

        private final int getRepLen1Price(int state2, int posState) {
            return RangeEncoder.Companion.getPrice0(this._isRepG0[state2]) + RangeEncoder.Companion.getPrice0(this._isRep0Long[(state2 << 4) + posState]);
        }

        private final int getPureRepPrice(int repIndex, int state2, int posState) {
            int price = 0;
            if (repIndex == 0) {
                price = RangeEncoder.Companion.getPrice0(this._isRepG0[state2]);
                price += RangeEncoder.Companion.getPrice1(this._isRep0Long[(state2 << 4) + posState]);
            } else {
                price = RangeEncoder.Companion.getPrice1(this._isRepG0[state2]);
                if (repIndex == 1) {
                    price += RangeEncoder.Companion.getPrice0(this._isRepG1[state2]);
                } else {
                    price += RangeEncoder.Companion.getPrice1(this._isRepG1[state2]);
                    price += RangeEncoder.Companion.getPrice(this._isRepG2[state2], repIndex - 2);
                }
            }
            return price;
        }

        private final int getRepPrice(int repIndex, int len, int state2, int posState) {
            int price = this._repMatchLenEncoder.getPrice(len - 2, posState);
            return price + this.getPureRepPrice(repIndex, state2, posState);
        }

        private final int getPosLenPrice(int pos, int len, int posState) {
            int price = 0;
            int lenToPosState = LzmaBase.INSTANCE.getLenToPosState(len);
            price = pos < 128 ? this._distancesPrices[lenToPosState * 128 + pos] : this._posSlotPrices[(lenToPosState << 6) + Companion.getPosSlot2$korge_core(pos)] + this._alignPrices[pos & 0xF];
            return price + this._lenEncoder.getPrice(len - 2, posState);
        }

        private final int backward(int cur) {
            int posPrev;
            int cc;
            this._optimumEndIndex = cc = cur;
            int posMem = this._optimum[cc].getPosPrev();
            int backMem = this._optimum[cc].getBackPrev();
            do {
                if (this._optimum[cc].getPrev1IsChar()) {
                    this._optimum[posMem].makeAsChar();
                    this._optimum[posMem].setPosPrev(posMem - 1);
                    if (this._optimum[cc].getPrev2()) {
                        this._optimum[posMem - 1].setPrev1IsChar(false);
                        this._optimum[posMem - 1].setPosPrev(this._optimum[cc].getPosPrev2());
                        this._optimum[posMem - 1].setBackPrev(this._optimum[cc].getBackPrev2());
                    }
                }
                posPrev = posMem;
                int backCur = backMem;
                backMem = this._optimum[posPrev].getBackPrev();
                posMem = this._optimum[posPrev].getPosPrev();
                this._optimum[posPrev].setBackPrev(backCur);
                this._optimum[posPrev].setPosPrev(cc);
            } while ((cc = posPrev) > 0);
            this.backRes = this._optimum[0].getBackPrev();
            this._optimumCurrentIndex = this._optimum[0].getPosPrev();
            return this._optimumCurrentIndex;
        }

        /*
         * Unable to fully structure code
         */
        private final int getOptimum(int position) {
            ppos = position;
            if (this._optimumEndIndex != this._optimumCurrentIndex) {
                lenRes = this._optimum[this._optimumCurrentIndex].getPosPrev() - this._optimumCurrentIndex;
                this.backRes = this._optimum[this._optimumCurrentIndex].getBackPrev();
                this._optimumCurrentIndex = this._optimum[this._optimumCurrentIndex].getPosPrev();
                return lenRes;
            }
            this._optimumCurrentIndex = this._optimumEndIndex = 0;
            lenMain = 0;
            numDistancePairs = 0;
            if (!this._longestMatchWasFound) {
                lenMain = this.readMatchDistances();
            } else {
                lenMain = this._longestMatchLength;
                this._longestMatchWasFound = false;
            }
            numDistancePairs = this._numDistancePairs;
            v0 = this._matchFinder;
            Intrinsics.checkNotNull(v0);
            numAvailableBytes = v0.getNumAvailableBytes() + 1;
            if (numAvailableBytes < 2) {
                this.backRes = -1;
                return 1;
            }
            if (numAvailableBytes > 273) {
                numAvailableBytes = 273;
            }
            repMaxIndex = 0;
            for (i = 0; i < 4; ++i) {
                this.reps[i] = this._repDistances[i];
                v1 = this._matchFinder;
                Intrinsics.checkNotNull(v1);
                this.repLens[i] = v1.getMatchLen(-1, this.reps[i], 273);
                if (this.repLens[i] <= this.repLens[repMaxIndex]) continue;
                repMaxIndex = i;
            }
            if (this.repLens[repMaxIndex] >= this._numFastBytes) {
                this.backRes = repMaxIndex;
                lenRes = this.repLens[repMaxIndex];
                this.movePos(lenRes - 1);
                return lenRes;
            }
            if (lenMain >= this._numFastBytes) {
                this.backRes = this._matchDistances[numDistancePairs - 1] + 4;
                this.movePos(lenMain - 1);
                return lenMain;
            }
            v2 = this._matchFinder;
            Intrinsics.checkNotNull(v2);
            currentByte = v2.getIndexByte(-1);
            v3 = this._matchFinder;
            Intrinsics.checkNotNull(v3);
            matchByte = v3.getIndexByte(0 - this._repDistances[0] - 1 - 1);
            if (lenMain < 2 && currentByte != matchByte && this.repLens[repMaxIndex] < 2) {
                this.backRes = -1;
                return 1;
            }
            this._optimum[0].setState(this._state);
            posState = ppos & this._posStateMask;
            this._optimum[1].setPrice(RangeEncoder.Companion.getPrice0(this._isMatch[(this._state << 4) + posState]) + this._literalEncoder.getSubCoder(ppos, this._previousByte).getPrice(LzmaBase.INSTANCE.stateIsCharState(this._state) == false, matchByte, currentByte));
            this._optimum[1].makeAsChar();
            matchPrice = RangeEncoder.Companion.getPrice1(this._isMatch[(this._state << 4) + posState]);
            repMatchPrice = matchPrice + RangeEncoder.Companion.getPrice1(this._isRep[this._state]);
            if (matchByte == currentByte && (shortRepPrice = repMatchPrice + this.getRepLen1Price(this._state, posState)) < this._optimum[1].getPrice()) {
                this._optimum[1].setPrice(shortRepPrice);
                this._optimum[1].makeAsShortRep();
            }
            lenEnd = 0;
            v4 = lenEnd = lenMain >= this.repLens[repMaxIndex] ? lenMain : this.repLens[repMaxIndex];
            if (lenEnd < 2) {
                this.backRes = this._optimum[1].getBackPrev();
                return 1;
            }
            this._optimum[1].setPosPrev(0);
            this._optimum[0].setBacks0(this.reps[0]);
            this._optimum[0].setBacks1(this.reps[1]);
            this._optimum[0].setBacks2(this.reps[2]);
            this._optimum[0].setBacks3(this.reps[3]);
            len = lenEnd;
            do {
                this._optimum[len--].setPrice(0xFFFFFFF);
            } while (len >= 2);
            i = 0;
            while (i < 4) {
                repLen = this.repLens[i];
                if (repLen < 2) {
                    ++i;
                    continue;
                }
                price = repMatchPrice + this.getPureRepPrice(i, this._state, posState);
                do {
                    if ((curAndLenPrice = price + this._repMatchLenEncoder.getPrice(repLen - 2, posState)) >= (optimum = this._optimum[repLen]).getPrice()) continue;
                    optimum.setPrice(curAndLenPrice);
                    optimum.setPosPrev(0);
                    optimum.setBackPrev(i);
                    optimum.setPrev1IsChar(false);
                } while (--repLen >= 2);
                ++i;
            }
            normalMatchPrice = matchPrice + RangeEncoder.Companion.getPrice0(this._isRep[this._state]);
            v5 = len = this.repLens[0] >= 2 ? this.repLens[0] + 1 : 2;
            if (len <= lenMain) {
                offs = 0;
                while (len > this._matchDistances[offs]) {
                    offs += 2;
                }
                while (true) {
                    if ((curAndLenPrice = normalMatchPrice + this.getPosLenPrice(distance = this._matchDistances[offs + 1], len, posState)) < (optimum = this._optimum[len]).getPrice()) {
                        optimum.setPrice(curAndLenPrice);
                        optimum.setPosPrev(0);
                        optimum.setBackPrev(distance + 4);
                        optimum.setPrev1IsChar(false);
                    }
                    if (len == this._matchDistances[offs]) {
                        if ((offs += 2) == numDistancePairs) break;
                    }
                    ++len;
                }
            }
            cur = 0;
            block11: while (true) {
                if ((cur = (distance = cur) + 1) == lenEnd) {
                    return this.backward(cur);
                }
                newLen = this.readMatchDistances();
                numDistancePairs = this._numDistancePairs;
                if (newLen >= this._numFastBytes) {
                    this._longestMatchLength = newLen;
                    this._longestMatchWasFound = true;
                    return this.backward(cur);
                }
                ++ppos;
                posPrev = this._optimum[cur].getPosPrev();
                state = 0;
                if (this._optimum[cur].getPrev1IsChar()) {
                    --posPrev;
                    if (this._optimum[cur].getPrev2()) {
                        state = this._optimum[this._optimum[cur].getPosPrev2()].getState();
                        state = this._optimum[cur].getBackPrev2() < 4 ? LzmaBase.INSTANCE.stateUpdateRep(state) : LzmaBase.INSTANCE.stateUpdateMatch(state);
                    } else {
                        state = this._optimum[posPrev].getState();
                    }
                    state = LzmaBase.INSTANCE.stateUpdateChar(state);
                } else {
                    state = this._optimum[posPrev].getState();
                }
                if (posPrev == cur - 1) {
                    state = this._optimum[cur].isShortRep() != false ? LzmaBase.INSTANCE.stateUpdateShortRep(state) : LzmaBase.INSTANCE.stateUpdateChar(state);
                } else {
                    pos = 0;
                    if (this._optimum[cur].getPrev1IsChar() && this._optimum[cur].getPrev2()) {
                        posPrev = this._optimum[cur].getPosPrev2();
                        pos = this._optimum[cur].getBackPrev2();
                        state = LzmaBase.INSTANCE.stateUpdateRep(state);
                    } else {
                        pos = this._optimum[cur].getBackPrev();
                        state = pos < 4 ? LzmaBase.INSTANCE.stateUpdateRep(state) : LzmaBase.INSTANCE.stateUpdateMatch(state);
                    }
                    opt = this._optimum[posPrev];
                    if (pos < 4) {
                        switch (pos) {
                            case 0: {
                                this.reps[0] = opt.getBacks0();
                                this.reps[1] = opt.getBacks1();
                                this.reps[2] = opt.getBacks2();
                                this.reps[3] = opt.getBacks3();
                                v6 = Unit.INSTANCE;
                                break;
                            }
                            case 1: {
                                this.reps[0] = opt.getBacks1();
                                this.reps[1] = opt.getBacks0();
                                this.reps[2] = opt.getBacks2();
                                this.reps[3] = opt.getBacks3();
                                v6 = Unit.INSTANCE;
                                break;
                            }
                            case 2: {
                                this.reps[0] = opt.getBacks2();
                                this.reps[1] = opt.getBacks0();
                                this.reps[2] = opt.getBacks1();
                                this.reps[3] = opt.getBacks3();
                                v6 = Unit.INSTANCE;
                                break;
                            }
                            default: {
                                this.reps[0] = opt.getBacks3();
                                this.reps[1] = opt.getBacks0();
                                this.reps[2] = opt.getBacks1();
                                this.reps[3] = opt.getBacks2();
                                v6 = Unit.INSTANCE;
                            }
                        }
                    } else {
                        this.reps[0] = pos - 4;
                        this.reps[1] = opt.getBacks0();
                        this.reps[2] = opt.getBacks1();
                        this.reps[3] = opt.getBacks2();
                    }
                }
                this._optimum[cur].setState(state);
                this._optimum[cur].setBacks0(this.reps[0]);
                this._optimum[cur].setBacks1(this.reps[1]);
                this._optimum[cur].setBacks2(this.reps[2]);
                this._optimum[cur].setBacks3(this.reps[3]);
                curPrice = this._optimum[cur].getPrice();
                v7 = this._matchFinder;
                Intrinsics.checkNotNull(v7);
                currentByte = v7.getIndexByte(-1);
                v8 = this._matchFinder;
                Intrinsics.checkNotNull(v8);
                matchByte = v8.getIndexByte(0 - this.reps[0] - 1 - 1);
                posState = ppos & this._posStateMask;
                v9 = curPrice + RangeEncoder.Companion.getPrice0(this._isMatch[(state << 4) + posState]);
                v10 = this._matchFinder;
                Intrinsics.checkNotNull(v10);
                curAnd1Price = v9 + this._literalEncoder.getSubCoder(ppos, v10.getIndexByte(-2)).getPrice(LzmaBase.INSTANCE.stateIsCharState(state) == false, matchByte, currentByte);
                nextOptimum = this._optimum[cur + 1];
                nextIsChar = false;
                if (curAnd1Price < nextOptimum.getPrice()) {
                    nextOptimum.setPrice(curAnd1Price);
                    nextOptimum.setPosPrev(cur);
                    nextOptimum.makeAsChar();
                    nextIsChar = true;
                }
                matchPrice = curPrice + RangeEncoder.Companion.getPrice1(this._isMatch[(state << 4) + posState]);
                repMatchPrice = matchPrice + RangeEncoder.Companion.getPrice1(this._isRep[state]);
                if (matchByte == currentByte && (nextOptimum.getPosPrev() >= cur || nextOptimum.getBackPrev() != 0) && (shortRepPrice = repMatchPrice + this.getRepLen1Price(state, posState)) <= nextOptimum.getPrice()) {
                    nextOptimum.setPrice(shortRepPrice);
                    nextOptimum.setPosPrev(cur);
                    nextOptimum.makeAsShortRep();
                    nextIsChar = true;
                }
                v11 = this._matchFinder;
                Intrinsics.checkNotNull(v11);
                numAvailableBytesFull = v11.getNumAvailableBytes() + 1;
                numAvailableBytes = numAvailableBytesFull = Math.min(4095 - cur, numAvailableBytesFull);
                if (numAvailableBytes < 2) continue;
                if (numAvailableBytes > this._numFastBytes) {
                    numAvailableBytes = this._numFastBytes;
                }
                if (!nextIsChar && matchByte != currentByte) {
                    t = Math.min(numAvailableBytesFull - 1, this._numFastBytes);
                    v12 = this._matchFinder;
                    Intrinsics.checkNotNull(v12);
                    lenTest2 = v12.getMatchLen(0, this.reps[0], t);
                    if (lenTest2 >= 2) {
                        state2 = LzmaBase.INSTANCE.stateUpdateChar(state);
                        posStateNext = ppos + 1 & this._posStateMask;
                        nextRepMatchPrice = curAnd1Price + RangeEncoder.Companion.getPrice1(this._isMatch[(state2 << 4) + posStateNext]) + RangeEncoder.Companion.getPrice1(this._isRep[state2]);
                        $this$getOptimum_u24lambda_u240 = this;
                        $i$a$-run-SevenZip$LzmaEncoder$getOptimum$1 = false;
                        offset = cur + 1 + lenTest2;
                        while (lenEnd < offset) {
                            $this$getOptimum_u24lambda_u240._optimum[++lenEnd].setPrice(0xFFFFFFF);
                        }
                        curAndLenPrice = nextRepMatchPrice + $this$getOptimum_u24lambda_u240.getRepPrice(0, lenTest2, state2, posStateNext);
                        if (curAndLenPrice < (optimum = $this$getOptimum_u24lambda_u240._optimum[offset]).getPrice()) {
                            optimum.setPrice(curAndLenPrice);
                            optimum.setPosPrev(cur + 1);
                            optimum.setBackPrev(0);
                            optimum.setPrev1IsChar(true);
                            optimum.setPrev2(false);
                        }
                    }
                }
                startLen = 2;
                for (repIndex = 0; repIndex < 4; ++repIndex) {
                    lenTest = 0;
                    v13 = this._matchFinder;
                    Intrinsics.checkNotNull(v13);
                    lenTest = v13.getMatchLen(-1, this.reps[repIndex], numAvailableBytes);
                    if (lenTest < 2) continue;
                    lenTestTemp = lenTest;
                    while (true) {
                        if (lenEnd < cur + lenTest) {
                            this._optimum[++lenEnd].setPrice(0xFFFFFFF);
                            continue;
                        }
                        curAndLenPrice = repMatchPrice + this.getRepPrice(repIndex, lenTest, state, posState);
                        if (curAndLenPrice < (optimum = this._optimum[cur + lenTest]).getPrice()) {
                            optimum.setPrice(curAndLenPrice);
                            optimum.setPosPrev(cur);
                            optimum.setBackPrev(repIndex);
                            optimum.setPrev1IsChar(false);
                        }
                        if ((lenTest += -1) < 2) break;
                    }
                    lenTest = lenTestTemp;
                    if (repIndex == 0) {
                        startLen = lenTest + 1;
                    }
                    if (lenTest >= numAvailableBytesFull) continue;
                    t = Math.min(numAvailableBytesFull - 1 - lenTest, this._numFastBytes);
                    v14 = this._matchFinder;
                    Intrinsics.checkNotNull(v14);
                    lenTest2 = v14.getMatchLen(lenTest, this.reps[repIndex], t);
                    if (lenTest2 < 2) continue;
                    state2 = 0;
                    state2 = LzmaBase.INSTANCE.stateUpdateRep(state);
                    posStateNext = 0;
                    posStateNext = ppos + lenTest & this._posStateMask;
                    v15 = repMatchPrice + this.getRepPrice(repIndex, lenTest, state, posState) + RangeEncoder.Companion.getPrice0(this._isMatch[(state2 << 4) + posStateNext]);
                    v16 = this._matchFinder;
                    Intrinsics.checkNotNull(v16);
                    v17 = this._literalEncoder.getSubCoder(ppos + lenTest, v16.getIndexByte(lenTest - 1 - 1));
                    v18 = this._matchFinder;
                    Intrinsics.checkNotNull(v18);
                    v19 = v18.getIndexByte(lenTest - 1 - (this.reps[repIndex] + 1));
                    v20 = this._matchFinder;
                    Intrinsics.checkNotNull(v20);
                    curAndLenCharPrice = v15 + v17.getPrice(true, v19, v20.getIndexByte(lenTest - 1));
                    state2 = LzmaBase.INSTANCE.stateUpdateChar(state2);
                    posStateNext = ppos + lenTest + 1 & this._posStateMask;
                    nextMatchPrice = curAndLenCharPrice + RangeEncoder.Companion.getPrice1(this._isMatch[(state2 << 4) + posStateNext]);
                    nextRepMatchPrice = nextMatchPrice + RangeEncoder.Companion.getPrice1(this._isRep[state2]);
                    $this$getOptimum_u24lambda_u241 = this;
                    $i$a$-run-SevenZip$LzmaEncoder$getOptimum$2 = false;
                    offset = lenTest + 1 + lenTest2;
                    while (lenEnd < cur + offset) {
                        $this$getOptimum_u24lambda_u241._optimum[++lenEnd].setPrice(0xFFFFFFF);
                    }
                    curAndLenPrice = nextRepMatchPrice + $this$getOptimum_u24lambda_u241.getRepPrice(0, lenTest2, state2, posStateNext);
                    if (curAndLenPrice >= (optimum = $this$getOptimum_u24lambda_u241._optimum[cur + offset]).getPrice()) continue;
                    optimum.setPrice(curAndLenPrice);
                    optimum.setPosPrev(cur + lenTest + 1);
                    optimum.setBackPrev(0);
                    optimum.setPrev1IsChar(true);
                    optimum.setPrev2(true);
                    optimum.setPosPrev2(cur);
                    optimum.setBackPrev2(repIndex);
                }
                if (newLen > numAvailableBytes) {
                    newLen = numAvailableBytes;
                    numDistancePairs = 0;
                    while (newLen > this._matchDistances[numDistancePairs]) {
                        numDistancePairs += 2;
                    }
                    this._matchDistances[numDistancePairs] = newLen;
                    numDistancePairs += 2;
                }
                if (newLen < startLen) continue;
                normalMatchPrice = matchPrice + RangeEncoder.Companion.getPrice0(this._isRep[state]);
                while (lenEnd < cur + newLen) {
                    this._optimum[++lenEnd].setPrice(0xFFFFFFF);
                }
                offs = 0;
                while (startLen > this._matchDistances[offs]) {
                    offs += 2;
                }
                lenTest = startLen;
                while (true) {
                    if ((curAndLenPrice = normalMatchPrice + this.getPosLenPrice(curBack = this._matchDistances[offs + 1], lenTest, posState)) < (optimum = this._optimum[cur + lenTest]).getPrice()) {
                        optimum.setPrice(curAndLenPrice);
                        optimum.setPosPrev(cur);
                        optimum.setBackPrev(curBack + 4);
                        optimum.setPrev1IsChar(false);
                    }
                    if (lenTest == this._matchDistances[offs]) {
                        if (lenTest < numAvailableBytesFull) {
                            t = Math.min(numAvailableBytesFull - 1 - lenTest, this._numFastBytes);
                            v21 = this._matchFinder;
                            Intrinsics.checkNotNull(v21);
                            lenTest2 = v21.getMatchLen(lenTest, curBack, t);
                            if (lenTest2 >= 2) {
                                state2 = LzmaBase.INSTANCE.stateUpdateMatch(state);
                                posStateNext = ppos + lenTest & this._posStateMask;
                                v22 = curAndLenPrice + RangeEncoder.Companion.getPrice0(this._isMatch[(state2 << 4) + posStateNext]);
                                v23 = this._matchFinder;
                                Intrinsics.checkNotNull(v23);
                                v24 = this._literalEncoder.getSubCoder(ppos + lenTest, v23.getIndexByte(lenTest - 1 - 1));
                                v25 = this._matchFinder;
                                Intrinsics.checkNotNull(v25);
                                v26 = v25.getIndexByte(lenTest - (curBack + 1) - 1);
                                v27 = this._matchFinder;
                                Intrinsics.checkNotNull(v27);
                                curAndLenCharPrice = v22 + v24.getPrice(true, v26, v27.getIndexByte(lenTest - 1));
                                state2 = LzmaBase.INSTANCE.stateUpdateChar(state2);
                                posStateNext = ppos + lenTest + 1 & this._posStateMask;
                                nextMatchPrice = curAndLenCharPrice + RangeEncoder.Companion.getPrice1(this._isMatch[(state2 << 4) + posStateNext]);
                                nextRepMatchPrice = nextMatchPrice + RangeEncoder.Companion.getPrice1(this._isRep[state2]);
                                offset = lenTest + 1 + lenTest2;
                                while (lenEnd < cur + offset) {
                                    this._optimum[++lenEnd].setPrice(0xFFFFFFF);
                                }
                                curAndLenPrice = nextRepMatchPrice + this.getRepPrice(0, lenTest2, state2, posStateNext);
                                if (curAndLenPrice < (optimum = this._optimum[cur + offset]).getPrice()) {
                                    optimum.setPrice(curAndLenPrice);
                                    optimum.setPosPrev(cur + lenTest + 1);
                                    optimum.setBackPrev(0);
                                    optimum.setPrev1IsChar(true);
                                    optimum.setPrev2(true);
                                    optimum.setPosPrev2(cur);
                                    optimum.setBackPrev2(curBack + 4);
                                }
                            }
                        }
                        if ((offs += 2) != numDistancePairs) ** break;
                        continue block11;
                    }
                    ++lenTest;
                }
                break;
            }
        }

        private final void writeEndMarker(int posState) {
            if (!this._writeEndMark) {
                return;
            }
            this._rangeEncoder.encode(this._isMatch, (this._state << 4) + posState, 1);
            this._rangeEncoder.encode(this._isRep, this._state, 0);
            this._state = LzmaBase.INSTANCE.stateUpdateMatch(this._state);
            int len = 2;
            this._lenEncoder.encode(this._rangeEncoder, len - 2, posState);
            int posSlot = 63;
            int lenToPosState = LzmaBase.INSTANCE.getLenToPosState(len);
            this._posSlotEncoder[lenToPosState].encode(this._rangeEncoder, posSlot);
            int footerBits = 30;
            int posReduced = (1 << footerBits) - 1;
            this._rangeEncoder.encodeDirectBits(posReduced >> 4, footerBits - 4);
            this._posAlignEncoder.reverseEncode(this._rangeEncoder, posReduced & 0xF);
        }

        private final void flush(int nowPos) {
            this.releaseMFStream();
            this.writeEndMarker(nowPos & this._posStateMask);
            this._rangeEncoder.flushData();
            this._rangeEncoder.flushStream();
        }

        private final void codeOneBlock(long[] inSize, long[] outSize, boolean[] finished) {
            inSize[0] = 0L;
            outSize[0] = 0L;
            finished[0] = true;
            if (this._inStream != null) {
                LzBinTree lzBinTree = this._matchFinder;
                Intrinsics.checkNotNull(lzBinTree);
                SyncInputStream syncInputStream = this._inStream;
                Intrinsics.checkNotNull(syncInputStream);
                lzBinTree.setStream(syncInputStream);
                LzBinTree lzBinTree2 = this._matchFinder;
                Intrinsics.checkNotNull(lzBinTree2);
                lzBinTree2.init();
                this._needReleaseMFStream = true;
                this._inStream = null;
            }
            if (this._finished) {
                return;
            }
            this._finished = true;
            long progressPosValuePrev = this.nowPos64;
            if (this.nowPos64 == 0L) {
                LzBinTree lzBinTree = this._matchFinder;
                Intrinsics.checkNotNull(lzBinTree);
                if (lzBinTree.getNumAvailableBytes() == 0) {
                    this.flush((int)this.nowPos64);
                    return;
                }
                this.readMatchDistances();
                int posState = (int)this.nowPos64 & this._posStateMask;
                this._rangeEncoder.encode(this._isMatch, (this._state << 4) + posState, 0);
                this._state = LzmaBase.INSTANCE.stateUpdateChar(this._state);
                LzBinTree lzBinTree3 = this._matchFinder;
                Intrinsics.checkNotNull(lzBinTree3);
                byte curByte = lzBinTree3.getIndexByte(0 - this._additionalOffset);
                this._literalEncoder.getSubCoder((int)this.nowPos64, this._previousByte).encode(this._rangeEncoder, curByte);
                this._previousByte = curByte;
                int n = this._additionalOffset;
                this._additionalOffset = n + -1;
                long l = this.nowPos64;
                this.nowPos64 = l + 1L;
            }
            LzBinTree lzBinTree = this._matchFinder;
            Intrinsics.checkNotNull(lzBinTree);
            if (lzBinTree.getNumAvailableBytes() == 0) {
                this.flush((int)this.nowPos64);
                return;
            }
            while (true) {
                int len = this.getOptimum((int)this.nowPos64);
                int pos = this.backRes;
                int posState = (int)this.nowPos64 & this._posStateMask;
                int complexState = (this._state << 4) + posState;
                if (len == 1 && pos == -1) {
                    this._rangeEncoder.encode(this._isMatch, complexState, 0);
                    LzBinTree lzBinTree4 = this._matchFinder;
                    Intrinsics.checkNotNull(lzBinTree4);
                    byte curByte = lzBinTree4.getIndexByte(0 - this._additionalOffset);
                    LiteralEncoder.Encoder2 subCoder = this._literalEncoder.getSubCoder((int)this.nowPos64, this._previousByte);
                    if (!LzmaBase.INSTANCE.stateIsCharState(this._state)) {
                        LzBinTree lzBinTree5 = this._matchFinder;
                        Intrinsics.checkNotNull(lzBinTree5);
                        byte matchByte = lzBinTree5.getIndexByte(0 - this._repDistances[0] - 1 - this._additionalOffset);
                        subCoder.encodeMatched(this._rangeEncoder, matchByte, curByte);
                    } else {
                        subCoder.encode(this._rangeEncoder, curByte);
                    }
                    this._previousByte = curByte;
                    this._state = LzmaBase.INSTANCE.stateUpdateChar(this._state);
                } else {
                    this._rangeEncoder.encode(this._isMatch, complexState, 1);
                    if (pos < 4) {
                        int n;
                        this._rangeEncoder.encode(this._isRep, this._state, 1);
                        if (pos == 0) {
                            this._rangeEncoder.encode(this._isRepG0, this._state, 0);
                            if (len == 1) {
                                this._rangeEncoder.encode(this._isRep0Long, complexState, 0);
                            } else {
                                this._rangeEncoder.encode(this._isRep0Long, complexState, 1);
                            }
                        } else {
                            this._rangeEncoder.encode(this._isRepG0, this._state, 1);
                            if (pos == 1) {
                                this._rangeEncoder.encode(this._isRepG1, this._state, 0);
                            } else {
                                this._rangeEncoder.encode(this._isRepG1, this._state, 1);
                                this._rangeEncoder.encode(this._isRepG2, this._state, pos - 2);
                            }
                        }
                        if (len == 1) {
                            n = LzmaBase.INSTANCE.stateUpdateShortRep(this._state);
                        } else {
                            this._repMatchLenEncoder.encode(this._rangeEncoder, len - 2, posState);
                            n = LzmaBase.INSTANCE.stateUpdateRep(this._state);
                        }
                        this._state = n;
                        int distance = this._repDistances[pos];
                        if (pos != 0) {
                            for (int i2 = pos; 0 < i2; --i2) {
                                this._repDistances[i2] = this._repDistances[i2 - 1];
                            }
                            this._repDistances[0] = distance;
                        }
                    } else {
                        this._rangeEncoder.encode(this._isRep, this._state, 0);
                        this._state = LzmaBase.INSTANCE.stateUpdateMatch(this._state);
                        this._lenEncoder.encode(this._rangeEncoder, len - 2, posState);
                        int posSlot = Companion.getPosSlot$korge_core(pos -= 4);
                        int lenToPosState = LzmaBase.INSTANCE.getLenToPosState(len);
                        this._posSlotEncoder[lenToPosState].encode(this._rangeEncoder, posSlot);
                        if (posSlot >= 4) {
                            int footerBits = (posSlot >> 1) - 1;
                            int baseVal = (2 | posSlot & 1) << footerBits;
                            int posReduced = pos - baseVal;
                            if (posSlot < 14) {
                                BitTreeEncoder.Companion.reverseEncode(this._posEncoders, baseVal - posSlot - 1, this._rangeEncoder, footerBits, posReduced);
                            } else {
                                this._rangeEncoder.encodeDirectBits(posReduced >> 4, footerBits - 4);
                                this._posAlignEncoder.reverseEncode(this._rangeEncoder, posReduced & 0xF);
                                int n = this._alignPriceCount;
                                this._alignPriceCount = n + 1;
                            }
                        }
                        int distance = pos;
                        for (int i3 = 3; 0 < i3; --i3) {
                            this._repDistances[i3] = this._repDistances[i3 - 1];
                        }
                        this._repDistances[0] = distance;
                        int n = this._matchPriceCount;
                        this._matchPriceCount = n + 1;
                    }
                    LzBinTree lzBinTree6 = this._matchFinder;
                    Intrinsics.checkNotNull(lzBinTree6);
                    this._previousByte = lzBinTree6.getIndexByte(len - 1 - this._additionalOffset);
                }
                this._additionalOffset -= len;
                this.nowPos64 += (long)len;
                if (this._additionalOffset != 0) continue;
                if (this._matchPriceCount >= 128) {
                    this.fillDistancesPrices();
                }
                if (this._alignPriceCount >= 16) {
                    this.fillAlignPrices();
                }
                inSize[0] = this.nowPos64;
                outSize[0] = this._rangeEncoder.getProcessedSizeAdd();
                LzBinTree lzBinTree7 = this._matchFinder;
                Intrinsics.checkNotNull(lzBinTree7);
                if (lzBinTree7.getNumAvailableBytes() == 0) {
                    this.flush((int)this.nowPos64);
                    return;
                }
                if (this.nowPos64 - progressPosValuePrev >= 4096L) break;
            }
            this._finished = false;
            finished[0] = false;
        }

        private final void releaseMFStream() {
            if (this._matchFinder != null && this._needReleaseMFStream) {
                LzBinTree lzBinTree = this._matchFinder;
                Intrinsics.checkNotNull(lzBinTree);
                lzBinTree.releaseStream();
                this._needReleaseMFStream = false;
            }
        }

        private final void setOutStream(SyncOutputStream outStream) {
            this._rangeEncoder.setStream(outStream);
        }

        private final void releaseOutStream() {
            this._rangeEncoder.releaseStream();
        }

        private final void releaseStreams() {
            this.releaseMFStream();
            this.releaseOutStream();
        }

        private final void setStreams(SyncInputStream inStream, SyncOutputStream outStream, long inSize, long outSize) {
            this._inStream = inStream;
            this._finished = false;
            this.create$korge_core();
            this.setOutStream(outStream);
            this.init$korge_core();
            LzmaEncoder $this$setStreams_u24lambda_u242 = this;
            boolean bl = false;
            $this$setStreams_u24lambda_u242.fillDistancesPrices();
            $this$setStreams_u24lambda_u242.fillAlignPrices();
            this._lenEncoder.setTableSize(this._numFastBytes + 1 - 2);
            this._lenEncoder.updateTables(1 << this._posStateBits);
            this._repMatchLenEncoder.setTableSize(this._numFastBytes + 1 - 2);
            this._repMatchLenEncoder.updateTables(1 << this._posStateBits);
            this.nowPos64 = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void code(@NotNull SyncInputStream inStream, @NotNull SyncOutputStream outStream, long inSize, long outSize, @Nullable ICodeProgress progress) {
            this._needReleaseMFStream = false;
            try {
                this.setStreams(inStream, outStream, inSize, outSize);
                while (true) {
                    this.codeOneBlock(this.processedInSize, this.processedOutSize, this.finished);
                    if (this.finished[0]) {
                        return;
                    }
                    ICodeProgress iCodeProgress = progress;
                    if (iCodeProgress == null) continue;
                    iCodeProgress.setProgress(this.processedInSize[0], this.processedOutSize[0]);
                }
            }
            finally {
                this.releaseStreams();
            }
        }

        public final void writeCoderProperties(@NotNull SyncOutputStream outStream) {
            this.properties[0] = (byte)((this._posStateBits * 5 + this._numLiteralPosStateBits) * 9 + this._numLiteralContextBits);
            for (int i2 = 0; i2 < 4; ++i2) {
                this.properties[1 + i2] = (byte)(this._dictionarySize >> 8 * i2);
            }
            outStream.write(this.properties, 0, 5);
        }

        private final void fillDistancesPrices() {
            for (int i2 = 4; i2 < 128; ++i2) {
                int posSlot = Companion.getPosSlot$korge_core(i2);
                int footerBits = (posSlot >> 1) - 1;
                int baseVal = (2 | posSlot & 1) << footerBits;
                this.tempPrices[i2] = BitTreeEncoder.Companion.reverseGetPrice(this._posEncoders, baseVal - posSlot - 1, footerBits, i2 - baseVal);
            }
            for (int lenToPosState = 0; lenToPosState < 4; ++lenToPosState) {
                int i3;
                int posSlot;
                BitTreeEncoder encoder2 = this._posSlotEncoder[lenToPosState];
                int st = lenToPosState << 6;
                for (posSlot = 0; posSlot < this._distTableSize; ++posSlot) {
                    this._posSlotPrices[st + posSlot] = encoder2.getPrice(posSlot);
                }
                for (posSlot = 14; posSlot < this._distTableSize; ++posSlot) {
                    int[] nArray = this._posSlotPrices;
                    int n = st + posSlot;
                    nArray[n] = nArray[n] + ((posSlot >> 1) - 1 - 4 << 6);
                }
                int st2 = lenToPosState * 128;
                for (i3 = 0; i3 < 4; ++i3) {
                    this._distancesPrices[st2 + i3] = this._posSlotPrices[st + i3];
                }
                while (i3 < 128) {
                    this._distancesPrices[st2 + i3] = this._posSlotPrices[st + Companion.getPosSlot$korge_core(i3)] + this.tempPrices[i3];
                    ++i3;
                }
            }
            this._matchPriceCount = 0;
        }

        private final void fillAlignPrices() {
            for (int i2 = 0; i2 < 16; ++i2) {
                this._alignPrices[i2] = this._posAlignEncoder.reverseGetPrice(i2);
            }
            this._alignPriceCount = 0;
        }

        public final boolean setAlgorithm(int algorithm) {
            return true;
        }

        public final boolean setDictionarySize(int dictionarySize) {
            boolean cond2;
            int kDicLogSizeMaxCompress = 29;
            boolean cond1 = dictionarySize < 1;
            boolean bl = cond2 = dictionarySize > 1 << kDicLogSizeMaxCompress;
            if (cond1 || cond2) {
                return false;
            }
            this._dictionarySize = dictionarySize;
            int dicLogSize = 0;
            while (dictionarySize > 1 << dicLogSize) {
                ++dicLogSize;
            }
            this._distTableSize = dicLogSize * 2;
            return true;
        }

        public final boolean setNumFastBytes(int numFastBytes) {
            if (numFastBytes < 5 || numFastBytes > 273) {
                return false;
            }
            this._numFastBytes = numFastBytes;
            return true;
        }

        public final boolean setMatchFinder(int matchFinderIndex) {
            if (matchFinderIndex < 0 || matchFinderIndex > 2) {
                return false;
            }
            int matchFinderIndexPrev = this._matchFinderType;
            this._matchFinderType = matchFinderIndex;
            if (this._matchFinder != null && matchFinderIndexPrev != this._matchFinderType) {
                this._dictionarySizePrev = -1;
                this._matchFinder = null;
            }
            return true;
        }

        public final boolean setLcLpPb(int lc, int lp, int pb) {
            if (lp < 0 || lp > 4 || lc < 0 || lc > 8 || pb < 0 || pb > 4) {
                return false;
            }
            this._numLiteralPosStateBits = lp;
            this._numLiteralContextBits = lc;
            this._posStateBits = pb;
            this._posStateMask = (1 << this._posStateBits) - 1;
            return true;
        }

        public final void setEndMarkerMode(boolean endMarkerMode) {
            this._writeEndMark = endMarkerMode;
        }

        static {
            byte[] byArray;
            Companion = new Companion(null);
            byte[] g_FastPos = byArray = new byte[2048];
            boolean bl = false;
            int kFastSlots = 22;
            int c = 2;
            g_FastPos[0] = 0;
            g_FastPos[1] = 1;
            for (int slotFast = 2; slotFast < kFastSlots; ++slotFast) {
                int k = 1 << (slotFast >> 1) - 1;
                int j = 0;
                while (j < k) {
                    g_FastPos[c] = (byte)slotFast;
                    ++j;
                    ++c;
                }
            }
            LzmaEncoder.g_FastPos = byArray;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u000fJ\u0015\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lkorlibs/io/compression/lzma/SevenZip$LzmaEncoder$Companion;", "", "()V", "EMatchFinderTypeBT2", "", "EMatchFinderTypeBT4", "g_FastPos", "", "kDefaultDictionaryLogSize", "kIfinityPrice", "kNumFastBytesDefault", "kNumOpts", "kPropSize", "getPosSlot", "pos", "getPosSlot$korge_core", "getPosSlot2", "getPosSlot2$korge_core", "korge-core"})
        public static final class Companion {
            private Companion() {
            }

            public final int getPosSlot$korge_core(int pos) {
                if (pos < 2048) {
                    return g_FastPos[pos];
                }
                return pos < 0x200000 ? g_FastPos[pos >> 10] + 20 : g_FastPos[pos >> 20] + 40;
            }

            public final int getPosSlot2$korge_core(int pos) {
                if (pos < 131072) {
                    return g_FastPos[pos >> 6] + 12;
                }
                return pos < 0x8000000 ? g_FastPos[pos >> 16] + 32 : g_FastPos[pos >> 26] + 52;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0015\n\u0002\b\u0002\b\u0090\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u000e\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0010J&\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u0019"}, d2={"Lkorlibs/io/compression/lzma/SevenZip$LzmaEncoder$LenEncoder;", "", "(Lkorlibs/io/compression/lzma/SevenZip$LzmaEncoder;)V", "_choice", "", "_highCoder", "Lkorlibs/io/compression/lzma/SevenZip$BitTreeEncoder;", "_lowCoder", "", "[Lkorlibs/io/compression/lzma/SevenZip$BitTreeEncoder;", "_midCoder", "encode", "", "rangeEncoder", "Lkorlibs/io/compression/lzma/SevenZip$RangeEncoder;", "symbol", "", "posState", "init", "numPosStates", "setPrices", "numSymbols", "prices", "", "st", "korge-core"})
        public class LenEncoder {
            @NotNull
            private short[] _choice = new short[2];
            @NotNull
            private BitTreeEncoder[] _lowCoder;
            @NotNull
            private BitTreeEncoder[] _midCoder;
            @NotNull
            private BitTreeEncoder _highCoder;

            public LenEncoder() {
                int n;
                int n2 = 0;
                BitTreeEncoder[] bitTreeEncoderArray = new BitTreeEncoder[16];
                LenEncoder lenEncoder = this;
                while (n2 < 16) {
                    n = n2++;
                    bitTreeEncoderArray[n] = new BitTreeEncoder(3);
                }
                lenEncoder._lowCoder = bitTreeEncoderArray;
                n2 = 0;
                bitTreeEncoderArray = new BitTreeEncoder[16];
                lenEncoder = this;
                while (n2 < 16) {
                    n = n2++;
                    bitTreeEncoderArray[n] = new BitTreeEncoder(3);
                }
                lenEncoder._midCoder = bitTreeEncoderArray;
                this._highCoder = new BitTreeEncoder(8);
            }

            public final void init(int numPosStates) {
                RangeEncoder.Companion.initBitModels(this._choice);
                for (int posState = 0; posState < numPosStates; ++posState) {
                    this._lowCoder[posState].init();
                    this._midCoder[posState].init();
                }
                this._highCoder.init();
            }

            public void encode(@NotNull RangeEncoder rangeEncoder, int symbol, int posState) {
                int sym = symbol;
                if (sym < 8) {
                    rangeEncoder.encode(this._choice, 0, 0);
                    this._lowCoder[posState].encode(rangeEncoder, sym);
                } else {
                    rangeEncoder.encode(this._choice, 0, 1);
                    if ((sym -= 8) < 8) {
                        rangeEncoder.encode(this._choice, 1, 0);
                        this._midCoder[posState].encode(rangeEncoder, sym);
                    } else {
                        rangeEncoder.encode(this._choice, 1, 1);
                        this._highCoder.encode(rangeEncoder, sym - 8);
                    }
                }
            }

            public final void setPrices(int posState, int numSymbols, @NotNull int[] prices, int st) {
                int i2;
                int a0 = RangeEncoder.Companion.getPrice0(this._choice[0]);
                int a1 = RangeEncoder.Companion.getPrice1(this._choice[0]);
                int b0 = a1 + RangeEncoder.Companion.getPrice0(this._choice[1]);
                int b1 = a1 + RangeEncoder.Companion.getPrice1(this._choice[1]);
                for (i2 = 0; i2 < 8; ++i2) {
                    if (i2 >= numSymbols) {
                        return;
                    }
                    prices[st + i2] = a0 + this._lowCoder[posState].getPrice(i2);
                }
                while (i2 < 16) {
                    if (i2 >= numSymbols) {
                        return;
                    }
                    prices[st + i2] = b0 + this._midCoder[posState].getPrice(i2 - 8);
                    ++i2;
                }
                while (i2 < numSymbols) {
                    prices[st + i2] = b1 + this._highCoder.getPrice(i2 - 8 - 8);
                    ++i2;
                }
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0080\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH\u0016J\u0016\u0010\u000f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bJ\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\bJ\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\bH\u0002J\u000e\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lkorlibs/io/compression/lzma/SevenZip$LzmaEncoder$LenPriceTableEncoder;", "Lkorlibs/io/compression/lzma/SevenZip$LzmaEncoder$LenEncoder;", "Lkorlibs/io/compression/lzma/SevenZip$LzmaEncoder;", "(Lkorlibs/io/compression/lzma/SevenZip$LzmaEncoder;)V", "_counters", "", "_prices", "_tableSize", "", "encode", "", "rangeEncoder", "Lkorlibs/io/compression/lzma/SevenZip$RangeEncoder;", "symbol", "posState", "getPrice", "setTableSize", "tableSize", "updateTable", "updateTables", "numPosStates", "korge-core"})
        public final class LenPriceTableEncoder
        extends LenEncoder {
            @NotNull
            private int[] _prices = new int[4352];
            private int _tableSize;
            @NotNull
            private int[] _counters = new int[16];

            public final void setTableSize(int tableSize) {
                this._tableSize = tableSize;
            }

            public final int getPrice(int symbol, int posState) {
                return this._prices[posState * 272 + symbol];
            }

            private final void updateTable(int posState) {
                this.setPrices(posState, this._tableSize, this._prices, posState * 272);
                this._counters[posState] = this._tableSize;
            }

            public final void updateTables(int numPosStates) {
                for (int posState = 0; posState < numPosStates; ++posState) {
                    this.updateTable(posState);
                }
            }

            @Override
            public void encode(@NotNull RangeEncoder rangeEncoder, int symbol, int posState) {
                super.encode(rangeEncoder, symbol, posState);
                int[] nArray = this._counters;
                nArray[posState] = nArray[posState] + -1;
                if (nArray[posState] == 0) {
                    this.updateTable(posState);
                }
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0005\n\u0002\b\u0003\b\u0080\u0004\u0018\u00002\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\tJ\u001e\u0010\u0010\u001a\n0\u0005R\u00060\u0000R\u00020\u00062\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\rR \u0010\u0003\u001a\u0012\u0012\f\u0012\n0\u0005R\u00060\u0000R\u00020\u0006\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lkorlibs/io/compression/lzma/SevenZip$LzmaEncoder$LiteralEncoder;", "", "(Lkorlibs/io/compression/lzma/SevenZip$LzmaEncoder;)V", "m_Coders", "", "Lkorlibs/io/compression/lzma/SevenZip$LzmaEncoder$LiteralEncoder$Encoder2;", "Lkorlibs/io/compression/lzma/SevenZip$LzmaEncoder;", "[Lkorlibs/io/compression/lzma/SevenZip$LzmaEncoder$LiteralEncoder$Encoder2;", "m_NumPosBits", "", "m_NumPrevBits", "m_PosMask", "create", "", "numPosBits", "numPrevBits", "getSubCoder", "pos", "prevByte", "", "init", "Encoder2", "korge-core"})
        public final class LiteralEncoder {
            @Nullable
            private Encoder2[] m_Coders;
            private int m_NumPrevBits;
            private int m_NumPosBits;
            private int m_PosMask;

            public final void create(int numPosBits, int numPrevBits) {
                if (this.m_Coders != null && this.m_NumPrevBits == numPrevBits && this.m_NumPosBits == numPosBits) {
                    return;
                }
                this.m_NumPosBits = numPosBits;
                this.m_PosMask = (1 << numPosBits) - 1;
                this.m_NumPrevBits = numPrevBits;
                int numStates = 1 << this.m_NumPrevBits + this.m_NumPosBits;
                int n = 0;
                Encoder2[] encoder2Array = new Encoder2[numStates];
                LiteralEncoder literalEncoder = this;
                while (n < numStates) {
                    int n2 = n++;
                    encoder2Array[n2] = new Encoder2();
                }
                literalEncoder.m_Coders = encoder2Array;
            }

            public final void init() {
                int numStates = 1 << this.m_NumPrevBits + this.m_NumPosBits;
                for (int i2 = 0; i2 < numStates; ++i2) {
                    Intrinsics.checkNotNull(this.m_Coders);
                    this.m_Coders[i2].init();
                }
            }

            @NotNull
            public final Encoder2 getSubCoder(int pos, byte prevByte) {
                Intrinsics.checkNotNull(this.m_Coders);
                return this.m_Coders[((pos & this.m_PosMask) << this.m_NumPrevBits) + (SevenZipKt.access$and(prevByte, 255) >>> 8 - this.m_NumPrevBits)];
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0017\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u0011\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lkorlibs/io/compression/lzma/SevenZip$LzmaEncoder$LiteralEncoder$Encoder2;", "", "(Lkorlibs/io/compression/lzma/SevenZip$LzmaEncoder$LiteralEncoder;)V", "m_Encoders", "", "encode", "", "rangeEncoder", "Lkorlibs/io/compression/lzma/SevenZip$RangeEncoder;", "symbol", "", "encodeMatched", "matchByte", "getPrice", "", "matchMode", "", "init", "korge-core"})
            public final class Encoder2 {
                @NotNull
                private short[] m_Encoders = new short[768];

                public final void init() {
                    RangeEncoder.Companion.initBitModels(this.m_Encoders);
                }

                public final void encode(@NotNull RangeEncoder rangeEncoder, byte symbol) {
                    int context2 = 1;
                    for (int i2 = 7; -1 < i2; --i2) {
                        int bit = SevenZipKt.access$shr(symbol, i2) & 1;
                        rangeEncoder.encode(this.m_Encoders, context2, bit);
                        context2 = context2 << 1 | bit;
                    }
                }

                public final void encodeMatched(@NotNull RangeEncoder rangeEncoder, byte matchByte, byte symbol) {
                    int context2 = 1;
                    boolean same = true;
                    for (int i2 = 7; -1 < i2; --i2) {
                        int bit = SevenZipKt.access$shr(symbol, i2) & 1;
                        int state2 = context2;
                        if (same) {
                            int matchBit = SevenZipKt.access$shr(matchByte, i2) & 1;
                            state2 += 1 + matchBit << 8;
                            same = matchBit == bit;
                        }
                        rangeEncoder.encode(this.m_Encoders, state2, bit);
                        context2 = context2 << 1 | bit;
                    }
                }

                public final int getPrice(boolean matchMode, byte matchByte, byte symbol) {
                    int i2;
                    int price = 0;
                    int context2 = 1;
                    if (matchMode) {
                        for (i2 = 7; i2 >= 0; --i2) {
                            int matchBit = SevenZipKt.access$shr(matchByte, i2) & 1;
                            int bit = SevenZipKt.access$shr(symbol, i2) & 1;
                            price += RangeEncoder.Companion.getPrice(this.m_Encoders[(1 + matchBit << 8) + context2], bit);
                            context2 = context2 << 1 | bit;
                            if (matchBit == bit) continue;
                            --i2;
                            break;
                        }
                    }
                    while (i2 >= 0) {
                        int bit = SevenZipKt.access$shr(symbol, i2) & 1;
                        price += RangeEncoder.Companion.getPrice(this.m_Encoders[context2], bit);
                        context2 = context2 << 1 | bit;
                        --i2;
                    }
                    return price;
                }
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u001a\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010-\u001a\u00020\u001fJ\u0006\u0010.\u001a\u00020/J\u0006\u00100\u001a\u00020/R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0006\"\u0004\b\u000e\u0010\bR\u001a\u0010\u000f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0006\"\u0004\b\u0011\u0010\bR\u001a\u0010\u0012\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0006\"\u0004\b\u0014\u0010\bR\u001a\u0010\u0015\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0006\"\u0004\b\u0017\u0010\bR\u001a\u0010\u0018\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0006\"\u0004\b\u001a\u0010\bR\u001a\u0010\u001b\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0006\"\u0004\b\u001d\u0010\bR\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010!\"\u0004\b&\u0010#R\u001a\u0010'\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0006\"\u0004\b)\u0010\bR\u001a\u0010*\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u0006\"\u0004\b,\u0010\b\u00a8\u00061"}, d2={"Lkorlibs/io/compression/lzma/SevenZip$LzmaEncoder$Optimal;", "", "(Lkorlibs/io/compression/lzma/SevenZip$LzmaEncoder;)V", "backPrev", "", "getBackPrev", "()I", "setBackPrev", "(I)V", "backPrev2", "getBackPrev2", "setBackPrev2", "backs0", "getBacks0", "setBacks0", "backs1", "getBacks1", "setBacks1", "backs2", "getBacks2", "setBacks2", "backs3", "getBacks3", "setBacks3", "posPrev", "getPosPrev", "setPosPrev", "posPrev2", "getPosPrev2", "setPosPrev2", "prev1IsChar", "", "getPrev1IsChar", "()Z", "setPrev1IsChar", "(Z)V", "prev2", "getPrev2", "setPrev2", "price", "getPrice", "setPrice", "state", "getState", "setState", "isShortRep", "makeAsChar", "", "makeAsShortRep", "korge-core"})
        public final class Optimal {
            private int state;
            private boolean prev1IsChar;
            private boolean prev2;
            private int posPrev2;
            private int backPrev2;
            private int price;
            private int posPrev;
            private int backPrev;
            private int backs0;
            private int backs1;
            private int backs2;
            private int backs3;

            public final int getState() {
                return this.state;
            }

            public final void setState(int n) {
                this.state = n;
            }

            public final boolean getPrev1IsChar() {
                return this.prev1IsChar;
            }

            public final void setPrev1IsChar(boolean bl) {
                this.prev1IsChar = bl;
            }

            public final boolean getPrev2() {
                return this.prev2;
            }

            public final void setPrev2(boolean bl) {
                this.prev2 = bl;
            }

            public final int getPosPrev2() {
                return this.posPrev2;
            }

            public final void setPosPrev2(int n) {
                this.posPrev2 = n;
            }

            public final int getBackPrev2() {
                return this.backPrev2;
            }

            public final void setBackPrev2(int n) {
                this.backPrev2 = n;
            }

            public final int getPrice() {
                return this.price;
            }

            public final void setPrice(int n) {
                this.price = n;
            }

            public final int getPosPrev() {
                return this.posPrev;
            }

            public final void setPosPrev(int n) {
                this.posPrev = n;
            }

            public final int getBackPrev() {
                return this.backPrev;
            }

            public final void setBackPrev(int n) {
                this.backPrev = n;
            }

            public final int getBacks0() {
                return this.backs0;
            }

            public final void setBacks0(int n) {
                this.backs0 = n;
            }

            public final int getBacks1() {
                return this.backs1;
            }

            public final void setBacks1(int n) {
                this.backs1 = n;
            }

            public final int getBacks2() {
                return this.backs2;
            }

            public final void setBacks2(int n) {
                this.backs2 = n;
            }

            public final int getBacks3() {
                return this.backs3;
            }

            public final void setBacks3(int n) {
                this.backs3 = n;
            }

            public final void makeAsChar() {
                this.backPrev = -1;
                this.prev1IsChar = false;
            }

            public final void makeAsShortRep() {
                this.backPrev = 0;
                this.prev1IsChar = false;
            }

            public final boolean isShortRep() {
                return this.backPrev == 0;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0017\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0004J\u000e\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004J\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u0019J\u000e\u0010\u001b\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\rR\u001a\u0010\u0003\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lkorlibs/io/compression/lzma/SevenZip$RangeDecoder;", "", "()V", "code", "", "getCode$korge_core", "()I", "setCode$korge_core", "(I)V", "range", "getRange$korge_core", "setRange$korge_core", "stream", "Lkorlibs/io/stream/SyncInputStream;", "getStream$korge_core", "()Lkorlibs/io/stream/SyncInputStream;", "setStream$korge_core", "(Lkorlibs/io/stream/SyncInputStream;)V", "decodeBit", "probs", "", "index", "decodeDirectBits", "numTotalBits", "init", "", "releaseStream", "setStream", "Companion", "korge-core"})
    public static final class RangeDecoder {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private int range;
        private int code;
        @Nullable
        private SyncInputStream stream;
        public static final int kTopMask = -16777216;
        public static final int kNumBitModelTotalBits = 11;
        public static final int kBitModelTotal = 2048;
        public static final int kNumMoveBits = 5;

        public final int getRange$korge_core() {
            return this.range;
        }

        public final void setRange$korge_core(int n) {
            this.range = n;
        }

        public final int getCode$korge_core() {
            return this.code;
        }

        public final void setCode$korge_core(int n) {
            this.code = n;
        }

        @Nullable
        public final SyncInputStream getStream$korge_core() {
            return this.stream;
        }

        public final void setStream$korge_core(@Nullable SyncInputStream syncInputStream) {
            this.stream = syncInputStream;
        }

        public final void setStream(@NotNull SyncInputStream stream) {
            this.stream = stream;
        }

        public final void releaseStream() {
            this.stream = null;
        }

        public final void init() {
            this.code = 0;
            this.range = -1;
            for (int i2 = 0; i2 < 5; ++i2) {
                SyncInputStream syncInputStream = this.stream;
                Intrinsics.checkNotNull(syncInputStream);
                this.code = this.code << 8 | syncInputStream.read();
            }
        }

        public final int decodeDirectBits(int numTotalBits) {
            int result2 = 0;
            for (int i2 = numTotalBits; 0 < i2; --i2) {
                this.range >>>= 1;
                int t = this.code - this.range >>> 31;
                this.code -= this.range & t - 1;
                result2 = result2 << 1 | 1 - t;
                if ((this.range & 0xFF000000) != 0) continue;
                SyncInputStream syncInputStream = this.stream;
                Intrinsics.checkNotNull(syncInputStream);
                this.code = this.code << 8 | syncInputStream.read();
                this.range <<= 8;
            }
            return result2;
        }

        public final int decodeBit(@NotNull short[] probs, int index2) {
            short prob = probs[index2];
            int newBound = (this.range >>> 11) * prob;
            if ((this.code ^ Integer.MIN_VALUE) < (newBound ^ Integer.MIN_VALUE)) {
                this.range = newBound;
                probs[index2] = (short)(prob + (2048 - prob >>> 5));
                if ((this.range & 0xFF000000) == 0) {
                    SyncInputStream syncInputStream = this.stream;
                    Intrinsics.checkNotNull(syncInputStream);
                    this.code = this.code << 8 | syncInputStream.read();
                    this.range <<= 8;
                }
                return 0;
            }
            this.range -= newBound;
            this.code -= newBound;
            probs[index2] = (short)(prob - (prob >>> 5));
            if ((this.range & 0xFF000000) == 0) {
                SyncInputStream syncInputStream = this.stream;
                Intrinsics.checkNotNull(syncInputStream);
                this.code = this.code << 8 | syncInputStream.read();
                this.range <<= 8;
            }
            return 1;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0017\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lkorlibs/io/compression/lzma/SevenZip$RangeDecoder$Companion;", "", "()V", "kBitModelTotal", "", "kNumBitModelTotalBits", "kNumMoveBits", "kTopMask", "initBitModels", "", "probs", "", "korge-core"})
        public static final class Companion {
            private Companion() {
            }

            public final void initBitModels(@NotNull short[] probs) {
                int n = probs.length;
                for (int i2 = 0; i2 < n; ++i2) {
                    probs[i2] = 1024;
                }
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0017\n\u0002\b\u000e\u0018\u0000 $2\u00020\u0001:\u0001$B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004J\u0016\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004J\u0006\u0010\u001d\u001a\u00020\u0015J\u0006\u0010\u001e\u001a\u00020\u0015J\u0006\u0010\u001f\u001a\u00020\u0007J\u0006\u0010 \u001a\u00020\u0015J\u0006\u0010!\u001a\u00020\u0015J\u000e\u0010\"\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010#\u001a\u00020\u0015H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006%"}, d2={"Lkorlibs/io/compression/lzma/SevenZip$RangeEncoder;", "", "()V", "_cache", "", "_cacheSize", "_position", "", "low", "range", "getRange$korge_core", "()I", "setRange$korge_core", "(I)V", "stream", "Lkorlibs/io/stream/SyncOutputStream;", "getStream$korge_core", "()Lkorlibs/io/stream/SyncOutputStream;", "setStream$korge_core", "(Lkorlibs/io/stream/SyncOutputStream;)V", "encode", "", "probs", "", "index", "symbol", "encodeDirectBits", "v", "numTotalBits", "flushData", "flushStream", "getProcessedSizeAdd", "init", "releaseStream", "setStream", "shiftLow", "Companion", "korge-core"})
    public static final class RangeEncoder {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private SyncOutputStream stream;
        private long low;
        private int range;
        private int _cacheSize;
        private int _cache;
        private long _position;
        public static final int kTopMask = -16777216;
        public static final int kNumBitModelTotalBits = 11;
        public static final int kBitModelTotal = 2048;
        public static final int kNumMoveBits = 5;
        private static final int kNumMoveReducingBits = 2;
        public static final int kNumBitPriceShiftBits = 6;
        @NotNull
        private static final int[] probPrices = new int[512];

        @Nullable
        public final SyncOutputStream getStream$korge_core() {
            return this.stream;
        }

        public final void setStream$korge_core(@Nullable SyncOutputStream syncOutputStream) {
            this.stream = syncOutputStream;
        }

        public final int getRange$korge_core() {
            return this.range;
        }

        public final void setRange$korge_core(int n) {
            this.range = n;
        }

        public final void setStream(@NotNull SyncOutputStream stream) {
            this.stream = stream;
        }

        public final void releaseStream() {
            this.stream = null;
        }

        public final void init() {
            this._position = 0L;
            this.low = 0L;
            this.range = -1;
            this._cacheSize = 1;
            this._cache = 0;
        }

        public final void flushData() {
            for (int i2 = 0; i2 < 5; ++i2) {
                this.shiftLow();
            }
        }

        public final void flushStream() {
            SyncOutputStream syncOutputStream = this.stream;
            Intrinsics.checkNotNull(syncOutputStream);
            syncOutputStream.flush();
        }

        private final void shiftLow() {
            int lowHi = (int)(this.low >>> 32);
            if (lowHi != 0 || this.low < 0xFF000000L) {
                this._position += (long)this._cacheSize;
                int temp = this._cache;
                do {
                    SyncOutputStream syncOutputStream = this.stream;
                    Intrinsics.checkNotNull(syncOutputStream);
                    SyncStreamKt.write8(syncOutputStream, temp + lowHi);
                    temp = 255;
                    this._cacheSize += -1;
                } while (this._cacheSize != 0);
                this._cache = (int)this.low >>> 24;
            }
            int n = this._cacheSize;
            this._cacheSize = n + 1;
            this.low = (this.low & 0xFFFFFFL) << 8;
        }

        public final void encodeDirectBits(int v, int numTotalBits) {
            for (int i2 = numTotalBits - 1; -1 < i2; --i2) {
                this.range >>>= 1;
                if ((v >>> i2 & 1) == 1) {
                    this.low += (long)this.range;
                }
                if ((this.range & 0xFF000000) != 0) continue;
                this.range <<= 8;
                this.shiftLow();
            }
        }

        public final long getProcessedSizeAdd() {
            return (long)this._cacheSize + this._position + (long)4;
        }

        public final void encode(@NotNull short[] probs, int index2, int symbol) {
            short prob = probs[index2];
            int newBound = (this.range >>> 11) * prob;
            if (symbol == 0) {
                this.range = newBound;
                probs[index2] = (short)(prob + (2048 - prob >>> 5));
            } else {
                this.low += (long)(newBound & 0xFFFFFFFF);
                this.range -= newBound;
                probs[index2] = (short)(prob - (prob >>> 5));
            }
            if ((this.range & 0xFF000000) == 0) {
                this.range <<= 8;
                this.shiftLow();
            }
        }

        static {
            int kNumBits = 9;
            for (int i2 = kNumBits - 1; -1 < i2; --i2) {
                int start2 = 1 << kNumBits - i2 - 1;
                int end2 = 1 << kNumBits - i2;
                for (int j = start2; j < end2; ++j) {
                    RangeEncoder.probPrices[j] = (i2 << 6) + (end2 - j << 6 >>> kNumBits - i2 - 1);
                }
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0015\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0017\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004J\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004J\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lkorlibs/io/compression/lzma/SevenZip$RangeEncoder$Companion;", "", "()V", "kBitModelTotal", "", "kNumBitModelTotalBits", "kNumBitPriceShiftBits", "kNumMoveBits", "kNumMoveReducingBits", "kTopMask", "probPrices", "", "getPrice", "Prob", "symbol", "getPrice0", "getPrice1", "initBitModels", "", "probs", "", "korge-core"})
        public static final class Companion {
            private Companion() {
            }

            public final void initBitModels(@NotNull short[] probs) {
                int n = probs.length;
                for (int i2 = 0; i2 < n; ++i2) {
                    probs[i2] = 1024;
                }
            }

            public final int getPrice(int Prob, int symbol) {
                return probPrices[((Prob - symbol ^ -symbol) & 0x7FF) >>> 2];
            }

            public final int getPrice0(int Prob) {
                return probPrices[Prob >>> 2];
            }

            public final int getPrice1(int Prob) {
                return probPrices[2048 - Prob >>> 2];
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

