/*
 * Decompiled with CFR 0.152.
 */
package korlibs.io.compression.lzo;

import korlibs.memory.ArraysKt;
import korlibs.memory.ByteArrayGetSetKt;
import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010\u0015\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\t\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J@\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00042\b\b\u0002\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J(\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u0004H\u0002J(\u0010\"\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0004H\u0002J8\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u0004H\u0002J8\u0010*\u001a\u00020\u00042\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010+\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u0004H\u0002J(\u0010,\u001a\u00020\u00042\u0006\u0010'\u001a\u00020(2\u0006\u0010-\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u00042\u0006\u0010.\u001a\u00020\u0004H\u0002J0\u0010/\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u00042\u0006\u00100\u001a\u00020\u00042\u0006\u00101\u001a\u00020\u0004H\u0002J \u00102\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u00103\u001a\u00020\u0004H\u0002J\u0018\u00104\u001a\u00020\u00042\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u0004H\u0002J\u000e\u00108\u001a\u00020\u00042\u0006\u00109\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lkorlibs/io/compression/lzo/LzoRawCompressor;", "", "()V", "COPY_LENGTH", "", "HASH_LOG", "LAST_LITERAL_SIZE", "MATCH_FIND_LIMIT", "MAX_DISTANCE", "MAX_INPUT_SIZE", "MAX_TABLE_SIZE", "MIN_LENGTH", "MIN_MATCH", "MIN_TABLE_SIZE", "ML_BITS", "RUN_BITS", "RUN_MASK", "SKIP_TRIGGER", "compress", "inputBase", "", "inputAddress", "inputLength", "outputBase", "outputAddress", "maxOutputLength", "table", "", "computeTableSize", "inputSize", "count", "start", "matchStart", "matchLimit", "emitCopy", "output", "matchOffset", "matchLength", "emitLastLiteral", "firstLiteral", "", "literalLength", "emitLiteral", "input", "encodeLiteralLength", "outBase", "length", "encodeMatchLength", "baseMatchLength", "command", "encodeOffset", "offset", "hash", "value", "", "mask", "maxCompressedLength", "sourceLength", "korge-core"})
@SourceDebugExtension(value={"SMAP\nLzoRawCompressor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LzoRawCompressor.kt\nkorlibs/io/compression/lzo/LzoRawCompressor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,339:1\n1#2:340\n*E\n"})
public final class LzoRawCompressor {
    @NotNull
    public static final LzoRawCompressor INSTANCE = new LzoRawCompressor();
    public static final int LAST_LITERAL_SIZE = 5;
    public static final int MIN_MATCH = 4;
    private static final int MAX_INPUT_SIZE = 0x7E000000;
    private static final int HASH_LOG = 12;
    private static final int MIN_TABLE_SIZE = 16;
    public static final int MAX_TABLE_SIZE = 4096;
    private static final int COPY_LENGTH = 8;
    private static final int MATCH_FIND_LIMIT = 12;
    private static final int MIN_LENGTH = 13;
    private static final int ML_BITS = 4;
    private static final int RUN_BITS = 4;
    private static final int RUN_MASK = 15;
    private static final int MAX_DISTANCE = 49151;
    private static final int SKIP_TRIGGER = 6;

    private LzoRawCompressor() {
    }

    private final int hash(long value, int mask) {
        return (int)(value * 889523592379L >>> 28 & (long)mask);
    }

    public final int maxCompressedLength(int sourceLength) {
        return sourceLength + sourceLength / 255 + 16;
    }

    public final int compress(@NotNull byte[] inputBase, int inputAddress, int inputLength, @NotNull byte[] outputBase, int outputAddress, int maxOutputLength, @NotNull int[] table) {
        int tableSize = this.computeTableSize(inputLength);
        kotlin.collections.ArraysKt.fill$default(table, 0, 0, 0, 6, null);
        int mask = tableSize - 1;
        if (!(inputLength <= 0x7E000000)) {
            boolean $i$a$-require-LzoRawCompressor$compress$32 = false;
            String $i$a$-require-LzoRawCompressor$compress$32 = "Max input length exceeded";
            throw new IllegalArgumentException($i$a$-require-LzoRawCompressor$compress$32.toString());
        }
        if (!(maxOutputLength >= this.maxCompressedLength(inputLength))) {
            boolean $i$a$-require-LzoRawCompressor$compress$42 = false;
            String $i$a$-require-LzoRawCompressor$compress$42 = "Max output length must be larger than " + INSTANCE.maxCompressedLength(inputLength);
            throw new IllegalArgumentException($i$a$-require-LzoRawCompressor$compress$42.toString());
        }
        if (inputLength == 0) {
            return 0;
        }
        int input = inputAddress;
        int output2 = outputAddress;
        int inputLimit = inputAddress + inputLength;
        int matchFindLimit = inputLimit - 12;
        int matchLimit = inputLimit - 5;
        if (inputLength < 13) {
            output2 = this.emitLastLiteral(true, outputBase, output2, inputBase, input, inputLimit - input);
            return output2 - outputAddress;
        }
        int anchor = input;
        table[this.hash((long)ByteArrayGetSetKt.getS64LE((byte[])inputBase, (int)input), (int)mask)] = input - inputAddress;
        int nextHash = this.hash(ByteArrayGetSetKt.getS64LE(inputBase, ++input), mask);
        boolean done = false;
        boolean firstLiteral = true;
        block0: do {
            int nextInputIndex = input;
            int findMatchAttempts = 64;
            int step2 = 1;
            int matchIndex = 0;
            do {
                int hash2 = nextHash;
                input = nextInputIndex;
                if ((nextInputIndex += (step2 = findMatchAttempts++ >>> 6)) > matchFindLimit) {
                    output2 = this.emitLastLiteral(firstLiteral, outputBase, output2, inputBase, anchor, inputLimit - anchor);
                    return output2 - outputAddress;
                }
                nextHash = this.hash(ByteArrayGetSetKt.getS64LE(inputBase, nextInputIndex), mask);
                table[hash2] = input - inputAddress;
            } while (ByteArrayGetSetKt.getS32LE(inputBase, matchIndex) != ByteArrayGetSetKt.getS32LE(inputBase, input) || matchIndex + 49151 < input);
            for (matchIndex = inputAddress + table[hash2]; input > anchor && matchIndex > inputAddress && ByteArrayGetSetKt.getU8(inputBase, input - 1) == ByteArrayGetSetKt.getU8(inputBase, matchIndex - 1); --input, --matchIndex) {
            }
            int literalLength = input - anchor;
            output2 = this.emitLiteral(firstLiteral, inputBase, anchor, outputBase, output2, literalLength);
            firstLiteral = false;
            do {
                int offset2 = input - matchIndex;
                int matchLength = this.count(inputBase, input += 4, matchIndex + 4, matchLimit);
                output2 = this.emitCopy(outputBase, output2, offset2, matchLength + 4);
                anchor = input += matchLength;
                if (input > matchFindLimit) {
                    done = true;
                    continue block0;
                }
                int position = input - 2;
                table[this.hash((long)ByteArrayGetSetKt.getS64LE((byte[])inputBase, (int)position), (int)mask)] = position - inputAddress;
                int hash3 = this.hash(ByteArrayGetSetKt.getS64LE(inputBase, input), mask);
                matchIndex = inputAddress + table[hash3];
                table[hash3] = input - inputAddress;
            } while (matchIndex + 49151 >= input && ByteArrayGetSetKt.getS32LE(inputBase, matchIndex) == ByteArrayGetSetKt.getS32LE(inputBase, input));
            nextHash = this.hash(ByteArrayGetSetKt.getS64LE(inputBase, ++input), mask);
        } while (!done);
        output2 = this.emitLastLiteral(false, outputBase, output2, inputBase, anchor, inputLimit - anchor);
        return output2 - outputAddress;
    }

    public static /* synthetic */ int compress$default(LzoRawCompressor lzoRawCompressor, byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, int[] nArray, int n5, Object object) {
        if ((n5 & 0x40) != 0) {
            nArray = new int[4096];
        }
        return lzoRawCompressor.compress(byArray, n, n2, byArray2, n3, n4, nArray);
    }

    private final int count(byte[] inputBase, int start2, int matchStart, int matchLimit) {
        int matchStart2 = matchStart;
        int current2 = start2;
        while (current2 < matchLimit - 7) {
            long diff = ByteArrayGetSetKt.getS64LE(inputBase, matchStart2) ^ ByteArrayGetSetKt.getS64LE(inputBase, current2);
            if (diff != 0L) {
                return (current2 += Long.numberOfTrailingZeros(diff) >> 3) - start2;
            }
            current2 += 8;
            matchStart2 += 8;
        }
        if (current2 < matchLimit - 3 && ByteArrayGetSetKt.getU32LE(inputBase, matchStart2) == ByteArrayGetSetKt.getU32LE(inputBase, current2)) {
            current2 += 4;
            matchStart2 += 4;
        }
        if (current2 < matchLimit - 1 && ByteArrayGetSetKt.getU16LE(inputBase, matchStart2) == ByteArrayGetSetKt.getU16LE(inputBase, current2)) {
            current2 += 2;
            matchStart2 += 2;
        }
        if (current2 < matchLimit && ByteArrayGetSetKt.getU8(inputBase, matchStart2) == ByteArrayGetSetKt.getU8(inputBase, current2)) {
            ++current2;
        }
        return current2 - start2;
    }

    private final int emitLastLiteral(boolean firstLiteral, byte[] outputBase, int output2, byte[] inputBase, int inputAddress, int literalLength) {
        int output3 = output2;
        output3 = this.encodeLiteralLength(firstLiteral, outputBase, output3, literalLength);
        ArraysKt.arraycopy(inputBase, inputAddress, outputBase, output3, literalLength);
        output3 += literalLength;
        ByteArrayGetSetKt.set8(outputBase, output3++, 17);
        ByteArrayGetSetKt.set16LE(outputBase, output3, 0);
        return output3 += 2;
    }

    private final int emitLiteral(boolean firstLiteral, byte[] inputBase, int input, byte[] outputBase, int output2, int literalLength) {
        int input2 = input;
        int output3 = output2;
        output3 = this.encodeLiteralLength(firstLiteral, outputBase, output3, literalLength);
        int outputLimit = output3 + literalLength;
        do {
            ByteArrayGetSetKt.set64LE(outputBase, output3, ByteArrayGetSetKt.getS64LE(inputBase, input2));
            input2 += 8;
        } while ((output3 += 8) < outputLimit);
        return outputLimit;
    }

    private final int encodeLiteralLength(boolean firstLiteral, byte[] outBase, int output2, int length2) {
        int output3 = output2;
        int length3 = length2;
        if (firstLiteral && length3 < 238) {
            ByteArrayGetSetKt.set8(outBase, output3++, length3 + 17);
        } else if (length3 < 4) {
            ByteArrayGetSetKt.set8(outBase, output3 - 2, ByteArrayGetSetKt.getU8(outBase, output3 - 2) | length3);
        } else if ((length3 -= 3) > 15) {
            int remaining;
            ByteArrayGetSetKt.set8(outBase, output3++, 0);
            for (remaining = length3 - 15; remaining > 255; remaining -= 255) {
                ByteArrayGetSetKt.set8(outBase, output3++, 0);
            }
            ByteArrayGetSetKt.set8(outBase, output3++, remaining);
        } else {
            ByteArrayGetSetKt.set8(outBase, output3++, length3);
        }
        return output3;
    }

    private final int emitCopy(byte[] outputBase, int output2, int matchOffset, int matchLength) {
        int output3 = output2;
        int matchOffset2 = 0;
        matchOffset2 = matchOffset;
        int matchLength2 = matchLength;
        if (!(matchOffset2 <= 49151 && matchOffset2 >= 1)) {
            boolean bl = false;
            String string = "Unsupported copy offset: " + matchOffset2;
            throw new IllegalArgumentException(string.toString());
        }
        if (matchLength2 <= 8 && matchOffset2 <= 2048) {
            int n = matchOffset2;
            matchOffset2 = n + -1;
            ByteArrayGetSetKt.set8(outputBase, output3++, --matchLength2 << 5 | (matchOffset2 & 7) << 2);
            ByteArrayGetSetKt.set8(outputBase, output3++, matchOffset2 >>> 3);
            return output3;
        }
        matchLength2 -= 2;
        if (matchOffset2 >= 32768) {
            output3 = this.encodeMatchLength(outputBase, output3, matchLength2, 7, 24);
        } else if (matchOffset2 > 16384) {
            output3 = this.encodeMatchLength(outputBase, output3, matchLength2, 7, 16);
        } else {
            output3 = this.encodeMatchLength(outputBase, output3, matchLength2, 31, 32);
            int n = matchOffset2;
            matchOffset2 = n + -1;
        }
        output3 = this.encodeOffset(outputBase, output3, matchOffset2);
        return output3;
    }

    private final int encodeOffset(byte[] outputBase, int outputAddress, int offset2) {
        ByteArrayGetSetKt.set16LE(outputBase, outputAddress, offset2 << 2);
        return outputAddress + 2;
    }

    private final int encodeMatchLength(byte[] outputBase, int output2, int matchLength, int baseMatchLength, int command2) {
        int output3 = output2;
        if (matchLength <= baseMatchLength) {
            ByteArrayGetSetKt.set8(outputBase, output3++, command2 | matchLength);
        } else {
            long remaining;
            ByteArrayGetSetKt.set8(outputBase, output3++, command2);
            for (remaining = (long)(matchLength - baseMatchLength); remaining > 510L; remaining -= (long)510) {
                ByteArrayGetSetKt.set16LE(outputBase, output3, 0);
                output3 += 2;
            }
            if (remaining > 255L) {
                ByteArrayGetSetKt.set8(outputBase, output3++, 0);
                remaining -= (long)255;
            }
            ByteArrayGetSetKt.set8(outputBase, output3++, remaining);
        }
        return output3;
    }

    private final int computeTableSize(int inputSize) {
        int target = Integer.highestOneBit(inputSize - 1) << 1;
        return Math.max(Math.min(target, 4096), 16);
    }
}

