/*
 * Decompiled with CFR 0.152.
 */
package korlibs.io.compression.lzo;

import korlibs.io.lang.MalformedInputException;
import korlibs.memory.ArraysKt;
import korlibs.memory.ByteArrayGetSetKt;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lkorlibs/io/compression/lzo/LzoRawDecompressor;", "", "()V", "DEC_32_TABLE", "", "DEC_64_TABLE", "decompress", "", "inputBase", "", "inputAddress", "inputLimit", "outputBase", "outputAddress", "outputLimit", "korge-core"})
public final class LzoRawDecompressor {
    @NotNull
    public static final LzoRawDecompressor INSTANCE = new LzoRawDecompressor();
    @NotNull
    private static final int[] DEC_32_TABLE;
    @NotNull
    private static final int[] DEC_64_TABLE;

    private LzoRawDecompressor() {
    }

    public final int decompress(@NotNull byte[] inputBase, int inputAddress, int inputLimit, @NotNull byte[] outputBase, int outputAddress, int outputLimit) throws MalformedInputException {
        if (inputAddress == inputLimit) {
            return 0;
        }
        int fastOutputLimit = outputLimit - 8;
        int output2 = outputAddress;
        block0: for (int input = inputAddress; input < inputLimit; input += 2) {
            boolean firstCommand = true;
            int lastLiteralLength = 0;
            while (true) {
                int literalOutputLimit;
                int trailer;
                int it;
                int n;
                int nextByte;
                if (input >= inputLimit) {
                    throw new MalformedInputException(input - inputAddress, null, 2, null);
                }
                int command2 = ByteArrayGetSetKt.getU8(inputBase, input++);
                int matchLength = 0;
                int matchOffset = 0;
                int literalLength = 0;
                if ((command2 & 0xF0) == 0) {
                    if (lastLiteralLength == 0) {
                        matchOffset = 0;
                        matchLength = 0;
                        literalLength = command2 & 0xF;
                        if (literalLength == 0) {
                            literalLength = 15;
                            nextByte = 0;
                            while (input < inputLimit) {
                                it = n = ByteArrayGetSetKt.getU8(inputBase, input++);
                                boolean bl = false;
                                nextByte = it;
                                if (n != 0) break;
                                literalLength += 255;
                            }
                            literalLength += nextByte;
                        }
                        literalLength += 3;
                    } else if (lastLiteralLength <= 3) {
                        matchLength = 2;
                        if (input >= inputLimit) {
                            throw new MalformedInputException(input - inputAddress, null, 2, null);
                        }
                        matchOffset = (command2 & 0xC) >>> 2;
                        matchOffset |= ByteArrayGetSetKt.getU8(inputBase, input++) << 2;
                        literalLength = command2 & 3;
                    } else {
                        matchLength = 3;
                        if (input >= inputLimit) {
                            throw new MalformedInputException(input - inputAddress, null, 2, null);
                        }
                        matchOffset = (command2 & 0xC) >>> 2;
                        matchOffset |= ByteArrayGetSetKt.getU8(inputBase, input++) << 2;
                        matchOffset |= 0x800;
                        literalLength = command2 & 3;
                    }
                } else if (firstCommand) {
                    matchLength = 0;
                    matchOffset = 0;
                    literalLength = command2 - 17;
                } else if ((command2 & 0xF0) == 16) {
                    matchLength = command2 & 7;
                    if (matchLength == 0) {
                        matchLength = 7;
                        nextByte = 0;
                        while (input < inputLimit) {
                            it = n = ByteArrayGetSetKt.getU8(inputBase, input++);
                            boolean bl = false;
                            nextByte = it;
                            if (n != 0) break;
                            matchLength += 255;
                        }
                        matchLength += nextByte;
                    }
                    matchLength += 2;
                    if (input + 2 > inputLimit) {
                        throw new MalformedInputException(input - inputAddress, null, 2, null);
                    }
                    trailer = ByteArrayGetSetKt.getU16LE(inputBase, input);
                    matchOffset = (command2 & 8) << 11;
                    if ((matchOffset += trailer >> 2) == 0) continue block0;
                    matchOffset += 16383;
                    literalLength = trailer & 3;
                } else if ((command2 & 0xE0) == 32) {
                    matchLength = command2 & 0x1F;
                    if (matchLength == 0) {
                        matchLength = 31;
                        nextByte = 0;
                        while (input < inputLimit) {
                            it = n = ByteArrayGetSetKt.getU8(inputBase, input++);
                            boolean bl = false;
                            nextByte = it;
                            if (n != 0) break;
                            matchLength += 255;
                        }
                        matchLength += nextByte;
                    }
                    matchLength += 2;
                    if (input + 2 > inputLimit) {
                        throw new MalformedInputException(input - inputAddress, null, 2, null);
                    }
                    trailer = ByteArrayGetSetKt.getU16LE(inputBase, input);
                    input += 2;
                    matchOffset = trailer >>> 2;
                    literalLength = trailer & 3;
                } else if ((command2 & 0xC0) != 0) {
                    matchLength = (command2 & 0xE0) >>> 5;
                    ++matchLength;
                    if (input >= inputLimit) {
                        throw new MalformedInputException(input - inputAddress, null, 2, null);
                    }
                    matchOffset = (command2 & 0x1C) >>> 2;
                    matchOffset |= ByteArrayGetSetKt.getU8(inputBase, input++) << 3;
                    literalLength = command2 & 3;
                } else {
                    throw new MalformedInputException(input - 1, "Invalid LZO command " + command2);
                }
                firstCommand = false;
                if (matchLength != 0) {
                    int matchAddress;
                    if ((matchAddress = output2 - ++matchOffset) < outputAddress || output2 + matchLength > outputLimit) {
                        throw new MalformedInputException(input - inputAddress, null, 2, null);
                    }
                    int matchOutputLimit = output2 + matchLength;
                    if (output2 > fastOutputLimit) {
                        while (output2 < matchOutputLimit) {
                            ByteArrayGetSetKt.set8(outputBase, output2++, ByteArrayGetSetKt.getU8(outputBase, matchAddress++));
                        }
                    } else {
                        if (matchOffset < 8) {
                            int increment32 = DEC_32_TABLE[matchOffset];
                            int decrement64 = DEC_64_TABLE[matchOffset];
                            ByteArrayGetSetKt.set8(outputBase, output2 + 0, ByteArrayGetSetKt.getU8(outputBase, matchAddress + 0));
                            ByteArrayGetSetKt.set8(outputBase, output2 + 1, ByteArrayGetSetKt.getU8(outputBase, matchAddress + 1));
                            ByteArrayGetSetKt.set8(outputBase, output2 + 2, ByteArrayGetSetKt.getU8(outputBase, matchAddress + 2));
                            ByteArrayGetSetKt.set8(outputBase, output2 + 3, ByteArrayGetSetKt.getU8(outputBase, matchAddress + 3));
                            ByteArrayGetSetKt.set32LE(outputBase, output2 += 4, ByteArrayGetSetKt.getU32LE(outputBase, matchAddress += increment32));
                            output2 += 4;
                            matchAddress -= decrement64;
                        } else {
                            ByteArrayGetSetKt.set64LE(outputBase, output2, ByteArrayGetSetKt.getS64LE(outputBase, matchAddress));
                            matchAddress += 8;
                            output2 += 8;
                        }
                        if (matchOutputLimit >= fastOutputLimit) {
                            if (matchOutputLimit > outputLimit) {
                                throw new MalformedInputException(input - inputAddress, null, 2, null);
                            }
                            while (output2 < fastOutputLimit) {
                                ByteArrayGetSetKt.set64LE(outputBase, output2, ByteArrayGetSetKt.getS64LE(outputBase, matchAddress));
                                matchAddress += 8;
                                output2 += 8;
                            }
                            while (output2 < matchOutputLimit) {
                                ByteArrayGetSetKt.set8(outputBase, output2++, ByteArrayGetSetKt.getU8(outputBase, matchAddress++));
                            }
                        } else {
                            while (output2 < matchOutputLimit) {
                                ByteArrayGetSetKt.set64LE(outputBase, output2, ByteArrayGetSetKt.getS64LE(outputBase, matchAddress));
                                matchAddress += 8;
                                output2 += 8;
                            }
                        }
                    }
                    output2 = matchOutputLimit;
                }
                if ((literalOutputLimit = output2 + literalLength) > fastOutputLimit || input + literalLength > inputLimit - 8) {
                    if (literalOutputLimit > outputLimit) {
                        throw new MalformedInputException(input - inputAddress, null, 2, null);
                    }
                    ArraysKt.arraycopy(inputBase, input, outputBase, output2, literalLength);
                    input += literalLength;
                    output2 += literalLength;
                } else {
                    do {
                        ByteArrayGetSetKt.set64LE(outputBase, output2, ByteArrayGetSetKt.getS64LE(inputBase, input));
                        input += 8;
                    } while ((output2 += 8) < literalOutputLimit);
                    input -= output2 - literalOutputLimit;
                    output2 = literalOutputLimit;
                }
                lastLiteralLength = literalLength;
            }
        }
        return output2 - outputAddress;
    }

    static {
        int[] nArray = new int[]{4, 1, 2, 1, 4, 4, 4, 4};
        DEC_32_TABLE = nArray;
        nArray = new int[]{0, 0, 0, -1, 0, 1, 2, 3};
        DEC_64_TABLE = nArray;
    }
}

