/*
 * Decompiled with CFR 0.152.
 */
package korlibs.io.compression.util;

import korlibs.io.compression.util.BitReader;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J\u0018\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u000fH\u0002J\b\u0010 \u001a\u00020\u001cH\u0002J\"\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u00042\b\b\u0002\u0010#\u001a\u00020\u000f2\b\b\u0002\u0010$\u001a\u00020\u000fJ\u000e\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020'J\b\u0010(\u001a\u00020\u001cH\u0002J\"\u0010)\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u00042\b\b\u0002\u0010#\u001a\u00020\u000f2\b\b\u0002\u0010$\u001a\u00020\u000fJ(\u0010*\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u000e\u0010\f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\r\u001a\u00020\u000f*\u00020\u000f8\u00c2\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0019\u0010\u0011\u001a\u00020\u000f*\u00020\u000f8\u00c2\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0015R\u0019\u0010\u0013\u001a\u00020\u000f*\u00020\u000f8\u00c2\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015\u00a8\u0006-"}, d2={"Lkorlibs/io/compression/util/HuffmanTree;", "", "()V", "CODES", "", "COFFSET", "COUNTS", "FAST_INFO", "getFAST_INFO", "()[I", "FAST_NODE", "getFAST_NODE", "OFFSETS", "left", "ncodes", "", "nodeOffset", "right", "root", "value", "getLeft", "(I)I", "getRight", "getValue", "alloc", "allocLeaf", "allocNode", "computeEncodedValues", "", "node", "encoded", "encodedBits", "computeFastLookup", "fromLengths", "codeLengths", "start", "end", "read", "reader", "Lkorlibs/io/compression/util/BitReader;", "resetAlloc", "setFromLengths", "writeVariants", "nvalue", "Companion", "korge-core"})
@SourceDebugExtension(value={"SMAP\nHuffman.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Huffman.kt\nkorlibs/io/compression/util/HuffmanTree\n+ 2 Bits.kt\nkorlibs/memory/BitsKt\n*L\n1#1,212:1\n93#1:213\n92#1:214\n91#1:215\n91#1:216\n93#1:220\n92#1:221\n91#1:222\n91#1:223\n91#1:224\n92#1:225\n93#1:226\n91#1:227\n132#2,3:217\n*S KotlinDebug\n*F\n+ 1 Huffman.kt\nkorlibs/io/compression/util/HuffmanTree\n*L\n65#1:213\n65#1:214\n66#1:215\n69#1:216\n181#1:220\n181#1:221\n182#1:222\n183#1:223\n189#1:224\n191#1:225\n192#1:226\n197#1:227\n181#1:217,3\n*E\n"})
public final class HuffmanTree {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final int[] value = new int[1024];
    @NotNull
    private final int[] left = new int[1024];
    @NotNull
    private final int[] right = new int[1024];
    private int nodeOffset;
    private int root = 1023;
    private int ncodes;
    @NotNull
    private final int[] FAST_INFO;
    @NotNull
    private final int[] FAST_NODE;
    @NotNull
    private final int[] COUNTS;
    @NotNull
    private final int[] OFFSETS;
    @NotNull
    private final int[] COFFSET;
    @NotNull
    private final int[] CODES;
    private static final int INVALID_VALUE = -1;
    private static final int INCOMPLETE_VALUE = -2;
    private static final int NIL = 1023;
    private static final int MAX_LEN = 16;
    private static final int MAX_CODES = 288;
    private static final boolean ENABLE_EXPERIMENTAL_FAST_READ = true;
    private static final boolean ENABLE_EXPERIMENTAL_FAST_READ_V2 = true;
    private static final int FAST_BITS = 10;

    public HuffmanTree() {
        int n;
        int n2 = 0;
        int[] nArray = new int[1024];
        HuffmanTree huffmanTree = this;
        while (n2 < 1024) {
            n = n2++;
            nArray[n] = -1;
        }
        huffmanTree.FAST_INFO = nArray;
        n2 = 0;
        nArray = new int[1024];
        huffmanTree = this;
        while (n2 < 1024) {
            n = n2++;
            nArray[n] = 0;
        }
        huffmanTree.FAST_NODE = nArray;
        this.COUNTS = new int[17];
        this.OFFSETS = new int[17];
        this.COFFSET = new int[17];
        this.CODES = new int[288];
    }

    @NotNull
    public final int[] getFAST_INFO() {
        return this.FAST_INFO;
    }

    @NotNull
    public final int[] getFAST_NODE() {
        return this.FAST_NODE;
    }

    public final int read(@NotNull BitReader reader) {
        boolean $i$f$getValue;
        int $this$value$iv;
        HuffmanTree this_$iv;
        reader.ensureBits(10);
        int node2 = this.root;
        if (reader.getBitsavailable() >= 10) {
            int bits = reader.peekBits(10);
            int raw = this.FAST_INFO[bits];
            short value = (short)raw;
            int len = raw >> 16;
            if (len > 0) {
                reader.skipBits(len);
                if (value == -2) {
                    node2 = this.FAST_NODE[bits];
                } else {
                    return value;
                }
            }
        }
        do {
            int n;
            if (reader.sreadBit()) {
                HuffmanTree bits = this;
                int $this$right$iv = node2;
                boolean $i$f$getRight = false;
                n = this_$iv.right[$this$right$iv];
            } else {
                this_$iv = this;
                int $this$left$iv = node2;
                boolean $i$f$getLeft = false;
                n = node2 = this_$iv.left[$this$left$iv];
            }
            if (node2 == 1023) break;
            this_$iv = this;
            $this$value$iv = node2;
            $i$f$getValue = false;
        } while (this_$iv.value[$this$value$iv] == -1);
        this_$iv = this;
        $this$value$iv = node2;
        $i$f$getValue = false;
        return this_$iv.value[$this$value$iv];
    }

    private final void resetAlloc() {
        this.nodeOffset = 0;
    }

    private final int alloc(int value, int left, int right) {
        int n = this.nodeOffset;
        this.nodeOffset = n + 1;
        int $this$alloc_u24lambda_u240 = n;
        boolean bl = false;
        this.value[$this$alloc_u24lambda_u240] = value;
        this.left[$this$alloc_u24lambda_u240] = left;
        this.right[$this$alloc_u24lambda_u240] = right;
        return n;
    }

    private final int getValue(int $this$value) {
        boolean $i$f$getValue = false;
        return this.value[$this$value];
    }

    private final int getLeft(int $this$left) {
        boolean $i$f$getLeft = false;
        return this.left[$this$left];
    }

    private final int getRight(int $this$right) {
        boolean $i$f$getRight = false;
        return this.right[$this$right];
    }

    private final int allocLeaf(int value) {
        return this.alloc(value, 1023, 1023);
    }

    private final int allocNode(int left, int right) {
        return this.alloc(-1, left, right);
    }

    @NotNull
    public final HuffmanTree fromLengths(@NotNull int[] codeLengths, int start2, int end2) {
        this.setFromLengths(codeLengths, start2, end2);
        return this;
    }

    public static /* synthetic */ HuffmanTree fromLengths$default(HuffmanTree huffmanTree, int[] nArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = nArray.length;
        }
        return huffmanTree.fromLengths(nArray, n, n2);
    }

    public final void setFromLengths(@NotNull int[] codeLengths, int start2, int end2) {
        int n;
        int oldOffset = 0;
        int oldCount = 0;
        int ncodes = end2 - start2;
        this.resetAlloc();
        ArraysKt.fill$default(this.COUNTS, 0, 0, 0, 6, null);
        for (int n2 = start2; n2 < end2; ++n2) {
            int codeLen = codeLengths[n2];
            if (!(0 <= codeLen ? codeLen < 17 : false)) {
                throw new IllegalStateException(("Invalid HuffmanTree.codeLengths " + codeLen).toString());
            }
            int[] nArray = this.COUNTS;
            int n3 = nArray[codeLen];
            nArray[codeLen] = n3 + 1;
        }
        int currentOffset = 0;
        for (n = 0; n < 16; ++n) {
            int count2 = this.COUNTS[n];
            this.OFFSETS[n] = currentOffset;
            this.COFFSET[n] = currentOffset;
            currentOffset += count2;
        }
        for (n = start2; n < end2; ++n) {
            int codeLen = codeLengths[n];
            int[] nArray = this.COFFSET;
            int n4 = nArray[codeLen];
            nArray[codeLen] = n4 + 1;
            this.CODES[n4] = n - start2;
        }
        for (int i2 = 16; 0 < i2; --i2) {
            int newOffset = this.nodeOffset;
            int OFFSET = this.OFFSETS[i2];
            int SIZE2 = this.COUNTS[i2];
            for (int j = 0; j < SIZE2; ++j) {
                this.allocLeaf(this.CODES[OFFSET + j]);
            }
            IntProgression intProgression = RangesKt.step(RangesKt.until(0, oldCount), 2);
            int j = intProgression.getFirst();
            int n5 = intProgression.getLast();
            int n6 = intProgression.getStep();
            if (n6 > 0 && j <= n5 || n6 < 0 && n5 <= j) {
                while (true) {
                    this.allocNode(oldOffset + j, oldOffset + j + 1);
                    if (j == n5) break;
                    j += n6;
                }
            }
            oldOffset = newOffset;
            if ((oldCount = SIZE2 + oldCount / 2) < 2 || oldCount % 2 == 0) continue;
            throw new IllegalStateException(("This canonical code does not represent a Huffman code tree: " + oldCount).toString());
        }
        if (oldCount != 2) {
            throw new IllegalStateException("This canonical code does not represent a Huffman code tree".toString());
        }
        this.root = this.allocNode(this.nodeOffset - 2, this.nodeOffset - 1);
        this.ncodes = ncodes;
        this.computeFastLookup();
    }

    public static /* synthetic */ void setFromLengths$default(HuffmanTree huffmanTree, int[] nArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = nArray.length;
        }
        huffmanTree.setFromLengths(nArray, n, n2);
    }

    private final void computeFastLookup() {
        ArraysKt.fill$default(this.FAST_INFO, -1, 0, 0, 6, null);
        this.computeEncodedValues(this.root, 0, 0);
    }

    private final void computeEncodedValues(int node2, int encoded, int encodedBits) {
        HuffmanTree this_$iv;
        HuffmanTree huffmanTree = this;
        int $this$value$iv = node2;
        boolean $i$f$getValue = false;
        if (this_$iv.value[$this$value$iv] == -1) {
            if (encodedBits < 10) {
                this_$iv = this;
                int $this$left$iv = node2;
                boolean $i$f$getLeft = false;
                this.computeEncodedValues(this_$iv.left[$this$left$iv], encoded, encodedBits + 1);
                this_$iv = this;
                int $this$right$iv = node2;
                boolean $i$f$getRight = false;
                this.computeEncodedValues(this_$iv.right[$this$right$iv], encoded | 1 << encodedBits, encodedBits + 1);
            } else {
                this.writeVariants(encoded, encodedBits, node2, -2);
            }
        } else {
            this_$iv = this;
            $this$value$iv = node2;
            $i$f$getValue = false;
            this.writeVariants(encoded, encodedBits, node2, this_$iv.value[$this$value$iv]);
        }
    }

    private final void writeVariants(int encoded, int encodedBits, int node2, int nvalue) {
        int encodedInfo = nvalue & 0xFFFF | encodedBits << 16;
        int rangeCount = 1 << 10 - encodedBits;
        for (int n = 0; n < rangeCount; ++n) {
            int i2 = encoded | n << encodedBits;
            this.FAST_INFO[i2] = encodedInfo;
            this.FAST_NODE[i2] = node2;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lkorlibs/io/compression/util/HuffmanTree$Companion;", "", "()V", "ENABLE_EXPERIMENTAL_FAST_READ", "", "ENABLE_EXPERIMENTAL_FAST_READ_V2", "FAST_BITS", "", "INCOMPLETE_VALUE", "INVALID_VALUE", "MAX_CODES", "MAX_LEN", "NIL", "korge-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

