/*
 * Decompiled with CFR 0.152.
 */
package korlibs.io.concurrent.atomic;

import korlibs.io.concurrent.atomic.KorAtomicBase;
import korlibs.io.concurrent.atomic.KorAtomicInt;
import korlibs.io.concurrent.atomic.KorAtomicKt;
import korlibs.io.concurrent.atomic.KorAtomicNumber;
import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u000e\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0002H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00028V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u0004\u00a8\u0006\u0016"}, d2={"Lkorlibs/io/concurrent/atomic/KorAtomicFloat;", "Lkorlibs/io/concurrent/atomic/KorAtomicNumber;", "", "initial", "(F)V", "atomic", "Lkorlibs/io/concurrent/atomic/KorAtomicInt;", "value", "getValue", "()Ljava/lang/Float;", "setValue", "addAndGet", "delta", "(F)Ljava/lang/Float;", "addAndGetMod", "modulo", "compareAndSet", "", "expect", "update", "toString", "", "korge-core"})
@SourceDebugExtension(value={"SMAP\nKorAtomic.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KorAtomic.kt\nkorlibs/io/concurrent/atomic/KorAtomicFloat\n+ 2 KorAtomic.kt\nkorlibs/io/concurrent/atomic/KorAtomicKt\n*L\n1#1,148:1\n26#2,4:149\n26#2,4:153\n*S KotlinDebug\n*F\n+ 1 KorAtomic.kt\nkorlibs/io/concurrent/atomic/KorAtomicFloat\n*L\n102#1:149,4\n103#1:153,4\n*E\n"})
public final class KorAtomicFloat
implements KorAtomicNumber<Float> {
    @NotNull
    private final KorAtomicInt atomic;

    public KorAtomicFloat(float initial) {
        this.atomic = KorAtomicKt.KorAtomicInt(Float.floatToRawIntBits(initial));
    }

    @Override
    @NotNull
    public Float getValue() {
        return Float.valueOf(Float.intBitsToFloat(this.atomic.getValue()));
    }

    @Override
    public void setValue(float value) {
        this.atomic.setValue(Float.floatToRawIntBits(value));
    }

    @Override
    public boolean compareAndSet(float expect, float update2) {
        boolean bl;
        if (this.getValue().floatValue() == expect) {
            this.setValue(update2);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public Float addAndGet(float delta) {
        float it;
        Float next$iv;
        Object value$iv;
        KorAtomicBase $this$update$iv = this;
        boolean $i$f$update = false;
        do {
            value$iv = $this$update$iv.getValue();
            it = ((Number)value$iv).floatValue();
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(value$iv, next$iv = Float.valueOf(it + delta)));
        return next$iv;
    }

    public final float addAndGetMod(float delta, float modulo) {
        float it;
        Float next$iv;
        Object value$iv;
        KorAtomicBase $this$update$iv = this;
        boolean $i$f$update = false;
        do {
            value$iv = $this$update$iv.getValue();
            it = ((Number)value$iv).floatValue();
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(value$iv, next$iv = Float.valueOf((it + delta) % modulo)));
        return ((Number)next$iv).floatValue();
    }

    @NotNull
    public String toString() {
        return String.valueOf(this.getValue().floatValue());
    }
}

