/*
 * Decompiled with CFR 0.152.
 */
package korlibs.io.file.registry;

import com.sun.jna.Pointer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import korlibs.annotations.KeepNames;
import korlibs.ffi.FFIArena;
import korlibs.ffi.FFIFuncConfig;
import korlibs.ffi.FFILib;
import korlibs.ffi.FFILibKt;
import korlibs.ffi.FFILib_jvmKt;
import korlibs.io.lang.CharsetKt;
import korlibs.io.lang.Charsets;
import korlibs.platform.Platform;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function12;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.functions.Function6;
import kotlin.jvm.functions.Function7;
import kotlin.jvm.functions.Function8;
import kotlin.jvm.functions.Function9;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.reflect.KTypeProjection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0019\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\bK\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004\u0097\u0001\u0098\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010m\u001a\u00020\u00042\u0006\u0010n\u001a\u00020\u00042\b\b\u0002\u0010o\u001a\u00020\u0004H\u0002J&\u0010p\u001a\u0004\u0018\u00010\u00012\u0006\u0010q\u001a\u00020\u00042\n\u0010r\u001a\u00060sj\u0002`t2\u0006\u0010u\u001a\u00020\u0004H\u0002J\u000e\u0010v\u001a\u00020k2\u0006\u0010w\u001a\u00020\u001fJ\u000e\u0010x\u001a\u00020y2\u0006\u0010w\u001a\u00020\u001fJ\u000e\u0010z\u001a\u00020y2\u0006\u0010w\u001a\u00020\u001fJ\u0010\u0010{\u001a\u0004\u0018\u00010\u00012\u0006\u0010w\u001a\u00020\u001fJ\u000e\u0010|\u001a\u00020k2\u0006\u0010w\u001a\u00020\u001fJ\u000e\u0010}\u001a\u00020k2\u0006\u0010w\u001a\u00020\u001fJ\u001c\u0010~\u001a\b\u0012\u0004\u0012\u00020\u001f0\u007f2\f\u0010\u0080\u0001\u001a\u00070\u0004j\u0003`\u0081\u0001H\u0002J\u0014\u0010~\u001a\b\u0012\u0004\u0012\u00020\u001f0\u007f2\u0006\u0010w\u001a\u00020\u001fJ\u0015\u0010\u0082\u0001\u001a\b\u0012\u0004\u0012\u00020\u001f0\u007f2\u0006\u0010w\u001a\u00020\u001fJ%\u0010\u0083\u0001\u001a\u0010\u0012\u0004\u0012\u00020\u001f\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001e2\f\u0010\u0080\u0001\u001a\u00070\u0004j\u0003`\u0081\u0001H\u0002J\u001d\u0010\u0083\u0001\u001a\u0010\u0012\u0004\u0012\u00020\u001f\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001e2\u0006\u0010w\u001a\u00020\u001fJ\u0011\u0010\u0084\u0001\u001a\u00020\u001f2\u0006\u0010w\u001a\u00020\u001fH\u0002Jf\u0010\u0085\u0001\u001a\u0003H\u0086\u0001\"\u0005\b\u0000\u0010\u0086\u00012\f\u0010\u0080\u0001\u001a\u00070\u0004j\u0003`\u0081\u00012\u0007\u0010\u0087\u0001\u001a\u00020\u001f2\u0007\u0010\u0088\u0001\u001a\u00020\u00042,\u0010\u0089\u0001\u001a'\u0012\u001b\u0012\u00190\u0004j\u0003`\u0081\u0001\u00a2\u0006\u000f\b\u008b\u0001\u0012\n\b\u008c\u0001\u0012\u0005\b\b(\u008d\u0001\u0012\u0005\u0012\u0003H\u0086\u00010\u008a\u0001H\u0082\b\u00a2\u0006\u0003\u0010\u008e\u0001J \u0010\u008f\u0001\u001a\u0011\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u0090\u00012\u0006\u0010w\u001a\u00020\u001fH\u0002J%\u0010\u0091\u0001\u001a\u0016\u0012\t\u0012\u00070\u0004j\u0003`\u0081\u0001\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u0090\u00012\u0006\u0010w\u001a\u00020\u001fH\u0002J&\u0010\u0092\u0001\u001a\u0017\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u0093\u00012\u0006\u0010w\u001a\u00020\u001fH\u0002J+\u0010\u0094\u0001\u001a\u001c\u0012\t\u0012\u00070\u0004j\u0003`\u0081\u0001\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u0093\u00012\u0006\u0010w\u001a\u00020\u001fH\u0002J\u001a\u0010\u0095\u0001\u001a\u00020y2\u0006\u0010w\u001a\u00020\u001f2\t\u0010\u0096\u0001\u001a\u0004\u0018\u00010\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00040\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010C\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010D\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010E\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010F\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010G\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010H\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010I\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010J\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010K\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010L\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010M\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010N\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010O\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010P\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010Q\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010R\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010S\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010T\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010U\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010V\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010W\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010X\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010Y\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010Z\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010[\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\\\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010]\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010^\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010_\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010`\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010a\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010c\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010d\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010g\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010h\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010i\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010j\u001a\u00020k8F\u00a2\u0006\u0006\u001a\u0004\bj\u0010l\u00a8\u0006\u0099\u0001"}, d2={"Lkorlibs/io/file/registry/WindowsRegistry;", "", "()V", "DELETE", "", "ERROR_ACCESS_DENIED", "ERROR_FILE_NOT_FOUND", "ERROR_INSUFFICIENT_BUFFER", "ERROR_INVALID_FUNCTION", "ERROR_INVALID_HANDLE", "ERROR_MORE_DATA", "ERROR_PATH_NOT_FOUND", "ERROR_SUCCESS", "ERROR_TOO_MANY_OPEN_FILES", "HKEY_CLASSES_ROOT", "HKEY_CURRENT_CONFIG", "HKEY_CURRENT_USER", "HKEY_CURRENT_USER_LOCAL_SETTINGS", "HKEY_DYN_DATA", "HKEY_LOCAL_MACHINE", "HKEY_PERFORMANCE_DATA", "HKEY_PERFORMANCE_NLSTEXT", "HKEY_PERFORMANCE_TEXT", "HKEY_USERS", "KEY_ALL_ACCESS", "KEY_CREATE_LINK", "KEY_CREATE_SUB_KEY", "KEY_ENUMERATE_SUB_KEYS", "KEY_EXECUTE", "KEY_MAP", "", "", "getKEY_MAP", "()Ljava/util/Map;", "KEY_NOTIFY", "KEY_QUERY_VALUE", "KEY_READ", "KEY_SET_VALUE", "KEY_WOW64_32KEY", "KEY_WOW64_64KEY", "KEY_WOW64_RES", "KEY_WRITE", "READ_CONTROL", "REG_APP_HIVE", "REG_BINARY", "REG_CREATED_NEW_KEY", "REG_DWORD", "REG_DWORD_BIG_ENDIAN", "REG_DWORD_LITTLE_ENDIAN", "REG_EXPAND_SZ", "REG_FORCE_RESTORE", "REG_FORCE_UNLOAD", "REG_FULL_RESOURCE_DESCRIPTOR", "REG_HIVE_EXACT_FILE_GROWTH", "REG_HIVE_NO_RM", "REG_HIVE_SINGLE_LOG", "REG_LATEST_FORMAT", "REG_LEGAL_CHANGE_FILTER", "REG_LEGAL_OPTION", "REG_LINK", "REG_MULTI_SZ", "REG_NONE", "REG_NOTIFY_CHANGE_ATTRIBUTES", "REG_NOTIFY_CHANGE_LAST_SET", "REG_NOTIFY_CHANGE_NAME", "REG_NOTIFY_CHANGE_SECURITY", "REG_NOTIFY_THREAD_AGNOSTIC", "REG_NO_COMPRESSION", "REG_NO_LAZY_FLUSH", "REG_OPENED_EXISTING_KEY", "REG_OPTION_BACKUP_RESTORE", "REG_OPTION_CREATE_LINK", "REG_OPTION_NON_VOLATILE", "REG_OPTION_OPEN_LINK", "REG_OPTION_RESERVED", "REG_OPTION_VOLATILE", "REG_PROCESS_APPKEY", "REG_PROCESS_PRIVATE", "REG_QWORD", "REG_QWORD_LITTLE_ENDIAN", "REG_REFRESH_HIVE", "REG_RESOURCE_LIST", "REG_RESOURCE_REQUIREMENTS_LIST", "REG_STANDARD_FORMAT", "REG_START_JOURNAL", "REG_SZ", "REG_WHOLE_HIVE_VOLATILE", "RRF_RT_ANY", "RRF_RT_DWORD", "RRF_RT_QWORD", "RRF_RT_REG_BINARY", "RRF_RT_REG_DWORD", "RRF_RT_REG_EXPAND_SZ", "RRF_RT_REG_MULTI_SZ", "RRF_RT_REG_NONE", "RRF_RT_REG_QWORD", "RRF_RT_REG_SZ", "SPECIFIC_RIGHTS_ALL", "STANDARD_RIGHTS_ALL", "STANDARD_RIGHTS_EXECUTE", "STANDARD_RIGHTS_READ", "STANDARD_RIGHTS_REQUIRED", "STANDARD_RIGHTS_WRITE", "SYNCHRONIZE", "WRITE_DAC", "WRITE_OWNER", "isSupported", "", "()Z", "checkSuccess", "rc", "extraValid", "convertValue", "type", "dataPtr", "Lcom/sun/jna/Pointer;", "Lkorlibs/ffi/FFIPointer;", "bytesSize", "createKey", "path", "deleteKey", "", "deleteValue", "getValue", "hasKey", "hasValue", "listSubKeys", "", "hKey", "Lkorlibs/io/file/registry/HKEY;", "listValueKeys", "listValues", "normalizePath", "openUseKey", "T", "keyName", "samDesired", "block", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "key", "(ILjava/lang/String;ILkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "parsePath", "Lkotlin/Pair;", "parsePathEx", "parsePathWithValue", "Lkotlin/Triple;", "parsePathWithValueEx", "setValue", "value", "Advapi32", "RegistryException", "korge-core"})
@SourceDebugExtension(value={"SMAP\nWindowsRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsRegistry.kt\nkorlibs/io/file/registry/WindowsRegistry\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 FFILib.kt\nkorlibs/ffi/FFILibKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,419:1\n404#1:431\n405#1,8:435\n404#1:449\n405#1,8:453\n404#1:467\n405#1,5:471\n411#1,2:486\n404#1:489\n405#1,8:493\n404#1:507\n405#1,8:511\n1#2:420\n1#2:484\n62#3,5:421\n62#3,5:426\n62#3,3:432\n66#3:443\n62#3,5:444\n62#3,3:450\n66#3:461\n62#3,5:462\n62#3,3:468\n62#3,3:476\n58#3:483\n66#3:485\n66#3:488\n62#3,3:490\n66#3:501\n62#3,5:502\n62#3,3:508\n66#3:519\n62#3,5:520\n1549#4:479\n1620#4,3:480\n*S KotlinDebug\n*F\n+ 1 WindowsRegistry.kt\nkorlibs/io/file/registry/WindowsRegistry\n*L\n294#1:431\n294#1:435,8\n299#1:449\n299#1:453,8\n332#1:467\n332#1:471,5\n332#1:486,2\n359#1:489\n359#1:493,8\n395#1:507\n395#1:511,8\n349#1:484\n231#1:421,5\n254#1:426,5\n294#1:432,3\n294#1:443\n297#1:444,5\n299#1:450,3\n299#1:461\n304#1:462,5\n332#1:468,3\n333#1:476,3\n349#1:483\n333#1:485\n332#1:488\n359#1:490,3\n359#1:501\n376#1:502,5\n395#1:508,3\n395#1:519\n404#1:520,5\n346#1:479\n346#1:480,3\n*E\n"})
public final class WindowsRegistry {
    @NotNull
    public static final WindowsRegistry INSTANCE = new WindowsRegistry();
    public static final int HKEY_CLASSES_ROOT = Integer.MIN_VALUE;
    public static final int HKEY_CURRENT_USER = -2147483647;
    public static final int HKEY_LOCAL_MACHINE = -2147483646;
    public static final int HKEY_USERS = -2147483645;
    public static final int HKEY_PERFORMANCE_DATA = -2147483644;
    public static final int HKEY_PERFORMANCE_TEXT = -2147483568;
    public static final int HKEY_PERFORMANCE_NLSTEXT = -2147483552;
    public static final int HKEY_CURRENT_CONFIG = -2147483643;
    public static final int HKEY_DYN_DATA = -2147483642;
    public static final int HKEY_CURRENT_USER_LOCAL_SETTINGS = -2147483641;
    @NotNull
    private static final Map<String, Integer> KEY_MAP;
    private static final int KEY_QUERY_VALUE = 1;
    private static final int KEY_SET_VALUE = 2;
    private static final int KEY_CREATE_SUB_KEY = 4;
    private static final int KEY_ENUMERATE_SUB_KEYS = 8;
    private static final int KEY_NOTIFY = 16;
    private static final int KEY_CREATE_LINK = 32;
    private static final int KEY_WOW64_32KEY = 512;
    private static final int KEY_WOW64_64KEY = 256;
    private static final int KEY_WOW64_RES = 768;
    private static final int DELETE = 65536;
    private static final int READ_CONTROL = 131072;
    private static final int WRITE_DAC = 262144;
    private static final int WRITE_OWNER = 524288;
    private static final int SYNCHRONIZE = 0x100000;
    private static final int STANDARD_RIGHTS_REQUIRED = 983040;
    private static final int STANDARD_RIGHTS_READ = 131072;
    private static final int STANDARD_RIGHTS_WRITE = 131072;
    private static final int STANDARD_RIGHTS_EXECUTE = 131072;
    private static final int STANDARD_RIGHTS_ALL = 0x1F0000;
    private static final int SPECIFIC_RIGHTS_ALL = 65535;
    private static final int KEY_READ = 131097;
    private static final int KEY_WRITE = 131078;
    private static final int KEY_EXECUTE = 131097;
    private static final int KEY_ALL_ACCESS = 983103;
    private static final int REG_OPTION_RESERVED = 0;
    private static final int REG_OPTION_NON_VOLATILE = 0;
    private static final int REG_OPTION_VOLATILE = 1;
    private static final int REG_OPTION_CREATE_LINK = 2;
    private static final int REG_OPTION_BACKUP_RESTORE = 4;
    private static final int REG_OPTION_OPEN_LINK = 8;
    private static final int REG_LEGAL_OPTION = 15;
    private static final int REG_CREATED_NEW_KEY = 1;
    private static final int REG_OPENED_EXISTING_KEY = 2;
    private static final int REG_STANDARD_FORMAT = 1;
    private static final int REG_LATEST_FORMAT = 2;
    private static final int REG_NO_COMPRESSION = 4;
    private static final int REG_WHOLE_HIVE_VOLATILE = 1;
    private static final int REG_REFRESH_HIVE = 2;
    private static final int REG_NO_LAZY_FLUSH = 4;
    private static final int REG_FORCE_RESTORE = 8;
    private static final int REG_APP_HIVE = 16;
    private static final int REG_PROCESS_PRIVATE = 32;
    private static final int REG_START_JOURNAL = 64;
    private static final int REG_HIVE_EXACT_FILE_GROWTH = 128;
    private static final int REG_HIVE_NO_RM = 256;
    private static final int REG_HIVE_SINGLE_LOG = 512;
    private static final int REG_FORCE_UNLOAD = 1;
    private static final int REG_NOTIFY_CHANGE_NAME = 1;
    private static final int REG_NOTIFY_CHANGE_ATTRIBUTES = 2;
    private static final int REG_NOTIFY_CHANGE_LAST_SET = 4;
    private static final int REG_NOTIFY_CHANGE_SECURITY = 8;
    private static final int REG_NOTIFY_THREAD_AGNOSTIC = 0x10000000;
    private static final int REG_LEGAL_CHANGE_FILTER = 0x1000000F;
    private static final int REG_NONE = 0;
    private static final int REG_SZ = 1;
    private static final int REG_EXPAND_SZ = 2;
    private static final int REG_BINARY = 3;
    private static final int REG_DWORD = 4;
    private static final int REG_DWORD_LITTLE_ENDIAN = 4;
    private static final int REG_DWORD_BIG_ENDIAN = 5;
    private static final int REG_LINK = 6;
    private static final int REG_MULTI_SZ = 7;
    private static final int REG_RESOURCE_LIST = 8;
    private static final int REG_FULL_RESOURCE_DESCRIPTOR = 9;
    private static final int REG_RESOURCE_REQUIREMENTS_LIST = 10;
    private static final int REG_QWORD = 11;
    private static final int REG_QWORD_LITTLE_ENDIAN = 11;
    private static final int ERROR_SUCCESS = 0;
    private static final int ERROR_INVALID_FUNCTION = 1;
    private static final int ERROR_FILE_NOT_FOUND = 2;
    private static final int ERROR_PATH_NOT_FOUND = 3;
    private static final int ERROR_TOO_MANY_OPEN_FILES = 4;
    private static final int ERROR_ACCESS_DENIED = 5;
    private static final int ERROR_INVALID_HANDLE = 6;
    private static final int ERROR_INSUFFICIENT_BUFFER = 122;
    private static final int ERROR_MORE_DATA = 234;
    private static final int RRF_RT_ANY = 65535;
    private static final int RRF_RT_DWORD = 24;
    private static final int RRF_RT_QWORD = 72;
    private static final int RRF_RT_REG_BINARY = 8;
    private static final int RRF_RT_REG_DWORD = 16;
    private static final int RRF_RT_REG_EXPAND_SZ = 4;
    private static final int RRF_RT_REG_MULTI_SZ = 32;
    private static final int RRF_RT_REG_NONE = 1;
    private static final int RRF_RT_REG_QWORD = 64;
    private static final int RRF_RT_REG_SZ = 2;
    private static final int REG_PROCESS_APPKEY = 1;

    private WindowsRegistry() {
    }

    @NotNull
    public final Map<String, Integer> getKEY_MAP() {
        return KEY_MAP;
    }

    private final Pair<Integer, String> parsePath(String path2) {
        String rpath = this.normalizePath(path2);
        if (((CharSequence)rpath).length() == 0) {
            return null;
        }
        String rootKeyStr = StringsKt.substringBefore$default(rpath, '\\', null, 2, null);
        String keyPath = StringsKt.substringAfter(rpath, '\\', "");
        String string = rootKeyStr.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
        Integer n = KEY_MAP.get(string);
        if (n == null) {
            throw new IllegalStateException(("Invalid rootKey '" + rootKeyStr + "', it should start with HKEY_ and be known").toString());
        }
        int rootKey = n;
        return TuplesKt.to(rootKey, keyPath);
    }

    private final Triple<Integer, String, String> parsePathWithValue(String path2) {
        Pair<Integer, String> pair = this.parsePath(path2);
        if (pair == null) {
            return null;
        }
        Pair<Integer, String> pair2 = pair;
        int root = ((Number)pair2.component1()).intValue();
        String keyPath = pair2.component2();
        String keyPathPath = StringsKt.substringBeforeLast$default(keyPath, '\\', null, 2, null);
        String valueName = StringsKt.substringAfterLast(keyPath, '\\', "");
        return new Triple<Integer, String, String>(root, keyPathPath, valueName);
    }

    private final String normalizePath(String path2) {
        char[] cArray = new char[]{'/'};
        return StringsKt.replace$default(StringsKt.trim(path2, cArray), '/', '\\', false, 4, null);
    }

    public final boolean isSupported() {
        return Platform.Companion.isWindows() && FFILib.Companion.isFFISupported();
    }

    private final Pair<Integer, String> parsePathEx(String path2) {
        Pair<Integer, String> pair;
        Pair<Integer, String> pair2 = this.parsePath(path2);
        if (pair2 != null) {
            Pair<Integer, String> it = pair2;
            boolean bl = false;
            pair = new Pair<Integer, String>(it.getFirst(), it.getSecond());
        } else {
            pair = null;
        }
        return pair;
    }

    private final Triple<Integer, String, String> parsePathWithValueEx(String path2) {
        Triple<Integer, String, String> triple;
        Triple<Integer, String, String> triple2 = this.parsePathWithValue(path2);
        if (triple2 != null) {
            Triple<Integer, String, String> it = triple2;
            boolean bl = false;
            triple = new Triple<Integer, String, String>(it.getFirst(), it.getSecond(), it.getThird());
        } else {
            triple = null;
        }
        return triple;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<String> listSubKeys(int hKey) {
        boolean $i$f$ffiScoped = false;
        FFIArena arena$iv = new FFIArena();
        try {
            FFIArena $this$listSubKeys_u24lambda_u242 = arena$iv;
            boolean bl = false;
            Pointer lpcSubKeys = $this$listSubKeys_u24lambda_u242.allocBytes(4);
            Pointer lpcMaxSubKeyLen = $this$listSubKeys_u24lambda_u242.allocBytes(4);
            WindowsRegistry.checkSuccess$default(INSTANCE, ((Number)Advapi32.INSTANCE.getRegQueryInfoKeyW().invoke(hKey, null, null, null, lpcSubKeys, lpcMaxSubKeyLen, null, null, null, null, null, null)).intValue(), 0, 2, null);
            int numSubkeys = FFILib_jvmKt.getS32$default(lpcSubKeys, 0, 1, null);
            int maxSubKey = FFILib_jvmKt.getS32$default(lpcMaxSubKeyLen, 0, 1, null);
            ArrayList<String> keys2 = new ArrayList<String>(numSubkeys);
            Pointer name2 = $this$listSubKeys_u24lambda_u242.allocBytes((maxSubKey + 1) * 2);
            Pointer lpcchValueName = $this$listSubKeys_u24lambda_u242.allocBytes(4);
            for (int i2 = 0; i2 < numSubkeys; ++i2) {
                FFILib_jvmKt.set32$default(lpcchValueName, maxSubKey + 1, 0, 2, null);
                WindowsRegistry.checkSuccess$default(INSTANCE, ((Number)Advapi32.INSTANCE.getRegEnumKeyExW().invoke(hKey, i2, name2, lpcchValueName, null, null, null, null)).intValue(), 0, 2, null);
                keys2.add(FFILib_jvmKt.getWideStringz(name2));
            }
            List list2 = keys2;
            return list2;
        }
        finally {
            arena$iv.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<String, Object> listValues(int hKey) {
        boolean $i$f$ffiScoped = false;
        FFIArena arena$iv = new FFIArena();
        try {
            FFIArena $this$listValues_u24lambda_u243 = arena$iv;
            boolean bl = false;
            Pointer lpcValues = $this$listValues_u24lambda_u243.allocBytes(4);
            Pointer lpcMaxValueNameLen = $this$listValues_u24lambda_u243.allocBytes(4);
            Pointer lpcMaxValueLen = $this$listValues_u24lambda_u243.allocBytes(4);
            WindowsRegistry.checkSuccess$default(INSTANCE, ((Number)Advapi32.INSTANCE.getRegQueryInfoKeyW().invoke(hKey, null, null, null, null, null, null, lpcValues, lpcMaxValueNameLen, lpcMaxValueLen, null, null)).intValue(), 0, 2, null);
            int nvalues = FFILib_jvmKt.getS32$default(lpcValues, 0, 1, null);
            int maxValueNameLen = FFILib_jvmKt.getS32$default(lpcMaxValueNameLen, 0, 1, null);
            int maxValueLen = FFILib_jvmKt.getS32$default(lpcMaxValueLen, 0, 1, null);
            Pointer namePtr = $this$listValues_u24lambda_u243.allocBytes((maxValueNameLen + 1) * 2);
            Pointer lpcchValueName = $this$listValues_u24lambda_u243.allocBytes(4);
            Pointer valuePtr = $this$listValues_u24lambda_u243.allocBytes((maxValueLen + 1) * 2);
            Pointer lpcbData = $this$listValues_u24lambda_u243.allocBytes(4);
            Pointer lpType = $this$listValues_u24lambda_u243.allocBytes(4);
            LinkedHashMap out = new LinkedHashMap();
            for (int n = 0; n < nvalues; ++n) {
                FFILib_jvmKt.set32$default(lpcchValueName, maxValueNameLen + 1, 0, 2, null);
                FFILib_jvmKt.set32$default(lpcbData, maxValueLen + 1, 0, 2, null);
                WindowsRegistry.checkSuccess$default(INSTANCE, ((Number)Advapi32.INSTANCE.getRegEnumValueW().invoke(hKey, n, namePtr, lpcchValueName, null, lpType, valuePtr, lpcbData)).intValue(), 0, 2, null);
                String name2 = FFILib_jvmKt.getWideStringz(namePtr);
                int valueSize = FFILib_jvmKt.getS32$default(lpcbData, 0, 1, null);
                int type2 = FFILib_jvmKt.getS32$default(lpType, 0, 1, null);
                ((Map)out).put(name2, INSTANCE.convertValue(type2, valuePtr, valueSize));
            }
            Map map2 = out;
            return map2;
        }
        finally {
            arena$iv.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<String> listSubKeys(@NotNull String path2) {
        List<String> list2;
        Pair<Integer, String> pair = this.parsePathEx(path2);
        if (pair == null) {
            return CollectionsKt.toList((Iterable)KEY_MAP.keySet());
        }
        Pair<Integer, String> pair2 = pair;
        int root = ((Number)pair2.component1()).intValue();
        String keyPath = pair2.component2();
        WindowsRegistry windowsRegistry = this;
        int samDesired$iv = 131097;
        boolean $i$f$openUseKey = false;
        boolean $i$f$ffiScoped = false;
        FFIArena arena$iv$iv = new FFIArena();
        try {
            List<String> list3;
            FFIArena $this$openUseKey_u24lambda_u2417$iv = arena$iv$iv;
            boolean bl = false;
            Pointer phkKey$iv = $this$openUseKey_u24lambda_u2417$iv.allocBytes(8);
            WindowsRegistry.checkSuccess$default(INSTANCE, ((Number)Advapi32.INSTANCE.getRegOpenKeyExW().invoke(root, keyPath, 0, samDesired$iv, phkKey$iv)).intValue(), 0, 2, null);
            int key$iv = FFILib_jvmKt.getS32$default(phkKey$iv, 0, 1, null);
            try {
                int key = key$iv;
                boolean bl2 = false;
                list3 = INSTANCE.listSubKeys(key);
            }
            finally {
                WindowsRegistry.checkSuccess$default(INSTANCE, ((Number)Advapi32.INSTANCE.getRegCloseKey().invoke(key$iv)).intValue(), 0, 2, null);
            }
            list2 = list3;
        }
        finally {
            arena$iv$iv.clear();
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Map<String, Object> listValues(@NotNull String path2) {
        boolean $i$f$ffiScoped = false;
        FFIArena arena$iv = new FFIArena();
        try {
            Map<String, Object> map2;
            Pair<Integer, String> pair;
            FFIArena $this$listValues_u24lambda_u246 = arena$iv;
            boolean bl = false;
            if (INSTANCE.parsePathEx(path2) == null) {
                Map<String, Object> map3 = MapsKt.emptyMap();
                return map3;
            }
            Pair<Integer, String> pair2 = pair;
            int root = ((Number)pair2.component1()).intValue();
            String keyPath = pair2.component2();
            WindowsRegistry windowsRegistry = INSTANCE;
            int samDesired$iv = 131097;
            boolean $i$f$openUseKey = false;
            boolean $i$f$ffiScoped2 = false;
            FFIArena arena$iv$iv = new FFIArena();
            try {
                Map<String, Object> map4;
                FFIArena $this$openUseKey_u24lambda_u2417$iv = arena$iv$iv;
                boolean bl2 = false;
                Pointer phkKey$iv = $this$openUseKey_u24lambda_u2417$iv.allocBytes(8);
                WindowsRegistry.checkSuccess$default(INSTANCE, ((Number)Advapi32.INSTANCE.getRegOpenKeyExW().invoke(root, keyPath, 0, samDesired$iv, phkKey$iv)).intValue(), 0, 2, null);
                int key$iv = FFILib_jvmKt.getS32$default(phkKey$iv, 0, 1, null);
                try {
                    int key = key$iv;
                    boolean bl3 = false;
                    map4 = INSTANCE.listValues(key);
                }
                finally {
                    WindowsRegistry.checkSuccess$default(INSTANCE, ((Number)Advapi32.INSTANCE.getRegCloseKey().invoke(key$iv)).intValue(), 0, 2, null);
                }
                map2 = map4;
            }
            finally {
                arena$iv$iv.clear();
            }
            Map<String, Object> map5 = map2;
            return map5;
        }
        finally {
            arena$iv.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Object getValue(@NotNull String path2) {
        Object object;
        Triple<Integer, String, String> triple = this.parsePathWithValueEx(path2);
        if (triple == null) {
            return null;
        }
        Triple<Integer, String, String> triple2 = triple;
        int root = ((Number)triple2.component1()).intValue();
        String keyPathPath = triple2.component2();
        String valueName = triple2.component3();
        boolean $i$f$ffiScoped = false;
        FFIArena arena$iv = new FFIArena();
        try {
            FFIArena $this$getValue_u24lambda_u247 = arena$iv;
            boolean bl = false;
            Pointer lpType = $this$getValue_u24lambda_u247.allocBytes(4);
            Pointer lpcbData = $this$getValue_u24lambda_u247.allocBytes(4);
            int v = ((Number)Advapi32.INSTANCE.getRegGetValueW().invoke(root, keyPathPath, valueName, 65535, lpType, null, lpcbData)).intValue();
            if (v == 2) {
                Object var17_13 = null;
                return var17_13;
            }
            INSTANCE.checkSuccess(v, 122);
            int bytesSize = FFILib_jvmKt.getS32$default(lpcbData, 0, 1, null);
            Pointer dataPtr = $this$getValue_u24lambda_u247.allocBytes(bytesSize);
            WindowsRegistry.checkSuccess$default(INSTANCE, ((Number)Advapi32.INSTANCE.getRegGetValueW().invoke(root, keyPathPath, valueName, 65535, lpType, dataPtr, lpcbData)).intValue(), 0, 2, null);
            int type2 = FFILib_jvmKt.getS32$default(lpType, 0, 1, null);
            object = INSTANCE.convertValue(type2, dataPtr, bytesSize);
        }
        finally {
            arena$iv.clear();
        }
        return object;
    }

    private final Object convertValue(int type2, Pointer dataPtr, int bytesSize) {
        Serializable serializable;
        switch (type2) {
            case 0: {
                serializable = null;
                break;
            }
            case 4: {
                serializable = Integer.valueOf(FFILib_jvmKt.getS32$default(dataPtr, 0, 1, null));
                break;
            }
            case 11: {
                serializable = Long.valueOf(FFILib_jvmKt.getS64$default(dataPtr, 0, 1, null));
                break;
            }
            case 3: {
                serializable = (Serializable)FFILibKt.getByteArray$default(dataPtr, bytesSize, 0, 2, null);
                break;
            }
            case 1: 
            case 2: {
                char[] cArray = new char[]{'\u0000'};
                serializable = (Serializable)((Object)StringsKt.trimEnd(CharsetKt.toString$default(FFILibKt.getByteArray$default(dataPtr, bytesSize, 0, 2, null), Charsets.INSTANCE.getUTF16_LE(), 0, 0, 6, null), cArray));
                break;
            }
            default: {
                String string = "type=" + type2 + ", bytesSize=" + bytesSize;
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
        }
        return serializable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void setValue(@NotNull String path2, @Nullable Object value) {
        Triple<Integer, String, String> triple = this.parsePathWithValueEx(path2);
        if (triple == null) {
            return;
        }
        Triple<Integer, String, String> triple2 = triple;
        int root = ((Number)triple2.component1()).intValue();
        String keyName = triple2.component2();
        String valueName = triple2.component3();
        WindowsRegistry windowsRegistry = this;
        int samDesired$iv = 131103;
        boolean $i$f$openUseKey = false;
        boolean $i$f$ffiScoped = false;
        FFIArena arena$iv$iv = new FFIArena();
        try {
            Integer n;
            FFIArena $this$openUseKey_u24lambda_u2417$iv = arena$iv$iv;
            boolean bl = false;
            Pointer phkKey$iv = $this$openUseKey_u24lambda_u2417$iv.allocBytes(8);
            WindowsRegistry.checkSuccess$default(INSTANCE, ((Number)Advapi32.INSTANCE.getRegOpenKeyExW().invoke(root, keyName, 0, samDesired$iv, phkKey$iv)).intValue(), 0, 2, null);
            int key$iv = FFILib_jvmKt.getS32$default(phkKey$iv, 0, 1, null);
            try {
                Integer n2;
                int key = key$iv;
                boolean bl2 = false;
                boolean $i$f$ffiScoped2 = false;
                FFIArena arena$iv = new FFIArena();
                try {
                    Object object;
                    FFIArena $this$setValue_u24lambda_u2413_u24lambda_u2412 = arena$iv;
                    boolean bl3 = false;
                    Object object2 = value;
                    if (object2 == null) {
                        object = Advapi32.INSTANCE.getRegSetValueExW().invoke(key, valueName, 0, 0, null, 0);
                    } else if (object2 instanceof Integer) {
                        void it;
                        Pointer pointer;
                        Pointer pointer2 = pointer = $this$setValue_u24lambda_u2413_u24lambda_u2412.allocBytes(4);
                        Integer n3 = 4;
                        Integer n4 = 0;
                        String string = valueName;
                        Integer n5 = key;
                        Function6<Integer, String, Integer, Integer, Pointer, Integer, Integer> function6 = Advapi32.INSTANCE.getRegSetValueExW();
                        boolean bl4 = false;
                        FFILib_jvmKt.set32$default((Pointer)it, ((Number)value).intValue(), 0, 2, null);
                        Unit unit = Unit.INSTANCE;
                        object = function6.invoke(n5, string, n4, n3, pointer, 4);
                    } else if (object2 instanceof Long) {
                        Pointer pointer;
                        Pointer it = pointer = $this$setValue_u24lambda_u2413_u24lambda_u2412.allocBytes(8);
                        Integer n6 = 11;
                        Integer n7 = 0;
                        String string = valueName;
                        Integer n8 = key;
                        Function6<Integer, String, Integer, Integer, Pointer, Integer, Integer> function6 = Advapi32.INSTANCE.getRegSetValueExW();
                        boolean bl5 = false;
                        FFILib_jvmKt.set64$default(it, ((Number)value).longValue(), 0, 2, null);
                        Unit unit = Unit.INSTANCE;
                        object = function6.invoke(n8, string, n7, n6, pointer, 8);
                    } else if ((object2 instanceof byte[] ? true : object2 instanceof List) ? true : object2 instanceof String) {
                        Object object3;
                        int size$iv;
                        void $this$allocBytes$iv;
                        Object object4;
                        Object object5;
                        byte[] byArray;
                        Object it = value;
                        int kind2 = it instanceof byte[] ? 3 : (it instanceof List ? 7 : 1);
                        Object bl5 = value;
                        if (bl5 instanceof byte[]) {
                            byArray = (byte[])value;
                        } else if (bl5 instanceof List) {
                            void $this$mapTo$iv$iv;
                            Iterable $this$map$iv = (Iterable)value;
                            boolean $i$f$map = false;
                            object5 = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                            boolean $i$f$mapTo = false;
                            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
                            while (iterator2.hasNext()) {
                                void it2;
                                Object item$iv$iv;
                                Object t = item$iv$iv = iterator2.next();
                                object4 = destination$iv$iv;
                                boolean bl6 = false;
                                object4.add(String.valueOf(it2));
                            }
                            byArray = CharsetKt.toByteArray$default(CollectionsKt.joinToString$default((List)destination$iv$iv, "", null, null, 0, null, new Function1<String, CharSequence>(value){
                                final /* synthetic */ Object $value;
                                {
                                    this.$value = $value;
                                    super(1);
                                }

                                @NotNull
                                public final CharSequence invoke(@NotNull String it) {
                                    return this.$value + "\u0000";
                                }
                            }, 30, null), Charsets.INSTANCE.getUTF16_LE(), 0, 0, 6, null);
                        } else {
                            byArray = CharsetKt.toByteArray$default(value + "\u0000", Charsets.INSTANCE.getUTF16_LE(), 0, 0, 6, null);
                        }
                        byte[] data2 = byArray;
                        bl5 = $this$setValue_u24lambda_u2413_u24lambda_u2412;
                        int $this$map$iv = data2.length;
                        Integer n9 = kind2;
                        Integer n10 = 0;
                        String string = valueName;
                        Integer n11 = key;
                        object4 = Advapi32.INSTANCE.getRegSetValueExW();
                        boolean $i$f$allocBytes = false;
                        Object it$iv = object5 = $this$allocBytes$iv.allocBytes(size$iv);
                        boolean bl7 = false;
                        for (int n$iv = 0; n$iv < size$iv; ++n$iv) {
                            void it3;
                            int item$iv$iv = n$iv;
                            object3 = it$iv;
                            boolean bl8 = false;
                            FFILib_jvmKt.set8((Pointer)object3, ((Number)data2[it3]).byteValue(), n$iv);
                        }
                        object3 = object5;
                        object = object4.invoke(n11, string, n10, n9, object3, data2.length);
                    } else {
                        object = Unit.INSTANCE;
                    }
                    n2 = object;
                }
                finally {
                    arena$iv.clear();
                }
                n = n2;
            }
            finally {
                WindowsRegistry.checkSuccess$default(INSTANCE, ((Number)Advapi32.INSTANCE.getRegCloseKey().invoke(key$iv)).intValue(), 0, 2, null);
            }
            Integer n12 = n;
        }
        finally {
            arena$iv$iv.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deleteValue(@NotNull String path2) {
        Triple<Integer, String, String> triple = this.parsePathWithValueEx(path2);
        if (triple == null) {
            return;
        }
        Triple<Integer, String, String> triple2 = triple;
        int root = ((Number)triple2.component1()).intValue();
        String keyName = triple2.component2();
        String valueName = triple2.component3();
        WindowsRegistry windowsRegistry = this;
        int samDesired$iv = 131103;
        boolean $i$f$openUseKey = false;
        boolean $i$f$ffiScoped = false;
        FFIArena arena$iv$iv = new FFIArena();
        try {
            int n;
            FFIArena $this$openUseKey_u24lambda_u2417$iv = arena$iv$iv;
            boolean bl = false;
            Pointer phkKey$iv = $this$openUseKey_u24lambda_u2417$iv.allocBytes(8);
            WindowsRegistry.checkSuccess$default(INSTANCE, ((Number)Advapi32.INSTANCE.getRegOpenKeyExW().invoke(root, keyName, 0, samDesired$iv, phkKey$iv)).intValue(), 0, 2, null);
            int key$iv = FFILib_jvmKt.getS32$default(phkKey$iv, 0, 1, null);
            try {
                int key = key$iv;
                boolean bl2 = false;
                n = WindowsRegistry.checkSuccess$default(INSTANCE, ((Number)Advapi32.INSTANCE.getRegDeleteValueW().invoke(key, valueName)).intValue(), 0, 2, null);
            }
            finally {
                WindowsRegistry.checkSuccess$default(INSTANCE, ((Number)Advapi32.INSTANCE.getRegCloseKey().invoke(key$iv)).intValue(), 0, 2, null);
            }
            int n2 = n;
        }
        finally {
            arena$iv$iv.clear();
        }
    }

    public final void deleteKey(@NotNull String path2) {
        Pair<Integer, String> pair = this.parsePathEx(path2);
        if (pair == null) {
            return;
        }
        Pair<Integer, String> pair2 = pair;
        int root = ((Number)pair2.component1()).intValue();
        String keyName = pair2.component2();
        WindowsRegistry.checkSuccess$default(this, ((Number)Advapi32.INSTANCE.getRegDeleteKeyW().invoke(root, keyName)).intValue(), 0, 2, null);
    }

    private final int checkSuccess(int rc, int extraValid) {
        if (rc != 0 && rc != extraValid) {
            throw new RegistryException(rc);
        }
        return rc;
    }

    static /* synthetic */ int checkSuccess$default(WindowsRegistry windowsRegistry, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        return windowsRegistry.checkSuccess(n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean createKey(@NotNull String path2) {
        boolean bl;
        Pair<Integer, String> pair = this.parsePathEx(path2);
        if (pair == null) {
            return false;
        }
        Pair<Integer, String> pair2 = pair;
        int root = ((Number)pair2.component1()).intValue();
        String keyName = pair2.component2();
        boolean $i$f$ffiScoped = false;
        FFIArena arena$iv = new FFIArena();
        try {
            FFIArena $this$createKey_u24lambda_u2415 = arena$iv;
            boolean bl2 = false;
            int samDesiredExtra = 0;
            Pointer phkResult = $this$createKey_u24lambda_u2415.allocBytes(4);
            Pointer lpdwDisposition = $this$createKey_u24lambda_u2415.allocBytes(4);
            WindowsRegistry.checkSuccess$default(INSTANCE, ((Number)Advapi32.INSTANCE.getRegCreateKeyExW().invoke(root, keyName, 0, null, 0, 0x20019 | samDesiredExtra, null, phkResult, lpdwDisposition)).intValue(), 0, 2, null);
            WindowsRegistry.checkSuccess$default(INSTANCE, ((Number)Advapi32.INSTANCE.getRegCloseKey().invoke(FFILib_jvmKt.getS32$default(phkResult, 0, 1, null))).intValue(), 0, 2, null);
            bl = 1 == FFILib_jvmKt.getS32$default(lpdwDisposition, 0, 1, null);
        }
        finally {
            arena$iv.clear();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasKey(@NotNull String path2) {
        boolean bl;
        Pair<Integer, String> pair = this.parsePathEx(path2);
        if (pair == null) {
            return false;
        }
        Pair<Integer, String> pair2 = pair;
        int root = ((Number)pair2.component1()).intValue();
        String keyName = pair2.component2();
        try {
            WindowsRegistry windowsRegistry = this;
            int samDesired$iv = 131097;
            boolean $i$f$openUseKey = false;
            boolean $i$f$ffiScoped = false;
            FFIArena arena$iv$iv = new FFIArena();
            try {
                Unit unit;
                FFIArena $this$openUseKey_u24lambda_u2417$iv = arena$iv$iv;
                boolean bl2 = false;
                Pointer phkKey$iv = $this$openUseKey_u24lambda_u2417$iv.allocBytes(8);
                WindowsRegistry.checkSuccess$default(INSTANCE, ((Number)Advapi32.INSTANCE.getRegOpenKeyExW().invoke(root, keyName, 0, samDesired$iv, phkKey$iv)).intValue(), 0, 2, null);
                int key$iv = FFILib_jvmKt.getS32$default(phkKey$iv, 0, 1, null);
                try {
                    int it = key$iv;
                    boolean bl3 = false;
                    unit = Unit.INSTANCE;
                }
                finally {
                    WindowsRegistry.checkSuccess$default(INSTANCE, ((Number)Advapi32.INSTANCE.getRegCloseKey().invoke(key$iv)).intValue(), 0, 2, null);
                }
                Unit unit2 = unit;
            }
            finally {
                arena$iv$iv.clear();
            }
            bl = true;
        }
        catch (RegistryException e) {
            if (e.getErrorCode() != 2) {
                throw e;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T openUseKey(int hKey, String keyName, int samDesired, Function1<? super Integer, ? extends T> block2) {
        T t;
        boolean $i$f$openUseKey = false;
        boolean $i$f$ffiScoped = false;
        FFIArena arena$iv = new FFIArena();
        try {
            T t2;
            FFIArena $this$openUseKey_u24lambda_u2417 = arena$iv;
            boolean bl = false;
            Pointer phkKey = $this$openUseKey_u24lambda_u2417.allocBytes(8);
            WindowsRegistry.checkSuccess$default(INSTANCE, ((Number)Advapi32.INSTANCE.getRegOpenKeyExW().invoke(hKey, keyName, 0, samDesired, phkKey)).intValue(), 0, 2, null);
            int key = FFILib_jvmKt.getS32$default(phkKey, 0, 1, null);
            try {
                t2 = block2.invoke(key);
            }
            finally {
                InlineMarker.finallyStart(1);
                WindowsRegistry.checkSuccess$default(INSTANCE, ((Number)Advapi32.INSTANCE.getRegCloseKey().invoke(key)).intValue(), 0, 2, null);
                InlineMarker.finallyEnd(1);
            }
            t = t2;
        }
        finally {
            InlineMarker.finallyStart(1);
            arena$iv.clear();
            InlineMarker.finallyEnd(1);
        }
        return t;
    }

    public final boolean hasValue(@NotNull String path2) {
        return this.getValue(path2) != null;
    }

    @NotNull
    public final List<String> listValueKeys(@NotNull String path2) {
        return CollectionsKt.toList((Iterable)this.listValues(path2).keySet());
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to("HKEY_CLASSES_ROOT", Integer.MIN_VALUE), TuplesKt.to("HKEY_CURRENT_USER", -2147483647), TuplesKt.to("HKEY_LOCAL_MACHINE", -2147483646), TuplesKt.to("HKEY_USERS", -2147483645), TuplesKt.to("HKEY_CURRENT_CONFIG", -2147483643), TuplesKt.to("HKEY_PERFORMANCE_DATA", -2147483644), TuplesKt.to("HKEY_PERFORMANCE_TEXT", -2147483568), TuplesKt.to("HKEY_PERFORMANCE_NLSTEXT", -2147483552), TuplesKt.to("HKEY_DYN_DATA", -2147483642), TuplesKt.to("HKEY_CURRENT_USER_LOCAL_SETTINGS", -2147483641)};
        KEY_MAP = MapsKt.mapOf(pairArray);
    }

    @KeepNames
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R:\u0010\u0003\u001a!\u0012\u0017\u0012\u00150\u0005j\u0002`\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\u00050\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u00fd\u0001\u0010\u000e\u001a\u00e3\u0001\u0012\u0017\u0012\u00150\u0005j\u0002`\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u0012\u0012\u0015\u0012\u0013\u0018\u00010\u0010\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u0014\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u0015\u0012\u001b\u0012\u0019\u0018\u00010\u0016j\u0004\u0018\u0001`\u0017\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u0018\u0012\u001b\u0012\u0019\u0018\u00010\u0016j\u0004\u0018\u0001`\u0017\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u0019\u0012\u001b\u0012\u0019\u0018\u00010\u0016j\u0004\u0018\u0001`\u0017\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\u00050\u000f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\r\u001a\u0004\b\u001b\u0010\u001cRQ\u0010\u001e\u001a8\u0012\u0017\u0012\u00150\u0005j\u0002`\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0015\u0012\u0013\u0018\u00010\u0010\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00050\u001f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\r\u001a\u0004\b \u0010!RQ\u0010#\u001a8\u0012\u0017\u0012\u00150\u0005j\u0002`\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0015\u0012\u0013\u0018\u00010\u0010\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b($\u0012\u0004\u0012\u00020\u00050\u001f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010\r\u001a\u0004\b%\u0010!R\u00fe\u0001\u0010'\u001a\u00e4\u0001\u0012\u0017\u0012\u00150\u0005j\u0002`\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b()\u0012\u001b\u0012\u0019\u0018\u00010\u0016j\u0004\u0018\u0001`\u0017\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(*\u0012\u001b\u0012\u0019\u0018\u00010\u0016j\u0004\u0018\u0001`\u0017\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(+\u0012\u001b\u0012\u0019\u0018\u00010\u0016j\u0004\u0018\u0001`\u0017\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(,\u0012\u001b\u0012\u0019\u0018\u00010\u0016j\u0004\u0018\u0001`\u0017\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u0013\u0012\u001b\u0012\u0019\u0018\u00010\u0016j\u0004\u0018\u0001`\u0017\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(-\u0012\u001b\u0012\u0019\u0018\u00010\u0016j\u0004\u0018\u0001`\u0017\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(.\u0012\u0004\u0012\u00020\u00050(8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b1\u0010\r\u001a\u0004\b/\u00100R\u00fe\u0001\u00102\u001a\u00e4\u0001\u0012\u0017\u0012\u00150\u0005j\u0002`\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b()\u0012\u001b\u0012\u0019\u0018\u00010\u0016j\u0004\u0018\u0001`\u0017\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b($\u0012\u001b\u0012\u0019\u0018\u00010\u0016j\u0004\u0018\u0001`\u0017\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(3\u0012\u001b\u0012\u0019\u0018\u00010\u0016j\u0004\u0018\u0001`\u0017\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(,\u0012\u001b\u0012\u0019\u0018\u00010\u0016j\u0004\u0018\u0001`\u0017\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(4\u0012\u001b\u0012\u0019\u0018\u00010\u0016j\u0004\u0018\u0001`\u0017\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(5\u0012\u001b\u0012\u0019\u0018\u00010\u0016j\u0004\u0018\u0001`\u0017\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(6\u0012\u0004\u0012\u00020\u00050(8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b8\u0010\r\u001a\u0004\b7\u00100R\u00d1\u0001\u00109\u001a\u00b7\u0001\u0012\u0017\u0012\u00150\u0005j\u0002`\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(;\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(<\u0012\u001b\u0012\u0019\u0018\u00010\u0016j\u0004\u0018\u0001`\u0017\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(=\u0012\u001b\u0012\u0019\u0018\u00010\u0016j\u0004\u0018\u0001`\u0017\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(>\u0012\u001b\u0012\u0019\u0018\u00010\u0016j\u0004\u0018\u0001`\u0017\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(?\u0012\u0004\u0012\u00020\u00050:8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bB\u0010\r\u001a\u0004\b@\u0010AR\u0096\u0001\u0010C\u001a}\u0012\u0017\u0012\u00150\u0005j\u0002`\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(E\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u0015\u0012\u001b\u0012\u0019\u0018\u00010\u0016j\u0004\u0018\u0001`\u0017\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u0019\u0012\u0004\u0012\u00020\u00050D8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bH\u0010\r\u001a\u0004\bF\u0010GR\u00f4\u0002\u0010I\u001a\u00da\u0002\u0012\u0017\u0012\u00150\u0005j\u0002`\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0015\u0012\u0013\u0018\u00010\u0010\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u0013\u0012\u001b\u0012\u0019\u0018\u00010\u0016j\u0004\u0018\u0001`\u0017\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(-\u0012\u001b\u0012\u0019\u0018\u00010\u0016j\u0004\u0018\u0001`\u0017\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(,\u0012\u001b\u0012\u0019\u0018\u00010\u0016j\u0004\u0018\u0001`\u0017\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(K\u0012\u001b\u0012\u0019\u0018\u00010\u0016j\u0004\u0018\u0001`\u0017\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(L\u0012\u001b\u0012\u0019\u0018\u00010\u0016j\u0004\u0018\u0001`\u0017\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(M\u0012\u001b\u0012\u0019\u0018\u00010\u0016j\u0004\u0018\u0001`\u0017\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(N\u0012\u001b\u0012\u0019\u0018\u00010\u0016j\u0004\u0018\u0001`\u0017\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(O\u0012\u001b\u0012\u0019\u0018\u00010\u0016j\u0004\u0018\u0001`\u0017\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(P\u0012\u001b\u0012\u0019\u0018\u00010\u0016j\u0004\u0018\u0001`\u0017\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(Q\u0012\u001b\u0012\u0019\u0018\u00010\u0016j\u0004\u0018\u0001`\u0017\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(.\u0012\u0004\u0012\u00020\u00050J8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bT\u0010\r\u001a\u0004\bR\u0010SR\u00ac\u0001\u0010U\u001a\u0092\u0001\u0012\u0017\u0012\u00150\u0005j\u0002`\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b($\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(W\u0012\u001b\u0012\u0019\u0018\u00010\u0016j\u0004\u0018\u0001`\u0017\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(5\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(X\u0012\u0004\u0012\u00020\u00050V8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b[\u0010\r\u001a\u0004\bY\u0010Z\u00a8\u0006\\"}, d2={"Lkorlibs/io/file/registry/WindowsRegistry$Advapi32;", "Lkorlibs/ffi/FFILib;", "()V", "RegCloseKey", "Lkotlin/Function1;", "", "Lkorlibs/io/file/registry/HKEY;", "Lkotlin/ParameterName;", "name", "hKey", "getRegCloseKey", "()Lkotlin/jvm/functions/Function1;", "RegCloseKey$delegate", "Lkotlin/properties/ReadOnlyProperty;", "RegCreateKeyExW", "Lkotlin/Function9;", "", "lpSubKey", "reserved", "lpClass", "dwOptions", "samDesired", "Lcom/sun/jna/Pointer;", "Lkorlibs/ffi/FFIPointer;", "lpSecurityAttributes", "phkResult", "lpdwDisposition", "getRegCreateKeyExW", "()Lkotlin/jvm/functions/Function9;", "RegCreateKeyExW$delegate", "RegDeleteKeyW", "Lkotlin/Function2;", "getRegDeleteKeyW", "()Lkotlin/jvm/functions/Function2;", "RegDeleteKeyW$delegate", "RegDeleteValueW", "lpValueName", "getRegDeleteValueW", "RegDeleteValueW$delegate", "RegEnumKeyExW", "Lkotlin/Function8;", "dwIndex", "lpName", "lpcchName", "lpReserved", "lpcchClass", "lpftLastWriteTime", "getRegEnumKeyExW", "()Lkotlin/jvm/functions/Function8;", "RegEnumKeyExW$delegate", "RegEnumValueW", "lpcchValueName", "lpType", "lpData", "lpcbData", "getRegEnumValueW", "RegEnumValueW$delegate", "RegGetValueW", "Lkotlin/Function7;", "lpValue", "dwFlags", "pdwType", "pvData", "pcbData", "getRegGetValueW", "()Lkotlin/jvm/functions/Function7;", "RegGetValueW$delegate", "RegOpenKeyExW", "Lkotlin/Function5;", "ulOptions", "getRegOpenKeyExW", "()Lkotlin/jvm/functions/Function5;", "RegOpenKeyExW$delegate", "RegQueryInfoKeyW", "Lkotlin/Function12;", "lpcSubKeys", "lpcbMaxSubKeyLen", "lpcbMaxClassLen", "lpcValues", "lpcbMaxValueNameLen", "lpcbMaxValueLen", "lpcbSecurityDescriptor", "getRegQueryInfoKeyW", "()Lkotlin/jvm/functions/Function12;", "RegQueryInfoKeyW$delegate", "RegSetValueExW", "Lkotlin/Function6;", "dwType", "cbData", "getRegSetValueExW", "()Lkotlin/jvm/functions/Function6;", "RegSetValueExW$delegate", "korge-core"})
    @SourceDebugExtension(value={"SMAP\nWindowsRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsRegistry.kt\nkorlibs/io/file/registry/WindowsRegistry$Advapi32\n+ 2 FFILib.kt\nkorlibs/ffi/FFILib\n*L\n1#1,419:1\n234#2:420\n234#2:421\n234#2:422\n234#2:423\n234#2:424\n234#2:425\n234#2:426\n234#2:427\n234#2:428\n234#2:429\n*S KotlinDebug\n*F\n+ 1 WindowsRegistry.kt\nkorlibs/io/file/registry/WindowsRegistry$Advapi32\n*L\n13#1:420\n14#1:421\n15#1:422\n16#1:423\n23#1:424\n34#1:425\n43#1:426\n53#1:427\n67#1:428\n77#1:429\n*E\n"})
    public static final class Advapi32
    extends FFILib {
        @NotNull
        public static final Advapi32 INSTANCE;
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private static final ReadOnlyProperty RegCloseKey$delegate;
        @NotNull
        private static final ReadOnlyProperty RegDeleteKeyW$delegate;
        @NotNull
        private static final ReadOnlyProperty RegDeleteValueW$delegate;
        @NotNull
        private static final ReadOnlyProperty RegSetValueExW$delegate;
        @NotNull
        private static final ReadOnlyProperty RegOpenKeyExW$delegate;
        @NotNull
        private static final ReadOnlyProperty RegCreateKeyExW$delegate;
        @NotNull
        private static final ReadOnlyProperty RegGetValueW$delegate;
        @NotNull
        private static final ReadOnlyProperty RegEnumValueW$delegate;
        @NotNull
        private static final ReadOnlyProperty RegQueryInfoKeyW$delegate;
        @NotNull
        private static final ReadOnlyProperty RegEnumKeyExW$delegate;

        private Advapi32() {
            String[] stringArray = new String[]{"Advapi32"};
            super(stringArray, false, 2, null);
        }

        @NotNull
        public final Function1<Integer, Integer> getRegCloseKey() {
            return (Function1)RegCloseKey$delegate.getValue(this, $$delegatedProperties[0]);
        }

        @NotNull
        public final Function2<Integer, String, Integer> getRegDeleteKeyW() {
            return (Function2)RegDeleteKeyW$delegate.getValue(this, $$delegatedProperties[1]);
        }

        @NotNull
        public final Function2<Integer, String, Integer> getRegDeleteValueW() {
            return (Function2)RegDeleteValueW$delegate.getValue(this, $$delegatedProperties[2]);
        }

        @NotNull
        public final Function6<Integer, String, Integer, Integer, Pointer, Integer, Integer> getRegSetValueExW() {
            return (Function6)RegSetValueExW$delegate.getValue(this, $$delegatedProperties[3]);
        }

        @NotNull
        public final Function5<Integer, String, Integer, Integer, Pointer, Integer> getRegOpenKeyExW() {
            return (Function5)RegOpenKeyExW$delegate.getValue(this, $$delegatedProperties[4]);
        }

        @NotNull
        public final Function9<Integer, String, Integer, String, Integer, Integer, Pointer, Pointer, Pointer, Integer> getRegCreateKeyExW() {
            return (Function9)RegCreateKeyExW$delegate.getValue(this, $$delegatedProperties[5]);
        }

        @NotNull
        public final Function7<Integer, String, String, Integer, Pointer, Pointer, Pointer, Integer> getRegGetValueW() {
            return (Function7)RegGetValueW$delegate.getValue(this, $$delegatedProperties[6]);
        }

        @NotNull
        public final Function8<Integer, Integer, Pointer, Pointer, Pointer, Pointer, Pointer, Pointer, Integer> getRegEnumValueW() {
            return (Function8)RegEnumValueW$delegate.getValue(this, $$delegatedProperties[7]);
        }

        @NotNull
        public final Function12<Integer, String, Pointer, Pointer, Pointer, Pointer, Pointer, Pointer, Pointer, Pointer, Pointer, Pointer, Integer> getRegQueryInfoKeyW() {
            return (Function12)RegQueryInfoKeyW$delegate.getValue(this, $$delegatedProperties[8]);
        }

        @NotNull
        public final Function8<Integer, Integer, Pointer, Pointer, Pointer, Pointer, Pointer, Pointer, Integer> getRegEnumKeyExW() {
            return (Function8)RegEnumKeyExW$delegate.getValue(this, $$delegatedProperties[9]);
        }

        static {
            Object object = new KProperty[]{Reflection.property1(new PropertyReference1Impl(Advapi32.class, "RegCloseKey", "getRegCloseKey()Lkotlin/jvm/functions/Function1;", 0)), Reflection.property1(new PropertyReference1Impl(Advapi32.class, "RegDeleteKeyW", "getRegDeleteKeyW()Lkotlin/jvm/functions/Function2;", 0)), Reflection.property1(new PropertyReference1Impl(Advapi32.class, "RegDeleteValueW", "getRegDeleteValueW()Lkotlin/jvm/functions/Function2;", 0)), Reflection.property1(new PropertyReference1Impl(Advapi32.class, "RegSetValueExW", "getRegSetValueExW()Lkotlin/jvm/functions/Function6;", 0)), Reflection.property1(new PropertyReference1Impl(Advapi32.class, "RegOpenKeyExW", "getRegOpenKeyExW()Lkotlin/jvm/functions/Function5;", 0)), Reflection.property1(new PropertyReference1Impl(Advapi32.class, "RegCreateKeyExW", "getRegCreateKeyExW()Lkotlin/jvm/functions/Function9;", 0)), Reflection.property1(new PropertyReference1Impl(Advapi32.class, "RegGetValueW", "getRegGetValueW()Lkotlin/jvm/functions/Function7;", 0)), Reflection.property1(new PropertyReference1Impl(Advapi32.class, "RegEnumValueW", "getRegEnumValueW()Lkotlin/jvm/functions/Function8;", 0)), Reflection.property1(new PropertyReference1Impl(Advapi32.class, "RegQueryInfoKeyW", "getRegQueryInfoKeyW()Lkotlin/jvm/functions/Function12;", 0)), Reflection.property1(new PropertyReference1Impl(Advapi32.class, "RegEnumKeyExW", "getRegEnumKeyExW()Lkotlin/jvm/functions/Function8;", 0))};
            $$delegatedProperties = object;
            INSTANCE = new Advapi32();
            object = INSTANCE;
            FFIFuncConfig config$iv = FFIFuncConfig.Companion.getWIDE_STRING();
            String name$iv = null;
            boolean required$iv = true;
            boolean $i$f$func = false;
            RegCloseKey$delegate = new FFILib.FuncInfo(Reflection.typeOf(Function1.class, KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE)), KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE))), name$iv, config$iv, required$iv).provideDelegate(INSTANCE, $$delegatedProperties[0]);
            FFILib $this$iv = INSTANCE;
            config$iv = FFIFuncConfig.Companion.getWIDE_STRING();
            name$iv = null;
            required$iv = true;
            $i$f$func = false;
            RegDeleteKeyW$delegate = new FFILib.FuncInfo(Reflection.typeOf(Function2.class, KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE)), KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(String.class)), KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE))), name$iv, config$iv, required$iv).provideDelegate(INSTANCE, $$delegatedProperties[1]);
            $this$iv = INSTANCE;
            config$iv = FFIFuncConfig.Companion.getWIDE_STRING();
            name$iv = null;
            required$iv = true;
            $i$f$func = false;
            RegDeleteValueW$delegate = new FFILib.FuncInfo(Reflection.typeOf(Function2.class, KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE)), KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(String.class)), KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE))), name$iv, config$iv, required$iv).provideDelegate(INSTANCE, $$delegatedProperties[2]);
            $this$iv = INSTANCE;
            config$iv = FFIFuncConfig.Companion.getWIDE_STRING();
            name$iv = null;
            required$iv = true;
            $i$f$func = false;
            RegSetValueExW$delegate = new FFILib.FuncInfo(Reflection.typeOf(Function6.class, KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE)), KTypeProjection.Companion.invariant(Reflection.typeOf(String.class)), KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE)), KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE)), KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE)), KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE))), name$iv, config$iv, required$iv).provideDelegate(INSTANCE, $$delegatedProperties[3]);
            $this$iv = INSTANCE;
            config$iv = FFIFuncConfig.Companion.getWIDE_STRING();
            name$iv = null;
            required$iv = true;
            $i$f$func = false;
            RegOpenKeyExW$delegate = new FFILib.FuncInfo(Reflection.typeOf(Function5.class, KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE)), KTypeProjection.Companion.invariant(Reflection.typeOf(String.class)), KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE)), KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE)), KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE))), name$iv, config$iv, required$iv).provideDelegate(INSTANCE, $$delegatedProperties[4]);
            $this$iv = INSTANCE;
            config$iv = FFIFuncConfig.Companion.getWIDE_STRING();
            name$iv = null;
            required$iv = true;
            $i$f$func = false;
            RegCreateKeyExW$delegate = new FFILib.FuncInfo(Reflection.typeOf(Function9.class, KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE)), KTypeProjection.Companion.invariant(Reflection.typeOf(String.class)), KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE)), KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(String.class)), KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE)), KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE)), KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE))), name$iv, config$iv, required$iv).provideDelegate(INSTANCE, $$delegatedProperties[5]);
            $this$iv = INSTANCE;
            config$iv = FFIFuncConfig.Companion.getWIDE_STRING();
            name$iv = null;
            required$iv = true;
            $i$f$func = false;
            RegGetValueW$delegate = new FFILib.FuncInfo(Reflection.typeOf(Function7.class, KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE)), KTypeProjection.Companion.invariant(Reflection.typeOf(String.class)), KTypeProjection.Companion.invariant(Reflection.typeOf(String.class)), KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE)), KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE))), name$iv, config$iv, required$iv).provideDelegate(INSTANCE, $$delegatedProperties[6]);
            $this$iv = INSTANCE;
            config$iv = FFIFuncConfig.Companion.getWIDE_STRING();
            name$iv = null;
            required$iv = true;
            $i$f$func = false;
            RegEnumValueW$delegate = new FFILib.FuncInfo(Reflection.typeOf(Function8.class, KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE)), KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE)), KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE))), name$iv, config$iv, required$iv).provideDelegate(INSTANCE, $$delegatedProperties[7]);
            $this$iv = INSTANCE;
            config$iv = FFIFuncConfig.Companion.getWIDE_STRING();
            name$iv = null;
            required$iv = true;
            $i$f$func = false;
            RegQueryInfoKeyW$delegate = new FFILib.FuncInfo(Reflection.typeOf(Function12.class, KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE)), KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(String.class)), KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE))), name$iv, config$iv, required$iv).provideDelegate(INSTANCE, $$delegatedProperties[8]);
            $this$iv = INSTANCE;
            config$iv = FFIFuncConfig.Companion.getWIDE_STRING();
            name$iv = null;
            required$iv = true;
            $i$f$func = false;
            RegEnumKeyExW$delegate = new FFILib.FuncInfo(Reflection.typeOf(Function8.class, KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE)), KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE)), KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE))), name$iv, config$iv, required$iv).provideDelegate(INSTANCE, $$delegatedProperties[9]);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lkorlibs/io/file/registry/WindowsRegistry$RegistryException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "errorCode", "", "(I)V", "getErrorCode", "()I", "korge-core"})
    public static final class RegistryException
    extends Exception {
        private final int errorCode;

        public RegistryException(int errorCode) {
            super("Win32 error " + errorCode);
            this.errorCode = errorCode;
        }

        public final int getErrorCode() {
            return this.errorCode;
        }
    }
}

