/*
 * Decompiled with CFR 0.152.
 */
package korlibs.io.file.sync;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import korlibs.io.file.std.MemoryNodeTree;
import korlibs.io.file.sync.SyncExecProcess;
import korlibs.io.file.sync.SyncIO;
import korlibs.io.file.sync.SyncIOFD;
import korlibs.io.file.sync.SyncIOStat;
import korlibs.memory.ArraysKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\nH\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0018\u001a\u0004\u0018\u00010\nH\u0016R\u0012\u0010\u0003\u001a\u00060\u0004R\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lkorlibs/io/file/sync/MemorySyncIO;", "Lkorlibs/io/file/sync/SyncIO;", "()V", "root", "Lkorlibs/io/file/std/MemoryNodeTree$Node;", "Lkorlibs/io/file/std/MemoryNodeTree;", "tree", "delete", "", "path", "", "list", "", "mkdir", "open", "Lkorlibs/io/file/sync/SyncIOFD;", "mode", "readlink", "realpath", "rmdir", "stat", "Lkorlibs/io/file/sync/SyncIOStat;", "writelink", "", "link", "NodeSyncIOFD", "korge-core"})
@SourceDebugExtension(value={"SMAP\nSyncIO.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SyncIO.kt\nkorlibs/io/file/sync/MemorySyncIO\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,190:1\n1549#2:191\n1620#2,3:192\n*S KotlinDebug\n*F\n+ 1 SyncIO.kt\nkorlibs/io/file/sync/MemorySyncIO\n*L\n179#1:191\n179#1:192,3\n*E\n"})
public final class MemorySyncIO
implements SyncIO {
    @NotNull
    private final MemoryNodeTree tree = new MemoryNodeTree(false, 1, null);
    @NotNull
    private final MemoryNodeTree.Node root = this.tree.getRootNode();

    @Override
    @NotNull
    public String realpath(@NotNull String path2) {
        return MemoryNodeTree.Node.access$default(this.root, path2, false, 2, null).followLinks().getPath();
    }

    @Override
    @Nullable
    public String readlink(@NotNull String path2) {
        MemoryNodeTree.Node node2 = this.root.accessOrNull(path2);
        return node2 != null ? node2.getLink() : null;
    }

    @Override
    public void writelink(@NotNull String path2, @Nullable String link) {
        MemoryNodeTree.Node node2 = this.root.access(path2, true);
        node2.setLink(link);
    }

    @Override
    @NotNull
    public SyncIOFD open(@NotNull String path2, @NotNull String mode) {
        boolean write2 = StringsKt.contains$default((CharSequence)mode, 'w', false, 2, null);
        return new NodeSyncIOFD(this.root.access(path2, write2).followLinks());
    }

    @Override
    @Nullable
    public SyncIOStat stat(@NotNull String path2) {
        MemoryNodeTree.Node node2 = this.root.accessOrNull(path2);
        if (node2 == null) {
            return null;
        }
        Object object = node2.getData();
        byte[] byArray = object instanceof byte[] ? (byte[])object : null;
        return new SyncIOStat(node2.getName(), node2.isDirectory(), byArray != null ? (long)byArray.length : 0L);
    }

    @Override
    public boolean mkdir(@NotNull String path2) {
        this.root.access(path2, true);
        return true;
    }

    @Override
    public boolean rmdir(@NotNull String path2) {
        return this.delete(path2);
    }

    @Override
    public boolean delete(@NotNull String path2) {
        MemoryNodeTree.Node node2 = this.root.accessOrNull(path2);
        if (node2 == null) {
            return false;
        }
        MemoryNodeTree.Node node3 = node2;
        node3.delete();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> list(@NotNull String path2) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.root.access(path2, false);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MemoryNodeTree.Node node2 = (MemoryNodeTree.Node)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public String readString(@NotNull String path2) {
        return SyncIO.DefaultImpls.readString(this, path2);
    }

    @Override
    public void writeString(@NotNull String path2, @NotNull String data2) {
        SyncIO.DefaultImpls.writeString(this, path2, data2);
    }

    @Override
    @NotNull
    public byte[] readAllBytes(@NotNull String path2) {
        return SyncIO.DefaultImpls.readAllBytes(this, path2);
    }

    @Override
    public void writeAllBytes(@NotNull String path2, @NotNull byte[] data2) {
        SyncIO.DefaultImpls.writeAllBytes(this, path2, data2);
    }

    @Override
    public void write(@NotNull String path2, @NotNull byte[] data2) {
        SyncIO.DefaultImpls.write(this, path2, data2);
    }

    @Override
    @NotNull
    public SyncExecProcess exec(@NotNull List<String> commands2, @NotNull Map<String, String> envs, @NotNull String cwd) {
        return SyncIO.DefaultImpls.exec(this, commands2, envs, cwd);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u001e\u001a\u00020\u001fH\u0016J \u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u0019H\u0016J \u0010$\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u0019H\u0016R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR$\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00078V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\t\"\u0004\b\u0011\u0010\u0012R\u0015\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R$\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00078V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\t\"\u0004\b\u0017\u0010\u0012R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006%"}, d2={"Lkorlibs/io/file/sync/MemorySyncIO$NodeSyncIOFD;", "Lkorlibs/io/file/sync/SyncIOFD;", "node", "Lkorlibs/io/file/std/MemoryNodeTree$Node;", "Lkorlibs/io/file/std/MemoryNodeTree;", "(Lkorlibs/io/file/std/MemoryNodeTree$Node;)V", "available", "", "getAvailable", "()J", "bytes", "", "getBytes", "()[B", "value", "length", "getLength", "setLength", "(J)V", "getNode", "()Lkorlibs/io/file/std/MemoryNodeTree$Node;", "position", "getPosition", "setPosition", "positionInt", "", "getPositionInt", "()I", "setPositionInt", "(I)V", "close", "", "read", "data", "offset", "size", "write", "korge-core"})
    public static final class NodeSyncIOFD
    implements SyncIOFD {
        @NotNull
        private final MemoryNodeTree.Node node;
        private int positionInt;

        public NodeSyncIOFD(@NotNull MemoryNodeTree.Node node2) {
            this.node = node2;
        }

        @NotNull
        public final MemoryNodeTree.Node getNode() {
            return this.node;
        }

        @NotNull
        public final byte[] getBytes() {
            byte[] byArray = this.node.getBytes();
            if (byArray == null) {
                byArray = new byte[]{};
            }
            return byArray;
        }

        public final int getPositionInt() {
            return this.positionInt;
        }

        public final void setPositionInt(int n) {
            this.positionInt = n;
        }

        @Override
        public long getLength() {
            return this.getBytes().length;
        }

        @Override
        public void setLength(long value) {
            byte[] byArray = Arrays.copyOf(this.getBytes(), (int)value);
            Intrinsics.checkNotNullExpressionValue(byArray, "copyOf(...)");
            this.node.setBytes(byArray);
        }

        @Override
        public long getPosition() {
            return this.positionInt;
        }

        @Override
        public void setPosition(long value) {
            this.positionInt = (int)value;
        }

        public final long getAvailable() {
            return this.getLength() - this.getPosition();
        }

        @Override
        public int write(@NotNull byte[] data2, int offset2, int size2) {
            this.setLength(Math.max(this.getLength(), this.getPosition() + (long)size2));
            ArraysKt.arraycopy(data2, offset2, this.getBytes(), this.positionInt, size2);
            this.positionInt += size2;
            return size2;
        }

        @Override
        public int read(@NotNull byte[] data2, int offset2, int size2) {
            int rsize = Math.min(size2, (int)this.getAvailable());
            ArraysKt.arraycopy(this.getBytes(), this.positionInt, data2, offset2, rsize);
            this.setPosition(this.getPosition() + (long)rsize);
            return rsize;
        }

        @Override
        public void close() {
        }
    }
}

