/*
 * Decompiled with CFR 0.152.
 */
package korlibs.io.file.sync;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import korlibs.io.file.sync.SyncExecProcess;
import korlibs.io.file.sync.SyncIO;
import korlibs.io.file.sync.SyncIOFD;
import korlibs.io.file.sync.SyncIOStat;
import korlibs.io.stream.JavaExKt;
import korlibs.io.stream.SyncInputStream;
import korlibs.io.stream.SyncOutputStream;
import korlibs.io.stream.SyncStream;
import korlibs.io.stream.SyncStreamKt;
import korlibs.io.util.JvmFsCaseSensitiveKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0004"}, d2={"platformSyncIO", "Lkorlibs/io/file/sync/SyncIO;", "caseSensitive", "", "korge-core"})
public final class PlatformSyncIOKt {
    @NotNull
    public static final SyncIO platformSyncIO(boolean caseSensitive) {
        return new SyncIO(caseSensitive){
            final /* synthetic */ boolean $caseSensitive;
            {
                this.$caseSensitive = $caseSensitive;
            }

            @NotNull
            public String realpath(@NotNull String path2) {
                String string = new File(path2).getCanonicalPath();
                Intrinsics.checkNotNullExpressionValue(string, "getCanonicalPath(...)");
                return string;
            }

            @Nullable
            public String readlink(@NotNull String path2) {
                Object object;
                try {
                    String string;
                    Path path3;
                    boolean bl = false;
                    Path path4 = path3 = Files.readSymbolicLink(new File(path2).toPath());
                    if (path4 != null) {
                        Intrinsics.checkNotNull(path4);
                        string = ((Object)path3.toAbsolutePath()).toString();
                    } else {
                        string = null;
                    }
                    object = Result.constructor-impl(string);
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl(ResultKt.createFailure(throwable));
                }
                return (String)(Result.isFailure-impl(object) ? null : object);
            }

            private final File file(String path2) {
                File file = new File(path2);
                boolean bl = this.$caseSensitive;
                File it = file;
                boolean bl2 = false;
                return bl ? JvmFsCaseSensitiveKt.caseSensitiveOrThrow(it) : it;
            }

            @NotNull
            public SyncIOFD open(@NotNull String path2, @NotNull String mode) {
                File file = this.file(path2);
                RandomAccessFile raf2 = new RandomAccessFile(file, mode);
                return new SyncIOFD(raf2){
                    final /* synthetic */ RandomAccessFile $raf;
                    {
                        this.$raf = $raf;
                    }

                    public long getLength() {
                        return this.$raf.length();
                    }

                    public void setLength(long value) {
                        this.$raf.setLength(value);
                    }

                    public long getPosition() {
                        return this.$raf.getFilePointer();
                    }

                    public void setPosition(long value) {
                        this.$raf.seek(value);
                    }

                    public int write(@NotNull byte[] data2, int offset2, int size2) {
                        this.$raf.write(data2, offset2, size2);
                        Unit $this$write_u24lambda_u240 = Unit.INSTANCE;
                        boolean bl = false;
                        return size2;
                    }

                    public int read(@NotNull byte[] data2, int offset2, int size2) {
                        return this.$raf.read(data2, offset2, size2);
                    }

                    public void close() {
                        this.$raf.close();
                    }
                };
            }

            @Nullable
            public SyncIOStat stat(@NotNull String path2) {
                SyncIOStat syncIOStat;
                File file;
                File it = file = this.file(path2);
                boolean bl = false;
                File file2 = it.exists() ? file : null;
                if (file2 != null) {
                    it = file2;
                    boolean bl2 = false;
                    syncIOStat = new SyncIOStat(path2, it.isDirectory(), it.length());
                } else {
                    syncIOStat = null;
                }
                return syncIOStat;
            }

            public boolean mkdir(@NotNull String path2) {
                return this.file(path2).mkdir();
            }

            public boolean rmdir(@NotNull String path2) {
                File file;
                File it = file = this.file(path2);
                boolean bl = false;
                File file2 = it.isDirectory() ? file : null;
                return file2 != null ? file2.delete() : false;
            }

            public boolean delete(@NotNull String path2) {
                File file;
                File it = file = this.file(path2);
                boolean bl = false;
                File file2 = !it.isDirectory() ? file : null;
                return file2 != null ? file2.delete() : false;
            }

            @NotNull
            public List<String> list(@NotNull String path2) {
                Object object = this.file(path2).list();
                if (object == null || (object = ArraysKt.toList(object)) == null) {
                    object = CollectionsKt.emptyList();
                }
                return object;
            }

            @NotNull
            public SyncExecProcess exec(@NotNull List<String> commands2, @NotNull Map<String, String> envs, @NotNull String cwd) {
                Object object = new ProcessBuilder(CollectionsKt.toMutableList((Collection)commands2)).directory(this.file(cwd));
                ProcessBuilder it = object;
                boolean bl = false;
                it.environment().putAll(envs);
                it = object;
                boolean bl2 = false;
                it.redirectError(ProcessBuilder.Redirect.INHERIT);
                Process process = ((ProcessBuilder)object).start();
                OutputStream outputStream = process.getOutputStream();
                Intrinsics.checkNotNullExpressionValue(outputStream, "getOutputStream(...)");
                object = JavaExKt.toSyncOutputStream(outputStream);
                InputStream inputStream = process.getInputStream();
                Intrinsics.checkNotNullExpressionValue(inputStream, "getInputStream(...)");
                SyncInputStream syncInputStream = JavaExKt.toSyncInputStream(inputStream);
                SyncStream syncStream = SyncStreamKt.openSync$default(new byte[0], null, 1, null);
                return new SyncExecProcess(process, (SyncOutputStream)object, syncInputStream, syncStream){
                    final /* synthetic */ Process $process;
                    {
                        this.$process = $process;
                        super($super_call_param$1, $super_call_param$2, $super_call_param$3);
                    }

                    public int getExitCode() {
                        return this.$process.waitFor();
                    }

                    public void destroy() {
                        this.$process.destroy();
                    }
                };
            }

            public void writelink(@NotNull String path2, @Nullable String link) {
                SyncIO.DefaultImpls.writelink(this, path2, link);
            }

            @NotNull
            public String readString(@NotNull String path2) {
                return SyncIO.DefaultImpls.readString(this, path2);
            }

            public void writeString(@NotNull String path2, @NotNull String data2) {
                SyncIO.DefaultImpls.writeString(this, path2, data2);
            }

            @NotNull
            public byte[] readAllBytes(@NotNull String path2) {
                return SyncIO.DefaultImpls.readAllBytes(this, path2);
            }

            public void writeAllBytes(@NotNull String path2, @NotNull byte[] data2) {
                SyncIO.DefaultImpls.writeAllBytes(this, path2, data2);
            }

            public void write(@NotNull String path2, @NotNull byte[] data2) {
                SyncIO.DefaultImpls.write(this, path2, data2);
            }
        };
    }
}

