/*
 * Decompiled with CFR 0.152.
 */
package korlibs.io.file.sync;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import korlibs.io.file.PathInfo;
import korlibs.io.file.PathInfoKt;
import korlibs.io.file.sync.SyncIO;
import korlibs.io.file.sync.SyncIOAPI;
import korlibs.io.file.sync.SyncIOFD;
import korlibs.io.file.sync.SyncIOKt;
import korlibs.io.file.sync.SyncIOStat;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000 12\u00020\u0001:\u00011B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0017\u001a\u00020\u000eJ\u0006\u0010\u0018\u001a\u00020\u000eJ\u0011\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0005H\u0086\u0002J\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00000\u001cJ\u0006\u0010\u001d\u001a\u00020\u000eJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0005J\u0006\u0010!\u001a\u00020\"J\u0006\u0010#\u001a\u00020\u0005J\b\u0010$\u001a\u0004\u0018\u00010\u0005J\u0006\u0010%\u001a\u00020\u0005J\u0006\u0010&\u001a\u00020\u000eJ\b\u0010'\u001a\u0004\u0018\u00010(J\b\u0010)\u001a\u00020\u0005H\u0016J\u000e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\"J\u000e\u0010-\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0005J\u000e\u0010.\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0005J\u0010\u0010/\u001a\u00020+2\b\u00100\u001a\u0004\u0018\u00010\u0005R\u0011\u0010\u0007\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\tR\u0011\u0010\u0012\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\t\u00a8\u00062"}, d2={"Lkorlibs/io/file/sync/SyncIOFile;", "", "impl", "Lkorlibs/io/file/sync/SyncIO;", "fullPath", "", "(Lkorlibs/io/file/sync/SyncIO;Ljava/lang/String;)V", "absolutePath", "getAbsolutePath", "()Ljava/lang/String;", "getFullPath", "getImpl", "()Lkorlibs/io/file/sync/SyncIO;", "isDirectory", "", "()Z", "name", "getName", "parent", "getParent", "()Lkorlibs/io/file/sync/SyncIOFile;", "path", "getPath", "delete", "exists", "get", "child", "list", "", "mkdir", "open", "Lkorlibs/io/file/sync/SyncIOFD;", "mode", "readBytes", "", "readString", "readlink", "realpath", "rmdir", "stat", "Lkorlibs/io/file/sync/SyncIOStat;", "toString", "writeBytes", "", "content", "writeString", "writeText", "writelink", "link", "Companion", "korge-core"})
@SourceDebugExtension(value={"SMAP\nSyncIO.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SyncIO.kt\nkorlibs/io/file/sync/SyncIOFile\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,190:1\n1549#2:191\n1620#2,3:192\n*S KotlinDebug\n*F\n+ 1 SyncIO.kt\nkorlibs/io/file/sync/SyncIOFile\n*L\n48#1:191\n48#1:192,3\n*E\n"})
public final class SyncIOFile {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SyncIO impl;
    @NotNull
    private final String fullPath;

    public SyncIOFile(@NotNull SyncIO impl, @NotNull String fullPath) {
        this.impl = impl;
        this.fullPath = fullPath;
    }

    @NotNull
    public final SyncIO getImpl() {
        return this.impl;
    }

    @NotNull
    public final String getFullPath() {
        return this.fullPath;
    }

    @NotNull
    public final SyncIOFile get(@NotNull String child) {
        return new SyncIOFile(this.impl, this.fullPath + "/" + child);
    }

    @NotNull
    public final String getName() {
        return PathInfoKt.getBaseName-pnq4Q78(PathInfo.constructor-impl(this.fullPath));
    }

    @NotNull
    public final String getPath() {
        return PathInfoKt.getParent-pnq4Q78(PathInfo.constructor-impl(this.fullPath));
    }

    @NotNull
    public final SyncIOFile getParent() {
        return new SyncIOFile(this.impl, this.getPath());
    }

    @NotNull
    public final String getAbsolutePath() {
        return this.fullPath;
    }

    @Nullable
    public final SyncIOStat stat() {
        return this.impl.stat(this.fullPath);
    }

    public final boolean isDirectory() {
        SyncIOStat syncIOStat = this.stat();
        return syncIOStat != null ? syncIOStat.isDirectory() : false;
    }

    public final boolean exists() {
        return this.stat() != null;
    }

    @NotNull
    public final byte[] readBytes() {
        return this.impl.readAllBytes(this.fullPath);
    }

    @NotNull
    public final String readString() {
        return this.impl.readString(this.fullPath);
    }

    public final void writeBytes(@NotNull byte[] content2) {
        this.impl.writeAllBytes(this.fullPath, content2);
    }

    public final void writeString(@NotNull String content2) {
        this.impl.writeString(this.fullPath, content2);
    }

    public final void writeText(@NotNull String content2) {
        this.impl.writeString(this.fullPath, content2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<SyncIOFile> list() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.impl.list(this.fullPath);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.get((String)it));
        }
        return (List)destination$iv$iv;
    }

    public final boolean mkdir() {
        return this.impl.mkdir(this.fullPath);
    }

    public final boolean rmdir() {
        return this.impl.rmdir(this.fullPath);
    }

    public final boolean delete() {
        return this.impl.delete(this.fullPath);
    }

    @NotNull
    public final String realpath() {
        return this.impl.realpath(this.fullPath);
    }

    @Nullable
    public final String readlink() {
        return this.impl.readlink(this.fullPath);
    }

    public final void writelink(@Nullable String link) {
        this.impl.writelink(this.fullPath, link);
    }

    @NotNull
    public final SyncIOFD open(@NotNull String mode) {
        return this.impl.open(this.fullPath, mode);
    }

    @NotNull
    public String toString() {
        return "SyncIOFile(" + this.fullPath + ")";
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0087\u0002\u00a8\u0006\u0007"}, d2={"Lkorlibs/io/file/sync/SyncIOFile$Companion;", "", "()V", "invoke", "Lkorlibs/io/file/sync/SyncIOFile;", "path", "", "korge-core"})
    public static final class Companion {
        private Companion() {
        }

        @SyncIOAPI
        @NotNull
        public final SyncIOFile invoke(@NotNull String path2) {
            return new SyncIOFile(SyncIOKt.getPlatformSyncIO(), path2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

