/*
 * Decompiled with CFR 0.152.
 */
package korlibs.io.lang;

import java.util.List;
import java.util.Locale;
import korlibs.concurrent.lock.NonRecursiveLock;
import korlibs.io.lang.CharsetJvmKt;
import korlibs.io.lang.CharsetKt;
import korlibs.io.lang.CharsetProvider;
import korlibs.io.lang.ExceptionsKt;
import korlibs.io.lang.ISO_8859_1;
import korlibs.io.lang.UTF8Kt;
import korlibs.memory.BitsKt;
import korlibs.memory.ByteArrayBuilder;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\b\u0006\b&\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\b2\b\b\u0002\u0010\u000f\u001a\u00020\bH&J,\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u00132\b\b\u0002\u0010\u000e\u001a\u00020\b2\b\b\u0002\u0010\u000f\u001a\u00020\bH&J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\bH\u0016J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lkorlibs/io/lang/Charset;", "", "name", "", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "decode", "", "out", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "src", "", "start", "end", "encode", "", "Lkorlibs/memory/ByteArrayBuilder;", "", "estimateNumberOfBytesForCharacters", "nchars", "estimateNumberOfCharactersForBytes", "nbytes", "Companion", "korge-core"})
public abstract class Charset {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;

    public Charset(@NotNull String name2) {
        this.name = name2;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public int estimateNumberOfCharactersForBytes(int nbytes) {
        return nbytes * 2;
    }

    public int estimateNumberOfBytesForCharacters(int nchars) {
        return nchars * 2;
    }

    public abstract void encode(@NotNull ByteArrayBuilder var1, @NotNull CharSequence var2, int var3, int var4);

    public static /* synthetic */ void encode$default(Charset charset, ByteArrayBuilder byteArrayBuilder, CharSequence charSequence, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: encode");
        }
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = charSequence.length();
        }
        charset.encode(byteArrayBuilder, charSequence, n, n2);
    }

    public abstract int decode(@NotNull StringBuilder var1, @NotNull byte[] var2, int var3, int var4);

    public static /* synthetic */ int decode$default(Charset charset, StringBuilder stringBuilder, byte[] byArray, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: decode");
        }
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = byArray.length;
        }
        return charset.decode(stringBuilder, byArray, n, n2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JD\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2!\u0010\n\u001a\u001d\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u00040\u000bH\u0086\bJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014J*\u0010\u0012\u001a\u0002H\u0015\"\u0004\b\u0000\u0010\u00152\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0016H\u0086\b\u00a2\u0006\u0002\u0010\u0017J\u000e\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0019\u001a\u00020\u0004*\u00060\u001aj\u0002`\u001b2\u0006\u0010\u000e\u001a\u00020\b\u00a8\u0006\u001c"}, d2={"Lkorlibs/io/lang/Charset$Companion;", "", "()V", "decodeCodePoints", "", "src", "", "start", "", "end", "block", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "codePoint", "forName", "Lkorlibs/io/lang/Charset;", "", "registerProvider", "provider", "Lkorlibs/io/lang/CharsetProvider;", "T", "Lkotlin/Function0;", "(Lkorlibs/io/lang/CharsetProvider;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "unregisterProvider", "appendCodePointV", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "korge-core"})
    @SourceDebugExtension(value={"SMAP\nCharset.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Charset.kt\nkorlibs/io/lang/Charset$Companion\n+ 2 Lock.jvm.kt\nkorlibs/concurrent/lock/NonRecursiveLock\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Datastructure_iterators.kt\nkorlibs/datastructure/iterators/_Datastructure_iteratorsKt\n*L\n1#1,284:1\n54#2:285\n54#2:287\n54#2:289\n1#3:286\n1#3:288\n1#3:290\n1#3:293\n61#4,2:291\n63#4:294\n*S KotlinDebug\n*F\n+ 1 Charset.kt\nkorlibs/io/lang/Charset$Companion\n*L\n46#1:285\n52#1:287\n65#1:289\n46#1:286\n52#1:288\n65#1:290\n66#1:291,2\n66#1:294\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final <T> T registerProvider(@NotNull CharsetProvider provider, @NotNull Function0<? extends T> block2) {
            T t;
            boolean $i$f$registerProvider = false;
            this.registerProvider(provider);
            try {
                t = block2.invoke();
            }
            finally {
                InlineMarker.finallyStart(1);
                this.unregisterProvider(provider);
                InlineMarker.finallyEnd(1);
            }
            return t;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void registerProvider(@NotNull CharsetProvider provider) {
            NonRecursiveLock this_$iv = CharsetKt.access$getCHARSET_PROVIDERS_LOCK$p();
            boolean $i$f$invoke = false;
            NonRecursiveLock nonRecursiveLock = this_$iv;
            synchronized (nonRecursiveLock) {
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = CharsetKt.access$getCHARSET_PROVIDERS$p().add(provider);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void unregisterProvider(@NotNull CharsetProvider provider) {
            NonRecursiveLock this_$iv = CharsetKt.access$getCHARSET_PROVIDERS_LOCK$p();
            boolean $i$f$invoke = false;
            NonRecursiveLock nonRecursiveLock = this_$iv;
            synchronized (nonRecursiveLock) {
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = CharsetKt.access$getCHARSET_PROVIDERS$p().remove(provider);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @NotNull
        public final Charset forName(@NotNull String name2) {
            String string = name2.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
            String normalizedName = StringsKt.replace$default(StringsKt.replace$default(string, "_", "", false, 4, null), "-", "", false, 4, null);
            switch (normalizedName) {
                case "UTF8": {
                    return UTF8Kt.getUTF8();
                }
                case "UTF16": 
                case "UTF16LE": {
                    return CharsetKt.getUTF16_LE();
                }
                case "UTF16BE": {
                    return CharsetKt.getUTF16_BE();
                }
                case "ISO88591": 
                case "LATIN1": {
                    return ISO_8859_1.INSTANCE;
                }
            }
            NonRecursiveLock this_$iv = CharsetKt.access$getCHARSET_PROVIDERS_LOCK$p();
            boolean $i$f$invoke = false;
            NonRecursiveLock nonRecursiveLock = this_$iv;
            synchronized (nonRecursiveLock) {
                boolean bl = false;
                boolean bl2 = false;
                List $this$fastForEach$iv = CharsetKt.access$getCHARSET_PROVIDERS$p();
                boolean $i$f$fastForEach = false;
                int n$iv = 0;
                while (n$iv < $this$fastForEach$iv.size()) {
                    CharsetProvider provider = (CharsetProvider)$this$fastForEach$iv.get(n$iv++);
                    boolean bl3 = false;
                    Charset charset = provider.invoke(normalizedName, name2);
                    if (charset == null) continue;
                    Charset it = charset;
                    boolean bl4 = false;
                    return it;
                }
                Unit $i$a$-synchronized-NonRecursiveLock$invoke$1$iv2 = Unit.INSTANCE;
            }
            Object object = CharsetJvmKt.getPlatformCharsetProvider().invoke(normalizedName, name2);
            if (object != null) {
                return object;
            }
            ExceptionsKt.invalidArg("Unknown charset '" + name2 + "'");
            throw new KotlinNothingValueException();
        }

        public final void appendCodePointV(@NotNull StringBuilder $this$appendCodePointV, int codePoint) {
            boolean bl = 55296 <= codePoint ? codePoint < 57344 : false;
            if (bl || codePoint > 65535) {
                int U0 = codePoint - 65536;
                int hs = BitsKt.extract(U0, 10, 10);
                int ls = BitsKt.extract(U0, 0, 10);
                $this$appendCodePointV.append((char)(0xD800 | hs));
                $this$appendCodePointV.append((char)(0xDC00 | ls));
            } else {
                $this$appendCodePointV.append((char)codePoint);
            }
        }

        public final void decodeCodePoints(@NotNull CharSequence src, int start2, int end2, @NotNull Function1<? super Integer, Unit> block2) {
            boolean $i$f$decodeCodePoints = false;
            int highSurrogate = 0;
            block4: for (int n = start2; n < end2; ++n) {
                int n2;
                block6: {
                    int n3;
                    block5: {
                        n3 = src.charAt(n);
                        boolean bl = 55296 <= n3 ? n3 < 57344 : false;
                        if (!bl) break block5;
                        switch (BitsKt.extract(n3, 10, 6)) {
                            case 54: {
                                highSurrogate = n3 & 0x3FF;
                                continue block4;
                            }
                            case 55: {
                                n2 = 65536 + (highSurrogate << 10 | n3 & 0x3FF);
                                break block6;
                            }
                            default: {
                                throw new IllegalStateException(("Unknown " + n3).toString());
                            }
                        }
                    }
                    n2 = n3;
                }
                int codePoint = n2;
                block2.invoke((Integer)codePoint);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

