/*
 * Decompiled with CFR 0.152.
 */
package korlibs.io.lang;

import korlibs.io.lang.Charset;
import korlibs.memory.ByteArrayBuilder;
import korlibs.memory.ByteArrayGetSetKt;
import kotlin.Metadata;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\bH\u0016J(\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\bH\u0016J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\bH\u0016J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lkorlibs/io/lang/UTF16Charset;", "Lkorlibs/io/lang/Charset;", "le", "", "(Z)V", "getLe", "()Z", "decode", "", "out", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "src", "", "start", "end", "encode", "", "Lkorlibs/memory/ByteArrayBuilder;", "", "estimateNumberOfBytesForCharacters", "nchars", "estimateNumberOfCharactersForBytes", "nbytes", "korge-core"})
public final class UTF16Charset
extends Charset {
    private final boolean le;

    public UTF16Charset(boolean le) {
        super("UTF-16-" + (le ? "LE" : "BE"));
        this.le = le;
    }

    public final boolean getLe() {
        return this.le;
    }

    @Override
    public int estimateNumberOfCharactersForBytes(int nbytes) {
        return nbytes * 2;
    }

    @Override
    public int estimateNumberOfBytesForCharacters(int nchars) {
        return nchars * 2;
    }

    @Override
    public int decode(@NotNull StringBuilder out, @NotNull byte[] src, int start2, int end2) {
        int consumed = 0;
        IntProgression intProgression = RangesKt.step(RangesKt.until(start2, end2), 2);
        int n = intProgression.getFirst();
        int n2 = intProgression.getLast();
        int n3 = intProgression.getStep();
        if (n3 > 0 && n <= n2 || n3 < 0 && n2 <= n) {
            while (true) {
                char c = (char)ByteArrayGetSetKt.getS16(src, n, this.le);
                out.append(c);
                consumed += 2;
                if (n == n2) break;
                n += n3;
            }
        }
        return consumed;
    }

    @Override
    public void encode(@NotNull ByteArrayBuilder out, @NotNull CharSequence src, int start2, int end2) {
        byte[] temp = new byte[2];
        for (int n = start2; n < end2; ++n) {
            ByteArrayGetSetKt.set16(temp, 0, src.charAt(n), this.le);
            ByteArrayBuilder.append$default(out, temp, 0, 0, 6, null);
        }
    }
}

