/*
 * Decompiled with CFR 0.152.
 */
package korlibs.io.net;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import korlibs.encoding.Hex;
import korlibs.io.lang.Charset;
import korlibs.io.lang.CharsetKt;
import korlibs.io.lang.MalformedInputException;
import korlibs.io.lang.StringExtKt;
import korlibs.io.lang.UTF8Kt;
import korlibs.io.net.URL;
import korlibs.io.net.URLKt;
import korlibs.io.util.BaseStrReader;
import korlibs.io.util.StrReader;
import korlibs.memory.ByteArrayBuilder;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty0;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b2\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u0000 D2\u00020\u0001:\u0001DB[\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\t\u0010/\u001a\u00020\u0003H\u00c6\u0003J\u000b\u00100\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u00101\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u00102\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u00103\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u00104\u001a\u00020\u0005H\u00c6\u0003J\u000b\u00105\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u00106\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u00107\u001a\u00020\rH\u00c6\u0003Jo\u00108\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\t\u001a\u00020\u00052\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\f\u001a\u00020\rH\u00c6\u0001J\u0013\u00109\u001a\u00020\u00032\b\u0010:\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010;\u001a\u00020\rH\u00d6\u0001J\u000e\u0010<\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0000J\u0006\u0010=\u001a\u00020\u0005J\b\u0010>\u001a\u00020\u0005H\u0016J\"\u0010?\u001a\u00060@j\u0002`A2\b\b\u0002\u0010B\u001a\u00020\u00032\f\b\u0002\u0010C\u001a\u00060@j\u0002`AR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001b\u0010\u0015\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0016\u0010\u0014R\u001b\u0010\u0019\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0018\u001a\u0004\b\u001a\u0010\u0014R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0014R\u0011\u0010\u001d\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u001eR\u0011\u0010 \u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001eR\u0013\u0010!\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0014R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0014R\u001b\u0010$\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010\u0018\u001a\u0004\b%\u0010\u0014R\u0011\u0010'\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0010R\u0013\u0010\n\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0014R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u0014R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u0014R\u0013\u0010,\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0014R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u0014\u00a8\u0006E"}, d2={"Lkorlibs/io/net/URL;", "", "isOpaque", "", "scheme", "", "subScheme", "userInfo", "host", "path", "query", "fragment", "defaultPort", "", "(ZLjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;I)V", "getDefaultPort", "()I", "defaultSchemePort", "getDefaultSchemePort", "getFragment", "()Ljava/lang/String;", "fullUrl", "getFullUrl", "fullUrl$delegate", "Lkotlin/Lazy;", "fullUrlWithoutScheme", "getFullUrlWithoutScheme", "fullUrlWithoutScheme$delegate", "getHost", "isAbsolute", "()Z", "isHierarchical", "isSecureScheme", "password", "getPassword", "getPath", "pathWithQuery", "getPathWithQuery", "pathWithQuery$delegate", "port", "getPort", "getQuery", "getScheme", "getSubScheme", "user", "getUser", "getUserInfo", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "hashCode", "resolve", "toComponentString", "toString", "toUrlString", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "includeScheme", "out", "Companion", "korge-core"})
@SourceDebugExtension(value={"SMAP\nURL.kt\nKotlin\n*S Kotlin\n*F\n+ 1 URL.kt\nkorlibs/io/net/URL\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,273:1\n1549#2:274\n1620#2,3:275\n766#2:278\n857#2,2:279\n*S KotlinDebug\n*F\n+ 1 URL.kt\nkorlibs/io/net/URL\n*L\n64#1:274\n64#1:275,3\n65#1:278\n65#1:279,2\n*E\n"})
public final class URL {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isOpaque;
    @Nullable
    private final String scheme;
    @Nullable
    private final String subScheme;
    @Nullable
    private final String userInfo;
    @Nullable
    private final String host;
    @NotNull
    private final String path;
    @Nullable
    private final String query;
    @Nullable
    private final String fragment;
    private final int defaultPort;
    @NotNull
    private final Lazy fullUrl$delegate;
    @NotNull
    private final Lazy fullUrlWithoutScheme$delegate;
    @NotNull
    private final Lazy pathWithQuery$delegate;
    private static final int DEFAULT_PORT;
    @NotNull
    private static final Regex schemeRegex;

    private URL(boolean isOpaque, String scheme, String subScheme, String userInfo, String host, String path2, String query, String fragment2, int defaultPort) {
        this.isOpaque = isOpaque;
        this.scheme = scheme;
        this.subScheme = subScheme;
        this.userInfo = userInfo;
        this.host = host;
        this.path = path2;
        this.query = query;
        this.fragment = fragment2;
        this.defaultPort = defaultPort;
        this.fullUrl$delegate = LazyKt.lazy((Function0)new Function0<String>(this){
            final /* synthetic */ URL this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                String string = URL.toUrlString$default(this.this$0, false, null, 3, null).toString();
                Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                return string;
            }
        });
        this.fullUrlWithoutScheme$delegate = LazyKt.lazy((Function0)new Function0<String>(this){
            final /* synthetic */ URL this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                String string = URL.toUrlString$default(this.this$0, false, null, 2, null).toString();
                Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                return string;
            }
        });
        this.pathWithQuery$delegate = LazyKt.lazy((Function0)new Function0<String>(this){
            final /* synthetic */ URL this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return this.this$0.getQuery() != null ? this.this$0.getPath() + "?" + this.this$0.getQuery() : this.this$0.getPath();
            }
        });
    }

    public final boolean isOpaque() {
        return this.isOpaque;
    }

    @Nullable
    public final String getScheme() {
        return this.scheme;
    }

    @Nullable
    public final String getSubScheme() {
        return this.subScheme;
    }

    @Nullable
    public final String getUserInfo() {
        return this.userInfo;
    }

    @Nullable
    public final String getHost() {
        return this.host;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @Nullable
    public final String getQuery() {
        return this.query;
    }

    @Nullable
    public final String getFragment() {
        return this.fragment;
    }

    public final int getDefaultPort() {
        return this.defaultPort;
    }

    @Nullable
    public final String getUser() {
        String string = this.userInfo;
        return string != null ? StringsKt.substringBefore$default(string, ':', null, 2, null) : null;
    }

    @Nullable
    public final String getPassword() {
        String string = this.userInfo;
        return string != null ? StringsKt.substringAfter$default(string, ':', null, 2, null) : null;
    }

    public final boolean isHierarchical() {
        return !this.isOpaque;
    }

    public final boolean isSecureScheme() {
        return Intrinsics.areEqual(this.scheme, "https") || Intrinsics.areEqual(this.scheme, "wss") || Intrinsics.areEqual(this.scheme, "ftps");
    }

    public final int getDefaultSchemePort() {
        return Companion.defaultPortForScheme(this.scheme);
    }

    public final int getPort() {
        return this.defaultPort == DEFAULT_PORT ? this.getDefaultSchemePort() : this.defaultPort;
    }

    @NotNull
    public final String getFullUrl() {
        Lazy lazy = this.fullUrl$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String getFullUrlWithoutScheme() {
        Lazy lazy = this.fullUrlWithoutScheme$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String getPathWithQuery() {
        Lazy lazy = this.pathWithQuery$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final StringBuilder toUrlString(boolean includeScheme, @NotNull StringBuilder out) {
        if (includeScheme && this.scheme != null) {
            out.append(this.scheme + ":");
            if (this.subScheme != null) {
                out.append(this.subScheme + ":");
            }
            if (!this.isOpaque) {
                out.append("//");
            }
        }
        if (this.userInfo != null) {
            out.append(this.userInfo + "@");
        }
        if (this.host != null) {
            out.append(this.host);
        }
        if (this.getPort() != DEFAULT_PORT && this.getPort() != this.getDefaultSchemePort()) {
            out.append(':').append(this.getPort());
        }
        out.append(this.path);
        if (this.query != null) {
            out.append("?" + this.query);
        }
        if (this.fragment != null) {
            out.append("#" + this.fragment);
        }
        return out;
    }

    public static /* synthetic */ StringBuilder toUrlString$default(URL uRL, boolean bl, StringBuilder stringBuilder, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            stringBuilder = new StringBuilder();
        }
        return uRL.toUrlString(bl, stringBuilder);
    }

    public final boolean isAbsolute() {
        return this.scheme != null;
    }

    @NotNull
    public String toString() {
        return this.getFullUrl();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String toComponentString() {
        void $this$filterTo$iv$iv;
        Pair it;
        Iterable $this$mapTo$iv$iv;
        KProperty0[] kProperty0Array = new KProperty0[]{new PropertyReference0Impl(this){

            @Nullable
            public Object get() {
                return ((URL)this.receiver).getScheme();
            }
        }, new PropertyReference0Impl(this){

            @Nullable
            public Object get() {
                return ((URL)this.receiver).getSubScheme();
            }
        }, new PropertyReference0Impl(this){

            @Nullable
            public Object get() {
                return ((URL)this.receiver).getUserInfo();
            }
        }, new PropertyReference0Impl(this){

            @Nullable
            public Object get() {
                return ((URL)this.receiver).getHost();
            }
        }, new PropertyReference0Impl(this){

            @Nullable
            public Object get() {
                return ((URL)this.receiver).getPath();
            }
        }, new PropertyReference0Impl(this){

            @Nullable
            public Object get() {
                return ((URL)this.receiver).getQuery();
            }
        }, new PropertyReference0Impl(this){

            @Nullable
            public Object get() {
                return ((URL)this.receiver).getFragment();
            }
        }};
        Iterable $this$map$iv = CollectionsKt.listOf(kProperty0Array);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            KProperty0 kProperty0 = (KProperty0)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to(it.getName(), it.get()));
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!(it.getSecond() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return "URL(" + CollectionsKt.joinToString$default((List)destination$iv$iv, ", ", null, null, 0, null, toComponentString.10.INSTANCE, 30, null) + ")";
    }

    @NotNull
    public final URL resolve(@NotNull URL path2) {
        return Companion.invoke(Companion.resolve(this.getFullUrl(), path2.getFullUrl()));
    }

    public final boolean component1() {
        return this.isOpaque;
    }

    @Nullable
    public final String component2() {
        return this.scheme;
    }

    @Nullable
    public final String component3() {
        return this.subScheme;
    }

    @Nullable
    public final String component4() {
        return this.userInfo;
    }

    @Nullable
    public final String component5() {
        return this.host;
    }

    @NotNull
    public final String component6() {
        return this.path;
    }

    @Nullable
    public final String component7() {
        return this.query;
    }

    @Nullable
    public final String component8() {
        return this.fragment;
    }

    public final int component9() {
        return this.defaultPort;
    }

    @NotNull
    public final URL copy(boolean isOpaque, @Nullable String scheme, @Nullable String subScheme, @Nullable String userInfo, @Nullable String host, @NotNull String path2, @Nullable String query, @Nullable String fragment2, int defaultPort) {
        return new URL(isOpaque, scheme, subScheme, userInfo, host, path2, query, fragment2, defaultPort);
    }

    public static /* synthetic */ URL copy$default(URL uRL, boolean bl, String string, String string2, String string3, String string4, String string5, String string6, String string7, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            bl = uRL.isOpaque;
        }
        if ((n2 & 2) != 0) {
            string = uRL.scheme;
        }
        if ((n2 & 4) != 0) {
            string2 = uRL.subScheme;
        }
        if ((n2 & 8) != 0) {
            string3 = uRL.userInfo;
        }
        if ((n2 & 0x10) != 0) {
            string4 = uRL.host;
        }
        if ((n2 & 0x20) != 0) {
            string5 = uRL.path;
        }
        if ((n2 & 0x40) != 0) {
            string6 = uRL.query;
        }
        if ((n2 & 0x80) != 0) {
            string7 = uRL.fragment;
        }
        if ((n2 & 0x100) != 0) {
            n = uRL.defaultPort;
        }
        return uRL.copy(bl, string, string2, string3, string4, string5, string6, string7, n);
    }

    public int hashCode() {
        int result2 = Boolean.hashCode(this.isOpaque);
        result2 = result2 * 31 + (this.scheme == null ? 0 : this.scheme.hashCode());
        result2 = result2 * 31 + (this.subScheme == null ? 0 : this.subScheme.hashCode());
        result2 = result2 * 31 + (this.userInfo == null ? 0 : this.userInfo.hashCode());
        result2 = result2 * 31 + (this.host == null ? 0 : this.host.hashCode());
        result2 = result2 * 31 + this.path.hashCode();
        result2 = result2 * 31 + (this.query == null ? 0 : this.query.hashCode());
        result2 = result2 * 31 + (this.fragment == null ? 0 : this.fragment.hashCode());
        result2 = result2 * 31 + Integer.hashCode(this.defaultPort);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof URL)) {
            return false;
        }
        URL uRL = (URL)other;
        if (this.isOpaque != uRL.isOpaque) {
            return false;
        }
        if (!Intrinsics.areEqual(this.scheme, uRL.scheme)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.subScheme, uRL.subScheme)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.userInfo, uRL.userInfo)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.host, uRL.host)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.path, uRL.path)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.query, uRL.query)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.fragment, uRL.fragment)) {
            return false;
        }
        return this.defaultPort == uRL.defaultPort;
    }

    public /* synthetic */ URL(boolean isOpaque, String scheme, String subScheme, String userInfo, String host, String path2, String query, String fragment2, int defaultPort, DefaultConstructorMarker $constructor_marker) {
        this(isOpaque, scheme, subScheme, userInfo, host, path2, query, fragment2, defaultPort);
    }

    static {
        schemeRegex = new Regex("^([a-zA-Z0-9+.-]+)(?::([a-zA-Z]+))?:");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\nJ\"\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJl\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u0018\u001a\u00020\n2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u001b\u001a\u00020\u000f2\b\b\u0002\u0010\u001c\u001a\u00020\u0004J\u0011\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\nH\u0086\u0002Jc\u0010\u001d\u001a\u00020\u00142\b\u0010\u0011\u001a\u0004\u0018\u00010\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0018\u001a\u00020\n2\b\u0010\u0019\u001a\u0004\u0018\u00010\n2\b\u0010\u001a\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u001b\u001a\u00020\u000f2\b\b\u0002\u0010\u001c\u001a\u00020\u00042\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\nH\u0087\u0002J\u000e\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\nJ\u0016\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\nJ\u0018\u0010#\u001a\u0004\u0018\u00010\n2\u0006\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\nR\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lkorlibs/io/net/URL$Companion;", "", "()V", "DEFAULT_PORT", "", "getDEFAULT_PORT", "()I", "schemeRegex", "Lkotlin/text/Regex;", "decodeComponent", "", "s", "charset", "Lkorlibs/io/lang/Charset;", "formUrlEncoded", "", "defaultPortForScheme", "scheme", "encodeComponent", "fromComponents", "Lkorlibs/io/net/URL;", "subScheme", "userInfo", "host", "path", "query", "fragment", "opaque", "port", "invoke", "url", "isAbsolute", "resolve", "base", "access", "resolveOrNull", "korge-core"})
    @SourceDebugExtension(value={"SMAP\nURL.kt\nKotlin\n*S Kotlin\n*F\n+ 1 URL.kt\nkorlibs/io/net/URL$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ByteArrayBuilder.kt\nkorlibs/memory/ByteArrayBuilder\n*L\n1#1,273:1\n1#2:274\n59#3,2:275\n59#3,2:277\n59#3,2:279\n59#3,2:281\n*S KotlinDebug\n*F\n+ 1 URL.kt\nkorlibs/io/net/URL$Companion\n*L\n225#1:275,2\n229#1:277,2\n231#1:279,2\n233#1:281,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final int getDEFAULT_PORT() {
            return DEFAULT_PORT;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final int defaultPortForScheme(@Nullable String scheme) {
            String string = scheme;
            if (string == null) return -1;
            int n = -1;
            switch (string.hashCode()) {
                case 3153745: {
                    if (string.equals("ftps")) {
                        n = 1;
                    }
                    break;
                }
                case 101730: {
                    if (string.equals("ftp")) {
                        n = 2;
                    }
                    break;
                }
                case 118039: {
                    if (string.equals("wss")) {
                        n = 3;
                    }
                    break;
                }
                case 3213448: {
                    if (string.equals("http")) {
                        n = 4;
                    }
                    break;
                }
                case 99617003: {
                    if (string.equals("https")) {
                        n = 3;
                    }
                    break;
                }
                case 3804: {
                    if (string.equals("ws")) {
                        n = 4;
                    }
                    break;
                }
            }
            switch (n) {
                case 2: {
                    return 21;
                }
                case 1: {
                    return 990;
                }
                case 4: {
                    return 80;
                }
                case 3: {
                    return 443;
                }
                default: {
                    return -1;
                }
            }
        }

        @NotNull
        public final URL fromComponents(@Nullable String scheme, @Nullable String subScheme, @Nullable String userInfo, @Nullable String host, @NotNull String path2, @Nullable String query, @Nullable String fragment2, boolean opaque, int port) {
            String string;
            String string2;
            String string3 = scheme;
            if (string3 != null) {
                String string4 = string3.toLowerCase(Locale.ROOT);
                string2 = string4;
                Intrinsics.checkNotNullExpressionValue(string4, "toLowerCase(...)");
            } else {
                string2 = null;
            }
            String string5 = subScheme;
            if (string5 != null) {
                String string6 = string5.toLowerCase(Locale.ROOT);
                string = string6;
                Intrinsics.checkNotNullExpressionValue(string6, "toLowerCase(...)");
            } else {
                string = null;
            }
            return new URL(opaque, string2, string, userInfo, host, path2, query, fragment2, port, null);
        }

        public static /* synthetic */ URL fromComponents$default(Companion companion, String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = null;
            }
            if ((n2 & 2) != 0) {
                string2 = null;
            }
            if ((n2 & 4) != 0) {
                string3 = null;
            }
            if ((n2 & 8) != 0) {
                string4 = null;
            }
            if ((n2 & 0x10) != 0) {
                string5 = "";
            }
            if ((n2 & 0x20) != 0) {
                string6 = null;
            }
            if ((n2 & 0x40) != 0) {
                string7 = null;
            }
            if ((n2 & 0x80) != 0) {
                bl = false;
            }
            if ((n2 & 0x100) != 0) {
                n = companion.getDEFAULT_PORT();
            }
            return companion.fromComponents(string, string2, string3, string4, string5, string6, string7, bl, n);
        }

        @Deprecated(message="Use URL.fromComponents", replaceWith=@ReplaceWith(expression="URL.fromComponents(scheme, subScheme, userInfo, host, path, query, fragment, opaque)", imports={}))
        @NotNull
        public final URL invoke(@Nullable String scheme, @Nullable String userInfo, @Nullable String host, @NotNull String path2, @Nullable String query, @Nullable String fragment2, boolean opaque, int port, @Nullable String subScheme) {
            String string;
            String string2;
            String string3 = scheme;
            if (string3 != null) {
                String string4 = string3.toLowerCase(Locale.ROOT);
                string2 = string4;
                Intrinsics.checkNotNullExpressionValue(string4, "toLowerCase(...)");
            } else {
                string2 = null;
            }
            String string5 = string2;
            String string6 = subScheme;
            if (string6 != null) {
                String string7 = string6.toLowerCase(Locale.ROOT);
                string = string7;
                Intrinsics.checkNotNullExpressionValue(string7, "toLowerCase(...)");
            } else {
                string = null;
            }
            String string8 = string;
            return this.fromComponents(string5, string8, userInfo, host, path2, query, fragment2, opaque, port);
        }

        public static /* synthetic */ URL invoke$default(Companion companion, String string, String string2, String string3, String string4, String string5, String string6, boolean bl, int n, String string7, int n2, Object object) {
            if ((n2 & 0x40) != 0) {
                bl = false;
            }
            if ((n2 & 0x80) != 0) {
                n = companion.getDEFAULT_PORT();
            }
            if ((n2 & 0x100) != 0) {
                string7 = null;
            }
            return companion.invoke(string, string2, string3, string4, string5, string6, bl, n, string7);
        }

        @NotNull
        public final URL invoke(@NotNull String url) {
            URL uRL;
            StrReader r = new StrReader(url, null, 0, 6, null);
            String schemeColon = r.tryRegex(schemeRegex);
            if (schemeColon != null) {
                boolean isHierarchical = BaseStrReader.tryLit$default(r, "//", false, 2, null) != null;
                String nonScheme = r.readRemaining();
                String[] stringArray = new String[]{":"};
                List schemeParts = StringsKt.split$default((CharSequence)StringsKt.dropLast(schemeColon, 1), stringArray, false, 0, 6, null);
                String scheme = (String)schemeParts.get(0);
                String subScheme = (String)CollectionsKt.getOrNull(schemeParts, 1);
                String nonFragment = StringsKt.substringBefore$default(nonScheme, '#', null, 2, null);
                String fragment2 = korlibs.io.util.StringExtKt.substringAfterOrNull(nonScheme, '#');
                String nonQuery = StringsKt.substringBefore$default(nonFragment, '?', null, 2, null);
                String query = korlibs.io.util.StringExtKt.substringAfterOrNull(nonFragment, '?');
                String authority = StringsKt.substringBefore$default(nonQuery, '/', null, 2, null);
                String path2 = korlibs.io.util.StringExtKt.substringAfterOrNull(nonQuery, '/');
                String hostWithPort = StringsKt.substringAfter$default(authority, '@', null, 2, null);
                String userInfo = korlibs.io.util.StringExtKt.substringBeforeOrNull(authority, '@');
                String host = StringsKt.substringBefore$default(hostWithPort, ':', null, 2, null);
                String port = korlibs.io.util.StringExtKt.substringAfterOrNull(hostWithPort, ':');
                boolean bl = !isHierarchical;
                Object object = host;
                String it = object;
                boolean bl2 = false;
                String string = ((CharSequence)it).length() > 0 ? object : null;
                String string2 = path2;
                object = string2 != null ? "/" + string2 : "";
                Object object2 = port;
                int n = object2 != null && (object2 = StringsKt.toIntOrNull((String)object2)) != null ? ((Integer)object2).intValue() : this.getDEFAULT_PORT();
                uRL = this.fromComponents(scheme, subScheme, userInfo, string, (String)object, query, fragment2, bl, n);
            } else {
                String nonFragment = StringsKt.substringBefore$default(url, '#', null, 2, null);
                String fragment3 = korlibs.io.util.StringExtKt.substringAfterOrNull(url, '#');
                String path3 = StringsKt.substringBefore$default(nonFragment, '?', null, 2, null);
                String query = korlibs.io.util.StringExtKt.substringAfterOrNull(nonFragment, '?');
                uRL = korlibs.io.net.URL$Companion.fromComponents$default(this, null, null, null, null, path3, query, fragment3, false, 0, 256, null);
            }
            return uRL;
        }

        public final boolean isAbsolute(@NotNull String url) {
            return new StrReader(url, null, 0, 6, null).tryRegex(schemeRegex) != null;
        }

        @Nullable
        public final String resolveOrNull(@NotNull String base2, @NotNull String access2) {
            Object object;
            try {
                boolean bl = false;
                object = Result.constructor-impl(Companion.resolve(base2, access2));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl(ResultKt.createFailure(throwable));
            }
            return (String)(Result.isFailure-impl(object) ? null : object);
        }

        @NotNull
        public final String resolve(@NotNull String base2, @NotNull String access2) {
            String string;
            String refinedAccess;
            String string2 = refinedAccess = StringsKt.startsWith$default(access2, "//", false, 2, null) && StringsKt.contains$default((CharSequence)base2, ":", false, 2, null) ? StringsKt.substringBefore$default(base2, ":", null, 2, null) + ":" + access2 : access2;
            if (this.isAbsolute(refinedAccess)) {
                return refinedAccess;
            }
            if (StringsKt.isBlank(base2)) {
                throw new MalformedInputException("The base URL should not be empty, or the access URL must be absolute.");
            }
            if (!this.isAbsolute(base2)) {
                throw new MalformedInputException("At least one of the base URL or access URL must be absolute.");
            }
            if (((CharSequence)refinedAccess).length() == 0) {
                string = base2;
            } else if (StringsKt.startsWith$default(refinedAccess, "/", false, 2, null)) {
                string = URL.copy$default(Companion.invoke(base2), false, null, null, null, null, URLKt.normalizeUrl(refinedAccess), null, null, 0, 415, null).getFullUrl();
            } else {
                URL $this$resolve_u24lambda_u242 = Companion.invoke(base2);
                boolean bl = false;
                String refinedPath = StringsKt.startsWith$default(refinedAccess, "?", false, 2, null) || StringsKt.startsWith$default(refinedAccess, "#", false, 2, null) ? $this$resolve_u24lambda_u242.getPath() + refinedAccess : StringsKt.substringBeforeLast$default($this$resolve_u24lambda_u242.getPath(), '/', null, 2, null) + "/" + refinedAccess;
                char[] cArray = new char[]{'/'};
                string = URL.copy$default($this$resolve_u24lambda_u242, false, null, null, null, null, "/" + StringsKt.trimStart(URLKt.normalizeUrl(refinedPath), cArray), null, null, 0, 415, null).getFullUrl();
            }
            return string;
        }

        @NotNull
        public final String decodeComponent(@NotNull String s, @NotNull Charset charset, boolean formUrlEncoded) {
            ByteArrayBuilder bos = new ByteArrayBuilder(0, 1, null);
            int len = s.length();
            for (int n = 0; n < len; ++n) {
                ByteArrayBuilder this_$iv;
                boolean $i$f$append;
                byte v$iv;
                char c = s.charAt(n);
                char c2 = c;
                if (c2 == '%') {
                    ByteArrayBuilder byteArrayBuilder = bos;
                    v$iv = (byte)Integer.parseInt(StringExtKt.substr(s, n + 1, 2), CharsKt.checkRadix(16));
                    $i$f$append = false;
                    this_$iv.appendFast(v$iv);
                    n += 2;
                    continue;
                }
                if (c2 == '+') {
                    if (formUrlEncoded) {
                        this_$iv = bos;
                        v$iv = 32;
                        $i$f$append = false;
                        this_$iv.appendFast(v$iv);
                        continue;
                    }
                    this_$iv = bos;
                    v$iv = 43;
                    $i$f$append = false;
                    this_$iv.appendFast(v$iv);
                    continue;
                }
                this_$iv = bos;
                v$iv = (byte)c;
                $i$f$append = false;
                this_$iv.appendFast(v$iv);
            }
            return CharsetKt.toString$default(bos.toByteArray(), charset, 0, 0, 6, null);
        }

        public static /* synthetic */ String decodeComponent$default(Companion companion, String string, Charset charset, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                charset = UTF8Kt.getUTF8();
            }
            if ((n & 4) != 0) {
                bl = false;
            }
            return companion.decodeComponent(string, charset, bl);
        }

        @NotNull
        public final String encodeComponent(@NotNull String s, @NotNull Charset charset, boolean formUrlEncoded) {
            StringBuilder sb = new StringBuilder(s.length());
            for (byte c : CharsetKt.toByteArray$default(s, charset, 0, 0, 6, null)) {
                char cc = (char)c;
                char c2 = cc;
                if (c2 == ' ') {
                    if (formUrlEncoded) {
                        sb.append("+");
                        continue;
                    }
                    sb.append("%20");
                    continue;
                }
                boolean bl = (('a' <= c2 ? c2 < '{' : false) ? true : ('A' <= c2 ? c2 < '[' : false)) ? true : ('0' <= c2 ? c2 < ':' : false);
                if ((((bl ? true : c2 == '-') ? true : c2 == '_') ? true : c2 == '.') ? true : c2 == '*') {
                    sb.append(cc);
                    continue;
                }
                sb.append('%');
                for (int n = 1; -1 < n; --n) {
                    sb.append(Hex.INSTANCE.encodeCharUpper(c >>> n * 4 & 0xF));
                }
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            return string;
        }

        public static /* synthetic */ String encodeComponent$default(Companion companion, String string, Charset charset, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                charset = UTF8Kt.getUTF8();
            }
            if ((n & 4) != 0) {
                bl = false;
            }
            return companion.encodeComponent(string, charset, bl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

