/*
 * Decompiled with CFR 0.152.
 */
package korlibs.io.serialization.yaml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import korlibs.io.serialization.yaml.Yaml;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003%&'B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000e\u001a\u00020\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J \u0010\u0014\u001a\u0004\u0018\u00010\u00012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000e\u001a\u00020\u0005J6\u0010\u0019\u001a\u0004\u0018\u00010\u00012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u001b\u001a\u00020\bH\u0002J\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u000e\u001a\u00020\u0005J\f\u0010\u001d\u001a\u00020\b*\u00020\u0005H\u0002J\f\u0010\u001e\u001a\u00020\b*\u00020\u001fH\u0002J\u0018\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00130\u0012*\b\u0012\u0004\u0012\u00020\u00130\u0016H\u0002J\f\u0010!\u001a\u00020\u0005*\u00020\"H\u0002J\u0012\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012*\u00020\"H\u0002J\f\u0010#\u001a\u00020\u0005*\u00020\u0005H\u0002J\f\u0010$\u001a\u00020\u0005*\u00020\u0005H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006("}, d2={"Lkorlibs/io/serialization/yaml/Yaml;", "", "()V", "EMPTY_SET", "", "", "SET_COMMA_END_ARRAY", "TRACE", "", "invalidOp", "", "getInvalidOp", "()Ljava/lang/Void;", "decode", "str", "msg", "parseStr", "toks", "", "Lkorlibs/io/serialization/yaml/Yaml$Token;", "read", "s", "Lkorlibs/io/serialization/yaml/Yaml$ListReader;", "level", "", "readOrString", "delimiters", "supportNonSpaceSymbols", "tokenize", "isQuoted", "isWhitespaceFast", "", "readId", "readUntilLineEnd", "Lkorlibs/io/serialization/yaml/Yaml$StrReader;", "unescape", "unquote", "ListReader", "StrReader", "Token", "korlibs-serialization-yaml"})
public final class Yaml {
    @NotNull
    public static final Yaml INSTANCE = new Yaml();
    public static final boolean TRACE = false;
    @NotNull
    private static final Set<String> EMPTY_SET = SetsKt.emptySet();
    @NotNull
    private static final Set<String> SET_COMMA_END_ARRAY;

    private Yaml() {
    }

    @Nullable
    public final Object decode(@NotNull String str) {
        return this.read(new ListReader<Token>(this.tokenize(str), null, 2, null), 0);
    }

    @Nullable
    public final Object read(@NotNull String str) {
        return this.read(new ListReader<Token>(this.tokenize(str), null, 2, null), 0);
    }

    private final Object parseStr(List<? extends Token> toks) {
        if (toks.size() == 1 && toks.get(0) instanceof Token.STR) {
            return toks.get(0).getUstr();
        }
        return this.parseStr(CollectionsKt.joinToString$default(toks, "", null, null, 0, null, parseStr.1.INSTANCE, 30, null));
    }

    private final Object parseStr(String str) {
        Object object;
        switch (str) {
            case "null": {
                object = null;
                break;
            }
            case "true": {
                object = true;
                break;
            }
            case "false": {
                object = false;
                break;
            }
            default: {
                object = StringsKt.toIntOrNull(str);
                if (object != null || (object = StringsKt.toDoubleOrNull(str)) != null) break;
                object = str;
            }
        }
        return object;
    }

    private final Object read(ListReader<Token> s, int level) {
        ArrayList<Object> arrayList;
        ListReader<Token> $this$read_u24lambda_u240 = s;
        boolean bl = false;
        ArrayList<Object> list2 = null;
        Object map2 = null;
        Object lastMapKey = null;
        Object lastMapValue = null;
        String levelStr = "";
        while (s.getHasMore()) {
            Token next;
            Object key;
            Token sp;
            Token.LINE line2;
            Token token2 = s.peek();
            Token.LINE lINE = line2 = token2 instanceof Token.LINE ? (Token.LINE)token2 : null;
            Integer lineLevel = lINE != null ? Integer.valueOf(lINE.getLevel()) : null;
            if (lineLevel != null && lineLevel > level) {
                Object res = INSTANCE.read(s, lineLevel);
                if (list2 != null) {
                    list2.add(res);
                    continue;
                }
                return res;
            }
            if (lineLevel != null && lineLevel < level) {
                break;
            }
            if (line2 != null) {
                s.read();
            }
            if (s.getEof()) break;
            Token item2 = s.peek();
            String string = item2.getStr();
            if (Intrinsics.areEqual(string, "-")) {
                if (!Intrinsics.areEqual(s.read().getStr(), "-")) {
                    INSTANCE.getInvalidOp();
                    throw new KotlinNothingValueException();
                }
                if (list2 == null) {
                    list2 = new ArrayList<Object>();
                    if (map2 != null && lastMapKey != null && lastMapValue == null) {
                        map2.put(lastMapKey, list2);
                    }
                }
                Object res = INSTANCE.read(s, level + 1);
                list2.add(res);
                continue;
            }
            if (Intrinsics.areEqual(string, "[")) {
                if (!Intrinsics.areEqual(s.read().getStr(), "[")) {
                    INSTANCE.getInvalidOp();
                    throw new KotlinNothingValueException();
                }
                ArrayList olist = new ArrayList();
                while (!Intrinsics.areEqual(s.peek().getStr(), "]")) {
                    String p;
                    ((Collection)olist).add(INSTANCE.readOrString(s, level, SET_COMMA_END_ARRAY, false));
                    String string2 = p = s.peek().getStr();
                    if (Intrinsics.areEqual(string2, ",")) {
                        s.read();
                        continue;
                    }
                    if (Intrinsics.areEqual(string2, "]")) break;
                    INSTANCE.invalidOp("Unexpected '" + p + "'");
                    throw new KotlinNothingValueException();
                }
                if (!Intrinsics.areEqual(s.read().getStr(), "]")) {
                    INSTANCE.getInvalidOp();
                    throw new KotlinNothingValueException();
                }
                return olist;
            }
            List<Token> keyIds = INSTANCE.readId(s);
            Token token3 = s.peekOrNull();
            if (token3 == null) {
                token3 = sp = (Token)Token.EOF.INSTANCE;
            }
            if (s.getEof() || !Intrinsics.areEqual(sp.getStr(), ":") || sp instanceof Token.SYMBOL && !((Token.SYMBOL)sp).isNextWhite()) {
                key = INSTANCE.parseStr(keyIds);
                return key;
            }
            key = String.valueOf(INSTANCE.parseStr(keyIds));
            if (map2 == null) {
                map2 = new LinkedHashMap();
            }
            if (!Intrinsics.areEqual(s.read().getStr(), ":")) {
                INSTANCE.getInvalidOp();
                throw new KotlinNothingValueException();
            }
            Token token4 = next = s.peekOrNull();
            String nextStr = token4 != null ? token4.getStr() : null;
            boolean hasSpaces = next instanceof Token.SYMBOL && ((Token.SYMBOL)next).isNextWhite();
            boolean nextIsSpecialSymbol = Intrinsics.areEqual(nextStr, "[") || Intrinsics.areEqual(nextStr, "{") || Intrinsics.areEqual(nextStr, "-") && hasSpaces;
            Object value = INSTANCE.readOrString(s, level, EMPTY_SET, !nextIsSpecialSymbol);
            lastMapKey = key;
            lastMapValue = value;
            map2.put(key, value);
            list2 = null;
        }
        if ((arrayList = map2) == null) {
            arrayList = list2;
        }
        return arrayList;
    }

    private final List<Token> readId(ListReader<Token> $this$readId) {
        Token token2;
        ArrayList<Token> tokens2 = new ArrayList<Token>();
        while ($this$readId.getHasMore() && ((token2 = $this$readId.peek()) instanceof Token.ID || token2 instanceof Token.STR || token2 instanceof Token.SYMBOL && Intrinsics.areEqual(token2.getStr(), "-") || token2 instanceof Token.SYMBOL && Intrinsics.areEqual(token2.getStr(), ":") && !((Token.SYMBOL)token2).isNextWhite())) {
            tokens2.add(token2);
            $this$readId.read();
        }
        return tokens2;
    }

    private final Object readOrString(ListReader<Token> s, int level, Set<String> delimiters, boolean supportNonSpaceSymbols) {
        Object object;
        Token sp = s.peek();
        if (sp instanceof Token.ID || supportNonSpaceSymbols && sp instanceof Token.SYMBOL && !((Token.SYMBOL)sp).isNextWhite()) {
            Token p;
            Object str = "";
            while (s.getHasMore() && !((p = s.peek()) instanceof Token.LINE) && !delimiters.contains(p.getStr())) {
                str = (String)str + s.read().getStr();
            }
            object = this.parseStr((String)str);
        } else {
            object = this.read(s, level + 1);
        }
        return object;
    }

    @NotNull
    public final List<Token> tokenize(@NotNull String str) {
        return this.tokenize(new StrReader(StringsKt.replace$default(str, "\r\n", "\n", false, 4, null), 0, 2, null));
    }

    private final List<Token> tokenize(StrReader $this$tokenize) {
        ArrayList<Token> out = new ArrayList<Token>();
        StrReader s = $this$tokenize;
        Ref.ObjectRef<String> str = new Ref.ObjectRef<String>();
        str.element = "";
        ArrayList indents = new ArrayList();
        block0: while ($this$tokenize.getHasMore()) {
            Yaml.tokenize$flush(str, out);
            String indentStr2 = StringsKt.replace$default($this$tokenize.readWhile(tokenize.indentStr.1.INSTANCE), "\t", "     ", false, 4, null);
            if (StringsKt.contains$default((CharSequence)indentStr2, '\n', false, 2, null)) continue;
            int indent = indentStr2.length();
            if (indents.isEmpty() || indent > ((Number)CollectionsKt.last(indents)).intValue()) {
                Integer n = indent;
                ((Collection)indents).add(n);
            } else {
                while (!((Collection)indents).isEmpty() && indent < ((Number)CollectionsKt.last(indents)).intValue()) {
                    indents.remove(indents.size() - 1);
                }
                if (indents.isEmpty()) {
                    this.getInvalidOp();
                    throw new KotlinNothingValueException();
                }
            }
            int indentLevel = indents.size() - 1;
            while (!((Collection)out).isEmpty() && CollectionsKt.last((List)out) instanceof Token.LINE) {
                out.remove(out.size() - 1);
            }
            ((Collection)out).add(new Token.LINE(indentStr2, indentLevel));
            while ($this$tokenize.getHasMore()) {
                char c = $this$tokenize.read();
                char c2 = c;
                if ((((c2 == ':' ? true : c2 == '-') ? true : c2 == '[') ? true : c2 == ']') ? true : c2 == ',') {
                    Yaml.tokenize$flush(str, out);
                    ((Collection)out).add(new Token.SYMBOL(String.valueOf(c), $this$tokenize.peekChar()));
                    continue;
                }
                if (c2 == '#') {
                    Character c3 = StringsKt.lastOrNull((CharSequence)str.element);
                    boolean bl = c3 != null ? this.isWhitespaceFast(c3.charValue()) : false;
                    if (bl || Intrinsics.areEqual(str.element, "") && CollectionsKt.lastOrNull((List)out) instanceof Token.LINE) {
                        Yaml.tokenize$flush(str, out);
                        this.readUntilLineEnd($this$tokenize);
                        $this$tokenize.skip();
                        continue block0;
                    }
                    str.element = "" + str.element + c;
                    continue;
                }
                if (c2 == '\n') {
                    Yaml.tokenize$flush(str, out);
                    continue block0;
                }
                if (c2 == '\"' ? true : c2 == '\'') {
                    Yaml.tokenize$flush(str, out);
                    Token last2 = (Token)CollectionsKt.lastOrNull((List)out);
                    if (last2 instanceof Token.SYMBOL && (Intrinsics.areEqual(((Token.SYMBOL)last2).getStr(), ":") || Intrinsics.areEqual(((Token.SYMBOL)last2).getStr(), "[") || Intrinsics.areEqual(((Token.SYMBOL)last2).getStr(), "{") || Intrinsics.areEqual(((Token.SYMBOL)last2).getStr(), ",") || Intrinsics.areEqual(((Token.SYMBOL)last2).getStr(), "-"))) {
                        s.unread();
                        ((Collection)out).add(new Token.STR(StrReader.readStringLit$default(s, false, 1, null)));
                        continue;
                    }
                    str.element = "" + str.element + c;
                    continue;
                }
                str.element = "" + str.element + c;
            }
        }
        Yaml.tokenize$flush(str, out);
        return out;
    }

    private final String readUntilLineEnd(StrReader $this$readUntilLineEnd) {
        return $this$readUntilLineEnd.readUntil(readUntilLineEnd.1.INSTANCE);
    }

    private final Void getInvalidOp() {
        throw new RuntimeException();
    }

    private final Void invalidOp(String msg) {
        throw new RuntimeException(msg);
    }

    private final boolean isWhitespaceFast(char $this$isWhitespaceFast) {
        return $this$isWhitespaceFast == ' ' || $this$isWhitespaceFast == '\t' || $this$isWhitespaceFast == '\r' || $this$isWhitespaceFast == '\n';
    }

    private final boolean isQuoted(String $this$isQuoted) {
        return StringsKt.startsWith$default((CharSequence)$this$isQuoted, '\"', false, 2, null) && StringsKt.endsWith$default((CharSequence)$this$isQuoted, '\"', false, 2, null);
    }

    private final String unquote(String $this$unquote) {
        String string;
        if (this.isQuoted($this$unquote)) {
            String string2 = $this$unquote.substring(1, $this$unquote.length() - 1);
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            string = this.unescape(string2);
        } else {
            string = $this$unquote;
        }
        return string;
    }

    private final String unescape(String $this$unescape) {
        StringBuilder out = new StringBuilder($this$unescape.length());
        int n = 0;
        while (n < $this$unescape.length()) {
            char c;
            if ((c = $this$unescape.charAt(n++)) == '\\') {
                char c2;
                char c3;
                if ((c3 = (c2 = $this$unescape.charAt(n++))) == '\\') {
                    out.append('\\');
                    continue;
                }
                if (c3 == '\"') {
                    out.append('\"');
                    continue;
                }
                if (c3 == 'n') {
                    out.append('\n');
                    continue;
                }
                if (c3 == 'r') {
                    out.append('\r');
                    continue;
                }
                if (c3 == 't') {
                    out.append('\t');
                    continue;
                }
                if (c3 == 'x' ? true : c3 == 'u') {
                    String chars;
                    int N = c2 == 'u' ? 4 : 2;
                    Intrinsics.checkNotNullExpressionValue($this$unescape.substring(n, n + N), "substring(...)");
                    n += N;
                    out.append((char)Integer.parseInt(chars, CharsKt.checkRadix(16)));
                    continue;
                }
                out.append("\\" + c2);
                continue;
            }
            out.append(c);
        }
        String string = out.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    private static final void tokenize$flush(Ref.ObjectRef<String> str, ArrayList<Token> out) {
        if (!StringsKt.isBlank((CharSequence)str.element) && ((CharSequence)str.element).length() > 0) {
            ((Collection)out).add(new Token.ID(((Object)StringsKt.trim((CharSequence)((String)str.element))).toString()));
            str.element = "";
        }
    }

    static {
        String[] stringArray = new String[]{",", "]"};
        SET_COMMA_END_ARRAY = SetsKt.setOf(stringArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u001fB\u001f\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u0018\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\bJ\r\u0010\u0019\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\bJ\u000b\u0010\u001a\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u001c\u001a\u00020\u0013J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u0015\u0010\u0005\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006 "}, d2={"Lkorlibs/io/serialization/yaml/Yaml$ListReader;", "T", "", "list", "", "ctx", "(Ljava/util/List;Ljava/lang/Object;)V", "getCtx", "()Ljava/lang/Object;", "Ljava/lang/Object;", "eof", "", "getEof", "()Z", "hasMore", "getHasMore", "getList", "()Ljava/util/List;", "position", "", "getPosition", "()I", "setPosition", "(I)V", "peek", "peekOrNull", "read", "skip", "count", "toString", "", "OutOfBoundsException", "korlibs-serialization-yaml"})
    @SourceDebugExtension(value={"SMAP\nYaml.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Yaml.kt\nkorlibs/io/serialization/yaml/Yaml$ListReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,364:1\n1#2:365\n*E\n"})
    private static final class ListReader<T> {
        @NotNull
        private final List<T> list;
        @Nullable
        private final T ctx;
        private int position;

        public ListReader(@NotNull List<? extends T> list2, @Nullable T ctx) {
            this.list = list2;
            this.ctx = ctx;
        }

        public /* synthetic */ ListReader(List list2, Object object, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                object = null;
            }
            this(list2, object);
        }

        @NotNull
        public final List<T> getList() {
            return this.list;
        }

        @Nullable
        public final T getCtx() {
            return this.ctx;
        }

        public final int getPosition() {
            return this.position;
        }

        public final void setPosition(int n) {
            this.position = n;
        }

        public final boolean getEof() {
            return this.position >= this.list.size();
        }

        public final boolean getHasMore() {
            return this.position < this.list.size();
        }

        @Nullable
        public final T peekOrNull() {
            return CollectionsKt.getOrNull(this.list, this.position);
        }

        public final T peek() {
            T t = CollectionsKt.getOrNull(this.list, this.position);
            if (t == null) {
                throw new OutOfBoundsException(this, this.position);
            }
            return t;
        }

        @NotNull
        public final ListReader<T> skip(int count2) {
            ListReader listReader;
            ListReader $this$skip_u24lambda_u240 = listReader = this;
            boolean bl = false;
            $this$skip_u24lambda_u240.position += count2;
            return listReader;
        }

        public static /* synthetic */ ListReader skip$default(ListReader listReader, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 1;
            }
            return listReader.skip(n);
        }

        public final T read() {
            T t;
            T $this$read_u24lambda_u241 = t = this.peek();
            boolean bl = false;
            this.skip(1);
            return t;
        }

        @NotNull
        public String toString() {
            return "ListReader(" + this.list + ")";
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0019\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0015\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lkorlibs/io/serialization/yaml/Yaml$ListReader$OutOfBoundsException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "list", "Lkorlibs/io/serialization/yaml/Yaml$ListReader;", "pos", "", "(Lkorlibs/io/serialization/yaml/Yaml$ListReader;I)V", "getList", "()Lkorlibs/io/serialization/yaml/Yaml$ListReader;", "getPos", "()I", "korlibs-serialization-yaml"})
        public static final class OutOfBoundsException
        extends RuntimeException {
            @NotNull
            private final ListReader<?> list;
            private final int pos;

            public OutOfBoundsException(@NotNull ListReader<?> list2, int pos) {
                this.list = list2;
                this.pos = pos;
            }

            @NotNull
            public final ListReader<?> getList() {
                return this.list;
            }

            public final int getPos() {
                return this.pos;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\f\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0005J\u0006\u0010\u0016\u001a\u00020\u0014J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J\u0006\u0010\u0018\u001a\u00020\u0014J\u000e\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0005J\u0017\u0010\u0019\u001a\u00020\u00032\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0082\bJ\u0010\u0010\u001d\u001a\u00020\u00032\b\b\u0002\u0010\u001e\u001a\u00020\bJ\u001a\u0010\u001f\u001a\u00020\u00032\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\b0!J\u001a\u0010\"\u001a\u00020\u00032\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\b0!J\u0006\u0010#\u001a\u00020\u0000J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0005J\u001a\u0010$\u001a\u00020\u001c2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\b0!J\u001d\u0010%\u001a\u00020\u001c2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\b0!H\u0086\bJ\u0018\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u00052\b\b\u0002\u0010(\u001a\u00020\u0005J\b\u0010)\u001a\u00020\u0003H\u0016J\u0006\u0010*\u001a\u00020\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\r\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006+"}, d2={"Lkorlibs/io/serialization/yaml/Yaml$StrReader;", "", "str", "", "pos", "", "(Ljava/lang/String;I)V", "hasMore", "", "getHasMore", "()Z", "length", "getLength", "()I", "getPos", "setPos", "(I)V", "getStr", "()Ljava/lang/String;", "peek", "", "count", "peekChar", "posSkip", "read", "readBlock", "callback", "Lkotlin/Function0;", "", "readStringLit", "reportErrors", "readUntil", "f", "Lkotlin/Function1;", "readWhile", "skip", "skipUntil", "skipWhile", "substr", "start", "len", "toString", "unread", "korlibs-serialization-yaml"})
    @SourceDebugExtension(value={"SMAP\nYaml.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Yaml.kt\nkorlibs/io/serialization/yaml/Yaml$StrReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,364:1\n258#1:365\n285#1,2:367\n258#1:369\n287#1,2:370\n285#1,4:372\n1#2:366\n*S KotlinDebug\n*F\n+ 1 Yaml.kt\nkorlibs/io/serialization/yaml/Yaml$StrReader\n*L\n259#1:365\n291#1:367,2\n291#1:369\n291#1:370,2\n292#1:372,4\n*E\n"})
    private static final class StrReader {
        @NotNull
        private final String str;
        private int pos;

        public StrReader(@NotNull String str, int pos) {
            this.str = str;
            this.pos = pos;
        }

        public /* synthetic */ StrReader(String string, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            this(string, n);
        }

        @NotNull
        public final String getStr() {
            return this.str;
        }

        public final int getPos() {
            return this.pos;
        }

        public final void setPos(int n) {
            this.pos = n;
        }

        public final int getLength() {
            return this.str.length();
        }

        public final boolean getHasMore() {
            return this.pos < this.getLength();
        }

        public final void skipWhile(@NotNull Function1<? super Character, Boolean> f) {
            boolean $i$f$skipWhile = false;
            while (this.getHasMore() && f.invoke(Character.valueOf(this.peek())).booleanValue()) {
                this.skip();
            }
        }

        public final void skipUntil(@NotNull Function1<? super Character, Boolean> f) {
            StrReader this_$iv = this;
            boolean $i$f$skipWhile = false;
            while (this_$iv.getHasMore()) {
                char it = this_$iv.peek();
                boolean bl = false;
                if (!(f.invoke(Character.valueOf(it)) == false)) break;
                this_$iv.skip();
            }
        }

        private final int posSkip(int count2) {
            int out = this.pos;
            this.pos += count2;
            return out;
        }

        @NotNull
        public final StrReader skip() {
            return this.skip(1);
        }

        public final char peek() {
            return this.getHasMore() ? this.str.charAt(this.pos) : (char)'\u0000';
        }

        public final char peekChar() {
            return this.peek();
        }

        public final char read() {
            return this.getHasMore() ? this.str.charAt(this.posSkip(1)) : (char)'\u0000';
        }

        @NotNull
        public final StrReader unread() {
            return this.skip(-1);
        }

        @NotNull
        public final String substr(int start2, int len) {
            int start3 = RangesKt.coerceIn(start2, 0, this.getLength());
            int end2 = RangesKt.coerceIn(start3 + len, 0, this.getLength());
            String string = this.str.substring(start3, end2);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            return string;
        }

        public static /* synthetic */ String substr$default(StrReader strReader, int n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n2 = strReader.getLength() - strReader.pos;
            }
            return strReader.substr(n, n2);
        }

        @NotNull
        public final StrReader skip(int count2) {
            StrReader strReader;
            StrReader $this$skip_u24lambda_u241 = strReader = this;
            boolean bl = false;
            $this$skip_u24lambda_u241.pos += count2;
            return strReader;
        }

        @NotNull
        public final String peek(int count2) {
            return this.substr(this.pos, count2);
        }

        @NotNull
        public final String read(int count2) {
            String string;
            String it = string = this.peek(count2);
            boolean bl = false;
            this.skip(count2);
            return string;
        }

        private final String readBlock(Function0<Unit> callback) {
            boolean $i$f$readBlock = false;
            int start2 = this.pos;
            callback.invoke();
            int end2 = this.pos;
            return this.substr(start2, end2 - start2);
        }

        @NotNull
        public final String readWhile(@NotNull Function1<? super Character, Boolean> f) {
            StrReader this_$iv = this;
            boolean $i$f$readBlock = false;
            int start$iv = this_$iv.pos;
            boolean bl = false;
            StrReader this_$iv2 = this;
            boolean $i$f$skipWhile = false;
            while (this_$iv2.getHasMore() && f.invoke(Character.valueOf(this_$iv2.peek())).booleanValue()) {
                this_$iv2.skip();
            }
            int end$iv = this_$iv.pos;
            return this_$iv.substr(start$iv, end$iv - start$iv);
        }

        @NotNull
        public final String readUntil(@NotNull Function1<? super Character, Boolean> f) {
            StrReader this_$iv = this;
            boolean $i$f$readBlock = false;
            int start$iv = this_$iv.pos;
            boolean bl = false;
            this.skipUntil(f);
            int end$iv = this_$iv.pos;
            return this_$iv.substr(start$iv, end$iv - start$iv);
        }

        @NotNull
        public final String readStringLit(boolean reportErrors) {
            StringBuilder out = new StringBuilder();
            char quotec = this.read();
            char c = quotec;
            if (!(c == '\"' ? true : c == '\'')) {
                throw new RuntimeException("Invalid string literal");
            }
            boolean closed = false;
            while (this.getHasMore()) {
                char c2 = this.read();
                if (c2 == '\\') {
                    char c3;
                    char cc = this.read();
                    char c4 = cc;
                    if (c4 == '\\') {
                        c3 = 92;
                    } else if (c4 == '/') {
                        c3 = 47;
                    } else if (c4 == '\'') {
                        c3 = 39;
                    } else if (c4 == '\"') {
                        c3 = 34;
                    } else if (c4 == 'b') {
                        c3 = 8;
                    } else if (c4 == 'f') {
                        c3 = 12;
                    } else if (c4 == 'n') {
                        c3 = 10;
                    } else if (c4 == 'r') {
                        c3 = 13;
                    } else if (c4 == 't') {
                        c3 = 9;
                    } else if (c4 == 'u') {
                        c3 = (char)Integer.parseInt(this.read(4), CharsKt.checkRadix(16));
                    } else {
                        throw new RuntimeException("Invalid char '" + cc + "'");
                    }
                    out.append(c3);
                    continue;
                }
                if (c2 == quotec) {
                    closed = true;
                    break;
                }
                out.append(c2);
            }
            if (!closed && reportErrors) {
                throw new RuntimeException("String literal not closed! '" + this.str + "'");
            }
            String string = out.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            return string;
        }

        public static /* synthetic */ String readStringLit$default(StrReader strReader, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = true;
            }
            return strReader.readStringLit(bl);
        }

        @NotNull
        public String toString() {
            int n = this.str.length();
            String string = this.str.substring(RangesKt.coerceIn(this.pos, StringsKt.getIndices(this.str)), RangesKt.coerceIn(this.pos + 10, StringsKt.getIndices(this.str)));
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            return "StrReader(str=" + n + ", pos=" + this.pos + ", range='" + StringsKt.replace$default(string, "\n", "\\n", false, 4, null) + "')";
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\bf\u0018\u00002\u00020\u0001:\u0005\b\t\n\u000b\fR\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005\u00a8\u0006\r"}, d2={"Lkorlibs/io/serialization/yaml/Yaml$Token;", "", "str", "", "getStr", "()Ljava/lang/String;", "ustr", "getUstr", "EOF", "ID", "LINE", "STR", "SYMBOL", "korlibs-serialization-yaml"})
    public static interface Token {
        @NotNull
        public String getStr();

        @NotNull
        public String getUstr();

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            @NotNull
            public static String getUstr(@NotNull Token $this) {
                return $this.getStr();
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lkorlibs/io/serialization/yaml/Yaml$Token$EOF;", "Lkorlibs/io/serialization/yaml/Yaml$Token;", "()V", "str", "", "getStr", "()Ljava/lang/String;", "korlibs-serialization-yaml"})
        public static final class EOF
        implements Token {
            @NotNull
            public static final EOF INSTANCE = new EOF();
            @NotNull
            private static final String str = "";

            private EOF() {
            }

            @Override
            @NotNull
            public String getStr() {
                return str;
            }

            @Override
            @NotNull
            public String getUstr() {
                return DefaultImpls.getUstr(this);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lkorlibs/io/serialization/yaml/Yaml$Token$ID;", "Lkorlibs/io/serialization/yaml/Yaml$Token;", "str", "", "(Ljava/lang/String;)V", "getStr", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "korlibs-serialization-yaml"})
        public static final class ID
        implements Token {
            @NotNull
            private final String str;

            public ID(@NotNull String str) {
                this.str = str;
            }

            @Override
            @NotNull
            public String getStr() {
                return this.str;
            }

            @Override
            @NotNull
            public String getUstr() {
                return DefaultImpls.getUstr(this);
            }

            @NotNull
            public final String component1() {
                return this.str;
            }

            @NotNull
            public final ID copy(@NotNull String str) {
                return new ID(str);
            }

            public static /* synthetic */ ID copy$default(ID iD, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = iD.str;
                }
                return iD.copy(string);
            }

            @NotNull
            public String toString() {
                return "ID(str=" + this.str + ")";
            }

            public int hashCode() {
                return this.str.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ID)) {
                    return false;
                }
                ID iD = (ID)other;
                return Intrinsics.areEqual(this.str, iD.str);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00d6\u0001J\b\u0010\u0013\u001a\u00020\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lkorlibs/io/serialization/yaml/Yaml$Token$LINE;", "Lkorlibs/io/serialization/yaml/Yaml$Token;", "str", "", "level", "", "(Ljava/lang/String;I)V", "getLevel", "()I", "getStr", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "korlibs-serialization-yaml"})
        public static final class LINE
        implements Token {
            @NotNull
            private final String str;
            private final int level;

            public LINE(@NotNull String str, int level) {
                this.str = str;
                this.level = level;
            }

            @Override
            @NotNull
            public String getStr() {
                return this.str;
            }

            public final int getLevel() {
                return this.level;
            }

            @NotNull
            public String toString() {
                return "LINE(" + this.level + ")";
            }

            @Override
            @NotNull
            public String getUstr() {
                return DefaultImpls.getUstr(this);
            }

            @NotNull
            public final String component1() {
                return this.str;
            }

            public final int component2() {
                return this.level;
            }

            @NotNull
            public final LINE copy(@NotNull String str, int level) {
                return new LINE(str, level);
            }

            public static /* synthetic */ LINE copy$default(LINE lINE, String string, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    string = lINE.str;
                }
                if ((n2 & 2) != 0) {
                    n = lINE.level;
                }
                return lINE.copy(string, n);
            }

            public int hashCode() {
                int result2 = this.str.hashCode();
                result2 = result2 * 31 + Integer.hashCode(this.level);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof LINE)) {
                    return false;
                }
                LINE lINE = (LINE)other;
                if (!Intrinsics.areEqual(this.str, lINE.str)) {
                    return false;
                }
                return this.level == lINE.level;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lkorlibs/io/serialization/yaml/Yaml$Token$STR;", "Lkorlibs/io/serialization/yaml/Yaml$Token;", "str", "", "(Ljava/lang/String;)V", "getStr", "()Ljava/lang/String;", "ustr", "getUstr", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "korlibs-serialization-yaml"})
        public static final class STR
        implements Token {
            @NotNull
            private final String str;
            @NotNull
            private final String ustr;

            public STR(@NotNull String str) {
                this.str = str;
                this.ustr = INSTANCE.unquote(this.getStr());
            }

            @Override
            @NotNull
            public String getStr() {
                return this.str;
            }

            @Override
            @NotNull
            public String getUstr() {
                return this.ustr;
            }

            @NotNull
            public final String component1() {
                return this.str;
            }

            @NotNull
            public final STR copy(@NotNull String str) {
                return new STR(str);
            }

            public static /* synthetic */ STR copy$default(STR sTR, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = sTR.str;
                }
                return sTR.copy(string);
            }

            @NotNull
            public String toString() {
                return "STR(str=" + this.str + ")";
            }

            public int hashCode() {
                return this.str.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof STR)) {
                    return false;
                }
                STR sTR = (STR)other;
                return Intrinsics.areEqual(this.str, sTR.str);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lkorlibs/io/serialization/yaml/Yaml$Token$SYMBOL;", "Lkorlibs/io/serialization/yaml/Yaml$Token;", "str", "", "next", "", "(Ljava/lang/String;C)V", "isNextWhite", "", "()Z", "getNext", "()C", "getStr", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "toString", "korlibs-serialization-yaml"})
        public static final class SYMBOL
        implements Token {
            @NotNull
            private final String str;
            private final char next;

            public SYMBOL(@NotNull String str, char next) {
                this.str = str;
                this.next = next;
            }

            @Override
            @NotNull
            public String getStr() {
                return this.str;
            }

            public final char getNext() {
                return this.next;
            }

            public final boolean isNextWhite() {
                return this.next == ' ' || this.next == '\t' || this.next == '\n' || this.next == '\r';
            }

            @Override
            @NotNull
            public String getUstr() {
                return DefaultImpls.getUstr(this);
            }

            @NotNull
            public final String component1() {
                return this.str;
            }

            public final char component2() {
                return this.next;
            }

            @NotNull
            public final SYMBOL copy(@NotNull String str, char next) {
                return new SYMBOL(str, next);
            }

            public static /* synthetic */ SYMBOL copy$default(SYMBOL sYMBOL, String string, char c, int n, Object object) {
                if ((n & 1) != 0) {
                    string = sYMBOL.str;
                }
                if ((n & 2) != 0) {
                    c = sYMBOL.next;
                }
                return sYMBOL.copy(string, c);
            }

            @NotNull
            public String toString() {
                return "SYMBOL(str=" + this.str + ", next=" + this.next + ")";
            }

            public int hashCode() {
                int result2 = this.str.hashCode();
                result2 = result2 * 31 + Character.hashCode(this.next);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof SYMBOL)) {
                    return false;
                }
                SYMBOL sYMBOL = (SYMBOL)other;
                if (!Intrinsics.areEqual(this.str, sYMBOL.str)) {
                    return false;
                }
                return this.next == sYMBOL.next;
            }
        }
    }
}

