/*
 * Decompiled with CFR 0.152.
 */
package korlibs.io.stream;

import korlibs.io.experimental.KorioExperimentalApi;
import korlibs.io.lang.ExceptionsKt;
import korlibs.memory.BitsKt;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u000e\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lkorlibs/io/stream/ByteArrayBitReader;", "", "data", "", "([B)V", "availableBits", "", "availableBytes", "getAvailableBytes", "()I", "currentBits", "getData", "()[B", "dataPos", "hasMoreBits", "", "getHasMoreBits", "()Z", "feedByte", "", "readIntBits", "nbits", "korge-core"})
@KorioExperimentalApi
public final class ByteArrayBitReader {
    @NotNull
    private final byte[] data;
    private int dataPos;
    private int currentBits;
    private int availableBits;

    public ByteArrayBitReader(@NotNull byte[] data2) {
        this.data = data2;
    }

    @NotNull
    public final byte[] getData() {
        return this.data;
    }

    private final int getAvailableBytes() {
        return this.data.length - this.dataPos;
    }

    public final boolean getHasMoreBits() {
        return this.availableBits > 0 || this.getAvailableBytes() > 0;
    }

    private final void feedByte() {
        this.currentBits <<= 8;
        int n = this.dataPos;
        this.dataPos = n + 1;
        this.currentBits |= this.data[n] & 0xFF;
        this.availableBits += 8;
    }

    public final int readIntBits(int nbits) {
        if (this.availableBits > 32) {
            ExceptionsKt.invalidOp("Too much bits to read");
            throw new KotlinNothingValueException();
        }
        while (this.availableBits < nbits && this.getAvailableBytes() > 0) {
            if (this.availableBits > 24) {
                throw new NotImplementedError(null, 1, null);
            }
            this.feedByte();
        }
        this.availableBits -= nbits;
        return BitsKt.extract(this.currentBits, this.availableBits, nbits);
    }
}

