/*
 * Decompiled with CFR 0.152.
 */
package korlibs.io.stream;

import korlibs.datastructure.ByteArrayDeque;
import korlibs.io.lang.Charset;
import korlibs.io.stream.CharReader;
import korlibs.io.stream.SyncInputStream;
import korlibs.io.stream.SyncStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0016\u001a\u00020\u0007H\u0002J\b\u0010\u0017\u001a\u00020\u0001H\u0016J\u001c\u0010\u0018\u001a\u00020\u00072\n\u0010\u0019\u001a\u00060\u0014j\u0002`\u00152\u0006\u0010\u001a\u001a\u00020\u0007H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lkorlibs/io/stream/CharReaderFromSyncStream;", "Lkorlibs/io/stream/CharReader;", "stream", "Lkorlibs/io/stream/SyncStream;", "charset", "Lkorlibs/io/lang/Charset;", "chunkSize", "", "(Lkorlibs/io/stream/SyncStream;Lkorlibs/io/lang/Charset;I)V", "buffer", "Lkorlibs/datastructure/ByteArrayDeque;", "getCharset", "()Lkorlibs/io/lang/Charset;", "getChunkSize", "()I", "getStream", "()Lkorlibs/io/stream/SyncStream;", "temp", "", "tempStringBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "bufferUp", "clone", "read", "out", "count", "Companion", "korge-core"})
@SourceDebugExtension(value={"SMAP\nCharReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CharReader.kt\nkorlibs/io/stream/CharReaderFromSyncStream\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,63:1\n1#2:64\n*E\n"})
public final class CharReaderFromSyncStream
implements CharReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SyncStream stream;
    @NotNull
    private final Charset charset;
    private final int chunkSize;
    @NotNull
    private final byte[] temp;
    @NotNull
    private final ByteArrayDeque buffer;
    @NotNull
    private StringBuilder tempStringBuilder;
    public static final int DEFAULT_CHUNK_SIZE = 1024;
    public static final int MIN_CHUNK_SIZE = 8;

    public CharReaderFromSyncStream(@NotNull SyncStream stream, @NotNull Charset charset, int chunkSize) {
        this.stream = stream;
        this.charset = charset;
        this.chunkSize = chunkSize;
        this.temp = new byte[this.chunkSize];
        this.buffer = new ByteArrayDeque(0, false, 3, null);
        this.tempStringBuilder = new StringBuilder();
        if (!(this.chunkSize >= 8)) {
            boolean bl = false;
            String string = "chunkSize must be greater than 8, was " + this.chunkSize;
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ CharReaderFromSyncStream(SyncStream syncStream, Charset charset, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 1024;
        }
        this(syncStream, charset, n);
    }

    @NotNull
    public final SyncStream getStream() {
        return this.stream;
    }

    @NotNull
    public final Charset getCharset() {
        return this.charset;
    }

    public final int getChunkSize() {
        return this.chunkSize;
    }

    @Override
    @NotNull
    public CharReader clone() {
        return new CharReaderFromSyncStream(this.stream.clone(), this.charset, this.chunkSize);
    }

    @Override
    public int read(@NotNull StringBuilder out, int count2) {
        this.bufferUp();
        while (this.tempStringBuilder.length() < count2) {
            int readCount = ByteArrayDeque.peek$default(this.buffer, this.temp, 0, 0, 6, null);
            int consumed = this.charset.decode(this.tempStringBuilder, this.temp, 0, readCount);
            if (consumed <= 0) {
                if (this.bufferUp() > 0) continue;
                break;
            }
            this.buffer.skip(consumed);
        }
        String slice = this.tempStringBuilder.substring(0, Math.min(count2, this.tempStringBuilder.length()));
        StringBuilder stringBuilder = new StringBuilder(slice.length()).append(this.tempStringBuilder.substring(slice.length()));
        Intrinsics.checkNotNullExpressionValue(stringBuilder, "append(...)");
        this.tempStringBuilder = stringBuilder;
        out.append(slice);
        return slice.length();
    }

    private final int bufferUp() {
        int readCount;
        int totalReadCount = 0;
        while (this.buffer.getAvailableRead() < this.temp.length && (readCount = SyncInputStream.DefaultImpls.read$default(this.stream, this.temp, 0, 0, 6, null)) > 0) {
            totalReadCount += readCount;
            this.buffer.write(this.temp, 0, readCount);
        }
        return totalReadCount;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lkorlibs/io/stream/CharReaderFromSyncStream$Companion;", "", "()V", "DEFAULT_CHUNK_SIZE", "", "MIN_CHUNK_SIZE", "korge-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

