/*
 * Decompiled with CFR 0.152.
 */
package korlibs.io.stream;

import korlibs.io.lang.ExceptionsKt;
import korlibs.io.stream.SyncStreamBase;
import korlibs.memory.ArraysKt;
import korlibs.memory.ByteArrayBuilder;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0010J\b\u0010\u0019\u001a\u00020\u0017H\u0016J(\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0003H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J(\u0010!\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0003H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u0007R$\u0010\f\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0004R$\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u00108V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\""}, d2={"Lkorlibs/io/stream/MemorySyncStreamBase;", "Lkorlibs/io/stream/SyncStreamBase;", "initialCapacity", "", "(I)V", "data", "Lkorlibs/memory/ByteArrayBuilder;", "(Lkorlibs/memory/ByteArrayBuilder;)V", "getData", "()Lkorlibs/memory/ByteArrayBuilder;", "setData", "value", "ilength", "getIlength", "()I", "setIlength", "", "length", "getLength", "()J", "setLength", "(J)V", "checkPosition", "", "position", "close", "read", "buffer", "", "offset", "len", "toString", "", "write", "korge-core"})
public final class MemorySyncStreamBase
extends SyncStreamBase {
    @NotNull
    private ByteArrayBuilder data;

    public MemorySyncStreamBase(@NotNull ByteArrayBuilder data2) {
        this.data = data2;
    }

    @NotNull
    public final ByteArrayBuilder getData() {
        return this.data;
    }

    public final void setData(@NotNull ByteArrayBuilder byteArrayBuilder) {
        this.data = byteArrayBuilder;
    }

    public MemorySyncStreamBase(int initialCapacity) {
        this(new ByteArrayBuilder(initialCapacity));
    }

    public /* synthetic */ MemorySyncStreamBase(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 4096;
        }
        this(n);
    }

    public final int getIlength() {
        return this.data.getSize();
    }

    public final void setIlength(int value) {
        this.data.setSize(value);
    }

    @Override
    public long getLength() {
        return this.data.getSize();
    }

    @Override
    public void setLength(long value) {
        this.data.setSize((int)value);
    }

    public final void checkPosition(long position) {
        if (position < 0L) {
            ExceptionsKt.invalidOp("Invalid position " + position);
            throw new KotlinNothingValueException();
        }
    }

    @Override
    public int read(long position, @NotNull byte[] buffer, int offset2, int len) {
        this.checkPosition(position);
        int ipos = (int)position;
        if (!(0L <= position ? position < (long)this.getIlength() : false)) {
            return 0;
        }
        int end2 = Math.min(this.getIlength(), ipos + len);
        int actualLen = Math.max(end2 - ipos, 0);
        ArraysKt.arraycopy(this.data.getData(), ipos, buffer, offset2, actualLen);
        return actualLen;
    }

    @Override
    public void write(long position, @NotNull byte[] buffer, int offset2, int len) {
        this.checkPosition(position);
        this.data.setSize(Math.max(this.data.getSize(), (int)(position + (long)len)));
        ArraysKt.arraycopy(buffer, offset2, this.data.getData(), (int)position, len);
    }

    @Override
    public void close() {
    }

    @NotNull
    public String toString() {
        return "MemorySyncStreamBase(" + this.data.getSize() + ")";
    }
}

