/*
 * Decompiled with CFR 0.152.
 */
package korlibs.io.stream;

import korlibs.io.stream.SyncStreamBase;
import korlibs.math.ClampKt;
import kotlin.Metadata;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004H\u0002J$\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001bH\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016J(\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016J\b\u0010#\u001a\u00020$H\u0016J(\u0010%\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016R\u0014\u0010\u0002\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0005\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR$\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00048V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\n\"\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006&"}, d2={"Lkorlibs/io/stream/SliceSyncStreamBase;", "Lkorlibs/io/stream/SyncStreamBase;", "base", "baseStart", "", "baseEnd", "(Lkorlibs/io/stream/SyncStreamBase;JJ)V", "getBase$korge_core", "()Lkorlibs/io/stream/SyncStreamBase;", "getBaseEnd$korge_core", "()J", "baseLength", "getBaseLength$korge_core", "getBaseStart$korge_core", "value", "length", "getLength", "setLength", "(J)V", "separateReadWrite", "", "getSeparateReadWrite", "()Z", "clampPosition", "position", "clampPositionLen", "Lkotlin/Pair;", "", "len", "close", "", "read", "buffer", "", "offset", "toString", "", "write", "korge-core"})
public final class SliceSyncStreamBase
extends SyncStreamBase {
    @NotNull
    private final SyncStreamBase base;
    private final long baseStart;
    private final long baseEnd;
    private final long baseLength;

    public SliceSyncStreamBase(@NotNull SyncStreamBase base2, long baseStart, long baseEnd) {
        this.base = base2;
        this.baseStart = baseStart;
        this.baseEnd = baseEnd;
        this.baseLength = this.baseEnd - this.baseStart;
    }

    @NotNull
    public final SyncStreamBase getBase$korge_core() {
        return this.base;
    }

    public final long getBaseStart$korge_core() {
        return this.baseStart;
    }

    public final long getBaseEnd$korge_core() {
        return this.baseEnd;
    }

    @Override
    public boolean getSeparateReadWrite() {
        return this.base.getSeparateReadWrite();
    }

    public final long getBaseLength$korge_core() {
        return this.baseLength;
    }

    @Override
    public long getLength() {
        return this.baseLength;
    }

    @Override
    public void setLength(long value) {
        throw new UnsupportedOperationException();
    }

    private final long clampPosition(long position) {
        return ClampKt.clamp(position, this.baseStart, this.baseEnd);
    }

    private final Pair<Long, Integer> clampPositionLen(long position, int len) {
        if (position < 0L) {
            throw new IllegalArgumentException("Invalid position");
        }
        long targetStartPosition = this.clampPosition(this.baseStart + position);
        long targetEndPosition = this.clampPosition(targetStartPosition + (long)len);
        int targetLen = (int)(targetEndPosition - targetStartPosition);
        return new Pair<Long, Integer>(targetStartPosition, targetLen);
    }

    @Override
    public int read(long position, @NotNull byte[] buffer, int offset2, int len) {
        Pair<Long, Integer> pair = this.clampPositionLen(position, len);
        long targetStartPosition = ((Number)pair.component1()).longValue();
        int targetLen = ((Number)pair.component2()).intValue();
        return this.base.read(targetStartPosition, buffer, offset2, targetLen);
    }

    @Override
    public void write(long position, @NotNull byte[] buffer, int offset2, int len) {
        Pair<Long, Integer> pair = this.clampPositionLen(position, len);
        long targetStartPosition = ((Number)pair.component1()).longValue();
        int targetLen = ((Number)pair.component2()).intValue();
        this.base.write(targetStartPosition, buffer, offset2, targetLen);
    }

    @Override
    public void close() {
    }

    @NotNull
    public String toString() {
        return "SliceAsyncStreamBase(" + this.base + ", " + this.baseStart + ", " + this.baseEnd + ")";
    }
}

