/*
 * Decompiled with CFR 0.152.
 */
package korlibs.io.util;

import korlibs.datastructure.CharDeque;
import korlibs.io.lang.StringExtKt;
import korlibs.io.stream.CharReader;
import korlibs.io.stream.CharReaderKt;
import korlibs.io.util.BaseStrReader;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0019\u001a\u00020\u0001H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000bH\u0016J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000bJ\u0010\u0010 \u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u000bH\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u000bH\u0016J\u0010\u0010$\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020\u000bH\u0016J\b\u0010%\u001a\u00020\u000bH\u0016J\u001a\u0010&\u001a\u0004\u0018\u00010\u001b2\u0006\u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\u0006H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00060\bj\u0002`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000b@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006)"}, d2={"Lkorlibs/io/util/CharReaderStrReader;", "Lkorlibs/io/util/BaseStrReader;", "reader", "Lkorlibs/io/stream/CharReader;", "(Lkorlibs/io/stream/CharReader;)V", "_eof", "", "buffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "bufferingPos", "", "deque", "Lkorlibs/datastructure/CharDeque;", "getDeque", "()Lkorlibs/datastructure/CharDeque;", "eof", "getEof", "()Z", "<set-?>", "pos", "getPos", "()I", "getReader", "()Lkorlibs/io/stream/CharReader;", "clone", "endBuffering", "", "start", "ensure", "", "count", "peek", "peekOffset", "", "offset", "skip", "startBuffering", "tryLit", "lit", "consume", "korge-core"})
public final class CharReaderStrReader
extends BaseStrReader {
    @NotNull
    private final CharReader reader;
    @NotNull
    private final CharDeque deque;
    @NotNull
    private StringBuilder buffer;
    private int bufferingPos;
    private boolean _eof;
    private int pos;

    public CharReaderStrReader(@NotNull CharReader reader) {
        this.reader = reader;
        this.deque = new CharDeque();
        this.buffer = new StringBuilder();
        this.bufferingPos = -1;
    }

    @NotNull
    public final CharReader getReader() {
        return this.reader;
    }

    @NotNull
    public final CharDeque getDeque() {
        return this.deque;
    }

    @Override
    public boolean getEof() {
        this.ensure(1);
        return this._eof && this.deque.isEmpty();
    }

    @Override
    public int getPos() {
        return this.pos;
    }

    public final void ensure(int count2) {
        if (count2 > 0 && this.deque.size() < count2) {
            String read2 = CharReaderKt.read(this.reader, count2);
            if (((CharSequence)read2).length() == 0) {
                this._eof = true;
            }
            this.deque.addAll(StringExtKt.toCharArray(read2));
        }
    }

    @Override
    public char peekOffset(int offset2) {
        if (!(offset2 >= 0)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        this.ensure(offset2 + 1);
        if (this.deque.size() <= offset2) {
            return '\u0000';
        }
        return this.deque.get(offset2);
    }

    @Override
    @NotNull
    public String peek(int count2) {
        StringBuilder stringBuilder;
        this.ensure(count2);
        StringBuilder $this$peek_u24lambda_u240 = stringBuilder = new StringBuilder(count2);
        boolean bl = false;
        int n = Math.min(this.deque.size(), count2);
        for (int n2 = 0; n2 < n; ++n2) {
            $this$peek_u24lambda_u240.append(this.deque.get(n2));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @Override
    @NotNull
    public BaseStrReader skip(int count2) {
        this.ensure(count2);
        for (int n = 0; n < count2; ++n) {
            char res = this.deque.removeFirst();
            if (this.bufferingPos >= 0) {
                this.buffer.append(res);
            }
            int n2 = this.getPos();
            this.pos = n2 + 1;
        }
        return this;
    }

    @Override
    @Nullable
    public String tryLit(@NotNull String lit, boolean consume2) {
        this.ensure(lit.length());
        int n = lit.length();
        for (int n2 = 0; n2 < n; ++n2) {
            if (this.peekOffset(n2) == lit.charAt(n2)) continue;
            return null;
        }
        this.skip(lit.length());
        return lit;
    }

    @Override
    @NotNull
    public BaseStrReader clone() {
        CharReaderStrReader charReaderStrReader;
        CharReaderStrReader it = charReaderStrReader = new CharReaderStrReader(this.reader.clone());
        boolean bl = false;
        int n = this.deque.size();
        for (int n2 = 0; n2 < n; ++n2) {
            it.deque.add(this.deque.get(n2));
        }
        it.buffer.append((CharSequence)this.buffer);
        it._eof = this._eof;
        it.bufferingPos = this.bufferingPos;
        it.pos = this.getPos();
        return charReaderStrReader;
    }

    @Override
    public int startBuffering() {
        this.bufferingPos = this.getPos();
        return this.getPos();
    }

    @Override
    @NotNull
    public String endBuffering(int start2) {
        String out = this.buffer.substring(start2 - this.bufferingPos, this.getPos() - this.bufferingPos);
        if (this.bufferingPos == start2) {
            this.bufferingPos = -1;
            StringsKt.clear(this.buffer);
        }
        Intrinsics.checkNotNull(out);
        return out;
    }
}

