/*
 * Decompiled with CFR 0.152.
 */
package korlibs.io.util;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import korlibs.io.util.JvmFsCaseSensitiveKt;
import korlibs.logger.Logger;
import korlibs.platform.Platform;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.NoSuchFileException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\f\u0010\u000e\u001a\u0004\u0018\u00010\t*\u00020\t\u001a\f\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u000f\u001a\f\u0010\u000e\u001a\u0004\u0018\u00010\f*\u00020\f\u001a\n\u0010\u0010\u001a\u00020\t*\u00020\t\u001a\f\u0010\u0010\u001a\u0004\u0018\u00010\f*\u00020\f\u001a\n\u0010\u0011\u001a\u00020\u0003*\u00020\t\u001a\n\u0010\u0011\u001a\u00020\u0003*\u00020\f\u001a\u000e\u0010\u0012\u001a\u0004\u0018\u00010\t*\u00020\u000fH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u0002\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\u0004\u0010\u0005\"\u0015\u0010\b\u001a\u00020\u0003*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\"\u0015\u0010\b\u001a\u00020\u0003*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\r\u00a8\u0006\u0013"}, d2={"LOGGER", "Lkorlibs/logger/Logger;", "keepOsFsCaseSensitivity", "", "getKeepOsFsCaseSensitivity", "()Z", "keepOsFsCaseSensitivity$delegate", "Lkotlin/Lazy;", "matchesCaseSensitive", "Ljava/io/File;", "getMatchesCaseSensitive", "(Ljava/io/File;)Z", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)Z", "caseSensitiveOrNull", "Ljava/net/URL;", "caseSensitiveOrThrow", "existsCaseSensitive", "toFileOrNull", "korge-core"})
@SourceDebugExtension(value={"SMAP\nJvmFsCaseSensitive.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmFsCaseSensitive.kt\nkorlibs/io/util/JvmFsCaseSensitiveKt\n+ 2 Logger.kt\nkorlibs/logger/Logger\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,48:1\n137#2:49\n125#2:50\n1#3:51\n*S KotlinDebug\n*F\n+ 1 JvmFsCaseSensitive.kt\nkorlibs/io/util/JvmFsCaseSensitiveKt\n*L\n34#1:49\n34#1:50\n*E\n"})
public final class JvmFsCaseSensitiveKt {
    @NotNull
    private static final Logger LOGGER = Logger.Companion.invoke("JvmFsCaseSensitive");
    @NotNull
    private static final Lazy keepOsFsCaseSensitivity$delegate = LazyKt.lazy(keepOsFsCaseSensitivity.2.INSTANCE);

    @Nullable
    public static final File toFileOrNull(@NotNull URL $this$toFileOrNull) {
        if (!Intrinsics.areEqual($this$toFileOrNull.getProtocol(), "file")) {
            return null;
        }
        URI uRI = $this$toFileOrNull.toURI();
        Intrinsics.checkNotNullExpressionValue(uRI, "toURI(...)");
        Path path2 = Paths.get(uRI);
        Intrinsics.checkNotNullExpressionValue(path2, "get(...)");
        return path2.toFile();
    }

    @Nullable
    public static final URL caseSensitiveOrNull(@NotNull URL $this$caseSensitiveOrNull) {
        if (Intrinsics.areEqual($this$caseSensitiveOrNull.getProtocol(), "file")) {
            URI uRI = $this$caseSensitiveOrNull.toURI();
            Intrinsics.checkNotNullExpressionValue(uRI, "toURI(...)");
            Path path2 = Paths.get(uRI);
            Intrinsics.checkNotNullExpressionValue(path2, "get(...)");
            File file = path2.toFile();
            Intrinsics.checkNotNull(file);
            boolean matchesCaseSensitive = JvmFsCaseSensitiveKt.getMatchesCaseSensitive(file);
            if (!matchesCaseSensitive) {
                return null;
            }
        }
        return $this$caseSensitiveOrNull;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean getMatchesCaseSensitive(@NotNull File $this$matchesCaseSensitive) {
        if (!$this$matchesCaseSensitive.exists()) {
            return true;
        }
        if (JvmFsCaseSensitiveKt.getKeepOsFsCaseSensitivity()) {
            return true;
        }
        if (Platform.Companion.isLinux()) {
            return true;
        }
        File canonicalFile = $this$matchesCaseSensitive.getCanonicalFile();
        boolean matchesCase = Intrinsics.areEqual(canonicalFile.getName(), $this$matchesCaseSensitive.getName());
        if (!matchesCase) {
            void this_$iv$iv;
            Logger this_$iv = LOGGER;
            boolean $i$f$info = false;
            Logger logger2 = this_$iv;
            Logger.Level level$iv$iv = Logger.Level.INFO;
            boolean $i$f$log = false;
            if (this_$iv$iv.isEnabled(level$iv$iv)) {
                Logger.Level level = level$iv$iv;
                void var9_9 = this_$iv$iv;
                boolean bl = false;
                String string = "File " + canonicalFile + " doesn't match " + $this$matchesCaseSensitive;
                var9_9.actualLog(level, string);
            }
        }
        return matchesCase;
    }

    @Nullable
    public static final File caseSensitiveOrNull(@NotNull File $this$caseSensitiveOrNull) {
        File file;
        File it = file = $this$caseSensitiveOrNull;
        boolean bl = false;
        return JvmFsCaseSensitiveKt.getMatchesCaseSensitive(it) ? file : null;
    }

    @NotNull
    public static final File caseSensitiveOrThrow(@NotNull File $this$caseSensitiveOrThrow) {
        File file = JvmFsCaseSensitiveKt.caseSensitiveOrNull($this$caseSensitiveOrThrow);
        if (file == null) {
            throw new NoSuchFileException($this$caseSensitiveOrThrow, null, null, 6, null);
        }
        return file;
    }

    public static final boolean existsCaseSensitive(@NotNull File $this$existsCaseSensitive) {
        return $this$existsCaseSensitive.exists() && JvmFsCaseSensitiveKt.getMatchesCaseSensitive($this$existsCaseSensitive);
    }

    public static final boolean getMatchesCaseSensitive(@NotNull Path $this$matchesCaseSensitive) {
        File file = $this$matchesCaseSensitive.toFile();
        Intrinsics.checkNotNullExpressionValue(file, "toFile(...)");
        return JvmFsCaseSensitiveKt.getMatchesCaseSensitive(file);
    }

    @Nullable
    public static final Path caseSensitiveOrNull(@NotNull Path $this$caseSensitiveOrNull) {
        File file = $this$caseSensitiveOrNull.toFile();
        Intrinsics.checkNotNullExpressionValue(file, "toFile(...)");
        File file2 = JvmFsCaseSensitiveKt.caseSensitiveOrNull(file);
        return file2 != null ? file2.toPath() : null;
    }

    @Nullable
    public static final Path caseSensitiveOrThrow(@NotNull Path $this$caseSensitiveOrThrow) {
        File file = $this$caseSensitiveOrThrow.toFile();
        Intrinsics.checkNotNullExpressionValue(file, "toFile(...)");
        return JvmFsCaseSensitiveKt.caseSensitiveOrThrow(file).toPath();
    }

    public static final boolean existsCaseSensitive(@NotNull Path $this$existsCaseSensitive) {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.exists($this$existsCaseSensitive, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && JvmFsCaseSensitiveKt.getMatchesCaseSensitive($this$existsCaseSensitive);
    }

    public static final boolean getKeepOsFsCaseSensitivity() {
        Lazy lazy = keepOsFsCaseSensitivity$delegate;
        return (Boolean)lazy.getValue();
    }
}

