/*
 * Decompiled with CFR 0.152.
 */
package korlibs.io.util;

import korlibs.io.util.NumberParserKt;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\bJ,\u0010\n\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\b\u00a8\u0006\f"}, d2={"Lkorlibs/io/util/NumberParser;", "", "()V", "parseDouble", "", "str", "", "start", "", "end", "parseInt", "radix", "korge-core"})
public final class NumberParser {
    @NotNull
    public static final NumberParser INSTANCE = new NumberParser();

    private NumberParser() {
    }

    public final int parseInt(@NotNull String str, int start2, int end2, int radix) {
        boolean positive = true;
        int out = 0;
        for (int n = start2; n < end2; ++n) {
            char c = str.charAt(n);
            if (c == '-' || c == '+') {
                positive = c == '+';
                continue;
            }
            int value = NumberParserKt.access$ctypeAsInt(c);
            if (value < 0) break;
            out *= radix;
            out += value;
        }
        return positive ? out : -out;
    }

    public static /* synthetic */ int parseInt$default(NumberParser numberParser, String string, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n = 0;
        }
        if ((n4 & 4) != 0) {
            n2 = string.length();
        }
        if ((n4 & 8) != 0) {
            n3 = 10;
        }
        return numberParser.parseInt(string, n, n2, n3);
    }

    public final double parseDouble(@NotNull String str, int start2, int end2) {
        double out = 0.0;
        double frac = 1.0;
        boolean pointSeen = false;
        boolean eSeen = false;
        boolean negate = false;
        boolean negateExponent = false;
        int exponent = 0;
        for (int n = start2; n < end2; ++n) {
            char c = str.charAt(n);
            char c2 = c;
            if (c2 == 'e' ? true : c2 == 'E') {
                eSeen = true;
                continue;
            }
            if (c2 == '-') {
                if (eSeen) {
                    negateExponent = true;
                    continue;
                }
                negate = true;
                continue;
            }
            if (c2 == '.') {
                pointSeen = true;
                continue;
            }
            if (eSeen) {
                exponent *= 10;
                exponent += NumberParserKt.access$ctypeAsInt(c);
                continue;
            }
            if (pointSeen) {
                frac /= (double)10;
            }
            out *= (double)10;
            out += (double)NumberParserKt.access$ctypeAsInt(c);
        }
        double res = out * frac * Math.pow(10.0, negateExponent ? -exponent : exponent);
        return negate ? -res : res;
    }

    public static /* synthetic */ double parseDouble$default(NumberParser numberParser, String string, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = string.length();
        }
        return numberParser.parseDouble(string, n, n2);
    }
}

