/*
 * Decompiled with CFR 0.152.
 */
package korlibs.io.util;

import korlibs.io.util.CharExtKt;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\t\u001a\n\u0010\u0007\u001a\u00020\u0001*\u00020\u0001\u001a\u0012\u0010\u0007\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\b\u001a\u00020\t\u001a\n\u0010\n\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u000b\u001a\u00020\t*\u00020\u0001\u001a\f\u0010\f\u001a\u00020\u0001*\u0004\u0018\u00010\u0001\u001a\u0014\u0010\f\u001a\u00020\u0001*\u0004\u0018\u00010\u00012\u0006\u0010\b\u001a\u00020\t\u001a\f\u0010\r\u001a\u00020\u0001*\u0004\u0018\u00010\u0001\u001a\f\u0010\u000e\u001a\u00020\u0001*\u00020\u0001H\u0007\u001a\n\u0010\u000f\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0010\u001a\u00020\u0001*\u00020\u0001\u001a\u000e\u0010\u0011\u001a\u00020\u0001*\u0004\u0018\u00010\u0001H\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0002\u001a\u00020\u0001*\u0004\u0018\u00010\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\u00a8\u0006\u0012"}, d2={"HEX_DIGITS_LOWER", "", "quoted", "getQuoted", "(Ljava/lang/String;)Ljava/lang/String;", "unquoted", "getUnquoted", "escape", "unicode", "", "escapeUnicode", "isQuoted", "quote", "quoteUnicode", "uescape", "unescape", "unquote", "uquote", "korge-core"})
public final class StringEscapeKt {
    @NotNull
    private static final String HEX_DIGITS_LOWER = "0123456789abcdef";

    @NotNull
    public static final String escape(@NotNull String $this$escape, boolean unicode) {
        StringBuilder out = new StringBuilder($this$escape.length() + 16);
        int n = $this$escape.length();
        for (int j = 0; j < n; ++j) {
            char c = $this$escape.charAt(j);
            char c2 = c;
            if (c2 == '\\') {
                out.append("\\\\");
                continue;
            }
            if (c2 == '\"') {
                out.append("\\\"");
                continue;
            }
            if (c2 == '\n') {
                out.append("\\n");
                continue;
            }
            if (c2 == '\r') {
                out.append("\\r");
                continue;
            }
            if (c2 == '\t') {
                out.append("\\t");
                continue;
            }
            if (!unicode) {
                boolean bl = '\u0000' <= c ? c < ' ' : false;
                if (bl) {
                    out.append("\\x");
                    out.append(HEX_DIGITS_LOWER.charAt(c >>> 4 & 0xF));
                    out.append(HEX_DIGITS_LOWER.charAt(c >>> 0 & 0xF));
                    continue;
                }
            }
            if (unicode && !CharExtKt.isPrintable(c)) {
                out.append("\\u");
                out.append(HEX_DIGITS_LOWER.charAt(c >>> 12 & 0xF));
                out.append(HEX_DIGITS_LOWER.charAt(c >>> 8 & 0xF));
                out.append(HEX_DIGITS_LOWER.charAt(c >>> 4 & 0xF));
                out.append(HEX_DIGITS_LOWER.charAt(c >>> 0 & 0xF));
                continue;
            }
            out.append(c);
        }
        String string = out.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @NotNull
    public static final String escape(@NotNull String $this$escape) {
        return StringEscapeKt.escape($this$escape, false);
    }

    @NotNull
    public static final String escapeUnicode(@NotNull String $this$escapeUnicode) {
        return StringEscapeKt.escape($this$escapeUnicode, true);
    }

    @Deprecated(message="", replaceWith=@ReplaceWith(expression="escapeUnicode()", imports={}))
    @NotNull
    public static final String uescape(@NotNull String $this$uescape) {
        return StringEscapeKt.escapeUnicode($this$uescape);
    }

    @NotNull
    public static final String unescape(@NotNull String $this$unescape) {
        StringBuilder out = new StringBuilder($this$unescape.length());
        int n = 0;
        while (n < $this$unescape.length()) {
            char c;
            if ((c = $this$unescape.charAt(n++)) == '\\') {
                char c2;
                char c3;
                if ((c3 = (c2 = $this$unescape.charAt(n++))) == '\\') {
                    out.append('\\');
                    continue;
                }
                if (c3 == '\"') {
                    out.append('\"');
                    continue;
                }
                if (c3 == 'n') {
                    out.append('\n');
                    continue;
                }
                if (c3 == 'r') {
                    out.append('\r');
                    continue;
                }
                if (c3 == 't') {
                    out.append('\t');
                    continue;
                }
                if (c3 == 'x' ? true : c3 == 'u') {
                    String chars;
                    int N = c2 == 'u' ? 4 : 2;
                    Intrinsics.checkNotNullExpressionValue($this$unescape.substring(n, n + N), "substring(...)");
                    n += N;
                    out.append((char)Integer.parseInt(chars, CharsKt.checkRadix(16)));
                    continue;
                }
                out.append("\\" + c2);
                continue;
            }
            out.append(c);
        }
        String string = out.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @NotNull
    public static final String quote(@Nullable String $this$quote, boolean unicode) {
        String string = $this$quote;
        return string != null ? "\"" + StringEscapeKt.escape(string, unicode) + "\"" : "null";
    }

    @NotNull
    public static final String quote(@Nullable String $this$quote) {
        return StringEscapeKt.quote($this$quote, false);
    }

    @NotNull
    public static final String quoteUnicode(@Nullable String $this$quoteUnicode) {
        return StringEscapeKt.quote($this$quoteUnicode, true);
    }

    @Deprecated(message="", replaceWith=@ReplaceWith(expression="quoteUnicode()", imports={}))
    @NotNull
    public static final String uquote(@Nullable String $this$uquote) {
        return StringEscapeKt.quoteUnicode($this$uquote);
    }

    public static final boolean isQuoted(@NotNull String $this$isQuoted) {
        return StringsKt.startsWith$default((CharSequence)$this$isQuoted, '\"', false, 2, null) && StringsKt.endsWith$default((CharSequence)$this$isQuoted, '\"', false, 2, null);
    }

    @NotNull
    public static final String unquote(@NotNull String $this$unquote) {
        String string;
        if (StringEscapeKt.isQuoted($this$unquote)) {
            String string2 = $this$unquote.substring(1, $this$unquote.length() - 1);
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            string = StringEscapeKt.unescape(string2);
        } else {
            string = $this$unquote;
        }
        return string;
    }

    @NotNull
    public static final String getQuoted(@Nullable String $this$quoted) {
        return StringEscapeKt.quote($this$quoted);
    }

    @NotNull
    public static final String getUnquoted(@NotNull String $this$unquoted) {
        return StringEscapeKt.unquote($this$unquoted);
    }
}

