/*
 * Decompiled with CFR 0.152.
 */
package korlibs.korge.render;

import java.util.Iterator;
import java.util.List;
import korlibs.datastructure.FastIdentityMap;
import korlibs.datastructure.FastMapKt;
import korlibs.datastructure.FastSmallSet;
import korlibs.datastructure.JvmKt;
import korlibs.datastructure.Pool;
import korlibs.graphics.AG;
import korlibs.graphics.AGBuffer;
import korlibs.korge.render.AgBufferManager;
import korlibs.korge.render.AgCachedBuffer;
import korlibs.memory.Buffer;
import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u001c\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b\u001eJ\u000e\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\fJ\u0014\u0010\u001f\u001a\u00020\u001d2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\f0!J\u0006\u0010\"\u001a\u00020\u001dJ\u000e\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\fJ\b\u0010%\u001a\u00020\u001dH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lkorlibs/korge/render/AgBufferManager;", "", "ag", "Lkorlibs/graphics/AG;", "(Lkorlibs/graphics/AG;)V", "getAg", "()Lkorlibs/graphics/AG;", "bufferPool", "Lkorlibs/datastructure/Pool;", "Lkorlibs/graphics/AGBuffer;", "buffers", "Lkorlibs/datastructure/FastIdentityMap;", "Lkorlibs/korge/render/AgCachedBuffer;", "empty", "Lkorlibs/memory/Buffer;", "getEmpty", "()Lkorlibs/memory/Buffer;", "fcount", "", "getFcount", "()I", "setFcount", "(I)V", "framesBetweenGC", "getFramesBetweenGC", "setFramesBetweenGC", "referencedBuffersSinceGC", "Lkorlibs/datastructure/FastSmallSet;", "afterRender", "", "afterRender$korge", "delete", "buffer", "", "gc", "getBuffer", "cached", "removeCache", "korge"})
@SourceDebugExtension(value={"SMAP\nAgBufferManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AgBufferManager.kt\nkorlibs/korge/render/AgBufferManager\n+ 2 FastMap.kt\nkorlibs/datastructure/FastMapKt\n+ 3 FastSmallSet.kt\nkorlibs/datastructure/FastSmallSet\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Datastructure_iterators.kt\nkorlibs/datastructure/iterators/_Datastructure_iteratorsKt\n*L\n1#1,67:1\n138#2,5:68\n54#3:73\n56#3:76\n1855#4,2:74\n61#5,3:77\n*S KotlinDebug\n*F\n+ 1 AgBufferManager.kt\nkorlibs/korge/render/AgBufferManager\n*L\n20#1:68,5\n42#1:73\n42#1:76\n42#1:74,2\n50#1:77,3\n*E\n"})
public final class AgBufferManager {
    @NotNull
    private final AG ag;
    @NotNull
    private final FastIdentityMap<AgCachedBuffer, AGBuffer> buffers;
    @NotNull
    private final FastSmallSet<AgCachedBuffer> referencedBuffersSinceGC;
    @NotNull
    private final Pool<AGBuffer> bufferPool;
    private int fcount;
    private int framesBetweenGC;
    @NotNull
    private final Buffer empty;

    public AgBufferManager(@NotNull AG ag2) {
        this.ag = ag2;
        this.buffers = JvmKt.FastIdentityMap();
        this.referencedBuffersSinceGC = new FastSmallSet();
        this.bufferPool = new Pool(0, bufferPool.1.INSTANCE, 1, null);
        this.framesBetweenGC = 60;
        this.empty = new Buffer(0, false, 2, null);
    }

    @NotNull
    public final AG getAg() {
        return this.ag;
    }

    @NotNull
    public final AGBuffer getBuffer(@NotNull AgCachedBuffer cached) {
        this.referencedBuffersSinceGC.add(cached);
        FastIdentityMap<AgCachedBuffer, AGBuffer> $this$getOrPut$iv = this.buffers;
        boolean $i$f$getOrPut = false;
        AGBuffer res$iv = JvmKt.get($this$getOrPut$iv, cached);
        AGBuffer aGBuffer = res$iv;
        if (aGBuffer == null) {
            AGBuffer aGBuffer2;
            AgCachedBuffer it = cached;
            boolean bl = false;
            AGBuffer it2 = aGBuffer2 = this.bufferPool.alloc();
            boolean bl2 = false;
            it2.upload(cached.getData());
            AGBuffer out$iv = aGBuffer2;
            JvmKt.set($this$getOrPut$iv, cached, out$iv);
            aGBuffer = out$iv;
        }
        return aGBuffer;
    }

    public final int getFcount() {
        return this.fcount;
    }

    public final void setFcount(int n) {
        this.fcount = n;
    }

    public final int getFramesBetweenGC() {
        return this.framesBetweenGC;
    }

    public final void setFramesBetweenGC(int n) {
        this.framesBetweenGC = n;
    }

    public final void afterRender$korge() {
        this.removeCache();
        int n = this.fcount;
        this.fcount = n + 1;
        if (this.fcount >= this.framesBetweenGC) {
            this.fcount = 0;
            this.gc();
        }
    }

    public final void gc() {
        FastSmallSet<AgCachedBuffer> this_$iv = this.referencedBuffersSinceGC;
        boolean $i$f$fastForEach = false;
        Iterable $this$forEach$iv$iv = this_$iv.get_items();
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv;
            Object it$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            AgCachedBuffer it = (AgCachedBuffer)it$iv;
            boolean bl2 = false;
            this.delete(it);
        }
        this.referencedBuffersSinceGC.clear();
    }

    private final void removeCache() {
    }

    public final void delete(@NotNull List<AgCachedBuffer> buffer) {
        List<AgCachedBuffer> $this$fastForEach$iv = buffer;
        boolean $i$f$fastForEach = false;
        int n$iv = 0;
        while (n$iv < $this$fastForEach$iv.size()) {
            AgCachedBuffer it = $this$fastForEach$iv.get(n$iv++);
            boolean bl = false;
            this.delete(it);
        }
    }

    @NotNull
    public final Buffer getEmpty() {
        return this.empty;
    }

    public final void delete(@NotNull AgCachedBuffer buffer) {
        block0: {
            AGBuffer buf;
            AGBuffer aGBuffer = buf = FastMapKt.getAndRemove(this.buffers, buffer);
            if (aGBuffer == null) break block0;
            AGBuffer it = aGBuffer;
            boolean bl = false;
            it.upload(this.empty);
            this.bufferPool.free(buf);
        }
    }
}

