/*
 * Decompiled with CFR 0.152.
 */
package korlibs.korge.service.storage;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import korlibs.concurrent.lock.Lock;
import korlibs.io.serialization.json.JsonKt;
import korlibs.korge.service.storage.IStorageWithKeys;
import korlibs.korge.view.Views;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0011H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0016\u001a\u00020\u0006H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0006H$J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0006H$J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u0006H\u0016J\b\u0010\u001e\u001a\u00020\u001bH\u0016J\b\u0010\u001f\u001a\u00020\u001bH\u0002J\u0010\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u0006H$J\u0019\u0010\"\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u0006H\u0096\u0002J\b\u0010$\u001a\u00020\u0006H\u0016R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\t\u001a\u00020\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\n\u0010\bR\u0012\u0010\r\u001a\u00060\u000ej\u0002`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006%"}, d2={"Lkorlibs/korge/service/storage/FiledBasedNativeStorage;", "Lkorlibs/korge/service/storage/IStorageWithKeys;", "views", "Lkorlibs/korge/view/Views;", "(Lkorlibs/korge/view/Views;)V", "gameStorageFile", "", "getGameStorageFile", "()Ljava/lang/String;", "gameStorageFolder", "getGameStorageFolder", "gameStorageFolder$delegate", "Lkotlin/Lazy;", "lock", "Lkorlibs/concurrent/lock/Lock;", "Lkorlibs/datastructure/lock/Lock;", "map", "", "getViews", "()Lkorlibs/korge/view/Views;", "ensureMap", "getOrNull", "key", "keys", "", "loadStr", "mkdirs", "", "folder", "remove", "removeAll", "save", "saveStr", "data", "set", "value", "toString", "korge"})
@SourceDebugExtension(value={"SMAP\nNativeStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NativeStorage.kt\nkorlibs/korge/service/storage/FiledBasedNativeStorage\n+ 2 Lock.jvm.kt\nkorlibs/concurrent/lock/Lock\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n32#2:83\n32#2:86\n32#2:88\n32#2:90\n32#2:92\n32#2:94\n1#3:84\n1#3:85\n1#3:87\n1#3:89\n1#3:91\n1#3:93\n1#3:95\n*S KotlinDebug\n*F\n+ 1 NativeStorage.kt\nkorlibs/korge/service/storage/FiledBasedNativeStorage\n*L\n39#1:83\n59#1:86\n63#1:88\n68#1:90\n72#1:92\n77#1:94\n39#1:84\n59#1:87\n63#1:89\n68#1:91\n72#1:93\n77#1:95\n*E\n"})
public abstract class FiledBasedNativeStorage
implements IStorageWithKeys {
    @NotNull
    private final Views views;
    @NotNull
    private final Lazy gameStorageFolder$delegate;
    @NotNull
    private final Lock lock;
    @Nullable
    private Map<String, String> map;

    public FiledBasedNativeStorage(@NotNull Views views2) {
        this.views = views2;
        this.gameStorageFolder$delegate = LazyKt.lazy((Function0)new Function0<String>(this){
            final /* synthetic */ FiledBasedNativeStorage this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                String string = this.this$0.getViews().getRealSettingsFolder();
                FiledBasedNativeStorage filedBasedNativeStorage = this.this$0;
                String it = string;
                boolean bl = false;
                filedBasedNativeStorage.mkdirs(it);
                return string;
            }
        });
        this.lock = new Lock();
    }

    @NotNull
    public final Views getViews() {
        return this.views;
    }

    @NotNull
    public final String getGameStorageFolder() {
        Lazy lazy = this.gameStorageFolder$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String getGameStorageFile() {
        return this.getGameStorageFolder() + "/game.storage";
    }

    protected abstract void mkdirs(@NotNull String var1);

    protected abstract void saveStr(@NotNull String var1);

    @NotNull
    protected abstract String loadStr();

    @NotNull
    public String toString() {
        return "NativeStorage(" + this.toMap() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<String> keys() {
        Lock this_$iv = this.lock;
        boolean $i$f$invoke = false;
        Lock lock = this_$iv;
        synchronized (lock) {
            boolean bl = false;
            boolean bl2 = false;
            this.ensureMap();
            Map<String, String> map2 = this.map;
            Intrinsics.checkNotNull(map2);
            List<String> list2 = CollectionsKt.toList((Iterable)map2.keySet());
            return list2;
        }
    }

    private final Map<String, String> ensureMap() {
        if (this.map == null) {
            Object $i$a$-runCatching-FiledBasedNativeStorage$ensureMap$str$22;
            this.map = new LinkedHashMap();
            try {
                boolean $i$a$-runCatching-FiledBasedNativeStorage$ensureMap$str$22 = false;
                $i$a$-runCatching-FiledBasedNativeStorage$ensureMap$str$22 = Result.constructor-impl(this.loadStr());
            }
            catch (Throwable throwable) {
                $i$a$-runCatching-FiledBasedNativeStorage$ensureMap$str$22 = Result.constructor-impl(ResultKt.createFailure(throwable));
            }
            String str = (String)(Result.isFailure-impl($i$a$-runCatching-FiledBasedNativeStorage$ensureMap$str$22) ? null : $i$a$-runCatching-FiledBasedNativeStorage$ensureMap$str$22);
            $i$a$-runCatching-FiledBasedNativeStorage$ensureMap$str$22 = str;
            if (!($i$a$-runCatching-FiledBasedNativeStorage$ensureMap$str$22 == null || $i$a$-runCatching-FiledBasedNativeStorage$ensureMap$str$22.length() == 0)) {
                try {
                    Map<String, String> map2 = this.map;
                    Intrinsics.checkNotNull(map2);
                    Object object = JsonKt.fromJson(str);
                    Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.String>");
                    map2.putAll((Map)object);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        Map<String, String> map3 = this.map;
        Intrinsics.checkNotNull(map3);
        return map3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void save() {
        Lock this_$iv = this.lock;
        boolean $i$f$invoke = false;
        Lock lock = this_$iv;
        synchronized (lock) {
            boolean bl = false;
            boolean bl2 = false;
            this.saveStr(JsonKt.toJson$default(this.ensureMap(), false, 1, null));
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(@NotNull String key, @NotNull String value) {
        Lock this_$iv = this.lock;
        boolean $i$f$invoke = false;
        Lock lock = this_$iv;
        synchronized (lock) {
            boolean bl = false;
            boolean bl2 = false;
            this.ensureMap().put(key, value);
            this.save();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public String getOrNull(@NotNull String key) {
        Lock this_$iv = this.lock;
        boolean $i$f$invoke = false;
        Lock lock = this_$iv;
        synchronized (lock) {
            boolean bl = false;
            boolean bl2 = false;
            String string = this.ensureMap().get(key);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(@NotNull String key) {
        Lock this_$iv = this.lock;
        boolean $i$f$invoke = false;
        Lock lock = this_$iv;
        synchronized (lock) {
            boolean bl = false;
            boolean bl2 = false;
            this.ensureMap().remove(key);
            this.save();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll() {
        Lock this_$iv = this.lock;
        boolean $i$f$invoke = false;
        Lock lock = this_$iv;
        synchronized (lock) {
            boolean bl = false;
            boolean bl2 = false;
            this.ensureMap().clear();
            this.save();
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    @NotNull
    public Map<String, String> toMap() {
        return IStorageWithKeys.DefaultImpls.toMap(this);
    }
}

