/*
 * Decompiled with CFR 0.152.
 */
package korlibs.korge.service.storage;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import korlibs.korge.service.storage.IStorageWithKeys;
import korlibs.korge.view.Views;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0019\u001a\u00020\u0017H\u0016J\b\u0010\u001a\u001a\u00020\u0017H\u0002J\u0019\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0012H\u0096\u0002J\b\u0010\u001d\u001a\u00020\u0012H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001e"}, d2={"Lkorlibs/korge/service/storage/NativeStorage;", "Lkorlibs/korge/service/storage/IStorageWithKeys;", "views", "Lkorlibs/korge/view/Views;", "(Lkorlibs/korge/view/Views;)V", "file", "Ljava/io/File;", "getFile", "()Ljava/io/File;", "folder", "getFolder", "props", "Ljava/util/Properties;", "getProps", "()Ljava/util/Properties;", "getViews", "()Lkorlibs/korge/view/Views;", "getOrNull", "", "key", "keys", "", "load", "", "remove", "removeAll", "save", "set", "value", "toString", "korge"})
@SourceDebugExtension(value={"SMAP\nNativeStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NativeStorage.kt\nkorlibs/korge/service/storage/NativeStorage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,57:1\n1#2:58\n1549#3:59\n1620#3,3:60\n*S KotlinDebug\n*F\n+ 1 NativeStorage.kt\nkorlibs/korge/service/storage/NativeStorage\n*L\n18#1:59\n18#1:60,3\n*E\n"})
public final class NativeStorage
implements IStorageWithKeys {
    @NotNull
    private final Views views;
    @NotNull
    private final Properties props;
    @NotNull
    private final File folder;
    @NotNull
    private final File file;

    /*
     * WARNING - void declaration
     */
    public NativeStorage(@NotNull Views views2) {
        File file;
        this.views = views2;
        this.props = new Properties();
        File file2 = file = new File(this.views.getRealSettingsFolder());
        NativeStorage nativeStorage = this;
        boolean bl = false;
        try {
            void it;
            boolean bl2 = false;
            Object object = Result.constructor-impl(it.mkdirs());
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl(ResultKt.createFailure(throwable));
        }
        nativeStorage.folder = file;
        this.file = new File(this.folder, "game.jvm.storage");
        this.load();
    }

    @NotNull
    public final Views getViews() {
        return this.views;
    }

    @NotNull
    public final Properties getProps() {
        return this.props;
    }

    @NotNull
    public final File getFolder() {
        return this.folder;
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    @NotNull
    public String toString() {
        return "NativeStorage(" + this.toMap() + ")";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> keys() {
        void $this$mapTo$iv$iv;
        Set<Object> set = this.props.keySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
        Iterable $this$map$iv = CollectionsKt.toList((Iterable)set);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toString());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void load() {
        if (!this.file.exists()) {
            return;
        }
        try {
            Closeable closeable2 = new FileInputStream(this.file);
            Throwable throwable = null;
            try {
                FileInputStream fis = (FileInputStream)closeable2;
                boolean bl = false;
                this.props.load(fis);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable2, throwable);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void save() {
        try {
            Closeable closeable2 = new FileOutputStream(this.file);
            Throwable throwable = null;
            try {
                FileOutputStream fout = (FileOutputStream)closeable2;
                boolean bl = false;
                this.props.store(fout, "");
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable2, throwable);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void set(@NotNull String key, @NotNull String value) {
        ((Map)this.props).put(key, value);
        this.save();
    }

    @Override
    @Nullable
    public String getOrNull(@NotNull String key) {
        Object object = this.props.get(key);
        return object != null ? object.toString() : null;
    }

    @Override
    public void remove(@NotNull String key) {
        this.props.remove(key);
        this.save();
    }

    @Override
    public void removeAll() {
        this.props.clear();
        this.save();
    }

    @Override
    @NotNull
    public Map<String, String> toMap() {
        return IStorageWithKeys.DefaultImpls.toMap(this);
    }
}

