/*
 * Decompiled with CFR 0.152.
 */
package korlibs.korge.service.storage;

import korlibs.korge.service.storage.IStorage;
import korlibs.korge.service.storage.IStorageKey;
import korlibs.korge.service.storage.IStorageKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\f\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B?\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060\b\u0012\u0014\u0010\t\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0002\u0010\nR\u001f\u0010\t\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R$\u0010\u0015\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00028\u00008V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lkorlibs/korge/service/storage/StorageKey;", "T", "Lkorlibs/korge/service/storage/IStorageKey;", "storage", "Lkorlibs/korge/service/storage/IStorage;", "key", "", "serialize", "Lkotlin/Function1;", "deserialize", "(Lkorlibs/korge/service/storage/IStorage;Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "getDeserialize", "()Lkotlin/jvm/functions/Function1;", "isDefined", "", "()Z", "getKey", "()Ljava/lang/String;", "getSerialize", "getStorage", "()Lkorlibs/korge/service/storage/IStorage;", "value", "getValue", "()Ljava/lang/Object;", "setValue", "(Ljava/lang/Object;)V", "korge"})
public final class StorageKey<T>
implements IStorageKey<T> {
    @NotNull
    private final IStorage storage;
    @NotNull
    private final String key;
    @NotNull
    private final Function1<T, String> serialize;
    @NotNull
    private final Function1<String, T> deserialize;

    public StorageKey(@NotNull IStorage storage2, @NotNull String key, @NotNull Function1<? super T, String> serialize, @NotNull Function1<? super String, ? extends T> deserialize2) {
        this.storage = storage2;
        this.key = key;
        this.serialize = serialize;
        this.deserialize = deserialize2;
    }

    @NotNull
    public final IStorage getStorage() {
        return this.storage;
    }

    @NotNull
    public final String getKey() {
        return this.key;
    }

    @NotNull
    public final Function1<T, String> getSerialize() {
        return this.serialize;
    }

    @NotNull
    public final Function1<String, T> getDeserialize() {
        return this.deserialize;
    }

    @Override
    public boolean isDefined() {
        return IStorageKt.contains(this.storage, this.key);
    }

    @Override
    public T getValue() {
        return this.deserialize.invoke(this.storage.getOrNull(this.key));
    }

    @Override
    public void setValue(T value) {
        this.storage.set(this.key, this.serialize.invoke(value));
    }

    @Override
    public T getValue(@Nullable Object t, @NotNull KProperty<?> property) {
        return IStorageKey.DefaultImpls.getValue(this, t, property);
    }

    @Override
    public void setValue(@Nullable Object t, @NotNull KProperty<?> property, T value) {
        IStorageKey.DefaultImpls.setValue(this, t, property, value);
    }
}

