/*
 * Decompiled with CFR 0.152.
 */
package korlibs.korge.testing;

import korlibs.image.bitmap.Bitmap;
import korlibs.image.color.RGBA;
import korlibs.korge.testing.KorgeScreenshotValidator;
import korlibs.korge.testing.KorgeScreenshotValidatorResult;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lkorlibs/korge/testing/AbsolutePixelDifferenceValidator;", "Lkorlibs/korge/testing/KorgeScreenshotValidator;", "pixelTolerance", "", "(J)V", "getNumPixelDifference", "left", "Lkorlibs/image/bitmap/Bitmap;", "right", "validate", "Lkorlibs/korge/testing/KorgeScreenshotValidatorResult;", "goldenName", "", "oldBitmap", "newBitmap", "korge"})
public final class AbsolutePixelDifferenceValidator
implements KorgeScreenshotValidator {
    private final long pixelTolerance;

    public AbsolutePixelDifferenceValidator(long pixelTolerance) {
        this.pixelTolerance = pixelTolerance;
    }

    @Override
    @NotNull
    public KorgeScreenshotValidatorResult validate(@NotNull String goldenName, @NotNull Bitmap oldBitmap, @Nullable Bitmap newBitmap) {
        if (newBitmap == null || oldBitmap.getWidth() != newBitmap.getWidth() || oldBitmap.getHeight() != newBitmap.getHeight()) {
            return KorgeScreenshotValidatorResult.Success.INSTANCE;
        }
        long diff = this.getNumPixelDifference(oldBitmap, newBitmap);
        if (diff > this.pixelTolerance) {
            return new KorgeScreenshotValidatorResult.Error("Difference in pixels greater than allowed tolerance (" + this.pixelTolerance + "): " + diff);
        }
        return KorgeScreenshotValidatorResult.Success.INSTANCE;
    }

    private final long getNumPixelDifference(Bitmap left, Bitmap right) {
        if (!(left.getWidth() == right.getWidth() && left.getHeight() == right.getHeight())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        long numDiff = 0L;
        int n = left.getHeight();
        for (int y = 0; y < n; ++y) {
            int n2 = left.getWidth();
            for (int x = 0; x < n2; ++x) {
                if (RGBA.equals-impl0(left.getRgbaRaw-GWFm98M(x, y), right.getRgbaRaw-GWFm98M(x, y))) continue;
                long l = numDiff;
                numDiff = l + 1L;
            }
        }
        return numDiff;
    }
}

