/*
 * Decompiled with CFR 0.152.
 */
package korlibs.korge.testing;

import korlibs.image.bitmap.Bitmap;
import korlibs.image.bitmap.Bitmap32;
import korlibs.image.bitmap.PSNRKt;
import korlibs.image.color.RGBAPremultiplied;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u00a8\u0006\t"}, d2={"Lkorlibs/korge/testing/BitmapComparer;", "", "()V", "compare", "Lkorlibs/korge/testing/BitmapComparer$CompareResult;", "left", "Lkorlibs/image/bitmap/Bitmap;", "right", "CompareResult", "korge"})
public final class BitmapComparer {
    @NotNull
    public static final BitmapComparer INSTANCE = new BitmapComparer();

    private BitmapComparer() {
    }

    @NotNull
    public final CompareResult compare(@NotNull Bitmap left, @NotNull Bitmap right) {
        Bitmap32 L = left.toBMP32().premultipliedIfRequired();
        Bitmap32 R = right.toBMP32().premultipliedIfRequired();
        if (L.getPremultiplied() != R.getPremultiplied()) {
            return new CompareResult(0, 0, 0, 0.0, "premultiplied left=" + L.getPremultiplied() + ", right=" + R.getPremultiplied(), 15, null);
        }
        if (L.getWidth() != R.getWidth() || L.getHeight() != R.getHeight()) {
            return new CompareResult(0, 0, 0, 0.0, "dimensions left=" + L.getWidth() + "x" + L.getHeight() + ", right=" + R.getWidth() + "x" + R.getHeight(), 15, null);
        }
        int pixelDiffCount = 0;
        int pixelTotalDistance = 0;
        int pixelMaxDistance = 0;
        int n = L.getHeight();
        for (int y = 0; y < n; ++y) {
            int n2 = L.getWidth();
            for (int x = 0; x < n2; ++x) {
                int lc = L.getRgbaPremultiplied-YdjHmOQ(x, y);
                int rc = R.getRgbaPremultiplied-YdjHmOQ(x, y);
                int Rdiff = Math.abs(RGBAPremultiplied.getR-impl(lc) - RGBAPremultiplied.getR-impl(rc));
                int Gdiff = Math.abs(RGBAPremultiplied.getG-impl(lc) - RGBAPremultiplied.getG-impl(rc));
                int Bdiff = Math.abs(RGBAPremultiplied.getB-impl(lc) - RGBAPremultiplied.getB-impl(rc));
                int Adiff = Math.abs(RGBAPremultiplied.getA-impl(lc) - RGBAPremultiplied.getA-impl(rc));
                pixelTotalDistance += Rdiff + Gdiff + Bdiff + Adiff;
                pixelMaxDistance = Math.max(pixelMaxDistance, Rdiff);
                pixelMaxDistance = Math.max(pixelMaxDistance, Gdiff);
                pixelMaxDistance = Math.max(pixelMaxDistance, Bdiff);
                pixelMaxDistance = Math.max(pixelMaxDistance, Adiff);
                if (RGBAPremultiplied.equals-impl0(lc, rc)) continue;
                ++pixelDiffCount;
            }
        }
        double psnr = PSNRKt.computePsnr(Bitmap32.Companion, L.toBMP32(), R.toBMP32());
        return new CompareResult(pixelDiffCount, pixelTotalDistance, pixelMaxDistance, psnr, null, 16, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\tH\u00c6\u0003J;\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\tH\u00d6\u0001R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lkorlibs/korge/testing/BitmapComparer$CompareResult;", "", "pixelDiffCount", "", "pixelTotalDistance", "pixelMaxDistance", "psnr", "", "error", "", "(IIIDLjava/lang/String;)V", "getError", "()Ljava/lang/String;", "getPixelDiffCount", "()I", "getPixelMaxDistance", "getPixelTotalDistance", "getPsnr", "()D", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "korge"})
    public static final class CompareResult {
        private final int pixelDiffCount;
        private final int pixelTotalDistance;
        private final int pixelMaxDistance;
        private final double psnr;
        @NotNull
        private final String error;

        public CompareResult(int pixelDiffCount, int pixelTotalDistance, int pixelMaxDistance, double psnr, @NotNull String error) {
            this.pixelDiffCount = pixelDiffCount;
            this.pixelTotalDistance = pixelTotalDistance;
            this.pixelMaxDistance = pixelMaxDistance;
            this.psnr = psnr;
            this.error = error;
        }

        public /* synthetic */ CompareResult(int n, int n2, int n3, double d, String string, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 1) != 0) {
                n = -1;
            }
            if ((n4 & 2) != 0) {
                n2 = -1;
            }
            if ((n4 & 4) != 0) {
                n3 = -1;
            }
            if ((n4 & 8) != 0) {
                d = 0.0;
            }
            if ((n4 & 0x10) != 0) {
                string = "";
            }
            this(n, n2, n3, d, string);
        }

        public final int getPixelDiffCount() {
            return this.pixelDiffCount;
        }

        public final int getPixelTotalDistance() {
            return this.pixelTotalDistance;
        }

        public final int getPixelMaxDistance() {
            return this.pixelMaxDistance;
        }

        public final double getPsnr() {
            return this.psnr;
        }

        @NotNull
        public final String getError() {
            return this.error;
        }

        public final int component1() {
            return this.pixelDiffCount;
        }

        public final int component2() {
            return this.pixelTotalDistance;
        }

        public final int component3() {
            return this.pixelMaxDistance;
        }

        public final double component4() {
            return this.psnr;
        }

        @NotNull
        public final String component5() {
            return this.error;
        }

        @NotNull
        public final CompareResult copy(int pixelDiffCount, int pixelTotalDistance, int pixelMaxDistance, double psnr, @NotNull String error) {
            return new CompareResult(pixelDiffCount, pixelTotalDistance, pixelMaxDistance, psnr, error);
        }

        public static /* synthetic */ CompareResult copy$default(CompareResult compareResult, int n, int n2, int n3, double d, String string, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = compareResult.pixelDiffCount;
            }
            if ((n4 & 2) != 0) {
                n2 = compareResult.pixelTotalDistance;
            }
            if ((n4 & 4) != 0) {
                n3 = compareResult.pixelMaxDistance;
            }
            if ((n4 & 8) != 0) {
                d = compareResult.psnr;
            }
            if ((n4 & 0x10) != 0) {
                string = compareResult.error;
            }
            return compareResult.copy(n, n2, n3, d, string);
        }

        @NotNull
        public String toString() {
            return "CompareResult(pixelDiffCount=" + this.pixelDiffCount + ", pixelTotalDistance=" + this.pixelTotalDistance + ", pixelMaxDistance=" + this.pixelMaxDistance + ", psnr=" + this.psnr + ", error=" + this.error + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.pixelDiffCount);
            result2 = result2 * 31 + Integer.hashCode(this.pixelTotalDistance);
            result2 = result2 * 31 + Integer.hashCode(this.pixelMaxDistance);
            result2 = result2 * 31 + Double.hashCode(this.psnr);
            result2 = result2 * 31 + this.error.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CompareResult)) {
                return false;
            }
            CompareResult compareResult = (CompareResult)other;
            if (this.pixelDiffCount != compareResult.pixelDiffCount) {
                return false;
            }
            if (this.pixelTotalDistance != compareResult.pixelTotalDistance) {
                return false;
            }
            if (this.pixelMaxDistance != compareResult.pixelMaxDistance) {
                return false;
            }
            if (Double.compare(this.psnr, compareResult.psnr) != 0) {
                return false;
            }
            return Intrinsics.areEqual(this.error, compareResult.error);
        }

        public CompareResult() {
            this(0, 0, 0, 0.0, null, 31, null);
        }
    }
}

