/*
 * Decompiled with CFR 0.152.
 */
package korlibs.korge.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import korlibs.korge.annotations.KorgeExperimental;
import korlibs.korge.render.RenderContext;
import korlibs.korge.ui.UIView;
import korlibs.korge.view.Container;
import korlibs.korge.view.DummyView;
import korlibs.korge.view.FixedSizeContainerKt;
import korlibs.korge.view.View;
import korlibs.korge.view.ViewKt;
import korlibs.math.ClampKt;
import korlibs.math.geom.MatrixTransform;
import korlibs.math.geom.RectangleD;
import korlibs.math.geom.Size2D;
import korlibs.math.geom.Vector2D;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KorgeExperimental
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000  2\u00020\u0001:\u0002 !B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\u0006\u0010\u001f\u001a\u00020\u001bR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00060\nj\u0002`\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R*\u0010\u0013\u001a\u001e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014j\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0016`\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lkorlibs/korge/ui/UIVerticalList;", "Lkorlibs/korge/ui/UIView;", "provider", "Lkorlibs/korge/ui/UIVerticalList$Provider;", "width", "", "(Lkorlibs/korge/ui/UIVerticalList$Provider;D)V", "dirty", "", "lastArea", "Lkorlibs/math/geom/RectangleD;", "Lkorlibs/math/geom/Rectangle;", "lastPoint", "Lkorlibs/math/geom/Vector2D;", "value", "getProvider", "()Lkorlibs/korge/ui/UIVerticalList$Provider;", "setProvider", "(Lkorlibs/korge/ui/UIVerticalList$Provider;)V", "viewsByIndex", "Ljava/util/LinkedHashMap;", "", "Lkorlibs/korge/view/View;", "Lkotlin/collections/LinkedHashMap;", "getIndexAtY", "y", "invalidateList", "", "renderInternal", "ctx", "Lkorlibs/korge/render/RenderContext;", "updateList", "Companion", "Provider", "korge"})
@SourceDebugExtension(value={"SMAP\nUIVerticalList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UIVerticalList.kt\nkorlibs/korge/ui/UIVerticalList\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,149:1\n372#2,3:150\n375#2,4:154\n1#3:153\n766#4:158\n857#4,2:159\n215#5,2:161\n*S KotlinDebug\n*F\n+ 1 UIVerticalList.kt\nkorlibs/korge/ui/UIVerticalList\n*L\n111#1:150,3\n111#1:154,4\n136#1:158\n136#1:159,2\n138#1:161,2\n*E\n"})
public class UIVerticalList
extends UIView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean dirty;
    @NotNull
    private final LinkedHashMap<Integer, View> viewsByIndex;
    @NotNull
    private RectangleD lastArea;
    @NotNull
    private Vector2D lastPoint;
    @NotNull
    private Provider provider;

    public UIVerticalList(@NotNull Provider provider, double width2) {
        super(Size2D.copy$default(UIView.Companion.getDEFAULT_SIZE(), width2, 0.0, 2, null), false, 2, null);
        this.viewsByIndex = new LinkedHashMap();
        this.lastArea = RectangleD.Companion.getNaN();
        this.lastPoint = Vector2D.Companion.getNaN();
        this.provider = provider;
        this.updateList();
        ViewKt.addUpdater((View)this, 1.INSTANCE);
    }

    public /* synthetic */ UIVerticalList(Provider provider, double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            d = 200.0;
        }
        this(provider, d);
    }

    @NotNull
    public final Provider getProvider() {
        return this.provider;
    }

    public final void setProvider(@NotNull Provider value) {
        this.provider = value;
        this.dirty = true;
        this.updateList();
    }

    @Override
    protected void renderInternal(@NotNull RenderContext ctx) {
        this.updateList();
        super.renderInternal(ctx);
    }

    private final int getIndexAtY(double y) {
        Double d = this.provider.getFixedHeight();
        double index2 = y / (double)(d != null ? (float)d.doubleValue() : 20.0f);
        return (int)index2;
    }

    public final void invalidateList() {
        this.dirty = true;
        this.removeChildren();
        this.viewsByIndex.clear();
        this.updateList();
    }

    /*
     * WARNING - void declaration
     */
    public final void updateList() {
        if (this.getParent() == null) {
            return;
        }
        RectangleD area = FixedSizeContainerKt.getVisibleGlobalArea(this);
        Vector2D point2 = this.getGlobalPos();
        int numItems = this.provider.getNumItems();
        if (this.dirty || !Intrinsics.areEqual(area, this.lastArea) || !Intrinsics.areEqual(point2, this.lastPoint)) {
            void $this$filterTo$iv$iv;
            Object key$iv;
            this.dirty = false;
            this.lastArea = area;
            this.lastPoint = point2;
            Container container2 = this.getParent();
            Intrinsics.checkNotNull(container2);
            MatrixTransform transform2 = container2.getGlobalMatrix().toTransform();
            int fromIndex = ClampKt.clamp(this.getIndexAtY((-point2.getY() + 0.0) / transform2.getScaleY()), 0, numItems - 1);
            int toIndex = 0;
            toIndex = fromIndex;
            if (numItems > 0) {
                int index2 = fromIndex;
                while (index2 < numItems) {
                    Object object;
                    void $this$getOrPut$iv;
                    Map map2 = this.viewsByIndex;
                    key$iv = index2;
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        View view2;
                        boolean bl = false;
                        double itemHeight = this.provider.getItemHeight(index2);
                        View it = view2 = this.provider.getItemView(index2, this);
                        boolean bl2 = false;
                        this.addChild(it);
                        View answer$iv = ViewKt.size(ViewKt.position(view2, 0.0, this.provider.getItemY(index2)), this.getWidth(), itemHeight);
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    View view3 = (View)object;
                    view3.setZIndex(index2);
                    toIndex = index2++;
                    if (view3.localToGlobal(new Vector2D(0.0, view3.getHeight())).getY() >= area.getBottom()) break;
                }
            }
            Set<Integer> set = this.viewsByIndex.keySet();
            Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
            Iterable $this$filter$iv = set;
            boolean $i$f$filter = false;
            key$iv = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Integer it = (Integer)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                int n = it;
                boolean bl2 = fromIndex <= n ? n <= toIndex : false;
                if (!(!bl2)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Set<Integer> removeIndices = CollectionsKt.toSet((List)destination$iv$iv);
            Map $this$forEach$iv = this.viewsByIndex;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry2 = element$iv = iterator2.next();
                boolean bl = false;
                int index3 = ((Number)entry2.getKey()).intValue();
                View view4 = (View)entry2.getValue();
                if (!removeIndices.contains(index3)) continue;
                view4.removeFromParent();
            }
            for (Integer index4 : removeIndices) {
                this.viewsByIndex.remove(index4);
            }
        }
        ViewKt.size((View)this, this.getWidth(), this.provider.getItemY(numItems - 1) + this.provider.getItemHeight(numItems - 1));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0086\n\u00a8\u0006\t"}, d2={"Lkorlibs/korge/ui/UIVerticalList$Companion;", "", "()V", "invoke", "Lkorlibs/korge/ui/UIVerticalList;", "provider", "Lkorlibs/korge/ui/UIVerticalList$Provider;", "width", "", "korge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final UIVerticalList invoke(@NotNull Provider provider, @NotNull Number width2) {
            boolean $i$f$invoke = false;
            return new UIVerticalList(provider, width2.doubleValue());
        }

        public static /* synthetic */ UIVerticalList invoke$default(Companion $this, Provider provider, Number width2, int n, Object object) {
            if ((n & 2) != 0) {
                width2 = 200.0;
            }
            boolean $i$f$invoke = false;
            return new UIVerticalList(provider, width2.doubleValue());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001:\u0001\u0011J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0007H&J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH&J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0007H\u0016R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lkorlibs/korge/ui/UIVerticalList$Provider;", "", "fixedHeight", "", "getFixedHeight", "()Ljava/lang/Double;", "numItems", "", "getNumItems", "()I", "getItemHeight", "index", "getItemView", "Lkorlibs/korge/view/View;", "vlist", "Lkorlibs/korge/ui/UIVerticalList;", "getItemY", "Dummy", "korge"})
    public static interface Provider {
        public int getNumItems();

        @Nullable
        public Double getFixedHeight();

        public double getItemY(int var1);

        public double getItemHeight(int var1);

        @NotNull
        public View getItemView(int var1, @NotNull UIVerticalList var2);

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            public static double getItemY(@NotNull Provider $this, int index2) {
                Double d = $this.getFixedHeight();
                return (d != null ? d : 20.0) * (double)index2;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\tH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lkorlibs/korge/ui/UIVerticalList$Provider$Dummy;", "Lkorlibs/korge/ui/UIVerticalList$Provider;", "()V", "fixedHeight", "", "getFixedHeight", "()Ljava/lang/Double;", "Ljava/lang/Double;", "numItems", "", "getNumItems", "()I", "getItemHeight", "index", "getItemView", "Lkorlibs/korge/view/View;", "vlist", "Lkorlibs/korge/ui/UIVerticalList;", "korge"})
        public static final class Dummy
        implements Provider {
            @NotNull
            public static final Dummy INSTANCE = new Dummy();
            @Nullable
            private static final Double fixedHeight;

            private Dummy() {
            }

            @Override
            public int getNumItems() {
                return 0;
            }

            @Override
            @Nullable
            public Double getFixedHeight() {
                return fixedHeight;
            }

            @Override
            public double getItemHeight(int index2) {
                return 0.0;
            }

            @Override
            @NotNull
            public View getItemView(int index2, @NotNull UIVerticalList vlist) {
                return new DummyView();
            }

            @Override
            public double getItemY(int index2) {
                return DefaultImpls.getItemY(this, index2);
            }
        }
    }
}

