/*
 * Decompiled with CFR 0.152.
 */
package korlibs.logger;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import korlibs.logger.Console;
import korlibs.logger.DefaultLogOutput;
import korlibs.logger.LoggerKt;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u0000 =2\u00020\u0001:\u0004=>?@B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010-\u001a\u00020.2\u0006\u0010\u0014\u001a\u00020\u00132\b\u0010/\u001a\u0004\u0018\u00010\u0001H\u0001J\u0019\u00100\u001a\u00020.2\u000e\u0010/\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000101H\u0086\bJ\u0019\u00102\u001a\u00020.2\u000e\u0010/\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000101H\u0086\bJ\u0019\u00103\u001a\u00020.2\u000e\u0010/\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000101H\u0086\bJ\u0019\u00104\u001a\u00020.2\u000e\u0010/\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000101H\u0086\bJ\u000e\u00105\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0013J!\u00106\u001a\u00020.2\u0006\u0010\u0014\u001a\u00020\u00132\u000e\u0010/\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000101H\u0086\bJ4\u00107\u001a\u0002H8\"\u0004\b\u0000\u001082\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0014\u001a\u00020\u00132\f\u00109\u001a\b\u0012\u0004\u0012\u0002H801H\u0086\b\u00a2\u0006\u0002\u0010:J\u0019\u0010;\u001a\u00020.2\u000e\u0010/\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000101H\u0086\bJ\u0019\u0010<\u001a\u00020.2\u000e\u0010/\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000101H\u0086\bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u00068\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\tR\u0012\u0010\u000b\u001a\u00020\u00068\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0012\u0010\f\u001a\u00020\u00068\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\tR\u0012\u0010\r\u001a\u00020\u00068\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\tR\u0011\u0010\u000e\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\tR\u0011\u0010\u000f\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\tR\u0012\u0010\u0010\u001a\u00020\u00068\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\tR\u0012\u0010\u0011\u001a\u00020\u00068\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\tR$\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00138F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001aR\u001c\u0010!\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0016\"\u0004\b#\u0010\u0018R\u001c\u0010$\u001a\u0004\u0018\u00010%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R$\u0010*\u001a\u00020%2\u0006\u0010\u0012\u001a\u00020%8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b+\u0010'\"\u0004\b,\u0010)\u00a8\u0006A"}, d2={"Lkorlibs/logger/Logger;", "", "name", "", "normalizedName", "dummy", "", "(Ljava/lang/String;Ljava/lang/String;Z)V", "getDummy", "()Z", "isDebugEnabled", "isErrorEnabled", "isFatalEnabled", "isInfoEnabled", "isLocalLevelSet", "isLocalOutputSet", "isTraceEnabled", "isWarnEnabled", "value", "Lkorlibs/logger/Logger$Level;", "level", "getLevel", "()Lkorlibs/logger/Logger$Level;", "setLevel", "(Lkorlibs/logger/Logger$Level;)V", "getName", "()Ljava/lang/String;", "nativeLogger", "getNativeLogger", "()Ljava/lang/Object;", "setNativeLogger", "(Ljava/lang/Object;)V", "getNormalizedName", "optLevel", "getOptLevel", "setOptLevel", "optOutput", "Lkorlibs/logger/Logger$Output;", "getOptOutput", "()Lkorlibs/logger/Logger$Output;", "setOptOutput", "(Lkorlibs/logger/Logger$Output;)V", "output", "getOutput", "setOutput", "actualLog", "", "msg", "debug", "Lkotlin/Function0;", "error", "fatal", "info", "isEnabled", "log", "logTime", "T", "block", "(Ljava/lang/String;Lkorlibs/logger/Logger$Level;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "trace", "warn", "Companion", "ConsoleLogOutput", "Level", "Output", "korlibs-logger"})
@SourceDebugExtension(value={"SMAP\nLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Logger.kt\nkorlibs/logger/Logger\n+ 2 measureTime.kt\nkotlin/time/MeasureTimeKt\n*L\n1#1,172:1\n125#1:173\n125#1:174\n125#1:175\n125#1:176\n125#1:177\n125#1:178\n125#1:191\n79#2,5:179\n113#2,7:184\n*S KotlinDebug\n*F\n+ 1 Logger.kt\nkorlibs/logger/Logger\n*L\n128#1:173\n131#1:174\n134#1:175\n137#1:176\n140#1:177\n143#1:178\n147#1:191\n146#1:179,5\n146#1:184,7\n*E\n"})
public final class Logger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final String normalizedName;
    private final boolean dummy;
    @Nullable
    private Object nativeLogger;
    @Nullable
    private Level optLevel;
    @Nullable
    private Output optOutput;
    @NotNull
    private static final Object Logger_lock = new Object();
    @NotNull
    private static final HashMap<String, Logger> Logger_loggers = new HashMap();
    @Nullable
    private static Level defaultLevel;
    @NotNull
    private static Output defaultOutput;

    private Logger(String name2, String normalizedName, boolean dummy) {
        this.name = name2;
        this.normalizedName = normalizedName;
        this.dummy = dummy;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getNormalizedName() {
        return this.normalizedName;
    }

    public final boolean getDummy() {
        return this.dummy;
    }

    @Nullable
    public final Object getNativeLogger() {
        return this.nativeLogger;
    }

    public final void setNativeLogger(@Nullable Object object) {
        this.nativeLogger = object;
    }

    @Nullable
    public final Level getOptLevel() {
        return this.optLevel;
    }

    public final void setOptLevel(@Nullable Level level) {
        this.optLevel = level;
    }

    @Nullable
    public final Output getOptOutput() {
        return this.optOutput;
    }

    public final void setOptOutput(@Nullable Output output2) {
        this.optOutput = output2;
    }

    @NotNull
    public final Level getLevel() {
        Level level = this.optLevel;
        if (level == null && (level = defaultLevel) == null) {
            level = Level.WARN;
        }
        return level;
    }

    public final void setLevel(@NotNull Level value) {
        this.optLevel = value;
    }

    @NotNull
    public final Output getOutput() {
        Output output2 = this.optOutput;
        if (output2 == null) {
            output2 = defaultOutput;
        }
        return output2;
    }

    public final void setOutput(@NotNull Output value) {
        this.optOutput = value;
    }

    public final boolean isLocalLevelSet() {
        return this.optLevel != null;
    }

    public final boolean isLocalOutputSet() {
        return this.optOutput != null;
    }

    public final boolean isEnabled(@NotNull Level level) {
        return level.getIndex() <= this.getLevel().getIndex();
    }

    public final boolean isFatalEnabled() {
        boolean $i$f$isFatalEnabled = false;
        return this.isEnabled(Level.FATAL);
    }

    public final boolean isErrorEnabled() {
        boolean $i$f$isErrorEnabled = false;
        return this.isEnabled(Level.ERROR);
    }

    public final boolean isWarnEnabled() {
        boolean $i$f$isWarnEnabled = false;
        return this.isEnabled(Level.WARN);
    }

    public final boolean isInfoEnabled() {
        boolean $i$f$isInfoEnabled = false;
        return this.isEnabled(Level.INFO);
    }

    public final boolean isDebugEnabled() {
        boolean $i$f$isDebugEnabled = false;
        return this.isEnabled(Level.DEBUG);
    }

    public final boolean isTraceEnabled() {
        boolean $i$f$isTraceEnabled = false;
        return this.isEnabled(Level.TRACE);
    }

    public final void log(@NotNull Level level, @NotNull Function0<? extends Object> msg) {
        boolean $i$f$log = false;
        if (this.isEnabled(level)) {
            this.actualLog(level, msg.invoke());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void fatal(@NotNull Function0<? extends Object> msg) {
        void this_$iv;
        boolean $i$f$fatal = false;
        Logger logger2 = this;
        Level level$iv = Level.FATAL;
        boolean $i$f$log = false;
        if (this_$iv.isEnabled(level$iv)) {
            this_$iv.actualLog(level$iv, msg.invoke());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void error(@NotNull Function0<? extends Object> msg) {
        void this_$iv;
        boolean $i$f$error = false;
        Logger logger2 = this;
        Level level$iv = Level.ERROR;
        boolean $i$f$log = false;
        if (this_$iv.isEnabled(level$iv)) {
            this_$iv.actualLog(level$iv, msg.invoke());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void warn(@NotNull Function0<? extends Object> msg) {
        void this_$iv;
        boolean $i$f$warn = false;
        Logger logger2 = this;
        Level level$iv = Level.WARN;
        boolean $i$f$log = false;
        if (this_$iv.isEnabled(level$iv)) {
            this_$iv.actualLog(level$iv, msg.invoke());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void info(@NotNull Function0<? extends Object> msg) {
        void this_$iv;
        boolean $i$f$info = false;
        Logger logger2 = this;
        Level level$iv = Level.INFO;
        boolean $i$f$log = false;
        if (this_$iv.isEnabled(level$iv)) {
            this_$iv.actualLog(level$iv, msg.invoke());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void debug(@NotNull Function0<? extends Object> msg) {
        void this_$iv;
        boolean $i$f$debug = false;
        Logger logger2 = this;
        Level level$iv = Level.DEBUG;
        boolean $i$f$log = false;
        if (this_$iv.isEnabled(level$iv)) {
            this_$iv.actualLog(level$iv, msg.invoke());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void trace(@NotNull Function0<? extends Object> msg) {
        void this_$iv;
        boolean $i$f$trace = false;
        Logger logger2 = this;
        Level level$iv = Level.TRACE;
        boolean $i$f$log = false;
        if (this_$iv.isEnabled(level$iv)) {
            this_$iv.actualLog(level$iv, msg.invoke());
        }
    }

    public final <T> T logTime(@NotNull String name2, @NotNull Level level, @NotNull Function0<? extends T> block2) {
        boolean $i$f$logTime = false;
        boolean $i$f$measureTimedValue = false;
        TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTimedValue2 = false;
        long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
        T result$iv$iv = block2.invoke();
        TimedValue timedValue = new TimedValue(result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc(mark$iv$iv), null);
        Object value = timedValue.component1();
        long time = timedValue.component2-UwyO8pc();
        Logger this_$iv = this;
        boolean $i$f$log = false;
        if (this_$iv.isEnabled(level)) {
            Level level2 = level;
            Logger logger2 = this_$iv;
            boolean bl = false;
            String string = name2 + ": " + Duration.toString-impl(time);
            logger2.actualLog(level2, string);
        }
        return value;
    }

    public static /* synthetic */ Object logTime$default(Logger $this, String name2, Level level, Function0 block2, int n, Object timedValue) {
        if ((n & 2) != 0) {
            level = Level.INFO;
        }
        boolean $i$f$logTime = false;
        boolean $i$f$measureTimedValue = false;
        TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTimedValue2 = false;
        long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
        Object result$iv$iv = block2.invoke();
        timedValue = new TimedValue(result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc(mark$iv$iv), null);
        Object value = timedValue.component1();
        long time = timedValue.component2-UwyO8pc();
        Logger this_$iv = $this;
        boolean $i$f$log = false;
        if (this_$iv.isEnabled(level)) {
            Level level2 = level;
            Logger logger2 = this_$iv;
            boolean bl = false;
            String string = name2 + ": " + Duration.toString-impl(time);
            logger2.actualLog(level2, string);
        }
        return value;
    }

    @PublishedApi
    public final void actualLog(@NotNull Level level, @Nullable Object msg) {
        this.getOutput().output(this, level, msg);
    }

    public /* synthetic */ Logger(String name2, String normalizedName, boolean dummy, DefaultConstructorMarker $constructor_marker) {
        this(name2, normalizedName, dummy);
    }

    static {
        defaultOutput = DefaultLogOutput.INSTANCE;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0016\u001a\u00020\b\"\n\b\u0000\u0010\u0017\u0018\u0001*\u00020\u0001H\u0086\nJ\u0011\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0007H\u0086\u0002J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0007H\u0002R\u0012\u0010\u0003\u001a\u00060\u0001j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001a"}, d2={"Lkorlibs/logger/Logger$Companion;", "", "()V", "Logger_lock", "Lkotlinx/atomicfu/locks/SynchronizedObject;", "Logger_loggers", "Ljava/util/HashMap;", "", "Lkorlibs/logger/Logger;", "Lkotlin/collections/HashMap;", "defaultLevel", "Lkorlibs/logger/Logger$Level;", "getDefaultLevel", "()Lkorlibs/logger/Logger$Level;", "setDefaultLevel", "(Lkorlibs/logger/Logger$Level;)V", "defaultOutput", "Lkorlibs/logger/Logger$Output;", "getDefaultOutput", "()Lkorlibs/logger/Logger$Output;", "setDefaultOutput", "(Lkorlibs/logger/Logger$Output;)V", "invoke", "T", "name", "normalizeName", "korlibs-logger"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Level getDefaultLevel() {
            return defaultLevel;
        }

        public final void setDefaultLevel(@Nullable Level level) {
            defaultLevel = level;
        }

        @NotNull
        public final Output getDefaultOutput() {
            return defaultOutput;
        }

        public final void setDefaultOutput(@NotNull Output output2) {
            defaultOutput = output2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final Logger invoke(@NotNull String name2) {
            Object object = Logger_lock;
            synchronized (object) {
                boolean bl = false;
                String normalizedName = Companion.normalizeName(name2);
                if (Logger_loggers.get(normalizedName) == null) {
                    String it;
                    String string;
                    Logger logger2 = new Logger(name2, normalizedName, true, null);
                    String string2 = LoggerKt.getMiniEnvironmentVariablesUC().get("LOG_" + normalizedName);
                    if (string2 != null) {
                        it = string = string2;
                        boolean bl2 = false;
                        logger2.setLevel(Level.Companion.get(it));
                    }
                    if (Logger_loggers.isEmpty()) {
                        String string3 = LoggerKt.getMiniEnvironmentVariablesUC().get("LOG_LEVEL");
                        if (string3 != null) {
                            it = string = string3;
                            boolean bl3 = false;
                            Companion.setDefaultLevel(Level.Companion.get(it));
                        }
                    }
                    ((Map)Logger_loggers).put(normalizedName, logger2);
                }
                Object v = Logger_loggers.get(normalizedName);
                Intrinsics.checkNotNull(v);
                Logger logger3 = (Logger)v;
                return logger3;
            }
        }

        private final String normalizeName(String name2) {
            String string = StringsKt.replace$default(StringsKt.replace$default(name2, '.', '_', false, 4, null), '/', '_', false, 4, null).toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
            return string;
        }

        public final /* synthetic */ <T> Logger invoke() {
            boolean $i$f$invoke = false;
            Intrinsics.reifiedOperationMarker(4, "T");
            String string = Reflection.getOrCreateKotlinClass(Object.class).getSimpleName();
            if (string == null) {
                string = "NoClassName";
            }
            return this.invoke(string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u000b"}, d2={"Lkorlibs/logger/Logger$ConsoleLogOutput;", "Lkorlibs/logger/Logger$Output;", "()V", "output", "", "logger", "Lkorlibs/logger/Logger;", "level", "Lkorlibs/logger/Logger$Level;", "msg", "", "korlibs-logger"})
    public static final class ConsoleLogOutput
    implements Output {
        @NotNull
        public static final ConsoleLogOutput INSTANCE = new ConsoleLogOutput();

        private ConsoleLogOutput() {
        }

        @Override
        public void output(@NotNull Logger logger2, @NotNull Level level, @Nullable Object msg) {
            switch (WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
                case 1: {
                    Object[] objectArray = new Object[]{logger2.getName(), msg};
                    Console.INSTANCE.error(objectArray);
                    break;
                }
                case 2: {
                    Object[] objectArray = new Object[]{logger2.getName(), msg};
                    Console.INSTANCE.warn(objectArray);
                    break;
                }
                default: {
                    Object[] objectArray = new Object[]{logger2.getName(), msg};
                    Console.INSTANCE.log(objectArray);
                }
            }
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Level.values().length];
                try {
                    nArray[Level.ERROR.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Level.WARN.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\f\b\u0086\u0081\u0002\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000eB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000f"}, d2={"Lkorlibs/logger/Logger$Level;", "", "index", "", "(Ljava/lang/String;II)V", "getIndex", "()I", "NONE", "FATAL", "ERROR", "WARN", "INFO", "DEBUG", "TRACE", "Companion", "korlibs-logger"})
    @SourceDebugExtension(value={"SMAP\nLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Logger.kt\nkorlibs/logger/Logger$Level\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,172:1\n8541#2,2:173\n8801#2,4:175\n*S KotlinDebug\n*F\n+ 1 Logger.kt\nkorlibs/logger/Logger$Level\n*L\n82#1:173,2\n82#1:175,4\n*E\n"})
    public static final class Level
    extends Enum<Level> {
        @NotNull
        public static final Companion Companion;
        private final int index;
        @NotNull
        private static final Map<String, Level> BY_NAME;
        public static final /* enum */ Level NONE;
        public static final /* enum */ Level FATAL;
        public static final /* enum */ Level ERROR;
        public static final /* enum */ Level WARN;
        public static final /* enum */ Level INFO;
        public static final /* enum */ Level DEBUG;
        public static final /* enum */ Level TRACE;
        private static final /* synthetic */ Level[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Level(int index2) {
            this.index = index2;
        }

        public final int getIndex() {
            return this.index;
        }

        public static Level[] values() {
            return (Level[])$VALUES.clone();
        }

        public static Level valueOf(String value) {
            return Enum.valueOf(Level.class, value);
        }

        @NotNull
        public static EnumEntries<Level> getEntries() {
            return $ENTRIES;
        }

        /*
         * WARNING - void declaration
         */
        static {
            void $this$associateByTo$iv$iv;
            NONE = new Level(0);
            FATAL = new Level(1);
            ERROR = new Level(2);
            WARN = new Level(3);
            INFO = new Level(4);
            DEBUG = new Level(5);
            TRACE = new Level(6);
            $VALUES = levelArray = new Level[]{Level.NONE, Level.FATAL, Level.ERROR, Level.WARN, Level.INFO, Level.DEBUG, Level.TRACE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            Level[] $this$associateBy$iv = Level.values();
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity($this$associateBy$iv.length), 16);
            Level[] levelArray = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            int n = ((void)$this$associateByTo$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                void it;
                void element$iv$iv;
                void var9_9 = element$iv$iv = $this$associateByTo$iv$iv[j];
                Map map2 = destination$iv$iv;
                boolean bl = false;
                map2.put(it.name(), element$iv$iv);
            }
            BY_NAME = destination$iv$iv;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0005H\u0086\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lkorlibs/logger/Logger$Level$Companion;", "", "()V", "BY_NAME", "", "", "Lkorlibs/logger/Logger$Level;", "getBY_NAME", "()Ljava/util/Map;", "get", "name", "korlibs-logger"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Map<String, Level> getBY_NAME() {
                return BY_NAME;
            }

            @NotNull
            public final Level get(@NotNull String name2) {
                Map<String, Level> map2 = this.getBY_NAME();
                String string = name2.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
                Level level = map2.get(string);
                if (level == null) {
                    level = NONE;
                }
                return level;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\"\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0001H&\u00a8\u0006\t"}, d2={"Lkorlibs/logger/Logger$Output;", "", "output", "", "logger", "Lkorlibs/logger/Logger;", "level", "Lkorlibs/logger/Logger$Level;", "msg", "korlibs-logger"})
    public static interface Output {
        public void output(@NotNull Logger var1, @NotNull Level var2, @Nullable Object var3);
    }
}

