/*
 * Decompiled with CFR 0.152.
 */
package korlibs.math.geom;

import korlibs.math.geom.Sphere3D;
import korlibs.math.geom.Vector3F;
import korlibs.math.geom.shape.Shape3D;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0019\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 52\u00020\u0001:\u00015B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010#\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010'H\u00d6\u0003J\u000e\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u0000J\t\u0010*\u001a\u00020+H\u00d6\u0001J\u000e\u0010,\u001a\u00020%2\u0006\u0010-\u001a\u00020\u0000J\u000e\u0010.\u001a\u00020%2\u0006\u0010/\u001a\u000200J\u0016\u0010.\u001a\u00020%2\u0006\u00101\u001a\u00020\u00032\u0006\u00102\u001a\u00020\u000bJ\t\u00103\u001a\u000204H\u00d6\u0001R\u0014\u0010\u0006\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\bR\u0011\u0010\u0013\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\rR\u0011\u0010\u0015\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\rR\u0011\u0010\u0017\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\rR\u0011\u0010\u0019\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\rR\u0011\u0010\u001b\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\rR\u0011\u0010\u001d\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\rR\u0014\u0010\u001f\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\r\u00a8\u00066"}, d2={"Lkorlibs/math/geom/AABB3D;", "Lkorlibs/math/geom/shape/Shape3D;", "min", "Lkorlibs/math/geom/Vector3F;", "max", "(Lkorlibs/math/geom/Vector3F;Lkorlibs/math/geom/Vector3F;)V", "center", "getCenter", "()Lkorlibs/math/geom/Vector3F;", "getMax", "maxX", "", "getMaxX", "()F", "maxY", "getMaxY", "maxZ", "getMaxZ", "getMin", "minX", "getMinX", "minY", "getMinY", "minZ", "getMinZ", "sizeX", "getSizeX", "sizeY", "getSizeY", "sizeZ", "getSizeZ", "volume", "getVolume", "component1", "component2", "copy", "equals", "", "other", "", "expandedToFit", "that", "hashCode", "", "intersectsAABB", "box", "intersectsSphere", "sphere", "Lkorlibs/math/geom/Sphere3D;", "origin", "radius", "toString", "", "Companion", "korge-foundation"})
public final class AABB3D
implements Shape3D {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Vector3F min;
    @NotNull
    private final Vector3F max;

    public AABB3D(@NotNull Vector3F min, @NotNull Vector3F max) {
        this.min = min;
        this.max = max;
    }

    public /* synthetic */ AABB3D(Vector3F vector3F, Vector3F vector3F2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            vector3F = Vector3F.Companion.invoke();
        }
        if ((n & 2) != 0) {
            vector3F2 = Vector3F.Companion.invoke();
        }
        this(vector3F, vector3F2);
    }

    @NotNull
    public final Vector3F getMin() {
        return this.min;
    }

    @NotNull
    public final Vector3F getMax() {
        return this.max;
    }

    public final float getMinX() {
        return this.min.getX();
    }

    public final float getMinY() {
        return this.min.getY();
    }

    public final float getMinZ() {
        return this.min.getZ();
    }

    public final float getMaxX() {
        return this.max.getX();
    }

    public final float getMaxY() {
        return this.max.getY();
    }

    public final float getMaxZ() {
        return this.max.getZ();
    }

    public final float getSizeX() {
        return this.getMaxX() - this.getMinX();
    }

    public final float getSizeY() {
        return this.getMaxY() - this.getMinY();
    }

    public final float getSizeZ() {
        return this.getMaxZ() - this.getMinZ();
    }

    @NotNull
    public final AABB3D expandedToFit(@NotNull AABB3D that) {
        AABB3D a = this;
        AABB3D b = that;
        return new AABB3D(new Vector3F(Math.min(a.getMinX(), b.getMinX()), Math.min(a.getMinY(), b.getMinY()), Math.min(a.getMinZ(), b.getMinZ())), new Vector3F(Math.max(a.getMaxX(), b.getMaxX()), Math.max(a.getMaxY(), b.getMaxY()), Math.max(a.getMaxZ(), b.getMaxZ())));
    }

    public final boolean intersectsSphere(@NotNull Sphere3D sphere) {
        return this.intersectsSphere(sphere.getCenter(), sphere.getRadius());
    }

    public final boolean intersectsSphere(@NotNull Vector3F origin2, float radius2) {
        return !(origin2.getX() + radius2 < this.getMinX() || origin2.getY() + radius2 < this.getMinY() || origin2.getZ() + radius2 < this.getMinZ() || origin2.getX() - radius2 > this.getMaxX() || origin2.getY() - radius2 > this.getMaxY() || origin2.getZ() - radius2 > this.getMaxZ());
    }

    public final boolean intersectsAABB(@NotNull AABB3D box2) {
        return this.max.getX() > box2.min.getX() && this.min.getX() < box2.max.getX() && this.max.getY() > box2.min.getY() && this.min.getY() < box2.max.getY() && this.max.getZ() > box2.min.getZ() && this.min.getZ() < box2.max.getZ();
    }

    @Override
    @NotNull
    public Vector3F getCenter() {
        return this.min.plus(this.max).times(0.5f);
    }

    @Override
    public float getVolume() {
        Vector3F v = this.max.minus(this.min);
        return v.getX() * v.getY() * v.getZ();
    }

    @NotNull
    public final Vector3F component1() {
        return this.min;
    }

    @NotNull
    public final Vector3F component2() {
        return this.max;
    }

    @NotNull
    public final AABB3D copy(@NotNull Vector3F min, @NotNull Vector3F max) {
        return new AABB3D(min, max);
    }

    public static /* synthetic */ AABB3D copy$default(AABB3D aABB3D, Vector3F vector3F, Vector3F vector3F2, int n, Object object) {
        if ((n & 1) != 0) {
            vector3F = aABB3D.min;
        }
        if ((n & 2) != 0) {
            vector3F2 = aABB3D.max;
        }
        return aABB3D.copy(vector3F, vector3F2);
    }

    @NotNull
    public String toString() {
        return "AABB3D(min=" + this.min + ", max=" + this.max + ")";
    }

    public int hashCode() {
        int result2 = this.min.hashCode();
        result2 = result2 * 31 + this.max.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AABB3D)) {
            return false;
        }
        AABB3D aABB3D = (AABB3D)other;
        if (!Intrinsics.areEqual(this.min, aABB3D.min)) {
            return false;
        }
        return Intrinsics.areEqual(this.max, aABB3D.max);
    }

    public AABB3D() {
        this(null, null, 3, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001d\u0010\t\u001a\u00020\u00042\b\b\u0002\u0010\n\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\bH\u0086\u0002\u00a8\u0006\f"}, d2={"Lkorlibs/math/geom/AABB3D$Companion;", "", "()V", "fromSphere", "Lkorlibs/math/geom/AABB3D;", "pos", "Lkorlibs/math/geom/Vector3F;", "radius", "", "invoke", "min", "max", "korge-foundation"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AABB3D invoke(float min, float max) {
            return new AABB3D(new Vector3F(min, min, min), new Vector3F(max, max, max));
        }

        public static /* synthetic */ AABB3D invoke$default(Companion companion, float f, float f2, int n, Object object) {
            if ((n & 1) != 0) {
                f = Float.POSITIVE_INFINITY;
            }
            if ((n & 2) != 0) {
                f2 = Float.NEGATIVE_INFINITY;
            }
            return companion.invoke(f, f2);
        }

        @NotNull
        public final AABB3D fromSphere(@NotNull Vector3F pos, float radius2) {
            return new AABB3D(new Vector3F(pos.getX() - radius2, pos.getY() - radius2, pos.getZ() - radius2), new Vector3F(pos.getX() + radius2, pos.getY() + radius2, pos.getZ() + radius2));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

