/*
 * Decompiled with CFR 0.152.
 */
package korlibs.math.geom;

import korlibs.math.geom.Angle;
import korlibs.math.geom.AngleKt;
import korlibs.math.geom.Vector2D;
import korlibs.math.geom.shape.AbstractShape2D;
import korlibs.math.geom.vector.VectorPath;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 +2\u00020\u0001:\u0001+B\u0019\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\r\u0010\u0018\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0006H\u00c6\u0003J\u0014\u0010\u001a\u001a\u00020\u001b2\n\u0010\u001c\u001a\u00060\u0003j\u0002`\u0004H\u0016J!\u0010\u001d\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0014\u0010\u001e\u001a\u00020\u00062\n\u0010\u001c\u001a\u00060\u0003j\u0002`\u0004H\u0016J\u0012\u0010\u001f\u001a\u00020\u00062\n\u0010\u001c\u001a\u00060\u0003j\u0002`\u0004J\u0012\u0010 \u001a\u00020\u00062\n\u0010\u001c\u001a\u00060\u0003j\u0002`\u0004J\u0012\u0010!\u001a\u00020\u00062\n\u0010\u001c\u001a\u00060\u0003j\u0002`\u0004J\u0013\u0010\"\u001a\u00020\u001b2\b\u0010#\u001a\u0004\u0018\u00010$H\u00d6\u0003J\t\u0010%\u001a\u00020&H\u00d6\u0001J\u0014\u0010'\u001a\u00020\u00032\n\u0010\u001c\u001a\u00060\u0003j\u0002`\u0004H\u0016J\u0018\u0010(\u001a\u00060\u0003j\u0002`\u00042\n\u0010\u001c\u001a\u00060\u0003j\u0002`\u0004H\u0016J\t\u0010)\u001a\u00020*H\u00d6\u0001R\u0014\u0010\b\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0018\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\r\u001a\u00020\u000e8TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0013\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\nR\u0011\u0010\u0016\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\n\u00a8\u0006,"}, d2={"Lkorlibs/math/geom/Circle;", "Lkorlibs/math/geom/shape/AbstractShape2D;", "center", "Lkorlibs/math/geom/Vector2D;", "Lkorlibs/math/geom/Point;", "radius", "", "(Lkorlibs/math/geom/Vector2D;D)V", "area", "getArea", "()D", "getCenter", "()Lkorlibs/math/geom/Vector2D;", "lazyVectorPath", "Lkorlibs/math/geom/vector/VectorPath;", "getLazyVectorPath", "()Lkorlibs/math/geom/vector/VectorPath;", "lazyVectorPath$delegate", "Lkotlin/Lazy;", "perimeter", "getPerimeter", "getRadius", "radiusSquared", "getRadiusSquared", "component1", "component2", "containsPoint", "", "p", "copy", "distance", "distanceClosestSquared", "distanceFarthestSquared", "distanceToCenterSquared", "equals", "other", "", "hashCode", "", "normalVectorAt", "projectedPoint", "toString", "", "Companion", "korge-foundation"})
@SourceDebugExtension(value={"SMAP\n_MathGeomShapes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 _MathGeomShapes.kt\nkorlibs/math/geom/Circle\n+ 2 VectorsDouble.kt\nkorlibs/math/geom/Vector2D\n+ 3 Angle.kt\nkorlibs/math/geom/Angle$Companion\n+ 4 VectorsDouble.kt\nkorlibs/math/geom/Vector2D$Companion\n*L\n1#1,130:1\n43#2:131\n43#2:132\n43#2:137\n200#3:133\n195#3:134\n169#4:135\n168#4:136\n*S KotlinDebug\n*F\n+ 1 _MathGeomShapes.kt\nkorlibs/math/geom/Circle\n*L\n18#1:131\n19#1:132\n29#1:137\n28#1:133\n28#1:134\n28#1:135\n28#1:136\n*E\n"})
public final class Circle
extends AbstractShape2D {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Vector2D center;
    private final double radius;
    @NotNull
    private final Lazy lazyVectorPath$delegate;

    public Circle(@NotNull Vector2D center, double radius2) {
        this.center = center;
        this.radius = radius2;
        this.lazyVectorPath$delegate = LazyKt.lazy((Function0)new Function0<VectorPath>(this){
            final /* synthetic */ Circle this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final VectorPath invoke() {
                VectorPath vectorPath;
                Circle circle2 = this.this$0;
                VectorPath out$iv = new VectorPath(null, null, null, false, 15, null);
                boolean $i$f$buildVectorPath = false;
                VectorPath $this$invoke_u24lambda_u240 = vectorPath = out$iv;
                boolean bl = false;
                $this$invoke_u24lambda_u240.circle(circle2.getCenter(), circle2.getRadius());
                return vectorPath;
            }
        });
    }

    @Override
    @NotNull
    public Vector2D getCenter() {
        return this.center;
    }

    public final double getRadius() {
        return this.radius;
    }

    @Override
    @NotNull
    protected VectorPath getLazyVectorPath() {
        Lazy lazy = this.lazyVectorPath$delegate;
        return (VectorPath)lazy.getValue();
    }

    @Override
    public double getArea() {
        return Math.PI * this.radius * this.radius;
    }

    @Override
    public double getPerimeter() {
        return Math.PI * 2 * this.radius;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double distance(@NotNull Vector2D p) {
        void this_$iv;
        Vector2D vector2D = p;
        Vector2D that$iv = this.getCenter();
        boolean $i$f$minus = false;
        return new Vector2D(this_$iv.getX() - that$iv.getX(), this_$iv.getY() - that$iv.getY()).getLength() - this.radius;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Vector2D normalVectorAt(@NotNull Vector2D p) {
        void this_$iv;
        Vector2D vector2D = p;
        Vector2D that$iv = this.getCenter();
        boolean $i$f$minus = false;
        return new Vector2D(this_$iv.getX() - that$iv.getX(), this_$iv.getY() - that$iv.getY()).getNormalized();
    }

    public final double getRadiusSquared() {
        return this.radius * this.radius;
    }

    public final double distanceToCenterSquared(@NotNull Vector2D p) {
        return Vector2D.Companion.distanceSquared(p, this.getCenter());
    }

    public final double distanceClosestSquared(@NotNull Vector2D p) {
        return this.distanceToCenterSquared(p) - this.getRadiusSquared();
    }

    public final double distanceFarthestSquared(@NotNull Vector2D p) {
        return this.distanceToCenterSquared(p) + this.getRadiusSquared();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Vector2D projectedPoint(@NotNull Vector2D p) {
        void angle$iv;
        void x$iv$iv;
        void base$iv;
        void $this$iv;
        void x1$iv$iv;
        double y0$iv$iv;
        void x0$iv$iv;
        void $this$iv22;
        Vector2D.Companion companion = Vector2D.Companion;
        Vector2D vector2D = this.getCenter();
        Angle.Companion companion2 = Angle.Companion;
        Vector2D p0$iv = this.getCenter();
        Vector2D up$iv = Vector2D.Companion.getUP();
        boolean bl = false;
        void var8_10 = $this$iv22;
        double d = p0$iv.getX();
        double d2 = p0$iv.getY();
        double d3 = p.getX();
        double y1$iv$iv = p.getY();
        boolean bl2 = false;
        double $this$iv22 = AngleKt.Angle_between((double)x0$iv$iv, y0$iv$iv, (double)x1$iv$iv, y1$iv$iv, up$iv);
        double length$iv = this.radius;
        Vector2D up$iv2 = $this$iv.getUP();
        boolean bl3 = false;
        void var10_18 = $this$iv;
        y0$iv$iv = base$iv.getX();
        double y$iv$iv = base$iv.getY();
        boolean bl4 = false;
        return new Vector2D((double)(x$iv$iv + Angle.cosine-impl((double)angle$iv, up$iv2) * length$iv), y$iv$iv + Angle.sine-impl((double)angle$iv, up$iv2) * length$iv);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsPoint(@NotNull Vector2D p) {
        void this_$iv;
        Vector2D vector2D = p;
        Vector2D that$iv = this.getCenter();
        boolean $i$f$minus = false;
        return new Vector2D(this_$iv.getX() - that$iv.getX(), this_$iv.getY() - that$iv.getY()).getLength() <= this.radius;
    }

    @NotNull
    public final Vector2D component1() {
        return this.center;
    }

    public final double component2() {
        return this.radius;
    }

    @NotNull
    public final Circle copy(@NotNull Vector2D center, double radius2) {
        return new Circle(center, radius2);
    }

    public static /* synthetic */ Circle copy$default(Circle circle2, Vector2D vector2D, double d, int n, Object object) {
        if ((n & 1) != 0) {
            vector2D = circle2.center;
        }
        if ((n & 2) != 0) {
            d = circle2.radius;
        }
        return circle2.copy(vector2D, d);
    }

    @NotNull
    public String toString() {
        return "Circle(center=" + this.center + ", radius=" + this.radius + ")";
    }

    public int hashCode() {
        int result2 = this.center.hashCode();
        result2 = result2 * 31 + Double.hashCode(this.radius);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Circle)) {
            return false;
        }
        Circle circle2 = (Circle)other;
        if (!Intrinsics.areEqual(this.center, circle2.center)) {
            return false;
        }
        return Double.compare(this.radius, circle2.radius) == 0;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\b\u001a\u00020\tH\u0086\nJ!\u0010\u0003\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0086\n\u00a8\u0006\f"}, d2={"Lkorlibs/math/geom/Circle$Companion;", "", "()V", "invoke", "Lkorlibs/math/geom/Circle;", "center", "Lkorlibs/math/geom/Vector2D;", "Lkorlibs/math/geom/Point;", "radius", "", "x", "y", "korge-foundation"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Circle invoke(@NotNull Vector2D center, @NotNull Number radius2) {
            boolean $i$f$invoke = false;
            return new Circle(center, radius2.doubleValue());
        }

        @NotNull
        public final Circle invoke(@NotNull Number x, @NotNull Number y, @NotNull Number radius2) {
            boolean $i$f$invoke = false;
            return new Circle(new Vector2D(x.doubleValue(), y.doubleValue()), radius2.doubleValue());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

