/*
 * Decompiled with CFR 0.152.
 */
package korlibs.math.geom;

import korlibs.datastructure.Extra;
import korlibs.math.IsAlmostEquals;
import korlibs.math.IsAlmostZeroKt;
import korlibs.math.geom.GenericDoubleVector;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002J\u0019\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bH\u00a6\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\bH\u0016J\u0018\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u000eH\u0016J\b\u0010\u0016\u001a\u00020\u0004H\u0016J\b\u0010\u0017\u001a\u00020\u0004H\u0016R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\u0082\u0001\u0002\u0018\u0019\u00a8\u0006\u001a"}, d2={"Lkorlibs/math/geom/DoubleVectorList;", "Lkorlibs/datastructure/Extra;", "Lkorlibs/math/IsAlmostEquals;", "closed", "", "getClosed", "()Z", "dimensions", "", "getDimensions", "()I", "size", "getSize", "get", "", "index", "dim", "getGeneric", "Lkorlibs/math/geom/GenericDoubleVector;", "isAlmostEquals", "other", "epsilon", "isEmpty", "isNotEmpty", "Lkorlibs/math/geom/DoubleVectorArrayList;", "Lkorlibs/math/geom/PointList;", "korge-foundation"})
public interface DoubleVectorList
extends Extra,
IsAlmostEquals<DoubleVectorList> {
    public boolean isEmpty();

    public boolean isNotEmpty();

    public boolean getClosed();

    public int getSize();

    public int getDimensions();

    public double get(int var1, int var2);

    @NotNull
    public GenericDoubleVector getGeneric(int var1);

    @Override
    public boolean isAlmostEquals(@NotNull DoubleVectorList var1, double var2);

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static boolean isEmpty(@NotNull DoubleVectorList $this) {
            return $this.getSize() == 0;
        }

        public static boolean isNotEmpty(@NotNull DoubleVectorList $this) {
            return $this.getSize() != 0;
        }

        @NotNull
        public static GenericDoubleVector getGeneric(@NotNull DoubleVectorList $this, int index2) {
            int n = 0;
            int n2 = $this.getDimensions();
            double[] dArray = new double[n2];
            int n3 = $this.getDimensions();
            while (n < n2) {
                int n4 = n++;
                dArray[n4] = $this.get(index2, n4);
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n5 = 4;
            int n6 = 0;
            double[] dArray2 = dArray;
            int n7 = n3;
            return new GenericDoubleVector(n7, dArray2, n6, n5, defaultConstructorMarker);
        }

        public static boolean isAlmostEquals(@NotNull DoubleVectorList $this, @NotNull DoubleVectorList other, double epsilon) {
            if ($this.getSize() != other.getSize()) {
                return false;
            }
            if ($this.getDimensions() != other.getDimensions()) {
                return false;
            }
            int n = $this.getDimensions();
            for (int dim = 0; dim < n; ++dim) {
                int n2 = $this.getSize();
                for (int n3 = 0; n3 < n2; ++n3) {
                    if (IsAlmostZeroKt.isAlmostEquals($this.get(n3, dim), other.get(n3, dim), epsilon)) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

