/*
 * Decompiled with CFR 0.152.
 */
package korlibs.math.geom;

import korlibs.math.geom.Angle;
import korlibs.math.geom.AngleKt;
import korlibs.math.geom.Matrix;
import korlibs.math.geom.PointList;
import korlibs.math.geom.RectangleD;
import korlibs.math.geom.Size2D;
import korlibs.math.geom.Vector2D;
import korlibs.math.geom.Vector2F;
import korlibs.math.geom.shape.Shape2D;
import korlibs.math.geom.vector.VectorPath;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 %2\u00020\u0001:\u0001%B\u001d\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\u0002\u0010\bJ\r\u0010\u0013\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0003J\r\u0010\u0014\u001a\u00060\u0006j\u0002`\u0007H\u00c6\u0003J\u0014\u0010\u0015\u001a\u00020\u00162\n\u0010\u0017\u001a\u00060\u0003j\u0002`\u0004H\u0016J%\u0010\u0018\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\f\b\u0002\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007H\u00c6\u0001J\u0014\u0010\u0019\u001a\u00020\n2\n\u0010\u0017\u001a\u00060\u0003j\u0002`\u0004H\u0016J\u0013\u0010\u001a\u001a\u00020\u00162\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\u0014\u0010\u001f\u001a\u00020\u00032\n\u0010\u0017\u001a\u00060\u0003j\u0002`\u0004H\u0016J\u0018\u0010 \u001a\u00060\u0003j\u0002`\u00042\n\u0010\u0017\u001a\u00060\u0003j\u0002`\u0004H\u0016J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\b\u0010#\u001a\u00020$H\u0016R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\fR\u0015\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006&"}, d2={"Lkorlibs/math/geom/Ellipse;", "Lkorlibs/math/geom/shape/Shape2D;", "center", "Lkorlibs/math/geom/Vector2D;", "Lkorlibs/math/geom/Point;", "radius", "Lkorlibs/math/geom/Size2D;", "Lkorlibs/math/geom/Size;", "(Lkorlibs/math/geom/Vector2D;Lkorlibs/math/geom/Size2D;)V", "area", "", "getArea", "()D", "getCenter", "()Lkorlibs/math/geom/Vector2D;", "perimeter", "getPerimeter", "getRadius", "()Lkorlibs/math/geom/Size2D;", "component1", "component2", "containsPoint", "", "p", "copy", "distance", "equals", "other", "", "hashCode", "", "normalVectorAt", "projectedPoint", "toString", "", "toVectorPath", "Lkorlibs/math/geom/vector/VectorPath;", "Companion", "korge-foundation"})
@SourceDebugExtension(value={"SMAP\n_MathGeomShapes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 _MathGeomShapes.kt\nkorlibs/math/geom/Ellipse\n+ 2 VectorsDouble.kt\nkorlibs/math/geom/Vector2D\n+ 3 Angle.kt\nkorlibs/math/geom/Angle$Companion\n+ 4 _MathGeom.shape.kt\nkorlibs/math/geom/shape/_MathGeom_shapeKt\n*L\n1#1,130:1\n43#2:131\n43#2:132\n42#2:135\n200#3:133\n195#3:134\n51#4:136\n*S KotlinDebug\n*F\n+ 1 _MathGeomShapes.kt\nkorlibs/math/geom/Ellipse\n*L\n42#1:131\n49#1:132\n60#1:135\n59#1:133\n59#1:134\n73#1:136\n*E\n"})
public final class Ellipse
implements Shape2D {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Vector2D center;
    @NotNull
    private final Size2D radius;

    public Ellipse(@NotNull Vector2D center, @NotNull Size2D radius2) {
        this.center = center;
        this.radius = radius2;
    }

    @Override
    @NotNull
    public Vector2D getCenter() {
        return this.center;
    }

    @NotNull
    public final Size2D getRadius() {
        return this.radius;
    }

    @Override
    public double getArea() {
        return Math.PI * this.radius.getWidth() * this.radius.getHeight();
    }

    @Override
    public double getPerimeter() {
        if (this.radius.getWidth() == this.radius.getHeight()) {
            return Math.PI * 2 * this.radius.getWidth();
        }
        Size2D size2D = this.radius;
        double a = size2D.component1();
        double b = size2D.component2();
        double h = (a - b) * (a - b) / ((a + b) * (a + b));
        return Math.PI * (a + b) * (1.0 + (double)3 * h / ((double)10 + Math.sqrt((double)4 - (double)3 * h)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double distance(@NotNull Vector2D p) {
        void this_$iv;
        Vector2D vector2D = p;
        Vector2D that$iv = this.getCenter();
        boolean $i$f$minus = false;
        Vector2D p2 = new Vector2D(this_$iv.getX() - that$iv.getX(), this_$iv.getY() - that$iv.getY());
        Vector2D scaledPoint = new Vector2D(p2.getX() / this.radius.getWidth(), p2.getY() / this.radius.getHeight());
        double length2 = scaledPoint.getLength();
        return (length2 - 1.0) * Math.min(this.radius.getWidth(), this.radius.getHeight());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Vector2D normalVectorAt(@NotNull Vector2D p) {
        void this_$iv;
        Object object = p;
        Vector2D that$iv = this.getCenter();
        boolean $i$f$minus = false;
        Vector2D pointOnEllipse = new Vector2D(this_$iv.getX() - that$iv.getX(), this_$iv.getY() - that$iv.getY());
        object = this.radius;
        double a = ((Size2D)object).component1();
        double b = ((Size2D)object).component2();
        Vector2D normal2 = new Vector2D(pointOnEllipse.getX() / (a * a), pointOnEllipse.getY() / (b * b));
        return normal2.getNormalized();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Vector2D projectedPoint(@NotNull Vector2D p) {
        void this_$iv;
        void x1$iv$iv;
        void y0$iv$iv;
        void x0$iv$iv;
        Vector2D $this$iv;
        Angle.Companion companion = Angle.Companion;
        Vector2D p0$iv = this.getCenter();
        Vector2D up$iv = Vector2D.Companion.getUP();
        boolean bl = false;
        void var8_7 = $this$iv;
        double d = p0$iv.getX();
        double d2 = p0$iv.getY();
        double d3 = p.getX();
        double y1$iv$iv = p.getY();
        boolean bl2 = false;
        double angle = AngleKt.Angle_between((double)x0$iv$iv, (double)y0$iv$iv, (double)x1$iv$iv, y1$iv$iv, up$iv);
        $this$iv = this.getCenter();
        Vector2D that$iv = new Vector2D(this.radius.getWidth() * Angle.getCosine-impl(angle), this.radius.getHeight() * Angle.getSine-impl(angle));
        boolean $i$f$plus = false;
        return new Vector2D(this_$iv.getX() + that$iv.getX(), this_$iv.getY() + that$iv.getY());
    }

    @Override
    public boolean containsPoint(@NotNull Vector2D p) {
        if (this.radius.isEmpty()) {
            return false;
        }
        return Math.pow(p.getX() - this.getCenter().getX(), 2) / Math.pow(this.radius.getWidth(), 2) + Math.pow(p.getY() - this.getCenter().getY(), 2) / Math.pow(this.radius.getHeight(), 2) <= 1.0;
    }

    @Override
    @NotNull
    public VectorPath toVectorPath() {
        VectorPath vectorPath;
        VectorPath out$iv = new VectorPath(null, null, null, false, 15, null);
        boolean $i$f$buildVectorPath = false;
        VectorPath $this$toVectorPath_u24lambda_u240 = vectorPath = out$iv;
        boolean bl = false;
        $this$toVectorPath_u24lambda_u240.ellipse(this.getCenter(), this.radius);
        return vectorPath;
    }

    @Override
    @Deprecated(message="Untested yet")
    public double distance(@NotNull Matrix ml, @NotNull Vector2D p, @NotNull Matrix mr) {
        return Shape2D.DefaultImpls.distance(this, ml, p, mr);
    }

    @Override
    @Deprecated(message="Untested yet")
    @NotNull
    public Vector2D normalVectorAt(@NotNull Matrix ml, @NotNull Vector2D p, @NotNull Matrix mr) {
        return Shape2D.DefaultImpls.normalVectorAt(this, ml, p, mr);
    }

    @Override
    @Deprecated(message="Untested yet")
    @NotNull
    public Vector2D projectedPoint(@NotNull Matrix ml, @NotNull Vector2D p, @NotNull Matrix mr) {
        return Shape2D.DefaultImpls.projectedPoint(this, ml, p, mr);
    }

    @Override
    @Deprecated(message="Untested yet")
    public boolean containsPoint(@NotNull Matrix ml, @NotNull Vector2D p, @NotNull Matrix mr) {
        return Shape2D.DefaultImpls.containsPoint(this, ml, p, mr);
    }

    @Override
    public boolean getClosed() {
        return Shape2D.DefaultImpls.getClosed(this);
    }

    @Override
    @NotNull
    public RectangleD getBounds() {
        return Shape2D.DefaultImpls.getBounds(this);
    }

    @Override
    @NotNull
    public PointList intersectionsWith(@NotNull Shape2D that) {
        return Shape2D.DefaultImpls.intersectionsWith(this, that);
    }

    @Override
    @NotNull
    public PointList intersectionsWith(@NotNull Matrix ml, @NotNull Shape2D that, @NotNull Matrix mr) {
        return Shape2D.DefaultImpls.intersectionsWith(this, ml, that, mr);
    }

    @Override
    public boolean intersectsWith(@NotNull Shape2D that) {
        return Shape2D.DefaultImpls.intersectsWith(this, that);
    }

    @Override
    public boolean intersectsWith(@NotNull Matrix ml, @NotNull Shape2D that, @NotNull Matrix mr) {
        return Shape2D.DefaultImpls.intersectsWith(this, ml, that, mr);
    }

    @NotNull
    public final Vector2D component1() {
        return this.center;
    }

    @NotNull
    public final Size2D component2() {
        return this.radius;
    }

    @NotNull
    public final Ellipse copy(@NotNull Vector2D center, @NotNull Size2D radius2) {
        return new Ellipse(center, radius2);
    }

    public static /* synthetic */ Ellipse copy$default(Ellipse ellipse2, Vector2D vector2D, Size2D size2D, int n, Object object) {
        if ((n & 1) != 0) {
            vector2D = ellipse2.center;
        }
        if ((n & 2) != 0) {
            size2D = ellipse2.radius;
        }
        return ellipse2.copy(vector2D, size2D);
    }

    @NotNull
    public String toString() {
        return "Ellipse(center=" + this.center + ", radius=" + this.radius + ")";
    }

    public int hashCode() {
        int result2 = this.center.hashCode();
        result2 = result2 * 31 + this.radius.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Ellipse)) {
            return false;
        }
        Ellipse ellipse2 = (Ellipse)other;
        if (!Intrinsics.areEqual(this.center, ellipse2.center)) {
            return false;
        }
        return Intrinsics.areEqual(this.radius, ellipse2.radius);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lkorlibs/math/geom/Ellipse$Companion;", "", "()V", "projectPointOntoEllipse", "Lkorlibs/math/geom/Vector2F;", "point", "center", "radius", "tolerance", "", "maxIterations", "", "korge-foundation"})
    @SourceDebugExtension(value={"SMAP\n_MathGeomShapes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 _MathGeomShapes.kt\nkorlibs/math/geom/Ellipse$Companion\n+ 2 VectorsFloat.kt\nkorlibs/math/geom/Vector2F\n*L\n1#1,130:1\n56#2:131\n52#2:132\n52#2:133\n*S KotlinDebug\n*F\n+ 1 _MathGeomShapes.kt\nkorlibs/math/geom/Ellipse$Companion\n*L\n96#1:131\n96#1:132\n97#1:133\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final Vector2F projectPointOntoEllipse(Vector2F point2, Vector2F center, Vector2F radius2, double tolerance, int maxIterations) {
            Vector2F currentPoint = point2;
            for (int i2 = 0; i2 < maxIterations; ++i2) {
                void that$iv;
                void this_$iv;
                Vector2F nextPoint;
                float dx = currentPoint.getX() - center.getX();
                float dy = currentPoint.getY() - center.getY();
                float rx2 = radius2.getX() * radius2.getX();
                float ry2 = radius2.getY() * radius2.getY();
                Vector2F f = new Vector2F((dx * rx2 - dy * dx * dy) / (rx2 * ry2), (dy * ry2 - dx * dy * dx) / (rx2 * ry2));
                Vector2F df = new Vector2F(((double)ry2 - 2.0 * (double)dy * (double)dy) / (double)(rx2 * ry2), ((double)rx2 - 2.0 * (double)dx * (double)dx) / (double)(rx2 * ry2));
                Vector2F vector2F = currentPoint;
                Vector2F this_$iv2 = f;
                boolean $i$f$div = false;
                this_$iv2 = new Vector2F(this_$iv2.getX() / df.getX(), this_$iv2.getY() / df.getY());
                boolean $i$f$minus = false;
                this_$iv2 = nextPoint = new Vector2F(this_$iv.getX() - that$iv.getX(), this_$iv.getY() - that$iv.getY());
                $i$f$minus = false;
                float dist = new Vector2F(this_$iv2.getX() - currentPoint.getX(), this_$iv2.getY() - currentPoint.getY()).getLength();
                if ((double)dist < tolerance) {
                    return nextPoint;
                }
                currentPoint = nextPoint;
            }
            return currentPoint;
        }

        static /* synthetic */ Vector2F projectPointOntoEllipse$default(Companion companion, Vector2F vector2F, Vector2F vector2F2, Vector2F vector2F3, double d, int n, int n2, Object object) {
            if ((n2 & 8) != 0) {
                d = 1.0E-6;
            }
            if ((n2 & 0x10) != 0) {
                n = 100;
            }
            return companion.projectPointOntoEllipse(vector2F, vector2F2, vector2F3, d, n);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

