/*
 * Decompiled with CFR 0.152.
 */
package korlibs.math.geom;

import korlibs.math.ClampKt;
import korlibs.math.IsAlmostZeroKt;
import korlibs.math.MathKt;
import korlibs.math.annotations.KormaExperimental;
import korlibs.math.geom.Angle;
import korlibs.math.geom.AngleKt;
import korlibs.math.geom.Matrix;
import korlibs.math.geom.PointList;
import korlibs.math.geom.Ray2D;
import korlibs.math.geom.RectangleD;
import korlibs.math.geom.Vector2D;
import korlibs.math.geom.VectorsDoubleKt;
import korlibs.math.geom.bezier.Bezier;
import korlibs.math.geom.shape.Shape2D;
import korlibs.math.geom.vector.VectorPath;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b,\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 k2\u00020\u0001:\u0001kB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B'\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\bB'\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\t\u0012\u0006\u0010\u0005\u001a\u00020\t\u0012\u0006\u0010\u0006\u001a\u00020\t\u0012\u0006\u0010\u0007\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB'\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u000b\u0012\u0006\u0010\u0005\u001a\u00020\u000b\u0012\u0006\u0010\u0006\u001a\u00020\u000b\u0012\u0006\u0010\u0007\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB\u0015\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0010J\t\u0010B\u001a\u00020\u000eH\u00c6\u0003J\t\u0010C\u001a\u00020\u000eH\u00c6\u0003J\u0016\u0010D\u001a\u00020\"2\u0006\u0010E\u001a\u00020\u00042\u0006\u0010F\u001a\u00020\u0004J\u0014\u0010G\u001a\u00020\"2\n\u0010H\u001a\u00060\u000ej\u0002`\u001bH\u0016J\u000e\u0010I\u001a\u00020\"2\u0006\u0010E\u001a\u00020\u0004J\u000e\u0010J\u001a\u00020\"2\u0006\u0010F\u001a\u00020\u0004J\u001d\u0010K\u001a\u00020\u00002\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000eH\u00c6\u0001J\n\u0010L\u001a\u00060\u000ej\u0002`\u001bJ\u0013\u0010M\u001a\u00020\"2\b\u0010N\u001a\u0004\u0018\u00010OH\u00d6\u0003J\r\u0010P\u001a\u00060\u0000j\u0002`QH\u0086\bJ\u001a\u0010R\u001a\n\u0018\u00010\u000ej\u0004\u0018\u0001`\u001b2\n\u0010S\u001a\u00060\u0000j\u0002`QJ\u001a\u0010T\u001a\n\u0018\u00010\u000ej\u0004\u0018\u0001`\u001b2\n\u0010S\u001a\u00060\u0000j\u0002`QJ\u0012\u0010U\u001a\u00020\u00042\n\u0010H\u001a\u00060\u000ej\u0002`\u001bJ\u001a\u0010V\u001a\n\u0018\u00010\u000ej\u0004\u0018\u0001`\u001b2\n\u0010S\u001a\u00060\u0000j\u0002`QJ\t\u0010W\u001a\u00020\u000bH\u00d6\u0001J\u0012\u0010X\u001a\u00020\"2\n\u0010S\u001a\u00060\u0000j\u0002`QJ\u0012\u0010Y\u001a\u00020\"2\n\u0010S\u001a\u00060\u0000j\u0002`QJ\u0012\u0010Z\u001a\u00020\"2\n\u0010S\u001a\u00060\u0000j\u0002`QJ\u0006\u0010[\u001a\u00020\"J\u0014\u0010\\\u001a\u00020\u000e2\n\u0010H\u001a\u00060\u000ej\u0002`\u001bH\u0016J\u0018\u0010]\u001a\u00060\u000ej\u0002`\u001b2\n\u0010H\u001a\u00060\u000ej\u0002`\u001bH\u0016J\u0016\u0010^\u001a\u00060\u000ej\u0002`\u001b2\n\u0010H\u001a\u00060\u000ej\u0002`\u001bJ\n\u0010_\u001a\u00060\u0000j\u0002`QJ\u0014\u0010`\u001a\u00060\u0000j\u0002`Q2\u0006\u0010a\u001a\u00020\u0004H\u0007J\u0006\u0010b\u001a\u00020cJ\n\u0010d\u001a\u00060ej\u0002`fJ\b\u0010g\u001a\u00020hH\u0016J\b\u0010i\u001a\u00020jH\u0016R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\u00020\u00148F\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016R\u0011\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0012R\u0018\u0010\u001a\u001a\u00060\u000ej\u0002`\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0012R\u0011\u0010\u001d\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0016R\u0011\u0010\u001f\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0016R\u0011\u0010!\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010#R\u0011\u0010$\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0016R\u0011\u0010&\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0016R\u0015\u0010(\u001a\u00060\u000ej\u0002`\u001b8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0012R\u0011\u0010*\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0016R\u0011\u0010,\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0016R\u0015\u0010.\u001a\u00060\u000ej\u0002`\u001b8F\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u0012R\u0011\u00100\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u0016R\u0011\u00102\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u0016R\u0014\u00104\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u0010\u0016R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b6\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b7\u0010\u0016R\u0011\u00108\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b9\u0010\u0016R\u0011\u0010:\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b;\u0010\u0016R\u0011\u0010\u0005\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b<\u0010\u0016R\u0011\u0010\u0007\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b=\u0010\u0016R\u0011\u0010>\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b?\u0010\u0016R\u0011\u0010@\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\bA\u0010\u0016\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006l"}, d2={"Lkorlibs/math/geom/Line2D;", "Lkorlibs/math/geom/shape/Shape2D;", "()V", "x0", "", "y0", "x1", "y1", "(DDDD)V", "", "(FFFF)V", "", "(IIII)V", "a", "Lkorlibs/math/geom/Vector2D;", "b", "(Lkorlibs/math/geom/Vector2D;Lkorlibs/math/geom/Vector2D;)V", "getA", "()Lkorlibs/math/geom/Vector2D;", "angle", "Lkorlibs/math/geom/Angle;", "getAngle-igmgxjg", "()D", "area", "getArea", "getB", "center", "Lkorlibs/math/geom/Point;", "getCenter", "dx", "getDx", "dy", "getDy", "isNIL", "", "()Z", "length", "getLength", "lengthSquared", "getLengthSquared", "max", "getMax", "maxX", "getMaxX", "maxY", "getMaxY", "min", "getMin", "minX", "getMinX", "minY", "getMinY", "perimeter", "getPerimeter", "getX0", "getX1", "xmax", "getXmax", "xmin", "getXmin", "getY0", "getY1", "ymax", "getYmax", "ymin", "getYmin", "component1", "component2", "containsBoundsXY", "x", "y", "containsPoint", "p", "containsX", "containsY", "copy", "directionVector", "equals", "other", "", "flipped", "Lkorlibs/math/geom/Line;", "getIntersectionPoint", "line", "getLineIntersectionPoint", "getMinimumDistance", "getSegmentIntersectionPoint", "hashCode", "intersects", "intersectsLine", "intersectsSegment", "isNaN", "normalVectorAt", "projectedPoint", "projectedPointOutsideSegment", "round", "scaledPoints", "scale", "toBezier", "Lkorlibs/math/geom/bezier/Bezier;", "toRay", "Lkorlibs/math/geom/Ray2D;", "Lkorlibs/math/geom/Ray;", "toString", "", "toVectorPath", "Lkorlibs/math/geom/vector/VectorPath;", "Companion", "korge-foundation"})
@SourceDebugExtension(value={"SMAP\nLine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Line.kt\nkorlibs/math/geom/Line2D\n+ 2 VectorsDouble.kt\nkorlibs/math/geom/Vector2D\n+ 3 _MathGeom.shape.kt\nkorlibs/math/geom/shape/_MathGeom_shapeKt\n+ 4 Angle.kt\nkorlibs/math/geom/Angle$Companion\n+ 5 Line.kt\nkorlibs/math/geom/Line2D$Companion\n*L\n1#1,174:1\n43#2,10:175\n42#2,11:185\n43#2:196\n43#2:198\n43#2,10:199\n42#2:209\n51#3:197\n200#4:210\n195#4:211\n156#5,12:212\n156#5,12:224\n*S KotlinDebug\n*F\n+ 1 Line.kt\nkorlibs/math/geom/Line2D\n*L\n20#1:175,10\n23#1:185,11\n24#1:196\n105#1:198\n106#1:199,10\n106#1:209\n69#1:197\n120#1:210\n120#1:211\n125#1:212,12\n129#1:224,12\n*E\n"})
public final class Line2D
implements Shape2D {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Vector2D a;
    @NotNull
    private final Vector2D b;
    @NotNull
    private static final Line2D ZERO = new Line2D(Vector2D.Companion.getZERO(), Vector2D.Companion.getZERO());
    @NotNull
    private static final Line2D NaN = new Line2D(Vector2D.Companion.getNaN(), Vector2D.Companion.getNaN());

    public Line2D(@NotNull Vector2D a, @NotNull Vector2D b) {
        this.a = a;
        this.b = b;
    }

    @NotNull
    public final Vector2D getA() {
        return this.a;
    }

    @NotNull
    public final Vector2D getB() {
        return this.b;
    }

    @Override
    public double getArea() {
        return 0.0;
    }

    @Override
    public double getPerimeter() {
        return this.getLength();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Vector2D normalVectorAt(@NotNull Vector2D p) {
        void scale$iv;
        Vector2D this_$iv;
        Vector2D projected = this.projectedPoint(p);
        Vector2D vector2D = this.b;
        Vector2D that$iv22 = this.a;
        boolean $i$f$minus = false;
        this_$iv = new Vector2D(this_$iv.getX() - that$iv22.getX(), this_$iv.getY() - that$iv22.getY()).toNormal().getNormalized();
        double that$iv22 = Math.signum(Vector2D.Companion.crossProduct(projected, p));
        boolean $i$f$times = false;
        return new Vector2D(this_$iv.getX() * scale$iv, this_$iv.getY() * scale$iv);
    }

    @Override
    @NotNull
    public Vector2D getCenter() {
        Vector2D this_$iv;
        Vector2D vector2D = this.a;
        Vector2D that$iv = this.b;
        boolean $i$f$plus = false;
        this_$iv = new Vector2D(this_$iv.getX() + that$iv.getX(), this_$iv.getY() + that$iv.getY());
        double scale$iv = 0.5;
        boolean $i$f$times = false;
        return new Vector2D(this_$iv.getX() * scale$iv, this_$iv.getY() * scale$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Ray2D toRay() {
        void this_$iv;
        Vector2D vector2D = this.b;
        Vector2D that$iv = this.a;
        boolean $i$f$minus = false;
        return new Ray2D(this.a, new Vector2D(this_$iv.getX() - that$iv.getX(), this_$iv.getY() - that$iv.getY()).getNormalized(), null, 4, null);
    }

    public final double getXmin() {
        return Math.min(this.getX0(), this.getX1());
    }

    public final double getXmax() {
        return Math.max(this.getX0(), this.getX1());
    }

    public final double getYmin() {
        return Math.min(this.getY0(), this.getY1());
    }

    public final double getYmax() {
        return Math.max(this.getY0(), this.getY1());
    }

    @Override
    @NotNull
    public Vector2D projectedPoint(@NotNull Vector2D p) {
        return VectorsDoubleKt.clamp(this.projectedPointOutsideSegment(p), new Vector2D(this.getXmin(), this.getYmin()), new Vector2D(this.getXmax(), this.getYmax()));
    }

    @NotNull
    public final Vector2D projectedPointOutsideSegment(@NotNull Vector2D p) {
        double v1x = this.getX0();
        double v2x = this.getX1();
        double v1y = this.getY0();
        double v2y = this.getY1();
        double px = p.getX();
        double py = p.getY();
        double e1x = v2x - v1x;
        double e1y = v2y - v1y;
        double e2x = px - v1x;
        double e2y = py - v1y;
        double valDp = Vector2D.Companion.dot(e1x, e1y, e2x, e2y);
        double lenLineE1 = Math.hypot(e1x, e1y);
        double lenLineE2 = Math.hypot(e2x, e2y);
        if (lenLineE1 == 0.0 || lenLineE2 == 0.0) {
            return new Vector2D(px, py);
        }
        double cos = valDp / (lenLineE1 * lenLineE2);
        double projLenOfLine = cos * lenLineE2;
        return new Vector2D(v1x + projLenOfLine * e1x / lenLineE1, v1y + projLenOfLine * e1y / lenLineE1);
    }

    @Override
    @NotNull
    public VectorPath toVectorPath() {
        VectorPath vectorPath;
        VectorPath out$iv = new VectorPath(null, null, null, false, 15, null);
        boolean $i$f$buildVectorPath = false;
        VectorPath $this$toVectorPath_u24lambda_u240 = vectorPath = out$iv;
        boolean bl = false;
        $this$toVectorPath_u24lambda_u240.moveTo(this.a);
        $this$toVectorPath_u24lambda_u240.lineTo(this.b);
        return vectorPath;
    }

    @Override
    public boolean containsPoint(@NotNull Vector2D p) {
        return false;
    }

    public Line2D() {
        this(new Vector2D(), new Vector2D());
    }

    public Line2D(double x0, double y0, double x1, double y1) {
        this(new Vector2D(x0, y0), new Vector2D(x1, y1));
    }

    public Line2D(float x0, float y0, float x1, float y1) {
        this(new Vector2D(x0, y0), new Vector2D(x1, y1));
    }

    public Line2D(int x0, int y0, int x1, int y1) {
        this(new Vector2D(x0, y0), new Vector2D(x1, y1));
    }

    @NotNull
    public final Line2D flipped() {
        boolean $i$f$flipped = false;
        return new Line2D(this.getB(), this.getA());
    }

    @NotNull
    public final Bezier toBezier() {
        return new Bezier(this.a, this.b);
    }

    public final double getX0() {
        return this.a.getX();
    }

    public final double getY0() {
        return this.a.getY();
    }

    public final double getX1() {
        return this.b.getX();
    }

    public final double getY1() {
        return this.b.getY();
    }

    public final double getDx() {
        return this.getX1() - this.getX0();
    }

    public final double getDy() {
        return this.getY1() - this.getY0();
    }

    @NotNull
    public final Vector2D getMin() {
        return new Vector2D(this.getMinX(), this.getMinY());
    }

    public final double getMinX() {
        return Math.min(this.a.getX(), this.b.getX());
    }

    public final double getMinY() {
        return Math.min(this.a.getY(), this.b.getY());
    }

    @NotNull
    public final Vector2D getMax() {
        return new Vector2D(this.getMaxX(), this.getMaxY());
    }

    public final double getMaxX() {
        return Math.max(this.a.getX(), this.b.getX());
    }

    public final double getMaxY() {
        return Math.max(this.a.getY(), this.b.getY());
    }

    @NotNull
    public final Line2D round() {
        return new Line2D(this.a.round(), this.b.round());
    }

    @NotNull
    public final Vector2D directionVector() {
        return new Vector2D(this.getDx(), this.getDy());
    }

    /*
     * WARNING - void declaration
     */
    public final double getMinimumDistance(@NotNull Vector2D p) {
        void that$iv;
        Vector2D v = this.a;
        Vector2D w = this.b;
        double l2 = Vector2D.Companion.distanceSquared(v, w);
        if (l2 == 0.0) {
            return Vector2D.Companion.distanceSquared(p, this.a);
        }
        Vector2D this_$iv = p;
        boolean $i$f$minus = false;
        Vector2D vector2D = new Vector2D(this_$iv.getX() - v.getX(), this_$iv.getY() - v.getY());
        this_$iv = w;
        $i$f$minus = false;
        double t = ClampKt.clamp(Vector2D.Companion.dot(vector2D, new Vector2D(this_$iv.getX() - v.getX(), this_$iv.getY() - v.getY())) / l2, 0.0, 1.0);
        this_$iv = v;
        Vector2D this_$iv2 = w;
        boolean $i$f$minus2 = false;
        this_$iv2 = new Vector2D(this_$iv2.getX() - v.getX(), this_$iv2.getY() - v.getY());
        boolean $i$f$times = false;
        this_$iv2 = new Vector2D(this_$iv2.getX() * t, this_$iv2.getY() * t);
        boolean $i$f$plus = false;
        return Vector2D.Companion.distance(p, new Vector2D(this_$iv.getX() + that$iv.getX(), this_$iv.getY() + that$iv.getY()));
    }

    @KormaExperimental
    @NotNull
    public final Line2D scaledPoints(double scale) {
        double dx = this.getDx();
        double dy = this.getDy();
        return new Line2D(this.getX0() - dx * scale, this.getY0() - dy * scale, this.getX1() + dx * scale, this.getY1() + dy * scale);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean containsX(double x) {
        boolean bl;
        boolean bl2;
        double d = this.getX0();
        if (x <= this.getX1()) {
            if (d <= x) {
                return true;
            }
            bl2 = false;
        } else {
            bl2 = false;
        }
        if (bl2) return true;
        d = this.getX1();
        if (x <= this.getX0()) {
            if (d <= x) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if (MathKt.almostEquals(x, this.getX0())) return true;
        if (!MathKt.almostEquals(x, this.getX1())) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean containsY(double y) {
        boolean bl;
        boolean bl2;
        double d = this.getY0();
        if (y <= this.getY1()) {
            if (d <= y) {
                return true;
            }
            bl2 = false;
        } else {
            bl2 = false;
        }
        if (bl2) return true;
        d = this.getY1();
        if (y <= this.getY0()) {
            if (d <= y) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if (MathKt.almostEquals(y, this.getY0())) return true;
        if (!MathKt.almostEquals(y, this.getY1())) return false;
        return true;
    }

    public final boolean containsBoundsXY(double x, double y) {
        return this.containsX(x) && this.containsY(y);
    }

    /*
     * WARNING - void declaration
     */
    public final double getAngle-igmgxjg() {
        void x1$iv$iv;
        void y0$iv$iv;
        void x0$iv$iv;
        void p0$iv;
        void $this$iv;
        Angle.Companion companion = Angle.Companion;
        Vector2D vector2D = this.a;
        Vector2D p1$iv = this.b;
        Vector2D up$iv = Vector2D.Companion.getUP();
        boolean bl = false;
        void var6_6 = $this$iv;
        double d = p0$iv.getX();
        double d2 = p0$iv.getY();
        double d3 = p1$iv.getX();
        double y1$iv$iv = p1$iv.getY();
        boolean bl2 = false;
        return AngleKt.Angle_between((double)x0$iv$iv, (double)y0$iv$iv, (double)x1$iv$iv, y1$iv$iv, up$iv);
    }

    public final double getLength() {
        return Vector2D.Companion.distance(this.a, this.b);
    }

    public final double getLengthSquared() {
        return Vector2D.Companion.distanceSquared(this.a, this.b);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Vector2D getLineIntersectionPoint(@NotNull Line2D line2) {
        Vector2D vector2D;
        void Dx$iv;
        void Cx$iv;
        void Cy$iv;
        void Bx$iv;
        void Ax$iv;
        void Ay$iv;
        void By$iv;
        Companion companion = Companion;
        double d = this.getX0();
        double d2 = this.getY0();
        double d3 = this.getX1();
        double d4 = this.getY1();
        double d5 = line2.getX0();
        double d6 = line2.getY0();
        double d7 = line2.getX1();
        double Dy$iv = line2.getY1();
        boolean $i$f$getIntersectXY = false;
        void a1$iv = By$iv - Ay$iv;
        void b1$iv = Ax$iv - Bx$iv;
        void c1$iv = a1$iv * Ax$iv + b1$iv * Ay$iv;
        double a2$iv = Dy$iv - Cy$iv;
        void b2$iv = Cx$iv - Dx$iv;
        double c2$iv = a2$iv * Cx$iv + b2$iv * Cy$iv;
        void determinant$iv = a1$iv * b2$iv - a2$iv * b1$iv;
        if (IsAlmostZeroKt.isAlmostZero((double)determinant$iv)) {
            vector2D = null;
        } else {
            void x$iv = (b2$iv * c1$iv - b1$iv * c2$iv) / determinant$iv;
            void y$iv = (a1$iv * c2$iv - a2$iv * c1$iv) / determinant$iv;
            vector2D = new Vector2D((double)x$iv, (double)y$iv);
        }
        return vector2D;
    }

    @Nullable
    public final Vector2D getIntersectionPoint(@NotNull Line2D line2) {
        return this.getSegmentIntersectionPoint(line2);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Vector2D getSegmentIntersectionPoint(@NotNull Line2D line2) {
        Vector2D out;
        Vector2D vector2D;
        void Dx$iv;
        void Cx$iv;
        void Cy$iv;
        void Bx$iv;
        void Ax$iv;
        void Ay$iv;
        void By$iv;
        Companion companion = Companion;
        double d = this.getX0();
        double d2 = this.getY0();
        double d3 = this.getX1();
        double d4 = this.getY1();
        double d5 = line2.getX0();
        double d6 = line2.getY0();
        double d7 = line2.getX1();
        double Dy$iv = line2.getY1();
        boolean $i$f$getIntersectXY = false;
        void a1$iv = By$iv - Ay$iv;
        void b1$iv = Ax$iv - Bx$iv;
        void c1$iv = a1$iv * Ax$iv + b1$iv * Ay$iv;
        double a2$iv = Dy$iv - Cy$iv;
        void b2$iv = Cx$iv - Dx$iv;
        double c2$iv = a2$iv * Cx$iv + b2$iv * Cy$iv;
        void determinant$iv = a1$iv * b2$iv - a2$iv * b1$iv;
        if (IsAlmostZeroKt.isAlmostZero((double)determinant$iv)) {
            vector2D = null;
        } else {
            void x$iv = (b2$iv * c1$iv - b1$iv * c2$iv) / determinant$iv;
            void y$iv = (a1$iv * c2$iv - a2$iv * c1$iv) / determinant$iv;
            vector2D = out = new Vector2D((double)x$iv, (double)y$iv);
        }
        if (out != null && this.containsBoundsXY(out.getX(), out.getY()) && line2.containsBoundsXY(out.getX(), out.getY())) {
            return out;
        }
        return null;
    }

    public final boolean intersectsLine(@NotNull Line2D line2) {
        return this.getLineIntersectionPoint(line2) != null;
    }

    public final boolean intersects(@NotNull Line2D line2) {
        return this.intersectsSegment(line2);
    }

    public final boolean intersectsSegment(@NotNull Line2D line2) {
        return this.getSegmentIntersectionPoint(line2) != null;
    }

    @NotNull
    public String toString() {
        return "Line(" + this.a + ", " + this.b + ")";
    }

    public final boolean isNIL() {
        return Double.isNaN(this.a.getX());
    }

    public final boolean isNaN() {
        return Double.isNaN(this.a.getY());
    }

    @Override
    @Deprecated(message="Untested yet")
    @NotNull
    public Vector2D normalVectorAt(@NotNull Matrix ml, @NotNull Vector2D p, @NotNull Matrix mr) {
        return Shape2D.DefaultImpls.normalVectorAt(this, ml, p, mr);
    }

    @Override
    @Deprecated(message="Untested yet")
    @NotNull
    public Vector2D projectedPoint(@NotNull Matrix ml, @NotNull Vector2D p, @NotNull Matrix mr) {
        return Shape2D.DefaultImpls.projectedPoint(this, ml, p, mr);
    }

    @Override
    @Deprecated(message="Untested yet")
    public boolean containsPoint(@NotNull Matrix ml, @NotNull Vector2D p, @NotNull Matrix mr) {
        return Shape2D.DefaultImpls.containsPoint(this, ml, p, mr);
    }

    @Override
    public boolean getClosed() {
        return Shape2D.DefaultImpls.getClosed(this);
    }

    @Override
    public double distance(@NotNull Vector2D p) {
        return Shape2D.DefaultImpls.distance(this, p);
    }

    @Override
    @Deprecated(message="Untested yet")
    public double distance(@NotNull Matrix ml, @NotNull Vector2D p, @NotNull Matrix mr) {
        return Shape2D.DefaultImpls.distance(this, ml, p, mr);
    }

    @Override
    @NotNull
    public RectangleD getBounds() {
        return Shape2D.DefaultImpls.getBounds(this);
    }

    @Override
    @NotNull
    public PointList intersectionsWith(@NotNull Shape2D that) {
        return Shape2D.DefaultImpls.intersectionsWith(this, that);
    }

    @Override
    @NotNull
    public PointList intersectionsWith(@NotNull Matrix ml, @NotNull Shape2D that, @NotNull Matrix mr) {
        return Shape2D.DefaultImpls.intersectionsWith(this, ml, that, mr);
    }

    @Override
    public boolean intersectsWith(@NotNull Shape2D that) {
        return Shape2D.DefaultImpls.intersectsWith(this, that);
    }

    @Override
    public boolean intersectsWith(@NotNull Matrix ml, @NotNull Shape2D that, @NotNull Matrix mr) {
        return Shape2D.DefaultImpls.intersectsWith(this, ml, that, mr);
    }

    @NotNull
    public final Vector2D component1() {
        return this.a;
    }

    @NotNull
    public final Vector2D component2() {
        return this.b;
    }

    @NotNull
    public final Line2D copy(@NotNull Vector2D a, @NotNull Vector2D b) {
        return new Line2D(a, b);
    }

    public static /* synthetic */ Line2D copy$default(Line2D line2D, Vector2D vector2D, Vector2D vector2D2, int n, Object object) {
        if ((n & 1) != 0) {
            vector2D = line2D.a;
        }
        if ((n & 2) != 0) {
            vector2D2 = line2D.b;
        }
        return line2D.copy(vector2D, vector2D2);
    }

    public int hashCode() {
        int result2 = this.a.hashCode();
        result2 = result2 * 31 + this.b.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Line2D)) {
            return false;
        }
        Line2D line2D = (Line2D)other;
        if (!Intrinsics.areEqual(this.a, line2D.a)) {
            return false;
        }
        return Intrinsics.areEqual(this.b, line2D.b);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\f\u001a\u00060\u0004j\u0002`\u00052\n\u0010\r\u001a\u00060\u000ej\u0002`\u000f2\n\u0010\u0010\u001a\u00060\u000ej\u0002`\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\u0012J2\u0010\u0013\u001a\u00060\u0004j\u0002`\u00052\n\u0010\r\u001a\u00060\u000ej\u0002`\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0012\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0018J>\u0010\u0019\u001a\n\u0018\u00010\u000ej\u0004\u0018\u0001`\u000f2\n\u0010\u001a\u001a\u00060\u000ej\u0002`\u000f2\n\u0010\u001b\u001a\u00060\u000ej\u0002`\u000f2\n\u0010\u001c\u001a\u00060\u000ej\u0002`\u000f2\n\u0010\u001d\u001a\u00060\u000ej\u0002`\u000fJQ\u0010\u0019\u001a\n\u0018\u00010\u000ej\u0004\u0018\u0001`\u000f2\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u0012H\u0086\bJ&\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u0012R\u0015\u0010\u0003\u001a\u00060\u0004j\u0002`\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0015\u0010\b\u001a\u00060\u0004j\u0002`\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0015\u0010\n\u001a\u00060\u0004j\u0002`\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006&"}, d2={"Lkorlibs/math/geom/Line2D$Companion;", "", "()V", "NIL", "Lkorlibs/math/geom/Line2D;", "Lkorlibs/math/geom/Line;", "getNIL", "()Lkorlibs/math/geom/Line2D;", "NaN", "getNaN", "ZERO", "getZERO", "fromPointAndDirection", "point", "Lkorlibs/math/geom/Vector2D;", "Lkorlibs/math/geom/Point;", "direction", "scale", "", "fromPointAngle", "angle", "Lkorlibs/math/geom/Angle;", "length", "fromPointAngle-71ybUt4", "(Lkorlibs/math/geom/Vector2D;DD)Lkorlibs/math/geom/Line2D;", "getIntersectXY", "a", "b", "c", "d", "Ax", "Ay", "Bx", "By", "Cx", "Cy", "Dx", "Dy", "korge-foundation"})
    @SourceDebugExtension(value={"SMAP\nLine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Line.kt\nkorlibs/math/geom/Line2D$Companion\n+ 2 VectorsDouble.kt\nkorlibs/math/geom/Vector2D\n+ 3 VectorsDouble.kt\nkorlibs/math/geom/Vector2D$Companion\n*L\n1#1,174:1\n156#1,12:179\n52#2:175\n42#2:176\n170#3:177\n168#3:178\n*S KotlinDebug\n*F\n+ 1 Line.kt\nkorlibs/math/geom/Line2D$Companion\n*L\n171#1:179,12\n149#1:175\n149#1:176\n151#1:177\n151#1:178\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Line2D getZERO() {
            return ZERO;
        }

        @NotNull
        public final Line2D getNaN() {
            return NaN;
        }

        @NotNull
        public final Line2D getNIL() {
            return this.getNaN();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Line2D fromPointAndDirection(@NotNull Vector2D point2, @NotNull Vector2D direction2, double scale) {
            void that$iv;
            void this_$iv;
            Vector2D vector2D = point2;
            Vector2D this_$iv2 = direction2;
            boolean $i$f$times = false;
            this_$iv2 = new Vector2D(this_$iv2.getX() * scale, this_$iv2.getY() * scale);
            boolean $i$f$plus = false;
            return new Line2D(point2, new Vector2D(this_$iv.getX() + that$iv.getX(), this_$iv.getY() + that$iv.getY()));
        }

        public static /* synthetic */ Line2D fromPointAndDirection$default(Companion companion, Vector2D vector2D, Vector2D vector2D2, double d, int n, Object object) {
            if ((n & 4) != 0) {
                d = 1.0;
            }
            return companion.fromPointAndDirection(vector2D, vector2D2, d);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Line2D fromPointAngle-71ybUt4(@NotNull Vector2D point2, double angle, double length2) {
            void x$iv$iv;
            Vector2D.Companion $this$iv = Vector2D.Companion;
            Vector2D up$iv = $this$iv.getUP();
            boolean bl = false;
            Vector2D.Companion companion = $this$iv;
            double d = 0.0;
            double y$iv$iv = 0.0;
            boolean bl2 = false;
            return new Line2D(point2, new Vector2D((double)(x$iv$iv + Angle.cosine-impl(angle, up$iv) * length2), y$iv$iv + Angle.sine-impl(angle, up$iv) * length2));
        }

        public static /* synthetic */ Line2D fromPointAngle-71ybUt4$default(Companion companion, Vector2D vector2D, double d, double d2, int n, Object object) {
            if ((n & 4) != 0) {
                d2 = 1.0;
            }
            return companion.fromPointAngle-71ybUt4(vector2D, d, d2);
        }

        public final double length(double Ax, double Ay, double Bx, double By) {
            return Math.hypot(Bx - Ax, By - Ay);
        }

        @Nullable
        public final Vector2D getIntersectXY(double Ax, double Ay, double Bx, double By, double Cx, double Cy, double Dx, double Dy) {
            boolean $i$f$getIntersectXY = false;
            double a1 = By - Ay;
            double b1 = Ax - Bx;
            double c1 = a1 * Ax + b1 * Ay;
            double a2 = Dy - Cy;
            double b2 = Cx - Dx;
            double c2 = a2 * Cx + b2 * Cy;
            double determinant = a1 * b2 - a2 * b1;
            if (IsAlmostZeroKt.isAlmostZero(determinant)) {
                return null;
            }
            double x = (b2 * c1 - b1 * c2) / determinant;
            double y = (a1 * c2 - a2 * c1) / determinant;
            return new Vector2D(x, y);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final Vector2D getIntersectXY(@NotNull Vector2D a, @NotNull Vector2D b, @NotNull Vector2D c, @NotNull Vector2D d) {
            Vector2D vector2D;
            void Dx$iv;
            void Cx$iv;
            void Cy$iv;
            void Bx$iv;
            void Ax$iv;
            void Ay$iv;
            void By$iv;
            Companion companion = this;
            double d2 = a.getX();
            double d3 = a.getY();
            double d4 = b.getX();
            double d5 = b.getY();
            double d6 = c.getX();
            double d7 = c.getY();
            double d8 = d.getX();
            double Dy$iv = d.getY();
            boolean $i$f$getIntersectXY = false;
            void a1$iv = By$iv - Ay$iv;
            void b1$iv = Ax$iv - Bx$iv;
            void c1$iv = a1$iv * Ax$iv + b1$iv * Ay$iv;
            double a2$iv = Dy$iv - Cy$iv;
            void b2$iv = Cx$iv - Dx$iv;
            double c2$iv = a2$iv * Cx$iv + b2$iv * Cy$iv;
            void determinant$iv = a1$iv * b2$iv - a2$iv * b1$iv;
            if (IsAlmostZeroKt.isAlmostZero((double)determinant$iv)) {
                vector2D = null;
            } else {
                void x$iv = (b2$iv * c1$iv - b1$iv * c2$iv) / determinant$iv;
                void y$iv = (a1$iv * c2$iv - a2$iv * c1$iv) / determinant$iv;
                vector2D = new Vector2D((double)x$iv, (double)y$iv);
            }
            return vector2D;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

