/*
 * Decompiled with CFR 0.152.
 */
package korlibs.math.geom;

import korlibs.datastructure.ConcurrentPool;
import korlibs.math.IsAlmostEquals;
import korlibs.math.IsAlmostZeroKt;
import korlibs.math.RoundDecimalPlacesKt;
import korlibs.math.annotations.KormaMutableApi;
import korlibs.math.geom.Angle;
import korlibs.math.geom.AngleKt;
import korlibs.math.geom.MMatrix;
import korlibs.math.geom.MPoint;
import korlibs.math.geom.MPointInt;
import korlibs.math.geom.Vector2D;
import korlibs.math.interpolation.Interpolable;
import korlibs.math.interpolation.MutableInterpolable;
import korlibs.math.interpolation._Math_interpolationKt;
import korlibs.number.StringExtKt;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@KormaMutableApi
@Deprecated(message="Use Point instead")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b$\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b8\n\u0002\u0018\u0002\n\u0002\b\f\b\u0087\b\u0018\u0000 \u0094\u00012\b\u0012\u0004\u0012\u00020\u00000\u00012\b\u0012\u0004\u0012\u00020\u00000\u00022\b\u0012\u0004\u0012\u00020\u00000\u00032\b\u0012\u0004\u0012\u00020\u00000\u0004:\u0002\u0094\u0001B\u0013\b\u0016\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\u0002\u0010\bB\u0017\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fB\u0017\b\u0016\u0012\u0006\u0010\t\u001a\u00020\r\u0012\u0006\u0010\u000b\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eB\u0015\u0012\u0006\u0010\t\u001a\u00020\u000f\u0012\u0006\u0010\u000b\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u000e\u00103\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0000J\u0012\u00103\u001a\u00020\u00002\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007J\u0016\u00103\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u000fJ\u001b\u00104\u001a\u00020\u00122\u0006\u00105\u001a\u00020\u0000\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b6\u00107J\u001f\u00104\u001a\u00020\u00122\n\u00105\u001a\u00060\u0006j\u0002`\u0007\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b6\u00108J\u0006\u00109\u001a\u00020\u0000J\u0006\u0010:\u001a\u00020\u0000J\u0011\u0010;\u001a\u00020\r2\u0006\u00105\u001a\u00020\u0000H\u0096\u0002J\t\u0010<\u001a\u00020\u000fH\u00c6\u0003J\t\u0010=\u001a\u00020\u000fH\u00c6\u0003J\u0006\u0010>\u001a\u00020\u0000J\u001d\u0010>\u001a\u00020\u00002\b\b\u0002\u0010\t\u001a\u00020\u000f2\b\b\u0002\u0010\u000b\u001a\u00020\u000fH\u00c6\u0001J\u000e\u0010?\u001a\u00020\u00002\u0006\u0010@\u001a\u00020\u0000J\u0012\u0010?\u001a\u00020\u00002\n\u0010@\u001a\u00060\u0006j\u0002`\u0007J\u000e\u0010A\u001a\u00020\u000f2\u0006\u0010@\u001a\u00020\u0000J\u0016\u0010A\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u000fJ\u0016\u0010A\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u0016\u0010A\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\rJ\u0011\u0010B\u001a\u00020\u00002\u0006\u0010@\u001a\u00020\u0000H\u0087\u0002J\u0011\u0010B\u001a\u00020\u00002\u0006\u0010C\u001a\u00020\u000fH\u0087\u0002J\u0011\u0010B\u001a\u00020\u00002\u0006\u0010C\u001a\u00020\nH\u0087\u0002J\u0011\u0010B\u001a\u00020\u00002\u0006\u0010C\u001a\u00020\rH\u0087\u0002J\u0011\u0010D\u001a\u00020E2\u0006\u0010@\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010D\u001a\u00020E2\u0006\u0010C\u001a\u00020\u000fH\u0086\u0002J\u0011\u0010F\u001a\u00020\u000f2\u0006\u0010@\u001a\u00020\u0000H\u0087\u0004J\u0013\u0010G\u001a\u00020H2\b\u00105\u001a\u0004\u0018\u00010IH\u00d6\u0003J\u0006\u0010J\u001a\u00020\u0000J\u0011\u0010K\u001a\u00020\u000f2\u0006\u0010L\u001a\u00020\rH\u0086\u0002J\t\u0010M\u001a\u00020\rH\u00d6\u0001J\"\u0010N\u001a\u00020\u00002\u0006\u0010O\u001a\u00020P2\u0006\u00105\u001a\u00020\u0000H\u0017\u00f8\u0001\u0000\u00a2\u0006\u0004\bQ\u0010RJ\u0018\u0010S\u001a\u00020H2\u0006\u00105\u001a\u00020\u00002\u0006\u0010T\u001a\u00020\u000fH\u0016J\u0011\u0010U\u001a\u00020\u00002\u0006\u0010@\u001a\u00020\u0000H\u0087\u0002J\u0011\u0010V\u001a\u00020E2\u0006\u0010@\u001a\u00020\u0000H\u0086\u0002J\u000e\u0010W\u001a\u00020\u00002\u0006\u0010X\u001a\u00020\u000fJ\u000e\u0010W\u001a\u00020\u00002\u0006\u0010X\u001a\u00020\nJ\u000e\u0010W\u001a\u00020\u00002\u0006\u0010X\u001a\u00020\rJ\u0006\u0010Y\u001a\u00020\u0000J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010Z\u001a\u00020\rJ\u0006\u0010[\u001a\u00020EJ\u0011\u0010\\\u001a\u00020\u00002\u0006\u0010@\u001a\u00020\u0000H\u0087\u0002J\u0011\u0010]\u001a\u00020E2\u0006\u0010@\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010^\u001a\u00020E2\u0006\u0010@\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010^\u001a\u00020E2\u0006\u0010C\u001a\u00020\u000fH\u0086\u0002J\"\u0010_\u001a\u00020\u00002\u0006\u0010`\u001a\u00020\u00122\b\b\u0002\u0010a\u001a\u00020\u0000\u00f8\u0001\u0000\u00a2\u0006\u0004\bb\u0010RJ\u0006\u0010c\u001a\u00020\u0000J\u0012\u0010d\u001a\u00020\u00002\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007J\u0016\u0010d\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u000fJ\u0016\u0010d\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u0016\u0010d\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\rJ\u0016\u0010e\u001a\u00020\u00002\u0006\u0010f\u001a\u00020\u00002\u0006\u0010g\u001a\u00020\u0000J\u0016\u0010h\u001a\u00020\u00002\u0006\u0010f\u001a\u00020\u00002\u0006\u0010g\u001a\u00020\u0000J\u0016\u0010h\u001a\u00020\u00002\u0006\u0010f\u001a\u00020\u00002\u0006\u0010X\u001a\u00020\u000fJ\u0016\u0010h\u001a\u00020\u00002\u0006\u0010f\u001a\u00020\u00002\u0006\u0010X\u001a\u00020\nJ\u0006\u0010i\u001a\u00020\u0000J*\u0010j\u001a\u00020\u00002\u0006\u0010O\u001a\u00020P2\u0006\u0010k\u001a\u00020\u00002\u0006\u0010l\u001a\u00020\u0000H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\bm\u0010nJ8\u0010j\u001a\u00020\u00002\u0006\u0010O\u001a\u00020P2\u0006\u0010o\u001a\u00020\u000f2\u0006\u0010p\u001a\u00020\u000f2\u0006\u0010q\u001a\u00020\u000f2\u0006\u0010r\u001a\u00020\u000f\u00f8\u0001\u0000\u00a2\u0006\u0004\bs\u0010tJ\u0006\u0010u\u001a\u00020\u0000J\u0016\u0010v\u001a\u00020\u00002\u0006\u0010f\u001a\u00020\u00002\u0006\u0010g\u001a\u00020\u0000J\u0016\u0010v\u001a\u00020\u00002\u0006\u0010f\u001a\u00020\u00002\u0006\u0010X\u001a\u00020\u000fJ\u0016\u0010v\u001a\u00020\u00002\u0006\u0010f\u001a\u00020\u00002\u0006\u0010X\u001a\u00020\nJ\u0006\u0010w\u001a\u00020\u0000J\u0006\u0010x\u001a\u00020\u0000J\"\u0010y\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0018\u001a\u00020\u000f\u00f8\u0001\u0000\u00a2\u0006\u0004\bz\u0010{J*\u0010y\u001a\u00020\u00002\u0006\u0010|\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0018\u001a\u00020\u000f\u00f8\u0001\u0000\u00a2\u0006\u0004\b}\u0010~J.\u0010y\u001a\u00020\u00002\n\u0010|\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0018\u001a\u00020\n\u00f8\u0001\u0000\u00a2\u0006\u0004\b}\u0010\u007fJ4\u0010y\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0018\u001a\u00020\u000f\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u0080\u0001\u0010\u0081\u0001J4\u0010y\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0018\u001a\u00020\n\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u0080\u0001\u0010\u0082\u0001J\u0007\u0010\u0083\u0001\u001a\u00020\u0000J\u0010\u0010\u0084\u0001\u001a\u00020\u00002\u0007\u0010\u0085\u0001\u001a\u00020\rJ\u0017\u0010\u0086\u0001\u001a\u00020\u00002\u0006\u0010f\u001a\u00020\u00002\u0006\u0010g\u001a\u00020\u0000J\u0019\u0010\u0087\u0001\u001a\u00020\u00002\b\u0010\u0088\u0001\u001a\u00030\u0089\u00012\u0006\u0010\u0005\u001a\u00020\u0000J!\u0010\u0087\u0001\u001a\u00020\u00002\b\u0010\u0088\u0001\u001a\u00030\u0089\u00012\u0006\u0010\t\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u000fJ\u0007\u0010\u008a\u0001\u001a\u00020\u0000J\u0007\u0010\u008b\u0001\u001a\u00020\u0000J\u000f\u0010\u008c\u0001\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0000J\u0013\u0010\u008c\u0001\u001a\u00020\u00002\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007J\u0017\u0010\u008c\u0001\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u000fJ\u0012\u0010\u008d\u0001\u001a\u00020\u00002\u0006\u0010@\u001a\u00020\u0000H\u0087\u0002J\u0012\u0010\u008d\u0001\u001a\u00020\u00002\u0006\u0010C\u001a\u00020\u000fH\u0087\u0002J\u0012\u0010\u008d\u0001\u001a\u00020\u00002\u0006\u0010C\u001a\u00020\nH\u0087\u0002J\u0012\u0010\u008d\u0001\u001a\u00020\u00002\u0006\u0010C\u001a\u00020\rH\u0087\u0002J\u0012\u0010\u008e\u0001\u001a\u00020E2\u0006\u0010@\u001a\u00020\u0000H\u0086\u0002J\u0012\u0010\u008e\u0001\u001a\u00020E2\u0006\u0010C\u001a\u00020\u000fH\u0086\u0002J\t\u0010\u008f\u0001\u001a\u00020 H\u0016J\u0013\u0010\u0090\u0001\u001a\u00020\u000f2\n\u0010\u0091\u0001\u001a\u0005\u0018\u00010\u0089\u0001J\u0013\u0010\u0092\u0001\u001a\u00020\u000f2\n\u0010\u0091\u0001\u001a\u0005\u0018\u00010\u0089\u0001J\u001b\u0010\u0093\u0001\u001a\u00020\u00002\b\u0010\u0088\u0001\u001a\u00030\u0089\u00012\b\b\u0002\u0010a\u001a\u00020\u0000R\u0017\u0010\u0011\u001a\u00020\u00128F\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0015\u0010\u0015\u001a\u00060\u0006j\u0002`\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0014R\u0011\u0010\u001a\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0014R\u0011\u0010\u001c\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020\u00008FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b$\u0010%\u001a\u0004\b&\u0010\u001eR\u0015\u0010'\u001a\u00060\u0006j\u0002`\u00078F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0017R\u0011\u0010)\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u0014R\u001a\u0010+\u001a\u00020\u00008FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b,\u0010%\u001a\u0004\b-\u0010\u001eR\u001a\u0010\t\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u0014\"\u0004\b/\u00100R\u001a\u0010\u000b\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010\u0014\"\u0004\b2\u00100\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0095\u0001"}, d2={"Lkorlibs/math/geom/MPoint;", "Lkorlibs/math/interpolation/MutableInterpolable;", "Lkorlibs/math/interpolation/Interpolable;", "", "Lkorlibs/math/IsAlmostEquals;", "p", "Lkorlibs/math/geom/Vector2D;", "Lkorlibs/math/geom/Point;", "(Lkorlibs/math/geom/Vector2D;)V", "x", "", "y", "(FF)V", "", "(II)V", "", "(DD)V", "angle", "Lkorlibs/math/geom/Angle;", "getAngle-igmgxjg", "()D", "immutable", "getImmutable", "()Lkorlibs/math/geom/Vector2D;", "length", "getLength", "magnitude", "getMagnitude", "mutable", "getMutable", "()Lkorlibs/math/geom/MPoint;", "niceStr", "", "getNiceStr", "()Ljava/lang/String;", "normalized", "getNormalized$annotations", "()V", "getNormalized", "point", "getPoint", "squaredLength", "getSquaredLength", "unit", "getUnit$annotations", "getUnit", "getX", "setX", "(D)V", "getY", "setY", "add", "angleTo", "other", "angleTo-AmL7uXk", "(Lkorlibs/math/geom/MPoint;)D", "(Lkorlibs/math/geom/Vector2D;)D", "ceil", "clear", "compareTo", "component1", "component2", "copy", "copyFrom", "that", "distanceTo", "div", "scale", "divAssign", "", "dot", "equals", "", "", "floor", "get", "index", "hashCode", "interpolateWith", "ratio", "Lkorlibs/math/interpolation/Ratio;", "interpolateWith-DJj3pIk", "(DLkorlibs/math/geom/MPoint;)Lkorlibs/math/geom/MPoint;", "isAlmostEquals", "epsilon", "minus", "minusAssign", "mul", "s", "neg", "decimalPlaces", "normalize", "plus", "plusAssign", "remAssign", "rotate", "rotation", "out", "rotate-2FdH_oo", "round", "setTo", "setToAdd", "a", "b", "setToDiv", "setToDown", "setToInterpolated", "l", "r", "setToInterpolated-aphylw4", "(DLkorlibs/math/geom/MPoint;Lkorlibs/math/geom/MPoint;)Lkorlibs/math/geom/MPoint;", "lx", "ly", "rx", "ry", "setToInterpolated-OzkQpaQ", "(DDDDD)Lkorlibs/math/geom/MPoint;", "setToLeft", "setToMul", "setToNormal", "setToOne", "setToPolar", "setToPolar-2FdH_oo", "(DD)Lkorlibs/math/geom/MPoint;", "base", "setToPolar-71ybUt4", "(Lkorlibs/math/geom/MPoint;DD)Lkorlibs/math/geom/MPoint;", "(Lkorlibs/math/geom/Vector2D;DF)Lkorlibs/math/geom/MPoint;", "setToPolar-fJ7hWco", "(DDDD)Lkorlibs/math/geom/MPoint;", "(FFDF)Lkorlibs/math/geom/MPoint;", "setToRight", "setToRoundDecimalPlaces", "places", "setToSub", "setToTransform", "mat", "Lkorlibs/math/geom/MMatrix;", "setToUp", "setToZero", "sub", "times", "timesAssign", "toString", "transformX", "m", "transformY", "transformed", "Companion", "korge-foundation"})
@SourceDebugExtension(value={"SMAP\n_MathGeomMutable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 _MathGeomMutable.kt\nkorlibs/math/geom/MPoint\n+ 2 Angle.kt\nkorlibs/math/geom/Angle$Companion\n*L\n1#1,3252:1\n195#2:3253\n195#2:3254\n195#2:3255\n195#2:3256\n*S KotlinDebug\n*F\n+ 1 _MathGeomMutable.kt\nkorlibs/math/geom/MPoint\n*L\n2036#1:3253\n2138#1:3254\n2139#1:3255\n2177#1:3256\n*E\n"})
public final class MPoint
implements MutableInterpolable<MPoint>,
Interpolable<MPoint>,
Comparable<MPoint>,
IsAlmostEquals<MPoint> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double x;
    private double y;
    @NotNull
    private static final ConcurrentPool<MPoint> POOL = new ConcurrentPool(Companion.POOL.1.INSTANCE, 0, Companion.POOL.2.INSTANCE, 2, null);
    @NotNull
    private static final MPoint Zero = new MPoint(0.0, 0.0);
    @NotNull
    private static final MPoint One = new MPoint(1.0, 1.0);
    @NotNull
    private static final MPoint Up = new MPoint(0.0, -1.0);
    @NotNull
    private static final MPoint Down = new MPoint(0.0, 1.0);
    @NotNull
    private static final MPoint Left = new MPoint(-1.0, 0.0);
    @NotNull
    private static final MPoint Right = new MPoint(1.0, 0.0);

    public MPoint(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public final double getX() {
        return this.x;
    }

    public final void setX(double d) {
        this.x = d;
    }

    public final double getY() {
        return this.y;
    }

    public final void setY(double d) {
        this.y = d;
    }

    public MPoint(@NotNull Vector2D p) {
        this(p.getX(), p.getY());
    }

    public MPoint(float x, float y) {
        this((double)x, (double)y);
    }

    public MPoint(int x, int y) {
        this((double)x, (double)y);
    }

    @NotNull
    public final Vector2D getPoint() {
        return new Vector2D(this.x, this.y);
    }

    @NotNull
    public final String getNiceStr() {
        return "(" + StringExtKt.getNiceStr(this.x) + ", " + StringExtKt.getNiceStr(this.y) + ")";
    }

    @NotNull
    public final String niceStr(int decimalPlaces) {
        return "(" + StringExtKt.niceStr$default(this.x, decimalPlaces, false, 2, null) + ", " + StringExtKt.niceStr$default(this.y, decimalPlaces, false, 2, null) + ")";
    }

    /*
     * WARNING - void declaration
     */
    public final double getAngle-igmgxjg() {
        void x1$iv;
        void y0$iv;
        void x0$iv;
        Angle.Companion companion = Angle.Companion;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = this.x;
        double y1$iv = this.y;
        Vector2D up$iv = Vector2D.Companion.getUP();
        boolean bl = false;
        return AngleKt.Angle_between((double)x0$iv, (double)y0$iv, (double)x1$iv, y1$iv, up$iv);
    }

    public final double transformX(@Nullable MMatrix m) {
        MMatrix mMatrix = m;
        return mMatrix != null ? mMatrix.transformX(this) : this.x;
    }

    public final double transformY(@Nullable MMatrix m) {
        MMatrix mMatrix = m;
        return mMatrix != null ? mMatrix.transformY(this) : this.y;
    }

    @NotNull
    public final MPoint getMutable() {
        return new MPoint(this.x, this.y);
    }

    @NotNull
    public final Vector2D getImmutable() {
        return new Vector2D(this.x, this.y);
    }

    @Override
    public boolean isAlmostEquals(@NotNull MPoint other, double epsilon) {
        return IsAlmostZeroKt.isAlmostEquals(this.x, other.x, epsilon) && IsAlmostZeroKt.isAlmostEquals(this.y, other.y, epsilon);
    }

    @NotNull
    public final MPoint clear() {
        return this.setToZero();
    }

    @NotNull
    public final MPoint setToZero() {
        return this.setTo(0.0, 0.0);
    }

    @NotNull
    public final MPoint setToOne() {
        return this.setTo(1.0, 1.0);
    }

    @NotNull
    public final MPoint setToUp() {
        return this.setTo(0.0, -1.0);
    }

    @NotNull
    public final MPoint setToDown() {
        return this.setTo(0.0, 1.0);
    }

    @NotNull
    public final MPoint setToLeft() {
        return this.setTo(-1.0, 0.0);
    }

    @NotNull
    public final MPoint setToRight() {
        return this.setTo(1.0, 0.0);
    }

    @NotNull
    public final MPoint floor() {
        return this.setTo(Math.floor(this.x), Math.floor(this.y));
    }

    @NotNull
    public final MPoint round() {
        return this.setTo(Math.rint(this.x), Math.rint(this.y));
    }

    @NotNull
    public final MPoint ceil() {
        return this.setTo(Math.ceil(this.x), Math.ceil(this.y));
    }

    @NotNull
    public final MPoint setToRoundDecimalPlaces(int places) {
        return this.setTo(RoundDecimalPlacesKt.roundDecimalPlaces(this.x, places), RoundDecimalPlacesKt.roundDecimalPlaces(this.y, places));
    }

    @NotNull
    public final MPoint setTo(int x, int y) {
        return this.setTo((double)x, (double)y);
    }

    @NotNull
    public final MPoint setTo(double x, double y) {
        this.x = x;
        this.y = y;
        return this;
    }

    @NotNull
    public final MPoint setTo(float x, float y) {
        this.x = x;
        this.y = y;
        return this;
    }

    @NotNull
    public final MPoint setTo(@NotNull Vector2D p) {
        return this.setTo(p.getX(), p.getY());
    }

    @NotNull
    public final MPoint setToPolar-2FdH_oo(double angle, double length2) {
        return this.setToPolar-fJ7hWco(0.0, 0.0, angle, length2);
    }

    public static /* synthetic */ MPoint setToPolar-2FdH_oo$default(MPoint mPoint, double d, double d2, int n, Object object) {
        if ((n & 2) != 0) {
            d2 = 1.0;
        }
        return mPoint.setToPolar-2FdH_oo(d, d2);
    }

    @NotNull
    public final MPoint setToPolar-71ybUt4(@NotNull Vector2D base2, double angle, float length2) {
        return this.setToPolar-fJ7hWco((float)base2.getX(), (float)base2.getY(), angle, length2);
    }

    public static /* synthetic */ MPoint setToPolar-71ybUt4$default(MPoint mPoint, Vector2D vector2D, double d, float f, int n, Object object) {
        if ((n & 4) != 0) {
            f = 1.0f;
        }
        return mPoint.setToPolar-71ybUt4(vector2D, d, f);
    }

    @NotNull
    public final MPoint setToPolar-71ybUt4(@NotNull MPoint base2, double angle, double length2) {
        return this.setToPolar-fJ7hWco(base2.x, base2.y, angle, length2);
    }

    public static /* synthetic */ MPoint setToPolar-71ybUt4$default(MPoint mPoint, MPoint mPoint2, double d, double d2, int n, Object object) {
        if ((n & 4) != 0) {
            d2 = 1.0;
        }
        return mPoint.setToPolar-71ybUt4(mPoint2, d, d2);
    }

    @NotNull
    public final MPoint setToPolar-fJ7hWco(double x, double y, double angle, double length2) {
        return this.setTo(x + Angle.getCosine-impl(angle) * length2, y + Angle.getSine-impl(angle) * length2);
    }

    public static /* synthetic */ MPoint setToPolar-fJ7hWco$default(MPoint mPoint, double d, double d2, double d3, double d4, int n, Object object) {
        if ((n & 8) != 0) {
            d4 = 1.0;
        }
        return mPoint.setToPolar-fJ7hWco(d, d2, d3, d4);
    }

    @NotNull
    public final MPoint setToPolar-fJ7hWco(float x, float y, double angle, float length2) {
        return this.setTo((double)x + Angle.getCosine-impl(angle) * (double)length2, (double)y + Angle.getSine-impl(angle) * (double)length2);
    }

    public static /* synthetic */ MPoint setToPolar-fJ7hWco$default(MPoint mPoint, float f, float f2, double d, float f3, int n, Object object) {
        if ((n & 8) != 0) {
            f3 = 1.0f;
        }
        return mPoint.setToPolar-fJ7hWco(f, f2, d, f3);
    }

    @NotNull
    public final MPoint setToNormal() {
        return this.setTo(-this.y, this.x);
    }

    @NotNull
    public final MPoint neg() {
        return this.setTo(-this.x, -this.y);
    }

    @NotNull
    public final MPoint mul(double s) {
        return this.setTo(this.x * s, this.y * s);
    }

    @NotNull
    public final MPoint mul(float s) {
        return this.mul((double)s);
    }

    @NotNull
    public final MPoint mul(int s) {
        return this.mul((double)s);
    }

    @NotNull
    public final MPoint add(@NotNull Vector2D p) {
        return this.setTo(this.x + p.getX(), this.y + p.getY());
    }

    @NotNull
    public final MPoint add(@NotNull MPoint p) {
        return this.setToAdd(this, p);
    }

    @NotNull
    public final MPoint add(double x, double y) {
        return this.setTo(this.x + x, this.y + y);
    }

    @NotNull
    public final MPoint sub(@NotNull Vector2D p) {
        return this.setTo(this.x - p.getX(), this.y - p.getY());
    }

    @NotNull
    public final MPoint sub(@NotNull MPoint p) {
        return this.setToSub(this, p);
    }

    @NotNull
    public final MPoint sub(double x, double y) {
        return this.setTo(this.x - x, this.y - y);
    }

    @NotNull
    public final MPoint copyFrom(@NotNull Vector2D that) {
        return this.setTo(that.getX(), that.getY());
    }

    @NotNull
    public final MPoint copyFrom(@NotNull MPoint that) {
        return this.setTo(that.x, that.y);
    }

    @NotNull
    public final MPoint setToTransform(@NotNull MMatrix mat, @NotNull MPoint p) {
        return this.setToTransform(mat, p.x, p.y);
    }

    @NotNull
    public final MPoint setToTransform(@NotNull MMatrix mat, double x, double y) {
        return this.setTo(mat.transformX(x, y), mat.transformY(x, y));
    }

    @NotNull
    public final MPoint setToAdd(@NotNull MPoint a, @NotNull MPoint b) {
        return this.setTo(a.x + b.x, a.y + b.y);
    }

    @NotNull
    public final MPoint setToSub(@NotNull MPoint a, @NotNull MPoint b) {
        return this.setTo(a.x - b.x, a.y - b.y);
    }

    @NotNull
    public final MPoint setToMul(@NotNull MPoint a, @NotNull MPoint b) {
        return this.setTo(a.x * b.x, a.y * b.y);
    }

    @NotNull
    public final MPoint setToMul(@NotNull MPoint a, double s) {
        return this.setTo(a.x * s, a.y * s);
    }

    @NotNull
    public final MPoint setToMul(@NotNull MPoint a, float s) {
        return this.setToMul(a, (double)s);
    }

    @NotNull
    public final MPoint setToDiv(@NotNull MPoint a, @NotNull MPoint b) {
        return this.setTo(a.x / b.x, a.y / b.y);
    }

    @NotNull
    public final MPoint setToDiv(@NotNull MPoint a, double s) {
        return this.setTo(a.x / s, a.y / s);
    }

    @NotNull
    public final MPoint setToDiv(@NotNull MPoint a, float s) {
        return this.setToDiv(a, (double)s);
    }

    public final void plusAssign(@NotNull MPoint that) {
        this.setTo(this.x + that.x, this.y + that.y);
    }

    public final void minusAssign(@NotNull MPoint that) {
        this.setTo(this.x - that.x, this.y - that.y);
    }

    public final void remAssign(@NotNull MPoint that) {
        this.setTo(this.x % that.x, this.y % that.y);
    }

    public final void remAssign(double scale) {
        this.setTo(this.x % scale, this.y % scale);
    }

    public final void divAssign(@NotNull MPoint that) {
        this.setTo(this.x / that.x, this.y / that.y);
    }

    public final void divAssign(double scale) {
        this.setTo(this.x / scale, this.y / scale);
    }

    public final void timesAssign(@NotNull MPoint that) {
        this.setTo(this.x * that.x, this.y * that.y);
    }

    public final void timesAssign(double scale) {
        this.setTo(this.x * scale, this.y * scale);
    }

    @Deprecated(message="allocates")
    @NotNull
    public final MPoint plus(@NotNull MPoint that) {
        return new MPoint(this.x + that.x, this.y + that.y);
    }

    @Deprecated(message="allocates")
    @NotNull
    public final MPoint minus(@NotNull MPoint that) {
        return new MPoint(this.x - that.x, this.y - that.y);
    }

    @Deprecated(message="allocates")
    @NotNull
    public final MPoint times(@NotNull MPoint that) {
        return new MPoint(this.x * that.x, this.y * that.y);
    }

    @Deprecated(message="allocates")
    @NotNull
    public final MPoint div(@NotNull MPoint that) {
        return new MPoint(this.x / that.x, this.y / that.y);
    }

    @Deprecated(message="allocates")
    public final double dot(@NotNull MPoint that) {
        return this.x * that.x + this.y * that.y;
    }

    @Deprecated(message="allocates")
    @NotNull
    public final MPoint times(double scale) {
        return new MPoint(this.x * scale, this.y * scale);
    }

    @Deprecated(message="allocates")
    @NotNull
    public final MPoint times(float scale) {
        return this.times((double)scale);
    }

    @Deprecated(message="allocates")
    @NotNull
    public final MPoint times(int scale) {
        return this.times((double)scale);
    }

    @Deprecated(message="allocates")
    @NotNull
    public final MPoint div(double scale) {
        return new MPoint(this.x / scale, this.y / scale);
    }

    @Deprecated(message="allocates")
    @NotNull
    public final MPoint div(float scale) {
        return this.div((double)scale);
    }

    @Deprecated(message="allocates")
    @NotNull
    public final MPoint div(int scale) {
        return this.div((double)scale);
    }

    public final double distanceTo(double x, double y) {
        return Math.hypot(x - this.x, y - this.y);
    }

    public final double distanceTo(int x, int y) {
        return this.distanceTo((double)x, (double)y);
    }

    public final float distanceTo(float x, float y) {
        return (float)this.distanceTo((double)x, (double)y);
    }

    public final double distanceTo(@NotNull MPoint that) {
        return this.distanceTo(that.x, that.y);
    }

    /*
     * WARNING - void declaration
     */
    public final double angleTo-AmL7uXk(@NotNull MPoint other) {
        void x1$iv;
        void y0$iv;
        void x0$iv;
        Angle.Companion companion = Angle.Companion;
        double d = this.x;
        double d2 = this.y;
        double d3 = other.x;
        double y1$iv = other.y;
        Vector2D up$iv = Vector2D.Companion.getUP();
        boolean bl = false;
        return AngleKt.Angle_between((double)x0$iv, (double)y0$iv, (double)x1$iv, y1$iv, up$iv);
    }

    /*
     * WARNING - void declaration
     */
    public final double angleTo-AmL7uXk(@NotNull Vector2D other) {
        void x1$iv;
        void y0$iv;
        void x0$iv;
        Angle.Companion companion = Angle.Companion;
        double d = this.x;
        double d2 = this.y;
        double d3 = other.getX();
        double y1$iv = other.getY();
        Vector2D up$iv = Vector2D.Companion.getUP();
        boolean bl = false;
        return AngleKt.Angle_between((double)x0$iv, (double)y0$iv, (double)x1$iv, y1$iv, up$iv);
    }

    @NotNull
    public final MPoint transformed(@NotNull MMatrix mat, @NotNull MPoint out) {
        return out.setToTransform(mat, this);
    }

    public static /* synthetic */ MPoint transformed$default(MPoint mPoint, MMatrix mMatrix, MPoint mPoint2, int n, Object object) {
        if ((n & 2) != 0) {
            mPoint2 = Companion.invoke();
        }
        return mPoint.transformed(mMatrix, mPoint2);
    }

    public final double get(int index2) {
        double d;
        switch (index2) {
            case 0: {
                d = this.x;
                break;
            }
            case 1: {
                d = this.y;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("IPoint doesn't have " + index2 + " component");
            }
        }
        return d;
    }

    @NotNull
    public final MPoint copy() {
        return new MPoint(this.x, this.y);
    }

    @NotNull
    public final MPoint getUnit() {
        return this.div(this.getLength());
    }

    @Deprecated(message="Allocates")
    public static /* synthetic */ void getUnit$annotations() {
    }

    public final double getSquaredLength() {
        return this.x * this.x + this.y * this.y;
    }

    public final double getLength() {
        return Math.hypot(this.x, this.y);
    }

    public final double getMagnitude() {
        return Math.hypot(this.x, this.y);
    }

    @NotNull
    public final MPoint getNormalized() {
        double imag = 1.0 / this.getMagnitude();
        return new MPoint(this.x * imag, this.y * imag);
    }

    @Deprecated(message="Allocates")
    public static /* synthetic */ void getNormalized$annotations() {
    }

    public final void normalize() {
        double len = this.getLength();
        if (IsAlmostZeroKt.isAlmostZero(len)) {
            this.setTo(0, 0);
        } else {
            this.setTo(this.x / len, this.y / len);
        }
    }

    @Override
    @Deprecated(message="Allocates")
    @NotNull
    public MPoint interpolateWith-DJj3pIk(double ratio2, @NotNull MPoint other) {
        return Companion.invoke().setToInterpolated-aphylw4(ratio2, this, other);
    }

    @Override
    @NotNull
    public MPoint setToInterpolated-aphylw4(double ratio2, @NotNull MPoint l, @NotNull MPoint r) {
        return this.setToInterpolated-OzkQpaQ(ratio2, l.x, l.y, r.x, r.y);
    }

    @NotNull
    public final MPoint setToInterpolated-OzkQpaQ(double ratio2, double lx, double ly, double rx, double ry) {
        return this.setTo(_Math_interpolationKt.interpolate-aphylw4(ratio2, lx, rx), _Math_interpolationKt.interpolate-aphylw4(ratio2, ly, ry));
    }

    @Override
    public int compareTo(@NotNull MPoint other) {
        return Companion.compare(this.x, this.y, other.x, other.y);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final MPoint rotate-2FdH_oo(double rotation, @NotNull MPoint out) {
        void x1$iv;
        void y0$iv;
        void x0$iv;
        Angle.Companion companion = Angle.Companion;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = this.x;
        double y1$iv = this.y;
        Vector2D up$iv = Vector2D.Companion.getUP();
        boolean bl = false;
        return out.setToPolar-2FdH_oo(Angle.plus-9E-s4b0(AngleKt.Angle_between((double)x0$iv, (double)y0$iv, (double)x1$iv, y1$iv, up$iv), rotation), this.getLength());
    }

    public static /* synthetic */ MPoint rotate-2FdH_oo$default(MPoint mPoint, double d, MPoint mPoint2, int n, Object object) {
        if ((n & 2) != 0) {
            mPoint2 = Companion.invoke();
        }
        return mPoint.rotate-2FdH_oo(d, mPoint2);
    }

    @NotNull
    public String toString() {
        return "(" + StringExtKt.getNiceStr(this.x) + ", " + StringExtKt.getNiceStr(this.y) + ")";
    }

    public final double component1() {
        return this.x;
    }

    public final double component2() {
        return this.y;
    }

    @NotNull
    public final MPoint copy(double x, double y) {
        return new MPoint(x, y);
    }

    public static /* synthetic */ MPoint copy$default(MPoint mPoint, double d, double d2, int n, Object object) {
        if ((n & 1) != 0) {
            d = mPoint.x;
        }
        if ((n & 2) != 0) {
            d2 = mPoint.y;
        }
        return mPoint.copy(d, d2);
    }

    public int hashCode() {
        int result2 = Double.hashCode(this.x);
        result2 = result2 * 31 + Double.hashCode(this.y);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MPoint)) {
            return false;
        }
        MPoint mPoint = (MPoint)other;
        if (Double.compare(this.x, mPoint.x) != 0) {
            return false;
        }
        return Double.compare(this.y, mPoint.y) == 0;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Deprecated(message="")
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0018\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0087\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J3\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u001f\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b#\u0010$JC\u0010\u001c\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020\u001f\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b+\u0010,J#\u0010-\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b0\u00101J+\u0010-\u001a\u00020\u001d2\n\u0010.\u001a\u000602j\u0002`32\n\u0010/\u001a\u000602j\u0002`3\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b0\u00104J#\u00105\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b6\u00101J\u0016\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u00042\u0006\u0010:\u001a\u00020\u0004J&\u00107\u001a\u0002082\u0006\u0010;\u001a\u00020\u001f2\u0006\u0010<\u001a\u00020\u001f2\u0006\u0010=\u001a\u00020\u001f2\u0006\u0010>\u001a\u00020\u001fJ\u0016\u0010?\u001a\u00020\u001f2\u0006\u0010@\u001a\u00020\u00042\u0006\u0010A\u001a\u00020\u0004J&\u0010?\u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u001fJ \u0010B\u001a\u00020\u00042\u0006\u0010.\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u00042\b\b\u0002\u0010C\u001a\u00020\u0004J\u0016\u0010D\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u0004J \u0010D\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020E2\u0006\u0010/\u001a\u00020E\u00f8\u0001\u0001\u00a2\u0006\u0004\bF\u00101J\u0016\u0010D\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020\u001f2\u0006\u0010/\u001a\u00020\u001fJ&\u0010D\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020\u001fJ&\u0010D\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020G2\u0006\u0010&\u001a\u00020G2\u0006\u0010'\u001a\u00020G2\u0006\u0010(\u001a\u00020GJ&\u0010D\u001a\u00020\u001f2\u0006\u0010%\u001a\u0002082\u0006\u0010&\u001a\u0002082\u0006\u0010'\u001a\u0002082\u0006\u0010(\u001a\u000208J\u0016\u0010H\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u0004J \u0010H\u001a\u0002082\u0006\u0010.\u001a\u00020E2\u0006\u0010/\u001a\u00020E\u00f8\u0001\u0001\u00a2\u0006\u0004\bI\u0010JJ&\u0010H\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020\u001fJ&\u0010H\u001a\u0002082\u0006\u0010%\u001a\u0002082\u0006\u0010&\u001a\u0002082\u0006\u0010'\u001a\u0002082\u0006\u0010(\u001a\u000208J\u0016\u0010K\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u0004J&\u0010K\u001a\u00020\u001f2\u0006\u0010L\u001a\u00020\u001f2\u0006\u0010M\u001a\u00020\u001f2\u0006\u0010N\u001a\u00020\u001f2\u0006\u0010O\u001a\u00020\u001fJ,\u0010P\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010Q\u001a\u00020\u001f2\b\b\u0002\u0010C\u001a\u00020\u0004\u00f8\u0001\u0001\u00a2\u0006\u0004\bR\u0010SJ4\u0010P\u001a\u00020\u00042\u0006\u0010T\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010Q\u001a\u00020\u001f2\b\b\u0002\u0010C\u001a\u00020\u0004\u00f8\u0001\u0001\u00a2\u0006\u0004\bU\u0010VJ<\u0010P\u001a\u00020\u00042\u0006\u0010W\u001a\u00020\u001f2\u0006\u0010X\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010Q\u001a\u00020\u001f2\b\b\u0002\u0010C\u001a\u00020\u0004\u00f8\u0001\u0001\u00a2\u0006\u0004\bY\u0010ZJ\t\u0010[\u001a\u00020\u0004H\u0086\u0002J%\u0010[\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010Q\u001a\u00020\u001fH\u0086\n\u00f8\u0001\u0001\u00a2\u0006\u0004\b\\\u0010]J\u0011\u0010[\u001a\u00020\u00042\u0006\u0010^\u001a\u00020\u0004H\u0086\u0002J\u0011\u0010[\u001a\u00020\u00042\u0006\u0010_\u001a\u00020\u001fH\u0086\u0002J\u0019\u0010[\u001a\u00020\u00042\u0006\u0010W\u001a\u00020\u001f2\u0006\u0010X\u001a\u00020\u001fH\u0086\u0002J\u0011\u0010[\u001a\u00020\u00042\u0006\u0010_\u001a\u00020GH\u0086\u0002J\u0019\u0010[\u001a\u00020\u00042\u0006\u0010W\u001a\u00020G2\u0006\u0010X\u001a\u00020GH\u0086\u0002J\u0011\u0010[\u001a\u00020\u00042\u0006\u0010_\u001a\u000208H\u0086\u0002J\u0019\u0010[\u001a\u00020\u00042\u0006\u0010W\u001a\u0002082\u0006\u0010X\u001a\u000208H\u0086\u0002J\u0019\u0010[\u001a\u00020\u00042\u0006\u0010W\u001a\u00020`2\u0006\u0010X\u001a\u00020`H\u0086\nJ6\u0010a\u001a\u00020b2\u0006\u0010c\u001a\u00020\u001f2\u0006\u0010d\u001a\u00020\u001f2\u0006\u0010W\u001a\u00020\u001f2\u0006\u0010X\u001a\u00020\u001f2\u0006\u0010e\u001a\u00020\u001f2\u0006\u0010f\u001a\u00020\u001fJ6\u0010a\u001a\u00020b2\u0006\u0010c\u001a\u0002082\u0006\u0010d\u001a\u0002082\u0006\u0010W\u001a\u0002082\u0006\u0010X\u001a\u0002082\u0006\u0010e\u001a\u0002082\u0006\u0010f\u001a\u000208J\u0016\u0010g\u001a\u00020\u00042\u0006\u0010.\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u0004J \u0010g\u001a\u00020\u00042\u0006\u0010.\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u00042\b\b\u0002\u0010C\u001a\u00020\u0004J\u001e\u0010h\u001a\u00020\u001f2\u0006\u0010@\u001a\u00020\u00042\u0006\u0010A\u001a\u00020\u00042\u0006\u0010i\u001a\u00020\u0004J6\u0010h\u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u001f2\u0006\u0010j\u001a\u00020\u001f2\u0006\u0010k\u001a\u00020\u001fJ\u0010\u0010l\u001a\u00020\u001f2\u0006\u0010W\u001a\u00020\u001fH\u0002J\u0010\u0010l\u001a\u0002082\u0006\u0010W\u001a\u000208H\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\t\u0010\u0002\u001a\u0004\b\n\u0010\u0007R\u001c\u0010\u000b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\u0002\u001a\u0004\b\r\u0010\u0007R\"\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0010\u0010\u0002\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0014\u0010\u0002\u001a\u0004\b\u0015\u0010\u0007R\u001c\u0010\u0016\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0017\u0010\u0002\u001a\u0004\b\u0018\u0010\u0007R\u001c\u0010\u0019\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001a\u0010\u0002\u001a\u0004\b\u001b\u0010\u0007\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006m"}, d2={"Lkorlibs/math/geom/MPoint$Companion;", "", "()V", "Down", "Lkorlibs/math/geom/MPoint;", "getDown$annotations", "getDown", "()Lkorlibs/math/geom/MPoint;", "Left", "getLeft$annotations", "getLeft", "One", "getOne$annotations", "getOne", "POOL", "Lkorlibs/datastructure/ConcurrentPool;", "getPOOL$annotations", "getPOOL", "()Lkorlibs/datastructure/ConcurrentPool;", "Right", "getRight$annotations", "getRight", "Up", "getUp$annotations", "getUp", "Zero", "getZero$annotations", "getZero", "angle", "Lkorlibs/math/geom/Angle;", "ax", "", "ay", "bx", "by", "angle-4n2g6LM", "(DDDD)D", "x1", "y1", "x2", "y2", "x3", "y3", "angle-Vt5jPd8", "(DDDDDD)D", "angleArc", "a", "b", "angleArc-YNSfjqc", "(Lkorlibs/math/geom/MPoint;Lkorlibs/math/geom/MPoint;)D", "Lkorlibs/math/geom/Vector2D;", "Lkorlibs/math/geom/Point;", "(Lkorlibs/math/geom/Vector2D;Lkorlibs/math/geom/Vector2D;)D", "angleFull", "angleFull-YNSfjqc", "compare", "", "l", "r", "lx", "ly", "rx", "ry", "crossProduct", "p1", "p2", "direction", "out", "distance", "Lkorlibs/math/geom/MPointInt;", "distance-Fi050nw", "", "distanceSquared", "distanceSquared-Fi050nw", "(Lkorlibs/math/geom/MPoint;Lkorlibs/math/geom/MPoint;)I", "dot", "aX", "aY", "bX", "bY", "fromPolar", "length", "fromPolar-tghNPes", "(DDLkorlibs/math/geom/MPoint;)Lkorlibs/math/geom/MPoint;", "base", "fromPolar-BB-CTYA", "(Lkorlibs/math/geom/MPoint;DDLkorlibs/math/geom/MPoint;)Lkorlibs/math/geom/MPoint;", "x", "y", "fromPolar-naQvTww", "(DDDDLkorlibs/math/geom/MPoint;)Lkorlibs/math/geom/MPoint;", "invoke", "invoke-2FdH_oo", "(DD)Lkorlibs/math/geom/MPoint;", "v", "xy", "", "isCollinear", "", "xa", "ya", "xb", "yb", "middle", "orientation", "p3", "cx", "cy", "square", "korge-foundation"})
    @SourceDebugExtension(value={"SMAP\n_MathGeomMutable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 _MathGeomMutable.kt\nkorlibs/math/geom/MPoint$Companion\n+ 2 Angle.kt\nkorlibs/math/geom/Angle$Companion\n*L\n1#1,3252:1\n149#2:3253\n149#2:3254\n200#2:3255\n195#2:3256\n195#2:3257\n195#2:3258\n*S KotlinDebug\n*F\n+ 1 _MathGeomMutable.kt\nkorlibs/math/geom/MPoint$Companion\n*L\n2213#1:3253\n2214#1:3254\n2215#1:3255\n2215#1:3256\n2227#1:3257\n2236#1:3258\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ConcurrentPool<MPoint> getPOOL() {
            return POOL;
        }

        @Deprecated(message="")
        public static /* synthetic */ void getPOOL$annotations() {
        }

        @NotNull
        public final MPoint getZero() {
            return Zero;
        }

        @Deprecated(message="")
        public static /* synthetic */ void getZero$annotations() {
        }

        @NotNull
        public final MPoint getOne() {
            return One;
        }

        @Deprecated(message="")
        public static /* synthetic */ void getOne$annotations() {
        }

        @NotNull
        public final MPoint getUp() {
            return Up;
        }

        @Deprecated(message="")
        public static /* synthetic */ void getUp$annotations() {
        }

        @NotNull
        public final MPoint getDown() {
            return Down;
        }

        @Deprecated(message="")
        public static /* synthetic */ void getDown$annotations() {
        }

        @NotNull
        public final MPoint getLeft() {
            return Left;
        }

        @Deprecated(message="")
        public static /* synthetic */ void getLeft$annotations() {
        }

        @NotNull
        public final MPoint getRight() {
            return Right;
        }

        @Deprecated(message="")
        public static /* synthetic */ void getRight$annotations() {
        }

        @NotNull
        public final MPoint invoke() {
            return new MPoint(0.0, 0.0);
        }

        @NotNull
        public final MPoint invoke(@NotNull MPoint v) {
            return new MPoint(v.getX(), v.getY());
        }

        @NotNull
        public final MPoint invoke(double x, double y) {
            return new MPoint(x, y);
        }

        @NotNull
        public final MPoint invoke(float x, float y) {
            return new MPoint(x, y);
        }

        @NotNull
        public final MPoint invoke(int x, int y) {
            return new MPoint(x, y);
        }

        @NotNull
        public final MPoint invoke(int xy) {
            return new MPoint((double)xy, (double)xy);
        }

        @NotNull
        public final MPoint invoke(float xy) {
            return new MPoint((double)xy, (double)xy);
        }

        @NotNull
        public final MPoint invoke(double xy) {
            return new MPoint(xy, xy);
        }

        @NotNull
        public final MPoint invoke(@NotNull Number x, @NotNull Number y) {
            boolean $i$f$invoke = false;
            return new MPoint(x.doubleValue(), y.doubleValue());
        }

        @NotNull
        public final MPoint invoke-2FdH_oo(double angle, double length2) {
            boolean bl = false;
            return korlibs.math.geom.MPoint$Companion.fromPolar-tghNPes$default(this, angle, length2, null, 4, null);
        }

        public static /* synthetic */ MPoint invoke-2FdH_oo$default(Companion $this, double angle, double length2, int n, Object object) {
            if ((n & 2) != 0) {
                length2 = 1.0;
            }
            boolean bl = false;
            return korlibs.math.geom.MPoint$Companion.fromPolar-tghNPes$default($this, angle, length2, null, 4, null);
        }

        /*
         * WARNING - void declaration
         */
        public final double angleArc-YNSfjqc(@NotNull Vector2D a, @NotNull Vector2D b) {
            void radians$iv;
            Angle.Companion companion = Angle.Companion;
            double d = Math.acos(a.dot(b) / (a.getLength() * b.getLength()));
            boolean bl = false;
            return Angle.constructor-impl((double)radians$iv);
        }

        /*
         * WARNING - void declaration
         */
        public final double angleArc-YNSfjqc(@NotNull MPoint a, @NotNull MPoint b) {
            void radians$iv;
            Angle.Companion companion = Angle.Companion;
            double d = Math.acos(a.dot(b) / (a.getLength() * b.getLength()));
            boolean bl = false;
            return Angle.constructor-impl((double)radians$iv);
        }

        /*
         * WARNING - void declaration
         */
        public final double angleFull-YNSfjqc(@NotNull MPoint a, @NotNull MPoint b) {
            void x1$iv$iv;
            void y0$iv$iv;
            void x0$iv$iv;
            void p0$iv;
            void $this$iv;
            Angle.Companion companion = Angle.Companion;
            Vector2D vector2D = a.getImmutable();
            Vector2D p1$iv = b.getImmutable();
            Vector2D up$iv = Vector2D.Companion.getUP();
            boolean bl = false;
            void var8_8 = $this$iv;
            double d = p0$iv.getX();
            double d2 = p0$iv.getY();
            double d3 = p1$iv.getX();
            double y1$iv$iv = p1$iv.getY();
            boolean bl2 = false;
            return AngleKt.Angle_between((double)x0$iv$iv, (double)y0$iv$iv, (double)x1$iv$iv, y1$iv$iv, up$iv);
        }

        @NotNull
        public final MPoint middle(@NotNull MPoint a, @NotNull MPoint b) {
            return new MPoint((a.getX() + b.getX()) * 0.5, (a.getY() + b.getY()) * 0.5);
        }

        @NotNull
        public final MPoint fromPolar-naQvTww(double x, double y, double angle, double length2, @NotNull MPoint out) {
            return out.setTo(x + Angle.getCosine-impl(angle) * length2, y + Angle.getSine-impl(angle) * length2);
        }

        public static /* synthetic */ MPoint fromPolar-naQvTww$default(Companion companion, double d, double d2, double d3, double d4, MPoint mPoint, int n, Object object) {
            if ((n & 8) != 0) {
                d4 = 1.0;
            }
            if ((n & 0x10) != 0) {
                mPoint = Companion.invoke();
            }
            return companion.fromPolar-naQvTww(d, d2, d3, d4, mPoint);
        }

        @NotNull
        public final MPoint fromPolar-tghNPes(double angle, double length2, @NotNull MPoint out) {
            return this.fromPolar-naQvTww(0.0, 0.0, angle, length2, out);
        }

        public static /* synthetic */ MPoint fromPolar-tghNPes$default(Companion companion, double d, double d2, MPoint mPoint, int n, Object object) {
            if ((n & 2) != 0) {
                d2 = 1.0;
            }
            if ((n & 4) != 0) {
                mPoint = Companion.invoke();
            }
            return companion.fromPolar-tghNPes(d, d2, mPoint);
        }

        @NotNull
        public final MPoint fromPolar-BB-CTYA(@NotNull MPoint base2, double angle, double length2, @NotNull MPoint out) {
            return this.fromPolar-naQvTww(base2.getX(), base2.getY(), angle, length2, out);
        }

        public static /* synthetic */ MPoint fromPolar-BB-CTYA$default(Companion companion, MPoint mPoint, double d, double d2, MPoint mPoint2, int n, Object object) {
            if ((n & 4) != 0) {
                d2 = 1.0;
            }
            if ((n & 8) != 0) {
                mPoint2 = Companion.invoke();
            }
            return companion.fromPolar-BB-CTYA(mPoint, d, d2, mPoint2);
        }

        @NotNull
        public final MPoint direction(@NotNull MPoint a, @NotNull MPoint b, @NotNull MPoint out) {
            return out.setTo(b.getX() - a.getX(), b.getY() - a.getY());
        }

        public static /* synthetic */ MPoint direction$default(Companion companion, MPoint mPoint, MPoint mPoint2, MPoint mPoint3, int n, Object object) {
            if ((n & 4) != 0) {
                mPoint3 = Companion.invoke();
            }
            return companion.direction(mPoint, mPoint2, mPoint3);
        }

        @NotNull
        public final MPoint middle(@NotNull MPoint a, @NotNull MPoint b, @NotNull MPoint out) {
            return out.setTo((a.getX() + b.getX()) * 0.5, (a.getY() + b.getY()) * 0.5);
        }

        public static /* synthetic */ MPoint middle$default(Companion companion, MPoint mPoint, MPoint mPoint2, MPoint mPoint3, int n, Object object) {
            if ((n & 4) != 0) {
                mPoint3 = Companion.invoke();
            }
            return companion.middle(mPoint, mPoint2, mPoint3);
        }

        public final double angle-4n2g6LM(double ax, double ay, double bx, double by) {
            Angle.Companion $this$iv = Angle.Companion;
            Vector2D up$iv = Vector2D.Companion.getUP();
            boolean bl = false;
            return AngleKt.Angle_between(ax, ay, bx, by, up$iv);
        }

        public final int compare(@NotNull MPoint l, @NotNull MPoint r) {
            return this.compare(l.getX(), l.getY(), r.getX(), r.getY());
        }

        public final int compare(double lx, double ly, double rx, double ry) {
            int ret = Double.compare(ly, ry);
            return ret == 0 ? Double.compare(lx, rx) : ret;
        }

        /*
         * WARNING - void declaration
         */
        public final double angle-Vt5jPd8(double x1, double y1, double x2, double y2, double x3, double y3) {
            void x1$iv;
            void y0$iv;
            void x0$iv;
            Angle.Companion companion = Angle.Companion;
            double d = x1 - x2;
            double d2 = y1 - y2;
            double d3 = x1 - x3;
            double y1$iv = y1 - y3;
            Vector2D up$iv = Vector2D.Companion.getUP();
            boolean bl = false;
            return AngleKt.Angle_between((double)x0$iv, (double)y0$iv, (double)x1$iv, y1$iv, up$iv);
        }

        private final double square(double x) {
            return x * x;
        }

        private final int square(int x) {
            return x * x;
        }

        public final double distanceSquared(double x1, double y1, double x2, double y2) {
            return this.square(x1 - x2) + this.square(y1 - y2);
        }

        public final int distanceSquared(int x1, int y1, int x2, int y2) {
            return this.square(x1 - x2) + this.square(y1 - y2);
        }

        public final double distance(@NotNull MPoint a, @NotNull MPoint b) {
            return this.distance(a.getX(), a.getY(), b.getX(), b.getY());
        }

        public final double distance-Fi050nw(@NotNull MPoint a, @NotNull MPoint b) {
            return this.distance(MPointInt.getX-impl(a), MPointInt.getY-impl(a), MPointInt.getX-impl(b), MPointInt.getY-impl(b));
        }

        public final double distance(double a, double b) {
            return Math.abs(a - b);
        }

        public final double distance(double x1, double y1, double x2, double y2) {
            return Math.hypot(x1 - x2, y1 - y2);
        }

        public final double distance(float x1, float y1, float x2, float y2) {
            return this.distance((double)x1, (double)y1, (double)x2, (double)y2);
        }

        public final double distance(int x1, int y1, int x2, int y2) {
            return this.distance((double)x1, (double)y1, (double)x2, (double)y2);
        }

        public final double distanceSquared(@NotNull MPoint a, @NotNull MPoint b) {
            return this.distanceSquared(a.getX(), a.getY(), b.getX(), b.getY());
        }

        public final int distanceSquared-Fi050nw(@NotNull MPoint a, @NotNull MPoint b) {
            return this.distanceSquared(MPointInt.getX-impl(a), MPointInt.getY-impl(a), MPointInt.getX-impl(b), MPointInt.getY-impl(b));
        }

        public final double dot(double aX, double aY, double bX, double bY) {
            return aX * bX + aY * bY;
        }

        public final double dot(@NotNull MPoint a, @NotNull MPoint b) {
            return this.dot(a.getX(), a.getY(), b.getX(), b.getY());
        }

        public final boolean isCollinear(double xa, double ya, double x, double y, double xb, double yb) {
            return IsAlmostZeroKt.isAlmostZero(Math.abs((x - xa) / (y - ya) - (xa - xb) / (ya - yb)));
        }

        public final boolean isCollinear(int xa, int ya, int x, int y, int xb, int yb) {
            return this.isCollinear((double)xa, (double)ya, (double)x, (double)y, (double)xb, (double)yb);
        }

        public final double orientation(@NotNull MPoint p1, @NotNull MPoint p2, @NotNull MPoint p3) {
            return this.orientation(p1.getX(), p1.getY(), p2.getX(), p2.getY(), p3.getX(), p3.getY());
        }

        public final double orientation(double ax, double ay, double bx, double by, double cx, double cy) {
            return this.crossProduct(cx - ax, cy - ay, bx - ax, by - ay);
        }

        public final double crossProduct(double ax, double ay, double bx, double by) {
            return ax * by - bx * ay;
        }

        public final double crossProduct(@NotNull MPoint p1, @NotNull MPoint p2) {
            return this.crossProduct(p1.getX(), p1.getY(), p2.getX(), p2.getY());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

